//## begin module%1.4%.codegen_version preserve=yes
//   Read the documentation to learn more about C++ code generator
//   versioning.
//## end module%1.4%.codegen_version

//## begin module%3A2CD5680126.cm preserve=no
//   %X% %Q% %Z% %W%
//## end module%3A2CD5680126.cm

//## Module: amt_CCAMessages%3A2CD5680126; Subprogram specification
//## Subsystem: Amt::Include%3A7E97380302
//## Source file: e:\vasco\components\Amt\Include\amt_CCAMessages.h

#ifndef amt_CCAMessages_h
#define amt_CCAMessages_h 1

//## begin module%3A2CD5680126.includes preserve=yes
//## end module%3A2CD5680126.includes

//## begin module%3A2CD5680126.additionalDeclarations preserve=yes
//## end module%3A2CD5680126.additionalDeclarations


//## begin amt_tclBaseMessage%3A3DDB5702DE.preface preserve=yes
//***************************************************************************
//** FILE:         amt_MMObj.h
//** PROJECT:      VASCO
//** SW-COMPONENT: AMT
//**---------------------------------------------------------------------------
//** DESCRIPTION:  (A)pplication (M)essage (T)emplate
//**               Implementation of CCA-message classes 
//**---------------------------------------------------------------------------
//** COPYRIGHT:    (c) 2000 Robert Bosch GmbH, Hildesheim
//** HISTORY:
//** Date       |  Modification                         | Author
//** < 19.03.01 |  Basic prototypes                     | Bruns,EFG32
//**  19.03.01  |  Updated ELL conventions              | Bruns,EFG32
//**  19.09.01  |  Updated to ipc_def.h                 | Bruns,EFG32
//**               Converted all messages to static     
//**               offsets --> Speedup in framework
//**
//** REMARK: !!! This file is generated with RationalRose!!!
//**
//**         ++ This header file contains the definitions of all basic message 
//**            types like "..._CCAMSGTYPE_POWER", "..._CCAMSGTYPE_SVCREGCONF"
//**            and all correspondig subtypes.
//**         ++ User defined message types for ServiceData derived msg-classes
//**            are not part of this header and should be defined in user's
//**            message class definitions.
//**
//**---------------------------------------------------------------------------
//** REMARK: switches MUST be set in "amt_settings.h"
//*****************************************************************************

#define SYSTEM_S_IMPORT_INTERFACE_IPC
#include "system_pif.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

/*****************************************************************************
 * General values
 *****************************************************************************/
// This is the default value for tU8 reserved fields
#define AMT_C_U8_DEFAULT_RESERVED                           (tU8)0x00
#define AMT_C_U16_DEFAULT_RESERVED                           (tU16)0x0000

// This are the default values 
#define AMT_C_U32_DEFAULT_NULL                           (tU32)0x00000000
#define AMT_C_U16_DEFAULT_NULL                           (tU16)0x0000

// Values which represent invalid settings
#define  AMT_C_U16_SERVICE_UNDEF                            0xFFFF
#define  AMT_C_U16_APPID_INVALID                            0xFFFF
#define  AMT_C_U16_REGID_INVALID                            0xFFFF
#define  AMT_C_U16_SERVICE_VERSION_INVALID                  0xFFFF
#define  AMT_C_U16_SUBID_INVALID                            0xFFFF
#define  AMT_C_U16_SUBID_DEFAULT                            0x0000

// Priorities of messages
#define AMT_C_U32_PRIORITY_POWER                      CCA_C_U32_PRIORITY_POWER
#define AMT_C_U32_PRIORITY_SVCREGISTER                CCA_C_U32_PRIORITY_SVCREGISTER
#define AMT_C_U32_PRIORITY_SVCUNREGISTER              CCA_C_U32_PRIORITY_SVCUNREGISTER
#define AMT_C_U32_PRIORITY_SVCREGCONF                 CCA_C_U32_PRIORITY_SVCCONF
#define AMT_C_U32_PRIORITY_SVCSTATUS                  CCA_C_U32_PRIORITY_SVCSTATUS
#define AMT_C_U32_PRIORITY_SVCDATA_GET                CCA_C_U32_PRIORITY_SVCDATA_GET
#define AMT_C_U32_PRIORITY_SVCDATA_SET                CCA_C_U32_PRIORITY_SVCDATA_SET
#define AMT_C_U32_PRIORITY_SVCDATA_METHODSTART        CCA_C_U32_PRIORITY_SVCDATA_METHODSTART
#define AMT_C_U32_PRIORITY_SVCDATA_UPREG              CCA_C_U32_PRIORITY_SVCDATA_UPREG
#define AMT_C_U32_PRIORITY_SVCDATA_RELUPREG           CCA_C_U32_PRIORITY_SVCDATA_RELUPREG
#define AMT_C_U32_PRIORITY_SVCDATA_METHODABORT        CCA_C_U32_PRIORITY_SVCDATA_METHODABORT
#define AMT_C_U32_PRIORITY_SVCDATA_STATUS             CCA_C_U32_PRIORITY_SVCDATA_STATUS
#define AMT_C_U32_PRIORITY_SVCDATA_ERROR              CCA_C_U32_PRIORITY_SVCDATA_ERROR
#define AMT_C_U32_PRIORITY_SVCDATA_METHODRESULT       CCA_C_U32_PRIORITY_SVCDATA_METHODRESULT
#define AMT_C_U32_PRIORITY_SVCDATA_ABORTRESULT        CCA_C_U32_PRIORITY_SVCDATA_ABORTRESULT
#define AMT_C_U32_PRIORITY_SVCDATA_METHODRESULTFIRST  CCA_C_U32_PRIORITY_SVCDATA_METHODRESULTFIRST
#define AMT_C_U32_PRIORITY_SVCDATA_METHODRESULTMIDDLE CCA_C_U32_PRIORITY_SVCDATA_METHODRESULTMIDDLE
#define AMT_C_U32_PRIORITY_SVCDATA_METHODRESULTLAST   CCA_C_U32_PRIORITY_SVCDATA_METHODRESULTLAST


/*****************************************************************************
 * Header (BaseMessage) values
 *****************************************************************************/
// Context values
#define  AMT_C_U8_CCACONTEXT_LOCAL                          CCA_C_U8_CONTEXT_LOCAL


/*****************************************************************************
 * PowerMessage
 *****************************************************************************/
#define  AMT_C_U8_CCAMSGTYPE_POWER                          CCA_C_U8_TYPE_POWER
   // subcodes - PowerType values
   #define  AMT_C_U16_PWR_APP_START_REQ                     (tU16)0x00
   #define  AMT_C_U16_PWR_APP_INITIALIZED                   (tU16)0x01
   #define  AMT_C_U16_PWR_APP_RESTART                       (tU16)0x02
   #define  AMT_C_U16_PWR_PROXY_START_CONF                  (tU16)0x03
   #define  AMT_C_U16_PWR_PROXY_START_REJ                   (tU16)0x04
   #define  AMT_C_U16_PWR_PROXY_STATE_CHANGE_REQ            (tU16)0x10
   #define  AMT_C_U16_PWR_APP_STATE_ACK                     (tU16)0x11
   #define  AMT_C_U16_PWR_APP_STATE_REJ                     (tU16)0x12
   #define  AMT_C_U16_PWR_PROXY_STATE_CHANGE_IMMEDIATELY    (tU16)0x13

   #define  AMT_C_U16_PWR_PROXY_END_APP                     (tU16)0x20
   #define  AMT_C_U16_PWR_APP_END_SUCCESSFUL                (tU16)0x21
   #define  AMT_C_U16_PWR_APP_END_FAILURE                   (tU16)0x22

   #define  AMT_C_U16_PWR_APP_ERROR_DETECT                  (tU16)0x30
   #define  AMT_C_U16_PWR_APP_CCA_MSG_QUEUE_FULL            (tU16)0x31

   #define  AMT_C_U16_PWR_WDOGTIMER                         (tU16)0x40
   #define  AMT_C_U16_PWR_SVM_APP_REGISTER                  (tU16)0x41
      // subcodes for power-data1 field of app-register message. The following
      // values must be identical to the definitions in the WinCE Headerfile 
      // "cpm.h" (which is part of the WinCE SDK)
      // Following coding is used: REGISTRY_FLAGS: Bits 24-31
      //                           RECOVERY_FLAGS: Bits 16-23
      //                           Bits 8-15 unused, Bits 0-7 unused, 
      // REMARK: Any modification has effect on some methods in "SystemEntry.cpp"!!

      // make a log entry only
      #define AMT_C_U32_PWR_SVM_APPRECOVER_LOG              (tU32)0x01000000
      #define AMT_C_U32_PWR_SVM_APPRECOVER_RELAUNCH         (tU32)0x02000000

      // process will notify on specific time quantum
      #define AMT_C_U32_PWR_SVM_APPREG_ENTRYNOTIFY          (tU32)0x00030000

      // process will be watched to see if it goes away (actually no support!)
      #define AMT_C_U32_PWR_SVM_APPREG_ENTRYWATCH           (tU32)0x00040000

   #define  AMT_C_U16_PWR_SVM_APP_UNREGISTER                (tU16)0x42
   #define  AMT_C_U16_PWR_SVM_APP_NOTIFY                    (tU16)0x43
   #define  AMT_C_U16_PWR_SVM_APP_NOTIFY_PROBLEM            (tU16)0x44
   #define  AMT_C_U16_PWR_SVM_APP_NOTIFY_PROBLEM_RESPONSE   (tU16)0x45
      // notification codes (used by notify problem response)
      // subcodes for application states (whenever needed). The following 
      // values must be identical to the definitions in the WinCE Headerfile
      //  "syi_LpmTypes.h" (which is part of the WinCE SDK)
      // Following coding is used: REGISTRY_FLAGS: Bits 24-31
      #define AMT_C_U32_PWR_APP_STATE_UNDEFINED             (tU32)0x00000000
      #define AMT_C_U32_PWR_LPM_APP_STATE_RESTART           (tU32)0x00000001
      #define AMT_C_U32_PWR_APP_STATE_OK                    (tU32)0x00000002

   #define  AMT_C_U16_PWR_PROXY_CVM_SIGNAL_CHANGED          (tU16)0x50

      // Voltage has normal level [9V..16V]
      #define  AMT_C_U32_NORMAL_VOLTAGE                        (tU32)0
      // Voltage has dropped below normal level [9V..16V]
      #define  AMT_C_U32_LOW_VOLTAGE                           (tU32)1
      // Voltage has raised over normal level [9V..16V]
      #define  AMT_C_U32_HIGH_VOLTAGE                          (tU32)2


   #define  AMT_C_U16_PWR_APP_REQ_SYSTEM_STATE              (tU16)0x60

   #define  AMT_C_U16_PWR_APP_RAM_INIT_READY                (tU16)0x70

   #define  AMT_C_U16_PWR_USER_TRIGGER                      (tU16)0x80


   /* u32ApplicationStates */
   #define AMT_C_U32_STATE_INVALID                          (tU32)0x00
   #define AMT_C_U32_STATE_UNINITALIZED                     (tU32)0x01
   #define AMT_C_U32_STATE_INITIALIZED                      (tU32)0x02
   #define AMT_C_U32_STATE_NORMAL                           (tU32)0x03
   #define AMT_C_U32_STATE_DIAGNOSIS                        (tU32)0x04
   #define AMT_C_U32_STATE_PAUSE                            (tU32)0x05
   #define AMT_C_U32_STATE_PREPARE_DOWNLOAD                 (tU32)0x06
   #define AMT_C_U32_STATE_RECEIVE_READY                    (tU32)0x07
   #define AMT_C_U32_STATE_OFF                              (tU32)0x08


/*****************************************************************************
 * ServiceRegister
 *****************************************************************************/
#define  AMT_C_U8_CCAMSGTYPE_SVCREGISTER                    CCA_C_U8_TYPE_SVCREGISTER
   // subcodes: none


/*****************************************************************************
 * ServiceUnregister
 *****************************************************************************/
#define  AMT_C_U8_CCAMSGTYPE_SVCUNREGISTER                  CCA_C_U8_TYPE_SVCUNREGISTER
   // subcodes: none


/*****************************************************************************
 * ServiceRegisterConf
 *****************************************************************************/
#define  AMT_C_U8_CCAMSGTYPE_SVCREGCONF                     CCA_C_U8_TYPE_SVCCONF
   // subcodes - RegState values
   #define AMT_C_U8_REGCONF_NO_SUCCESS                      CCA_C_U8_SVCCONF_NO_SUCCESS
   #define AMT_C_U8_REGCONF_SUCCESS                         CCA_C_U8_SVCCONF_SUCCESS
   #define AMT_C_U8_REGCONF_SERVICE_ALREADY_REGISTERED      CCA_C_U8_SVCCONF_SERVICE_ALREADY_REGISTERED      
   #define AMT_C_U8_REGCONF_SERVICE_VERSION_NOT_SUPPORTED   CCA_C_U8_SVCCONF_SERVICE_VERSION_NOT_SUPPORTED   
   #define AMT_C_U8_REGCONF_SERVICE_REGISTRATION_PENDING    CCA_C_U8_SVCCONF_SERVICE_REGISTRATION_PENDING    
   #define AMT_C_U8_REGCONF_SERVER_DOES_NOT_RESPOND_TIMEOUT CCA_C_U8_SVCCONF_SERVER_DOES_NOT_RESPOND_TIMEOUT 
   #define AMT_C_U8_REGCONF_SERVICE_DOES_NOT_EXIST          CCA_C_U8_SVCCONF_SERVICE_DOES_NOT_EXIST          


/*****************************************************************************
 * UnknownRegisterID
 *****************************************************************************/
#define  AMT_C_U8_CCAMSGTYPE_UNKNOWNREGID                   (tU8)IPC_CONTEXT_SUBTYPE_UNKNOWN_REGISTER_ID
   // subcodes: none


/*****************************************************************************
 * ServiceStatus
 *****************************************************************************/
#define  AMT_C_U8_CCAMSGTYPE_SVSSTATUS                      CCA_C_U8_TYPE_SVSSTATUS
   // subcodes - ServiceState values
   #define AMT_C_U8_SVCSTATE_NOT_AVAILABLE                  CCA_C_U8_SVCSTATUS_NOT_AVAILABLE
   #define AMT_C_U8_SVCSTATE_AVAILABLE                      CCA_C_U8_SVCSTATUS_AVAILABLE
   #define AMT_C_U8_SVCSTATE_REG_INVALID                    CCA_C_U8_SVCSTATUS_REG_DENIED
   #define AMT_C_U8_SVCSTATE_REG_DENIED                     CCA_C_U8_SVCSTATUS_REG_DENIED


/*****************************************************************************
 * ServiceData
 *****************************************************************************/
#define  AMT_C_U8_CCAMSGTYPE_SVCDATA                        CCA_C_U8_TYPE_SVCDATA
   //subcodes - StreamType Fields
   #define  AMT_C_U8_CCAMSG_STREAMTYPE_NODATA               CCA_C_U8_STREAMTYPE_NODATA
   #define  AMT_C_U8_CCAMSG_STREAMTYPE_FIRSTDATA            CCA_C_U8_STREAMTYPE_FIRSTDATA
   #define  AMT_C_U8_CCAMSG_STREAMTYPE_MIDDLEDATA           CCA_C_U8_STREAMTYPE_MIDDLEDATA
   #define  AMT_C_U8_CCAMSG_STREAMTYPE_LASTDATA             CCA_C_U8_STREAMTYPE_LASTDATA
   #define  AMT_C_U8_CCAMSG_STREAMTYPE_ABORTED              CCA_C_U8_STREAMTYPE_ABORTED

   // subcodes - OpCode Fields
   #define  AMT_C_U8_CCAMSG_OPCODE_SET                      CCA_C_U8_OPCODE_SET
   #define  AMT_C_U8_CCAMSG_OPCODE_GET                      CCA_C_U8_OPCODE_GET
   #define  AMT_C_U8_CCAMSG_OPCODE_UPREG                    CCA_C_U8_OPCODE_UPREG
   #define  AMT_C_U8_CCAMSG_OPCODE_RELUPREG                 CCA_C_U8_OPCODE_RELUPREG
   #define  AMT_C_U8_CCAMSG_OPCODE_STATUS                   CCA_C_U8_OPCODE_STATUS
   #define  AMT_C_U8_CCAMSG_OPCODE_ERROR                    CCA_C_U8_OPCODE_ERROR
   #define  AMT_C_U8_CCAMSG_OPCODE_INCREMENT                CCA_C_U8_OPCODE_INCREMENT
   #define  AMT_C_U8_CCAMSG_OPCODE_DECREMENT                CCA_C_U8_OPCODE_DECREMENT
   #define  AMT_C_U8_CCAMSG_OPCODE_PURESET                  CCA_C_U8_OPCODE_PURESET

   // for methods (change request in progress -> MONA)
   #define  AMT_C_U8_CCAMSG_OPCODE_METHODSTART              CCA_C_U8_OPCODE_METHODSTART
   #define  AMT_C_U8_CCAMSG_OPCODE_METHODRESULT             CCA_C_U8_OPCODE_METHODRESULT
   #define  AMT_C_U8_CCAMSG_OPCODE_METHODABORT              CCA_C_U8_OPCODE_METHODABORT
   #define  AMT_C_U8_CCAMSG_OPCODE_ABORTRESULT              CCA_C_U8_OPCODE_ABORTRESULT
   #define  AMT_C_U8_CCAMSG_OPCODE_METHODRESULTFIRST        CCA_C_U8_OPCODE_METHODRESULTFIRST
   #define  AMT_C_U8_CCAMSG_OPCODE_METHODRESULTMIDDLE       CCA_C_U8_OPCODE_METHODRESULTMIDDLE
   #define  AMT_C_U8_CCAMSG_OPCODE_METHODRESULTLAST         CCA_C_U8_OPCODE_METHODRESULTLAST

   // for message port acknowledgements
   #define  AMT_C_U8_CCAMSG_OPCODE_CLIENT_PORT_ACK          CCA_C_U8_OPCODE_CLIENT_PORT_ACK
   #define  AMT_C_U8_CCAMSG_OPCODE_SERVER_PORT_ACK          CCA_C_U8_OPCODE_SERVER_PORT_ACK

#define AMT_C_U8_CCAMSGTYPE_SUPPLIER_STATE_REGISTER           CCA_C_U8_TYPE_SUPPLIER_STATE_REGISTER    

#define AMT_C_U8_CCAMSGTYPE_SUPPLIER_STATE                    CCA_C_U8_TYPE_SUPPLIER_STATE             

 // Service supplier application is known but not started
 #define AMT_C_U8_CCAMSG_SUPPLIER_STATE_UNAVAILABLE    (tU8)0
 // Service supplier application is initialized
 #define AMT_C_U8_CCAMSG_SUPPLIER_STATE_AVAILABLE      (tU8)1
 // Service supplier there is no application which offers the service
 #define AMT_C_U8_CCAMSG_SUPPLIER_STATE_UNKNOWN        (tU8)2
 // Service supplier e.g. repeated registration for the same Service without prior de-registration
 #define AMT_C_U8_CCAMSG_SUPPLIER_STATE_ERROR          (tU8)3
 // Service supplier application does not exist
 #define AMT_C_U8_CCAMSG_SUPPLIER_STATE_DOES_NOT_EXIST (tU8)4

#define AMT_C_U8_CCAMSGTYPE_SUPPLIER_STATE_UNREGISTER         CCA_C_U8_TYPE_SUPPLIER_STATE_UNREGISTER  

#define AMT_C_U8_CCAMSGTYPE_APPLICATION_INFO_REGISTER         CCA_C_U8_TYPE_APPLICATION_INFO_REGISTER  

#define AMT_C_U8_CCAMSGTYPE_APPLICATION_INFO                  CCA_C_U8_TYPE_APPLICATION_INFO           

 // Application is known but not started
 #define AMT_C_U8_CCAMSG_APPLICATION_INFO_UNAVAILABLE    (tU8)0
 // Application is initialized
 #define AMT_C_U8_CCAMSG_APPLICATION_INFO_AVAILABLE      (tU8)1
 // There is no application which offers the service
 #define AMT_C_U8_CCAMSG_APPLICATION_INFO_UNKNOWN        (tU8)2
 // Repeated registration for the same application without prior de-registration
 #define AMT_C_U8_CCAMSG_APPLICATION_INFO_ERROR          (tU8)3
 // Application does not exist
 #define AMT_C_U8_CCAMSG_APPLICATION_INFO_DOES_NOT_EXIST (tU8)4

#define AMT_C_U8_CCAMSGTYPE_APPLICATION_INFO_UNREGISTER       CCA_C_U8_TYPE_APPLICATION_INFO_UNREGISTER

#define AMT_C_U8_TYPE_DEBUG_APPLICATION                       CCA_C_U8_TYPE_DEBUG_APPLICATION

 #define AMT_C_U8_CCAMSG_DEBUG_APPLICATION_GET_APP_INFO          (tU8)0
 #define AMT_C_U8_CCAMSG_DEBUG_APPLICATION_TRIGGER_USER_ACTION   (tU8)1

   /**************************************************************************
    * ServiceError
    **************************************************************************/
   // subcodes for oopcode=ERROR

   // --UNSPECIFIED: if there isn't another error code defined, use this one. 
   #define AMT_C_U16_ERROR_UNSPECIFIED                CCA_C_U16_ERROR_UNSPECIFIED
   // --VERSION_NOT_SUPPORTED: The server doesn't support this version (actual version is 0x0002).
   #define AMT_C_U16_ERROR_VERSION_NOT_SUPPORTED      CCA_C_U16_ERROR_VERSION_NOT_SUPPORTED
   // --INVALID_CCATYPE: The message type of the ipc header is invalid.      
   #define AMT_C_U16_ERROR_INVALID_CCATYPE            CCA_C_U16_ERROR_INVALID_CCATYPE
   // --INVALID_OPCODE: The opcode identifier is out of range (0x00-0x09). 
   #define AMT_C_U16_ERROR_INVALID_OPCODE             CCA_C_U16_ERROR_INVALID_OPCODE
   // --UNKNOWN_FCT_ID: The service hasn't a function with desired identifier.
   #define AMT_C_U16_ERROR_UNKNOWN_FCT_ID             CCA_C_U16_ERROR_UNKNOWN_FCT_ID
   // --UNKNOWN_REG_ID: The register identifier is invalid.
   #define AMT_C_U16_ERROR_UNKNOWN_REG_ID             CCA_C_U16_ERROR_UNKNOWN_REG_ID
   // --UNKNOWN_SVC_ID: The server hasn't a service with desired identifier.
   #define AMT_C_U16_ERROR_UNKNOWN_SVC_ID             CCA_C_U16_ERROR_UNKNOWN_SVC_ID
   // --PARAMETER_OUT_OF_RANGE: One or more of the parameter are wrong or out of range
   #define AMT_C_U16_ERROR_PARAMETER_OUT_OF_RANGE     CCA_C_U16_ERROR_PARAMETER_OUT_OF_RANGE
   // --PARAMETER_MISSING: One or more of the parameter are missing.  
   #define AMT_C_U16_ERROR_PARAMETER_MISSING          CCA_C_U16_ERROR_PARAMETER_MISSING
   // --PARAMETER_TOO_MANY: There are too many  parameters for this function.
   #define AMT_C_U16_ERROR_PARAMETER_TOO_MANY         CCA_C_U16_ERROR_PARAMETER_TOO_MANY
   // --FUNCTION_BUSY: The function is available, but is busy (there is no queueing for this function).
   #define AMT_C_U16_ERROR_FUNCTION_BUSY              CCA_C_U16_ERROR_FUNCTION_BUSY
   // --FUNCTION_TEMPORARY_NOT_AVAILABLE: The function is implemented, but not available at this moment.  
   #define AMT_C_U16_ERROR_TEMPORARY_NOT_AVAILABLE    CCA_C_U16_ERROR_TEMPORARY_NOT_AVAILABLE
   // --OPCODE_NOT_SUPPORTED : The function doesn't support this opcode.
   #define AMT_C_U16_ERROR_OPCODE_NOT_SUPPORTED       CCA_C_U16_ERROR_OPCODE_NOT_SUPPORTED
   // --INTERNAL_FAILURE: The execution of the function failed.
   #define AMT_C_U16_ERROR_INTERNAL_FAILURE           CCA_C_U16_ERROR_INTERNAL_FAILURE
   // --UPREG_FAILURE: The registration for the property failed. There may be 
   //                  to much clients which are already registered or you 
   //                  tried to register twice.
   #define AMT_C_U16_ERROR_UPREG_FAILURE              CCA_C_U16_ERROR_UPREG_FAILURE
   // --RELUPREG_FAILURE: The de-registration from al property failed. Are you
   //                     really registered?
   #define AMT_C_U16_ERROR_RELUPREG_FAILURE           CCA_C_U16_ERROR_RELUPREG_FAILURE
   // --RELUPREG_CONF_WITHOUT_STATUS: The de-registration was successfully, but the server
   //                     was not able to respond with a status message because it has no 
   //                     access to a valid property
   #define AMT_C_U16_ERROR_RELUPREG_CONF_WITHOUT_STATUS           CCA_C_U16_ERROR_RELUPREG_CONF_WITHOUT_STATUS

   /**************************************************************************
    * dummy dll link -> used to setup connection to dll main (-> D. Tiemann)
    **************************************************************************/
   tVoid dummy_amt_dll(tVoid);



//## end amt_tclBaseMessage%3A3DDB5702DE.preface

//## Class: amt_tclBaseMessage%3A3DDB5702DE
// *********************************************************
// ***********************
// DESCRIPTION:
//
// This is the representation of the general message
// header. All get and set methods are undocumentated due
// to  simplicity.
//
// History:
//
// 19.03.01 EFG32-Bruns
// InitialVersion
// 19.09.01 EFG32-Bruns
// Updated to ipc_def.h and using static offsets for all
// messages
// Added direct memory access methods: "u8Get/vSetValueU8",
// "u16Get/vSetValueU16" and "u32Get/vSetValueU16"
//
//
// *********************************************************
// ***********************
//## Category: amt::amt_CCAMessages%3A0BF8D802EE
//## Subsystem: Amt::Include%3A7E97380302
//## Persistence: Transient
//## Cardinality/Multiplicity: n



//## Uses: uses%3A6EAC8B01F5;amt_tclMappableType { -> }

class amt_tclBaseMessage : public amt_tclMappableMessage  //## Inherits: <unnamed>%3A409CC50330
{
  //## begin amt_tclBaseMessage%3A3DDB5702DE.initialDeclarations preserve=yes
   #define AMT_C_U32_BASEMSG_SOURCEAPPID        (tU32)0
   #define AMT_C_U32_BASEMSG_TARGETAPPID        (tU32)2
   #define AMT_C_U32_BASEMSG_SIZE               (tU32)4
   #define AMT_C_U32_BASEMSG_VERSION            (tU32)8
   #define AMT_C_U32_BASEMSG_CONTEXT            (tU32)10
   #define AMT_C_U32_BASEMSG_TYPE               (tU32)11
   #define AMT_C_U32_BASEMSG_SOURCESUBID        (tU32)12
   #define AMT_C_U32_BASEMSG_TARGETSUBID        (tU32)14
   #define AMT_C_U32_BASEMSG_TIMESTAMP          (tU32)16

   #define AMT_C_U32_BASEMSG_ABSMSGSIZE         (tU32)20
  //## end amt_tclBaseMessage%3A3DDB5702DE.initialDeclarations

  public:
    //## Constructors (specified)
      //## Operation: amt_tclBaseMessage%3A6EADF30397
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Default Constructor - does NO ALLOCATION (no leaf class)
      //
      // PARAMETER:
      // -
      //
      // RETURNVALUE:
      // -
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      amt_tclBaseMessage ();

    //## Destructor (specified)
      //## Operation: ~amt_tclBaseMessage%3A6EADFA035B
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Destructor - does nothing here... message classes must
      // be deleted by explicitely calling "bDelete()".
      //
      // PARAMETER:
      // -
      //
      // RETURNVALUE:
      // -
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      virtual ~amt_tclBaseMessage ();


    //## Other Operations (specified)
      //## Operation: u8GetType%3A41D7F401AA
      tU8 u8GetType () const;

      //## Operation: u8GetContext%3A41DD9200CB
      tU8 u8GetContext () const;

      //## Operation: u16GetVersion%3A41DDA40031
      tU16 u16GetVersion () const;

      //## Operation: u32GetSize%3A41DDB1002F
      tU32 u32GetSize () const;

      //## Operation: u16GetSourceAppID%3A41DDBD02AE
      tU16 u16GetSourceAppID () const;

      //## Operation: u16GetTargetAppID%3A41DDC8023B
      tU16 u16GetTargetAppID () const;

      //## Operation: vSetType%3A41DDDE02F1
      tVoid vSetType (tU8 u8NewType);

      //## Operation: vSetContext%3A41DE01000C
      tVoid vSetContext (tU8 u8NewContext);

      //## Operation: vSetVersion%3A41DE1E0018
      tVoid vSetVersion (tU16 u16NewVersion);

      //## Operation: vSetSize%3A41DE3402F5
      tVoid vSetSize (tU32 u32NewSize);

      //## Operation: vSetSourceAppID%3A41DE4C03AE
      tVoid vSetSourceAppID (tU16 u16NewSourceAppID);

      //## Operation: vSetTargetAppID%3A41DE6B009B
      tVoid vSetTargetAppID (tU16 u16NewTargetAppID);

      //## Operation: vInitBaseMessage%3A6EAF6B0384
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Initialisation of all fields in the message header. Sets
      // source, target and type field to given values. The
      // message size field is set to dynamically calculated
      // value of "u32DynMsgSize"; version is initially set to 0
      // and context is set to ...LOCAL.
      //
      // PARAMETER:
      // tU16   u16Source
      // contents of source field (->I)
      // tU16   u16Target
      // contents of target field (->I)
      // tU8     u8Type
      // contents of type field (->I)
      // tU16   u16SourceSub
      // contents of source sub id field (->I)
      // default value 0x0000
      // tU16   u16TargetSub
      // contents of target sub id field (->I)
      // default value 0x0000
      // tU32   u32Timestamp
      // contents of time stamp field (->I)
      // default value 0x00000000
      //
      // RETURNVALUE:
      // tVoid
      //
      // History:
      // 29.01.02 PDP3-Andres
      // added parameters u16SourceSub and u16TargetSub due to
      // format
      // changes
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      tVoid vInitBaseMessage (tU16 u16Source, tU16 u16Target, tU8 u8Type, tU16 u16SourceSub = AMT_C_U16_DEFAULT_NULL, tU16 u16TargetSub = AMT_C_U16_DEFAULT_NULL, tU32 u32Timestamp = AMT_C_U32_DEFAULT_NULL);

      //## Operation: vPrintRaw%3A87C89901A3
      tVoid vPrintRaw (tBool bEnableMoreDetails = TRUE, tU32 bDefaultSize = AMT_TRACE_SIZE_DEFAULT) const;

      //## Operation: operator==%3AB7469E0080
      tBool operator == (const amt_tclBaseMessage& roRight) const;

      //## Operation: vBaseMessageSetup%3AB776DD0398
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Initialise BaseMessage; set "u32DynMsgSize" to the size
      // of the message header.
      //
      // PARAMETER:
      // -
      //
      // RETURNVALUE:
      // tVoid
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      tVoid vBaseMessageSetup ();

      //## Operation: operator!=%3AB8645D0265
      tBool operator != (const amt_tclBaseMessage& roRight) const;

      //## Operation: operator=%3ABB3CC20262
      amt_tclBaseMessage& operator = (const amt_tclBaseMessage& roRight);


      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // This is an alternative to the poClone method designed to enable 
      // submission of one single prototype message to multiple clients.
      // Therefore we:
      // - allocate shared memory in message pool of appropriate size
      // - set our internal pointer to it.
      // - copy the content (shared memory) of poPrototypeMessage into it.
      //
      // Return:  TRUE  if successful, 
      //          FALSE if poPrototypeMessage is invalid
      //                 or we already have a valid pointer to a message
      //                 or memory allocation fails 
      //
      // Note: 
      // - Direction of copy is opposite to method poClone; here we import.
      // - Derived classes don't need to overwrite this function
      //
      // History:
      // 19.11.07   Martin Koch (Fa. ESE)       
      // InitialVersion
      // *********************************************************
      // ***********************
      tBool bCloneMessageContent (const amt_tclBaseMessage* poPrototypeMessage);


      //## Operation: poClone%3B02476D01BD
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // see amt_tclMappableMessage.
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      virtual amt_tclMappableMessage* poClone () const;

      //## Operation: u8GetValue%3B7939860095
      inline tU8 u8GetValue (tU32 u32Offset) const;

      //## Operation: u16GetValue%3B79399B01E9
      inline tU16 u16GetValue (tU32 u32Offset) const;

      //## Operation: u32GetValue%3B7939A600AF
      inline tU32 u32GetValue (tU32 u32Offset) const;

      //## Operation: vSetValueU32%3B793CD50006
      inline tVoid vSetValueU32 (tU32 u32Offset, tU32 u32Value);

      //## Operation: vSetValueU16%3B793D2C011A
      inline tVoid vSetValueU16 (tU32 u32Offset, tU16 u16Value);

      //## Operation: vSetValueU8%3B793D470368
      inline tVoid vSetValueU8 (tU32 u32Offset, tU8 u8Value);

      inline tVoid vSetStreamU8(tU32 u32Offset, tU8 const * pu8Data, tU32 u32DataSize, tU32 u32MaxDataSize);

      inline tU8* pu8GetStreamU8(tU32 u32Offset) const;

      //## Operation: u16GetSourceSubID%3C50096F03D2
      tU16 u16GetSourceSubID () const;

      //## Operation: u16GetTargetSubID%3C500E0303C3
      tU16 u16GetTargetSubID () const;

      //## Operation: vSetSourceSubID%3C500E3F0261
      tVoid vSetSourceSubID (tU16 u16NewSourceSubID);

      //## Operation: vSetTargetSubID%3C500E7800E6
      tVoid vSetTargetSubID (tU16 u16NewTargetSubID);

      //## Operation: u32GetTimestamp%3C500EB100D4
      tU32 u32GetTimestamp () const;

      //## Operation: vSetTimestamp%3C500EDA02D2
      tVoid vSetTimestamp (tU32 u32NewTimestamp);

    // Additional Public Declarations
      //## begin amt_tclBaseMessage%3A3DDB5702DE.public preserve=yes
      //## end amt_tclBaseMessage%3A3DDB5702DE.public

  protected:
    //## Constructors (specified)
      //## Operation: amt_tclBaseMessage%3A7162EC013D
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Copy Constructor - does NO ALLOCATION (no leaf class)
      //
      // PARAMETER:
      // const amt_tclBaseMessage &
      //
      // RETURNVALUE:
      // -
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      amt_tclBaseMessage (const amt_tclBaseMessage& roBaseMessage);

    // Additional Protected Declarations
      //## begin amt_tclBaseMessage%3A3DDB5702DE.protected preserve=yes
      //## end amt_tclBaseMessage%3A3DDB5702DE.protected

};

//## begin amt_tclBaseMessage%3A3DDB5702DE.postscript preserve=yes
//## end amt_tclBaseMessage%3A3DDB5702DE.postscript

//## begin amt_tclPowerMessage%3A2CD1D8016B.preface preserve=yes
//## end amt_tclPowerMessage%3A2CD1D8016B.preface

//## Class: amt_tclPowerMessage%3A2CD1D8016B
// *********************************************************
// ***********************
// DESCRIPTION:
//
// This is the representation of a Power message. All get
// and set methods are undocumentated due to simplicity.
//
// History:
//
// 19.03.01 EFG32-Bruns
// InitialVersion
// 19.09.01 EFG32-Bruns
// Updated to ipc_def.h and using static offsets for all
// messages
//
// *********************************************************
// ***********************
//## Category: amt::amt_CCAMessages%3A0BF8D802EE
//## Subsystem: Amt::Include%3A7E97380302
//## Persistence: Transient
//## Cardinality/Multiplicity: n



class  amt_tclPowerMessage : public amt_tclBaseMessage  //## Inherits: <unnamed>%3A3E0DCB011E
{
  //## begin amt_tclPowerMessage%3A2CD1D8016B.initialDeclarations preserve=yes
   #define AMT_C_U32_POWERMESSAGE_POWERTYPE       (tU32)20
   #define AMT_C_U32_POWERMESSAGE_RESERVED        (tU32)22
   #define AMT_C_U32_POWERMESSAGE_POWERDATA1      (tU32)24
   #define AMT_C_U32_POWERMESSAGE_POWERDATA2      (tU32)28

   #define AMT_C_U32_POWERMESSAGE_RELMSGSIZE      (tU32)12
  //## end amt_tclPowerMessage%3A2CD1D8016B.initialDeclarations

  public:
    //## Constructors (specified)
      //## Operation: amt_tclPowerMessage%3A7172DE01A1
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Constructor - does ALLOCATION of message.
      //
      // PARAMETER:
      // tU16   u16Source (->I)
      // The value of the source field
      // tU16   u16Target (->I)
      // The value of the target field
      // tU16   u16PowerType (->I)
      // The value of the powertype field
      // tU32   u32PowerData1 (->I)
      // The value of the powerdata1 field
      // tU32   u32PowerData2 (->I)
      // The value of the powerdata2 field
      // tU16 u16SourceSub (->I)
      // The value of the source sub id field
      // tU16 u16TargetSub (->I)
      // The value of the target sub id field
      // tU32   u32Timestamp (->I)
      // The value of the timestamp field
      //
      // RETURNVALUE:
      // -
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // 29.01.02 PDP3-Andres
      // added parameters u16SourceSub, u16TargetSub and
      // u32Timestamp
      // *********************************************************
      // ***********************
      amt_tclPowerMessage (tU16 u16Source, tU16 u16Target, tU16 u16PowerType, tU32 u32PowerData1, tU32 u32PowerData2, tU16 u16SourceSub = AMT_C_U16_DEFAULT_NULL, tU16 u16TargetSub = AMT_C_U16_DEFAULT_NULL, tU32 u32Timestamp = AMT_C_U16_DEFAULT_NULL);

      //## Operation: amt_tclPowerMessage%3A7172F200CD
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Constructor for message reception - does NO ALLOCATION
      // of message. Transforms base message to this message.
      //
      // PARAMETER:
      // amt_tclBaseMessage   *poBaseMessage
      // Pointer to received base message
      //
      // RETURNVALUE:
      // -
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      amt_tclPowerMessage (amt_tclBaseMessage* poBaseMessage);
      amt_tclPowerMessage (const amt_tclBaseMessage* copoBaseMessage);
      amt_tclPowerMessage (const amt_tclBaseMessage& corfoBaseMessage);

      //## Operation: amt_tclPowerMessage%3ABA012B0230
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Default constructor - does ALLOCATION of message.
      //
      // PARAMETER:
      //
      // RETURNVALUE:
      // -
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      amt_tclPowerMessage ();


    //## Other Operations (specified)
      //## Operation: u16GetPowerType%3A71722300C6
      tU16 u16GetPowerType () const;

      //## Operation: vSetPowerType%3A71722B0294
      tVoid vSetPowerType (tU16 u16NewPowerType);

      //## Operation: u32GetPowerData1%3A717230031D
      tU32 u32GetPowerData1 () const;

      //## Operation: vSetPowerData1%3A717236018B
      tVoid vSetPowerData1 (tU32 u32NewPowerData);

      //## Operation: operator=%3AB8783001A4
      amt_tclPowerMessage& operator = (const amt_tclPowerMessage& roRight);

      //## Operation: operator==%3AB87856036C
      tBool operator == (const amt_tclPowerMessage& roRight) const; //lint !e1511: Member hides non-virtual member

      //## Operation: operator!=%3AB87857006A
      tBool operator != (const amt_tclPowerMessage& roRight) const; //lint !e1511: Member hides non-virtual member

      //## Operation: vPowerMessageSetup%3AB884E30163
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Initialise Power message; add size of this message class
      // to "u32DynMsgSize".
      //
      // PARAMETER:
      // -
      //
      // RETURNVALUE:
      // tVoid
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      tVoid vPowerMessageSetup ();

      //## Operation: u16GetReservedPower%3AD17BAA0198
      tU16 u16GetReservedPower () const;

      //## Operation: vSetReservedPower%3AD17BCC0115
      tVoid vSetReservedPower (tU16 u16NewReserved);

      //## Operation: u32GetPowerData2%3ADE90EB0194
      tU32 u32GetPowerData2 () const;

      //## Operation: vSetPowerData2%3ADE90F803E1
      tVoid vSetPowerData2 (tU32 u32NewPowerData);

      //## Operation: poClone%3B0241240191
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // see amt_tclMappableMessage.
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      virtual amt_tclMappableMessage* poClone () const;

    // Additional Public Declarations
      //## begin amt_tclPowerMessage%3A2CD1D8016B.public preserve=yes
      //## end amt_tclPowerMessage%3A2CD1D8016B.public

  protected:
    //## Constructors (specified)
      //## Operation: amt_tclPowerMessage%3ABB3BA503C0
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Copy-constructor for message - does ALLOCATION of
      // message.
      //
      // PARAMETER:
      // const amt_tclPowerMessage  &roRight (-> I)
      // Reference to message which will be copied.
      //
      // RETURNVALUE:
      // -
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      amt_tclPowerMessage (const amt_tclPowerMessage& roRight);

    // Additional Protected Declarations
      //## begin amt_tclPowerMessage%3A2CD1D8016B.protected preserve=yes
      //## end amt_tclPowerMessage%3A2CD1D8016B.protected

};

//## begin amt_tclPowerMessage%3A2CD1D8016B.postscript preserve=yes
//## end amt_tclPowerMessage%3A2CD1D8016B.postscript

//## begin amt_tclServiceSupplierRegister%3A0BF34303A7.preface preserve=yes
//## end amt_tclServiceSupplierRegister%3A0BF34303A7.preface

//## Class: amt_tclServiceSupplierRegister%3A0BF34303A7
// *********************************************************
// ***********************
// DESCRIPTION:
//
// This is the representation of a ServiceSupplierRegister message.
// All get and set methods are undocumentated due to
// simplicity.
//
// History:
//
// 19.03.01 EFG32-Bruns
// InitialVersion
// 19.09.01 EFG32-Bruns
// Updated to ipc_def.h and using static offsets for all
// messages
//
// *********************************************************
// ***********************
//## Category: amt::amt_CCAMessages%3A0BF8D802EE
//## Subsystem: Amt::Include%3A7E97380302
//## Persistence: Transient
//## Cardinality/Multiplicity: n



class amt_tclServiceSupplierRegister : public amt_tclBaseMessage  //## Inherits: <unnamed>%3A3E095101CA
{
  //## begin amt_tclServiceSupplierRegister%3A0BF34303A7.initialDeclarations preserve=yes
   #define AMT_C_U32_SVCSREGISTER_SERVICEID           (tU32)20

   #define AMT_C_U32_SVCSREGISTER_RELMSGSIZE          (tU32)2
  //## end amt_tclServiceSupplierRegister%3A0BF34303A7.initialDeclarations

  public:
    //## Constructors (specified)
      //## Operation: amt_tclServiceSupplierRegister%3A40953D021F
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Constructor - does ALLOCATION of message.
      //
      // PARAMETER:
      // tU16   u16Source (->I)
      // The value of the source field
      // tU16   u16Target (->I)
      // The value of the target field
      // tU16   u16ServiceID (->I)
      // The value of the service-ID field
      // tU16   u16SourceSub (->I)
      // The value of the source sub id field
      // tU16   u16TargetSub (->I)
      // The value of the target sub id field
      // tU32   u32Timestamp (->I)
      // The value of the timestamp field
      //
      // RETURNVALUE:
      // -
      //
      // History:
      // 04.09.09 TMS-Jentsch
      // *********************************************************
      // ***********************
      amt_tclServiceSupplierRegister (tU16 nSource, tU16 nTarget, tU16 nServiceID, tU16 u16SourceSub = AMT_C_U16_DEFAULT_NULL, tU16 u16TargetSub = AMT_C_U16_DEFAULT_NULL, tU32 u32TimeStamp = AMT_C_U32_DEFAULT_NULL);

      //## Operation: amt_tclServiceSupplierRegister%3A714FC40073
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Constructor for message reception - does NO ALLOCATION
      // of message. Transforms base message to this message.
      //
      // PARAMETER:
      // amt_tclBaseMessage   *poBaseMessage
      // Pointer to received base message
      //
      // RETURNVALUE:
      // -
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      amt_tclServiceSupplierRegister (amt_tclBaseMessage* poBaseMessage);
      amt_tclServiceSupplierRegister (const amt_tclBaseMessage* copoBaseMessage);
      amt_tclServiceSupplierRegister (const amt_tclBaseMessage& corfoBaseMessage);

      //## Operation: amt_tclServiceSupplierRegister%3AB785D0011A
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Default constructor - does ALLOCATION of message.
      //
      // PARAMETER:
      //
      // RETURNVALUE:
      // -
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      amt_tclServiceSupplierRegister ();


    //## Other Operations (specified)
      //## Operation: u16GetServiceID%3A41EE7B00B2
      tU16 u16GetServiceID () const;

      //## Operation: vSetServiceID%3A41EE98037A
      tVoid vSetServiceID (tU16 u16NewServiceID);

      //## Operation: operator==%3AB747970287
      tBool operator == (const amt_tclServiceSupplierRegister& roRight) const; //lint !e1511: Member hides non-virtual member

      //## Operation: vServiceSupplierRegisterSetup%3AB776FE01C9
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Initialise ServiceSupplierRegister message; add size of this
      // message class to "u32DynMsgSize".
      //
      // PARAMETER:
      // -
      //
      // RETURNVALUE:
      // tVoid
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      tVoid vServiceSupplierRegisterSetup ();

      //## Operation: operator=%3AB86091016D
      amt_tclServiceSupplierRegister& operator = (const amt_tclServiceSupplierRegister& roRight);

      //## Operation: operator!=%3AB8648B00C7
      tBool operator != (const amt_tclServiceSupplierRegister& roRight) const; //lint !e1511: Member hides non-virtual member

      //## Operation: poClone%3B0240BE01F9
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // see amt_tclMappableMessage.
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      virtual amt_tclMappableMessage* poClone () const;

    // Additional Public Declarations
      //## begin amt_tclServiceSupplierRegister%3A0BF34303A7.public preserve=yes
      //## end amt_tclServiceSupplierRegister%3A0BF34303A7.public

  protected:
    //## Constructors (specified)
      //## Operation: amt_tclServiceSupplierRegister%3AB786A703AE
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Copy-constructor for message - does ALLOCATION of
      // message.
      //
      // PARAMETER:
      // const amt_tclServiceSupplierRegister  &roRight (-> I)
      // Reference to message which will be copied.
      //
      // RETURNVALUE:
      // -
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      amt_tclServiceSupplierRegister (const amt_tclServiceSupplierRegister& roRight);

    // Additional Protected Declarations
      //## begin amt_tclServiceSupplierRegister%3A0BF34303A7.protected preserve=yes
      //## end amt_tclServiceSupplierRegister%3A0BF34303A7.protected

};

//## begin amt_tclServiceSupplierRegister%3A0BF34303A7.postscript preserve=yes
//## end amt_tclServiceSupplierRegister%3A0BF34303A7.postscript

//## begin amt_tclServiceSupplierStatus%3A2E3AD9029B.preface preserve=yes
//## end amt_tclServiceSupplierStatus%3A2E3AD9029B.preface

//## Class: amt_tclServiceSupplierStatus%3A2E3AD9029B
// *********************************************************
// ***********************
// DESCRIPTION:
//
// This is the representation of a ServiceSupplierStatus message.
// All get and set methods are undocumentated due to
// simplicity.
//
// History:
//
// 19.03.01 EFG32-Bruns
// InitialVersion
// 19.09.01 EFG32-Bruns
// Updated to ipc_def.h and using static offsets for all
// messages
//
// *********************************************************
// ***********************
//## Category: amt::amt_CCAMessages%3A0BF8D802EE
//## Subsystem: Amt::Include%3A7E97380302
//## Persistence: Transient
//## Cardinality/Multiplicity: n



class amt_tclServiceSupplierStatus : public amt_tclBaseMessage  //## Inherits: <unnamed>%3A3E0E36038E
{
  //## begin amt_tclServiceSupplierStatus%3A2E3AD9029B.initialDeclarations preserve=yes
   #define AMT_C_U32_SERVICESUPPLIERSTATUS_SERVICEID              (tU32)20
   #define AMT_C_U32_SERVICESUPPLIERSTATUS_APPID                  (tU32)22
   #define AMT_C_U32_SERVICESUPPLIERSTATUS_SERVICESUPPLIERSTATE   (tU32)24

   #define AMT_C_U32_SERVICESUPPLIERSTATUS_RELMSGSIZE         (tU32)5
  //## end amt_tclServiceSupplierStatus%3A2E3AD9029B.initialDeclarations

  public:
    //## Constructors (specified)
      //## Operation: amt_tclServiceSupplierStatus%3A7EC5B20260
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Constructor - does ALLOCATION of message.
      //
      // PARAMETER:
      // tU16   u16Source (->I)
      // The value of the source field
      // tU16   u16Target (->I)
      // The value of the target field
      // tU16   u16AppID (->I)
      // The value of the register-ID field
      // tU8 ServiceSupplierState
      // The value of the service state field
      // tU16 u16SourceSub
      // The value of the source sub id field (->I)
      // tU16 u16TargetSub
      // The value of the target sub id field (->I)
      // tU32 u32Timestamp
      // The value of the timestamp field (->I)
      //
      // RETURNVALUE:
      // -
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      amt_tclServiceSupplierStatus (tU16 u16Source, tU16 u16Target, tU16 u16ServiceID, tU16 u16AppID, tU8 u8ServiceSupplierState, tU16 u16SourceSub = AMT_C_U16_DEFAULT_NULL, tU16 u16TargetSub = AMT_C_U16_DEFAULT_NULL, tU32 u32TimeStamp = AMT_C_U32_DEFAULT_NULL);

      //## Operation: amt_tclServiceSupplierStatus%3A7EC5EF0041
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Constructor for message reception - does NO ALLOCATION
      // of message. Transforms base message to this message.
      //
      // PARAMETER:
      // amt_tclBaseMessage   *poBaseMessage
      // Pointer to received base message
      //
      // RETURNVALUE:
      // -
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      amt_tclServiceSupplierStatus (amt_tclBaseMessage* poBaseMessage);
      amt_tclServiceSupplierStatus (const amt_tclBaseMessage* copoBaseMessage);
      amt_tclServiceSupplierStatus (const amt_tclBaseMessage& corfoBaseMessage);

      //## Operation: amt_tclServiceSupplierStatus%3ABA0120018A
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Default constructor - does ALLOCATION of message.
      //
      // PARAMETER:
      //
      // RETURNVALUE:
      // -
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      amt_tclServiceSupplierStatus ();


    //## Other Operations (specified)
      //## Operation: u16GetServiceID%3A7EC49601F3
      tU16 u16GetServiceID () const;

      //## Operation: vSetServiceID%3A7EC4A901F1
      tVoid vSetServiceID (tU16 nServiceID);

      //## Operation: u16GetRegisterID%3A7EC4B201B7
      tU16 u16GetAppID () const;

      //## Operation: vSetRegisterID%3A7EC4BA01D7
      tVoid vSetAppID (tU16 nAppID);

      //## Operation: u8GetServiceSupplierState%3A7EC4EB0368
      tU8 u8GetServiceSupplierState () const;

      //## Operation: vSetServiceSupplierState%3A7EC4F3039C
      tVoid vSetServiceSupplierState (tU8 nServiceSupplierState);

      //## Operation: operator=%3AB87F3800BC
      amt_tclServiceSupplierStatus& operator = (const amt_tclServiceSupplierStatus& roRight);

      //## Operation: operator==%3AB87F5F0130
      tBool operator == (const amt_tclServiceSupplierStatus& roRight) const; //lint !e1511: Member hides non-virtual member

      //## Operation: operator!=%3AB87F6A00E6
      tBool operator != (const amt_tclServiceSupplierStatus& roRight) const; //lint !e1511: Member hides non-virtual member

      //## Operation: vServiceSupplierStatusSetup%3AB884D50145
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Initialise ServiceSupplierStatus message; add size of this
      // message class to "u32DynMsgSize".
      //
      // PARAMETER:
      // -
      //
      // RETURNVALUE:
      // tVoid
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      tVoid vServiceSupplierStatusSetup ();

      //## Operation: poClone%3B0241200203
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // see amt_tclMappableMessage.
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      virtual amt_tclMappableMessage* poClone () const;

    // Additional Public Declarations
      //## begin amt_tclServiceSupplierStatus%3A2E3AD9029B.public preserve=yes
      //## end amt_tclServiceSupplierStatus%3A2E3AD9029B.public

  protected:
    //## Constructors (specified)
      //## Operation: amt_tclServiceSupplierStatus%3ABB39AF0061
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Copy-constructor for message - does ALLOCATION of
      // message.
      //
      // PARAMETER:
      // const amt_tclServiceSupplierStatus    &roRight (-> I)
      // Reference to message which will be copied.
      //
      // RETURNVALUE:
      // -
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      amt_tclServiceSupplierStatus (const amt_tclServiceSupplierStatus& roRight);

    // Additional Protected Declarations
      //## begin amt_tclServiceSupplierStatus%3A2E3AD9029B.protected preserve=yes
      //## end amt_tclServiceSupplierStatus%3A2E3AD9029B.protected

};

//## begin amt_tclServiceSupplierStatus%3A2E3AD9029B.postscript preserve=yes
//## end amt_tclServiceSupplierStatus%3A2E3AD9029B.postscript


//## begin amt_tclServiceSupplierUnregister%3A0BF34303A7.preface preserve=yes
//## end amt_tclServiceSupplierUnregister%3A0BF34303A7.preface

//## Class: amt_tclServiceSupplierUnregister%3A0BF34303A7
// *********************************************************
// ***********************
// DESCRIPTION:
//
// This is the representation of a ServiceSupplierUnregister message.
// All get and set methods are undocumentated due to
// simplicity.
//
// History:
//
// 19.03.01 EFG32-Bruns
// InitialVersion
// 19.09.01 EFG32-Bruns
// Updated to ipc_def.h and using static offsets for all
// messages
//
// *********************************************************
// ***********************
//## Category: amt::amt_CCAMessages%3A0BF8D802EE
//## Subsystem: Amt::Include%3A7E97380302
//## Persistence: Transient
//## Cardinality/Multiplicity: n



class amt_tclServiceSupplierUnregister : public amt_tclBaseMessage  //## Inherits: <unnamed>%3A3E095101CA
{
  //## begin amt_tclServiceSupplierUnregister%3A0BF34303A7.initialDeclarations preserve=yes
   #define AMT_C_U32_SVSUNREGISTER_SERVICEID           (tU32)20

   #define AMT_C_U32_SCSUNREGISTER_RELMSGSIZE          (tU32)2
  //## end amt_tclServiceSupplierUnregister%3A0BF34303A7.initialDeclarations

  public:
    //## Constructors (specified)
      //## Operation: amt_tclServiceSupplierUnregister%3A40953D021F
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Constructor - does ALLOCATION of message.
      //
      // PARAMETER:
      // tU16   u16Source (->I)
      // The value of the source field
      // tU16   u16Target (->I)
      // The value of the target field
      // tU16   u16ServiceID (->I)
      // The value of the service-ID field
      // tU16   u16SourceSub (->I)
      // The value of the source sub id field
      // tU16   u16TargetSub (->I)
      // The value of the target sub id field
      // tU32   u32Timestamp (->I)
      // The value of the timestamp field
      //
      // RETURNVALUE:
      // -
      //
      // History:
      // 04.09.09 TMS-Jentsch
      // *********************************************************
      // ***********************
      amt_tclServiceSupplierUnregister (tU16 nSource, tU16 nTarget, tU16 nServiceID, tU16 u16SourceSub = AMT_C_U16_DEFAULT_NULL, tU16 u16TargetSub = AMT_C_U16_DEFAULT_NULL, tU32 u32TimeStamp = AMT_C_U32_DEFAULT_NULL);

      //## Operation: amt_tclServiceSupplierUnregister%3A714FC40073
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Constructor for message reception - does NO ALLOCATION
      // of message. Transforms base message to this message.
      //
      // PARAMETER:
      // amt_tclBaseMessage   *poBaseMessage
      // Pointer to received base message
      //
      // RETURNVALUE:
      // -
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      amt_tclServiceSupplierUnregister (amt_tclBaseMessage* poBaseMessage);
      amt_tclServiceSupplierUnregister (const amt_tclBaseMessage* copoBaseMessage);
      amt_tclServiceSupplierUnregister (const amt_tclBaseMessage& corfoBaseMessage);

      //## Operation: amt_tclServiceSupplierUnregister%3AB785D0011A
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Default constructor - does ALLOCATION of message.
      //
      // PARAMETER:
      //
      // RETURNVALUE:
      // -
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      amt_tclServiceSupplierUnregister ();


    //## Other Operations (specified)
      //## Operation: u16GetServiceID%3A41EE7B00B2
      tU16 u16GetServiceID () const;

      //## Operation: vSetServiceID%3A41EE98037A
      tVoid vSetServiceID (tU16 u16NewServiceID);

      //## Operation: operator==%3AB747970287
      tBool operator == (const amt_tclServiceSupplierUnregister& roRight) const; //lint !e1511: Member hides non-virtual member

      //## Operation: vServiceSupplierUnregisterSetup%3AB776FE01C9
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Initialise ServiceSupplierUnregister message; add size of this
      // message class to "u32DynMsgSize".
      //
      // PARAMETER:
      // -
      //
      // RETURNVALUE:
      // tVoid
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      tVoid vServiceSupplierUnregisterSetup ();

      //## Operation: operator=%3AB86091016D
      amt_tclServiceSupplierUnregister& operator = (const amt_tclServiceSupplierUnregister& roRight);

      //## Operation: operator!=%3AB8648B00C7
      tBool operator != (const amt_tclServiceSupplierUnregister& roRight) const; //lint !e1511: Member hides non-virtual member

      //## Operation: poClone%3B0240BE01F9
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // see amt_tclMappableMessage.
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      virtual amt_tclMappableMessage* poClone () const;

    // Additional Public Declarations
      //## begin amt_tclServiceSupplierUnregister%3A0BF34303A7.public preserve=yes
      //## end amt_tclServiceSupplierUnregister%3A0BF34303A7.public

  protected:
    //## Constructors (specified)
      //## Operation: amt_tclServiceSupplierUnregister%3AB786A703AE
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Copy-constructor for message - does ALLOCATION of
      // message.
      //
      // PARAMETER:
      // const amt_tclServiceSupplierUnregister  &roRight (-> I)
      // Reference to message which will be copied.
      //
      // RETURNVALUE:
      // -
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      amt_tclServiceSupplierUnregister (const amt_tclServiceSupplierUnregister& roRight);

    // Additional Protected Declarations
      //## begin amt_tclServiceSupplierUnregister%3A0BF34303A7.protected preserve=yes
      //## end amt_tclServiceSupplierUnregister%3A0BF34303A7.protected

};

//## begin amt_tclServiceSupplierUnregister%3A0BF34303A7.postscript preserve=yes
//## end amt_tclServiceSupplierUnregister%3A0BF34303A7.postscript

//## begin amt_tclApplicationInfoRegister%3A0BF34303A7.preface preserve=yes
//## end amt_tclApplicationInfoRegister%3A0BF34303A7.preface

//## Class: amt_tclApplicationInfoRegister%3A0BF34303A7
// *********************************************************
// ***********************
// DESCRIPTION:
//
// This is the representation of a ApplicationInfoRegister message.
// All get and set methods are undocumentated due to
// simplicity.
//
// History:
//
// 19.03.01 EFG32-Bruns
// InitialVersion
// 19.09.01 EFG32-Bruns
// Updated to ipc_def.h and using static offsets for all
// messages
//
// *********************************************************
// ***********************
//## Category: amt::amt_CCAMessages%3A0BF8D802EE
//## Subsystem: Amt::Include%3A7E97380302
//## Persistence: Transient
//## Cardinality/Multiplicity: n



class amt_tclApplicationInfoRegister : public amt_tclBaseMessage  //## Inherits: <unnamed>%3A3E095101CA
{
  //## begin amt_tclApplicationInfoRegister%3A0BF34303A7.initialDeclarations preserve=yes
   #define AMT_C_U32_AIREGISTER_APPID           (tU32)20

   #define AMT_C_U32_AIREGISTER_RELMSGSIZE     (tU32)2
  //## end amt_tclApplicationInfoRegister%3A0BF34303A7.initialDeclarations

  public:
    //## Constructors (specified)
      //## Operation: amt_tclApplicationInfoRegister%3A40953D021F
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Constructor - does ALLOCATION of message.
      //
      // PARAMETER:
      // tU16   u16Source (->I)
      // The value of the source field
      // tU16   u16Target (->I)
      // The value of the target field
      // tU16   u16AppID (->I)
      // The value of the service-ID field
      // tU16   u16SourceSub (->I)
      // The value of the source sub id field
      // tU16   u16TargetSub (->I)
      // The value of the target sub id field
      // tU32   u32Timestamp (->I)
      // The value of the timestamp field
      //
      // RETURNVALUE:
      // -
      //
      // History:
      // 04.09.09 TMS-Jentsch
      // *********************************************************
      // ***********************
      amt_tclApplicationInfoRegister (tU16 nSource, tU16 nTarget, tU16 nAppID, tU16 u16SourceSub = AMT_C_U16_DEFAULT_NULL, tU16 u16TargetSub = AMT_C_U16_DEFAULT_NULL, tU32 u32TimeStamp = AMT_C_U32_DEFAULT_NULL);

      //## Operation: amt_tclApplicationInfoRegister%3A714FC40073
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Constructor for message reception - does NO ALLOCATION
      // of message. Transforms base message to this message.
      //
      // PARAMETER:
      // amt_tclBaseMessage   *poBaseMessage
      // Pointer to received base message
      //
      // RETURNVALUE:
      // -
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      amt_tclApplicationInfoRegister (amt_tclBaseMessage* poBaseMessage);
      amt_tclApplicationInfoRegister (const amt_tclBaseMessage* copoBaseMessage);
      amt_tclApplicationInfoRegister (const amt_tclBaseMessage& corfoBaseMessage);

      //## Operation: amt_tclApplicationInfoRegister%3AB785D0011A
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Default constructor - does ALLOCATION of message.
      //
      // PARAMETER:
      //
      // RETURNVALUE:
      // -
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      amt_tclApplicationInfoRegister ();


    //## Other Operations (specified)
      //## Operation: u16GetServiceID%3A41EE7B00B2
      tU16 u16GetAppID () const;

      //## Operation: vSetServiceID%3A41EE98037A
      tVoid vSetAppID (tU16 u16NewServiceID);

      //## Operation: operator==%3AB747970287
      tBool operator == (const amt_tclApplicationInfoRegister& roRight) const; //lint !e1511: Member hides non-virtual member

      //## Operation: vApplicationInfoRegisterSetup%3AB776FE01C9
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Initialise ApplicationInfoRegister message; add size of this
      // message class to "u32DynMsgSize".
      //
      // PARAMETER:
      // -
      //
      // RETURNVALUE:
      // tVoid
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      tVoid vApplicationInfoRegisterSetup ();

      //## Operation: operator=%3AB86091016D
      amt_tclApplicationInfoRegister& operator = (const amt_tclApplicationInfoRegister& roRight);

      //## Operation: operator!=%3AB8648B00C7
      tBool operator != (const amt_tclApplicationInfoRegister& roRight) const; //lint !e1511: Member hides non-virtual member

      //## Operation: poClone%3B0240BE01F9
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // see amt_tclMappableMessage.
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      virtual amt_tclMappableMessage* poClone () const;

    // Additional Public Declarations
      //## begin amt_tclApplicationInfoRegister%3A0BF34303A7.public preserve=yes
      //## end amt_tclApplicationInfoRegister%3A0BF34303A7.public

  protected:
    //## Constructors (specified)
      //## Operation: amt_tclApplicationInfoRegister%3AB786A703AE
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Copy-constructor for message - does ALLOCATION of
      // message.
      //
      // PARAMETER:
      // const amt_tclApplicationInfoRegister  &roRight (-> I)
      // Reference to message which will be copied.
      //
      // RETURNVALUE:
      // -
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      amt_tclApplicationInfoRegister (const amt_tclApplicationInfoRegister& roRight);

    // Additional Protected Declarations
      //## begin amt_tclApplicationInfoRegister%3A0BF34303A7.protected preserve=yes
      //## end amt_tclApplicationInfoRegister%3A0BF34303A7.protected

};

//## begin amt_tclApplicationInfoRegister%3A0BF34303A7.postscript preserve=yes
//## end amt_tclApplicationInfoRegister%3A0BF34303A7.postscript

//## begin amt_tclApplicationInfoStatus%3A2E3AD9029B.preface preserve=yes
//## end amt_tclApplicationInfoStatus%3A2E3AD9029B.preface

//## Class: amt_tclApplicationInfoStatus%3A2E3AD9029B
// *********************************************************
// ***********************
// DESCRIPTION:
//
// This is the representation of a ApplicationInfo message.
// All get and set methods are undocumentated due to
// simplicity.
//
// History:
//
// 19.03.01 EFG32-Bruns
// InitialVersion
// 19.09.01 EFG32-Bruns
// Updated to ipc_def.h and using static offsets for all
// messages
//
// *********************************************************
// ***********************
//## Category: amt::amt_CCAMessages%3A0BF8D802EE
//## Subsystem: Amt::Include%3A7E97380302
//## Persistence: Transient
//## Cardinality/Multiplicity: n



class amt_tclApplicationInfoStatus : public amt_tclBaseMessage  //## Inherits: <unnamed>%3A3E0E36038E
{
  //## begin amt_tclApplicationInfoStatus%3A2E3AD9029B.initialDeclarations preserve=yes
   #define AMT_C_U32_APPLICATIONINFO_APPID                  (tU32)20
   #define AMT_C_U32_APPLICATIONINFO_APPSTATE               (tU32)22

   #define AMT_C_U32_AI_RELMSGSIZE                          (tU32)3
  //## end amt_tclApplicationInfoStatus%3A2E3AD9029B.initialDeclarations

  public:
    //## Constructors (specified)
      //## Operation: amt_tclApplicationInfoStatus%3A7EC5B20260
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Constructor - does ALLOCATION of message.
      //
      // PARAMETER:
      // tU16   u16Source (->I)
      // The value of the source field
      // tU16   u16Target (->I)
      // The value of the target field
      // tU16   u16AppID (->I)
      // The value of the register-ID field
      // tU8 ServiceSupplierState
      // The value of the service state field
      // tU16 u16SourceSub
      // The value of the source sub id field (->I)
      // tU16 u16TargetSub
      // The value of the target sub id field (->I)
      // tU32 u32Timestamp
      // The value of the timestamp field (->I)
      //
      // RETURNVALUE:
      // -
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      amt_tclApplicationInfoStatus (tU16 u16Source, tU16 u16Target, tU16 u16AppID, tU8 u8ApplicationInfoState, tU16 u16SourceSub = AMT_C_U16_DEFAULT_NULL, tU16 u16TargetSub = AMT_C_U16_DEFAULT_NULL, tU32 u32Timestamp = AMT_C_U32_DEFAULT_NULL);

      //## Operation: amt_tclApplicationInfoStatus%3A7EC5EF0041
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Constructor for message reception - does NO ALLOCATION
      // of message. Transforms base message to this message.
      //
      // PARAMETER:
      // amt_tclBaseMessage   *poBaseMessage
      // Pointer to received base message
      //
      // RETURNVALUE:
      // -
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      amt_tclApplicationInfoStatus (amt_tclBaseMessage* poBaseMessage);
      amt_tclApplicationInfoStatus (const amt_tclBaseMessage* copoBaseMessage);
      amt_tclApplicationInfoStatus (const amt_tclBaseMessage& corfoBaseMessage);

      //## Operation: amt_tclApplicationInfoStatus%3ABA0120018A
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Default constructor - does ALLOCATION of message.
      //
      // PARAMETER:
      //
      // RETURNVALUE:
      // -
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      amt_tclApplicationInfoStatus ();


    //## Other Operations (specified)
      //## Operation: u16GetRegisterID%3A7EC4B201B7
      tU16 u16GetAppID () const;

      //## Operation: vSetRegisterID%3A7EC4BA01D7
      tVoid vSetAppID (tU16 nRegisterID);

      //## Operation: u8GetServiceSupplierState%3A7EC4EB0368
      tU8 u8GetApplicationInfoState () const;

      //## Operation: vSetServiceSupplierState%3A7EC4F3039C
      tVoid vSetApplicationInfoState (tU8 nServiceSupplierState);

      //## Operation: operator=%3AB87F3800BC
      amt_tclApplicationInfoStatus& operator = (const amt_tclApplicationInfoStatus& roRight);

      //## Operation: operator==%3AB87F5F0130
      tBool operator == (const amt_tclApplicationInfoStatus& roRight) const; //lint !e1511: Member hides non-virtual member

      //## Operation: operator!=%3AB87F6A00E6
      tBool operator != (const amt_tclApplicationInfoStatus& roRight) const; //lint !e1511: Member hides non-virtual member

      //## Operation: vApplicationInfoSetup%3AB884D50145
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Initialise ApplicationInfo message; add size of this
      // message class to "u32DynMsgSize".
      //
      // PARAMETER:
      // -
      //
      // RETURNVALUE:
      // tVoid
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      tVoid vApplicationInfoStatusSetup ();

      //## Operation: poClone%3B0241200203
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // see amt_tclMappableMessage.
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      virtual amt_tclMappableMessage* poClone () const;

    // Additional Public Declarations
      //## begin amt_tclApplicationInfoStatus%3A2E3AD9029B.public preserve=yes
      //## end amt_tclApplicationInfoStatus%3A2E3AD9029B.public

  protected:
    //## Constructors (specified)
      //## Operation: amt_tclApplicationInfoStatus%3ABB39AF0061
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Copy-constructor for message - does ALLOCATION of
      // message.
      //
      // PARAMETER:
      // const amt_tclApplicationInfoStatus    &roRight (-> I)
      // Reference to message which will be copied.
      //
      // RETURNVALUE:
      // -
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      amt_tclApplicationInfoStatus (const amt_tclApplicationInfoStatus& roRight);

    // Additional Protected Declarations
      //## begin amt_tclApplicationInfoStatus%3A2E3AD9029B.protected preserve=yes
      //## end amt_tclApplicationInfoStatus%3A2E3AD9029B.protected

};

//## begin amt_tclApplicationInfoStatus%3A2E3AD9029B.postscript preserve=yes
//## end amt_tclApplicationInfoStatus%3A2E3AD9029B.postscript


//## begin amt_tclApplicationInfoUnregister%3A0BF34303A7.preface preserve=yes
//## end amt_tclApplicationInfoUnregister%3A0BF34303A7.preface

//## Class: amt_tclApplicationInfoUnregister%3A0BF34303A7
// *********************************************************
// ***********************
// DESCRIPTION:
//
// This is the representation of a ApplicationInfoUnregister message.
// All get and set methods are undocumentated due to
// simplicity.
//
// History:
//
// 19.03.01 EFG32-Bruns
// InitialVersion
// 19.09.01 EFG32-Bruns
// Updated to ipc_def.h and using static offsets for all
// messages
//
// *********************************************************
// ***********************
//## Category: amt::amt_CCAMessages%3A0BF8D802EE
//## Subsystem: Amt::Include%3A7E97380302
//## Persistence: Transient
//## Cardinality/Multiplicity: n



class amt_tclApplicationInfoUnregister : public amt_tclBaseMessage  //## Inherits: <unnamed>%3A3E095101CA
{
  //## begin amt_tclApplicationInfoUnregister%3A0BF34303A7.initialDeclarations preserve=yes
   #define AMT_C_U32_AI_UNREGISTER_APPID           (tU32)20

   #define AMT_C_U32_AI_UNREGISTER_RELMSGSIZE     (tU32)2
  //## end amt_tclApplicationInfoUnregister%3A0BF34303A7.initialDeclarations

  public:
    //## Constructors (specified)
      //## Operation: amt_tclApplicationInfoUnregister%3A40953D021F
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Constructor - does ALLOCATION of message.
      //
      // PARAMETER:
      // tU16   u16Source (->I)
      // The value of the source field
      // tU16   u16Target (->I)
      // The value of the target field
      // tU16   u16AppID (->I)
      // The value of the service-ID field
      // tU16   u16SourceSub (->I)
      // The value of the source sub id field
      // tU16   u16TargetSub (->I)
      // The value of the target sub id field
      // tU32   u32Timestamp (->I)
      // The value of the timestamp field
      //
      // RETURNVALUE:
      // -
      //
      // History:
      // 04.09.09 TMS-Jentsch
      // *********************************************************
      // ***********************
      amt_tclApplicationInfoUnregister (tU16 nSource, tU16 nTarget, tU16 nAppID, tU16 u16SourceSub = AMT_C_U16_DEFAULT_NULL, tU16 u16TargetSub = AMT_C_U16_DEFAULT_NULL, tU32 u32TimeStamp = AMT_C_U32_DEFAULT_NULL);

      //## Operation: amt_tclApplicationInfoUnregister%3A714FC40073
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Constructor for message reception - does NO ALLOCATION
      // of message. Transforms base message to this message.
      //
      // PARAMETER:
      // amt_tclBaseMessage   *poBaseMessage
      // Pointer to received base message
      //
      // RETURNVALUE:
      // -
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      amt_tclApplicationInfoUnregister (amt_tclBaseMessage* poBaseMessage);
      amt_tclApplicationInfoUnregister (const amt_tclBaseMessage* copoBaseMessage);
      amt_tclApplicationInfoUnregister (const amt_tclBaseMessage& corfoBaseMessage);

      //## Operation: amt_tclApplicationInfoUnregister%3AB785D0011A
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Default constructor - does ALLOCATION of message.
      //
      // PARAMETER:
      //
      // RETURNVALUE:
      // -
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      amt_tclApplicationInfoUnregister ();


    //## Other Operations (specified)
      //## Operation: u16GetServiceID%3A41EE7B00B2
      tU16 u16GetAppID () const;

      //## Operation: vSetServiceID%3A41EE98037A
      tVoid vSetAppID (tU16 u16NewServiceID);

      //## Operation: operator==%3AB747970287
      tBool operator == (const amt_tclApplicationInfoUnregister& roRight) const; //lint !e1511: Member hides non-virtual member

      //## Operation: vApplicationInfoUnregisterSetup%3AB776FE01C9
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Initialise ApplicationInfoUnregister message; add size of this
      // message class to "u32DynMsgSize".
      //
      // PARAMETER:
      // -
      //
      // RETURNVALUE:
      // tVoid
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      tVoid vApplicationInfoUnregisterSetup ();

      //## Operation: operator=%3AB86091016D
      amt_tclApplicationInfoUnregister& operator = (const amt_tclApplicationInfoUnregister& roRight);

      //## Operation: operator!=%3AB8648B00C7
      tBool operator != (const amt_tclApplicationInfoUnregister& roRight) const; //lint !e1511: Member hides non-virtual member

      //## Operation: poClone%3B0240BE01F9
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // see amt_tclMappableMessage.
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      virtual amt_tclMappableMessage* poClone () const;

    // Additional Public Declarations
      //## begin amt_tclApplicationInfoUnregister%3A0BF34303A7.public preserve=yes
      //## end amt_tclApplicationInfoUnregister%3A0BF34303A7.public

  protected:
    //## Constructors (specified)
      //## Operation: amt_tclApplicationInfoUnregister%3AB786A703AE
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Copy-constructor for message - does ALLOCATION of
      // message.
      //
      // PARAMETER:
      // const amt_tclApplicationInfoUnregister  &roRight (-> I)
      // Reference to message which will be copied.
      //
      // RETURNVALUE:
      // -
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      amt_tclApplicationInfoUnregister (const amt_tclApplicationInfoUnregister& roRight);

    // Additional Protected Declarations
      //## begin amt_tclApplicationInfoUnregister%3A0BF34303A7.protected preserve=yes
      //## end amt_tclApplicationInfoUnregister%3A0BF34303A7.protected

};

//## begin amt_tclApplicationInfoUnregister%3A0BF34303A7.postscript preserve=yes
//## end amt_tclApplicationInfoUnregister%3A0BF34303A7.postscript


//## begin amt_tclServiceRegister%3A0BF34303A7.preface preserve=yes
//## end amt_tclServiceRegister%3A0BF34303A7.preface

//## Class: amt_tclServiceRegister%3A0BF34303A7
// *********************************************************
// ***********************
// DESCRIPTION:
//
// This is the representation of a ServiceRegister message.
// All get and set methods are undocumentated due to
// simplicity.
//
// History:
//
// 19.03.01 EFG32-Bruns
// InitialVersion
// 19.09.01 EFG32-Bruns
// Updated to ipc_def.h and using static offsets for all
// messages
//
// *********************************************************
// ***********************
//## Category: amt::amt_CCAMessages%3A0BF8D802EE
//## Subsystem: Amt::Include%3A7E97380302
//## Persistence: Transient
//## Cardinality/Multiplicity: n



class amt_tclServiceRegister : public amt_tclBaseMessage  //## Inherits: <unnamed>%3A3E095101CA
{
  //## begin amt_tclServiceRegister%3A0BF34303A7.initialDeclarations preserve=yes
   #define AMT_C_U32_SVCREGISTER_SERVICEID           (tU32)20
   #define AMT_C_U32_SVCREGISTER_SERVICEMAJORVERSION (tU32)22
   #define AMT_C_U32_SVCREGISTER_SERVICEMINORVERSION (tU32)24

   #define AMT_C_U32_SVCREGISTER_RELMSGSIZE     (tU32)6
  //## end amt_tclServiceRegister%3A0BF34303A7.initialDeclarations

  public:
    //## Constructors (specified)
      //## Operation: amt_tclServiceRegister%3A40953D021F
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Constructor - does ALLOCATION of message.
      //
      // PARAMETER:
      // tU16   u16Source (->I)
      // The value of the source field
      // tU16   u16Target (->I)
      // The value of the target field
      // tU16   u16ServiceID (->I)
      // The value of the service-ID field
      // tU16   u16ServiceVersion (->I)
      // The value of the version field
      // tU16   u16SourceSub (->I)
      // The value of the source sub id field
      // tU16   u16TargetSub (->I)
      // The value of the target sub id field
      // tU32   u32Timestamp (->I)
      // The value of the timestamp field
      //
      // RETURNVALUE:
      // -
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // 29.01.02 PDP3-Andres
      // added parameters u16SourceSub, u16TargetSub and
      // u32Timestamp
      // *********************************************************
      // ***********************
      amt_tclServiceRegister (tU16 nSource, tU16 nTarget, tU16 nServiceID, tU16 nServiceMajorVersion, tU16 nServiceMinorVersion, tU16 u16SourceSub = AMT_C_U16_DEFAULT_NULL, tU16 u16TargetSub = AMT_C_U16_DEFAULT_NULL, tU32 u32TimeStamp = AMT_C_U32_DEFAULT_NULL);

      //## Operation: amt_tclServiceRegister%3A714FC40073
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Constructor for message reception - does NO ALLOCATION
      // of message. Transforms base message to this message.
      //
      // PARAMETER:
      // amt_tclBaseMessage   *poBaseMessage
      // Pointer to received base message
      //
      // RETURNVALUE:
      // -
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      amt_tclServiceRegister (amt_tclBaseMessage* poBaseMessage);
      amt_tclServiceRegister (const amt_tclBaseMessage* copoBaseMessage);
      amt_tclServiceRegister (const amt_tclBaseMessage& corfoBaseMessage);

      //## Operation: amt_tclServiceRegister%3AB785D0011A
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Default constructor - does ALLOCATION of message.
      //
      // PARAMETER:
      //
      // RETURNVALUE:
      // -
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      amt_tclServiceRegister ();


    //## Other Operations (specified)
      //## Operation: u16GetServiceID%3A41EE7B00B2
      tU16 u16GetServiceID () const;

      //## Operation: u16GetServiceMajorVersion%3A41EE87029A
      tU16 u16GetServiceMajorVersion () const;

      //## Operation: vSetServiceID%3A41EE98037A
      tVoid vSetServiceID (tU16 u16NewServiceID);

      //## Operation: vSetServiceMajorVersion%3A41EE9E03E7
      tVoid vSetServiceMajorVersion (tU16 u16NewServiceVersion);

      //## Operation: operator==%3AB747970287
      tBool operator == (const amt_tclServiceRegister& roRight) const; //lint !e1511: Member hides non-virtual member

      //## Operation: vServiceRegisterSetup%3AB776FE01C9
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Initialise ServiceRegister message; add size of this
      // message class to "u32DynMsgSize".
      //
      // PARAMETER:
      // -
      //
      // RETURNVALUE:
      // tVoid
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      tVoid vServiceRegisterSetup ();

      //## Operation: operator=%3AB86091016D
      amt_tclServiceRegister& operator = (const amt_tclServiceRegister& roRight);

      //## Operation: operator!=%3AB8648B00C7
      tBool operator != (const amt_tclServiceRegister& roRight) const; //lint !e1511: Member hides non-virtual member

      //## Operation: poClone%3B0240BE01F9
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // see amt_tclMappableMessage.
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      virtual amt_tclMappableMessage* poClone () const;

      //## Operation: u16GetServiceMinorVersion%3C5130780285
      tU16 u16GetServiceMinorVersion () const;

      //## Operation: vSetServiceMinorVersion%3C5130880238
      tVoid vSetServiceMinorVersion (tU16 u16NewServiceVersion);

    // Additional Public Declarations
      //## begin amt_tclServiceRegister%3A0BF34303A7.public preserve=yes
      //## end amt_tclServiceRegister%3A0BF34303A7.public

  protected:
    //## Constructors (specified)
      //## Operation: amt_tclServiceRegister%3AB786A703AE
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Copy-constructor for message - does ALLOCATION of
      // message.
      //
      // PARAMETER:
      // const amt_tclServiceRegister  &roRight (-> I)
      // Reference to message which will be copied.
      //
      // RETURNVALUE:
      // -
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      amt_tclServiceRegister (const amt_tclServiceRegister& roRight);

    // Additional Protected Declarations
      //## begin amt_tclServiceRegister%3A0BF34303A7.protected preserve=yes
      //## end amt_tclServiceRegister%3A0BF34303A7.protected

};

//## begin amt_tclServiceRegister%3A0BF34303A7.postscript preserve=yes
//## end amt_tclServiceRegister%3A0BF34303A7.postscript

//## begin amt_tclServiceData%3A0BF3B20266.preface preserve=yes
//## end amt_tclServiceData%3A0BF3B20266.preface

//## Class: amt_tclServiceData%3A0BF3B20266
// *********************************************************
// ***********************
// DESCRIPTION:
//
// This is the representation of a ServiceData message. It
// is the *gateway* for user messages. All user messages
// must be derived from ServiceData messages.
// All get and set methods are undocumentated due to
// simplicity.
//
// History:
//
// 19.03.01 EFG32-Bruns
// InitialVersion
// 19.09.01 EFG32-Bruns
// Updated to ipc_def.h and using static offsets for all
// messages
//
// *********************************************************
// ***********************
//## Category: amt::amt_CCAMessages%3A0BF8D802EE
//## Subsystem: Amt::Include%3A7E97380302
//## Persistence: Transient
//## Cardinality/Multiplicity: n



class amt_tclServiceData : public amt_tclBaseMessage  //## Inherits: <unnamed>%3A3E0E8F0292
{
  //## begin amt_tclServiceData%3A0BF3B20266.initialDeclarations preserve=yes
   #define AMT_C_U32_SVCDATA_SERVICEID          (tU32)20
   #define AMT_C_U32_SVCDATA_REGISTERID         (tU32)22
   #define AMT_C_U32_SVCDATA_FUNCTIONID         (tU32)24
   #define AMT_C_U32_SVCDATA_OPCODE             (tU32)26
   #define AMT_C_U32_SVCDATA_ACT                (tU32)27
   #define AMT_C_U32_SVCDATA_CMDCOUNTER         (tU32)28
   #define AMT_C_U32_SVCDATA_STREAMTYPE         (tU32)30
   #define AMT_C_U32_SVCDATA_STREAMCOUNTER      (tU32)31

   #define AMT_C_U32_SVCDATA_RELMSGSIZE         (tU32)12
  //## end amt_tclServiceData%3A0BF3B20266.initialDeclarations

  public:
    //## Constructors (specified)
      //## Operation: amt_tclServiceData%3A15282101D4
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Constructor for message reception - does NO ALLOCATION
      // of message. Transforms base message to this message.
      //
      // PARAMETER:
      // amt_tclBaseMessage   *poBaseMessage
      // Pointer to received base message
      //
      // RETURNVALUE:
      // -
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      amt_tclServiceData (amt_tclBaseMessage* poBaseMessage);
      amt_tclServiceData (const amt_tclBaseMessage* copoBaseMessage);
      amt_tclServiceData (const amt_tclBaseMessage& corfoBaseMessage);

      //## Operation: amt_tclServiceData%3A7FCAEF0216
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Default constructor - does NO ALLOCATION of message (no
      // leaf class).
      //
      // PARAMETER:
      //
      // RETURNVALUE:
      // -
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      amt_tclServiceData ();

      //## Operation: amt_tclServiceData%3B01297303A3
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Copy-constructor for message - does NO ALLOCATION of
      // message (no leaf class).
      //
      // PARAMETER:
      // const amt_tclServiceData  &roRight (-> I)
      // Reference to message which will be copied.
      //
      // RETURNVALUE:
      // -
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      amt_tclServiceData (const amt_tclServiceData& roRight);


    //## Other Operations (specified)
      //## Operation: vInitServiceData%3A14E072012C
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Initialisation of all fields in the service data messge.
      //
      // PARAMETER:
      // tU16   u16Source
      // contents of source field (->I)
      // tU16   u16Target
      // contents of target field (->I)
      // tU8     u8StreamType
      // contents of stream type field (->I)
      // tU8     u8StreamCounter
      // contents of stream counter field (->I)
      // tU16   u16RegisterID
      // contents of register-ID field (->I)
      // tU16   u16CmdCounter
      // contents of command counter field (->I)
      // tU16   u16ServiceID
      // contents of service-ID field (->I)
      // tU16   u16Function
      // contents of function-ID field (->I)
      // tU8     u8OpCode
      // contents of opcode field (->I)
      // tU32   u32ClientSpecificField
      // contents of client specific field field (->I)
      //
      // RETURNVALUE:
      // tVoid
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      tVoid vInitServiceData (tU16 u16Source, tU16 u16Target, tU8 u8StreamType, tU8 u8StreamCounter, tU16 u16RegisterID, tU16 u16CmdCounter, tU16 u16ServiceID, tU16 u16FunctionID, tU8 u8OpCode, tU8 u8ACT = 0, tU16 u16SourceSub = AMT_C_U16_DEFAULT_NULL, tU16 u16TargetSub = AMT_C_U16_DEFAULT_NULL, tU32 u32Timestamp = AMT_C_U32_DEFAULT_NULL);

      //## Operation: u8GetACT%3B24825B008A
      tU8 u8GetACT () const;

      //## Operation: vSetACT%3B24826A017C
      tVoid vSetACT (tU8 u8NewValue);

      //## Operation: vSetStreamType%3A14E0FE032C
      tVoid vSetStreamType (tU8 u8StreamType);

      //## Operation: u8GetStreamType%3A14E12900CB
      tU8 u8GetStreamType () const;

      //## Operation: vSetStreamCounter%3A14E1300021
      tVoid vSetStreamCounter (tU8 u8StreamCounter);

      //## Operation: u8GetStreamCounter%3A14E7E30334
      tU8 u8GetStreamCounter () const;

      //## Operation: vSetRegisterID%3A14E7F30189
      tVoid vSetRegisterID (tU16 u16RegisterID);

      //## Operation: u16GetRegisterID%3A14E7FC0132
      tU16 u16GetRegisterID () const;

      //## Operation: vSetCmdCounter%3A14E806008C
      tVoid vSetCmdCounter (tU16 u16CmdCounter);

      //## Operation: u16GetCmdCounter%3A153D8D032E
      tU16 u16GetCmdCounter () const;

      //## Operation: vSetServiceID%3A7FC6CE01BC
      tVoid vSetServiceID (tU16 u16ServiceID);

      //## Operation: u16GetServiceID%3A7FC6D40391
      tU16 u16GetServiceID () const;

      //## Operation: vSetFunctionID%3A7FC6ED00DA
      tVoid vSetFunctionID (tU16 u16FunctionID);

      //## Operation: u16GetFunctionID%3A7FC70101C9
      tU16 u16GetFunctionID () const;

      //## Operation: vSetOpCode%3A7FC72503CA
      tVoid vSetOpCode (tU8 u8OpCode);

      //## Operation: u8GetOpCode%3A7FC72B02EC
      tU8 u8GetOpCode () const;

      //## Operation: operator=%3AB86C0303A1
      amt_tclServiceData& operator = (const amt_tclServiceData& roRight);

      //## Operation: operator==%3AB86C2F015F
      tBool operator == (const amt_tclServiceData& roRight) const; //lint !e1511: Member hides non-virtual member

      //## Operation: operator!=%3AB86C540311
      tBool operator != (const amt_tclServiceData& roRight) const; //lint !e1511: Member hides non-virtual member

      //## Operation: vServiceDataSetup%3AB88498010B
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Initialise ServiceData message; add size of this message
      // class to "u32DynMsgSize".
      //
      // PARAMETER:
      // -
      //
      // RETURNVALUE:
      // tVoid
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      tVoid vServiceDataSetup ();

      //## Operation: poClone%3B0247770077
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // see amt_tclMappableMessage.
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      virtual amt_tclMappableMessage* poClone () const;

      //## Operation: bIsClientMessage%3C51388A02CC
      tBool bIsClientMessage () const;

      //## Operation: bIsServerMessage%3C5138E0029D
      tBool bIsServerMessage () const;

    // Additional Public Declarations
      //## begin amt_tclServiceData%3A0BF3B20266.public preserve=yes
      //## end amt_tclServiceData%3A0BF3B20266.public

};

//## begin amt_tclServiceData%3A0BF3B20266.postscript preserve=yes
//## end amt_tclServiceData%3A0BF3B20266.postscript

//## begin amt_tclServiceStatus%3A2E3AD9029B.preface preserve=yes
//## end amt_tclServiceStatus%3A2E3AD9029B.preface

//## Class: amt_tclServiceStatus%3A2E3AD9029B
// *********************************************************
// ***********************
// DESCRIPTION:
//
// This is the representation of a ServiceStatus message.
// All get and set methods are undocumentated due to
// simplicity.
//
// History:
//
// 19.03.01 EFG32-Bruns
// InitialVersion
// 19.09.01 EFG32-Bruns
// Updated to ipc_def.h and using static offsets for all
// messages
//
// *********************************************************
// ***********************
//## Category: amt::amt_CCAMessages%3A0BF8D802EE
//## Subsystem: Amt::Include%3A7E97380302
//## Persistence: Transient
//## Cardinality/Multiplicity: n



class amt_tclServiceStatus : public amt_tclBaseMessage  //## Inherits: <unnamed>%3A3E0E36038E
{
  //## begin amt_tclServiceStatus%3A2E3AD9029B.initialDeclarations preserve=yes
   #define AMT_C_U32_SERVICESTATUS_SERVICEID          (tU32)20
   #define AMT_C_U32_SERVICESTATUS_REGISTERID         (tU32)22
   #define AMT_C_U32_SERVICESTATUS_SERVICESTATE       (tU32)24
   #define AMT_C_U32_SERVICESTATUS_RESERVED1          (tU32)25

   #define AMT_C_U32_SERVICESTATUS_RELMSGSIZE         (tU32)6
  //## end amt_tclServiceStatus%3A2E3AD9029B.initialDeclarations

  public:
    //## Constructors (specified)
      //## Operation: amt_tclServiceStatus%3A7EC5B20260
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Constructor - does ALLOCATION of message.
      //
      // PARAMETER:
      // tU16   u16Source (->I)
      // The value of the source field
      // tU16   u16Target (->I)
      // The value of the target field
      // tU16   u16RegisterID (->I)
      // The value of the register-ID field
      // tU8 ServiceState
      // The value of the service state field
      // tU16 u16SourceSub
      // The value of the source sub id field (->I)
      // tU16 u16TargetSub
      // The value of the target sub id field (->I)
      // tU32 u32Timestamp
      // The value of the timestamp field (->I)
      //
      // RETURNVALUE:
      // -
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      amt_tclServiceStatus (tU16 u16Source, tU16 u16Target, tU16 u16ServiceID, tU16 u16RegisterID, tU8 u8ServiceState, tU16 u16SourceSub = AMT_C_U16_DEFAULT_NULL, tU16 u16TargetSub = AMT_C_U16_DEFAULT_NULL, tU32 u32Timestamp = AMT_C_U32_DEFAULT_NULL);

      //## Operation: amt_tclServiceStatus%3A7EC5EF0041
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Constructor for message reception - does NO ALLOCATION
      // of message. Transforms base message to this message.
      //
      // PARAMETER:
      // amt_tclBaseMessage   *poBaseMessage
      // Pointer to received base message
      //
      // RETURNVALUE:
      // -
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      amt_tclServiceStatus (amt_tclBaseMessage* poBaseMessage);
      amt_tclServiceStatus (const amt_tclBaseMessage* copoBaseMessage);
      amt_tclServiceStatus (const amt_tclBaseMessage& corfoBaseMessage);

      //## Operation: amt_tclServiceStatus%3ABA0120018A
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Default constructor - does ALLOCATION of message.
      //
      // PARAMETER:
      //
      // RETURNVALUE:
      // -
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      amt_tclServiceStatus ();


    //## Other Operations (specified)
      //## Operation: u16GetServiceID%3A7EC49601F3
      tU16 u16GetServiceID () const;

      //## Operation: vSetServiceID%3A7EC4A901F1
      tVoid vSetServiceID (tU16 nServiceID);

      //## Operation: u16GetRegisterID%3A7EC4B201B7
      tU16 u16GetRegisterID () const;

      //## Operation: vSetRegisterID%3A7EC4BA01D7
      tVoid vSetRegisterID (tU16 nRegisterID);

      //## Operation: u8GetServiceState%3A7EC4EB0368
      tU8 u8GetServiceState () const;

      //## Operation: vSetServiceState%3A7EC4F3039C
      tVoid vSetServiceState (tU8 nServiceState);

      //## Operation: vSetReservedServStat1%3AB87E42031B
      tVoid vSetReservedServStat1 (tU8 u8NewReserved);

      //## Operation: u8GetReservedServStat1%3AB87F1F00E8
      tU8 u8GetReservedServStat1 () const;

      //## Operation: operator=%3AB87F3800BC
      amt_tclServiceStatus& operator = (const amt_tclServiceStatus& roRight);

      //## Operation: operator==%3AB87F5F0130
      tBool operator == (const amt_tclServiceStatus& roRight) const; //lint !e1511: Member hides non-virtual member

      //## Operation: operator!=%3AB87F6A00E6
      tBool operator != (const amt_tclServiceStatus& roRight) const; //lint !e1511: Member hides non-virtual member

      //## Operation: vServiceStatusSetup%3AB884D50145
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Initialise ServiceStatus message; add size of this
      // message class to "u32DynMsgSize".
      //
      // PARAMETER:
      // -
      //
      // RETURNVALUE:
      // tVoid
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      tVoid vServiceStatusSetup ();

      //## Operation: poClone%3B0241200203
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // see amt_tclMappableMessage.
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      virtual amt_tclMappableMessage* poClone () const;

    // Additional Public Declarations
      //## begin amt_tclServiceStatus%3A2E3AD9029B.public preserve=yes
      //## end amt_tclServiceStatus%3A2E3AD9029B.public

  protected:
    //## Constructors (specified)
      //## Operation: amt_tclServiceStatus%3ABB39AF0061
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Copy-constructor for message - does ALLOCATION of
      // message.
      //
      // PARAMETER:
      // const amt_tclServiceStatus    &roRight (-> I)
      // Reference to message which will be copied.
      //
      // RETURNVALUE:
      // -
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      amt_tclServiceStatus (const amt_tclServiceStatus& roRight);

    // Additional Protected Declarations
      //## begin amt_tclServiceStatus%3A2E3AD9029B.protected preserve=yes
      //## end amt_tclServiceStatus%3A2E3AD9029B.protected

};

//## begin amt_tclServiceStatus%3A2E3AD9029B.postscript preserve=yes
//## end amt_tclServiceStatus%3A2E3AD9029B.postscript

//## begin amt_tclServiceRegisterConf%3A2E3A2D01B7.preface preserve=yes
//## end amt_tclServiceRegisterConf%3A2E3A2D01B7.preface

//## Class: amt_tclServiceRegisterConf%3A2E3A2D01B7
// *********************************************************
// ***********************
// DESCRIPTION:
//
// This is the representation of a ServiceRegister
// Confirmation message. All get and set methods are
// undocumentated due to simplicity.
//
// History:
//
// 19.03.01 EFG32-Bruns
// InitialVersion
// 19.09.01 EFG32-Bruns
// Updated to ipc_def.h and using static offsets for all
// messages
//
// *********************************************************
// ***********************
//## Category: amt::amt_CCAMessages%3A0BF8D802EE
//## Subsystem: Amt::Include%3A7E97380302
//## Persistence: Transient
//## Cardinality/Multiplicity: n



class amt_tclServiceRegisterConf : public amt_tclBaseMessage  //## Inherits: <unnamed>%3A3E0CD7011D
{
  //## begin amt_tclServiceRegisterConf%3A2E3A2D01B7.initialDeclarations preserve=yes
   #define AMT_C_U32_SVCREGCONF_SERVICEID            (tU32)20
   #define AMT_C_U32_SVCREGCONF_REGISTERID           (tU32)22
   #define AMT_C_U32_SVCREGCONF_REGISTERSTATE        (tU32)24
   #define AMT_C_U32_SVCREGCONF_RES1                 (tU32)25
   #define AMT_C_U32_SVCREGCONF_SERVICEMAJORVERSION  (tU32)26
   #define AMT_C_U32_SVCREGCONF_SERVICEMINORVERSION  (tU32)28
   #define AMT_C_U32_SVCREGCONF_SERVICEPATCHVERSION  (tU32)30

   #define AMT_C_U32_SVCREGISTERCONF_RELMSGSIZE (tU32)12
  //## end amt_tclServiceRegisterConf%3A2E3A2D01B7.initialDeclarations

  public:
    //## Constructors (specified)
      //## Operation: amt_tclServiceRegisterConf%3A71B49D03D6
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Constructor - does ALLOCATION of message.
      //
      // PARAMETER:
      // tU16   u16Source (->I)
      // The value of the source field
      // tU16   u16Target (->I)
      // The value of the target field
      // tU16   u16ServiceID (->I)
      // The value of the service-ID field
      // tU16   u16RegisterID (->I)
      // The value of the register-ID field
      // tU8 RegisterState
      // The value of the service-ID field
      // tU16   u16MajorVersion (->I)
      // The value of the major version field
      // tU16   u16MinorVersion (->I)
      // The value of the minor version field
      // tU16   u16PatchVersion (->I)
      // The value of the patch version field
      // tU16   u16SourceSub
      // The value of the source sub id field
      // tU16   u16TargeSub
      // The value of the target sub id field
      // tU32   u32Timestamp
      // The value of the timestamp field
      //
      // RETURNVALUE:
      // -
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // 28.01.02 PDP3-Andres
      // added parameters u16SourceSub, u16TargetSub, u32Timestamp
      // due to message header extention
      // *********************************************************
      // ***********************
      amt_tclServiceRegisterConf (tU16 u16Source, tU16 u16Target, tU16 u16ServiceID, tU16 u16RegisterID, tU8 u8RegisterState, tU16 u16MajorVersion, tU16 u16MinorVersion, tU16 u16PatchVersion, tU16 u16SourceSub = AMT_C_U16_DEFAULT_NULL, tU16 u16TargetSub = AMT_C_U16_DEFAULT_NULL, tU32 u32Timestamp = AMT_C_U32_DEFAULT_NULL);

      //## Operation: amt_tclServiceRegisterConf%3A71B52F000A
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Constructor for message reception - does NO ALLOCATION
      // of message. Transforms base message to this message.
      //
      // PARAMETER:
      // amt_tclBaseMessage   *poBaseMessage
      // Pointer to received base message
      //
      // RETURNVALUE:
      // -
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      amt_tclServiceRegisterConf (amt_tclBaseMessage* poBaseMessage);
      amt_tclServiceRegisterConf (const amt_tclBaseMessage* copoBaseMessage);
      amt_tclServiceRegisterConf (const amt_tclBaseMessage& corfoBaseMessage);

      //## Operation: amt_tclServiceRegisterConf%3ABA00D100FA
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Default constructor - does ALLOCATION of message.
      //
      // PARAMETER:
      //
      // RETURNVALUE:
      // -
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      amt_tclServiceRegisterConf ();


    //## Other Operations (specified)
      //## Operation: u16GetServiceID%3A71B56A02C2
      tU16 u16GetServiceID () const;

      //## Operation: u16GetRegisterID%3A71B570032F
      tU16 u16GetRegisterID () const;

      //## Operation: u8GetRegisterState%3A71B57501C3
      tU8 u8GetRegisterState () const;

      //## Operation: vSetRegisterID%3A71B5860290
      tVoid vSetRegisterID (tU16 u16RegisterID);

      //## Operation: vSetServiceID%3A71B58B021F
      tVoid vSetServiceID (tU16 u16ServiceID);

      //## Operation: vSetRegisterState%3A71B59002A9
      tVoid vSetRegisterState (tU8 u8RegisterState);

      //## Operation: operator=%3AB873270092
      amt_tclServiceRegisterConf& operator = (const amt_tclServiceRegisterConf& roRight);

      //## Operation: operator==%3AB8734D030E
      tBool operator == (const amt_tclServiceRegisterConf& roRight) const; //lint !e1511: Member hides non-virtual member

      //## Operation: operator!=%3AB8736901E2
      tBool operator != (const amt_tclServiceRegisterConf& roRight) const; //lint !e1511: Member hides non-virtual member

      //## Operation: vSetReservedServRegConf1%3AB87647002F
      tVoid vSetReservedServRegConf1 (tU8 u8NewReserved);

      //## Operation: u8GetReservedServRegConf1%3AB8767800F7
      tU8 u8GetReservedServRegConf1 () const;

      //## Operation: vServiceRegisterConfSetup%3AB8848A00B1
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Initialise ServiceRegisterConf message; add size of this
      // message class to "u32DynMsgSize".
      //
      // PARAMETER:
      // -
      //
      // RETURNVALUE:
      // tVoid
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      tVoid vServiceRegisterConfSetup ();

      //## Operation: poClone%3B02410300C1
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // see amt_tclMappableMessage.
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      virtual amt_tclMappableMessage* poClone () const;

      //## Operation: u16GetServiceMajorVersion%3C513103025D
      tU16 u16GetServiceMajorVersion () const;

      //## Operation: u16GetServiceMinorVersion%3C51314B027E
      tU16 u16GetServiceMinorVersion () const;

      //## Operation: vSetServiceMajorVersion%3C513166027D
      tVoid vSetServiceMajorVersion (tU16 u16NewServiceMajorVersion);

      //## Operation: vSetServiceMinorVersion%3C5131A001CC
      tVoid vSetServiceMinorVersion (tU16 u16NewServiceMinorVersion);

      //## Operation: vSetServicePatchVersion%3C5131A1030E
      tVoid vSetServicePatchVersion (tU16 u16NewServicePatchVersion);

      //## Operation: u16GetServicePatchVersion%3C51326E034F
      tU16 u16GetServicePatchVersion () const;

    // Additional Public Declarations
      //## begin amt_tclServiceRegisterConf%3A2E3A2D01B7.public preserve=yes
      //## end amt_tclServiceRegisterConf%3A2E3A2D01B7.public

  protected:
    //## Constructors (specified)
      //## Operation: amt_tclServiceRegisterConf%3ABB37A503BE
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Copy-constructor for message - does ALLOCATION of
      // message.
      //
      // PARAMETER:
      // const amt_tclServiceRegisterConf  &roRight (-> I)
      // Reference to message which will be copied.
      //
      // RETURNVALUE:
      // -
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      amt_tclServiceRegisterConf (const amt_tclServiceRegisterConf& roRight);

    // Additional Protected Declarations
      //## begin amt_tclServiceRegisterConf%3A2E3A2D01B7.protected preserve=yes
      //## end amt_tclServiceRegisterConf%3A2E3A2D01B7.protected

};

//## begin amt_tclServiceRegisterConf%3A2E3A2D01B7.postscript preserve=yes
//## end amt_tclServiceRegisterConf%3A2E3A2D01B7.postscript

//## begin amt_tclServiceUnregister%3A0BF35E00D5.preface preserve=yes
//## end amt_tclServiceUnregister%3A0BF35E00D5.preface

//## Class: amt_tclServiceUnregister%3A0BF35E00D5
// *********************************************************
// ***********************
// DESCRIPTION:
//
// This is the representation of a ServiceUnregister
// message. All get and set methods are undocumentated due
// to  simplicity.
//
// History:
//
// 19.03.01 EFG32-Bruns
// InitialVersion
// 19.09.01 EFG32-Bruns
// Updated to ipc_def.h and using static offsets for all
// messages
//
// *********************************************************
// ***********************
//## Category: amt::amt_CCAMessages%3A0BF8D802EE
//## Subsystem: Amt::Include%3A7E97380302
//## Persistence: Transient
//## Cardinality/Multiplicity: n



class amt_tclServiceUnregister : public amt_tclBaseMessage  //## Inherits: <unnamed>%3A3E0C5700BE
{
  //## begin amt_tclServiceUnregister%3A0BF35E00D5.initialDeclarations preserve=yes
   #define AMT_C_U32_SVCUNREGISTER_SERVICEID      (tU32)20
   #define AMT_C_U32_SVCUNREGISTER_REGISTERID     (tU32)22

   #define AMT_C_U32_SVCUNREGISTER_RELMSGSIZE     (tU32)4
  //## end amt_tclServiceUnregister%3A0BF35E00D5.initialDeclarations

  public:
    //## Constructors (specified)
      //## Operation: amt_tclServiceUnregister%3A7196130348
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Constructor - does ALLOCATION of message.
      //
      // PARAMETER:
      // tU16   u16Source (->I)
      // The value of the source field
      // tU16   u16Target (->I)
      // The value of the target field
      // tU16   u16ServiceID (->I)
      // The value of the service-ID field
      // tU16   u16RegisterID (->I)
      // The value of the register-ID field
      // tU16   u16SourceSub(->I)
      // The value of the source sub ID field
      // tU16   u16TargetSub (->I)
      // The value of the target sub ID field
      // tU32   u32Timestamp (->I)
      // The value of the timestamp field
      //
      // RETURNVALUE:
      // -
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // 28.01.02 PDP3-Andres
      // added new parameters u16SourceSub, u16TargetSub,
      // u32Timestamp
      // *********************************************************
      // ***********************
      amt_tclServiceUnregister (tU16 u16Source, tU16 u16Target, tU16 u16ServiceID, tU16 u16RegisterID, tU16 u16SourceSub = AMT_C_U16_DEFAULT_NULL, tU16 u16TargetSub = AMT_C_U16_DEFAULT_NULL, tU32 u32Timestamp = AMT_C_U32_DEFAULT_NULL);

      //## Operation: amt_tclServiceUnregister%3A719694004A
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Constructor for message reception - does NO ALLOCATION
      // of message. Transforms base message to this message.
      //
      // PARAMETER:
      // amt_tclBaseMessage   *poBaseMessage
      // Pointer to received base message
      //
      // RETURNVALUE:
      // -
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      amt_tclServiceUnregister (amt_tclBaseMessage* poBaseMessage);
      amt_tclServiceUnregister (const amt_tclBaseMessage* copoBaseMessage);
      amt_tclServiceUnregister (const amt_tclBaseMessage& corfoBaseMessage);

      //## Operation: amt_tclServiceUnregister%3ABA0061033E
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Default constructor - does ALLOCATION of message.
      //
      // PARAMETER:
      //
      // RETURNVALUE:
      // -
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      amt_tclServiceUnregister ();


    //## Other Operations (specified)
      //## Operation: u16GetServiceID%3A7196C90353
      tU16 u16GetServiceID () const;

      //## Operation: vSetServiceID%3A7196D602C6
      tVoid vSetServiceID (tU16 u16NewServiceID);

      //## Operation: u16GetRegisterID%3A7196D80341
      tU16 u16GetRegisterID () const;

      //## Operation: vSetRegisterID%3A7196EA009E
      tVoid vSetRegisterID (tU16 u16NewRegisterID);

      //## Operation: operator==%3AB8631E0086
      tBool operator == (const amt_tclServiceUnregister& roRight) const; //lint !e1511: Member hides non-virtual member

      //## Operation: operator!=%3AB864DD036E
      tBool operator != (const amt_tclServiceUnregister& roRight) const; //lint !e1511: Member hides non-virtual member

      //## Operation: operator=%3AB864ED00F0
      amt_tclServiceUnregister& operator = (const amt_tclServiceUnregister& roRight);

      //## Operation: vServiceUnregisterSetup%3AB8845A0292
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Initialise ServiceUnregister message; add size of this
      // message class to "u32DynMsgSize".
      //
      // PARAMETER:
      // -
      //
      // RETURNVALUE:
      // tVoid
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      tVoid vServiceUnregisterSetup ();

      //## Operation: poClone%3B0240FB00A2
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // see amt_tclMappableMessage.
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      virtual amt_tclMappableMessage* poClone () const;

    // Additional Public Declarations
      //## begin amt_tclServiceUnregister%3A0BF35E00D5.public preserve=yes
      //## end amt_tclServiceUnregister%3A0BF35E00D5.public

  protected:
    //## Constructors (specified)
      //## Operation: amt_tclServiceUnregister%3ABB26B701B3
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Copy-constructor for message - does ALLOCATION of
      // message.
      //
      // PARAMETER:
      // const amt_tclServiceUnregister  &roRight (-> I)
      // Reference to message which will be copied.
      //
      // RETURNVALUE:
      // -
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      amt_tclServiceUnregister (const amt_tclServiceUnregister& roRight);

    // Additional Protected Declarations
      //## begin amt_tclServiceUnregister%3A0BF35E00D5.protected preserve=yes
      //## end amt_tclServiceUnregister%3A0BF35E00D5.protected

};

//## begin amt_tclServiceUnregister%3A0BF35E00D5.postscript preserve=yes
//## end amt_tclServiceUnregister%3A0BF35E00D5.postscript

//## begin amt_tclServiceDataError%3AB8C1E80147.preface preserve=yes
//## end amt_tclServiceDataError%3AB8C1E80147.preface

//## Class: amt_tclServiceDataError%3AB8C1E80147
// *********************************************************
// ***********************
// DESCRIPTION:
//
// This is the representation of a ServiceDataError
// message. An error message is send as reply on any failed
// ServiceData message. This class is a template for
// realising own error messages.  All get and set methods
// are undocumentated due to  simplicity.
//
// History:
//
// 19.03.01 EFG32-Bruns
// InitialVersion
// 19.09.01 EFG32-Bruns
// Updated to ipc_def.h and using static offsets for all
// messages
//
// *********************************************************
// ***********************
//## Category: amt::amt_CCAMessages%3A0BF8D802EE
//## Subsystem: Amt::Include%3A7E97380302
//## Persistence: Transient
//## Cardinality/Multiplicity: n



class amt_tclServiceDataError : public amt_tclServiceData  //## Inherits: <unnamed>%3AB8C31C01F4
{
  //## begin amt_tclServiceDataError%3AB8C1E80147.initialDeclarations preserve=yes
  //## end amt_tclServiceDataError%3AB8C1E80147.initialDeclarations

  public:
    //## Constructors (specified)
      //## Operation: amt_tclServiceDataError%3AB8C34301A0
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Constructor for message reception - does NO ALLOCATION
      // of message. Transforms base message to this message.
      //
      // PARAMETER:
      // amt_tclServiceDataError*   poServiceData
      // Pointer to received ServiceData message
      //
      // RETURNVALUE:
      // -
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      amt_tclServiceDataError (amt_tclServiceData* poServiceData);
      amt_tclServiceDataError (const amt_tclServiceData* copoBaseMessage);
      amt_tclServiceDataError (const amt_tclServiceData& corfoBaseMessage);

      //## Operation: amt_tclServiceDataError%3AB8C34C031F
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Constructor - does ALLOCATION of message and copies from
      // parameters
      //
      // PARAMETER:
      // const amt_tclServiceDataError    roSourceServiceData
      // The origin service data message on which a respond error
      // message is set up
      // tU16    u16ErrorCode
      // The error code which to set
      //
      // RETURNVALUE:
      // -
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      amt_tclServiceDataError (const amt_tclServiceData& roSourceServiceData, tU16 u16ErrorData);

      //## Operation: amt_tclServiceDataError%3B163F750173
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Default constructor - does ALLOCATION of message.
      //
      // PARAMETER:
      //
      // RETURNVALUE:
      // -
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      amt_tclServiceDataError ();


    //## Other Operations (specified)
      //## Operation: operator=%3AB8C44902D3
      amt_tclServiceDataError& operator = (const amt_tclServiceDataError& roRight);

      //## Operation: operator==%3AB8C467010A
      tBool operator == (const amt_tclServiceDataError& roRight) const; //lint !e1511: Member hides non-virtual member

      //## Operation: operator!=%3AB8C46F00E3
      tBool operator != (const amt_tclServiceDataError& roRight) const; //lint !e1511: Member hides non-virtual member

      //## Operation: u16GetErrorData%3AC3281D0280
      tU16 u16GetErrorData () const;

      //## Operation: vSetErrorData%3AC3282B03B7
      tVoid vSetErrorData (tU16 u16NewErrorData);

      //## Operation: vServiceDataErrorSetup%3AC328900344
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Initialise ServiceDataError message; add size of this
      // message class to "u32DynMsgSize".
      //
      // PARAMETER:
      // -
      //
      // RETURNVALUE:
      // tVoid
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      tVoid vServiceDataErrorSetup ();

      //## Operation: poClone%3B02411C03CA
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // see amt_tclMappableMessage.
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      virtual amt_tclMappableMessage* poClone () const;

    // Additional Public Declarations
      //## begin amt_tclServiceDataError%3AB8C1E80147.public preserve=yes
      //## end amt_tclServiceDataError%3AB8C1E80147.public

  protected:
    //## Constructors (specified)
      //## Operation: amt_tclServiceDataError%3AC328DE001B
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Copy-constructor for message - does ALLOCATION of
      // message.
      //
      // PARAMETER:
      // const amt_tclServiceDataError   &roRight (-> I)
      // Reference to message which will be copied.
      //
      // RETURNVALUE:
      // -
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      amt_tclServiceDataError (const amt_tclServiceDataError& roRight);

    // Additional Protected Declarations
      //## begin amt_tclServiceDataError%3AB8C1E80147.protected preserve=yes
      //## end amt_tclServiceDataError%3AB8C1E80147.protected

  private:
    // Data Members for Class Attributes

      //## Attribute: oErrorData%3AC3280903B8
      //## begin amt_tclServiceDataError::oErrorData%3AC3280903B8.attr preserve=no  private: static amt_tclMU16 {UA} 
      static amt_tclMU16 oErrorData;
      //## end amt_tclServiceDataError::oErrorData%3AC3280903B8.attr

    // Additional Private Declarations
      //## begin amt_tclServiceDataError%3AB8C1E80147.private preserve=yes
      //## end amt_tclServiceDataError%3AB8C1E80147.private

};

//## begin amt_tclServiceDataError%3AB8C1E80147.postscript preserve=yes

//-----------------------------------------------------------------------------
// amt_bInit static s
//
// This function is used to create an object of every message type.
//-----------------------------------------------------------------------------
tBool amt_bInitStatics(tVoid);

//## end amt_tclServiceDataError%3AB8C1E80147.postscript

// Class amt_tclBaseMessage 


//## Other Operations (inline)
inline tU8 amt_tclBaseMessage::u8GetType () const
{
  //## begin amt_tclBaseMessage::u8GetType%3A41D7F401AA.body preserve=yes
   return u8GetValue(AMT_C_U32_BASEMSG_TYPE);
  //## end amt_tclBaseMessage::u8GetType%3A41D7F401AA.body
}

inline tU8 amt_tclBaseMessage::u8GetContext () const
{
  //## begin amt_tclBaseMessage::u8GetContext%3A41DD9200CB.body preserve=yes
   return u8GetValue(AMT_C_U32_BASEMSG_CONTEXT);
  //## end amt_tclBaseMessage::u8GetContext%3A41DD9200CB.body
}

inline tU16 amt_tclBaseMessage::u16GetVersion () const
{
  //## begin amt_tclBaseMessage::u16GetVersion%3A41DDA40031.body preserve=yes
   return u16GetValue(AMT_C_U32_BASEMSG_VERSION);
  //## end amt_tclBaseMessage::u16GetVersion%3A41DDA40031.body
}

inline tU32 amt_tclBaseMessage::u32GetSize () const
{
  //## begin amt_tclBaseMessage::u32GetSize%3A41DDB1002F.body preserve=yes
   return u32GetValue(AMT_C_U32_BASEMSG_SIZE);
  //## end amt_tclBaseMessage::u32GetSize%3A41DDB1002F.body
}

inline tU16 amt_tclBaseMessage::u16GetSourceAppID () const
{
  //## begin amt_tclBaseMessage::u16GetSourceAppID%3A41DDBD02AE.body preserve=yes
    return u16GetValue(AMT_C_U32_BASEMSG_SOURCEAPPID);
  //## end amt_tclBaseMessage::u16GetSourceAppID%3A41DDBD02AE.body
}

inline tU16 amt_tclBaseMessage::u16GetTargetAppID () const
{
  //## begin amt_tclBaseMessage::u16GetTargetAppID%3A41DDC8023B.body preserve=yes
    return u16GetValue(AMT_C_U32_BASEMSG_TARGETAPPID);
  //## end amt_tclBaseMessage::u16GetTargetAppID%3A41DDC8023B.body
}

inline tVoid amt_tclBaseMessage::vSetType (tU8 u8NewType)
{
  //## begin amt_tclBaseMessage::vSetType%3A41DDDE02F1.body preserve=yes
   vSetValueU8(AMT_C_U32_BASEMSG_TYPE, u8NewType);
  //## end amt_tclBaseMessage::vSetType%3A41DDDE02F1.body
}

inline tVoid amt_tclBaseMessage::vSetContext (tU8 u8NewContext)
{
  //## begin amt_tclBaseMessage::vSetContext%3A41DE01000C.body preserve=yes
   vSetValueU8(AMT_C_U32_BASEMSG_CONTEXT, u8NewContext);
  //## end amt_tclBaseMessage::vSetContext%3A41DE01000C.body
}

inline tVoid amt_tclBaseMessage::vSetVersion (tU16 u16NewVersion)
{
  //## begin amt_tclBaseMessage::vSetVersion%3A41DE1E0018.body preserve=yes
   vSetValueU16(AMT_C_U32_BASEMSG_VERSION, u16NewVersion);
  //## end amt_tclBaseMessage::vSetVersion%3A41DE1E0018.body
}

inline tVoid amt_tclBaseMessage::vSetSize (tU32 u32NewSize)
{
  //## begin amt_tclBaseMessage::vSetSize%3A41DE3402F5.body preserve=yes
   vSetValueU32(AMT_C_U32_BASEMSG_SIZE, u32NewSize);
  //## end amt_tclBaseMessage::vSetSize%3A41DE3402F5.body
}

inline tVoid amt_tclBaseMessage::vSetSourceAppID (tU16 u16NewSourceAppID)
{
  //## begin amt_tclBaseMessage::vSetSourceAppID%3A41DE4C03AE.body preserve=yes
   vSetValueU16(AMT_C_U32_BASEMSG_SOURCEAPPID, u16NewSourceAppID);
  //## end amt_tclBaseMessage::vSetSourceAppID%3A41DE4C03AE.body
}

inline tVoid amt_tclBaseMessage::vSetTargetAppID (tU16 u16NewTargetAppID)
{
  //## begin amt_tclBaseMessage::vSetTargetAppID%3A41DE6B009B.body preserve=yes
   vSetValueU16(AMT_C_U32_BASEMSG_TARGETAPPID, u16NewTargetAppID);
  //## end amt_tclBaseMessage::vSetTargetAppID%3A41DE6B009B.body
}

inline tU8 amt_tclBaseMessage::u8GetValue (tU32 u32Offset) const
{
  //## begin amt_tclBaseMessage::u8GetValue%3B7939860095.body preserve=yes
   tU8* pu8MemBase = pu8GetSharedMemBase();

   if (pu8MemBase != NULL)
      return *((tU8*)(pu8MemBase + u32Offset));
   else
      return 0;
  //## end amt_tclBaseMessage::u8GetValue%3B7939860095.body
}

inline tU16 amt_tclBaseMessage::u16GetValue (tU32 u32Offset) const
{
  //## begin amt_tclBaseMessage::u16GetValue%3B79399B01E9.body preserve=yes
   tU8* pu8MemBase = pu8GetSharedMemBase();

   if (pu8MemBase != NULL)
      return *((tU16*)(pu8MemBase + u32Offset)); //lint !e826: Suspicious pointer-to-pointer conversion (area too small)
   else
      return 0;
  //## end amt_tclBaseMessage::u16GetValue%3B79399B01E9.body
}

inline tU32 amt_tclBaseMessage::u32GetValue (tU32 u32Offset) const
{
  //## begin amt_tclBaseMessage::u32GetValue%3B7939A600AF.body preserve=yes
   tU8* pu8MemBase = pu8GetSharedMemBase();

   if (pu8MemBase != NULL)
      return *((tU32*)(pu8MemBase + u32Offset)); //lint !e826: Suspicious pointer-to-pointer conversion (area too small)
   else
      return 0;
  //## end amt_tclBaseMessage::u32GetValue%3B7939A600AF.body
}

inline tVoid amt_tclBaseMessage::vSetValueU32 (tU32 u32Offset, tU32 u32Value)
{
  //## begin amt_tclBaseMessage::vSetValueU32%3B793CD50006.body preserve=yes
   tU8* pu8MemBase = pu8GetSharedMemBase();

   if (pu8MemBase != NULL)
      *((tU32*)(pu8MemBase + u32Offset)) = u32Value; //lint !e826: Suspicious pointer-to-pointer conversion
  //## end amt_tclBaseMessage::vSetValueU32%3B793CD50006.body
} //lint !e1762: Member function could be made const --> member indirectly changed

inline tVoid amt_tclBaseMessage::vSetValueU16 (tU32 u32Offset, tU16 u16Value)
{
  //## begin amt_tclBaseMessage::vSetValueU16%3B793D2C011A.body preserve=yes
   tU8* pu8MemBase = pu8GetSharedMemBase();

   if (pu8MemBase != NULL)
      *((tU16*)(pu8MemBase + u32Offset)) = u16Value; //lint !e826: Suspicious pointer-to-pointer conversion
  //## end amt_tclBaseMessage::vSetValueU16%3B793D2C011A.body
} //lint !e1762: Member function could be made const --> member indirectly changed

inline tVoid amt_tclBaseMessage::vSetValueU8 (tU32 u32Offset, tU8 u8Value)
{
  //## begin amt_tclBaseMessage::vSetValueU8%3B793D470368.body preserve=yes
   tU8* pu8MemBase = pu8GetSharedMemBase();

   if (pu8MemBase != NULL)
      *((tU8*)(pu8MemBase + u32Offset)) = u8Value;
  //## end amt_tclBaseMessage::vSetValueU8%3B793D470368.body
} //lint !e1762: Member function could be made const --> member indirectly changed

inline tVoid amt_tclBaseMessage::vSetStreamU8(tU32 u32Offset, tU8 const * pu8Data, tU32 u32DataSize, tU32 u32MaxDataSize)
{
  tU8* pu8MemBase = pu8GetSharedMemBase();

  if (pu8MemBase != NULL)
  {
    OSAL_pvMemorySet((pu8MemBase + u32Offset), 0x00, u32MaxDataSize); //lint !e522: Expected void type, assignment, increment or decrement

    if ((pu8Data != NULL) && (u32DataSize > 0))
    {
      if (u32DataSize <= u32MaxDataSize)
      {
        OSAL_pvMemoryCopy((pu8MemBase + u32Offset), pu8Data, u32DataSize);
      }
      else
      {
        amt_vTraceOutString(TR_LEVEL_FATAL, 
                            "amt_tclBaseMessage::vSetStreamU8() : Passed u32DataSize = %d exceeds limit of %d", 
                            u32DataSize, 
                            u32MaxDataSize);
      }
    }
  }
}

inline tU8* amt_tclBaseMessage::pu8GetStreamU8(tU32 u32Offset) const
{
  tU8* pu8MemBase = pu8GetSharedMemBase();

  if (pu8MemBase != NULL)
  {
    return (pu8MemBase + u32Offset);
  }
  else
  {
    return NULL;
  }
}

inline tU16 amt_tclBaseMessage::u16GetSourceSubID () const
{
  //## begin amt_tclBaseMessage::u16GetSourceSubID%3C50096F03D2.body preserve=yes
   return u16GetValue(AMT_C_U32_BASEMSG_SOURCESUBID);
  //## end amt_tclBaseMessage::u16GetSourceSubID%3C50096F03D2.body
}

inline tU16 amt_tclBaseMessage::u16GetTargetSubID () const
{
  //## begin amt_tclBaseMessage::u16GetTargetSubID%3C500E0303C3.body preserve=yes
   return u16GetValue(AMT_C_U32_BASEMSG_TARGETSUBID);
  //## end amt_tclBaseMessage::u16GetTargetSubID%3C500E0303C3.body
}

inline tVoid amt_tclBaseMessage::vSetSourceSubID (tU16 u16NewSourceSubID)
{
  //## begin amt_tclBaseMessage::vSetSourceSubID%3C500E3F0261.body preserve=yes
   vSetValueU16(AMT_C_U32_BASEMSG_SOURCESUBID, u16NewSourceSubID);
  //## end amt_tclBaseMessage::vSetSourceSubID%3C500E3F0261.body
}

inline tVoid amt_tclBaseMessage::vSetTargetSubID (tU16 u16NewTargetSubID)
{
  //## begin amt_tclBaseMessage::vSetTargetSubID%3C500E7800E6.body preserve=yes
   vSetValueU16(AMT_C_U32_BASEMSG_TARGETSUBID, u16NewTargetSubID);
  //## end amt_tclBaseMessage::vSetTargetSubID%3C500E7800E6.body
}

inline tU32 amt_tclBaseMessage::u32GetTimestamp () const
{
  //## begin amt_tclBaseMessage::u32GetTimestamp%3C500EB100D4.body preserve=yes
   return u32GetValue(AMT_C_U32_BASEMSG_TIMESTAMP);
  //## end amt_tclBaseMessage::u32GetTimestamp%3C500EB100D4.body
}

inline tVoid amt_tclBaseMessage::vSetTimestamp (tU32 u32NewTimestamp)
{
  //## begin amt_tclBaseMessage::vSetTimestamp%3C500EDA02D2.body preserve=yes
   vSetValueU32(AMT_C_U32_BASEMSG_TIMESTAMP, u32NewTimestamp);
  //## end amt_tclBaseMessage::vSetTimestamp%3C500EDA02D2.body
}

// Class amt_tclPowerMessage 


//## Other Operations (inline)
inline tU16 amt_tclPowerMessage::u16GetPowerType () const
{
  //## begin amt_tclPowerMessage::u16GetPowerType%3A71722300C6.body preserve=yes
   return u16GetValue(AMT_C_U32_POWERMESSAGE_POWERTYPE);
  //## end amt_tclPowerMessage::u16GetPowerType%3A71722300C6.body
}

inline tVoid amt_tclPowerMessage::vSetPowerType (tU16 u16NewPowerType)
{
  //## begin amt_tclPowerMessage::vSetPowerType%3A71722B0294.body preserve=yes
   vSetValueU16(AMT_C_U32_POWERMESSAGE_POWERTYPE, u16NewPowerType);
  //## end amt_tclPowerMessage::vSetPowerType%3A71722B0294.body
}

inline tU32 amt_tclPowerMessage::u32GetPowerData1 () const
{
  //## begin amt_tclPowerMessage::u32GetPowerData1%3A717230031D.body preserve=yes
  return u32GetValue(AMT_C_U32_POWERMESSAGE_POWERDATA1);  
  //## end amt_tclPowerMessage::u32GetPowerData1%3A717230031D.body
}

inline tVoid amt_tclPowerMessage::vSetPowerData1 (tU32 u32NewPowerData)
{
  //## begin amt_tclPowerMessage::vSetPowerData1%3A717236018B.body preserve=yes
   vSetValueU32(AMT_C_U32_POWERMESSAGE_POWERDATA1, u32NewPowerData);
  //## end amt_tclPowerMessage::vSetPowerData1%3A717236018B.body
}

inline tU16 amt_tclPowerMessage::u16GetReservedPower () const
{
  //## begin amt_tclPowerMessage::u16GetReservedPower%3AD17BAA0198.body preserve=yes
  return u16GetValue(AMT_C_U32_POWERMESSAGE_RESERVED);  
  //## end amt_tclPowerMessage::u16GetReservedPower%3AD17BAA0198.body
}

inline tVoid amt_tclPowerMessage::vSetReservedPower (tU16 u16NewReserved)
{
  //## begin amt_tclPowerMessage::vSetReservedPower%3AD17BCC0115.body preserve=yes
   vSetValueU16(AMT_C_U32_POWERMESSAGE_RESERVED, u16NewReserved);
  //## end amt_tclPowerMessage::vSetReservedPower%3AD17BCC0115.body
}

inline tU32 amt_tclPowerMessage::u32GetPowerData2 () const
{
  //## begin amt_tclPowerMessage::u32GetPowerData2%3ADE90EB0194.body preserve=yes
  return u32GetValue(AMT_C_U32_POWERMESSAGE_POWERDATA2);
  //## end amt_tclPowerMessage::u32GetPowerData2%3ADE90EB0194.body
}

inline tVoid amt_tclPowerMessage::vSetPowerData2 (tU32 u32NewPowerData)
{
  //## begin amt_tclPowerMessage::vSetPowerData2%3ADE90F803E1.body preserve=yes
  vSetValueU32(AMT_C_U32_POWERMESSAGE_POWERDATA2, u32NewPowerData);
  //## end amt_tclPowerMessage::vSetPowerData2%3ADE90F803E1.body
}

// Class amt_tclServiceSupplierRegister 


//## Other Operations (inline)
inline tU16 amt_tclServiceSupplierRegister::u16GetServiceID () const
{
  //## begin amt_tclServiceSupplierRegister::u16GetServiceID%3A41EE7B00B2.body preserve=yes
   return u16GetValue(AMT_C_U32_SVCSREGISTER_SERVICEID);
  //## end amt_tclServiceSupplierRegister::u16GetServiceID%3A41EE7B00B2.body
}

inline tVoid amt_tclServiceSupplierRegister::vSetServiceID (tU16 u16NewServiceID)
{
  //## begin amt_tclServiceSupplierRegister::vSetServiceID%3A41EE98037A.body preserve=yes
   vSetValueU16(AMT_C_U32_SVCSREGISTER_SERVICEID, u16NewServiceID);
  //## end amt_tclServiceSupplierRegister::vSetServiceID%3A41EE98037A.body
}

// Class amt_tclServiceSupplierStatus 

//## Other Operations (inline)
inline tU16 amt_tclServiceSupplierStatus::u16GetServiceID () const
{
  //## begin amt_tclServiceSupplierStatus::u16GetServiceID%3A41EE7B00B2.body preserve=yes
   return u16GetValue(AMT_C_U32_SERVICESUPPLIERSTATUS_SERVICEID);
  //## end amt_tclServiceSupplierStatus::u16GetServiceID%3A41EE7B00B2.body
}

inline tVoid amt_tclServiceSupplierStatus::vSetServiceID (tU16 u16NewServiceID)
{
  //## begin amt_tclServiceSupplierStatus::vSetServiceID%3A41EE98037A.body preserve=yes
   vSetValueU16(AMT_C_U32_SERVICESUPPLIERSTATUS_SERVICEID, u16NewServiceID);
  //## end amt_tclServiceSupplierStatus::vSetServiceID%3A41EE98037A.body
}

inline tU16 amt_tclServiceSupplierStatus::u16GetAppID () const
{
  //## begin amt_tclServiceSupplierStatus::u16GetAppID%3A41EE7B00B2.body preserve=yes
   return u16GetValue(AMT_C_U32_SERVICESUPPLIERSTATUS_APPID);
  //## end amt_tclServiceSupplierStatus::u16GetAppID%3A41EE7B00B2.body
}

inline tVoid amt_tclServiceSupplierStatus::vSetAppID (tU16 u16NewAppID)
{
  //## begin amt_tclServiceSupplierStatus::vSetAppID%3A41EE98037A.body preserve=yes
   vSetValueU16(AMT_C_U32_SERVICESUPPLIERSTATUS_APPID, u16NewAppID);
  //## end amt_tclServiceSupplierStatus::vSetAppID%3A41EE98037A.body
}

inline tU8 amt_tclServiceSupplierStatus::u8GetServiceSupplierState () const
{
  //## begin amt_tclServiceSupplierStatus::u8GetServiceSupplierState%3A41EE7B00B2.body preserve=yes
   return u8GetValue(AMT_C_U32_SERVICESUPPLIERSTATUS_SERVICESUPPLIERSTATE);
  //## end amt_tclServiceSupplierStatus::u8GetServiceSupplierState%3A41EE7B00B2.body
}

inline tVoid amt_tclServiceSupplierStatus::vSetServiceSupplierState (tU8 nServiceSupplierState)
{
  //## begin amt_tclServiceSupplierStatus::vSetServiceSupplierState%3A41EE98037A.body preserve=yes
   vSetValueU8(AMT_C_U32_SERVICESUPPLIERSTATUS_SERVICESUPPLIERSTATE, nServiceSupplierState);
  //## end amt_tclServiceSupplierStatus::vSetServiceSupplierState%3A41EE98037A.body
}

// Class amt_tclServiceSupplierRegister 

//## Other Operations (inline)
inline tU16 amt_tclServiceSupplierUnregister::u16GetServiceID () const
{
  //## begin amt_tclServiceSupplierUnregister::u16GetServiceID%3A41EE7B00B2.body preserve=yes
   return u16GetValue(AMT_C_U32_SVSUNREGISTER_SERVICEID);
  //## end amt_tclServiceSupplierUnregister::u16GetServiceID%3A41EE7B00B2.body
}

inline tVoid amt_tclServiceSupplierUnregister::vSetServiceID (tU16 u16NewServiceID)
{
  //## begin amt_tclServiceSupplierUnregister::vSetServiceID%3A41EE98037A.body preserve=yes
   vSetValueU16(AMT_C_U32_SVSUNREGISTER_SERVICEID, u16NewServiceID);
  //## end amt_tclServiceSupplierUnregister::vSetServiceID%3A41EE98037A.body
}

// Class amt_tclApplicationInfoRegister 


//## Other Operations (inline)
inline tU16 amt_tclApplicationInfoRegister::u16GetAppID () const
{
  //## begin amt_tclApplicationInfoRegister::u16GetAppID%3A41EE7B00B2.body preserve=yes
   return u16GetValue(AMT_C_U32_AIREGISTER_APPID);
  //## end amt_tclApplicationInfoRegister::u16GetAppID%3A41EE7B00B2.body
}

inline tVoid amt_tclApplicationInfoRegister::vSetAppID (tU16 u16NewAppID)
{
  //## begin amt_tclApplicationInfoRegister::vSetAppID%3A41EE98037A.body preserve=yes
   vSetValueU16(AMT_C_U32_AIREGISTER_APPID, u16NewAppID);
  //## end amt_tclApplicationInfoRegister::vSetAppID%3A41EE98037A.body
}

// Class amt_tclApplicationInfoStatus 

inline tU16 amt_tclApplicationInfoStatus::u16GetAppID () const
{
  //## begin amt_tclApplicationInfoStatus::u16GetAppID%3A41EE7B00B2.body preserve=yes
   return u16GetValue(AMT_C_U32_APPLICATIONINFO_APPID);
  //## end amt_tclApplicationInfoStatus::u16GetAppID%3A41EE7B00B2.body
}

inline tVoid amt_tclApplicationInfoStatus::vSetAppID (tU16 u16NewAppID)
{
  //## begin amt_tclApplicationInfoStatus::vSetAppID%3A41EE98037A.body preserve=yes
   vSetValueU16(AMT_C_U32_APPLICATIONINFO_APPID, u16NewAppID);
  //## end amt_tclApplicationInfoStatus::vSetAppID%3A41EE98037A.body
}

inline tU8 amt_tclApplicationInfoStatus::u8GetApplicationInfoState () const
{
  //## begin amt_tclApplicationInfoStatus::u8GetApplicationInfoState%3A41EE7B00B2.body preserve=yes
   return u8GetValue(AMT_C_U32_APPLICATIONINFO_APPSTATE);
  //## end amt_tclApplicationInfoStatus::u8GetApplicationInfoState%3A41EE7B00B2.body
}

inline tVoid amt_tclApplicationInfoStatus::vSetApplicationInfoState (tU8 nApplicationInfoState)
{
  //## begin amt_tclApplicationInfoStatus::vSetApplicationInfoState%3A41EE98037A.body preserve=yes
   vSetValueU8(AMT_C_U32_APPLICATIONINFO_APPSTATE, nApplicationInfoState);
  //## end amt_tclApplicationInfoStatus::vSetApplicationInfoState%3A41EE98037A.body
}

// Class amt_tclApplicationInfoUnregister 

//## Other Operations (inline)
inline tU16 amt_tclApplicationInfoUnregister::u16GetAppID () const
{
  //## begin amt_tclApplicationInfoUnregister::u16GetAppID%3A41EE7B00B2.body preserve=yes
   return u16GetValue(AMT_C_U32_AI_UNREGISTER_APPID);
  //## end amt_tclApplicationInfoUnregister::u16GetAppID%3A41EE7B00B2.body
}

inline tVoid amt_tclApplicationInfoUnregister::vSetAppID (tU16 u16NewAppID)
{
  //## begin amt_tclApplicationInfoUnregister::vSetAppID%3A41EE98037A.body preserve=yes
   vSetValueU16(AMT_C_U32_AI_UNREGISTER_APPID, u16NewAppID);
  //## end amt_tclApplicationInfoUnregister::vSetAppID%3A41EE98037A.body
}

// Class amt_tclServiceRegister 

//## Other Operations (inline)
inline tU16 amt_tclServiceRegister::u16GetServiceID () const
{
  //## begin amt_tclServiceRegister::u16GetServiceID%3A41EE7B00B2.body preserve=yes
   return u16GetValue(AMT_C_U32_SVCREGISTER_SERVICEID);
  //## end amt_tclServiceRegister::u16GetServiceID%3A41EE7B00B2.body
}

inline tU16 amt_tclServiceRegister::u16GetServiceMajorVersion () const
{
  //## begin amt_tclServiceRegister::u16GetServiceMajorVersion%3A41EE87029A.body preserve=yes

   return u16GetValue(AMT_C_U32_SVCREGISTER_SERVICEMAJORVERSION);
  //## end amt_tclServiceRegister::u16GetServiceMajorVersion%3A41EE87029A.body
}

inline tVoid amt_tclServiceRegister::vSetServiceID (tU16 u16NewServiceID)
{
  //## begin amt_tclServiceRegister::vSetServiceID%3A41EE98037A.body preserve=yes
   vSetValueU16(AMT_C_U32_SVCREGISTER_SERVICEID, u16NewServiceID);
  //## end amt_tclServiceRegister::vSetServiceID%3A41EE98037A.body
}

inline tVoid amt_tclServiceRegister::vSetServiceMajorVersion (tU16 u16NewServiceVersion)
{
  //## begin amt_tclServiceRegister::vSetServiceMajorVersion%3A41EE9E03E7.body preserve=yes
   vSetValueU16(AMT_C_U32_SVCREGISTER_SERVICEMAJORVERSION, u16NewServiceVersion);
  //## end amt_tclServiceRegister::vSetServiceMajorVersion%3A41EE9E03E7.body
}

inline tU16 amt_tclServiceRegister::u16GetServiceMinorVersion () const
{
  //## begin amt_tclServiceRegister::u16GetServiceMinorVersion%3C5130780285.body preserve=yes
   return u16GetValue(AMT_C_U32_SVCREGISTER_SERVICEMINORVERSION);
  //## end amt_tclServiceRegister::u16GetServiceMinorVersion%3C5130780285.body
}

inline tVoid amt_tclServiceRegister::vSetServiceMinorVersion (tU16 u16NewServiceVersion)
{
  //## begin amt_tclServiceRegister::vSetServiceMinorVersion%3C5130880238.body preserve=yes
   vSetValueU16(AMT_C_U32_SVCREGISTER_SERVICEMINORVERSION, u16NewServiceVersion);
  //## end amt_tclServiceRegister::vSetServiceMinorVersion%3C5130880238.body
}

// Class amt_tclServiceData 


//## Other Operations (inline)
inline tU8 amt_tclServiceData::u8GetACT () const
{
  //## begin amt_tclServiceData::u8GetACT%3B24825B008A.body preserve=yes
   return u8GetValue(AMT_C_U32_SVCDATA_ACT);
  //## end amt_tclServiceData::u8GetACT%3B24825B008A.body
}

inline tVoid amt_tclServiceData::vSetACT (tU8 u8NewValue)
{
  //## begin amt_tclServiceData::vSetACT%3B24826A017C.body preserve=yes
   vSetValueU8(AMT_C_U32_SVCDATA_ACT, u8NewValue);
  //## end amt_tclServiceData::vSetACT%3B24826A017C.body
}

inline tVoid amt_tclServiceData::vSetStreamType (tU8 u8StreamType)
{
  //## begin amt_tclServiceData::vSetStreamType%3A14E0FE032C.body preserve=yes
   vSetValueU8(AMT_C_U32_SVCDATA_STREAMTYPE, u8StreamType);
  //## end amt_tclServiceData::vSetStreamType%3A14E0FE032C.body
}

inline tU8 amt_tclServiceData::u8GetStreamType () const
{
  //## begin amt_tclServiceData::u8GetStreamType%3A14E12900CB.body preserve=yes
   return u8GetValue(AMT_C_U32_SVCDATA_STREAMTYPE);
  //## end amt_tclServiceData::u8GetStreamType%3A14E12900CB.body
}

inline tVoid amt_tclServiceData::vSetStreamCounter (tU8 u8StreamCounter)
{
  //## begin amt_tclServiceData::vSetStreamCounter%3A14E1300021.body preserve=yes
   vSetValueU8(AMT_C_U32_SVCDATA_STREAMCOUNTER, u8StreamCounter);
  //## end amt_tclServiceData::vSetStreamCounter%3A14E1300021.body
}

inline tU8 amt_tclServiceData::u8GetStreamCounter () const
{
  //## begin amt_tclServiceData::u8GetStreamCounter%3A14E7E30334.body preserve=yes
   return u8GetValue(AMT_C_U32_SVCDATA_STREAMCOUNTER);
  //## end amt_tclServiceData::u8GetStreamCounter%3A14E7E30334.body
}

inline tVoid amt_tclServiceData::vSetRegisterID (tU16 u16RegisterID)
{
  //## begin amt_tclServiceData::vSetRegisterID%3A14E7F30189.body preserve=yes
   vSetValueU16(AMT_C_U32_SVCDATA_REGISTERID, u16RegisterID);
  //## end amt_tclServiceData::vSetRegisterID%3A14E7F30189.body
}

inline tU16 amt_tclServiceData::u16GetRegisterID () const
{
  //## begin amt_tclServiceData::u16GetRegisterID%3A14E7FC0132.body preserve=yes
   return u16GetValue(AMT_C_U32_SVCDATA_REGISTERID);
  //## end amt_tclServiceData::u16GetRegisterID%3A14E7FC0132.body
}

inline tVoid amt_tclServiceData::vSetCmdCounter (tU16 u16CmdCounter)
{
  //## begin amt_tclServiceData::vSetCmdCounter%3A14E806008C.body preserve=yes
   vSetValueU16(AMT_C_U32_SVCDATA_CMDCOUNTER, u16CmdCounter);
  //## end amt_tclServiceData::vSetCmdCounter%3A14E806008C.body
}

inline tU16 amt_tclServiceData::u16GetCmdCounter () const
{
  //## begin amt_tclServiceData::u16GetCmdCounter%3A153D8D032E.body preserve=yes
   return u16GetValue(AMT_C_U32_SVCDATA_CMDCOUNTER);
  //## end amt_tclServiceData::u16GetCmdCounter%3A153D8D032E.body
}

inline tVoid amt_tclServiceData::vSetServiceID (tU16 u16ServiceID)
{
  //## begin amt_tclServiceData::vSetServiceID%3A7FC6CE01BC.body preserve=yes
   vSetValueU16(AMT_C_U32_SVCDATA_SERVICEID, u16ServiceID);
  //## end amt_tclServiceData::vSetServiceID%3A7FC6CE01BC.body
}

inline tU16 amt_tclServiceData::u16GetServiceID () const
{
  //## begin amt_tclServiceData::u16GetServiceID%3A7FC6D40391.body preserve=yes
   return u16GetValue(AMT_C_U32_SVCDATA_SERVICEID);
  //## end amt_tclServiceData::u16GetServiceID%3A7FC6D40391.body
}

inline tVoid amt_tclServiceData::vSetFunctionID (tU16 u16FunctionID)
{
  //## begin amt_tclServiceData::vSetFunctionID%3A7FC6ED00DA.body preserve=yes
   vSetValueU16(AMT_C_U32_SVCDATA_FUNCTIONID, u16FunctionID);
  //## end amt_tclServiceData::vSetFunctionID%3A7FC6ED00DA.body
}

inline tU16 amt_tclServiceData::u16GetFunctionID () const
{
  //## begin amt_tclServiceData::u16GetFunctionID%3A7FC70101C9.body preserve=yes
   return u16GetValue(AMT_C_U32_SVCDATA_FUNCTIONID);
  //## end amt_tclServiceData::u16GetFunctionID%3A7FC70101C9.body
}

inline tVoid amt_tclServiceData::vSetOpCode (tU8 u8OpCode)
{
  //## begin amt_tclServiceData::vSetOpCode%3A7FC72503CA.body preserve=yes
   vSetValueU8(AMT_C_U32_SVCDATA_OPCODE, u8OpCode);
  //## end amt_tclServiceData::vSetOpCode%3A7FC72503CA.body
}

inline tU8 amt_tclServiceData::u8GetOpCode () const
{
  //## begin amt_tclServiceData::u8GetOpCode%3A7FC72B02EC.body preserve=yes
   return u8GetValue(AMT_C_U32_SVCDATA_OPCODE);
  //## end amt_tclServiceData::u8GetOpCode%3A7FC72B02EC.body
}

// Class amt_tclServiceStatus 


//## Other Operations (inline)
inline tU16 amt_tclServiceStatus::u16GetServiceID () const
{
  //## begin amt_tclServiceStatus::u16GetServiceID%3A7EC49601F3.body preserve=yes
   return u16GetValue(AMT_C_U32_SERVICESTATUS_SERVICEID);
  //## end amt_tclServiceStatus::u16GetServiceID%3A7EC49601F3.body
}

inline tVoid amt_tclServiceStatus::vSetServiceID (tU16 nServiceID)
{
  //## begin amt_tclServiceStatus::vSetServiceID%3A7EC4A901F1.body preserve=yes
   vSetValueU16(AMT_C_U32_SERVICESTATUS_SERVICEID, nServiceID);
  //## end amt_tclServiceStatus::vSetServiceID%3A7EC4A901F1.body
}

inline tU16 amt_tclServiceStatus::u16GetRegisterID () const
{
  //## begin amt_tclServiceStatus::u16GetRegisterID%3A7EC4B201B7.body preserve=yes
   return u16GetValue(AMT_C_U32_SERVICESTATUS_REGISTERID);
  //## end amt_tclServiceStatus::u16GetRegisterID%3A7EC4B201B7.body
}

inline tVoid amt_tclServiceStatus::vSetRegisterID (tU16 nRegisterID)
{
  //## begin amt_tclServiceStatus::vSetRegisterID%3A7EC4BA01D7.body preserve=yes
   vSetValueU16(AMT_C_U32_SERVICESTATUS_REGISTERID, nRegisterID);
  //## end amt_tclServiceStatus::vSetRegisterID%3A7EC4BA01D7.body
}

inline tU8 amt_tclServiceStatus::u8GetServiceState () const
{
  //## begin amt_tclServiceStatus::u8GetServiceState%3A7EC4EB0368.body preserve=yes
   return u8GetValue(AMT_C_U32_SERVICESTATUS_SERVICESTATE);
  //## end amt_tclServiceStatus::u8GetServiceState%3A7EC4EB0368.body
}

inline tVoid amt_tclServiceStatus::vSetServiceState (tU8 nServiceState)
{
  //## begin amt_tclServiceStatus::vSetServiceState%3A7EC4F3039C.body preserve=yes
   vSetValueU8(AMT_C_U32_SERVICESTATUS_SERVICESTATE, nServiceState);
  //## end amt_tclServiceStatus::vSetServiceState%3A7EC4F3039C.body
}

inline tVoid amt_tclServiceStatus::vSetReservedServStat1 (tU8 u8NewReserved)
{
  //## begin amt_tclServiceStatus::vSetReservedServStat1%3AB87E42031B.body preserve=yes
   vSetValueU8(AMT_C_U32_SERVICESTATUS_RESERVED1, u8NewReserved);
  //## end amt_tclServiceStatus::vSetReservedServStat1%3AB87E42031B.body
}

inline tU8 amt_tclServiceStatus::u8GetReservedServStat1 () const
{
  //## begin amt_tclServiceStatus::u8GetReservedServStat1%3AB87F1F00E8.body preserve=yes
   return u8GetValue(AMT_C_U32_SERVICESTATUS_RESERVED1);
  //## end amt_tclServiceStatus::u8GetReservedServStat1%3AB87F1F00E8.body
}

// Class amt_tclServiceRegisterConf 


//## Other Operations (inline)
inline tU16 amt_tclServiceRegisterConf::u16GetServiceID () const
{
  //## begin amt_tclServiceRegisterConf::u16GetServiceID%3A71B56A02C2.body preserve=yes
   return u16GetValue(AMT_C_U32_SVCREGCONF_SERVICEID);
  //## end amt_tclServiceRegisterConf::u16GetServiceID%3A71B56A02C2.body
}

inline tU16 amt_tclServiceRegisterConf::u16GetRegisterID () const
{
  //## begin amt_tclServiceRegisterConf::u16GetRegisterID%3A71B570032F.body preserve=yes
   return u16GetValue(AMT_C_U32_SVCREGCONF_REGISTERID);
  //## end amt_tclServiceRegisterConf::u16GetRegisterID%3A71B570032F.body
}

inline tU8 amt_tclServiceRegisterConf::u8GetRegisterState () const
{
  //## begin amt_tclServiceRegisterConf::u8GetRegisterState%3A71B57501C3.body preserve=yes
   return u8GetValue(AMT_C_U32_SVCREGCONF_REGISTERSTATE);
  //## end amt_tclServiceRegisterConf::u8GetRegisterState%3A71B57501C3.body
}

inline tVoid amt_tclServiceRegisterConf::vSetRegisterID (tU16 u16RegisterID)
{
  //## begin amt_tclServiceRegisterConf::vSetRegisterID%3A71B5860290.body preserve=yes
   vSetValueU16(AMT_C_U32_SVCREGCONF_REGISTERID, u16RegisterID);
  //## end amt_tclServiceRegisterConf::vSetRegisterID%3A71B5860290.body
}

inline tVoid amt_tclServiceRegisterConf::vSetServiceID (tU16 u16ServiceID)
{
  //## begin amt_tclServiceRegisterConf::vSetServiceID%3A71B58B021F.body preserve=yes
   vSetValueU16(AMT_C_U32_SVCREGCONF_SERVICEID, u16ServiceID);
  //## end amt_tclServiceRegisterConf::vSetServiceID%3A71B58B021F.body
}

inline tVoid amt_tclServiceRegisterConf::vSetRegisterState (tU8 u8RegisterState)
{
  //## begin amt_tclServiceRegisterConf::vSetRegisterState%3A71B59002A9.body preserve=yes
   vSetValueU8(AMT_C_U32_SVCREGCONF_REGISTERSTATE, u8RegisterState);
  //## end amt_tclServiceRegisterConf::vSetRegisterState%3A71B59002A9.body
}

inline tVoid amt_tclServiceRegisterConf::vSetReservedServRegConf1 (tU8 u8NewReserved)
{
  //## begin amt_tclServiceRegisterConf::vSetReservedServRegConf1%3AB87647002F.body preserve=yes
   vSetValueU8(AMT_C_U32_SVCREGCONF_RES1, u8NewReserved);
  //## end amt_tclServiceRegisterConf::vSetReservedServRegConf1%3AB87647002F.body
}

inline tU8 amt_tclServiceRegisterConf::u8GetReservedServRegConf1 () const
{
  //## begin amt_tclServiceRegisterConf::u8GetReservedServRegConf1%3AB8767800F7.body preserve=yes
   return u8GetValue(AMT_C_U32_SVCREGCONF_RES1);
  //## end amt_tclServiceRegisterConf::u8GetReservedServRegConf1%3AB8767800F7.body
}

inline tU16 amt_tclServiceRegisterConf::u16GetServiceMajorVersion () const
{
  //## begin amt_tclServiceRegisterConf::u16GetServiceMajorVersion%3C513103025D.body preserve=yes
   return u16GetValue(AMT_C_U32_SVCREGCONF_SERVICEMAJORVERSION);
  //## end amt_tclServiceRegisterConf::u16GetServiceMajorVersion%3C513103025D.body
}

inline tU16 amt_tclServiceRegisterConf::u16GetServiceMinorVersion () const
{
  //## begin amt_tclServiceRegisterConf::u16GetServiceMinorVersion%3C51314B027E.body preserve=yes
   return u16GetValue(AMT_C_U32_SVCREGCONF_SERVICEMINORVERSION);
  //## end amt_tclServiceRegisterConf::u16GetServiceMinorVersion%3C51314B027E.body
}

inline tVoid amt_tclServiceRegisterConf::vSetServiceMajorVersion (tU16 u16NewServiceMajorVersion)
{
  //## begin amt_tclServiceRegisterConf::vSetServiceMajorVersion%3C513166027D.body preserve=yes
   vSetValueU16(AMT_C_U32_SVCREGCONF_SERVICEMAJORVERSION, u16NewServiceMajorVersion);
  //## end amt_tclServiceRegisterConf::vSetServiceMajorVersion%3C513166027D.body
}

inline tVoid amt_tclServiceRegisterConf::vSetServiceMinorVersion (tU16 u16NewServiceMinorVersion)
{
  //## begin amt_tclServiceRegisterConf::vSetServiceMinorVersion%3C5131A001CC.body preserve=yes
   vSetValueU16(AMT_C_U32_SVCREGCONF_SERVICEMINORVERSION, u16NewServiceMinorVersion);
  //## end amt_tclServiceRegisterConf::vSetServiceMinorVersion%3C5131A001CC.body
}

inline tVoid amt_tclServiceRegisterConf::vSetServicePatchVersion (tU16 u16NewServicePatchVersion)
{
  //## begin amt_tclServiceRegisterConf::vSetServicePatchVersion%3C5131A1030E.body preserve=yes
   vSetValueU16(AMT_C_U32_SVCREGCONF_SERVICEPATCHVERSION, u16NewServicePatchVersion);
  //## end amt_tclServiceRegisterConf::vSetServicePatchVersion%3C5131A1030E.body
}

inline tU16 amt_tclServiceRegisterConf::u16GetServicePatchVersion () const
{
  //## begin amt_tclServiceRegisterConf::u16GetServicePatchVersion%3C51326E034F.body preserve=yes
   return u16GetValue(AMT_C_U32_SVCREGCONF_SERVICEPATCHVERSION);
  //## end amt_tclServiceRegisterConf::u16GetServicePatchVersion%3C51326E034F.body
}

// Class amt_tclServiceUnregister 


//## Other Operations (inline)
inline tU16 amt_tclServiceUnregister::u16GetServiceID () const
{
  //## begin amt_tclServiceUnregister::u16GetServiceID%3A7196C90353.body preserve=yes
   return u16GetValue(AMT_C_U32_SVCUNREGISTER_SERVICEID);
  //## end amt_tclServiceUnregister::u16GetServiceID%3A7196C90353.body
}

inline tVoid amt_tclServiceUnregister::vSetServiceID (tU16 u16NewServiceID)
{
  //## begin amt_tclServiceUnregister::vSetServiceID%3A7196D602C6.body preserve=yes
  vSetValueU16(AMT_C_U32_SVCUNREGISTER_SERVICEID, u16NewServiceID);
  //## end amt_tclServiceUnregister::vSetServiceID%3A7196D602C6.body
}

inline tU16 amt_tclServiceUnregister::u16GetRegisterID () const
{
  //## begin amt_tclServiceUnregister::u16GetRegisterID%3A7196D80341.body preserve=yes
   return u16GetValue(AMT_C_U32_SVCUNREGISTER_REGISTERID);
  //## end amt_tclServiceUnregister::u16GetRegisterID%3A7196D80341.body
}

inline tVoid amt_tclServiceUnregister::vSetRegisterID (tU16 u16NewRegisterID)
{
  //## begin amt_tclServiceUnregister::vSetRegisterID%3A7196EA009E.body preserve=yes
  vSetValueU16(AMT_C_U32_SVCUNREGISTER_REGISTERID, u16NewRegisterID);
  //## end amt_tclServiceUnregister::vSetRegisterID%3A7196EA009E.body
}


//## begin amt_tclDebugAppInfo%3A0BF34303A7.preface preserve=yes
//## end amt_tclDebugAppInfo%3A0BF34303A7.preface

//## Class: amt_tclDebugAppInfo%3A0BF34303A7
// *********************************************************
// ***********************
// DESCRIPTION:
//
// This is the representation of a ServiceSupplierRegister message.
// All get and set methods are undocumentated due to
// simplicity.
//
// History:
//
// 19.03.01 EFG32-Bruns
// InitialVersion
// 19.09.01 EFG32-Bruns
// Updated to ipc_def.h and using static offsets for all
// messages
//
// *********************************************************
// ***********************
//## Category: amt::amt_CCAMessages%3A0BF8D802EE
//## Subsystem: Amt::Include%3A7E97380302
//## Persistence: Transient
//## Cardinality/Multiplicity: n



class amt_tclDebugAppInfo : public amt_tclBaseMessage  //## Inherits: <unnamed>%3A3E095101CA
{
  //## begin amt_tclDebugAppInfo%3A0BF34303A7.initialDeclarations preserve=yes
   #define AMT_C_U8_DEBUG_APPLICATION_COMMAND      (tU32)20
   #define AMT_C_PU8_DEBUG_APPLICATION_DATA        (tU32)21
   #define AMT_C_U32_DEBUG_APPLICATION_DATA_SIZE   (tU32)20

   #define AMT_C_U32_DEBUG_APPLICATION_RELMSGSIZE  (tU32)21
  //## end amt_tclDebugAppInfo%3A0BF34303A7.initialDeclarations

  public:
    //## Constructors (specified)
      //## Operation: amt_tclDebugAppInfo%3A40953D021F
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Constructor - does ALLOCATION of message.
      //
      // PARAMETER:
      // tU16   u16Source (->I)
      // The value of the source field
      // tU16   u16Target (->I)
      // The value of the target field
      // tU16   u16ServiceID (->I)
      // The value of the service-ID field
      // tU16   u16SourceSub (->I)
      // The value of the source sub id field
      // tU16   u16TargetSub (->I)
      // The value of the target sub id field
      // tU32   u32Timestamp (->I)
      // The value of the timestamp field
      //
      // RETURNVALUE:
      // -
      //
      // History:
      // 04.09.09 TMS-Jentsch
      // *********************************************************
      // ***********************
      amt_tclDebugAppInfo (tU16 nSource, tU16 nTarget, tU8 u8Command, tU8 const * pu8Data, tU32 u32DataSize);

      // Old and only temporary constructor for the SPM as long as the SPM hasn't removed the usage of the class amt_tclDebugAppInfo.
      amt_tclDebugAppInfo (tU16 nSource, tU16 nTarget, tU32 nAppInfoLevel);

      //## Operation: amt_tclDebugAppInfo%3A714FC40073
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Constructor for message reception - does NO ALLOCATION
      // of message. Transforms base message to this message.
      //
      // PARAMETER:
      // amt_tclBaseMessage   *poBaseMessage
      // Pointer to received base message
      //
      // RETURNVALUE:
      // -
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      amt_tclDebugAppInfo (amt_tclBaseMessage* poBaseMessage);
      amt_tclDebugAppInfo (const amt_tclBaseMessage* copoBaseMessage);
      amt_tclDebugAppInfo (const amt_tclBaseMessage& corfoBaseMessage);

      //## Operation: amt_tclDebugAppInfo%3AB785D0011A
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Default constructor - does ALLOCATION of message.
      //
      // PARAMETER:
      //
      // RETURNVALUE:
      // -
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      amt_tclDebugAppInfo ();


    //## Other Operations (specified)

      tU8   u8GetCommand() const;
      tVoid vSetCommand(tU8 u8Command);

      tU8*  pu8GetData() const;
      tVoid vSetData(tU8 const * pu8Data, tU32 u32DataSize);

      //## Operation: operator==%3AB747970287
      tBool operator == (const amt_tclDebugAppInfo& roRight) const; //lint !e1511: Member hides non-virtual member

      //## Operation: vServiceSupplierRegisterSetup%3AB776FE01C9
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Initialise ServiceSupplierRegister message; add size of this
      // message class to "u32DynMsgSize".
      //
      // PARAMETER:
      // -
      //
      // RETURNVALUE:
      // tVoid
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************

      //## Operation: operator=%3AB86091016D
      amt_tclDebugAppInfo& operator = (const amt_tclDebugAppInfo& roRight);

      //## Operation: operator!=%3AB8648B00C7
      tBool operator != (const amt_tclDebugAppInfo& roRight) const; //lint !e1511: Member hides non-virtual member

      //## Operation: poClone%3B0240BE01F9
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // see amt_tclMappableMessage.
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      virtual amt_tclMappableMessage* poClone () const;

    // Additional Public Declarations
      //## begin amt_tclDebugAppInfo%3A0BF34303A7.public preserve=yes
      //## end amt_tclDebugAppInfo%3A0BF34303A7.public

  protected:
    //## Constructors (specified)
      //## Operation: amt_tclDebugAppInfo%3AB786A703AE
      // *********************************************************
      // ***********************
      // DESCRIPTION:
      // Copy-constructor for message - does ALLOCATION of
      // message.
      //
      // PARAMETER:
      // const amt_tclDebugAppInfo  &roRight (-> I)
      // Reference to message which will be copied.
      //
      // RETURNVALUE:
      // -
      //
      // History:
      // 19.03.01 EFG32-Bruns
      // InitialVersion
      // *********************************************************
      // ***********************
      amt_tclDebugAppInfo (const amt_tclDebugAppInfo& roRight);

    // Additional Protected Declarations
      //## begin amt_tclDebugAppInfo%3A0BF34303A7.protected preserve=yes
      //## end amt_tclDebugAppInfo%3A0BF34303A7.protected

};

inline tU8 amt_tclDebugAppInfo::u8GetCommand() const
{
  return u8GetValue(AMT_C_U8_DEBUG_APPLICATION_COMMAND);
}

inline tVoid amt_tclDebugAppInfo::vSetCommand(tU8 u8Command)
{
  vSetValueU8(AMT_C_U8_DEBUG_APPLICATION_COMMAND, u8Command);
}

inline tU8* amt_tclDebugAppInfo::pu8GetData() const
{
  return pu8GetStreamU8(AMT_C_PU8_DEBUG_APPLICATION_DATA);
}

inline tVoid amt_tclDebugAppInfo::vSetData(tU8 const * pu8Data, tU32 u32DataSize)
{
  vSetStreamU8(AMT_C_PU8_DEBUG_APPLICATION_DATA, pu8Data, u32DataSize, AMT_C_U32_DEBUG_APPLICATION_DATA_SIZE);
}

// Class amt_tclServiceDataError 

//## begin module%3A2CD5680126.epilog preserve=yes
// ServiceData base class without any data fields
class amt_tclServiceDataMsg0 : public amt_tclServiceData  
{
public:
   amt_tclServiceDataMsg0(amt_tclBaseMessage* poBaseMessage)
     : amt_tclServiceData(poBaseMessage)
   {};

   amt_tclServiceDataMsg0(const amt_tclBaseMessage* copoBaseMessage)
     : amt_tclServiceData(copoBaseMessage)
   {};

   amt_tclServiceDataMsg0(const amt_tclBaseMessage& corfoBaseMessage)
     : amt_tclServiceData(corfoBaseMessage)
   {};

   // set bAllocateMsg to FALSE to prevent message allocation.
   // That is useful if you want to inherit from this class. 
   // Otherwise don't specify the parameter at all.
   amt_tclServiceDataMsg0(tBool bAllocateMsg = TRUE)
     : amt_tclServiceData()
   {
      if(bAllocateMsg)
      {
         if(bAllocateMessage() == TRUE)
         {
            vSetSize(u32GetDynMsgSize());
         }
      }
   };

   amt_tclServiceDataMsg0& operator = (const amt_tclServiceDataMsg0& roRight)
   {
      if ( this != &roRight )
      {
         amt_tclServiceData::operator=(roRight);
      }
      return *this;
   };

   tBool operator == (const amt_tclServiceDataMsg0& roRight) const
   { //lint !e1511: Member hides non-virtual member
      return amt_tclServiceData::operator==(roRight);
   };

   tBool operator != (const amt_tclServiceDataMsg0& roRight) const
   { //lint !e1511: Member hides non-virtual member
      return !((*this) == roRight);
   };

   virtual amt_tclMappableMessage* poClone () const
   {
      return OSAL_NEW amt_tclServiceDataMsg0(*this);
   };

/*
  KSM2HI : 28.07.2015
  Intentionally deactivated below code due to LINT warning :
 
  amt_CCAMessages.h(4535) : Warning 1511: prio2: 
    Member hides non-virtual member 'amt_tclMappableMessage::bAllocateMessage(void)'
    (line 479, file /home/ksm2hi/vmshare/ksm2hi_AI_PRJ_CF3_BASE_SW_15.0F29.vws/di_frameworks/components/amt/../amt/include/amt_MMObj.h)

  In my opinion this function can be removed in class amt_tclServiceDataMsg0. 

  When bAllocateMessage() is called by this class amt_tclServiceDataMsg0, then the function bAllocateMessage() is called from the derived class amt_tclMappableMessage.
  The class amt_tclServiceData is also derived from amt_tclMappableMessage and therefore with removing bAllocateMessage() from amt_tclServiceDataMsg0 the behavior stays the same.

  derivation chain :  amt_tclServiceDataMsg0 :
                        amt_tclServiceData :
                          amt_tclBaseMessage :
                            amt_tclMappableMessage => tBool bAllocateMessage ();
*/
#if 0
   tBool bAllocateMessage()
   {
      return ( amt_tclServiceData::bAllocateMessage() );
   };
#endif

protected:
   amt_tclServiceDataMsg0(const amt_tclServiceDataMsg0& roRight)
     : amt_tclServiceData(roRight)
   {};

}; //lint !e1739: Binary operator operator== and operator!= should be non-member function




// ServiceData template with one data field
template <class T1>
class amt_tclServiceDataMsg1 : public amt_tclServiceDataMsg0  
{
private:
   amt_tclMappedIntegralType<T1> oData1;
public:
   amt_tclServiceDataMsg1(amt_tclBaseMessage* poBaseMessage)
     : amt_tclServiceDataMsg0(poBaseMessage)
   {
      vMsgSetupT1();
   };

   amt_tclServiceDataMsg1(const amt_tclBaseMessage* copoBaseMessage)
     : amt_tclServiceDataMsg0(copoBaseMessage)
   {
      vMsgSetupT1();
   };

   amt_tclServiceDataMsg1(const amt_tclBaseMessage& corfoBaseMessage)
     : amt_tclServiceDataMsg0(corfoBaseMessage)
   {
      vMsgSetupT1();
   };

   // set bAllocateMsg to FALSE to prevent message allocation.
   // That is useful if you want to inherit from this class.
   // Otherwise don't specify the parameter at all.
   amt_tclServiceDataMsg1(tBool bAllocateMsg = TRUE)
     : amt_tclServiceDataMsg0((tBool)FALSE)
   {
      vMsgSetupT1();

      if(bAllocateMsg)
      {
         if(bAllocateMessage() == TRUE)
         {
            vSetSize(u32GetDynMsgSize());
         }
      }
   };

   T1 GetData1() const
   {
      return oData1.nGetValue(this);
   };

   tVoid vSetData1(T1 Data)
   {
      oData1.vSetValue(this, Data);
   };

   amt_tclServiceDataMsg1& operator = (const amt_tclServiceDataMsg1& roRight)
   {
      amt_tclServiceDataMsg0::operator=(roRight);

      // assign specific elements
      vSetData1(roRight.GetData1());

      return *this;
   };

   tBool operator == (const amt_tclServiceDataMsg1& roRight) const
   { //lint !e1511: Member hides non-virtual member
      tBool bSuccess = FALSE;

      // first compare elements of base class
      if(amt_tclServiceDataMsg0::operator==(roRight))
      {
         // now compare specific elements
         if(GetData1() == roRight.GetData1())
         {
            bSuccess = TRUE;
         }
      }
      return bSuccess;
   };

   tBool operator != (const amt_tclServiceDataMsg1& roRight) const
   { //lint !e1511: Member hides non-virtual member
      return !((*this) == roRight);
   };

   virtual amt_tclMappableMessage* poClone () const
   {
      return OSAL_NEW amt_tclServiceDataMsg1<T1>(*this);
   };

protected:
   amt_tclServiceDataMsg1(const amt_tclServiceDataMsg1& roRight)
     : amt_tclServiceDataMsg0(roRight)
   {};

   tVoid vMsgSetupT1()
   {
      vAddType(&oData1);
   }
};


// ServiceData template with two data fields
template <class T1, class T2>
class amt_tclServiceDataMsg2 : public amt_tclServiceDataMsg1<T1>
{
private:
   amt_tclMappedIntegralType<T2> oData2;
public:
   amt_tclServiceDataMsg2(amt_tclBaseMessage* poBaseMessage)
     : amt_tclServiceDataMsg1<T1>(poBaseMessage)
   {
      vMsgSetupT2();
   };

   amt_tclServiceDataMsg2(const amt_tclBaseMessage* copoBaseMessage)
     : amt_tclServiceDataMsg1<T1>(copoBaseMessage)
   {
      vMsgSetupT2();
   };

   amt_tclServiceDataMsg2(const amt_tclBaseMessage& corfoBaseMessage)
     : amt_tclServiceDataMsg1<T1>(corfoBaseMessage)
   {
      vMsgSetupT2();
   };


   // set bAllocateMsg to FALSE to prevent message allocation.
   // That is useful if you want to inherit from this class.
   // Otherwise don't specify the parameter at all.
   amt_tclServiceDataMsg2(tBool bAllocateMsg = TRUE) 
     : amt_tclServiceDataMsg1<T1>((tBool)FALSE)
   {
      vMsgSetupT2();

      if(bAllocateMsg)
      {
         if(this->bAllocateMessage() == TRUE)
         {
            this->vSetSize(this->u32GetDynMsgSize());
         }
      }
   };

   T2 GetData2() const
   {
      return oData2.nGetValue(this);
   };

   tVoid vSetData2(T2 Data)
   {
      oData2.vSetValue(this, Data);
   };

   amt_tclServiceDataMsg2& operator = (const amt_tclServiceDataMsg2& roRight)
   {
      amt_tclServiceDataMsg1<T1>::operator=(roRight);

      // assign specific elements
      vSetData2(roRight.GetData2());

      return *this;
   };

   tBool operator == (const amt_tclServiceDataMsg2& roRight) const
   {
      tBool bSuccess = FALSE;

      // first compare elements of base class
      if(amt_tclServiceDataMsg2::operator==(roRight))
      {
         // now compare specific elements
         if(GetData2() == roRight.GetData2())
         {
            bSuccess = TRUE;
         }
      }
      return bSuccess;
   };

   tBool operator != (const amt_tclServiceDataMsg2& roRight) const
   {
      return !((*this) == roRight);
   };

   virtual amt_tclMappableMessage* poClone () const
   {
      return OSAL_NEW amt_tclServiceDataMsg2<T1, T2>(*this);
   };

protected:
   amt_tclServiceDataMsg2(const amt_tclServiceDataMsg2& roRight)
     : amt_tclServiceDataMsg1<T1>(roRight)
   {};

   tVoid vMsgSetupT2()
   {
      this->vAddType(&oData2);
   }
};


// ServiceData template with three data fields
template <class T1, class T2, class T3>
class amt_tclServiceDataMsg3 : public amt_tclServiceDataMsg2<T1, T2>
{
private:
   amt_tclMappedIntegralType<T3> oData3;
public:
   amt_tclServiceDataMsg3(amt_tclBaseMessage* poBaseMessage)
     : amt_tclServiceDataMsg2<T1, T2>(poBaseMessage)
   {
      vMsgSetupT3();
   };

   amt_tclServiceDataMsg3(const amt_tclBaseMessage* copoBaseMessage)
     : amt_tclServiceDataMsg2<T1, T2>(copoBaseMessage)
   {
      vMsgSetupT3();
   };

   amt_tclServiceDataMsg3(const amt_tclBaseMessage& corfoBaseMessage)
     : amt_tclServiceDataMsg2<T1, T2>(corfoBaseMessage)
   {
      vMsgSetupT3();
   };

   // set bAllocateMsg to FALSE to prevent message allocation.
   // That is useful if you want to inherit from this class.
   // Otherwise don't specify the parameter at all.
   amt_tclServiceDataMsg3(tBool bAllocateMsg = TRUE) 
     : amt_tclServiceDataMsg2<T1, T2>((tBool)FALSE)
   {
      vMsgSetupT3();

      if(bAllocateMsg)
      {
         if(this->bAllocateMessage() == TRUE)
         {
            this->vSetSize(this->u32GetDynMsgSize());
         }
      }
   };

   T3 GetData3() const
   {
      return oData3.nGetValue(this);
   };

   tVoid vSetData3(T3 Data)
   {
      oData3.vSetValue(this, Data);
   };

   amt_tclServiceDataMsg3& operator = (const amt_tclServiceDataMsg3& roRight)
   {
      amt_tclServiceDataMsg2<T1, T2>::operator=(roRight);

      // assign specific elements
      vSetData3(roRight.GetData3());

      return *this;
   };

   tBool operator == (const amt_tclServiceDataMsg3& roRight) const
   {
      tBool bSuccess = FALSE;

      // first compare elements of base class
      if(amt_tclServiceDataMsg3::operator==(roRight))
      {
         // now compare specific elements
         if(GetData3() == roRight.GetData3())
         {
            bSuccess = TRUE;
         }
      }
      return bSuccess;
   };

   tBool operator != (const amt_tclServiceDataMsg3& roRight) const
   {
      return !((*this) == roRight);
   };

   virtual amt_tclMappableMessage* poClone () const
   {
      return OSAL_NEW amt_tclServiceDataMsg3<T1, T2, T3>(*this);
   };

protected:
   amt_tclServiceDataMsg3(const amt_tclServiceDataMsg3& roRight)
     : amt_tclServiceDataMsg2<T1,T2>(roRight)
   {};

   tVoid vMsgSetupT3()
   {
      this->vAddType(&oData3);
   }
};


// ServiceData template with four data fields
template <class T1, class T2, class T3, class T4>
class amt_tclServiceDataMsg4 : public amt_tclServiceDataMsg3<T1, T2, T3>
{
private:
   amt_tclMappedIntegralType<T4> oData4;
public:
   amt_tclServiceDataMsg4(amt_tclBaseMessage* poBaseMessage)
     : amt_tclServiceDataMsg3<T1, T2, T3>(poBaseMessage)
   {
      vMsgSetupT4();
   };

   amt_tclServiceDataMsg4(const amt_tclBaseMessage* copoBaseMessage)
     : amt_tclServiceDataMsg3<T1, T2, T3>(copoBaseMessage)
   {
      vMsgSetupT4();
   };

   amt_tclServiceDataMsg4(const amt_tclBaseMessage& corfoBaseMessage)
     : amt_tclServiceDataMsg3<T1, T2, T3>(corfoBaseMessage)
   {
      vMsgSetupT4();
   };

   // set bAllocateMsg to FALSE to prevent message allocation.
   // That is useful if you want to inherit from this class.
   // Otherwise don't specify the parameter at all.
   amt_tclServiceDataMsg4(tBool bAllocateMsg = TRUE) 
     : amt_tclServiceDataMsg3<T1, T2, T3>((tBool)FALSE)
   {
      vMsgSetupT4();

      if(bAllocateMsg)
      {
         if(this->bAllocateMessage() == TRUE)
         {
            this->vSetSize(this->u32GetDynMsgSize());
         }
      }
   };

   T4 GetData4() const
   {
      return oData4.nGetValue(this);
   };

   tVoid vSetData4(T4 Data)
   {
      oData4.vSetValue(this, Data);
   };

   amt_tclServiceDataMsg4& operator = (const amt_tclServiceDataMsg4& roRight)
   {
      amt_tclServiceDataMsg3<T1, T2, T3>::operator=(roRight);

      // assign specific elements
      vSetData4(roRight.GetData4());

      return *this;
   };

   tBool operator == (const amt_tclServiceDataMsg4& roRight) const
   {
      tBool bSuccess = FALSE;

      // first compare elements of base class
      if(amt_tclServiceDataMsg4::operator==(roRight))
      {
         // now compare specific elements
         if(GetData4() == roRight.GetData4())
         {
            bSuccess = TRUE;
         }
      }
      return bSuccess;
   };

   tBool operator != (const amt_tclServiceDataMsg4& roRight) const
   {
      return !((*this) == roRight);
   };

   virtual amt_tclMappableMessage* poClone () const
   {
      return OSAL_NEW amt_tclServiceDataMsg4<T1, T2, T3, T4>(*this);
   };

protected:
   amt_tclServiceDataMsg4(const amt_tclServiceDataMsg4& roRight)
     : amt_tclServiceDataMsg3<T1,T2,T3>(roRight)
   {};

   tVoid vMsgSetupT4()
   {
      this->vAddType(&oData4);
   }
};

//## end module%3A2CD5680126.epilog


#endif
