//***************************************************************************
//** FILE:         amt_Main.h
//** PROJECT:      VASCO
//** SW-COMPONENT: AMT
//**---------------------------------------------------------------------------
//** DESCRIPTION:  (A)pplication (M)essage (T)emplate
//**               Definition of AMT initialisation interface
//**---------------------------------------------------------------------------
//** COPYRIGHT:    (c) 2000 Robert Bosch GmbH, Hildesheim
//** HISTORY:
//** Date       |  Modification                         | Author
//** < 19.03.01 |  Basic prototypes                     | Bruns,EFG32
//**  19.03.01  |  Updated ELL conventions              | Bruns,EFG32
//**  01.10.01  |  set complete AMT_API to export       | Bruns,EFG32
//**               see "problem C4273"
//**
//**---------------------------------------------------------------------------
//** REMARK: switches MUST be set in "amt_settings.h"
//*****************************************************************************

#ifndef AMT_MAIN_H
   #define AMT_MAIN_H


/******************************************************************************
 *FUNCTION:    amt_bInit
 *DESCRIPTION: Initialise AMT framework (tracing, static variables, ...)
 *             Must be called before using AMT framework.
 *
 *PARAMETER:   -
 *
 *RETURNVALUE: TRUE on success, else FALSE
 *
 *HISTORY:     -
 *****************************************************************************/
tBool amt_bInit(tVoid);



/******************************************************************************
 *FUNCTION:    amt_bDeInit
 *DESCRIPTION: De-Initialise AMT framework and frees used resources (tracing, 
 *             static variables, ...)
 *
 *PARAMETER:   -
 *
 *RETURNVALUE: TRUE on success, else FALSE
 *
 *HISTORY:     -
 *****************************************************************************/
tBool amt_bDeInit(tVoid);



#endif // AMT_MAIN_H

