//***************************************************************************
//** FILE:         amt_Main.cpp
//** PROJECT:      VASCO
//** SW-COMPONENT: AMT
//**---------------------------------------------------------------------------
//** DESCRIPTION:  (A)pplication (M)essage (T)emplate
//**               Implementation of AMT initialisation interface
//**---------------------------------------------------------------------------
//** COPYRIGHT:    (c) 2000 Robert Bosch GmbH, Hildesheim
//** HISTORY:
//** Date       |  Modification                         | Author
//**<=01.10.01  |  see header file                      | BNS2HI
//**
//*****************************************************************************
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define AMT_S_IMPORT_INTERFACE_GENERIC
#include "amt_if.h"


// GLOBAL "amt_gu32RefCounter"
// count the references to this module; This reference counter is used for 
// de-initialisiation. If "amt_bInit" is called more than once the trace
// descriptior and the static fields are only initialised once!
static tU32  amt_gu32RefCounter = 0;



/******************************************************************************
 *FUNCTION:    dummy_amt_dll
 *DESCRIPTION: Dummy function to assure correct linkage 
 *             (-> introduced by D.Tiemann for integration to SWNAVI archive)
 *
 *PARAMETER:   -
 *
 *RETURNVALUE: tVoid
 *
 *HISTORY:     -
 *****************************************************************************/
tVoid dummy_amt_dll(tVoid) {}

/******************************************************************************
 *FUNCTION:    amt_bInit
 *DESCRIPTION: Initialise AMT framework (tracing, static variables, ...)
 *             Must be called before using AMT framework.
 *
 *PARAMETER:   -
 *
 *RETURNVALUE: TRUE on success, else FALSE
 *
 *HISTORY:     -
 *****************************************************************************/
tBool amt_bInit()
{
   tBool bSuccess = TRUE;
   if(amt_gu32RefCounter == 0)
   {
      // first initialisation -> "init"-functions are called
      // initialise osal's TRACE...
      bSuccess = bSuccess && amt_bInitTrace();

      // initialise all static fields...
      bSuccess = bSuccess && amt_bInitStatics();

   }
   // initialisation again successfully done -> memory
   amt_gu32RefCounter++;

   return bSuccess;
}



/******************************************************************************
 *FUNCTION:    amt_bDeInit
 *DESCRIPTION: De-Initialise AMT framework and frees used resources (tracing, 
 *             static variables, ...)
 *
 *PARAMETER:   -
 *
 *RETURNVALUE: TRUE on success, else FALSE
 *
 *HISTORY:     -
 *****************************************************************************/
tBool amt_bDeInit()
{
   tBool bSuccess = TRUE;
   amt_gu32RefCounter--;
   if(amt_gu32RefCounter == 0)
   {
      // de-initialise osal's TRACE...
      bSuccess = amt_bDeInitTrace();
   }

   return bSuccess;
}
