//## begin module%1.4%.codegen_version preserve=yes
//   Read the documentation to learn more about C++ code generator
//   versioning.
//## end module%1.4%.codegen_version

//## begin module%3A3E1DE10129.cm preserve=no
//	  %X% %Q% %Z% %W%
//## end module%3A3E1DE10129.cm

//## Module: amt_MMObj%3A3E1DE10129; Subprogram body
//	#########################################################
//	## FILE:          amt_MMObj.cpp
//	## PROJECT:       VASCO
//	## SW-COMPONENT:  AMT
//	##-------------------------------------------------------
//	## DOCUMENTATION: see header
//	##-------------------------------------------------------
//	#########################################################
//## Subsystem: Amt%3A7E936D016B
//## Source file: e:\vasco\components\Amt\amt_MMObj.cpp

//## begin module%3A3E1DE10129.includes preserve=yes
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define AMT_S_IMPORT_INTERFACE_GENERIC
#include "amt_if.h"
//## end module%3A3E1DE10129.includes

//## begin module%3A3E1DE10129.additionalDeclarations preserve=yes
//## end module%3A3E1DE10129.additionalDeclarations


// Class amt_tclMappableMessage 

amt_tclMappableMessage::amt_tclMappableMessage ()
  //## begin amt_tclMappableMessage::amt_tclMappableMessage%3A6E91A3010A.hasinit preserve=no
  //## end amt_tclMappableMessage::amt_tclMappableMessage%3A6E91A3010A.hasinit
  //## begin amt_tclMappableMessage::amt_tclMappableMessage%3A6E91A3010A.initialization preserve=yes
  : pu8SharedMemBase(NULL)
  , u32DynMsgSize(0)
  //## end amt_tclMappableMessage::amt_tclMappableMessage%3A6E91A3010A.initialization
{
  //## begin amt_tclMappableMessage::amt_tclMappableMessage%3A6E91A3010A.body preserve=yes

   // Initialise all attributes
   rOSALMsg.enLocation = OSAL_EN_MEMORY_INVALID;
   rOSALMsg.u32Offset  = 0;

  //## end amt_tclMappableMessage::amt_tclMappableMessage%3A6E91A3010A.body
}

amt_tclMappableMessage::amt_tclMappableMessage (const amt_tclMappableMessage& rfoMMsg)
  //## begin amt_tclMappableMessage::amt_tclMappableMessage%3A71258502E9.hasinit preserve=no
  //## end amt_tclMappableMessage::amt_tclMappableMessage%3A71258502E9.hasinit
  //## begin amt_tclMappableMessage::amt_tclMappableMessage%3A71258502E9.initialization preserve=yes
  //## end amt_tclMappableMessage::amt_tclMappableMessage%3A71258502E9.initialization
{
  //## begin amt_tclMappableMessage::amt_tclMappableMessage%3A71258502E9.body preserve=yes

   // copy all attributes
   rOSALMsg         = rfoMMsg.rOSALMsg;
   u32DynMsgSize    = rfoMMsg.u32DynMsgSize;
   pu8SharedMemBase = rfoMMsg.pu8SharedMemBase; //lint !e1554: Direct pointer copy of member within copy constructor --> copy pointer to shared membase

  //## end amt_tclMappableMessage::amt_tclMappableMessage%3A71258502E9.body
}

amt_tclMappableMessage::amt_tclMappableMessage (const OSAL_trMessage* pOSALHandle, tU32 u32MsgSize)
  //## begin amt_tclMappableMessage::amt_tclMappableMessage%3B023E5E038F.hasinit preserve=no
  //## end amt_tclMappableMessage::amt_tclMappableMessage%3B023E5E038F.hasinit
  //## begin amt_tclMappableMessage::amt_tclMappableMessage%3B023E5E038F.initialization preserve=yes
  //## end amt_tclMappableMessage::amt_tclMappableMessage%3B023E5E038F.initialization
{
  //## begin amt_tclMappableMessage::amt_tclMappableMessage%3B023E5E038F.body preserve=yes

   // This constructor sets the message handle to a specified value. The size of the
   // message must be given in second parameter (another solution can be to read this value
   // from the message's size field...). The message is then mapped by calling 
   // "OSAL_pu8MessageMap".
   rOSALMsg         = *pOSALHandle;
   u32DynMsgSize    = u32MsgSize;
   pu8SharedMemBase = OSAL_pu8MessageContentGet(rOSALMsg, OSAL_EN_READWRITE);

  //## end amt_tclMappableMessage::amt_tclMappableMessage%3B023E5E038F.body
}


amt_tclMappableMessage::~amt_tclMappableMessage ()
{
  //## begin amt_tclMappableMessage::~amt_tclMappableMessage%3A71257A01DF.body preserve=yes

   // REMARK: Do nothing here.
   //         The message must be deleted explicitly by calling "bDelete"!!!
   pu8SharedMemBase = NULL;

  //## end amt_tclMappableMessage::~amt_tclMappableMessage%3A71257A01DF.body
}



//## Other Operations (implementation)
tVoid amt_tclMappableMessage::vAddType (amt_tclMappableType* prNewType)
{
  //## begin amt_tclMappableMessage::vAddType%3A4095F000F0.body preserve=yes

   // set offset of type (declared friendship!!) to actual message size
   prNewType->u32Offset  = u32DynMsgSize;

   // increment actual message size by wize of new type
   u32DynMsgSize        += prNewType->u32GetSizeOfType();

  //## end amt_tclMappableMessage::vAddType%3A4095F000F0.body
}

tBool amt_tclMappableMessage::bAllocateMessage ()
{
  //## begin amt_tclMappableMessage::bAllocateMessage%3A40966F017F.body preserve=yes

   // initialisation of pu8SharedMemBase!
   pu8SharedMemBase = NULL;


   // create an osal message
   tBool bSuccess = FALSE;
   if (OSAL_OK == OSAL_s32MessageCreate(&rOSALMsg, u32DynMsgSize, OSAL_EN_MEMORY_SHARED))
   {
      pu8SharedMemBase= OSAL_pu8MessageContentGet(rOSALMsg, OSAL_EN_READWRITE);
      if( 0 != pu8SharedMemBase)
      {
         // clear region
         OSAL_pvMemorySet(pu8SharedMemBase, 0xCC, u32DynMsgSize); //lint !e522: Expected void type, assignment, increment or decrement
#ifdef _DEBUG
         // get thread-id
         OSAL_tThreadID hThreadId = OSAL_ThreadWhoAmI();
         OSAL_pvMemoryCopy(pu8SharedMemBase, (tPCVoid)&hThreadId,
            sizeof(OSAL_tThreadID)>u32DynMsgSize?u32DynMsgSize:sizeof(OSAL_tThreadID) );
#endif //_DEBUG
         bSuccess = TRUE;
      }
   }

   return (bSuccess);

  //## end amt_tclMappableMessage::bAllocateMessage%3A40966F017F.body
}

tVoid amt_tclMappableMessage::vSetSharedMemBase (tU8* pu8NewSharedBase)
{
  //## begin amt_tclMappableMessage::vSetSharedMemBase%3A715B020176.body preserve=yes

   pu8SharedMemBase = pu8NewSharedBase;

  //## end amt_tclMappableMessage::vSetSharedMemBase%3A715B020176.body
}

OSAL_trMessage* amt_tclMappableMessage::prGetOSALMsgHandle ()
{
  //## begin amt_tclMappableMessage::prGetOSALMsgHandle%3A715B9203C2.body preserve=yes

   return &rOSALMsg; //lint !e1536: Exposing low access member (need access in ail and so on)

  //## end amt_tclMappableMessage::prGetOSALMsgHandle%3A715B9203C2.body
}

tBool amt_tclMappableMessage::bDelete ()
{
  //## begin amt_tclMappableMessage::bDelete%3A824730017E.body preserve=yes

   tBool bRetVal = FALSE;

   if (pu8SharedMemBase)
   {
      // Free all resources (delete handle)
      if (OSAL_s32MessageDelete(rOSALMsg) == OSAL_OK)   //lint !e522: Expected void type, assignment, increment or decrement
      {
        pu8SharedMemBase = NULL;
        bRetVal = TRUE;
      }
      else
      {
        NORMAL_M_ASSERT_ALWAYS();
      }
   }

   return (bRetVal);

  //## end amt_tclMappableMessage::bDelete%3A824730017E.body
}

tBool amt_tclMappableMessage::bIsValid () const
{
  //## begin amt_tclMappableMessage::bIsValid%3AB9C2D50099.body preserve=yes

   // returns "TRUE" if "pu8SharedMemBase" is valid (!= 0).
   return ((pu8SharedMemBase != 0) ? TRUE : FALSE);

  //## end amt_tclMappableMessage::bIsValid%3AB9C2D50099.body
}

tVoid amt_tclMappableMessage::vInvalidate()
{
  pu8SharedMemBase    = NULL;
  rOSALMsg.enLocation = OSAL_EN_MEMORY_INVALID;
  rOSALMsg.u32Offset  = 0;
}

tBool amt_tclMappableMessage::bEnableAccess ()
{
  //## begin amt_tclMappableMessage::bEnableAccess%3AB9D6500338.body preserve=yes

   tBool fSuccess = FALSE;

   // Map pointer according to handle in shared memory (this takes resources!).
   tU8 *pu8MemBase = OSAL_pu8MessageContentGet(rOSALMsg, OSAL_EN_READWRITE);

   if(pu8MemBase != 0)
   {

      // update pointer to message in Shared-Memory ("pu8SharedMemBase").
      vSetSharedMemBase(pu8MemBase);
      fSuccess = TRUE;
   }
   return fSuccess;

  //## end amt_tclMappableMessage::bEnableAccess%3AB9D6500338.body
}

tBool amt_tclMappableMessage::bHandOver (amt_tclMappableMessage* poDestinationMessage)
{
   //  This Method provides a way to delegate further processing of our 
   //  message to any empty MappableMessage-derived object. 
   //
   //  Primary intended usage is separating 
   //     user data loading (impicitly creating the message) 
   //  from
   //     filling in mailing parameters and posting
   //
   //  Therefore we:
   //     - copy all handles to shared memory into the destination object
   //     - invalidate our own handles
   //
   //  Return:  TRUE  if successful, 
   //           FALSE if the pointer to the destination message is not valid
   //                 or the destination message already owns a valid message
   //                 or we don't own a valid message
   //
   //  History:
   //  21.05.10  |  Martin Koch (Fa. ESE)   |  InitialVersion

   tBool bSuccess = FALSE;

   if (poDestinationMessage == NULL)
      ;  // cannot execute, pointer to destination is invalid 
   else if (poDestinationMessage->bIsValid())
      ;  // beware of executing, destination message would become orphan
   else if (bIsValid())
   {
      // handover pu8SharedMemBase, u32DynMsgSize and rOSALMsg
      poDestinationMessage->pu8SharedMemBase = pu8SharedMemBase;
      poDestinationMessage->u32DynMsgSize = u32DynMsgSize;
      poDestinationMessage->rOSALMsg = rOSALMsg;

      // invalidate our handles
      pu8SharedMemBase = NULL;
      rOSALMsg.enLocation = OSAL_EN_MEMORY_INVALID;
      rOSALMsg.u32Offset = (tU32) 0;

      bSuccess = TRUE;
   }  
   return bSuccess;
}

// assignment constructor
// 19.05.2017, ksm2hi : Coverity blamed that there is a public copy constructor but no assignment constructor. So also added the assignment constructor to be consequent in this regard.
amt_tclMappableMessage& amt_tclMappableMessage::operator = (const amt_tclMappableMessage& roRight)
{
   if ( this != &roRight )
   {
      rOSALMsg         = roRight.rOSALMsg;
      u32DynMsgSize    = roRight.u32DynMsgSize;
      pu8SharedMemBase = roRight.pu8SharedMemBase;
   }

   return *this;
}

// Additional Declarations
  //## begin amt_tclMappableMessage%3A409563021A.declarations preserve=yes
  //## end amt_tclMappableMessage%3A409563021A.declarations

// Class amt_tclMappableType 

amt_tclMappableType::amt_tclMappableType ()
  //## begin amt_tclMappableType::amt_tclMappableType%3A3DDC5B033C.hasinit preserve=no
  //## end amt_tclMappableType::amt_tclMappableType%3A3DDC5B033C.hasinit
  //## begin amt_tclMappableType::amt_tclMappableType%3A3DDC5B033C.initialization preserve=yes
  //## end amt_tclMappableType::amt_tclMappableType%3A3DDC5B033C.initialization
{
  //## begin amt_tclMappableType::amt_tclMappableType%3A3DDC5B033C.body preserve=yes

   // Initialise all attributes
    u32Offset = 0;

  //## end amt_tclMappableType::amt_tclMappableType%3A3DDC5B033C.body
}



//## Other Operations (implementation)
tU32 amt_tclMappableType::u32GetSizeOfType () const
{
  //## begin amt_tclMappableType::u32GetSizeOfType%3A3DDBB702FA.body preserve=yes

   // return "0" via default. This method MUST is overwritten by derived classes.
   return 0;

  //## end amt_tclMappableType::u32GetSizeOfType%3A3DDBB702FA.body
}

// Additional Declarations
  //## begin amt_tclMappableType%3A3DCC0703D2.declarations preserve=yes
  //## end amt_tclMappableType%3A3DCC0703D2.declarations

// Class amt_tclBufferN 

amt_tclBufferN::amt_tclBufferN ()
  //## begin amt_tclBufferN::amt_tclBufferN%3A83C9A70267.hasinit preserve=no
  //## end amt_tclBufferN::amt_tclBufferN%3A83C9A70267.hasinit
  //## begin amt_tclBufferN::amt_tclBufferN%3A83C9A70267.initialization preserve=yes
  //## end amt_tclBufferN::amt_tclBufferN%3A83C9A70267.initialization
{
  //## begin amt_tclBufferN::amt_tclBufferN%3A83C9A70267.body preserve=yes

   // Initialise internal attributes.
   u32BufferSize = 0;

  //## end amt_tclBufferN::amt_tclBufferN%3A83C9A70267.body
}



//## Other Operations (implementation)
tVoid amt_tclBufferN::vSetValue (amt_tclMappableMessage* poMMsg, const tChar* pcocBuffer) const
{
  //## begin amt_tclBufferN::vSetValue%3A83C9BD03BD.body preserve=yes

   // raise exception if message pointer is invalid.
   if(   poMMsg
      && poMMsg->pu8GetSharedMemBase() )
   {
      // first set the length of the string in the first tU32 field
      tChar *pcLengthField32 = (tChar*)(poMMsg->pu8GetSharedMemBase())+u32Offset;
      OSAL_pvMemoryCopy(pcLengthField32, &u32BufferSize, sizeof(tU32)); //lint !e522: Expected void type, assignment, increment or decrement

      // copy string data to message's data region
      tChar *pcDataRegion =  (tChar*)((poMMsg->pu8GetSharedMemBase())
                           + sizeof(tU32)
                           + u32Offset);
      OSAL_pvMemoryCopy(pcDataRegion, pcocBuffer, u32BufferSize); //lint !e522: Expected void type, assignment, increment or decrement
   }

  //## end amt_tclBufferN::vSetValue%3A83C9BD03BD.body
} //lint !e818: Pointer parameter 'poMMsg' could be declared as pointing to const

tBool amt_tclBufferN::bGetValue (const amt_tclMappableMessage* prMMsg, tChar* pcBuffer, tU32 u32MaxLength) const
{
  //## begin amt_tclBufferN::bGetValue%3A83C9D003C5.body preserve=yes

  // raise exception if message pointer is invalid.
   if(   prMMsg
      && prMMsg->pu8GetSharedMemBase())
   {
      // Simply read the data region. The maximum lentgh must have been set by calling 
      // nLink at the appropriate time. nLink ensures that "nStringLength" has the correct
      // value.
      // printf("actualLength = %d\n", nBufferSize);
      const tChar *pcocDataRegion = (const tChar*)((prMMsg->pu8GetSharedMemBase())
                                  +  sizeof(tU32)
                                  +  u32Offset);

      // add 0-byte at maximum position
      tU32 u32Max = (u32BufferSize > (u32MaxLength-1)) ? (u32MaxLength-1) : u32BufferSize;
      OSAL_pvMemoryCopy(pcBuffer, pcocDataRegion, u32Max/*u32MaxLength*/); //lint !e522: Expected void type, assignment, increment or decrement
      pcBuffer[u32Max]=0;

      // This return is for further extentend error checking
      return TRUE;
   }
   else
      return FALSE;

  //## end amt_tclBufferN::bGetValue%3A83C9D003C5.body
}

tU32 amt_tclBufferN::u32Link (amt_tclMappableMessage* poMMsg)
{
  //## begin amt_tclBufferN::u32Link%3A83C9EB02DD.body preserve=yes

   // raise exception if message pointer is invalid.
   if (  poMMsg
      && poMMsg->pu8GetSharedMemBase())
   {
      // "Link" simply updates the string length by reading the first tU32 of the current message 
      // position. Thus "nLink" MUST (!!!) be called after all preceeding types have been
      // added to the message (by vAddType) and the message's actual size is at the beginning
      // of the String --> the string length is coded in the next tU32 field of the message and
      // can be read out.
      tChar *pcLengthField32 =   (tChar*)( (poMMsg->pu8GetSharedMemBase())
                              + (poMMsg->u32GetDynMsgSize()) );
      // rewritten prototype: tU32 u32StoredLength = *pcLengthField32;
      tU32 u32StoredLength;
      OSAL_pvMemoryCopy((tChar*)&u32StoredLength, pcLengthField32, sizeof(tU32)); //lint !e522: Expected void type, assignment, increment or decrement
      u32BufferSize = u32StoredLength;
   
      return u32StoredLength;
   }
   else
      return 0;

  //## end amt_tclBufferN::u32Link%3A83C9EB02DD.body
} //lint !e818: Pointer parameter 'poMMsg' could be declared as pointing to const

tVoid amt_tclBufferN::vSetBufferSize (tU32 u32BufferLen)
{
  //## begin amt_tclBufferN::vSetBufferSize%3A83C9FF01BA.body preserve=yes
   u32BufferSize = u32BufferLen;
  //## end amt_tclBufferN::vSetBufferSize%3A83C9FF01BA.body
}

tU32 amt_tclBufferN::u32GetSizeOfType () const
{
  //## begin amt_tclBufferN::u32GetSizeOfType%3A83D75F0023.body preserve=yes

   // The length of the string is stored at the front of the buffer. If the message is
   // posted to a client this first field is read to determine the lentgh of the
   // data region for the string in the message.
   tU32 nLengthOverall =   (tU32)(sizeof(tU32)   // first tU32 is used for string length
                         + u32BufferSize);       // length of data region

   return (nLengthOverall);

  //## end amt_tclBufferN::u32GetSizeOfType%3A83D75F0023.body
}

tU32 amt_tclBufferN::u32GetBufferSize () const
{
  //## begin amt_tclBufferN::u32GetBufferSize%3AB9D20B0232.body preserve=yes

   return u32BufferSize;

  //## end amt_tclBufferN::u32GetBufferSize%3AB9D20B0232.body
}

tVoid amt_tclBufferN::vClone (amt_tclMappableMessage* poDestiMsg, const amt_tclMappableMessage* pSourceMsg, const amt_tclBufferN* pSourceBufferN)
{
  //## begin amt_tclBufferN::vClone%3B14ECE6003A.body preserve=yes

   // copy whole data including size field
   if (  poDestiMsg
      && pSourceBufferN
      && pSourceMsg
      && pSourceMsg->pu8GetSharedMemBase() )
   {
      // copy size field, assumes correct length in source (!)
      u32BufferSize = pSourceBufferN->u32BufferSize;

      const tChar *pcocStartOfSourceBufferN = (const tChar*)((pSourceMsg->pu8GetSharedMemBase())
                                            + sizeof(tU32)
                                            + pSourceBufferN->u32Offset );
      vSetValue (poDestiMsg, pcocStartOfSourceBufferN);
   }

  //## end amt_tclBufferN::vClone%3B14ECE6003A.body
}

tBool amt_tclBufferN::bGetValueRaw (const amt_tclMappableMessage* prMMsg, tChar* pcBuffer, tU32 u32MaxLength) const
{
  //## begin amt_tclBufferN::bGetValueRaw%3B8B9C8A00A2.body preserve=yes

   // raise exception if message pointer is invalid.
   if (  prMMsg
      && prMMsg->pu8GetSharedMemBase())
   {
      // Simply read the data region. The maximum lentgh must have been set by calling 
      // nLink at the appropriate time. nLink ensures that "nStringLength" has the correct
      // value.
      // printf("actualLength = %d\n", nBufferSize);
      const tChar *pcocDataRegion = (const tChar*)((prMMsg->pu8GetSharedMemBase())
                                  + sizeof(tU32)
                                  + u32Offset);

      // add 0-byte at maximum position
      tU32 u32Max = (u32BufferSize > (u32MaxLength)) ? (u32MaxLength) : u32BufferSize;
      OSAL_pvMemoryCopy(pcBuffer, pcocDataRegion, u32Max); //lint !e522: Expected void type, assignment, increment or decrement

      // This return is for further extentend error checking
      return TRUE;
   }
   else
      return FALSE;

  //## end amt_tclBufferN::bGetValueRaw%3B8B9C8A00A2.body
}

tChar * amt_tclBufferN::pcGetDataPointer (amt_tclMappableMessage *poMMsg) const
{
  //## begin amt_tclBufferN::pcGetDataPointer%3D3D23110238.body preserve=yes

   if (  poMMsg
      && poMMsg->pu8GetSharedMemBase())
   {
      // set the length of the datafield in the first tU32 field
      // when the method vSetValue(...) was not used to write the dataregion
      tChar *pcLengthField32 = (tChar*)(poMMsg->pu8GetSharedMemBase())+u32Offset;
      OSAL_pvMemoryCopy(pcLengthField32, &u32BufferSize, sizeof(tU32)); //lint !e522: Expected void type, assignment, increment or decrement


      tChar *pcDataRegion = (tChar *)((poMMsg->pu8GetSharedMemBase())
                           + sizeof( tU32) 
                           + u32Offset);

      return pcDataRegion;
   }
   else
      return OSAL_NULL;

  //## end amt_tclBufferN::pcGetDataPointer%3D3D23110238.body
} //lint !e818: Pointer parameter 'poMMsg' could be declared as pointing to const

// Additional Declarations
  //## begin amt_tclBufferN%3A83C94502D5.declarations preserve=yes
  //## end amt_tclBufferN%3A83C94502D5.declarations

//## begin module%3A3E1DE10129.epilog preserve=yes
//## end module%3A3E1DE10129.epilog
