/*******************************************************************************
 * FILE:          ail_trace.h         
 * SW-COMPONENT:  AIL
 * DESCRIPTION:   allows formatted tracing
 * AUTHOR:        EFG32-Brunke
 * COPYRIGHT:     (c) 2001 Robert Bosch GmbH, Hildesheim
 * HISTORY:      
 ******************************************************************************/

#ifndef AIL_TRACE_HEADER
#define AIL_TRACE_HEADER

#ifdef __cplusplus
extern "C"{
#endif

/*******************************************************************************
| includes of component-internal interface, if necessary
| (scope: component-local)
|-----------------------------------------------------------------------------*/


/*******************************************************************************
| defines and macros (scope: global)
|-----------------------------------------------------------------------------*/

#define AIL_C_U16_MAX_TRACE_BUF                                             1000
#define AIL_C_U8_TRACE_THRESHOLD_MSG_PRINT                                    70

#define AIL_C_U8_TRACE_TYPE_STRING                                             1
#define AIL_C_U8_TRACE_TYPE_MESSAGEDUMP                                        2
#define AIL_C_U8_TRACE_TYPE_DATADUMP                                           3

#define AIL_C_U8_TRACE_MSG_RECEIVED                                            1
#define AIL_C_U8_TRACE_MSG_SENT                                                2

#ifdef AIL_MESSAGE_COUNTER_ENABLED
#define CCA_INFO_ARRAY_SIZE                                               0x4000
#endif

/*******************************************************************************
| enuma and typedefs (scope: global)
|-----------------------------------------------------------------------------*/

enum ail_TraceClassAppRec
{
                        TR_CLASS_APPREC_AIL_SPM = TR_COMP_APPREC + 1                      ,
                        TR_CLASS_APPREC_AIL_NAVI                                          ,
                        TR_CLASS_APPREC_AIL_OBN                                           ,
                        TR_CLASS_APPREC_AIL_TIMA                                          ,
                        TR_CLASS_APPREC_AIL_MA                                            ,
                        TR_CLASS_APPREC_AIL_DATA_SERVER                                   ,
                        TR_CLASS_APPREC_AIL_VOICE                                         ,
                        TR_CLASS_APPREC_AIL_BASIC                                         ,
                        TR_CLASS_APPREC_AIL_TELEFON                                       ,
                        TR_CLASS_APPREC_AIL_INFOTAINMENT                                  ,
                        TR_CLASS_APPREC_AIL_COMCCA_GW                                     ,
                        TR_CLASS_APPREC_AIL_DOWNLOAD                                      ,
                        TR_CLASS_APPREC_AIL_SELFTEST                                      ,
                        TR_CLASS_APPREC_AIL_TMC                                           ,
                        TR_CLASS_APPREC_AIL_SINA                                          ,
                        TR_CLASS_APPREC_AIL_MCU                                           ,
                        TR_CLASS_APPREC_AIL_FC_TEA                                        ,
                        TR_CLASS_APPREC_AIL_FC_DIAGNOSIS                                  ,
                        TR_CLASS_APPREC_AIL_FC_CLIMATE                                    ,
                        TR_CLASS_APPREC_AIL_FC_STATISTICS                                 ,
                        TR_CLASS_APPREC_AIL_FC_WDB                                        ,
                        TR_CLASS_APPREC_AIL_FC_WEBSEARCH                                  ,
                        TR_CLASS_APPREC_AIL_FC_LOCINPUT                                   ,
                        TR_CLASS_APPREC_AIL_FC_SYNCATLANTICWIZ                            ,
                        TR_CLASS_APPREC_AIL_DEVICEMANAGER                                 ,
                        TR_CLASS_APPREC_AIL_SPM_SLV                                       ,
                        TR_CLASS_APPREC_AIL_FC_PDC                                        ,
                        TR_CLASS_APPREC_AIL_VD_TOUCH                                      ,
                        TR_CLASS_APPREC_AIL_INTERACTIONLOGGER                             ,
                        TR_CLASS_APPREC_AIL_KBD                                           ,
                        TR_CLASS_APPREC_AIL_MMGR                                          ,
                        TR_CLASS_APPREC_AIL_CLUSTER                                       ,
                        TR_CLASS_APPREC_AIL_FC_REMOTE_DISPLAY                             ,
                        TR_CLASS_APPREC_AIL_VD_DIMMING                                    ,
                        TR_CLASS_APPREC_AIL_FC_UAM                                        ,
                        TR_CLASS_APPREC_AIL_FC_HEATCTRL                                   ,
                        TR_CLASS_APPREC_AIL_FC_SECURITY                                   ,
                        TR_CLASS_APPREC_AIL_VD_GRAPHIC_ABSTRACTION                        ,
                        TR_CLASS_APPREC_AIL_VD_CLOCK                                      ,
                        TR_CLASS_APPREC_AIL_FC_AUXCTRL_EXTBOX                             ,
                        TR_CLASS_APPREC_AIL_EXT_VR                                        ,
                        TR_CLASS_APPREC_AIL_FC_MDI                                        ,
                        TR_CLASS_APPREC_AIL_FC_TUNERSYNC                                  ,
                        TR_CLASS_APPREC_AIL_FC_DABTUNER                                   ,
                        TR_CLASS_APPREC_AIL_VD_VEHICLE_DATA                               ,
                        TR_CLASS_APPREC_AIL_FC_OPS                                        ,
                        TR_CLASS_APPREC_AIL_VD_RVC                                        ,
                        TR_CLASS_APPREC_AIL_FC_CHIME                                      ,
                        TR_CLASS_APPREC_AIL_FC_IPOD                                       ,
                        TR_CLASS_APPREC_AIL_FC_ADASHORIZON                                ,
                        TR_CLASS_APPREC_AIL_FC_NAVREPEATER                                ,
                        TR_CLASS_APPREC_AIL_FC_MEDIAPLAYER_EXTBOX                         ,
                        TR_CLASS_APPREC_AIL_FC_TUNER_EXTBOX                               ,
                        TR_CLASS_APPREC_AIL_FC_VEHICLEFUNCTION_EXTBOX                     ,
                        TR_CLASS_APPREC_AIL_FC_AUDIO_EXTBOX                               ,
                        TR_CLASS_APPREC_AIL_FC_XM_TUNER                                   ,
                        TR_CLASS_APPREC_AIL_FC_UPS                                        ,
                        TR_CLASS_APPREC_AIL_FC_REMOTE_CLIENT                              ,
                        TR_CLASS_APPREC_AIL_VD_ADASIS                                     ,
                        TR_CLASS_APPREC_AIL_FC_LOGBOOK                                    ,
                        TR_CLASS_APPREC_AIL_FC_VIDEO                                      ,
                        TR_CLASS_APPREC_AIL_VD_CAPCTRL                                    ,
                        TR_CLASS_APPREC_AIL_VD_VEHICLE_SENSOR                             ,
                        TR_CLASS_APPREC_AIL_FC_ASSIST                                     ,
                        TR_CLASS_APPREC_AIL_FC_EXTKI                                      ,
                        TR_CLASS_APPREC_AIL_PREDICTIVE_DRIVING                            ,
                        TR_CLASS_APPREC_AIL_VD_EHPROV                                     ,
                        TR_CLASS_APPREC_AIL_FC_CBS                                        ,
                        TR_CLASS_APPREC_AIL_FC_DATAPROVIDER                               ,
                        TR_CLASS_APPREC_AIL_DP_TEST_CLIENT                                ,
                        TR_CLASS_APPREC_AIL_FC_MCAN_METER                                 ,
                        TR_CLASS_APPREC_AIL_FC_TELEMATIC                                  ,
                        TR_CLASS_APPREC_AIL_FC_CANCOMM                                    ,
                        TR_CLASS_APPREC_AIL_AUDIOCUES                                     ,
                        TR_CLASS_APPREC_AIL_ANIMATION                                     ,
                        TR_CLASS_APPREC_AIL_STREAMROUTER                                  ,
                        TR_CLASS_APPREC_AIL_DRVASS_VIDEO_EARLY                            ,
                        TR_CLASS_APPREC_AIL_DRVASS_VIDEO                                  ,
                        TR_CLASS_APPREC_AIL_FAVORITESBACKUP                               ,
                        TR_CLASS_APPREC_AIL_TOUCHDISPLAY                                  ,
                        TR_CLASS_APPREC_AIL_INTERNETAPPLICATIONS                          ,
                        TR_CLASS_APPREC_AIL_INTERNETRADIO                                 ,
                        TR_CLASS_APPREC_AIL_MEDIAPLAYER                                   ,
                        TR_CLASS_APPREC_AIL_IPODAUTH                                      ,
                        TR_CLASS_APPREC_AIL_NAVSTORAGE                                    ,
                        TR_CLASS_APPREC_AIL_LOCATIONBASEDSERVICE                          ,
                        TR_CLASS_APPREC_AIL_NAVCOPY                                       ,
                        TR_CLASS_APPREC_AIL_NAVEXTHMI                                     ,
                        TR_CLASS_APPREC_AIL_BLUETOOTH                                     ,
                        TR_CLASS_APPREC_AIL_MESSAGING                                     ,
                        TR_CLASS_APPREC_AIL_PHONEBOOK                                     ,
                        TR_CLASS_APPREC_AIL_RADIODATA                                     ,
                        TR_CLASS_APPREC_AIL_SAALS                                         ,
                        TR_CLASS_APPREC_AIL_AVMANAGER                                     ,
                        TR_CLASS_APPREC_AIL_NAAGS                                         ,
                        TR_CLASS_APPREC_AIL_IPODCONTROL                                   ,
                        TR_CLASS_APPREC_AIL_AVTESTSERVER                                  ,
                        TR_CLASS_APPREC_AIL_VOLUMECONTROL                                 ,
                        TR_CLASS_APPREC_AIL_TEST_SERVER_A                                 ,
                        TR_CLASS_APPREC_AIL_TEST_SERVER_B                                 ,
                        TR_CLASS_APPREC_AIL_TEST_SERVER_C                                 ,
                        TR_CLASS_APPREC_AIL_TEST_SERVER_D                                 ,
                        TR_CLASS_APPREC_AIL_TEST_CLIENT_A1                                ,
                        TR_CLASS_APPREC_AIL_TEST_CLIENT_A2                                ,
                        TR_CLASS_APPREC_AIL_TEST_CLIENT_A3                                ,
                        TR_CLASS_APPREC_AIL_TEST_CLIENT_A4                                ,
                        TR_CLASS_APPREC_AIL_TEST_CLIENT_B1                                ,
                        TR_CLASS_APPREC_AIL_TEST_CLIENT_B2                                ,
                        TR_CLASS_APPREC_AIL_TEST_CLIENT_B3                                ,
                        TR_CLASS_APPREC_AIL_TEST_CLIENT_B4                                ,
                        TR_CLASS_APPREC_AIL_TEST_CLIENT_C1                                ,
                        TR_CLASS_APPREC_AIL_TEST_CLIENT_C2                                ,
                        TR_CLASS_APPREC_AIL_TEST_CLIENT_C3                                ,
                        TR_CLASS_APPREC_AIL_TEST_CLIENT_C4                                ,
                        TR_CLASS_APPREC_AIL_TEST_CLIENT_D1                                ,
                        TR_CLASS_APPREC_AIL_TEST_CLIENT_D2                                ,
                        TR_CLASS_APPREC_AIL_TEST_CLIENT_D3                                ,
                        TR_CLASS_APPREC_AIL_TEST_CLIENT_D4                                ,
                        TR_CLASS_APPREC_AIL_FC_APP                                        ,
                        TR_CLASS_APPREC_AIL_DIAGLOG                                       ,
                        TR_CLASS_APPREC_AIL_DCM_ADRAMPLIFIER                              ,
                        TR_CLASS_APPREC_AIL_DRVFUNC                                       ,
                        TR_CLASS_APPREC_AIL_AUDIO                                         ,
                        TR_CLASS_APPREC_AIL_TUNER                                         ,
                        TR_CLASS_APPREC_AIL_UI                                            ,
                        TR_CLASS_APPREC_AIL_DCM_AMFMTUNER                                 ,
                        TR_CLASS_APPREC_AIL_SPI                                           ,
                        TR_CLASS_APPREC_AIL_DCM_XMTUNER                                   ,
                        TR_CLASS_APPREC_AIL_MP3                                           ,
                        TR_CLASS_APPREC_AIL_CDVD                                          ,
                        TR_CLASS_APPREC_AIL_CDCVD                                         ,
                        TR_CLASS_APPREC_AIL_DIAGDEBUG                                     ,
                        TR_CLASS_APPREC_AIL_GATEWAY                                       ,
                        TR_CLASS_APPREC_AIL_VOICE_GATEWAY                                 ,
                        TR_CLASS_APPREC_AIL_TMC_GATEWAY                                   ,
                        TR_CLASS_APPREC_AIL_DIAG_GATEWAY                                  ,
                        TR_CLASS_APPREC_AIL_TRCSFWGW                                      ,
                        TR_CLASS_APPREC_AIL_RFD                                           ,
                        TR_CLASS_APPREC_AIL_FC_LBS                                        ,
                        TR_CLASS_APPREC_AIL_TUNERMASTER                                   ,
                        TR_CLASS_APPREC_AIL_CONTEXTMANAGER                                ,
                        TR_CLASS_APPREC_AIL_NAVIFUNC                                      ,
                        TR_CLASS_APPREC_AIL_MAPPREP                                       ,
                        TR_CLASS_APPREC_AIL_AMFM_AUD                                      ,
                        TR_CLASS_APPREC_AIL_ACR_HANDLER                                   ,
                        TR_CLASS_APPREC_AIL_DCM_TUNERMASTER                               ,
                        TR_CLASS_APPREC_AIL_DCM_BROWSER                                   ,
                        TR_CLASS_APPREC_AIL_DCM_IPODCTRL                                  ,
                        TR_CLASS_APPREC_AIL_DCM_PWMAMPLIFIER                              ,
                        TR_CLASS_APPREC_AIL_DCM_AMPLIFIER                                 ,
                        TR_CLASS_APPREC_AIL_DCM_CHIME                                     ,
                        TR_CLASS_APPREC_AIL_DCM_MEDIAPLAYER                               ,
                        TR_CLASS_APPREC_AIL_CONNECTIONMASTER                              ,
                        TR_CLASS_APPREC_AIL_AUDIOMASTER                                   ,
                        TR_CLASS_APPREC_AIL_DCM_PROFILECTRL                               ,
                        TR_CLASS_APPREC_AIL_FCM_CARCUSTOMIZATION                          ,
                        TR_CLASS_APPREC_AIL_FCM_ELECTRONICCLIMATECONTROL                  ,
                        TR_CLASS_APPREC_AIL_FCM_SILVERBOX                                 ,
                        TR_CLASS_APPREC_AIL_FCM_ONSTAR                                    ,
                        TR_CLASS_APPREC_AIL_FCM_UNIVERSALHANDSFREEPHONE                   ,
                        TR_CLASS_APPREC_AIL_FCM_DABTUNER                                  ,
                        TR_CLASS_APPREC_AIL_DCM_ODI_GATEWAY                               ,
                        TR_CLASS_APPREC_AIL_DCM_OPTICAL_DISK                              ,
                        TR_CLASS_APPREC_AIL_DCM_AUDARBITMASTER                            ,
                        TR_CLASS_APPREC_AIL_DCM_PHONE                                     ,
                        TR_CLASS_APPREC_AIL_DCM_PHONE_PROXY                               ,
                        TR_CLASS_APPREC_AIL_DCM_AUD_ARBIT_MASTER                          ,
                        TR_CLASS_APPREC_AIL_DCM_AUX_JACK                                  ,
                        TR_CLASS_APPREC_AIL_DCM_USB                                       ,
                        TR_CLASS_APPREC_AIL_DCM_PDIM                                      ,
                        TR_CLASS_APPREC_AIL_DDL_TEST                                      ,
                        TR_CLASS_APPREC_AIL_MAP_3D                                        ,
                        TR_CLASS_APPREC_AIL_MID_MAP_ENGINE                                ,
                        TR_CLASS_APPREC_AIL_FRAMETEST_NAVI                                ,
                        TR_CLASS_APPREC_AIL_FRAMETEST_MONA                                ,
                        TR_CLASS_APPREC_AIL_FRAMETEST_TIMA                                ,
                        TR_CLASS_APPREC_AIL_STA_SERVER                                    ,
                        TR_CLASS_APPREC_AIL_STA_CLIENT                                    ,
                        TR_CLASS_APPREC_AIL_CSFW_CCA_TEST_CLIENT                          ,
                        TR_CLASS_APPREC_AIL_CSFW_CCA_TEST_SERVER                          ,
                        TR_CLASS_APPREC_AIL_CSFW_CCA_SAMPLE_CLIENT                        ,
                        TR_CLASS_APPREC_AIL_CSFW_CCA_SAMPLE_SERVER                        ,
                        TR_CLASS_APPREC_AIL_DEMO_CLIENT_CORE_1                            ,
                        TR_CLASS_APPREC_AIL_DEMO_SERVER_CORE_1                            ,
                        TR_CLASS_APPREC_AIL_DEMO_CLIENT_CORE_2                            ,
                        TR_CLASS_APPREC_AIL_DEMO_SERVER_CORE_2                            ,
                        TR_CLASS_APPREC_AIL_SDS_VOICE_CONTROL                             ,
                        TR_CLASS_APPREC_AIL_SDS_RECOGNIZER                                ,
                        TR_CLASS_APPREC_AIL_SDS_TTS                                       ,
                        TR_CLASS_APPREC_AIL_SDS_PROMPT_PLAYER                             ,
                        TR_CLASS_APPREC_AIL_SDS_RECORDER                                  ,
                        TR_CLASS_APPREC_AIL_SDS_SPEECH_DATA_PROVIDER                      ,
                        TR_CLASS_APPREC_AIL_SDS_TEST_BASEAPP                              ,
                        TR_CLASS_APPREC_AIL_SDS_TEST_SERVER_BASEAPP                       ,
                        TR_CLASS_APPREC_AIL_ACRHANDLER                                    ,
                        TR_CLASS_APPREC_AIL_TRANSCRIPTIONSERVICE                          ,
                        TR_CLASS_APPREC_AIL_SDS_WRAPPER                                   ,
                        TR_CLASS_APPREC_AIL_SENSOR                                        ,
                        TR_CLASS_APPREC_AIL_MOSTCCAGW                                     ,
                        TR_CLASS_APPREC_AIL_SDS_REMOTE_CLIENT                             ,
                        TR_CLASS_APPREC_AIL_TMC_IP                                        , /* KSM2HI, 25.05.2011 */
                        TR_CLASS_APPREC_AIL_FC_RECORDING                                  , /* KSM2HI, 05.07.2011 */
                        TR_CLASS_APPREC_AIL_FC_MEMNAVIDB                                  , /* KSM2HI, 07.09.2011 */
                        TR_CLASS_APPREC_AIL_MOSTTestServer                                , /* KSM2HI, 10.10.2011 */
                        TR_CLASS_APPREC_AIL_SystemInfo                                    , /* KSM2HI, 10.10.2011 */
                        TR_CLASS_APPREC_AIL_DABDATA                                       , /* KSM2HI, 10.10.2011 */
                        TR_CLASS_APPREC_AIL_BROWSER                                       , /* KSM2HI, 10.10.2011 */
                        TR_CLASS_APPREC_AIL_BROWSER_MEDIA                                 , /* KSM2HI, 10.10.2011 */
                        TR_CLASS_APPREC_AIL_OPERAMINI                                     , /* KSM2HI, 10.10.2011 */
                        TR_CLASS_APPREC_AIL_ACT_SAFETY_DEMO                               , /* KSM2HI, 10.10.2011 */
                        TR_CLASS_APPREC_AIL_FC_BTAUDIO                                    , /* KSM2HI, 10.10.2011 */
                        TR_CLASS_APPREC_AIL_VD_TEM                                        , /* KSM2HI, 10.10.2011 */
                        TR_CLASS_APPREC_AIL_CSB                                           , /* KSM2HI, 10.10.2011 */
                        TR_CLASS_APPREC_AIL_SREC_CTRL                                     , /* KSM2HI, 19.12.2011 */
                        TR_CLASS_APPREC_AIL_NAV_RNW_ACCESS_TEST                           , /* KSM2HI, 19.12.2011 */
                        TR_CLASS_APPREC_AIL_VD_COMMUNITY_TELEMATICS                       , /* KSM2HI, 17.01.2012 */
                        TR_CLASS_APPREC_AIL_FC_PROFILER                                   , /* KSM2HI, 24.01.2012 */
                        TR_CLASS_APPREC_AIL_FC_WIFISETTINGS                               , /* KSM2HI, 13.02.2012 */
                        TR_CLASS_APPREC_AIL_FC_AUDIO_ROUTE_MGR                            , /* KSM2HI, 29.02.2012 */
                        TR_CLASS_APPREC_AIL_FC_DIVA_SERVER                                , /* KSM2HI, 29.02.2012 */
                        TR_CLASS_APPREC_AIL_CCA_TEST_MANAGER                              , /* KSM2HI, 02.03.2012 */
                        TR_CLASS_APPREC_AIL_FC_SXM                                        , /* KSM2HI, 07.05.2012 */
                        TR_CLASS_APPREC_AIL_SMARTPHONEINTEGRATION                         , /* KSM2HI, 07.05.2012 */
                        TR_CLASS_APPREC_AIL_FC_INFOSCOUT                                  , /* KSM2HI, 07.06.2012 */
                        TR_CLASS_APPREC_AIL_CATALOGUE                                     , /* KSM2HI, 18.06.2012 */
                        TR_CLASS_APPREC_AIL_FC_MCAN_TCU                                   , /* KMR2HI, 05.07.2012 */
                        TR_CLASS_APPREC_AIL_SDS_TESTAPP                                   , /* KSM2HI, 19.07.2012 */
                        TR_CLASS_APPREC_AIL_SD_REFRESH                                    , /* KSM2HI, 07.01.2013 */
                        TR_CLASS_APPREC_AIL_FC_TPEG                                       , /* KSM2HI, 15.02.2013 */
                        TR_CLASS_APPREC_AIL_FC_TRAFFIC                                    , /* KSM2HI, 20.03.2013 */
                        TR_CLASS_APPREC_AIL_HMI_01                                        , /* KSM2HI, 13.05.2013 */
                        TR_CLASS_APPREC_AIL_HMI_02                                        , /* KSM2HI, 13.05.2013 */
                        TR_CLASS_APPREC_AIL_HMI_03                                        , /* KSM2HI, 13.05.2013 */
                        TR_CLASS_APPREC_AIL_HMI_04                                        , /* KSM2HI, 13.05.2013 */
                        TR_CLASS_APPREC_AIL_HMI_05                                        , /* KSM2HI, 13.05.2013 */
                        TR_CLASS_APPREC_AIL_HMI_06                                        , /* KSM2HI, 13.05.2013 */
                        TR_CLASS_APPREC_AIL_HMI_07                                        , /* KSM2HI, 13.05.2013 */
                        TR_CLASS_APPREC_AIL_HMI_08                                        , /* KSM2HI, 13.05.2013 */
                        TR_CLASS_APPREC_AIL_HMI_09                                        , /* KSM2HI, 13.05.2013 */
                        TR_CLASS_APPREC_AIL_HMI_10                                        , /* KSM2HI, 13.05.2013 */
                        TR_CLASS_APPREC_AIL_HMI_11                                        , /* KSM2HI, 13.05.2013 */
                        TR_CLASS_APPREC_AIL_HMI_12                                        , /* KSM2HI, 13.05.2013 */
                        TR_CLASS_APPREC_AIL_HMI_13                                        , /* KSM2HI, 13.05.2013 */
                        TR_CLASS_APPREC_AIL_HMI_14                                        , /* KSM2HI, 13.05.2013 */
                        TR_CLASS_APPREC_AIL_HMI_15                                        , /* KSM2HI, 13.05.2013 */
                        TR_CLASS_APPREC_AIL_APPLICATION_MANAGER                           , /* KSM2HI, 03.06.2013 */
                        TR_CLASS_APPREC_AIL_SETTING_APPLICATION                           , /* KSM2HI, 03.06.2013 */
                        TR_CLASS_APPREC_AIL_RSE                                           , /* KSM2HI, 03.06.2013 */
                        TR_CLASS_APPREC_AIL_CCA_INC_ADAPTER                               , /* KSM2HI, 07.06.2013 */ 
                        TR_CLASS_APPREC_AIL_NAVI_SRV                                      , /* KSM2HI, 05.08.2013 */ 
                        TR_CLASS_APPREC_AIL_FC_FILEMANAGER                                , /* KSM2HI, 05.08.2013 */ 
                        TR_CLASS_APPREC_AIL_MULTIMEDIA                                    , /* KSM2HI, 05.08.2013 */ 
                        TR_CLASS_APPREC_AIL_HVAC                                          , /* KSM2HI, 05.08.2013 */ 
                        TR_CLASS_APPREC_AIL_SPEECH_UI                                     , /* KSM2HI, 05.08.2013 */ 
                        TR_CLASS_APPREC_AIL_HMI_SYSTEM_SETTING                            , /* KSM2HI, 05.08.2013 */ 
                        TR_CLASS_APPREC_AIL_CAR_SETTING                                   , /* KSM2HI, 05.08.2013 */ 
                        TR_CLASS_APPREC_AIL_HOME_SCREEN                                   , /* KSM2HI, 05.08.2013 */ 
                        TR_CLASS_APPREC_AIL_FC_LANGUAGECHANGE                             , /* KSM2HI, 12.08.2013 */ 
                        TR_CLASS_APPREC_AIL_ASF_TUNER                                     , /* KSM2HI, 09.09.2013 */ 
                        TR_CLASS_APPREC_AIL_ASF_MEDIAPLAYER                               , /* KSM2HI, 09.09.2013 */ 
                        TR_CLASS_APPREC_AIL_NAVI_HMI                                      , /* KSM2HI, 26.09.2013 */ 
                        TR_CLASS_APPREC_AIL_SPM_TEST_ADAPTOR                              , /* KSM2HI, 18.10.2013 */ 
                        TR_CLASS_APPREC_AIL_FC_USB_TCU                                    , /* KSM2HI, 18.10.2013 */ 
                        TR_CLASS_APPREC_AIL_IPSIM                                         , /* KSM2HI, 18.10.2013 */ 
                        TR_CLASS_APPREC_AIL_HMI_TUNER                                     , /* KSM2HI, 04.11.2013 */ 
                        TR_CLASS_APPREC_AIL_HMI_ENGINEERING_MODE                          , /* KSM2HI, 04.11.2013 */ 
                        TR_CLASS_APPREC_AIL_HMI_DRIVER_ASSISTANCE                         , /* KSM2HI, 04.11.2013 */ 
                        TR_CLASS_APPREC_AIL_HMI_BTPHONE                                   , /* KSM2HI, 04.11.2013 */ 
                        TR_CLASS_APPREC_AIL_HMI_DIAGNOSTICS                               , /* KSM2HI, 04.11.2013 */ 
                        TR_CLASS_APPREC_AIL_HMI_STATUSBAR                                 , /* KSM2HI, 04.11.2013 */ 
                        TR_CLASS_APPREC_AIL_HMI_AUDIOAPP                                  , /* KSM2HI, 04.11.2013 */ 
                        TR_CLASS_APPREC_AIL_FC_SW_UPDATE                                  , /* KSM2HI, 18.11.2013 */ 
                        TR_CLASS_APPREC_AIL_FC_TRAFFICINFOPROVIDER                        , /* KSM2HI, 25.11.2013 */ 
                        TR_CLASS_APPREC_AIL_TIP_TEST_CLIENT                               , /* KSM2HI, 25.11.2013 */ 
                        TR_CLASS_APPREC_AIL_VD_VIDEO_CAMERA                               , /* KSM2HI, 12.12.2013 */ 
                        TR_CLASS_APPREC_AIL_VD_RVC_EARLY                                  , /* KSM2HI, 12.12.2013 */ 
                        TR_CLASS_APPREC_AIL_SPICCADBUSADAPTER                             , /* KSM2HI, 12.12.2013 */ 
                        TR_CLASS_APPREC_AIL_FC_VIDEOMANAGER                               , /* KSM2HI, 04.02.2014 */ 
                        TR_CLASS_APPREC_AIL_FC_BTREMOTECONTROL                            , /* KSM2HI, 04.02.2014 */ 
                        TR_CLASS_APPREC_AIL_MP_TEST_ADAPTOR                               , /* KSM2HI, 12.02.2014 */ 
                        TR_CLASS_APPREC_AIL_PHN_TEST_ADAPTOR                              , /* KSM2HI, 12.02.2014 */ 
                        TR_CLASS_APPREC_AIL_PHNBK_TEST_ADAPTOR                            , /* KSM2HI, 12.02.2014 */ 
                        TR_CLASS_APPREC_AIL_BT_TEST_ADAPTOR                               , /* KSM2HI, 12.02.2014 */ 
                        TR_CLASS_APPREC_AIL_MSG_TEST_ADAPTOR                              , /* KSM2HI, 12.02.2014 */ 
                        TR_CLASS_APPREC_AIL_WIFI_TEST_ADAPTOR                             , /* KSM2HI, 12.02.2014 */ 
                        TR_CLASS_APPREC_AIL_TUN_TEST_ADAPTOR                              , /* KSM2HI, 12.02.2014 */ 
                        TR_CLASS_APPREC_AIL_TUNMSTR_TEST_ADAPTOR                          , /* KSM2HI, 12.02.2014 */ 
                        TR_CLASS_APPREC_AIL_DAB_TEST_ADAPTOR                              , /* KSM2HI, 12.02.2014 */ 
                        TR_CLASS_APPREC_AIL_FC_AUX                                        , /* KSM2HI, 14.04.2014 */ 
                        TR_CLASS_APPREC_AIL_MP_MOST_TEST_ADAPTOR                          , /* KSM2HI, 28.04.2014 */ 
                        TR_CLASS_APPREC_AIL_FC_CDPLAYER                                   , /* KSM2HI, 28.04.2014 */ 
                        TR_CLASS_APPREC_AIL_FC_DATASERVICES                               , /* KSM2HI, 29.04.2014 */ 
                        TR_CLASS_APPREC_AIL_FC_BTDEVICEMANAGER                            , /* KSM2HI, 23.05.2014 */ 
                        TR_CLASS_APPREC_AIL_FC_REAR_VC                                    , /* KSM2HI, 23.07.2014 */ 
                        TR_CLASS_APPREC_AIL_VD_INPUT                                      , /* KSM2HI, 11.09.2014 */ 
                        TR_CLASS_APPREC_AIL_HIT                                           , /* KSM2HI, 11.09.2014 */ 
                        TR_CLASS_APPREC_AIL_DVDPLAYER                                     , /* KSM2HI, 26.09.2014 */ 
                        TR_CLASS_APPREC_AIL_SWITCH_GW                                     , /* KSM2HI, 26.09.2014 */ 
                        TR_CLASS_APPREC_AIL_ACL_SPI                                       , /* KSM2HI, 17.10.2014 */ 
                        TR_CLASS_APPREC_AIL_ACL_PHONE                                     , /* KSM2HI, 10.11.2014 */ 
                        TR_CLASS_APPREC_AIL_ACL_CONNECTIVITY                              , /* KSM2HI, 10.11.2014 */ 
                        TR_CLASS_APPREC_AIL_GENIVIAUDIO                                   , /* KSM2HI, 19.01.2015 */ 
                        TR_CLASS_APPREC_AIL_FC_USERMANAGER                                , /* KSM2HI, 02.02.2015 */ 
                        TR_CLASS_APPREC_AIL_OTA                                           , /* KSM2HI, 02.02.2015 */ 
                        TR_CLASS_APPREC_AIL_OTA_CCA                                       , /* KSM2HI, 02.02.2015 */ 
                        TR_CLASS_APPREC_AIL_FC_CONNECT                                    , /* KSM2HI, 24.02.2015 */ 
                        TR_CLASS_APPREC_AIL_SCREENTEST                                    , /* KSM2HI, 27.03.2015 */ 
                        TR_CLASS_APPREC_AIL_FC_PARKASSIST                                 , /* KSM2HI, 27.03.2015 */ 
                        TR_CLASS_APPREC_AIL_EXPORTSERVICE                                 , /* KSM2HI, 27.03.2015 */ 
                        TR_CLASS_APPREC_AIL_FC_VEHFUNCMASTER                              , /* KSM2HI, 27.03.2015 */ 
                        TR_CLASS_APPREC_AIL_KEYHANDLER                                    , /* KSM2HI, 15.04.2015 */ 
                        TR_CLASS_APPREC_AIL_FC_USB                                        , /* KSM2HI, 17.04.2015 */ 
                        TR_CLASS_APPREC_AIL_DATACOLLECTOR                                 , /* KSM2HI, 05.05.2015 */ 
                        TR_CLASS_APPREC_AIL_LEARNDATACOMM                                 , /* KSM2HI, 05.06.2015 */ 
                        TR_CLASS_APPREC_AIL_GENERIC_PROXY                                 , /* KSM2HI, 29.07.2015 */ 
                        TR_CLASS_APPREC_AIL_DISPLAYMANAGER                                , /* KSM2HI, 29.07.2015 */ 
                        TR_CLASS_APPREC_AIL_PV                                            , /* KSM2HI, 29.07.2015 */ 
                        TR_CLASS_APPREC_AIL_FC_SPEECH_AUDIO                               , /* KSM2HI, 11.08.2015 */ 
                        TR_CLASS_APPREC_AIL_SMARTAPP                                      , /* KSM2HI, 11.08.2015 */ 
                        TR_CLASS_APPREC_AIL_FC_EXT_DRV                                    , /* KSM2HI, 11.08.2015 */ 
                        TR_CLASS_APPREC_AIL_FC_VP2_PARKASSIST                             , /* KSM2HI, 17.09.2015 */ 
                        TR_CLASS_APPREC_AIL_FC_VPAS_PARKASSIST                            , /* KSM2HI, 17.09.2015 */ 
                        TR_CLASS_APPREC_AIL_FC_ATB                                        , /* KSM2HI, 30.09.2015 */ 
                        TR_CLASS_APPREC_AIL_FC_SERVICEMGR                                 , /* KSM2HI, 30.09.2015 */ 
                        TR_CLASS_APPREC_AIL_FC_MAPUPDATE                                  , /* KSM2HI, 21.10.2015 */ 
                        TR_CLASS_APPREC_AIL_ACL_UPDATE                                    , /* KSM2HI, 02.11.2015 */ 
                        TR_CLASS_APPREC_AIL_MNDB_TEST_CLIENT                              , /* KSM2HI, 13.01.2016 */ 
                        TR_CLASS_APPREC_AIL_ASF_AUDIOMASTER                               , /* KSM2HI, 04.03.2016 */ 
                        TR_CLASS_APPREC_AIL_LCM_CCA_DBUS_GATEWAY                          , /* KSM2HI, 04.03.2016 */ 
                        TR_CLASS_APPREC_AIL_FC_EXT_KI                                     , /* KSM2HI, 15.03.2016 */ 
                        TR_CLASS_APPREC_AIL_NAVI_3RD_PARTY                                , /* KSM2HI, 22.03.2016 */ 
                        TR_CLASS_APPREC_AIL_FC_DTV                                        , /* KSM2HI, 22.07.2016 */ 
                        TR_CLASS_APPREC_AIL_FC_TPEGDB                                     , /* KSM2HI, 31.08.2016 */ 
                        TR_CLASS_APPREC_AIL_CAREASYAPPS                                   , /* KSM2HI, 22.09.2016 */ 
                        TR_CLASS_APPREC_AIL_LCM_DBUS_CLIENT                               , /* KSM2HI, 22.09.2016 */ 
                        TR_CLASS_APPREC_AIL_FC_VIDEOPOSITIONSUPPORT                       , /* KSM2HI, 30.09.2016 */ 
                        TR_CLASS_APPREC_AIL_WPV                                           , /* KSM2HI, 05.10.2016 */ 
                        TR_CLASS_APPREC_AIL_FC_DUMM                                       , /* KSM2HI, 27.10.2016 */ 
                        TR_CLASS_APPREC_AIL_FD_THERMAL_MGMT                               , /* KSM2HI, 11.11.2016 */ 
                        TR_CLASS_APPREC_AIL_FD_SUPPLY_MGMT                                , /* KSM2HI, 11.11.2016 */ 
                        TR_CLASS_APPREC_AIL_FD_PWR_MASTER                                 , /* KSM2HI, 11.11.2016 */ 
                        TR_CLASS_APPREC_AIL_FD_SYSTEM_SM                                  , /* KSM2HI, 11.11.2016 */ 
                        TR_CLASS_APPREC_AIL_AUTO_DRIVE                                    , /* KSM2HI, 07.12.2016 */ 
                        TR_CLASS_APPREC_AIL_VIDEO_MANAGER                                 , /* KSM2HI, 07.12.2016 */ 
                        TR_CLASS_APPREC_AIL_WEBPORTAL                                     , /* KSM2HI, 07.12.2016 */ 
                        TR_CLASS_APPREC_AIL_RMT_APP_CTRL                                  , /* KSM2HI, 22.12.2016 */ 
                        TR_CLASS_APPREC_AIL_SUGGESTION_AND_NOTIFICATION_MANAGER           , /* KSM2HI, 20.01.2017 */ 
                        TR_CLASS_APPREC_AIL_FC_STC                                        , /* KSM2HI, 10.03.2017 */ 
                        TR_CLASS_APPREC_AIL_TEST_SERVER_E                                 , /* KSM2HI, 21.06.2017 */ 
                        TR_CLASS_APPREC_AIL_EARLYWPVCONFIG                                , /* KSM2HI, 21.06.2017 */ 
                        TR_CLASS_APPREC_AIL_SUGGESTION_AND_NOTIFICATION_PUSHMESSAGE_PROXY , /* KSM2HI, 04.07.2017 */ 
                        TR_CLASS_APPREC_AIL_SUGGESTION_AND_NOTIFICATION_ACTIONHANDLER     , /* KSM2HI, 04.07.2017 */ 
                        TR_CLASS_APPREC_AIL_USER_REMOTE_SYNC_CTRL                         , /* KSM2HI, 07.12.2017 */ 
                        TR_CLASS_APPREC_AIL_SEAMLESS_PAIRING_IPCM                         , /* KSM2HI, 15.12.2017 */ 
                        TR_CLASS_APPREC_AIL_VALET_MODE_MANAGER                            , /* KSM2HI, 26.01.2018 */ 
                        TR_CLASS_APPREC_AIL_WIFI_BUSINESS_LOGIC                           , /* KSM2HI, 23.03.2018 */ 
                        TR_CLASS_APPREC_AIL_FC_EXT_MEDIA_IN                               , /* KSM2HI, 31.01.2019 */ 
                        TR_CLASS_APPREC_AIL_FC_SXM_360L                                     /* KSM2HI, 06.02.2019 */ 

  /*  ||===============>                                             */
  /*  ||                                                             */
  /*  ||                                                             */
  /*                                                                 */
  /* To guarantee downward compatibility for the ApplicationRecorder */
  /* new applications must be added at the END of this enumeration.  */

};

enum ail_TraceClassSrvRec
{
                        TR_CLASS_SRVREC_AIL_DIAGNOSIS = TR_COMP_SRVREC + 1             ,
                        TR_CLASS_SRVREC_AIL_HANDLE_DIAGNOSIS                           ,
                        TR_CLASS_SRVREC_AIL_REPORT_MEMORY                              ,
                        TR_CLASS_SRVREC_AIL_SBS_LISTMATCHING                           ,
                        TR_CLASS_SRVREC_AIL_DVD_MGNT                                   ,
                        TR_CLASS_SRVREC_AIL_TRAFFIC_MESSAGE_TELEMATIC                  ,
                        TR_CLASS_SRVREC_AIL_RESOURCE_INFORMATION                       ,
                        TR_CLASS_SRVREC_AIL_RAW_DATA                                   ,
                        TR_CLASS_SRVREC_AIL_LOCATION_INPUT                             ,
                        TR_CLASS_SRVREC_AIL_SBS_SUPPORT                                ,
                        TR_CLASS_SRVREC_AIL_NAVI                                       ,
                        TR_CLASS_SRVREC_AIL_SENSORS                                    ,
                        TR_CLASS_SRVREC_AIL_TRAFFIC_MESSAGE_PRESENTATION               ,
                        TR_CLASS_SRVREC_AIL_TRAFFIC_MESSAGE_DATA                       ,
                        TR_CLASS_SRVREC_AIL_TRAFFIC_MESSAGE_BROADCAST                  ,
                        TR_CLASS_SRVREC_AIL_VOICE                                      ,
                        TR_CLASS_SRVREC_AIL_TMC_LIST_DATA                              ,
                        TR_CLASS_SRVREC_AIL_DAPI_ROADNETWORK                           ,
                        TR_CLASS_SRVREC_AIL_DAPI_ARCHIVE                               ,
                        TR_CLASS_SRVREC_AIL_RDD                                        ,
                        TR_CLASS_SRVREC_AIL_NAVI_INTERNAL                              ,
                        TR_CLASS_SRVREC_AIL_ARCHIVE_CONTROL                            ,
                        TR_CLASS_SRVREC_AIL_LIM                                        ,
                        TR_CLASS_SRVREC_AIL_RC_ENGINEERING                             ,
                        TR_CLASS_SRVREC_AIL_MCNET_MANAGEMENT                           ,
                        TR_CLASS_SRVREC_AIL_DESTMEM_MANAGEMENT                         ,
                        TR_CLASS_SRVREC_AIL_RG_ENGINEERING                             ,
                        TR_CLASS_SRVREC_AIL_RTF                                        ,
                        TR_CLASS_SRVREC_AIL_POSITION                                   ,
                        TR_CLASS_SRVREC_AIL_GUIDANCE                                   ,
                        TR_CLASS_SRVREC_AIL_SENSORS_IERROR                             ,
                        TR_CLASS_SRVREC_AIL_OBN                                        ,
                        TR_CLASS_SRVREC_AIL_DAPI_ARCHIVE_INTERN                        ,
                        TR_CLASS_SRVREC_AIL_MAP_INTERNAL                               ,
                        TR_CLASS_SRVREC_AIL_EDM_ENGINEERING                            ,
                        TR_CLASS_SRVREC_AIL_VR_HMI                                     ,
                        TR_CLASS_SRVREC_AIL_FASTMAP                                    ,
                        TR_CLASS_SRVREC_AIL_VD_DIMMING                                 ,
                        TR_CLASS_SRVREC_AIL_TELEFON                                    ,
                        TR_CLASS_SRVREC_AIL_SINA_ENGINEERING                           ,
                        TR_CLASS_SRVREC_AIL_HEATCTRL                                   ,
                        TR_CLASS_SRVREC_AIL_SECURITY                                   ,
                        TR_CLASS_SRVREC_AIL_ROUTECALCULATION                           ,
                        TR_CLASS_SRVREC_AIL_EDM_INTERNAL                               ,
                        TR_CLASS_SRVREC_AIL_TMC_TUNER                                  ,
                        TR_CLASS_SRVREC_AIL_AUXCTRL_EXTBOX                             ,
                        TR_CLASS_SRVREC_AIL_TEA                                        ,
                        TR_CLASS_SRVREC_AIL_UAM                                        ,
                        TR_CLASS_SRVREC_AIL_WEATHER                                    ,
                        TR_CLASS_SRVREC_AIL_WEATHER_TUNER                              ,
                        TR_CLASS_SRVREC_AIL_WDB_INTERNAL                               ,
                        TR_CLASS_SRVREC_AIL_CLIMATE_CONTROL                            ,
                        TR_CLASS_SRVREC_AIL_CLOCK                                      ,
                        TR_CLASS_SRVREC_AIL_STATISTICS                                 ,
                        TR_CLASS_SRVREC_AIL_EXT_VR                                     ,
                        TR_CLASS_SRVREC_AIL_MDI                                        ,
                        TR_CLASS_SRVREC_AIL_PHONE_GENERAL                              ,
                        TR_CLASS_SRVREC_AIL_PHONE_AUDIO                                ,
                        TR_CLASS_SRVREC_AIL_REGION_SELECTION                           ,
                        TR_CLASS_SRVREC_AIL_REGION_KNITTER                             ,
                        TR_CLASS_SRVREC_AIL_TUNERSYNC                                  ,
                        TR_CLASS_SRVREC_AIL_VEHICLE_DATA                               ,
                        TR_CLASS_SRVREC_AIL_OPS                                        ,
                        TR_CLASS_SRVREC_AIL_RVC                                        ,
                        TR_CLASS_SRVREC_AIL_CHIME                                      ,
                        TR_CLASS_SRVREC_AIL_IPOD                                       ,
                        TR_CLASS_SRVREC_AIL_ADASIS                                     ,
                        TR_CLASS_SRVREC_AIL_NAVREPEATER                                ,
                        TR_CLASS_SRVREC_AIL_MEDIAPLAYER_EXTBOX                         ,
                        TR_CLASS_SRVREC_AIL_TUNER_EXTBOX                               ,
                        TR_CLASS_SRVREC_AIL_VEHICLEFUNCTION_EXTBOX                     ,
                        TR_CLASS_SRVREC_AIL_AUDIO_EXTBOX                               ,
                        TR_CLASS_SRVREC_AIL_XM_TUNER                                   ,
                        TR_CLASS_SRVREC_AIL_TEA_ENGINEERING                            ,
                        TR_CLASS_SRVREC_AIL_UPS                                        ,
                        TR_CLASS_SRVREC_AIL_PHONE_NDI                                  ,
                        TR_CLASS_SRVREC_AIL_REMOTE_CLIENT                              ,
                        TR_CLASS_SRVREC_AIL_MCAN_PHONE                                 ,
                        TR_CLASS_SRVREC_AIL_VEHICLE_CONFIG                             ,
                        TR_CLASS_SRVREC_AIL_LOGBOOK                                    ,
                        TR_CLASS_SRVREC_AIL_MDB_ENGINEERING                            ,
                        TR_CLASS_SRVREC_AIL_TSD                                        ,
                        TR_CLASS_SRVREC_AIL_VEHICLE_SENSOR                             ,
                        TR_CLASS_SRVREC_AIL_ASSIST                                     ,
                        TR_CLASS_SRVREC_AIL_DAPI_POI                                   ,
                        TR_CLASS_SRVREC_AIL_PREDICTIVE_DRIVING                         ,
                        TR_CLASS_SRVREC_AIL_DIAGLOG                                    ,
                        TR_CLASS_SRVREC_AIL_DIAGLIB                                    ,
                        TR_CLASS_SRVREC_AIL_DIAG_DEFSET                                ,
                        TR_CLASS_SRVREC_AIL_DAB_TUNER                                  ,
                        TR_CLASS_SRVREC_AIL_DAB_MECA                                   ,
                        TR_CLASS_SRVREC_AIL_SPM                                        ,
                        TR_CLASS_SRVREC_AIL_CONTEXTMANAGER                             ,
                        TR_CLASS_SRVREC_AIL_AUDIOFUNC                                  ,
                        TR_CLASS_SRVREC_AIL_TUNERCONTROL                               ,
                        TR_CLASS_SRVREC_AIL_SPI                                        ,
                        TR_CLASS_SRVREC_AIL_CDVD                                       ,
                        TR_CLASS_SRVREC_AIL_MP3                                        ,
                        TR_CLASS_SRVREC_AIL_DIAGDEBUG                                  ,
                        TR_CLASS_SRVREC_AIL_DOWNLOAD                                   ,
                        TR_CLASS_SRVREC_AIL_GATEWAY                                    ,
                        TR_CLASS_SRVREC_AIL_SPI_RADIO                                  ,
                        TR_CLASS_SRVREC_AIL_SPI_KEYBOARD                               ,
                        TR_CLASS_SRVREC_AIL_SPI_DISPLAY                                ,
                        TR_CLASS_SRVREC_AIL_NAVIFUNC_NAVI                              ,
                        TR_CLASS_SRVREC_AIL_NAVIFUNC_SENSOR                            ,
                        TR_CLASS_SRVREC_AIL_NAVIFUNC_TIMA                              ,
                        TR_CLASS_SRVREC_AIL_DRVFUNC_CDC                                ,
                        TR_CLASS_SRVREC_AIL_DRVFUNC_CD                                 ,
                        TR_CLASS_SRVREC_AIL_AUDIO_SRC                                  ,
                        TR_CLASS_SRVREC_AIL_UIDIAG                                     ,
                        TR_CLASS_SRVREC_AIL_MAPCTRL                                    ,
                        TR_CLASS_SRVREC_AIL_AUDIODIAG                                  ,
                        TR_CLASS_SRVREC_AIL_TUNERDIAG                                  ,
                        TR_CLASS_SRVREC_AIL_DDL_TEST                                   ,
                        TR_CLASS_SRVREC_AIL_AMFM_AUD                                   ,
                        TR_CLASS_SRVREC_AIL_AUDIO_DIAG                                 ,
                        TR_CLASS_SRVREC_AIL_AMFM_AUD_TUN                               ,
                        TR_CLASS_SRVREC_AIL_AMFM_AUD_AUD                               ,
                        TR_CLASS_SRVREC_AIL_AMFM_AUD_DAB                               ,
                        TR_CLASS_SRVREC_AIL_KBD                                        ,
                        TR_CLASS_SRVREC_AIL_MMGR                                       ,
                        TR_CLASS_SRVREC_AIL_CLUSTER                                    ,
                        TR_CLASS_SRVREC_AIL_CAPCTRL                                    ,
                        TR_CLASS_SRVREC_AIL_EXTKI                                      ,
                        TR_CLASS_SRVREC_AIL_HMI                                        ,
                        TR_CLASS_SRVREC_AIL_VIDEO                                      ,
                        TR_CLASS_SRVREC_AIL_SDS_VOICE_CONTROL                          ,
                        TR_CLASS_SRVREC_AIL_SDS_RECOGNIZER                             ,
                        TR_CLASS_SRVREC_AIL_SDS_TTS                                    ,
                        TR_CLASS_SRVREC_AIL_SDS_PROMPT_PLAYER                          ,
                        TR_CLASS_SRVREC_AIL_SDS_RECORDER                               ,
                        TR_CLASS_SRVREC_AIL_SDS_SPEECH_DATA_PROVIDER                   ,
                        TR_CLASS_SRVREC_AIL_SDS_TEST_BASEAPP                           ,
                        TR_CLASS_SRVREC_AIL_ACR                                        ,
                        TR_CLASS_SRVREC_AIL_MAP_3D_CTRL                                ,
                        TR_CLASS_SRVREC_AIL_FRAMETEST_ADDITIONAL_TEST_SERVICE          ,
                        TR_CLASS_SRVREC_AIL_FRAMETEST_TEST_SERVICE                     ,
                        TR_CLASS_SRVREC_AIL_CSFW_CCA_TEST_SERVICE                      ,
                        TR_CLASS_SRVREC_AIL_CSFW_CCA_SAMPLE_SERVICE                    ,
                        TR_CLASS_SRVREC_AIL_DEMO_MESSAGE_SERVICE                       , 
                        TR_CLASS_SRVREC_AIL_MOSTCCAGWSERVICE                           , 
                        TR_CLASS_SRVREC_AIL_DATA_ACCESS                                , /* BRU2HI, 11.05.2010 */
                        TR_CLASS_SRVREC_AIL_MCAN_METER                                 , /* BRU2HI, 11.05.2010 */
                        TR_CLASS_SRVREC_AIL_FB_ALERTMANAGER                            , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_FB_AMPLIFIER                               , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_FB_AMTUNER                                 , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_FB_AUDIOCUES                               , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_FB_AUDIODISKPLAYER                         , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_FB_AVMANAGER                               , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_FB_AUXILIARYINPUTJACK                      , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_FB_BLUETOOTHSETTINGS                       , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_FB_CENTERSTACKHMI                          , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_FB_CUSTOMIZATIONBCM                        , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_FB_CUSTOMIZATIONDOORSLOCKS                 , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_FB_CUSTOMIZATIONECC                        , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_FB_CUSTOMIZATIONIPC                        , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_FB_CUSTOMIZATIONMEMORYSETTINGS             , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_FB_CUSTOMIZATIONOBJECTCOMPUTATIONSETTINGS  , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_FB_CUSTOMIZATIONPA                         , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_FB_CUSTOMIZATIONSBZA                       , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_FB_DABTUNER                                , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_FB_DEVELOPMENTSCREENCLIENT                 , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_FB_ENHANCEDTESTABILITY                     , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_FB_FAVORITESBACKUPMANAGER                  , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_FB_FAVORITESMANAGER                        , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_FB_FMTUNER                                 , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_FB_GMLANGATEWAY                            , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_FB_HEADPHONE                               , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_FB_HVACSETTINGS                            , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_FB_ICSCONTROLS                             , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_FB_INTERNETAPPLICATIONS                    , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_FB_INTERNETRADIO                           , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_FB_LVMINTERFACE                            , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_FB_MEDIAPLAYER                             , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_FB_MESSAGING                               , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_FB_MICROPHONEINPUT                         , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_FB_NAVIGATION                              , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_FB_NETBLOCK                                , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_FB_NETBLOCK_TIMINGMASTER                   , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_FB_NETWORKMASTER                           , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_FB_ONSTARAUDIO                             , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_FB_ONSTARDATASETTINGS                      , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_FB_ONSTARPERSONALCALLING                   , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_FB_ONSTARTBTNAVIGATION                     , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_FB_PHONEBOOK                               , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_FB_PROGRAMMINGMASTER                       , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_FB_SDARS                                   , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_FB_SPEECHHMI                               , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_FB_SYSTEMSTATE                             , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_FB_TELEPHONE                               , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_FB_TEXTTOSPEECH                            , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_FB_AUXTOUCHSCREEN                          , /* BRU2HI, 08.06.2010 */
                        TR_CLASS_SRVREC_AIL_FB_DOWNLOAD                                , /* BRU2HI, 08.06.2010 */
                        TR_CLASS_SRVREC_AIL_FB_GPS                                     , /* BRU2HI, 08.06.2010 */
                        TR_CLASS_SRVREC_AIL_ANIMATION                                  , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_STREAMROUTER                               , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_DRVASS_VIDEO_EARLY                         , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_DRVASS_VIDEO                               , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_TOUCHDISPLAY                               , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_IPODAUTH                                   , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_IPOD_PANDORA                               , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_NAVSTORAGE                                 , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_LOCATIONBASEDSERVICE                       , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_NAVCOPY                                    , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_NAV_EXTENDED                               , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_RADIODATA_WEATHER                          , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_RADIODATA_TRAFFIC                          , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_RADIODATA_LOCATIONBASEDSERVICES            , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_RADIODATA_RELIABLEFILE                     , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_SAAL                                       , /* BRU2HI, 01.06.2010 */
                        TR_CLASS_SRVREC_AIL_SDS_TRANSCRIPTIONSERVICE                   , /* BRU2HI, 20.07.2010 */
                        TR_CLASS_SRVREC_AIL_SDS_VOCONSERVICE                           , /* BRU2HI, 20.07.2010 */
                        TR_CLASS_SRVREC_AIL_SDS_WRAPPER                                , /* BRU2HI, 20.07.2010 */
                        TR_CLASS_SRVREC_AIL_DATA_LOADER                                , /* BRU2HI, 20.07.2010 */
                        TR_CLASS_SRVREC_AIL_DATA_RESOURCE_MANAGER                      , /* BRU2HI, 20.07.2010 */
                        TR_CLASS_SRVREC_AIL_TELEMATIC                                  , /* BRU2HI, 20.07.2010 */
                        TR_CLASS_SRVREC_AIL_WEB_SEARCH                                 , /* BRU2HI, 03.08.2010 */
                        TR_CLASS_SRVREC_AIL_RADIODATA_MOVIE                            , /* BRU2HI, 03.08.2010 */
                        TR_CLASS_SRVREC_AIL_RADIODATA_FUEL                             , /* BRU2HI, 03.08.2010 */
                        TR_CLASS_SRVREC_AIL_RADIODATA_SONGTAG                          , /* BRU2HI, 03.08.2010 */
                        TR_CLASS_SRVREC_AIL_RADIODATA_DLPLUS                           , /* BRU2HI, 03.08.2010 */
                        TR_CLASS_SRVREC_AIL_FB_RSEPLAYER                               , /* BRU2HI, 17.08.2010 */
                        TR_CLASS_SRVREC_AIL_FB_SPEECHRECOGNITIONTESTSERVER             , /* BRU2HI, 17.08.2010 */
                        TR_CLASS_SRVREC_AIL_DEMO_SERVICE_CORE_1                        , /* KSM2HI, 29.09.2010 */
                        TR_CLASS_SRVREC_AIL_DEMO_SERVICE_CORE_2                        , /* KSM2HI, 29.09.2010 */
                        TR_CLASS_SRVREC_AIL_DEVICEMANAGER                              , /* KSM2HI, 18.10.2010 */
                        TR_CLASS_SRVREC_AIL_SPM_SLV                                    , /* KSM2HI, 18.10.2010 */
                        TR_CLASS_SRVREC_AIL_PDC                                        , /* KSM2HI, 18.10.2010 */
                        TR_CLASS_SRVREC_AIL_FB_ICSCONTROLS_2                           , /* KSM2HI, 08.11.2010 */
                        TR_CLASS_SRVREC_AIL_FB_SDARS_2                                 , /* KSM2HI, 08.11.2010 */
                        TR_CLASS_SRVREC_AIL_FB_FMTUNER_2                               , /* KSM2HI, 08.11.2010 */
                        TR_CLASS_SRVREC_AIL_FMWORKER_INTERNAL                          , /* KSM2HI, 26.11.2010 */
                        TR_CLASS_SRVREC_AIL_SYNC_AUDIO                                 , /* KSM2HI, 30.11.2010 */
                        TR_CLASS_SRVREC_AIL_SYNC_DISPLAY                               , /* KSM2HI, 30.11.2010 */
                        TR_CLASS_SRVREC_AIL_VD_TOUCH                                   , /* KSM2HI, 15.12.2010 */
                        TR_CLASS_SRVREC_AIL_INTERACTIONLOGGER                          , /* KSM2HI, 22.12.2010 */
                        TR_CLASS_SRVREC_AIL_NAAGS                                      , /* KSM2HI, 22.12.2010 */
                        TR_CLASS_SRVREC_AIL_IPODCONTROL                                , /* KSM2HI, 18.01.2011 */
                        TR_CLASS_SRVREC_AIL_AVTESTSERVER                               , /* KSM2HI, 18.01.2011 */
                        TR_CLASS_SRVREC_AIL_VOLUMECONTROL                              , /* KSM2HI, 18.01.2011 */
                        TR_CLASS_SRVREC_AIL_FB_CLUSTERHMI                              , /* KSM2HI, 27.01.2011 */
                        TR_CLASS_SRVREC_AIL_TMC_TUNER_CTRL                             , /* KSM2HI, 10.02.2011 */
                        TR_CLASS_SRVREC_AIL_FB_DEVELOPMENTSCREENCLIENT_2               , /* KSM2HI, 21.02.2011 */
                        TR_CLASS_SRVREC_AIL_FB_DEVELOPMENTSCREENCLIENT_INTERNAL        , /* KSM2HI, 21.02.2011 */
                        TR_CLASS_SRVREC_AIL_HMI_LAYER_SYNC                             , /* KSM2HI, 21.02.2011 */
                        TR_CLASS_SRVREC_AIL_HMI_GESTURE                                , /* KSM2HI, 21.02.2011 */
                        TR_CLASS_SRVREC_AIL_RFD                                        , /* KSM2HI, 10.03.2011 */
                        TR_CLASS_SRVREC_AIL_FB_DEVELOPMENTSCREENCLIENT_3               , /* KSM2HI, 30.03.2011 */
                        TR_CLASS_SRVREC_AIL_FUELPRICES                                 , /* KSM2HI, 30.03.2011 */
                        TR_CLASS_SRVREC_AIL_MOVIETIMES                                 , /* KSM2HI, 30.03.2011 */
                        TR_CLASS_SRVREC_AIL_TEST_A                                     , /* KSM2HI, 31.03.2011 */
                        TR_CLASS_SRVREC_AIL_TEST_B                                     , /* KSM2HI, 31.03.2011 */
                        TR_CLASS_SRVREC_AIL_TEST_C                                     , /* KSM2HI, 31.03.2011 */
                        TR_CLASS_SRVREC_AIL_TEST_D                                     , /* KSM2HI, 31.03.2011 */
                        TR_CLASS_SRVREC_AIL_IPOD_APP                                   , /* KSM2HI, 28.04.2011 */
                        TR_CLASS_SRVREC_AIL_APP_PANDORA                                , /* KSM2HI, 06.05.2011 */
                        TR_CLASS_SRVREC_AIL_IPOD_APP_CONTROL                           , /* KSM2HI, 13.05.2011 */
                        TR_CLASS_SRVREC_AIL_TUNERMASTERCONTROL                         , /* KSM2HI, 25.05.2011 */
                        TR_CLASS_SRVREC_AIL_FB_TOUCHPAD                                , /* KSM2HI, 30.05.2011 */
                        TR_CLASS_SRVREC_AIL_FB_WIFISETTINGS                            , /* KSM2HI, 30.05.2011 */
                        TR_CLASS_SRVREC_AIL_RECORDING                                  , /* KSM2HI, 05.07.2011 */
                        TR_CLASS_SRVREC_AIL_SPEECHSETTINGS                             , /* KSM2HI, 06.07.2011 */
                        TR_CLASS_SRVREC_AIL_DAPI_DEVICEMANAGER                         , /* KSM2HI, 02.08.2011 */
                        TR_CLASS_SRVREC_AIL_PDIM                                       , /* KSM2HI, 07.09.2011 */
                        TR_CLASS_SRVREC_AIL_CANCOMM                                    , /* KSM2HI, 07.09.2011 */
                        TR_CLASS_SRVREC_AIL_LEARNING_DATA                              , /* KSM2HI, 07.09.2011 */
                        TR_CLASS_SRVREC_AIL_TRACK_DATA_STORAGE                         , /* KSM2HI, 07.09.2011 */
                        TR_CLASS_SRVREC_AIL_GEOGRAPHIC_REFERENCE                       , /* KSM2HI, 07.09.2011 */
                        TR_CLASS_SRVREC_AIL_FB_MICROPHONEINPUT_2                       , /* KSM2HI, 15.09.2011 */
                        TR_CLASS_SRVREC_AIL_MOSTTestServer                             , /* KSM2HI, 10.10.2011 */
                        TR_CLASS_SRVREC_AIL_MOSTFilter                                 , /* KSM2HI, 10.10.2011 */
                        TR_CLASS_SRVREC_AIL_DAB_DATA                                   , /* KSM2HI, 10.10.2011 */
                        TR_CLASS_SRVREC_AIL_BROWSER                                    , /* KSM2HI, 10.10.2011 */
                        TR_CLASS_SRVREC_AIL_BROWSER_MEDIA                              , /* KSM2HI, 10.10.2011 */
                        TR_CLASS_SRVREC_AIL_APP_OPERAMINI                              , /* KSM2HI, 10.10.2011 */
                        TR_CLASS_SRVREC_AIL_APP_ACT_SAFETY_DEMO                        , /* KSM2HI, 10.10.2011 */
                        TR_CLASS_SRVREC_AIL_FC_BTAUDIO                                 , /* KSM2HI, 10.10.2011 */
                        TR_CLASS_SRVREC_AIL_VD_TEM                                     , /* KSM2HI, 10.10.2011 */
                        TR_CLASS_SRVREC_AIL_APP_CSB                                    , /* KSM2HI, 10.10.2011 */
                        TR_CLASS_SRVREC_AIL_RADIODATA_IDU                              , /* KSM2HI, 21.11.2011 */
                        TR_CLASS_SRVREC_AIL_SREC_CTRL                                  , /* KSM2HI, 19.12.2011 */
                        TR_CLASS_SRVREC_AIL_COMMUNITY_TELEMATICS                       , /* KSM2HI, 17.01.2012 */
                        TR_CLASS_SRVREC_AIL_COMMUNITY_MANAGEMENT                       , /* KSM2HI, 17.01.2012 */
                        TR_CLASS_SRVREC_AIL_PROFILERSERVICE                            , /* KSM2HI, 24.01.2012 */
                        TR_CLASS_SRVREC_AIL_AUDIO_ROUTE_MGR                            , /* KSM2HI, 29.02.2012 */
                        TR_CLASS_SRVREC_AIL_DIVA_SERVER                                , /* KSM2HI, 29.02.2012 */
                        TR_CLASS_SRVREC_AIL_APPINFO                                    , /* KSM2HI, 02.03.2012 */
                        TR_CLASS_SRVREC_AIL_AUD_SRC_ROUTE                              , /* KSM2HI, 07.05.2012 */
                        TR_CLASS_SRVREC_AIL_SXM_AUDIO                                  , /* KSM2HI, 07.05.2012 */
                        TR_CLASS_SRVREC_AIL_SXM_FUEL                                   , /* KSM2HI, 07.05.2012 */
                        TR_CLASS_SRVREC_AIL_SXM_GRAPHICAL_WEATHER                      , /* KSM2HI, 07.05.2012 */
                        TR_CLASS_SRVREC_AIL_SXM_TABULAR_WEATHER                        , /* KSM2HI, 07.05.2012 */
                        TR_CLASS_SRVREC_AIL_SXM_SPORTS                                 , /* KSM2HI, 07.05.2012 */
                        TR_CLASS_SRVREC_AIL_SXM_STOCKS                                 , /* KSM2HI, 07.05.2012 */
                        TR_CLASS_SRVREC_AIL_SXM_MOVIES                                 , /* KSM2HI, 07.05.2012 */
                        TR_CLASS_SRVREC_AIL_SMARTPHONEINTEGRATION                      , /* KSM2HI, 07.05.2012 */
                        TR_CLASS_SRVREC_AIL_INFOSCOUT                                  , /* KSM2HI, 07.06.2012 */
                        TR_CLASS_SRVREC_AIL_SXM_TRAFFIC                                , /* KSM2HI, 18.06.2012 */
                        TR_CLASS_SRVREC_AIL_SXM_SAFETY_CAMERA                          , /* KSM2HI, 18.06.2012 */
                        TR_CLASS_SRVREC_AIL_CATALOGUE                                  , /* KSM2HI, 18.06.2012 */
                        TR_CLASS_SRVREC_AIL_SXM_CHANNEL_ART                            , /* KSM2HI, 18.06.2012 */
                        TR_CLASS_SRVREC_AIL_POI                                        , /* KSM2HI, 18.06.2012 */
                        TR_CLASS_SRVREC_AIL_MCAN_TCU                                   , /* KMR2HI, 05.07.2012 */
                        TR_CLASS_SRVREC_AIL_SDS_TESTAPP                                , /* KSM2HI, 19.07.2012 */
                        TR_CLASS_SRVREC_AIL_CHKSUM                                     , /* KSM2HI, 03.01.2013 */
                        TR_CLASS_SRVREC_AIL_SD_REFRESH_CLIENT                          , /* KSM2HI, 07.01.2013 */
                        TR_CLASS_SRVREC_AIL_FC_TPEG                                    , /* KSM2HI, 15.02.2013 */
                        TR_CLASS_SRVREC_AIL_RSE                                        , /* KSM2HI, 03.06.2013 */
                        TR_CLASS_SRVREC_AIL_CAN_PROXY                                  , /* KSM2HI, 03.06.2013 */
                        TR_CLASS_SRVREC_AIL_FB_DEVICEPROJECTION                        , /* KSM2HI, 12.07.2013 */
                        TR_CLASS_SRVREC_AIL_LANGUAGECHANGE                             , /* KSM2HI, 12.08.2013 */
                        TR_CLASS_SRVREC_AIL_POS_ENGINEERING                            , /* KSM2HI, 09.09.2013 */
                        TR_CLASS_SRVREC_AIL_POI_HANDLER                                , /* KSM2HI, 26.09.2013 */
                        TR_CLASS_SRVREC_AIL_USB_TCU                                    , /* KSM2HI, 18.11.2013 */
                        TR_CLASS_SRVREC_AIL_IPSIM                                      , /* KSM2HI, 18.11.2013 */
                        TR_CLASS_SRVREC_AIL_TRAFFIC_INFORMATION                        , /* KSM2HI, 25.11.2013 */
                        TR_CLASS_SRVREC_AIL_VIDEO_CAMERA                               , /* KSM2HI, 12.12.2013 */
                        TR_CLASS_SRVREC_AIL_RVC_EARLY                                  , /* KSM2HI, 12.12.2013 */
                        TR_CLASS_SRVREC_AIL_BTREMOTECONTROL                            , /* KSM2HI, 04.02.2014 */
                        TR_CLASS_SRVREC_AIL_SENSOR_LOCATION                            , /* KSM2HI, 12.02.2014 */
                        TR_CLASS_SRVREC_AIL_AUX                                        , /* KSM2HI, 14.04.2014 */
                        TR_CLASS_SRVREC_AIL_CDPLAYER                                   , /* KSM2HI, 28.04.2014 */
                        TR_CLASS_SRVREC_AIL_DATASERVICES                               , /* KSM2HI, 29.04.2014 */
                        TR_CLASS_SRVREC_AIL_BTDEVICEMANAGER                            , /* KSM2HI, 23.05.2014 */
                        TR_CLASS_SRVREC_AIL_DP_DB_ACCESS                               , /* KSM2HI, 21.07.2014 */
                        TR_CLASS_SRVREC_AIL_REAR_VC                                    , /* KSM2HI, 23.07.2014 */
                        TR_CLASS_SRVREC_AIL_VD_INPUT                                   , /* KSM2HI, 11.09.2014 */
                        TR_CLASS_SRVREC_AIL_HIT                                        , /* KSM2HI, 11.09.2014 */
                        TR_CLASS_SRVREC_AIL_DVDPLAYER                                  , /* KSM2HI, 26.09.2014 */
                        TR_CLASS_SRVREC_AIL_SWITCH_GW                                  , /* KSM2HI, 26.09.2014 */
                        TR_CLASS_SRVREC_AIL_ACL_SPI                                    , /* KSM2HI, 17.10.2014 */
                        TR_CLASS_SRVREC_AIL_ADVANCEDPARKASSIST                         , /* KSM2HI, 16.12.2014 */
                        TR_CLASS_SRVREC_AIL_OTA                                        , /* KSM2HI, 02.02.2015 */
                        TR_CLASS_SRVREC_AIL_PARKASSIST                                 , /* KSM2HI, 27.03.2015 */
                        TR_CLASS_SRVREC_AIL_SXM_WEATHER_ALERTS                         , /* KSM2HI, 27.03.2015 */
                        TR_CLASS_SRVREC_AIL_SXM_CANADIAN_FUEL                          , /* KSM2HI, 27.03.2015 */
                        TR_CLASS_SRVREC_AIL_SXM_PARKING                                , /* KSM2HI, 27.03.2015 */
                        TR_CLASS_SRVREC_AIL_DATACOLLECTOR                              , /* KSM2HI, 30.04.2015 */
                        TR_CLASS_SRVREC_AIL_LEARNDATACOMM                              , /* KSM2HI, 05.06.2015 */
                        TR_CLASS_SRVREC_AIL_SXM_PHONETICS                              , /* KSM2HI, 01.07.2015 */
                        TR_CLASS_SRVREC_AIL_GENERIC_PROXY                              , /* KSM2HI, 29.07.2015 */
                        TR_CLASS_SRVREC_AIL_PV                                         , /* KSM2HI, 29.07.2015 */
                        TR_CLASS_SRVREC_AIL_CONNECT_TRAFFIC                            , /* KSM2HI, 29.07.2015 */
                        TR_CLASS_SRVREC_AIL_EXT_DRV                                    , /* KSM2HI, 11.08.2015 */
                        TR_CLASS_SRVREC_AIL_MAPUPDATE                                  , /* KSM2HI, 21.10.2015 */
                        TR_CLASS_SRVREC_AIL_FC_EXT_KI                                  , /* KSM2HI, 15.03.2016 */
                        TR_CLASS_SRVREC_AIL_NAVI_3RD_PARTY                             , /* KSM2HI, 22.03.2016 */
                        TR_CLASS_SRVREC_AIL_VEHICLEFUNCTION_SR_EXTBOX                  , /* KSM2HI, 30.03.2016 */
                        TR_CLASS_SRVREC_AIL_VEHICLEFUNCTION_MEX_EXTBOX                 , /* KSM2HI, 30.03.2016 */
                        TR_CLASS_SRVREC_AIL_VEHICLEFUNCTION_EV_EXTBOX                  , /* KSM2HI, 30.03.2016 */
                        TR_CLASS_SRVREC_AIL_VEHICLEFUNCTION_DRV_ASST_EXTBOX            , /* KSM2HI, 30.03.2016 */
                        TR_CLASS_SRVREC_AIL_VEHICLEFUNCTION_CLIMATE_EXTBOX             , /* KSM2HI, 30.03.2016 */
                        TR_CLASS_SRVREC_AIL_VEHICLEFUNCTION_HVAC_EXTBOX                , /* KSM2HI, 30.03.2016 */
                        TR_CLASS_SRVREC_AIL_VEHICLEFUNCTION_TPMS_EXTBOX                , /* KSM2HI, 30.03.2016 */
                        TR_CLASS_SRVREC_AIL_VEHICLEFUNCTION_CLINOMETER_EXTBOX          , /* KSM2HI, 30.03.2016 */
                        TR_CLASS_SRVREC_AIL_VEHICLEFUNCTION_DRV_ECO_EXTBOX             , /* KSM2HI, 30.03.2016 */
                        TR_CLASS_SRVREC_AIL_VEHICLEFUNCTION_RES_EXTBOX                 , /* KSM2HI, 30.03.2016 */
                        TR_CLASS_SRVREC_AIL_VEHICLEFUNCTION_AIR_QTY_EXTBOX             , /* KSM2HI, 30.03.2016 */
                        TR_CLASS_SRVREC_AIL_VEHICLEFUNCTION_BODY_EQP_EXTBOX            , /* KSM2HI, 30.03.2016 */
                        TR_CLASS_SRVREC_AIL_CONNECT                                    , /* KSM2HI, 04.07.2016 */
                        TR_CLASS_SRVREC_AIL_CONNECT_TPEG                               , /* KSM2HI, 31.08.2016 */
                        TR_CLASS_SRVREC_AIL_TPEGDATA                                   , /* KSM2HI, 31.08.2016 */
                        TR_CLASS_SRVREC_AIL_USERMANAGER                                , /* KSM2HI, 01.09.2016 */
                        TR_CLASS_SRVREC_AIL_LCM_DBUS_CLIENT                            , /* KSM2HI, 22.09.2016 */
                        TR_CLASS_SRVREC_AIL_FC_VIDEOPOSITIONSUPPORT                    , /* KSM2HI, 30.09.2016 */
                        TR_CLASS_SRVREC_AIL_VEHICLEFUNCTION_DRV_COMP_EXTBOX            , /* KSM2HI, 05.10.2016 */
                        TR_CLASS_SRVREC_AIL_VEHICLEFUNCTION_DRV_ASST_PIVI_EXTBOX       , /* KSM2HI, 05.10.2016 */
                        TR_CLASS_SRVREC_AIL_VEHICLEFUNCTION_HUD_EXTBOX                 , /* KSM2HI, 05.10.2016 */
                        TR_CLASS_SRVREC_AIL_VEHICLEFUNCTION_MAIN_INFO_EXTBOX           , /* KSM2HI, 05.10.2016 */
                        TR_CLASS_SRVREC_AIL_VEHICLEFUNCTION_HVAC_PIVI_EXTBOX           , /* KSM2HI, 05.10.2016 */
                        TR_CLASS_SRVREC_AIL_WPV                                        , /* KSM2HI, 05.10.2016 */
                        TR_CLASS_SRVREC_AIL_FC_DUMM                                    , /* KSM2HI, 27.10.2016 */
                        TR_CLASS_SRVREC_AIL_FD_THERMAL_MGMT                            , /* KSM2HI, 11.11.2016 */
                        TR_CLASS_SRVREC_AIL_FD_SUPPLY_MGMT                             , /* KSM2HI, 11.11.2016 */
                        TR_CLASS_SRVREC_AIL_FD_PWR_MASTER                              , /* KSM2HI, 11.11.2016 */
                        TR_CLASS_SRVREC_AIL_FD_SYSTEM_SM                               , /* KSM2HI, 11.11.2016 */
                        TR_CLASS_SRVREC_AIL_CONNECT_MAP                                , /* KSM2HI, 28.11.2016 */
                        TR_CLASS_SRVREC_AIL_AUTO_DRIVE                                 , /* KSM2HI, 07.12.2016 */
                        TR_CLASS_SRVREC_AIL_VIDEO_MANAGER                              , /* KSM2HI, 07.12.2016 */
                        TR_CLASS_SRVREC_AIL_TPEGSIMULATION                             , /* KSM2HI, 15.12.2016 */
                        TR_CLASS_SRVREC_AIL_SEAMLESS_PAIRING_IPCM                      , /* KSM2HI, 15.12.2016 */
                        TR_CLASS_SRVREC_AIL_MEDIA_CONTENT_SHARING                      , /* KSM2HI, 09.01.2019 */
                        TR_CLASS_SRVREC_AIL_FC_EXT_MEDIA_IN                              /* KSM2HI, 31.01.2019 */

  /*  ||===============>                                         */
  /*  ||                                                         */
  /*  ||                                                         */
  /*                                                             */
  /* To guarantee downward compatibility for the ServiceRecorder */
  /* new services must be added at the END of this enumeration.  */

};

typedef struct
{
  tU16  u16AppOrSrvId;
  tU16  u16TraceClass;
} rAppOrSrvToTraceClassRef;

/*******************************************************************************
| variable declaration (scope: global)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| function prototypes (scope: global)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
 *FUNCTION:    ail_bInitAilTrace()  
 *DESCRIPTION: Does all initialization for AIL_TRACE 
 *PARAMETER:   none 
 *                
 *                
 *RETURNVALUE: tBool 
 *             TRUE = getting success
 *
 *HISTORY:
 *18.02.2001 Initial Version  
 ******************************************************************************/
 tBool ail_bInitAilTrace(tVoid);

 
/*******************************************************************************
 *FUNCTION:    ail_vExitAilTrace()  
 *DESCRIPTION: Does all initialization for AIL_TRACE 
 *PARAMETER:   none 
 *                
 *                
 *RETURNVALUE: none 
 *
 *HISTORY:
 *18.02.2001 Initial Version  
 ******************************************************************************/
 tVoid ail_vExitAilTrace(tVoid);


/*******************************************************************************
 *FUNCTION:    ail_vTraceMsg
 *DESCRIPTION: Trace Message to OSAL-Trace-Device
 *PARAMETER:   TR_tenTraceLevel        enTraceLevel ( I )
 *                trace level according to trace concept
 *             tPChar                  pcFormatString ( ->I )         
 *                buffer to prepare character output string,
 *                must be located on callers user stack
 *             ...
 *                
 *RETURNVALUE: tVoid
 *
 *HISTORY:
 *26.02.2003 Initial Version  
 ******************************************************************************/
 tVoid ail_vTraceMsg( TR_tenTraceLevel enTraceLevel, const tChar *coszFormatString, ... );

/*******************************************************************************
 *FUNCTION:    ail_vTraceClassMsg
 *DESCRIPTION: Trace Message to OSAL-Trace-Device
 *PARAMETER:   TR_tenTraceClass        enTraceClass ( I )
 *                trace class according to trace concept
 *             TR_tenTraceLevel        enTraceLevel ( I )
 *                trace level according to trace concept
 *             tPChar                  pcFormatString ( ->I )         
 *                buffer to prepare character output string,
 *                must be located on callers user stack
 *             ...
 *                
 *RETURNVALUE: tVoid
 *
 *HISTORY:
 *26.02.2003 Initial Version  
 ******************************************************************************/
 tVoid ail_vTraceClassMsg( TR_tenTraceClass enTraceClass, TR_tenTraceLevel enTraceLevel, const tChar *coszFormatString, ... );

/*******************************************************************************
 *FUNCTION:    ail_vTraceHexMsg
 *DESCRIPTION: Trace Message to OSAL-Trace-Device
 *PARAMETER:   TR_tenTraceClass  enTraceClass   ( ->I )
 *                trace class according to trace concept
 *             TR_tenTraceLevel  enTraceLevel ( ->I )
 *                trace level according to trace concept
 *             tU32                    u32DumpBufferSize ( I )         
 *                size of buffer to be converted to hex-ascii-msg
 *             tPCU8                   pcu8DumpBuffer ( ->I )         
 *                pointer to buffer to be converted to hex-ascii-msg
 *             tPChar                  pcFormatString ( ->I )         
 *                buffer to prepare character output string,
 *                must be located on callers user stack
 *             ...
 *                
 *RETURNVALUE: tVoid
 *
 *HISTORY:
 *26.02.2003 Initial Version  
 ******************************************************************************/
 tVoid ail_vTraceHexMsg( TR_tenTraceClass enTraceClass, TR_tenTraceLevel enTraceLevel, tBool bForceUnlimitedRequest, tU32 u32DumpBufferSize, tPCU8 pcou8DumpBuffer, const tChar *coszFormatString, ... );

tBool ail_bIsCcaRecorderTraceClassActive
(
  rAppOrSrvToTraceClassRef arAppOrSrvToTraceClassRef[],
  tU16 u16NumberOfElements,
  TR_tenTraceClass& rf_enTraceClass, 
  TR_tenTraceLevel enTraceLevel, 
  tU16 u16AppOrSrvId
);

/*******************************************************************************
 *FUNCTION:    ail_bIsTraceActive
 *DESCRIPTION: Checks for activated AIL TraceLevel
 *PARAMETER:   TR_tenTraceLevel        enTraceLevel ( ->I )
 *                trace level to check
 *                
 *RETURNVALUE: tBool
 *             TRUE:  activated
 *             FALSE: not activated
 *
 *HISTORY:
 *14.09.2005 Initial Version  
 ******************************************************************************/
 tBool ail_bIsTraceActive( TR_tenTraceLevel enTraceLevel );

/*******************************************************************************
 *FUNCTION:    ail_bIsTraceClassActive
 *DESCRIPTION: Checks for activated TraceClass and TraceLevel
 *PARAMETER:   TR_tenTraceClass        enTraceClass ( ->I )
 *                trace class to check
 *             TR_tenTraceLevel        enTraceLevel ( ->I )
 *                trace level to check
 *                
 *RETURNVALUE: tBool
 *             TRUE:  activated
 *             FALSE: not activated
 *
 *HISTORY:
 *14.09.2005 Initial Version  
 ******************************************************************************/
 tBool ail_bIsTraceClassActive( TR_tenTraceClass enTraceClass, TR_tenTraceLevel enTraceLevel );

tVoid ail_vTraceCcaMessage(amt_tclBaseMessage* poMessage, tU8 u8Direction, tU32 u32Prio);

extern  tS32 ail_s32RefCount;

#ifdef __cplusplus
}
#endif

#endif /* AIL_TRACE_HEADER */
