/******************************************************************************
 * FILE:          ail_services.h         
 * SW-COMPONENT:  AIL
 * DESCRIPTION:   contains all known services in VASCO projects
 * AUTHOR:        EFG32-Brunke
 * COPYRIGHT:     (c) 2001 Robert Bosch GmbH, Hildesheim
 * HISTORY:      
 ******************************************************************************/

#ifndef AIL_SERVICES_HEADER
#define AIL_SERVICES_HEADER

                   // Version defines for offered service CCA_C_U16_SRV_APPINFO
#define AIL_C_U16_FI_MAJOR_VERSION_SERVICE_APPINFO                            1
#define AIL_C_U16_FI_MINOR_VERSION_SERVICE_APPINFO                            0

/******************************************************************************
| includes of component-internal interface, if necessary
| (scope: component-local)
|-----------------------------------------------------------------------------*/

#define SY_APP_ID_FC_NAVI           CCA_C_U16_APP_NAVI
#define SY_APP_ID_FC_TIMA           CCA_C_U16_APP_TIMA
#define SY_APP_ID_VD_SENSOR         CCA_C_U16_APP_SENSOR
#define SY_APP_ID_FC_DATA_SERVER    CCA_C_U16_APP_DATA_SERVER
#define SY_APP_ID_TMC_FI            CCA_C_U16_APP_TMC
#define SY_APP_ID_FCVD_VOICE        CCA_C_U16_APP_VOICE

/******************************************************************************
| defines and macros (scope: global)
|-----------------------------------------------------------------------------*/


/******************************************************************************
| typedefs (scope: global)
|-----------------------------------------------------------------------------*/

/* above folling service numbers are allowed for vasco projects */
typedef enum                        
{                                   
   AIL_C_U16_SRV_DIAGNOSIS                      = CCA_C_U16_SRV_DIAGNOSIS,
   AIL_C_U16_SRV_HANDLE_DIAGNOSIS               = CCA_C_U16_SRV_HANDLE_DIAGNOSIS,
   AIL_C_U16_SRV_REPORT_MEMORY                  = CCA_C_U16_SRV_REPORT_MEMORY,
   AIL_C_U16_SRV_SBS_LISTMATCHING               = CCA_C_U16_SRV_SBS_LISTMATCHING,
   AIL_C_U16_SRV_DVD_MGNT                       = CCA_C_U16_SRV_DVD_MGNT,
   AIL_C_U16_SRV_TRAFFIC_MESSAGE_TELEMATIC      = CCA_C_U16_SRV_TRAFFIC_MESSAGE_TELEMATIC,
   AIL_C_U16_SRV_RESOURCE_INFORMATION           = CCA_C_U16_SRV_RESOURCE_INFORMATION,
   AIL_C_U16_SRV_RAW_DATA                       = CCA_C_U16_SRV_RAW_DATA,
   AIL_C_U16_SRV_LOCATION_INPUT                 = CCA_C_U16_SRV_LOCATION_INPUT,
   AIL_C_U16_SRV_SBS_SUPPORT                    = CCA_C_U16_SRV_SBS_SUPPORT,    
   AIL_C_U16_SRV_NAVI                           = CCA_C_U16_SRV_NAVI,
   AIL_C_U16_SRV_SENSORS                        = CCA_C_U16_SRV_SENSORS,
   AIL_C_U16_SRV_TRAFFIC_MESSAGE_PRESENTATION   = CCA_C_U16_SRV_TRAFFIC_MESSAGE_PRESENTATION,
   AIL_C_U16_SRV_TRAFFIC_MESSAGE_DATA           = CCA_C_U16_SRV_TRAFFIC_MESSAGE_DATA,
   AIL_C_U16_SRV_TRAFFIC_MESSAGE_BROADCAST      = CCA_C_U16_SRV_TRAFFIC_MESSAGE_BROADCAST,
   AIL_C_U16_SRV_VOICE                          = CCA_C_U16_SRV_VOICE, // Service zur Sprachdatenhaltung und deren Ausgabe
   AIL_C_U16_SRV_TMC_LIST_DATA                  = CCA_C_U16_SRV_TMC_LIST_DATA,
   AIL_C_U16_SRV_DAPI_ROADNETWORK               = CCA_C_U16_SRV_DAPI_ROADNETWORK, // zur Verarbeitung von Straendaten
   AIL_C_U16_SRV_DAPI_ARCHIVE                   = CCA_C_U16_SRV_DAPI_ARCHIVE // zur Einlagerung von Daten in ein Archiv (->Korridor)
} ail_tenService;


/*******************************************************************************
| variable declaration (scope: global)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| function prototypes (scope: global)
|-----------------------------------------------------------------------------*/


#endif


