/******************************************************************************
 * FILE: ail_config.h         
 * SW-COMPONENT:  AIL
 * DESCRIPTION:  
 * AUTHOR:        
 * COPYRIGHT:     (c) 2001 Robert Bosch GmbH, Hildesheim
 * HISTORY:      
 ******************************************************************************/

#ifndef AIL_CONFIG_HEADER
#define AIL_CONFIG_HEADER

#ifdef __cplusplus
extern "C"{
#endif

/******************************************************************************
| includes of component-internal interface, if necessary
| (scope: component-local)
|-----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|-----------------------------------------------------------------------------*/

// TR_CLASS_AIL                 TR_COMP_CCA + 0 = 0x8B00
// TR_CLASS_SCD                 TR_COMP_CCA + 1 = 0x8B01
// TR_CLASS_AMT                 TR_COMP_CCA + 2 = 0x8B02
// TR_CLASS_AHL_CCA_EXTENSION   TR_COMP_CCA + 3 = 0x8B03
#define TR_CLASS_AIL                       ((TR_tenTraceClass)(TR_COMP_CCA + 0))

// enables trace on each power and application status messages (Level USER_1 oder component) 
#define AIL_MESSAGE_TRACE_POWER_MESSAGES

// enables trace on each service registration and status messages (Level USER_2) 
#define AIL_MESSAGE_TRACE_SVC_MESSAGES

// enables trace on each service data messages (Level USER_3)
#define AIL_MESSAGE_TRACE_SVC_DATA_MESSAGES 

// enables trace on each post, send and broadcast (Level USER_4)
#define AIL_MESSAGE_TRACE_EACH_MESSAGE

// enables message- and message-size counter 
// the output of this informations can requested by TTFIS 
//#define AIL_MESSAGE_COUNTER_ENABLED

// enables the traceoutput function for application info (only on request)
// this define could also be used by applications to check if the framework contains
// this functionality
#define AIL_DEBUG_APPLICATION

// The default implementation of the AIL drops the message queue handles to other
// applications as soon as there is no service registrations left to this application.
// Unfortunately dropping a message queue handle can lead to the issue that such a
// message queue handle can be dropped while the function OSAL_s32MessageQueuePost()
// is just being executed and has already passed the check for a valid message queue
// handle. While the function OSAL_s32MessageQueuePost() is executed from an AIL
// body thread or an AIL worker thread, a context switch to the AIL entry thread can
// lead to a drop of the message queue handle which is currently in use by the
// OSAL_s32MessageQueuePost() function from the other thread context. When to context
// switches back to the interrupted execution of OSAL_s32MessageQueuePost() the
// operation continues on an already closed message queue handle which finally leads
// to an exception.
//
// The below feature deactivates the dropping of message queue handles to other applications
// and keeps them ready for use until the own application is terminated. Only on termination
// of the own application the message queue handles to other applications are dropped.
#define AIL_KEEP_MSG_QUEUE_HANDLES_TO_OTHER_APPS_UNTIL_TERMINATION

/* -------------------------------------------------------------------------------- */
/* CCA message priority definition. See CCA services spec chapter 10, CCA messages. */
/* -------------------------------------------------------------------------------- */

/* Prio = 0 */
#define AIL_C_U32_CCA_PRIO_MSG_POWER                        OSAL_C_U32_MQUEUE_PRIORITY_HIGHEST

/* Prio = 1 */
#define AIL_C_U32_CCA_PRIO_MSG_SERVICE_CONFIRMATION         (OSAL_C_U32_MQUEUE_PRIORITY_HIGHEST + 1) // response
#define AIL_C_U32_CCA_PRIO_MSG_SERVICE_STATUS               (OSAL_C_U32_MQUEUE_PRIORITY_HIGHEST + 1) // response
#define AIL_C_U32_CCA_PRIO_MSG_SERVICE_SUPPLIER_STATUS      (OSAL_C_U32_MQUEUE_PRIORITY_HIGHEST + 1) // response
#define AIL_C_U32_CCA_PRIO_MSG_APPLICATION_INFO_STATUS      (OSAL_C_U32_MQUEUE_PRIORITY_HIGHEST + 1) // response

/* Prio = 2 */
#define AIL_C_U32_CCA_PRIO_MSG_SERVICE_REGISTER             (OSAL_C_U32_MQUEUE_PRIORITY_HIGHEST + 2) // query
#define AIL_C_U32_CCA_PRIO_MSG_SERVICE_UNREGISTER           (OSAL_C_U32_MQUEUE_PRIORITY_HIGHEST + 2) // query
#define AIL_C_U32_CCA_PRIO_MSG_SERVICE_SUPPLIER_REGISTER    (OSAL_C_U32_MQUEUE_PRIORITY_HIGHEST + 2) // query
#define AIL_C_U32_CCA_PRIO_MSG_SERVICE_SUPPLIER_UNREGISTER  (OSAL_C_U32_MQUEUE_PRIORITY_HIGHEST + 2) // query
#define AIL_C_U32_CCA_PRIO_MSG_APPLICATION_INFO_REGISTER    (OSAL_C_U32_MQUEUE_PRIORITY_HIGHEST + 2) // query
#define AIL_C_U32_CCA_PRIO_MSG_APPLICATION_INFO_UNREGISTER  (OSAL_C_U32_MQUEUE_PRIORITY_HIGHEST + 2) // query

/* Prio = 3 */

/* Prio = 4 */

/* Prio = 5 */
#define AIL_C_U32_CCA_PRIO_MSG_SERVICE_DATA_SERVER_HIGH     (OSAL_C_U32_MQUEUE_PRIORITY_HIGHEST + 5) // response
#define AIL_C_U32_CCA_PRIO_MSG_SERVICE_DATA_CLIENT_HIGH     (OSAL_C_U32_MQUEUE_PRIORITY_HIGHEST + 5) // query

/* Prio = 6 */

/* Prio = 7 */
#define AIL_C_U32_CCA_PRIO_MSG_SERVICE_DATA_SERVER          (OSAL_C_U32_MQUEUE_PRIORITY_HIGHEST + 7) // response
#define AIL_C_U32_CCA_PRIO_MSG_SERVICE_DATA_CLIENT          (OSAL_C_U32_MQUEUE_PRIORITY_HIGHEST + 7) // query
#define AIL_C_U32_CCA_PRIO_MSG_DEBUG_APPLICATION            (OSAL_C_U32_MQUEUE_PRIORITY_HIGHEST + 7) // query

/******************************************************************************
| typedefs (scope: global)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| variable declaration (scope: global)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| function prototypes (scope: global)
|-----------------------------------------------------------------------------*/

#ifdef __cplusplus
}
#endif

#endif


