//## begin module%1.4%.codegen_version preserve=yes
//   Read the documentation to learn more about C++ code generator
//   versioning.
//## end module%1.4%.codegen_version

//## begin module%3EF2CCB102E8.cm preserve=no
//	  %X% %Q% %Z% %W%
//## end module%3EF2CCB102E8.cm

//## begin module%3EF2CCB102E8.cp preserve=no
//## end module%3EF2CCB102E8.cp

//## Module: ail_Watchdog%3EF2CCB102E8; Subprogram specification
//## Subsystem: Ail::Include%3A841A9E02B0
//## Source file: e:\vasco\components\Ail\Include\ail_Watchdog.h

#ifndef ail_Watchdog_h
#define ail_Watchdog_h 1

//## begin module%3EF2CCB102E8.additionalIncludes preserve=no
//## end module%3EF2CCB102E8.additionalIncludes

//## begin module%3EF2CCB102E8.includes preserve=yes
//## end module%3EF2CCB102E8.includes

//## begin module%3EF2CCB102E8.declarations preserve=no
//## end module%3EF2CCB102E8.declarations

//## begin module%3EF2CCB102E8.additionalDeclarations preserve=yes
//## end module%3EF2CCB102E8.additionalDeclarations


//## Class: ail_tclWatchdog%3EF2C4C203A1
//## Category: AIL::Watchdog%3EF2C46D0005
//## Subsystem: Ail::Include%3A841A9E02B0
//## Persistence: Transient
//## Cardinality/Multiplicity: n

// forward declaration for AIL interface definition
class ail_tclIAppAdapt;

class ail_tclWatchdog
{
  public:
    //## Constructors (specified)
      //## Operation: ail_tclWatchdog%3EF2C60500FC
      //	//
      //	********************************************************************************
      //	//	DESCRIPTION:
      //	//	Constructor
      //	//
      //	//	PARAMETER:
      //	//	ail_tclAppInterfaceRestricted *poAilObject (->I):
      //	//	   pointer to the supervising ail-object
      //	//	TR_tenTraceClass enUseTraceClass (I):
      //	//	   trace infos about this watchdog-object with this trace-class
      //	//
      //	//	RETURNVALUE:
      //	//	none
      //	//
      //	//	History:
      //	//	26.06.03 CM-DI/ESA1-Fischer
      //	//	InitialVersion
      //	//
      //	//
      //	********************************************************************************
      ail_tclWatchdog (ail_tclIAppAdapt *poAilObject, TR_tenTraceClass enUseTraceClass = TR_CLASS_AIL);

    //## Destructor (specified)
      //## Operation: ~ail_tclWatchdog%3EF2C60C00DD
      //	//
      //	********************************************************************************
      //	//	DESCRIPTION:
      //	//	Destructor
      //	//
      //	//	PARAMETER:
      //	//	none
      //	//
      //	//	RETURNVALUE:
      //	//	none
      //	//
      //	//	History:
      //	//	26.06.03 CM-DI/ESA1-Fischer
      //	//	InitialVersion
      //	//
      //	//
      //	********************************************************************************
      virtual ~ail_tclWatchdog ();


    //## Other Operations (specified)
      //## Operation: bCreate%3EF2C6A100E2
      //	//
      //	********************************************************************************
      //	//	DESCRIPTION:
      //	//	bCreate: create watchdog, call only in context of the
      //	//	thread to be supervised.
      //	//
      //	//	PARAMETER:
      //	//	none
      //	//
      //	//	RETURNVALUE:
      //	//	tBool
      //	//	   TRUE: created, FALSE: creation failed
      //	//
      //	//	History:
      //	//	26.06.03 CM-DI/ESA1-Fischer
      //	//	InitialVersion
      //	//
      //	//
      //	********************************************************************************
      tBool bCreate ();

      //## Operation: bDelete%3EF2C6A803D0
      //	//
      //	********************************************************************************
      //	//	DESCRIPTION:
      //	//	bDelete: delete watchdog
      //	//
      //	//	PARAMETER:
      //	//	none
      //	//
      //	//	RETURNVALUE:
      //	//	tBool
      //	//	   TRUE: deleted, FALSE: not deleted
      //	//
      //	//	History:
      //	//	26.06.03 CM-DI/ESA1-Fischer
      //	//	InitialVersion
      //	//
      //	//
      //	********************************************************************************
      tBool bDelete ();

      //## Operation: bActivate%3EF2C6B10344
      //	//
      //	********************************************************************************
      //	//	DESCRIPTION:
      //	//	bActivate: activate watchdog. thread will be supervised
      //	//	by the ail-object
      //	//
      //	//	PARAMETER:
      //	//	OSAL_tMSecond WdgInterval (I):
      //	//	   watchdog-interval in ms. trigger watchdog
      //	//	   after this time, else system will be restarted
      //	//	OSAL_tMSecond MaxInterval (I):
      //	//	   max watchdog-interval in ms. deactivate watchdog
      //	//	   after this time, else system will be restarted
      //	//
      //	//	RETURNVALUE:
      //	//	tBool
      //	//	   TRUE: activated, FALSE: not activated
      //	//
      //	//	History:
      //	//	26.06.03 CM-DI/ESA1-Fischer
      //	//	InitialVersion
      //	//
      //	//
      //	********************************************************************************
      tBool bActivate (OSAL_tMSecond WdgInterval, OSAL_tMSecond MaxInterval = 0);

      //## Operation: vDeactivate%3EF2C6D102D7
      //	//
      //	********************************************************************************
      //	//	DESCRIPTION:
      //	//	vDeactivate: deactivate watchdog
      //	//
      //	//	PARAMETER:
      //	//	none
      //	//
      //	//	RETURNVALUE:
      //	//	tVoid
      //	//
      //	//	History:
      //	//	26.06.03 CM-DI/ESA1-Fischer
      //	//	InitialVersion
      //	//
      //	//
      //	********************************************************************************
      tVoid vDeactivate ();

      //## Operation: vTriggerWdg%3EF2C6DB0132
      //	//
      //	********************************************************************************
      //	//	DESCRIPTION:
      //	//	vTriggerWdg: trigger watchdog. you have to retrigger this
      //	//	watchdog every [WdgInterval] ms until you call vDeactivate.
      //	//
      //	//	PARAMETER:
      //	//	none
      //	//
      //	//	RETURNVALUE:
      //	//	tVoid
      //	//
      //	//	History:
      //	//	26.06.03 CM-DI/ESA1-Fischer
      //	//	InitialVersion
      //	//
      //	//
      //	********************************************************************************
      tVoid vTriggerWdg ();

  protected:

    // Data Members for Class Attributes

      //## Attribute: hWdgID%3EF2C567022F
      //## begin ail_tclWatchdog::hWdgID%3EF2C567022F.attr preserve=no  protected: ail_tWdgHandle {UA} OSAL_C_INVALID_HANDLE
      ail_tWdgHandle hWdgID;
      //## end ail_tclWatchdog::hWdgID%3EF2C567022F.attr

      //## Attribute: enTraceClass%3EF85E4A034A
      //## begin ail_tclWatchdog::enTraceClass%3EF85E4A034A.attr preserve=no  protected: TR_tenTraceClass {UA} enUseTraceClass
      TR_tenTraceClass enTraceClass;
      //## end ail_tclWatchdog::enTraceClass%3EF85E4A034A.attr

    // Data Members for Associations

      //## Association: AIL::Watchdog::<unnamed>%3EF6ED700222
      //## Role: ail_tclWatchdog::poAil%3EF6ED7003A8
      //## begin ail_tclWatchdog::poAil%3EF6ED7003A8.role preserve=no  protected: ail_tclAppInterfaceRestricted {1 -> 1RHgAN}
      ail_tclIAppAdapt *poAil;
      //## end ail_tclWatchdog::poAil%3EF6ED7003A8.role

  private:
      // declare private default-ctor to avoid uninitialized objects
      ail_tclWatchdog (); //lint !e1704 Constructor has private access specification

};

//## Class: ail_tclWatchdogServer%3EF2C486017C
//## Category: AIL::Watchdog%3EF2C46D0005
//## Subsystem: Ail::Include%3A841A9E02B0
//## Persistence: Transient
//## Cardinality/Multiplicity: n



class ail_tclWatchdogServer 
{
  public:
    //## Constructors (specified)
      //## Operation: ail_tclWatchdogServer%3EF2D09B01D0
      ail_tclWatchdogServer ();

    //## Destructor (specified)
      //## Operation: ~ail_tclWatchdogServer%3EF2D0A30049
      ~ail_tclWatchdogServer ();


    //## Other Operations (specified)
      //## Operation: bInit%3EF2D0E802F5
      tBool bInit (OSAL_tpfCallback pfTimerEvent, tPVoid pvArg);

      //## Operation: vDeinit%3EF2D0F0011F
      tVoid vDeinit ();

      //## Operation: hCreateWdg%3EF2D0FB02F4
      ail_tWdgHandle hCreateWdg (TR_tenTraceClass enTraceClass);

      //## Operation: vDeleteWdg%3EF2D108011E
      tVoid vDeleteWdg (ail_tWdgHandle hWdgHandle);

      //## Operation: bActivateWdg%3EF2D112017B
      tBool bActivateWdg (ail_tWdgHandle hWdgHandle, OSAL_tMSecond WdgInterval, OSAL_tMSecond MaxInterval);

      //## Operation: bDeactivateWdg%3EF2D11B011D
      tBool bDeactivateWdg (ail_tWdgHandle hWdgHandle);

      //## Operation: vTriggerWdg%3EF2D12301C8
      tVoid vTriggerWdg (ail_tWdgHandle hWdgHandle);

      //## Operation: hTimerEvent%3EF2D12A01B8
      ail_tWdgHandle hTimerEvent ();

      //## Operation: bGetWatchdogInfo%3EF7FE8A03DC
      tBool bGetWatchdogInfo (ail_tWdgHandle hWdgHandle, OSAL_tThreadID &rfThreadID, OSAL_tMSecond &rfWdgInterval, OSAL_tMSecond &rfMaxInterval);

  protected:
    // Data Members for Associations

      //## Association: AIL::Watchdog::<unnamed>%3EF2CEFA024F
      //## Role: ail_tclWatchdogServer::poWatchdogList%3EF2CEFA03E5
      //## begin ail_tclWatchdogServer::poWatchdogList%3EF2CEFA03E5.role preserve=no  protected: ail_tclWatchdogList {1 -> 1RHgAN}
      ail_tclWatchdogList *poWatchdogList;
      //## end ail_tclWatchdogServer::poWatchdogList%3EF2CEFA03E5.role

  private:

      // avoid copy
      ail_tclWatchdogServer(const ail_tclWatchdogServer &corfoWatchdogServer);
      // avoid assignment
      ail_tclWatchdogServer& operator=(const ail_tclWatchdogServer&);

    //## Other Operations (specified)
      //## Operation: FindObject%3EF2D3C802E9
      ail_tclWatchdogIterator FindObject (ail_tWdgHandle hWdgHandle);

      //## Operation: FindObject%3EF2D3D100A7
      ail_tclWatchdogIterator FindObject (OSAL_tThreadID ThreadID);

      //## Operation: FindNextTriggerObject%3EF2D3FF0102
      ail_tclWatchdogIterator FindNextTriggerObject ();

      //## Operation: hGetUniqueID%3EF2D40E01DC
      ail_tWdgHandle hGetUniqueID ();

      //## Operation: vRestartTimerForNextTrigger%3EF2D4200267
      tVoid vRestartTimerForNextTrigger ();

      //## Operation: vDeleteList%3EF6B22C027C
      tVoid vDeleteList ();

    // Data Members for Class Attributes

      //## Attribute: hWdgTimer%3EF2CF9E016A
      //## begin ail_tclWatchdogServer::hWdgTimer%3EF2CF9E016A.attr preserve=no  private: OSAL_tTimerHandle {UA} 
      OSAL_tTimerHandle hWdgTimer;
      //## end ail_tclWatchdogServer::hWdgTimer%3EF2CF9E016A.attr

      //## Attribute: hNextTrigger%3EF2CFBA035F
      //## begin ail_tclWatchdogServer::hNextTrigger%3EF2CFBA035F.attr preserve=no  private: ail_tWdgHandle {UA} 
      ail_tWdgHandle hNextTrigger;
      //## end ail_tclWatchdogServer::hNextTrigger%3EF2CFBA035F.attr

      //## Attribute: enWdgState%3EF2D07A005B
      //## begin ail_tclWatchdogServer::enWdgState%3EF2D07A005B.attr preserve=no  private: ail_tenWdgState {UA} 
      ail_tenWdgState enWdgState;
      //## end ail_tclWatchdogServer::enWdgState%3EF2D07A005B.attr

      //## Attribute: NextTriggerTime%3EFA99DE03A9
      //## begin ail_tclWatchdogServer::NextTriggerTime%3EFA99DE03A9.attr preserve=no  private: OSAL_tMSecond {UA} 
      OSAL_tMSecond NextTriggerTime;
      //## end ail_tclWatchdogServer::NextTriggerTime%3EFA99DE03A9.attr

};

// Class ail_tclWatchdog 

// Class ail_tclWatchdogServer 

//## begin module%3EF2CCB102E8.epilog preserve=yes
//## end module%3EF2CCB102E8.epilog


#endif
