//## begin module%1.4%.codegen_version preserve=yes
//   Read the documentation to learn more about C++ code generator
//   versioning.
//## end module%1.4%.codegen_version

//## begin module%3A841C9C0213.cm preserve=no
//   %X% %Q% %Z% %W%
//## end module%3A841C9C0213.cm

//## begin module%3A841C9C0213.cp preserve=no
//## end module%3A841C9C0213.cp

//## Module: ail_Interface%3A841C9C0213; Subprogram specification
//## Subsystem: Ail::Include%3A841A9E02B0
//## Source file: e:\vasco\components\Ail\Include\ail_Interface.h

#ifndef ail_Interface_h
#define ail_Interface_h 1

//## begin module%3A841C9C0213.additionalIncludes preserve=no
//## end module%3A841C9C0213.additionalIncludes

//## begin module%3A841C9C0213.includes preserve=yes
//## end module%3A841C9C0213.includes

//## begin module%3A841C9C0213.declarations preserve=no
//## end module%3A841C9C0213.declarations

//## begin module%3A841C9C0213.additionalDeclarations preserve=yes

/******************************************************************************
| defines and macros (scope: global)
|-----------------------------------------------------------------------------*/

#define  AIL_C_U8_APP_END_SUCCESSFUL   0x01
#define  AIL_C_U8_APP_END_FAILURE      0x00

#define AIL_C_U16_INTERNAL_REGISTERID 0x0000

// default-size for jump- and destroy-stack-size
#define  AIL_C_U32_ENTRY_JUMP_STACKSIZE      0x00000005
#define  AIL_C_U32_ENTRY_DESTROY_STACKSIZE   0x00000005
#define  AIL_C_U32_BODY_JUMP_STACKSIZE       0x0000000A
#define  AIL_C_U32_BODY_DESTROY_STACKSIZE    0x0000000A

#define AIL_C_U32_ERROR_ONINIT_FAILED        0x00000000
#define AIL_C_U32_ERROR_ONSHUTDOWN_REQUIRED  0x00000001
#define AIL_C_U32_ERROR_ONEXTRATIME_FAILED   0x00000002
#define AIL_C_U32_ERROR_ONDOUBLE_INITIALIZED 0x00000003
#define AIL_C_U32_ERROR_ONPROXYSTART_FAILED  0x00000004

// Assert-Makro
#define AIL_M_CHECK_SHUTDOWN( CONDITION ) vShutdownRequired(CONDITION,__FILE__,__LINE__)
#define AIL_M_SHUTDOWN_REQUIRED vShutdownRequired(FALSE,__FILE__,__LINE__)

//## end module%3A841C9C0213.additionalDeclarations


//## Class: ail_tclAppAdapt%3A1265470350
//## Category: AIL::ApplicationInterface%3A364930013E
//## Subsystem: Ail::Include%3A841A9E02B0
//## Persistence: Transient
//## Cardinality/Multiplicity: n



class ail_tclAppAdapt 
{
  public:
    //## Constructors (specified)
      //## Operation: ail_tclAppAdapt%3A879EA300B2
      // the constructor sets all member variables to invalid
      ail_tclAppAdapt ();

    //## Destructor (specified)
      //## Operation: ~ail_tclAppAdapt%3B27302901F0
      virtual ~ail_tclAppAdapt ();


    //## Other Operations (specified)
      //## Operation: bInitInstance%3A8791E30326
      // ********************************************************************************
      // DESCRIPTION:
      //
      // "bInitInstance()"  of the base class only has the purpose to call the "bEntry
      // ThreadSetup()"-function, which initalizes "ail_tclAppAdapt" and starts the
      // application entry thread
      //
      //
      // PARAMETER:
      //
      // tU16   u16NewLpmId  (->I)
      // Id of the ProxyLpm, for usage together with BR220-Wrapper it can be set to AIL_C
      // _U16_APPID_INVALID
      // tU16   u16MyAppId     (->I)
      // Id of own application
      //
      //
      // RETURNVALUE:
      //
      // tBool
      // TRUE, if getting success, else FALSE
      //
      //
      // History:
      //
      // 12.02.01 EFG32-Brunke
      // InitialVersion
      //
      // ********************************************************************************
      virtual tBool bInitInstance (tU16 u16NewLpmId, tU16 u16MyAppId, OSAL_tThreadID hExternalDispatcherThreadID = OSAL_ERROR);

      //## Operation: vDeinitInstance%3D3D75E20199
      virtual tVoid vDeinitInstance ();

      //## Operation: u16GetLpmId%3A1282CB037D
      // to get the application Id of the LPM proxy application
      tU16 u16GetLpmId () const;

      //## Operation: u16GetAppId%3A879296019D
      // to get my own application Id
      tU16 u16GetAppId () const;

      //## Operation: hGetMyInQueue%3A8792B60030
      // to get the input queue of the own application
      OSAL_tMQueueHandle hGetMyInQueue () const;

      //## Operation: hGetLpmInQueue%3A8792FE00CA
      // to get the input queue of the LPM proxy application
      OSAL_tMQueueHandle hGetLpmInQueue () const;

      //## Operation: hGetSupervisorThread%3BDFD04B01B3
      OSAL_tThreadID hGetSupervisorThread () const;

      //## Operation: vTriggerWdg%3BC54BD40037
      // ********************************************************************************
      // DESCRIPTION:
      //
      // When creating an instance of tclAppAdapt, it is refered to the registry and
      // decided, if this application must be supervised by a WDG or not. If yes, the
      // function "vTriggerWdg()" is installed as callback function of a stop watch.
      //
      // Internally "vTriggerWdg()" sends a power message with subcode for watchdog
      // identification to  the corresponding application. The function doesn't
      // re-trigger the stop watch itself! If WDG is still required, the application
      // must start the stop watch again.
      //
      //
      // PARAMETER:
      //
      // tVoid*  pvArg   (->I)
      // void pointer, internally casted to the "ail_tclAppAdapt" to access to base or
      // derivated object for to read the application InQueue form the "ail_tclApp
      // Adapt"-object
      //
      //
      // RETURNVALUE:
      //
      // none
      //
      //
      // History:
      //
      // 11.10.01 ECC32-Brunke
      // InitialVersion
      //
      // ********************************************************************************
      static tVoid vTriggerWdg (tVoid* pvArg);

  protected:

    //## Other Operations (specified)
      //## Operation: bEntryThreadSetup%3A8BF7EE0067
      // ********************************************************************************
      // DESCRIPTION:
      //
      // "bEntryThreadSetup()" opens all required communication queue and  starts the
      // application interface thread, which always begins with "vStartAppEntry()".
      // This function is not allowed to be overwriten. It can be also called by a "bInit
      // Instance()"-function of a derivated class to start the inital thread of an
      // application.
      //
      // PARAMETER:
      //
      // tU32   u32StartupPriority    (->I)
      // it's priorty
      // tU32   u32StackSize   (->I)
      // it's stacksize
      //
      //
      // RETURNVALUE:
      //
      // tBool
      // TRUE, if getting success, else FALSE
      //
      //
      // History:
      //
      // 12.02.01 EFG32-Brunke
      // InitialVersion
      //
      // ********************************************************************************
      tBool bEntryThreadSetup (tU32 u32StartupPriority, tU32 u32StackSize);

    // Data Members for Class Attributes

      //## Attribute: hLpmInQueue%3A878A7D039B
      //## begin ail_tclAppAdapt::hLpmInQueue%3A878A7D039B.attr preserve=no  protected: OSAL_tMQueueHandle {UA} OSAL_C_INVALID_HANDLE
      OSAL_tMQueueHandle hLpmInQueue;
      //## end ail_tclAppAdapt::hLpmInQueue%3A878A7D039B.attr

      //## Attribute: u16LpmId%3A8790D1030E
      //## begin ail_tclAppAdapt::u16LpmId%3A8790D1030E.attr preserve=no  protected: tU16 {UA} AMT_C_U16_APPID_INVALID
      tU16 u16LpmId;
      //## end ail_tclAppAdapt::u16LpmId%3A8790D1030E.attr

      //## Attribute: hMyInQueue%3A8790DA0176
      //## begin ail_tclAppAdapt::hMyInQueue%3A8790DA0176.attr preserve=no  protected: OSAL_tMQueueHandle {UA} OSAL_C_INVALID_HANDLE
      OSAL_tMQueueHandle hMyInQueue;
      //## end ail_tclAppAdapt::hMyInQueue%3A8790DA0176.attr

      //## Attribute: u16AppId%3A8791090015
      //## begin ail_tclAppAdapt::u16AppId%3A8791090015.attr preserve=no  protected: tU16 {UA} AMT_C_U16_APPID_INVALID
      tU16 u16AppId;
      //## end ail_tclAppAdapt::u16AppId%3A8791090015.attr

      //## Attribute: hEntryThreadID%3A879123017B
      //## begin ail_tclAppAdapt::hEntryThreadID%3A879123017B.attr preserve=no  protected: OSAL_tThreadID {UA} OSAL_ERROR
      OSAL_tThreadID hEntryThreadID;
      //## end ail_tclAppAdapt::hEntryThreadID%3A879123017B.attr

      tBool bEntryThreadCreated;

      //## Attribute: hSupervisorThreadID%3BDFD0A40189
      //## begin ail_tclAppAdapt::hSupervisorThreadID%3BDFD0A40189.attr preserve=no  protected: OSAL_tThreadID {UA} OSAL_ERROR
      OSAL_tThreadID hSupervisorThreadID;
      //## end ail_tclAppAdapt::hSupervisorThreadID%3BDFD0A40189.attr

      //## Attribute: u32WdgTime%3BC6D6540313
      //## begin ail_tclAppAdapt::u32WdgTime%3BC6D6540313.attr preserve=no  protected: tU32 {UA} 0
      tU32 u32WdgTime;
      //## end ail_tclAppAdapt::u32WdgTime%3BC6D6540313.attr

      //## Attribute: hWdgTimer%3BC6DC0C0106
      //## begin ail_tclAppAdapt::hWdgTimer%3BC6DC0C0106.attr preserve=no  protected: OSAL_tTimerHandle {UA} OSAL_C_INVALID_HANDLE
      OSAL_tTimerHandle hWdgTimer;
      //## end ail_tclAppAdapt::hWdgTimer%3BC6DC0C0106.attr

      //## Attribute: bMyQueueCreated%3F0BE8070016
      //## begin ail_tclAppAdapt::bMyQueueCreated%3F0BE8070016.attr preserve=no  protected: tBool {UA} FALSE
      tBool bMyQueueCreated;
      //## end ail_tclAppAdapt::bMyQueueCreated%3F0BE8070016.attr

  private:

    //## Other Operations (specified)
      //## Operation: vAppEntry%3A87932302F4
      // ********************************************************************************
      // DESCRIPTION:
      //
      // "vAppEntry()" is the first method of the "ail_tclAppAdapt" wich is called from
      // the inteface thread. Depending on the type of the object ( basic class or
      // derivated class ) for which "bInitInstance()" was called to intialize the "ail_
      // tclAppAdapt"-class, either the overwritten "vAppEntry" ( if existing ) or the "v
      // AppEntry" of the basic class becomes active. As operation of basic class this
      // function only contains "ReveiceMessage" and "ReleaseMessage" within a
      // while(1)-loop. The user has to overwrite this function to implement his own
      // framework here.
      //
      //
      // PARAMETER:
      //
      //
      // RETURNVALUE:
      //
      // none
      //
      //
      // History:
      //
      // 12.02.01 EFG32-Brunke
      // InitialVersion
      //
      // ********************************************************************************
      virtual tVoid vAppEntry () = 0;

      //## Operation: vStartAppEntry%3A87936C010E
      // ********************************************************************************
      // DESCRIPTION:
      //
      // Depending on the type of the object ( basic class or derivated class ) for
      // which "bInitInstance()" has been called, "vStartAppEntry()" calls "vAppEntry"
      // belonged to the type of the object pointer.
      //
      //
      // PARAMETER:
      //
      // tVoid*  pvArg   (->I)
      // void pointer, internally casted to the "ail_tclAppAdapt" to access to base or
      // derivated object
      //
      //
      // RETURNVALUE:
      //
      // none
      //
      //
      // History:
      //
      // 12.02.01 EFG32-Brunke
      // InitialVersion
      //
      // ********************************************************************************
      static tVoid vStartAppEntry (tVoid* pvArg);

};

/**
* Interface definition for AIL applications: Use this interface for your
* application instead of using ail_tclAppInterfaceRestricted directly.
* This helps you to keep your code clean from any system resources. So,
* you are able to replace the AIL object completely through your own testing
* implementation for regression tests.
*/
class ail_tclIAppAdapt
{
   public:
      virtual ~ail_tclIAppAdapt (){};

      //
      virtual tU16 u16GetLpmId () const = 0;
      virtual tU16 u16GetAppId () const = 0;

      // message sending
      virtual ail_tenCommunicationError enSendMessage (amt_tclServiceData** ppoMessage, OSAL_tMSecond rWaitForAnswerTime, tBool &rfbDeleteMessage) = 0;
      #if 0
      // KSM2HI, 15.02.2017 : Intentinally commented out. See explanation why in ail_Interface.cpp.
      virtual ail_tenCommunicationError enPostBroadcast (amt_tclServiceData* poMessage) = 0;
      #endif
      virtual ail_tenCommunicationError enPostMessage (amt_tclServiceData* poMessage, tBool bDeleteMsgOnNoSuccess = FALSE, tU32 u32Prio = OSAL_C_U32_MQUEUE_PRIORITY_LOWEST) = 0;

      // service registration
      virtual tU16 u16RegisterService (tU16 u16ServiceId, tU16 u16ServiceMajorVersion, tU16 u16ServiceMinorVersion = 0x0000, tU16 u16SourceSubID = 0x0000, tU16 u16ServerAppId = AMT_C_U16_APPID_INVALID) = 0;
      virtual tBool bRegisterAsync (tU16 u16ServiceId, tU16 u16ServiceMajorVersion, tU16 u16ServiceMinorVersion = 0x0000, tU16 u16SourceSubID = 0x0000, tU16 u16ServerAppId = AMT_C_U16_APPID_INVALID) = 0;
      virtual tVoid vUnregisterService (tU16 u16ServiceId, tU16 u16ServerAppId = AMT_C_U16_APPID_INVALID, tU16 u16RegisterId = AMT_C_U16_REGID_INVALID, tU16 u16SourceSubID = 0x0000) = 0;
      virtual tVoid vServiceAvailabilityChanged (tU16 u16ServiceId, tU8 u8ServiceState) = 0;
      virtual tU8 u8GetServiceAvailability (tU16 u16ServiceId) = 0;
      virtual tBool bGetServerRegisteredVersion(tU16 u16ServerAppId, tU16 u16ClientSubId, tU16 u16ServiceId, tU16 u16RegisterId, tU16& rfu16MajorVersion, tU16& rfu16MinorVersion, tU16& rfu16PatchVersion) = 0;
      virtual tBool bGetClientRegisteredVersion(tU16 u16ServiceId, tU16 u16RegisterId, tU16& rfu16MajorVersion, tU16& rfu16MinorVersion, tU16& rfu16PatchVersion) = 0;
      virtual tU16 u16GetServerRegisteredMajorVersion(tU16 u16ServerAppId, tU16 u16ClientSubId, tU16 u16ServiceId, tU16 u16RegisterId) = 0;
      virtual tU16 u16GetClientRegisteredMajorVersion(tU16 u16ServiceId, tU16 u16RegisterId) = 0;

      // application state changes
      virtual tVoid vAppStateChanged (tU32 u32AppState, OSAL_tMSecond rApproximatedChangeTime = 0) = 0;
      virtual tBool bRequestTimeOnStateChangeAutomatically() const = 0;
      virtual tVoid vApplicationCloseAcknowledge (tU8 u8SuccessType) = 0;
      virtual tVoid vApplicationRequestErrorEnd (tU32 u32ErrorReason = 0) = 0;

      virtual tU32 u32GetStartupInfo () const = 0;
      virtual tVoid vShutdownRequired (tBool bCondition, tCString coszFilename = OSAL_NULL, tU32 u32Line = 0) = 0;
      virtual tVoid vTerminateMySelf () = 0;

      // watchdog interface
      virtual tBool bGetWatchdogInfo (ail_tWdgHandle hWdgHandle, OSAL_tThreadID &rfThreadID, OSAL_tMSecond &rfWdgInterval, OSAL_tMSecond &rfMaxInterval) = 0;
      virtual ail_tWdgHandle hCreateWdg (TR_tenTraceClass enTraceClass) = 0;
      virtual tVoid vDeleteWdg (ail_tWdgHandle hWdgHandle) = 0;
      virtual tBool bActivateWdg (ail_tWdgHandle hWdgHandle, OSAL_tMSecond WdgInterval, OSAL_tMSecond MaxInterval) = 0;
      virtual tBool bDeactivateWdg (ail_tWdgHandle hWdgHandle) = 0;
      virtual tVoid vTriggerWdgServer (ail_tWdgHandle hWdgHandle) = 0;
};

//## Class: ail_tclAppInterfaceRestricted%3A10FC06005B
//## Category: AIL::ApplicationInterface%3A364930013E
//## Subsystem: Ail::Include%3A841A9E02B0
//## Persistence: Transient
//## Cardinality/Multiplicity: n



//## Uses: <unnamed>%3D5CF5E901C8;ail_tclAsyncRegisterReqList { -> }

class ail_tclAppInterfaceRestricted : public ail_tclAppAdapt  //## Inherits: <unnamed>%3A12655D03DE
   , public ail_tclIAppAdapt
{
  public:
      // redirected to base class to allow access via inteface
      virtual tU16 u16GetLpmId () const
      { //lint !e1511
         return ail_tclAppAdapt::u16GetLpmId();
      }

      // redirected to base class to allow access via inteface
      virtual tU16 u16GetAppId () const
      { //lint !e1511
         return ail_tclAppAdapt::u16GetAppId();
      }

    //## Constructors (specified)
      //## Operation: ail_tclAppInterfaceRestricted%3A110E160122
      // All own variables are set to default.
      // parameter:
      //    tU32 u32SizeOfEntryJumpStackSize (I)
      //       needed for exception-handling
      //    tU32 u32SizeOfEntryDestroyStackSize (I)
      //       needed for exception-handling
      ail_tclAppInterfaceRestricted
      (
         tU32  u32SizeOfEntryJumpStackSize = AIL_C_U32_ENTRY_JUMP_STACKSIZE,
         tU32  u32SizeOfEntryDestroyStackSize = AIL_C_U32_ENTRY_DESTROY_STACKSIZE
      );

    //## Destructor (specified)
      //## Operation: ~ail_tclAppInterfaceRestricted%3A87A86E0306
      // allocated buffer is released again
      virtual ~ail_tclAppInterfaceRestricted ();


    //## Other Operations (specified)
      //## Operation: bInitInstance%3A87A81101A4
      // ********************************************************************************
      // DESCRIPTION:
      //
      // Because all basic functions of the application interface depend on working on
      // lists, the init function must guarantee, that the required list objects are
      // instanciated. Internally also the "bEntryThreadSetup()"-function of the
      // BASIC-class is called to create the application entry thread and to open the
      // required mailboxes. It returns TRUE, if all initialization has got success,
      // else FALSE will be returned.
      //
      //
      // PARAMETER:
      //
      // tU16   u16NewLpmId    (->I)
      // Id of the LocalPowermanager
      // tU16   u16MyAppId    (->I)
      // Id of my own Application
      //
      //
      // RETURNVALUE:
      //
      // tBool
      // TRUE/FALSE
      //
      //
      // History:
      //
      // 12.02.01 EFG32-Brunke
      // InitialVersion
      //
      // ********************************************************************************
      virtual tBool bInitInstance (tU16 u16NewLpmId, tU16 u16MyAppId, OSAL_tThreadID hExternalDispatcherThreadID = OSAL_ERROR);

      //## Operation: vDeinitInstance%3A9D206C00D1
      virtual tVoid vDeinitInstance ();

      //## Operation: vOnNewAppState%3A10FC06005C
      // ********************************************************************************
      // DESCRIPTION:
      //
      // The interface framework calls "vOnNewAppState()" whenever a new POWER-Message
      // has been received. As default it mirrors all POWER commands to satisfy the
      // LPM-interface. For specific application behavior, the user must overwrite this
      // function.
      //
      //
      // PARAMETER:
      //
      // tU32   u32OldAppState    (->I)
      // the last confirmed application state
      // tU32   u32AppState    (->I)
      // the new requested application state
      //
      //
      // RETURNVALUE:
      //
      // none
      //
      //
      // History:
      //
      // 12.02.01 EFG32-Brunke
      // InitialVersion
      //
      // ********************************************************************************
      virtual tVoid vOnNewAppState (tU32 u32OldAppState, tU32 u32AppState);

      //## Operation: vOnNewMessage%3A10FC2400EA
      // ********************************************************************************
      // DESCRIPTION:
      //
      // The interface framework calls "vOnNewMessage()" whenever a new Service
      // Data-Message has been received. As default it releases the message buffer which
      // belongs to "amt_tclBaseMessage*". The user has to overwrite this function to
      // implement his own dipatcher here. Then it's his responsibility to free the
      // message buffer.
      //
      //
      // PARAMETER:
      //
      // amt_tclBaseMessage*  poMessage     (->I)
      // pointer to the received ServiceData-Message
      //
      //
      // RETURNVALUE:
      //
      // none
      //
      //
      // History:
      //
      // 12.02.01 EFG32-Brunke
      // InitialVersion
      //
      // ********************************************************************************
      virtual tVoid vOnNewMessage (amt_tclBaseMessage* poMessage);

      //## Operation: bOnAcceptNewRegister%3A10FCBB030E
      // ********************************************************************************
      // DESCRIPTION:
      //
      // The interface framework calls "vOnAcceptNewRegister()" whenever a new Service
      // Register-Message has been received. This function informs the application about
      // an interface request by a client.  As default it accepts all requests as valid
      // and gives back a RegisterID created by the call of "bCreatedRegisterId()". The
      // user has to overwrite this function if there is any possibility ( e.g. non
      // multi client capable )  to reject a client request. Depending on the return
      // code ( TRUE / FALSE ) the framework either protocols a vaild conncetion to it's
      // reference list and confirms the client's request or sends a negativ
      // confirmation to the client.
      //
      //
      // PARAMETER:
      //
      // tU16   u16ServiceId    (->I)
      // the requested ServiceId
      // tU16   u16ClientAppId (->I)
      // application id of requesting client
      // tU16   u16ClientSubId (->I)
      // application sub id of requesting client
      // tU16*   pu16RegisterId    (->I/0)
      // memory address to return the RegisterId
      //
      //
      // RETURNVALUE:
      //
      // tBool
      // TRUE, if accepted, else FALSE
      //
      //
      // History:
      //
      // 12.02.01 EFG32-Brunke
      // InitialVersion
      //
      // ********************************************************************************
      virtual tBool bOnAcceptNewRegister (tU16 u16ServiceId, tU16 u16ClientAppId, tU16 u16ClientSubId, tU16* pu16RegisterId);

      //## Operation: vOnUnregister%3A110A260136
      // ********************************************************************************
      // DESCRIPTION:
      //
      // The interface framework calls "vOnUnregister()" every time, when a valid Service
      // Unregister-Message has been received. This function informs the application,
      // that all requests label with this RegisterId has got obsolete. As default no
      // corresponding action is done. The user has to overwrite this function and to
      // clear the RegisterId from his application references. Please note, that the
      // framework will assign a free RegisterId next time a service is requested by
      // some client.
      //
      //
      // PARAMETER:
      //
      // tU16   u16ServiceId    (->I)
      // the former  requested ServiceId
      // tU16   u16RegisterId    [->I)
      // the obsolete RegisterId
      //
      //
      // RETURNVALUE:
      //
      // tVoid
      //
      //
      // History:
      //
      // 12.02.01 EFG32-Brunke
      // InitialVersion
      //
      // ********************************************************************************
      virtual tVoid vOnUnregister (tU16 u16ServiceId, tU16 u16RegisterId);

      //## Operation: vOnServiceState%3A10FEC801DC
      // ********************************************************************************
      // DESCRIPTION:
      //
      // The interface framework calls "vOnServiceState()" if the server announces a
      // change of the service avalibility. This function informs the application when
      // service is available ( again ) or not ( yet ) available.  As default no
      // corresponding action is done. The user has to overwrite this function to
      // synchronize his application's communication.
      //
      //
      // PARAMETER:
      //
      // tU16  u16ServiceId     (->I)
      // the concerned ServiceId
      // tU16  u16ServerId      (->I)
      // offered by ServerApplicationId
      // tU16  u16RegisterId     (->I)
      // the corresponding RegisterId
      // tU8 u8ServiceState   (->I)
      // the actual ServiceState
      // -> AMT_C_U8_SVCSTATE_AVAILABLE
      // -> AMT_C_U8_SVCSTATE_NOT_AVAILABLE
      // -> AMT_C_U8_SVCSTATE_REG_INVAILID
      //
      //
      // RETURNVALUE:
      //
      // tVoid
      //
      //
      // History:
      //
      // 12.02.01 EFG32-Brunke
      // InitialVersion
      //
      // ********************************************************************************
      virtual tVoid vOnServiceState (tU16 u16ServiceId, tU16 u16ServerId, tU16 u16RegisterId, tU8 u8ServiceState, tU16 u16SubId);

      //## Operation: bOnInit%3A110A400007
      // ********************************************************************************
      // DESCRIPTION:
      //
      // The interface framework calls "bOnInit()" before starting any communication
      // action.  As default this function always returns TRUE. The user has to
      // implement all his local application initialization ( creating required threads,
      // allocate application memory, ... ). If returns TRUE, initializing could be
      // successfully performed and framework will register application at the LocalPower
      // Management, else, the application would end itself.
      //
      //
      // PARAMETER:
      //
      // none
      //
      //
      //
      // RETURNVALUE:
      //
      // tBool
      // the application either could be successfully initialized or not
      //
      //
      // History:
      //
      // 12.02.01 EFG32-Brunke
      // InitialVersion
      //
      // ********************************************************************************
      virtual tBool bOnInit ();

      //## Operation: vOnApplicationClose%3ADC0C8201EE
      // ********************************************************************************
      // DESCRIPTION:
      //
      // This function is called, when the application shall be immediatley closed.
      //
      //
      //
      // PARAMETER:
      //
      // tVoid
      //
      //
      // RETURNVALUE:
      //
      // none
      //
      //
      // History:
      //
      // 17.04.01 EFG32-Brunke
      // InitialVersion
      //
      // ********************************************************************************
      virtual tVoid vOnApplicationClose ();

      //## Operation: bOnWatchdog%3BC6F0230378
      virtual tBool bOnWatchdog ();

      //## Operation: bOnWatchdogFailed%3EF7FA2402F0
      // //
      // ********************************************************************************
      // // DESCRIPTION:
      // // bOnWatchdogFailed. Is called, if a worker-thread failed to
      // // trigger his watchdog-object
      // //
      // // PARAMETER:
      // // ail_tWdgHandle hFailedWatchdog (I):
      // //                handle to watchdog-object
      // //
      // // RETURNVALUE:
      // // tBool
      // // TRUE: restart system, FALSE: don't restart system
      // //
      // // History:
      // // 26.06.03 CM-DI/ESA1-Fischer
      // // InitialVersion
      // //
      // //
      // ********************************************************************************
      virtual tBool bOnWatchdogFailed (ail_tWdgHandle hFailedWatchdog);

      //## Operation: enSendMessage%3A1102F502F2
      // ********************************************************************************
      // DESCRIPTION:
      //
      // "enSendMessage()" is the synchronous method to post a message and to receive an
      // answer in one step. There are two ways of restriction in use this function:
      // - the user must guarantee, that this function is not called in the context of
      // the application entry thread ( otherwise it would immediatly return  AIL_EN_N_
      // POST_MESSAGE_FAILED )
      // -  the "enSendMessage()"-funtion may only access to messages catalogues, which
      // explicitely allows for it's message to be used in synchronous mode
      // Note: The condition, that a messages catalogues can be marked as "can be
      // synchronously used" is, that the server, which offers the meassge catalogue
      // never uses "enSendMessage()" by itself ( prevent of deadlock )
      //
      //
      //
      // PARAMETER:
      //
      // amt_tclServiceData**   ppoMessage   (->I/O)
      // pointer to a reference of a ServiceData-Message to send and to received a
      // message
      // OSAL_tMSecond   rWaitForAnswerTime  (->I)
      // maximum time to wait for answer
      // tBool  &rfbDeleteMessage  (->O)
      // if bDeleteMessage is TRUE, the message has to be deleted by the user
      //
      //
      // RETURNVALUE:
      //
      // ail_tenCommunicationError
      // enum type to identify kind of return:
      // - AIL_EN_N_NO_ERROR => successfully received the answer
      // - AIL_EN_N_POST_MESSAGE_FAILED => not posted a message
      // - AIL_EN_N_SERVICE_AVAILABILITY_LOCK=> not posted a message
      // - AIL_EN_N_REGISTRATION_DENIED => not posted a message
      // - AIL_EN_N_ANSWER_TIMEOUT => not received a message
      // - AIL_EN_N_UNDEFINED_ABORT => not received a message
      //
      //
      // History:
      //
      // 12.02.01 EFG32-Brunke
      // InitialVersion
      // 14.05.03 CM-DI/ESA1-Fischer
      // Parameter bDeleteMessage added
      //
      // ********************************************************************************
      virtual ail_tenCommunicationError enSendMessage (amt_tclServiceData** ppoMessage, OSAL_tMSecond rWaitForAnswerTime, tBool &rfbDeleteMessage);
      ail_tenCommunicationError enSendMessageFromEntry(amt_tclServiceData** ppoMessage, OSAL_tMSecond rWaitForAnswerTime, tBool &rfbDeleteMessage);

      //## Operation: enPostBroadcast%3A10FDCC011C
      // ********************************************************************************
      // DESCRIPTION:
      //
      // The server application should call "u16PostBroadcast()" if a message have to be
      // sent to all client applications which are registered. The framework internally
      // uses this function to inform all registered clients, after the server
      // application has called "vServiceAvailabilityChanged()" and all registered
      // client must be informed about the new service state
      //
      //
      // PARAMETER:
      //
      // amt_tclServiceData*   poMessage  (->I)
      // pointer to a formated ServiceData-Message
      //
      //
      // RETURNVALUE:
      //
      // ail_tenCommunicationError
      // enum type to identify kind of return:
      // - AIL_EN_N_NO_ERROR
      //   => successfully broadcasted  to all registered clients
      // - AIL_EN_N_NOT_ALL_INFORMED
      //   => not posted to all registered clients ( no further error spezification )
      //
      //
      //
      // History:
      //
      // 12.02.01 EFG32-Brunke
      // InitialVersion
      //
      // ********************************************************************************
      #if 0
      // KSM2HI, 15.02.2017 : Intentinally commented out. See explanation why in ail_Interface.cpp.
      virtual ail_tenCommunicationError enPostBroadcast (amt_tclServiceData* poMessage);
      #endif

      //## Operation: enPostMessage%3A11044E0121
      // ********************************************************************************
      // DESCRIPTION:
      //
      // "u16PostMessage()" is the main communication function for client and server
      // application, when they want asynchronously to send  messages. There it's
      // sufficient to identfied the receiver by the "u16RegisterId" and the interface
      // framework will add source and destination AppId to the message buffer.
      //
      //
      // PARAMETER:
      //
      // amt_tclServiceData*     poMessage   (->I)
      // pointer to a formated ServiceData-Message
      //
      // tBool                   bDeleteMsgOnNoSuccess (->I)
      // If set to TRUE, in case of any error, the message buffer will be automatically
      // released.
      // Default this parameter is set to FALSE, this mean in case of any error the message
      // buffer must be released by the caller of "enPostMessage()"
      //
      // tU32                    u32Prio (->I)
      // Priority of the to be posted CCA message. Default value is OSAL_C_U32_MQUEUE_PRIORITY_LOWEST
      //
      // RETURNVALUE:
      //
      // ail_tenCommunicationError
      // enum type to identify kind of return:
      // - AIL_EN_N_NO_ERROR => successfully posted the message
      // - AIL_EN_N_POST_MESSAGE_FAILED => not posted a message
      // - AIL_EN_N_SERVICE_AVAILABILITY_LOCK=> not posted a message
      // - AIL_EN_N_REGISTRATION_DENIED => not posted a message
      // - AIL_EN_N_NOT_SEND => not posted a message
      //
      //
      // History:
      //
      // 12.02.01 EFG32-Brunke
      // InitialVersion
      //
      // ********************************************************************************
      virtual ail_tenCommunicationError enPostMessage (amt_tclServiceData* poMessage, tBool bDeleteMsgOnNoSuccess = FALSE, tU32 u32Prio = OSAL_C_U32_MQUEUE_PRIORITY_LOWEST);

      //## Operation: u16RegisterService%3A10FE880216
      // ********************************************************************************
      // DESCRIPTION:
      //
      // When ever a client application wants to initialize a new communication channel
      // to a server, this function must be used to get a new "u16RegisterId" as return
      // value.
      // If the concept of service number assignment has made it sure, that one service
      // is exclusively offered by one application, the server application Id is not
      // nessary to be set, because the functions refers to the registry and searches
      // for the first correspondig entry to get the ServerId from the ServiceId.
      // Internally this function uses the same sychronous message mechanism as "en
      // MessageSend()". It must not be called in the context of the application entry
      // thread, because it would be blocked. If still calling it, it immediately
      // returns AMT_C_U16_REGID_INVALID.
      //
      //
      // PARAMETER:
      //
      // tU16  u16ServiceId   (->I)
      // the requested service
      // tU16 u16ServiceMajorVersion (->I)
      // major version of the demanded service ( default: 0x0000 )
      // tU16 u16ServiceMinorVersion (->I)
      // minor version of the demanded service ( default: 0x0000 )
      // tU16 u16SourceSubID ( ->I)
      // sub id of source ( default: 0x0000 )
      // tU16  u16ServerAppId  (->I)
      // the Id of the server which offers the service ( default: AMT_C_U16_APPID_
      // INVALID )
      //
      //
      // RETURNVALUE:
      //
      // AMT_C_U16_REGID_INVALID or new "u16RegisterId"
      //
      //
      // History:
      //
      // 12.02.01 EFG32-Brunke
      // InitialVersion
      //
      // ********************************************************************************
      virtual tU16 u16RegisterService (tU16 u16ServiceId, tU16 u16ServiceMajorVersion, tU16 u16ServiceMinorVersion = 0x0000, tU16 u16SourceSubID = 0x0000, tU16 u16ServerAppId = AMT_C_U16_APPID_INVALID);

      // Added method vOnAsyncRegisterConf() as virtual here in class 'ail_tclAppInterfaceRestricted'
      // to allow an access of ail_tclOneThreadAppInterface::vOnAsyncRegisterConf() via 'ail_tclAppInterfaceRestricted'.
      virtual tVoid vOnAsyncRegisterConf (tU16 u16RegisterId, tU16 u16ServerAppId, tU16 u16ServiceId, tU16 u16TargetSubId);

      // Added method vOnAsyncRegisterConfExt() as virtual here in class 'ail_tclAppInterfaceRestricted'
      // to allow an access of ail_tclOneThreadAppInterface::vOnAsyncRegisterConfExt() via 'ail_tclAppInterfaceRestricted'.
      virtual tVoid vOnAsyncRegisterConfExt (tU16 u16RegisterId, tU16 u16ServerAppId, tU16 u16ServiceId, tU16 u16TargetSubId, tU8 u8AsyncRegisterConfStatus);

      // Added methods bRegisterAsync() and bRegisterAsyncExecute() as virtual here in class 'ail_tclAppInterfaceRestricted'
      // to allow an access of ail_tclOneThreadAppInterface::bRegisterAsync() via the interface-class 'ail_tclIAppAdapt'
      // where 'ail_tclAppInterfaceRestricted' is derived from.
      virtual tBool bRegisterAsync (tU16 u16ServiceId, tU16 u16ServiceMajorVersion, tU16 u16ServiceMinorVersion = 0x0000, tU16 u16SourceSubID = 0x0000, tU16 u16ServerAppId = AMT_C_U16_APPID_INVALID);

      virtual tBool bRegisterAsyncExecute (tU16 u16ServiceId, tU16 u16ServiceMajorVersion, tU16 u16ServiceMinorVersion, tU16 u16SourceSubID, tU16 u16ServerAppId, tBool bListAccessAlreadyTaken = FALSE);

      //## Operation: vUnregisterService%3A1100FF01F6
      // ********************************************************************************
      // DESCRIPTION:
      //
      // When calling "vUnregisterService()" only with the parameter "u16Service", the
      // application interface releases all communication channels concerning this
      // service.
      //
      // No overwriting of default parameter "u16ServerAppId = AMT_C_U16_APPID_INVALID "
      // and "u16RegisterId = AMT_C_U16_REGID_INVALID" means, a client only has opened
      // one communication channel for that "u16ServiceId" or there are opened several
      // communication channels for one service Id and the clients wants to release all
      // by one function call ( example: Release of the DIAGNOSIS-service, which is
      // offered from every application ).
      //
      // If a client application wants to release only one communication channel to a
      // specific server, he has to call "vUnregisterService()" with specified "u16Server
      // AppId" and the function sends the UNREGISTER_MESSAGE to the corresponding
      // server and clears the connection from the service reference table.
      //
      // Additionally the parameter "u16Register" is required, if a client is registered
      // twice for one service at the same server.
      //
      //
      // PARAMETER:
      //
      // tU16   u16ServiceId    (->I)
      // the ServiceId which to be cleaned from the reference connection table
      // tU16   u16ServerAppId   (->I)
      // the AppId of the concerned server
      // tU16   u16RegisterId   (->I)
      // the RegisterId last got from the server
      // tU16   u16SourceSubID   (->I)
      // the client internal subaddress
      //
      //
      // RETURNVALUE:
      //
      // none
      //
      //
      // History:
      //
      // 12.02.01 EFG32-Brunke
      // InitialVersion
      //
      // ********************************************************************************
      virtual tVoid vUnregisterService (tU16 u16ServiceId, tU16 u16ServerAppId = AMT_C_U16_APPID_INVALID, tU16 u16RegisterId = AMT_C_U16_REGID_INVALID, tU16 u16SourceSubID = 0x0000);

      //## Operation: vAppStateChanged%3A10FFFD01F5
      // ********************************************************************************
      // DESCRIPTION:
      //
      // Informs the LocalProcessManager about a new application state. Internally this
      // function sends a POWER_MESSAGE to a proxy application of the LocalProcess
      // Manager.
      //
      //
      // PARAMETER:
      //
      // tU32   u32AppState   (->I)
      // new state of the own application
      // OSAL_tMSecond  rApproximatedChangeTime (->I)
      // count of millisecond till this state is approximately reached ( always set to
      // 0, if this parameter is not used )
      //
      //
      // RETURNVALUE:
      //
      // none
      //
      //
      // History:
      //
      // 12.02.01 EFG32-Brunke
      // InitialVersion
      //
      // ********************************************************************************
      virtual tVoid vAppStateChanged (tU32 u32AppState, OSAL_tMSecond rApproximatedChangeTime = 0);

      // ********************************************************************************
      // DESCRIPTION:
      //
      // 'Flag' to inform AIL to request extra time for state-change automatically in
      // entry-thread. Default: request for extra time will be send automatically.
      // User must overwrite this method, if such behaviour is not desired.
      //
      //
      // PARAMETER:
      //
      // none
      //
      //
      // RETURNVALUE:
      //
      // tBool:   TRUE : send request automatically
      //          FALSE: don't send request, user must do it
      //
      // History:
      //
      // 18.07.05 CM-DI/ESP2-Fischer
      // InitialVersion
      //
      // ********************************************************************************
      virtual tBool bRequestTimeOnStateChangeAutomatically() const;

      //## Operation: vServiceAvailabilityChanged%3A10FDFD0339
      // ********************************************************************************
      // DESCRIPTION:
      //
      // The server application informs all registered clients about the actual
      // application service state. Internally this function sends a SERVICE_STATUS_
      // MESSAGE to all concerned clients.
      //
      //
      // PARAMETER:
      //
      // tU16   u16ServiceId   (->I)
      // the affected ServiceID
      // tU8    u8ServiceState    (->I)
      // new state of the application service
      //
      //
      // RETURNVALUE:
      //
      // none
      //
      //
      // History:
      //
      // 12.02.01 EFG32-Brunke
      // InitialVersion
      //
      // ********************************************************************************
      virtual tVoid vServiceAvailabilityChanged (tU16 u16ServiceId, tU8 u8ServiceState);

      //## Operation: bExternSynchronizeInterface%3A9F687800A3
      // ********************************************************************************
      // DESCRIPTION:
      //
      // The interface additionally allows to be syncronized by an external thread
      // directly using the LPM registration mechanism. If the LPM_ID is initially set
      // to AIL_C_U16_APPID_INVALID,  the interface blocks all messages until "en
      // InterfaceState" is set to AIL_EN_N_APPLICATION_INITIALIZED.
      // The function "bExternSynchronizeInterface" is created to be called from the
      // start thread of the VD-Core and it internally sets  "enInterfaceState" to AIL_EN
      // _N_APPLICATION_INITIALIZED after "bOnInit()" returns TRUE.
      //
      // PARAMETER:
      //
      // void
      //
      //
      // RETURNVALUE:
      //
      // tBool
      // the interface has accepted ( TRUE ) or request has failed
      //
      //
      // History:
      //
      // 02.03.01 EFG32-Brunke
      // InitialVersion
      //
      // ********************************************************************************
      tBool bExternSynchronizeInterface ();

      //## Operation: vApplicationCloseAcknowledge%3ADC0DEB01B1
      // ********************************************************************************
      // DESCRIPTION:
      //
      // The application notifies, if could successfully close all activities or not.
      //
      // PARAMETER:
      //
      // tU8   u8SuccessType    (->I)
      // AIL_C_U8_APP_END_SUCCESSFUL, AIL_C_U8_APP_END_FAILURE
      //
      //
      // RETURNVALUE:
      //
      // none
      //
      //
      // History:
      //
      // 17.04.01 EFG32-Brunke
      // InitialVersion
      //
      // ********************************************************************************
      virtual tVoid vApplicationCloseAcknowledge (tU8 u8SuccessType);

      //## Operation: vApplicationRequestErrorEnd%3BD9276502B4
      // ********************************************************************************
      // DESCRIPTION:
      //
      // Must be used, if ever an appliction wants to please the LocalProcessManager to
      // end the application. Internally this function sends a POWER_MESSAGE to a proxy
      // application of the LocalProcessManager ( LPX ) with the request code AMT_C_U16_
      // PWR_APP_ERROR_DETECT.
      //
      // This function doesn't block, it returns after sending the end request to the
      // LocalProcessManager. After responding of LPX  the "vApplicationEnd()" will be
      // called from AIL.
      //
      // PARAMETER:
      //
      // none
      //
      //
      // RETURNVALUE:
      //
      // none
      //
      //
      // History:
      //
      // 26.10.01 ECC32-Brunke
      // InitialVersion
      //
      // ********************************************************************************
      virtual tVoid vApplicationRequestErrorEnd (tU32 u32ErrorReason = 0);

      //## Operation: u8GetServiceAvailability%3CB3DFBB0092
      virtual tU8 u8GetServiceAvailability (tU16 u16ServiceId);

      //## Operation: vOnAppStateAckFailed%3CC5234C001F
      // ********************************************************************************
      // DESCRIPTION:
      //
      // The interface framework calls "vOnAppStateAckFailed()" whenever a new
      // POWER-Message "STATE_CHANGE_IMMEDIATELY" has been received. As default it
      // mirrors all POWER commands to satisfy the LPM-interface. For specific
      // application behavior, the user must overwrite this function.
      //
      //
      // PARAMETER:
      //
      // tU32   u32OldAppState    (->I)
      // the last confirmed application state
      // tU32   u32AppState    (->I)
      // the new requested application state
      //
      //
      // RETURNVALUE:
      //
      // none
      //
      //
      // History:
      //
      // 23.04.02 ESA1-Seegers
      // InitialVersion
      //
      // ********************************************************************************
      virtual tVoid vOnAppStateAckFailed (tU32 u32OldAppState, tU32 u32AppState);

      //## Operation: vOnCVMEvent%3CC52AB70192
      // ********************************************************************************
      // DESCRIPTION:
      //
      // The interface framework calls "vOnCVMEvent()" whenever a new POWER-Message "CVM_
      // SIGNAL_CHANGED" has been received. For specific application behavior, the user
      // must overwrite this function.
      //
      //
      // PARAMETER:
      //
      // tU32   u32CVMEvent    (->I)
      // the event that occurred at the critical voltage manager
      //
      //
      // RETURNVALUE:
      //
      // none
      //
      //
      // History:
      //
      // 23.04.02 ESA1-Seegers
      // InitialVersion
      //
      // ********************************************************************************
      virtual tVoid vOnCVMEvent (tU32 u32CVMEvent);

      //## Operation: u32GetStartupInfo%3CC52BC60065
      // ********************************************************************
      // Description:
      //
      // This function can be called by the application to retrieve the information
      // about the last reset reason, the start mode and the last download. All these
      // informations are stored in the attribute u32StartupInfo
      // *******************************************************************
      virtual tU32 u32GetStartupInfo () const;

      //## Operation: vRAMInitReady%3CC54C5001C2
      // ********************************************************************
      // DESCRIPTION:
      //
      // This method can be called by the application, if it has initialized all dynamic
      // heap. It is not mandatory (at the moment)
      //
      // 23.04.02 ESA1-Seegers
      // ********************************************************************
      tVoid vRAMInitReady ();

      //## Operation: vSetSystemState%3CC54CD903DC
      // ********************************************************************
      // DESCRIPTION:
      //
      // This method can be called, if an application wants the system to enter a
      // specific state. This is only allowed and possible for there applications, which
      // have been registrated at the system management(here: the developers).
      //
      // 23.04.02 ESA1-Seegers
      // ********************************************************************
      tVoid vSetSystemState (tU32 u32RequestedSysState);

      //## Operation: bSendCCAPowerMsg%3CC54DAA0256
      // *********************************************************************
      // DESCRIPTION:
      //
      // This method sends a CCA-Power message (to the LPM-Proxy). It is called by every
      // method, that provides some kind of communication from the application to the
      // system management concerning power messages. It is the method that actually
      // sends the message.
      //
      // 23.04.02 ESA1-Seegers
      // *********************************************************************
      tBool bSendCCAPowerMsg (tU16 u16RecvId, OSAL_tMQueueHandle hQueueHandle, tU32 u32MsgPrio, tU16 u16PwrType, tU32 u32PwrData1, tU32 u32PwrData2);

	  //## Operation: bSendCCASrvSupplierMsg%3CC54DAA0256
      // *********************************************************************
      // DESCRIPTION:
      //
      // This method sends a CCA-Application Info message (to the LPM-Proxy). It is called by every
      // method, that provides some kind of communication from the application to the
      // system management concerning supplier messages. It is the method that actually
      // sends the message.
      //
      // 23.04.02 ESA1-Seegers
      // *********************************************************************
      tBool bSendAppInfoMsg (tU16 u16ApplicationId, tBool bRegister = TRUE, tBool bUserApplication = TRUE, tBool bListAccessAlreadyTaken = FALSE);

      //## Operation: bSendCCASrvSupplierMsg%3CC54DAA0256
      // *********************************************************************
      // DESCRIPTION:
      //
      // This method sends a CCA-Supplier message (to the LPM-Proxy). It is called by every
      // method, that provides some kind of communication from the application to the
      // system management concerning supplier messages. It is the method that actually
      // sends the message.
      //
      // 23.04.02 ESA1-Seegers
      // *********************************************************************
      tBool bSendCCASrvSupplierMsg (tU16 u16ServiceId, tBool bRegister = TRUE, tBool bUserApplication = TRUE);

      //## Operation: bSendCCAPowerUserTrigger%3CC54DAA0257
      // *********************************************************************
      // DESCRIPTION:
      //
      // This method sends a CCA-Power trigger message (to the LPM-Proxy). 
      // This info can be used by applications to inform the SPM about some 
	  // internal state of the component.
	  // 
      // 23.12.11 Jentsch
      // *********************************************************************
      tBool bSendCCAPowerUserTrigger (tU32 u32PwrData1 = 0);

      //## Operation: vShutdownRequired%3EC9F531010D
      // ********************************************************************************
      // DESCRIPTION:
      //    This method traces callers filename and linenumber and calls directly
      //    vOnShutdownRequired . Use the AIL_M_SHUTDOWN_REQUIRED
      //    or the AIL_M_CHECK_SHUTDOWN-macro if you want to
      //    automatically fill in filename and linenumber
      //
      // PARAMETER:
      //    tBool  bCondition (I):
      //       shutdown-condition (FALSE: shutdown, TRUE: not)
      //    tCString  coszFilename (->I):
      //       filename
      //    tU32      u32Line (I)
      //       linenumber
      //
      // RETURNVALUE:
      // tVoid
      //
      // History:
      // 21.05.03 CM/DI-ESA1-Fischer
      // Initial Version
      //
      // ********************************************************************************
      virtual tVoid vShutdownRequired (tBool bCondition, tCString coszFilename = OSAL_NULL, tU32 u32Line = 0);

      //## Operation: bGetWatchdogInfo%3EF7FE18015B
      // //
      // ********************************************************************************
      // // DESCRIPTION:
      // // bGetWatchdogInfo: method to get information about
      // // a watchdog-object
      // //
      // // PARAMETER:
      // // ail_tWdgHandle hWdgHandle (I):
      // //                get info for this watchdog-object
      // // OSAL_tThreadID &rfThreadID (->O):
      // //                thread-id of supervised thread
      // // OSAL_tMSecond &rfWdgInterval (->O):
      // //                wdg-interval of supervised thread
      // // OSAL_tMSecond &rfMaxInterval (->O):
      // //                max-wdg-interval of supervised thread
      // //
      // // RETURNVALUE:
      // // tVoid
      // //
      // // History:
      // // 26.06.03 CM-DI/ESA1-Fischer
      // // InitialVersion
      // //
      // //
      // ********************************************************************************
      virtual tBool bGetWatchdogInfo (ail_tWdgHandle hWdgHandle, OSAL_tThreadID &rfThreadID, OSAL_tMSecond &rfWdgInterval, OSAL_tMSecond &rfMaxInterval);

      // //
      // ********************************************************************************
      // // DESCRIPTION:
      // // bGetServerRegisteredVersion: method for a client to get the version info related to
      // // a given registration
      // //
      // // PARAMETER:
      // // tU16 u16ServerAppId (I):
      // //                get version info for this server
      // // tU16 u16ClientSubId (I):
      // //                get version info from this client subid
      // // tU16 u16ServiceId (I):
      // //                get version info for this service
      // // tU16 u16RegisterId (I):
      // //                get version info for this registration
      // // tU16 u16MajorVersion (O):
      // //                related major version of given registration
      // // tU16 u16MinorVersion (O):
      // //                related minor version of given registration
      // // tU16 u16PatchVersion (O):
      // //                related patch version of given registration
      // //
      // // RETURNVALUE:
      // // tBool
      // //
      // // History:
      // // 08.04.04 CM-DI/ESN1-Bruns
      // // InitialVersion
      // //
      // //
      // ********************************************************************************
      virtual tBool bGetServerRegisteredVersion(tU16 u16ServerAppId, tU16 u16ClientSubId, tU16 u16ServiceId, tU16 u16RegisterId, tU16& rfu16MajorVersion, tU16& rfu16MinorVersion, tU16& rfu16PatchVersion);

      // //
      // ********************************************************************************
      // // DESCRIPTION:
      // // bGetClientRegisteredVersion: method for a client to get the version info related to
      // // a given registration
      // //
      // // PARAMETER:
      // // tU16 u16RegisterId (I):
      // //                get version info for this registration
      // // tU16 u16MajorVersion (O):
      // //                related major version of given registration
      // // tU16 u16MinorVersion (O):
      // //                related minor version of given registration
      // // tU16 u16PatchVersion (O):
      // //                related patch version of given registration
      // //
      // // RETURNVALUE:
      // // tBool
      // //
      // // History:
      // // 08.04.04 CM-DI/ESN1-Bruns
      // // InitialVersion
      // //
      // //
      // ********************************************************************************
      virtual tBool bGetClientRegisteredVersion(tU16 u16ServiceId, tU16 u16RegisterId, tU16& rfu16MajorVersion, tU16& rfu16MinorVersion, tU16& rfu16PatchVersion);

      // //
      // ********************************************************************************
      // // DESCRIPTION:
      // // u16GetServerRegisteredMajorVersion: method for a client to get the version info related to
      // // a given registration
      // //
      // // PARAMETER:
      // // tU16 u16ServerAppId (I):
      // //                get version info for this server
      // // tU16 u16ClientSubId (I):
      // //                get version info from this client subid
      // // tU16 u16ServiceId (I):
      // //                get version info for this service
      // // tU16 u16RegisterId (I):
      // //                get version info for this registration
      // //
      // // RETURNVALUE:
      // // tU16           related major version of given registration
      // //
      // // History:
      // // 08.04.04 CM-DI/ESN1-Bruns
      // // InitialVersion
      // //
      // //
      // ********************************************************************************
      virtual tU16 u16GetServerRegisteredMajorVersion(tU16 u16ServerAppId, tU16 u16ClientSubId, tU16 u16ServiceId, tU16 u16RegisterId);

      // //
      // ********************************************************************************
      // // DESCRIPTION:
      // // u16GetClientRegisteredMajorVersion: method for a client to get the version info related to
      // // a given registration
      // //
      // // PARAMETER:
      // // tU16 u16RegisterId (I):
      // //                get version info for this registration
      // //
      // // RETURNVALUE:
      // // tU16           related major version of given registration
      // //
      // // History:
      // // 08.04.04 CM-DI/ESN1-Bruns
      // // InitialVersion
      // //
      // //
      // ********************************************************************************
      virtual tU16 u16GetClientRegisteredMajorVersion(tU16 u16ServiceId, tU16 u16RegisterId);

      // //
      // ********************************************************************************
      // // DESCRIPTION:
      // // bPostIpcMessage: This function posts a message with a given priority into a  
      // // specified message queue. ATTENTION: Message will not be delete if posting it 
      // // has failed!! 
      // //
      // // PARAMETER:
      // // tU16 u16MyAppId (I) : identifier of calling application  
      // // OSAL_tMQueueHandle hMQ (I) : handle of queue to post in
      // // amt_tclBaseMessage* poMsgObject (I) : message to be sent
      // // tU32 u32Prio (I) : priority with which message has to be sent
      // //
      // // RETURNVALUE:
      // // tBool
      // //   TRUE     message was sent successfully
      // //   FALSE    message could not be sent
      // //
      // // History:
      // // 08.11.10 CM-AI/PJ-CF33-Kalms
      // // InitialVersion
      // //
      // //
      // ********************************************************************************
      tBool bPostIpcMessage(tU16 u16MyAppId,
                            OSAL_tMQueueHandle hMQ, 
                            amt_tclBaseMessage* poMsgObject, 
                            tU32 u32Prio,
                            tBool bTraceMsg = TRUE);

      // //
      // ********************************************************************************
      // // DESCRIPTION:
      // // This function forwards a CCA message to the internal dispatcher with the
      // // passed priority.
      // // 
      // // The function is typically used by CCA dispatcher applications where the
      // // receiver queue as well as the receiver thread is created and under control
      // // of another external application which just needs the AIL to dispatch the
      // // received CCA message.
      // //
      // // poMessage = CCA message to dispatch 
      // // u32Prio   = priority of the CCA message
      // //
      // // TRUE  = Continue dispatching
      // // FALSE = Stop dispatching
      // //
      // // History:
      // // 24.02.15 CM-AI/CM-AI/EPB2-Kollai
      // // InitialVersion
      // //
      // ********************************************************************************
      virtual tBool bDispatchCCAMessages (amt_tclBaseMessage* poMessage, 
                                          tU32 u32Prio = OSAL_C_U32_MAX);

  protected:

    tVoid vHandleAsyncRegisterConf (tU16 u16RegisterId, tU16 u16ServerAppId, tU16 u16ServiceId, tU16 u16TargetSubId, tU8 u8AsyncRegisterConfStatus);

    virtual tVoid vOnRegistrationRemoved(tU16 u16ServiceId, tU16 u16ServerAppId, tU16 u16SourceSubId);

     // //
     // ********************************************************************************
     // // DESCRIPTION:
     // // vOnServiceSupplierStatus: method for a client to inform about the service supplier status
     // //
     // // PARAMETER:
     // // tU16 u16ServiceId (I): service Id
     // // tU16 u16ServerAppId (I): application which provides the service
     // // tU8 u8SrvSupplierState (I): State of the services
     // //
     // // History:
     // // 20.04.10 CM-DI/TMS Jentsch
     // // InitialVersion
     // //
     // ********************************************************************************
     virtual tVoid vOnServiceSupplierStatus(tU16 u16ServiceId, tU16 u16ServerAppId, tU8 u8SrvSupplierState);

     // //
     // ********************************************************************************
     // // DESCRIPTION:
     // // vOnApplicationInfoStatus: method for a client to inform about the application info status
     // //
     // // PARAMETER:
     // // tU16 u16AppId (I): application which provides the service
     // // tU8 u8AppState (I): State of the services
     // //
     // // History:
     // // 20.04.10 CM-DI/TMS Jentsch
     // // InitialVersion
     // //
     // ********************************************************************************
     virtual tVoid vOnApplicationInfoStatus(tU16 u16ServerAppId, tU8 u8AppState);

    //## Other Operations (specified)
      //## Operation: vTerminateMySelf%3B948C3E0323
      // ********************************************************************************
      // DESCRIPTION:
      //
      // "vTeminateMySelf()" releases all objects it own class expecting thread
      // termination. It confirmed  the application's end to the LPX.
      //
      //
      // PARAMETER:
      //
      // none
      //
      //
      // RETURNVALUE:
      //
      // none
      //
      //
      // History:
      //
      // 04.08.01 CM-DI/ECC32-Brunke
      // InitialVersion
      //
      // ********************************************************************************
      virtual tVoid vTerminateMySelf ();

      //## Operation: bGetServiceVersion%3C67F1FB02CF
      // ********************************************************************************
      // DESCRIPTION:
      //
      // The server application has to override this method to report the
      // actual version number to a given service id
      //
      // PARAMETER:
      //
      // tU16  u16MyServiceID (->I)
      // service id
      // tU16 &  rfu16MajorVersion (->O)
      // major version number
      // tU16 &  rfu16MinorVersion (->O)
      // minor version number
      // tU16 &  rfu16PatchVersion (->O)
      // patch version number
      //
      // RETURNVALUE:
      // tBool
      // TRUE   server supports requested service
      // FALSE  server does not support requested service
      //
      // History:
      //
      // 11.02.02 PDP3-Andres
      // InitialVersion
      //
      // ********************************************************************************
      virtual tBool bGetServiceVersion (tU16 u16ServiceID, tU16 &rfu16MajorVersion, tU16 &rfu16MinorVersion, tU16 &rfu16PatchVersion);

      //## Operation: vOnUnhandledAilException%3EBF3EEF0345
      // ********************************************************************************
      // DESCRIPTION:
      // The interface framework calls "vOnUnhandledAilException()" if the thread-body
      // throws any unhandled exception. As default this function calls an assert.
      // The user has to implement his deinitializations if needed.
      //
      // PARAMETER:
      // none
      //
      // RETURNVALUE:
      // tVoid
      //
      // History:
      // 12.05.03 CM/DI-ESA1-Fischer
      // InitialVersion
      //
      // ********************************************************************************
      virtual tVoid vOnUnhandledAilException ();

      //## Operation: vOnRequiredShutdown%3ECCC312005B
      // ********************************************************************************
      // DESCRIPTION:
      //    This method is called by the ail-interface if a shutdown is required.
      //    This method tries to send an APP_ERROR_DETECT to the
      //    system-power-manager to shutdown the application. If msg-send
      //    fails an ASSERT is called.
      //
      // PARAMETER:
      //    tVoid
      // RETURNVALUE:
      //    tVoid
      //
      // History:
      // 22.05.03 CM/DI-ESA1-Fischer
      // Initial Version
      //
      // ********************************************************************************
      virtual tVoid vOnRequiredShutdown ();

      //## Operation: hCreateWdg%3EF6C4580255
      // //
      // ********************************************************************************
      // // DESCRIPTION:
      // // hCreateWdg: creates new watchdog-object in
      // // internal list and returns a handle to access to it.
      // //
      // // PARAMETER:
      // // TR_tenTraceClass enTraceClass (I):
      // //                trace infos about this watchdog with this trace-class
      // //
      // // RETURNVALUE:
      // // ail_tWdgHandle
      // //    Handle to created watchdog-object,
      // //    OSAL_C_INVALID_HANDLE if failed
      // //
      // // History:
      // // 26.06.03 CM-DI/ESA1-Fischer
      // // InitialVersion
      // //
      // //
      // ********************************************************************************
      virtual ail_tWdgHandle hCreateWdg (TR_tenTraceClass enTraceClass);

      //## Operation: vDeleteWdg%3EF6C482037D
      // //
      // ********************************************************************************
      // // DESCRIPTION:
      // // vDeleteWdg: deletes watchdog-object from internal list
      // //
      // // PARAMETER:
      // // ail_tWdgHandle hWdgHandle (I):
      // //                handle to wdg-object
      // //
      // // RETURNVALUE:
      // // tVoid
      // //
      // // History:
      // // 26.06.03 CM-DI/ESA1-Fischer
      // // InitialVersion
      // //
      // //
      // ********************************************************************************
      virtual tVoid vDeleteWdg (ail_tWdgHandle hWdgHandle);

      //## Operation: bActivateWdg%3EF6C4A8024E
      // //
      // ********************************************************************************
      // // DESCRIPTION:
      // // bActivateWdg: activate wdg-object with given interval
      // //
      // // PARAMETER:
      // // ail_tWdgHandle hWdgHandle (I):
      // //                activate this wdg-object
      // // OSAL_tMSecond WdgInterval (I):
      // //                wdg-interval for this watchdog
      // // OSAL_tMSecond MaxInterval (I):
      // //                max wdg-interval for this watchdog
      // //
      // // RETURNVALUE:
      // // tBool
      // //    TRUE: success, FALSE: not
      // //
      // // History:
      // // 26.06.03 CM-DI/ESA1-Fischer
      // // InitialVersion
      // //
      // //
      // ********************************************************************************
      virtual tBool bActivateWdg (ail_tWdgHandle hWdgHandle, OSAL_tMSecond WdgInterval, OSAL_tMSecond MaxInterval);

      //## Operation: bDeactivateWdg%3EF6C4EA00EF
      // //
      // ********************************************************************************
      // // DESCRIPTION:
      // // bDeactivateWdg: deactivate wdg-object
      // //
      // // PARAMETER:
      // // ail_tWdgHandle hWdgHandle (I):
      // //                deactivate this wdg-object
      // //
      // // RETURNVALUE:
      // // tBool
      // //    TRUE: success, FALSE: not
      // //
      // // History:
      // // 26.06.03 CM-DI/ESA1-Fischer
      // // InitialVersion
      // //
      // //
      // ********************************************************************************
      virtual tBool bDeactivateWdg (ail_tWdgHandle hWdgHandle);

      //## Operation: vTriggerWdgServer%3EF6C5050085
      // //
      // ********************************************************************************
      // // DESCRIPTION:
      // // vTriggerWdgServer: trigger wdg-object
      // //
      // // PARAMETER:
      // // ail_tWdgHandle hWdgHandle (I):
      // //                trigger this wdg-object
      // //
      // // RETURNVALUE:
      // // tVoid
      // //
      // // History:
      // // 26.06.03 CM-DI/ESA1-Fischer
      // // InitialVersion
      // //
      // //
      // ********************************************************************************
      virtual tVoid vTriggerWdgServer (ail_tWdgHandle hWdgHandle);

      //## Operation: vWdgTimerEvent%3EF6CC7402B4
      // //
      // ********************************************************************************
      // // DESCRIPTION:
      // // vWdgTimerEvent: this is the callback-function
      // // for the watchdog-timer
      // //
      // // PARAMETER:
      // // tPVoid pvArg (->I):
      // //                argument is a pointer to the ail-object
      // //
      // // RETURNVALUE:
      // // tVoid
      // //
      // // History:
      // // 26.06.03 CM-DI/ESA1-Fischer
      // // InitialVersion
      // //
      // //
      // ********************************************************************************
      static tVoid vWdgTimerEvent (tPVoid pvArg);

      tVoid vRemoveAllServiceRequests();

      tVoid vRemoveServiceRequest(tU16 u16ServiceId, tU16 u16ServerAppId, tU16 u16SourceSubId, tBool bConsiderServerAppId, tBool bListAccessAlreadyTaken);

    // Data Members for Class Attributes

      //## Attribute: hGeneralListAccess%3A927EF201EA
      //## begin ail_tclAppInterfaceRestricted::hGeneralListAccess%3A927EF201EA.attr preserve=no  protected: OSAL_tSemHandle {UA} OSAL_C_INVALID_HANDLE
      OSAL_tSemHandle hGeneralListAccess;
      //## end ail_tclAppInterfaceRestricted::hGeneralListAccess%3A927EF201EA.attr

      //## Attribute: enInterfaceState%3A9F603303D4
      //## begin ail_tclAppInterfaceRestricted::enInterfaceState%3A9F603303D4.attr preserve=no  protected: ail_tenInterfaceState {UA} AIL_EN_N_APPLICATION_NOT_REGISTERED
      ail_tenInterfaceState enInterfaceState;
      //## end ail_tclAppInterfaceRestricted::enInterfaceState%3A9F603303D4.attr

      //## Attribute: u32LastConfirmedAppState%3AFF812E024B
      //## begin ail_tclAppInterfaceRestricted::u32LastConfirmedAppState%3AFF812E024B.attr preserve=no  protected: tU32 {UA} AMT_C_U32_STATE_UNINITALIZED
      tU32 u32LastConfirmedAppState;
      //## end ail_tclAppInterfaceRestricted::u32LastConfirmedAppState%3AFF812E024B.attr

      //## Attribute: u32ActRequestedAppState%3CB5A0170280
      //## begin ail_tclAppInterfaceRestricted::u32ActRequestedAppState%3CB5A0170280.attr preserve=no  protected: tU32 {UA} AMT_C_U32_STATE_UNINITALIZED
      tU32 u32ActRequestedAppState;
      //## end ail_tclAppInterfaceRestricted::u32ActRequestedAppState%3CB5A0170280.attr

      //## Attribute: u32StartupInfo%3CC52C93033B
      // ********************************************************************
      // DESCRIPTION:
      //
      // This attribute contains the information about the start mode, the last reset
      // reason and the last download. They are coded as follows: bit 0-7 reset reason,
      // bit 8-15 start mode and bit 16-31 last download (see AMT definitions for
      // further details)
      //
      // 23.04.02 ESA1-Seegers
      // *********************************************************************
      //## begin ail_tclAppInterfaceRestricted::u32StartupInfo%3CC52C93033B.attr preserve=no  protected: tU32 {UA} 0
      tU32 u32StartupInfo;
      //## end ail_tclAppInterfaceRestricted::u32StartupInfo%3CC52C93033B.attr

      //## Attribute: u32EntryJumpStackSize%3EBB7C3C034E
      // size of jump-stack for exception-handling of entry-thread
      //## begin ail_tclAppInterfaceRestricted::u32EntryJumpStackSize%3EBB7C3C034E.attr preserve=no  protected: tU32 {UA} u32SizeOfEntryJumpStackSize
      tU32 u32EntryJumpStackSize;
      //## end ail_tclAppInterfaceRestricted::u32EntryJumpStackSize%3EBB7C3C034E.attr

      //## Attribute: u32EntryDestroyStackSize%3EBB7C730382
      // size of destroy-stack for exception-handling of entry-thread
      //## begin ail_tclAppInterfaceRestricted::u32EntryDestroyStackSize%3EBB7C730382.attr preserve=no  protected: tU32 {UA} u32SizeOfEntryDestroyStackSize
      tU32 u32EntryDestroyStackSize;
      //## end ail_tclAppInterfaceRestricted::u32EntryDestroyStackSize%3EBB7C730382.attr

      //## Attribute: bWdgUntriggered%3EF6D2270089
      //## begin ail_tclAppInterfaceRestricted::bWdgUntriggered%3EF6D2270089.attr preserve=no  protected: tBool {UA} FALSE
      tBool bWdgUntriggered;
      //## end ail_tclAppInterfaceRestricted::bWdgUntriggered%3EF6D2270089.attr

    // Data Members for Associations

      ail_tclServerApplicationList* m_poServerApplicationList;

      //## Association: AIL::ApplicationInterface::<unnamed>%3A89184C009F
      //## Role: ail_tclAppInterfaceRestricted::poServiceReferenceList%3A89184D00F1
      //## begin ail_tclAppInterfaceRestricted::poServiceReferenceList%3A89184D00F1.role preserve=no  protected: ail_tclServiceReferenceList {1 -> 1RHgAN}
      ail_tclServiceReferenceList *poServiceReferenceList;
      //## end ail_tclAppInterfaceRestricted::poServiceReferenceList%3A89184D00F1.role

      //## Association: AIL::ApplicationInterface::<unnamed>%3A8927A50027
      //## Role: ail_tclAppInterfaceRestricted::poOpenedQueueList%3A8927A700B6
      //## begin ail_tclAppInterfaceRestricted::poOpenedQueueList%3A8927A700B6.role preserve=no  protected: ail_tclOpenedQueueList {1 -> 1RHgAN}
      ail_tclOpenedQueueList *poOpenedQueueList;
      //## end ail_tclAppInterfaceRestricted::poOpenedQueueList%3A8927A700B6.role

      //## Association: AIL::ApplicationInterface::<unnamed>%3A89321402C7
      //## Role: ail_tclAppInterfaceRestricted::poServiceRegistryList%3A89321500DD
      //## begin ail_tclAppInterfaceRestricted::poServiceRegistryList%3A89321500DD.role preserve=no  protected: ail_tclServiceRegistryList {1 -> 1RHgAN}
      ail_tclServiceRegistryList *poServiceRegistryList;
      //## end ail_tclAppInterfaceRestricted::poServiceRegistryList%3A89321500DD.role

      //## Association: AIL::ApplicationInterface::<unnamed>%3A89321E01B3
      //## Role: ail_tclAppInterfaceRestricted::poServiceSyncAnswerList%3A89321F029A
      //## begin ail_tclAppInterfaceRestricted::poServiceSyncAnswerList%3A89321F029A.role preserve=no  protected: ail_tclServiceSyncAnswerList {1 -> 1RHgAN}
      ail_tclServiceSyncAnswerList *poServiceSyncAnswerList;
      //## end ail_tclAppInterfaceRestricted::poServiceSyncAnswerList%3A89321F029A.role

      //## Association: AIL::ApplicationInterface::<unnamed>%3A9CB3D1019A
      //## Role: ail_tclAppInterfaceRestricted::poInternalDispatch%3A9CB3D30175
      //## begin ail_tclAppInterfaceRestricted::poInternalDispatch%3A9CB3D30175.role preserve=no  protected: ail_tclInternalDispatch { -> 1RHAN}
      ail_tclInternalDispatch *poInternalDispatch;
      //## end ail_tclAppInterfaceRestricted::poInternalDispatch%3A9CB3D30175.role

      //## Association: AIL::ApplicationInterface::<unnamed>%3EA923E102AC
      //## Role: ail_tclAppInterfaceRestricted::poPoolSemaphoreList%3EA923E200D8
      //## begin ail_tclAppInterfaceRestricted::poPoolSemaphoreList%3EA923E200D8.role preserve=no  protected: ail_tclPoolSemaphoreList {1 -> 1RHgAN}
      ail_tclPoolSemaphoreList *poPoolSemaphoreList;
      //## end ail_tclAppInterfaceRestricted::poPoolSemaphoreList%3EA923E200D8.role

      //## Association: AIL::ApplicationInterface::<unnamed>%3EF2D51F0017
      //## Role: ail_tclAppInterfaceRestricted::poWatchdogServer%3EF2D51F0324
      //## begin ail_tclAppInterfaceRestricted::poWatchdogServer%3EF2D51F0324.role preserve=no  protected: ail_tclWatchdogServer {1 -> 1RHgAN}
      ail_tclWatchdogServer *poWatchdogServer;
      //## end ail_tclAppInterfaceRestricted::poWatchdogServer%3EF2D51F0324.role

      // flag to distinguish between applications with 1 or 2 ail-threads
      tBool bHasBodyThread;

      // remember to automatically request time on statechanges
      tBool bAutoRequestTimeOnStateChange;

      tBool bServerApplicationListAvailable();

  public:
      /* --Semaphore to signal after shut down. */
      OSAL_tSemHandle _hLicenseToKill;

      void vTracePendingSyncComm(TR_tenTraceLevel enLevel);
      virtual void vTraceInternalState(TR_tenTraceLevel enLevel);
      virtual void vOnTriggerUserAction(tU8* pu8Data);

  private:

      // avoid copy
      ail_tclAppInterfaceRestricted(const ail_tclAppInterfaceRestricted &corfoAppInterfaceRestricted);
      // avoid assignment
      ail_tclAppInterfaceRestricted& operator=(const ail_tclAppInterfaceRestricted&);

    //## Other Operations (specified)
      //## Operation: bCheckVersionNumber%3C68CE2B0038
      // ********************************************************************************
      // DESCRIPTION:
      //
      // This method checks if the server supports a service in the version
      // requested by the client
      //
      // PARAMETER:
      //
      // tU16  u16MyServiceID (->I)
      // service id
      // tU16 &  rfu16MajorVersion (->IO)
      // major version number requested by client (->I)
      // major version number supported by server if service is supported (->O)
      // major version number requested by client if service is not supported (->O)
      // tU16 &  rfu16MinorVersion (->IO)
      // minor version number requested by client (->I)
      // minor version number supported by server if service is supported (->O)
      // minor version number requested by client if service is not supported (->O)
      // tU16 &  rfu16PatchVersion (->O)
      // patch version number (is invalid if service is not supported by server)
      //
      // RETURNVALUE:
      // tBool
      // TRUE   server supports requested service
      // FALSE  server does not support requested service
      //
      // History:
      //
      // 12.02.02 PDP3-Andres
      // InitialVersion
      //
      // ********************************************************************************
      virtual tBool bCheckVersionNumber (tU16 u16RequestedServiceID, tU16 &rfu16RequestedMajorNumber, tU16 &rfu16RequestedMinorNumber, tU16 &rfu16RequestedPatchNumber);

      //## Operation: vAppEntry%3A8D1E71014A
      // ********************************************************************************
      // DESCRIPTION:
      //
      // "vAppEntry()" is the first method of the "ail_tclAppAdapt" wich is called from
      // the inteface thread.  As operation of "ail_tclAppInterfaceRestricted"-class
      // this function contains "ReveiceMessage" and the dispatcher for the whole
      // interface framework. "ReleaseMessage" is only done for REGISTER- and
      // POWER-messages. This function may only be overwritten if a annother kind of
      // framework dispatching shall be implemented here.
      //
      //
      // PARAMETER:
      //
      // tVoid
      //
      //
      // RETURNVALUE:
      //
      // none
      //
      //
      // History:
      //
      // 12.02.01 EFG32-Brunke
      // InitialVersion
      //
      // ********************************************************************************
      virtual tVoid vAppEntry ();

      //## Operation: bCreateRegisterId%3A110D480220
      // ********************************************************************************
      // DESCRIPTION:
      //
      // This function looks for occupied RegisterIds and creates a new one. To prevent,
      // that an application gets the same RegisterId as last time used, it distributs
      // always a new RegisterId. After overflow of the u16RegisterCount, beginning from
      // 1 the first free RegisterId will be distributed.
      // If a derivated class wants to overwrite it, it's the user's responsibilty
      // always to generate a none used RegisterId. If ever "vOnAcceptNewRegister()" is
      // overwritten and an independent RegisterId generation mechanism is implemented,
      // "bCreateRegisterId()" is not used anymore and needn't be touched. It returns
      // TRUE, if RegisterId is vaild, else FALSE will be returned.
      //
      //
      // PARAMETER:
      // tU16    u16ClientAppId (I->)
      // application id of requesting client
      // tU16    u16ClientSubId
      // application sub id of requesting client
      // tU16*   pu16RegisterId    (->I/0)
      // memory address to return the RegisterId
      //
      //
      // RETURNVALUE:
      //
      // tBool
      // TRUE/FALSE
      //
      //
      // History:
      //
      // 12.02.01 EFG32-Brunke
      // InitialVersion
      //
      // ********************************************************************************
      virtual tBool bCreateRegisterId (tU16 u16ServiceId, tU16 u16ClientAppId, tU16 u16ClientSubId, tU16* pu16RegisterId);

      //## Operation: vUnknownRegisterConf%3D5A6748022D
      virtual tVoid vUnknownRegisterConf (amt_tclServiceRegisterConf& rfoServiceRegisterConf);

      tVoid vHandleCcaMsgQueueFull(tU16 u16AppId);

    // Data Members for Class Attributes

      //## Attribute: u16LastDestributedRegisterId%3B263EF502BB
      //## begin ail_tclAppInterfaceRestricted::u16LastDestributedRegisterId%3B263EF502BB.attr preserve=no  private: tU16 {UA} 
      tU16 u16LastDestributedRegisterId;
      //## end ail_tclAppInterfaceRestricted::u16LastDestributedRegisterId%3B263EF502BB.attr

  //private: //## implementation
  //## begin ail_tclAppInterfaceRestricted%3A10FC06005B.friends preserve=no
    friend class ail_tclInternalDispatch;
    friend class ail_tclWatchdog;
  //## end ail_tclAppInterfaceRestricted%3A10FC06005B.friends
};


//## Class: ail_tclOneThreadAppInterface%3D591B940229
//## Category: AIL::ApplicationInterface%3A364930013E
//## Subsystem: Ail::Include%3A841A9E02B0
//## Persistence: Transient
//## Cardinality/Multiplicity: n


class ail_tclOneThreadAppInterface : public ail_tclAppInterfaceRestricted  //## Inherits: <unnamed>%3D591B9F0258
{
  public:
    //## Constructors (specified)
      //## Operation: ail_tclOneThreadAppInterface%3D60A0150046
      // parameter:
      //    tU32 u32SizeOfEntryJumpStackSize (I)
      //       needed for exception-handling
      //    tU32 u32SizeOfEntryDestroyStackSize (I)
      //       needed for exception-handling
      ail_tclOneThreadAppInterface (tU32 u32SizeOfEntryJumpStackSize = AIL_C_U32_ENTRY_JUMP_STACKSIZE, tU32 u32SizeOfEntryDestroyStackSize = AIL_C_U32_ENTRY_DESTROY_STACKSIZE);

    //## Destructor (specified)
      //## Operation: ~ail_tclOneThreadAppInterface%3D60A0390383
      virtual ~ail_tclOneThreadAppInterface ();


    //## Other Operations (specified)
      //## Operation: bInitInstance%3D609C960306
      virtual tBool bInitInstance (tU16 u16NewLpmId, tU16 u16MyAppId, OSAL_tThreadID hExternalDispatcherThreadID = OSAL_ERROR);

      //## Operation: vDeinitInstance%3D609CAC039F
      virtual tVoid vDeinitInstance ();

      //## Operation: vOnAsyncRegisterConf%3D591F130006
      // ********************************************************************************
      // DESCRIPTION:
      //
      // This function is called by the AIL-framework in the contex of the entry thread,
      // when ever a "RegisterConf"-message is received and the reference table hasn't
      // defined any waiting condition for this service, i.e. this answer isn't
      // synchronously awaited.
      // Because requesting a RegisterId is supervised by AIL, "vOnAsyncRegisterConf" is
      // called with the parameter u16RegisterId== AMT_C_U16_REGID_INVALID, when there
      // wasn't received any  answer within registration timeout of C_U32_REGISTER_CONF_
      // WAIT.
      //
      // ATTENTION: The asynchronous registration mechanism can only be used for Source
      // SubID = 0x0000!
      //
      // PARAMETER:
      //
      // tU16  u16RegisterId (->I)
      // the new RegisterId or AMT_C_U16_REGID_INVALID
      // ( in case of TOUT or negative confirmation )
      //
      // tU16 u16ServerAppId (->I)
      // the provider of the requested service
      //
      // tU16  u16ServiceId   (->I)
      // the requested service
      //
      // tU16 u16SourceSubID (->I)
      // the own SourceSubID
      //
      // RETURNVALUE:
      //
      // none
      //
      //
      // History:
      //
      // 13.08.02 EHS4-Brunke
      // InitialVersion
      //
      // ********************************************************************************
      virtual tVoid vOnAsyncRegisterConf (tU16 u16RegisterId, tU16 u16ServerAppId, tU16 u16ServiceId, tU16 u16TargetSubId);

      virtual tVoid vOnAsyncRegisterConfExt (tU16 u16RegisterId, tU16 u16ServerAppId, tU16 u16ServiceId, tU16 u16TargetSubId, tU8 u8AsyncRegisterConfStatus);

      //## Operation: bRegisterAsync%3D591EF0019C
      // ********************************************************************************
      // DESCRIPTION:
      //
      // The function "bRegisterAync()" can only be called in the context of the entry
      // thread and shall make possible to design "OneThread"-AIL applications.
      //
      // It immediatly returns after posting the "Register"-message to the client. The
      // user is responsible to memorized, that a registration request was sent. AIL
      // makes sure, always an answer will be asynchronously generated by ending in a
      // function call of "vOnAysncRegisterConf()".
      //
      // ATTENTION: The asynchronous registration mechanism can only be used for Source
      // SubID = 0x0000!
      //
      // PARAMETER:
      //
      // tU16  u16ServiceId   (->I)
      // the requested service
      // tU16 u16ServiceMajorVersion (->I)
      // major version of the demanded service ( default: 0x0000 )
      // tU16 u16ServiceMinorVersion (->I)
      // minor version of the demanded service ( default: 0x0000 )
      // tU16 u16SourceSubID ( ->I)
      // sub id of source ( default: 0x0000 )
      // tU16  u16ServerAppId  (->I)
      // the Id of the server which offers the service ( default: AMT_C_U16_APPID_
      // INVALID )
      //
      // RETURNVALUE:
      //
      // tBool
      // TRUE, if successfully posted
      // FALSE, in case of error ( no provider, impossible to post, SourceSubID!=0x0000 )
      //
      // History:
      //
      // 13.08.02 EHS4-Brunke
      // InitialVersion
      //
      // ********************************************************************************
      virtual tBool bRegisterAsync (tU16 u16ServiceId, tU16 u16ServiceMajorVersion, tU16 u16ServiceMinorVersion = 0x0000, tU16 u16SourceSubID = 0x0000, tU16 u16ServerAppId = AMT_C_U16_APPID_INVALID);

      virtual tBool bRegisterAsyncExecute (tU16 u16ServiceId, tU16 u16ServiceMajorVersion, tU16 u16ServiceMinorVersion, tU16 u16SourceSubID, tU16 u16ServerAppId, tBool bListAccessAlreadyTaken = FALSE);

      //## Operation: vTriggerAsyncRegisterTout%3D60EB9D0074
      static tVoid vTriggerAsyncRegisterTout (tVoid* pvArg);

      // Offer timer handle and pointer to async-register-request-list via a get method 
      // for test purposes (set time to eg. 1 ms to let it expire immediately).
      OSAL_tTimerHandle hGetAsyncRegisterTimerHandle() { return hAsyncRegisterTimer; }
      ail_tclAsyncRegisterReqList* poGetAsyncRegisterReqList() { return poAsyncRegisterReqList; }

  protected:

    //## Other Operations (specified)
      //## Operation: vTerminateMySelf%3D60B041039D
      virtual tVoid vTerminateMySelf ();

    // Data Members for Associations

      //## Association: AIL::ApplicationInterface::<unnamed>%3D5CF65100AF
      //## Role: ail_tclOneThreadAppInterface::poAsyncRegisterReqList%3D5CF652012C
      //## begin ail_tclOneThreadAppInterface::poAsyncRegisterReqList%3D5CF652012C.role preserve=no  protected: ail_tclAsyncRegisterReqList {1 -> 1RHgAN}
      ail_tclAsyncRegisterReqList *poAsyncRegisterReqList;
      //## end ail_tclOneThreadAppInterface::poAsyncRegisterReqList%3D5CF652012C.role

    //## Other Operations (specified)
      //## Operation: vUnknownRegisterConf%3D5A6882017A
      virtual tVoid vUnknownRegisterConf ( amt_tclServiceRegisterConf& rfoServiceRegisterConf );

    // Data Members for Class Attributes

      //## Attribute: hAsyncRegisterTimer%3D60ECBA0047
      //## begin ail_tclOneThreadAppInterface::hAsyncRegisterTimer%3D60ECBA0047.attr preserve=no  private: OSAL_tTimerHandle {UA} 
      OSAL_tTimerHandle hAsyncRegisterTimer;
      //## end ail_tclOneThreadAppInterface::hAsyncRegisterTimer%3D60ECBA0047.attr

  private:

      // avoid copy
      ail_tclOneThreadAppInterface(const ail_tclOneThreadAppInterface &corfoOneThreadAppInterface);
      // avoid assignment
      ail_tclOneThreadAppInterface& operator=(const ail_tclOneThreadAppInterface&);
};

//## Class: ail_tclAppInterface%3A9229980079
//## Category: AIL::ApplicationInterface%3A364930013E
//## Subsystem: Ail::Include%3A841A9E02B0
//## Persistence: Transient
//## Cardinality/Multiplicity: n


class ail_tclAppInterface : public ail_tclOneThreadAppInterface  //## Inherits: <unnamed>%3A922A290140
{
  public:
    //## Constructors (specified)
      //## Operation: ail_tclAppInterface%3B2F22D70014
      // parameter:
      //    tU32 u32SizeOfEntryJumpStackSize (I)
      //       needed for exception-handling
      //    tU32 u32SizeOfEntryDestroyStackSize (I)
      //       needed for exception-handling
      //    tU32 u32SizeOfBodyJumpStackSize (I)
      //       needed for exception-handling
      //    tU32 u32SizeOfBodyDestroyStackSize (I)
      //       needed for exception-handling
      ail_tclAppInterface (tU32 u32SizeOfEntryJumpStackSize = AIL_C_U32_ENTRY_JUMP_STACKSIZE, tU32 u32SizeOfEntryDestroyStackSize = AIL_C_U32_ENTRY_DESTROY_STACKSIZE, tU32 u32SizeOfBodyJumpStackSize = AIL_C_U32_BODY_JUMP_STACKSIZE, tU32 u32SizeOfBodyDestroyStackSize = AIL_C_U32_BODY_DESTROY_STACKSIZE);

    //## Destructor (specified)
      //## Operation: ~ail_tclAppInterface%3B2F22FA0190
      virtual ~ail_tclAppInterface ();


    //## Other Operations (specified)
      //## Operation: bInitInstance%3A9229FC0145
      virtual tBool bInitInstance (tU16 u16NewLpmId, tU16 u16MyAppId, OSAL_tThreadID hExternalDispatcherThreadID = OSAL_ERROR);

      //## Operation: vDeinitInstance%3A9D20AA03D3
      virtual tVoid vDeinitInstance ();

      //## Operation: hGetIntermediateInQueue%3B937C1300A2
      OSAL_tMQueueHandle hGetIntermediateInQueue () const;

  protected:

    //## Other Operations (specified)
      //## Operation: vTerminateMySelf%3B98A32100EE
      // ********************************************************************************
      // DESCRIPTION:
      //
      // "vTeminateMySelf()" releases all objects it own class expecting thread
      // termination. It calls the "vTerminateMySelf()"-function of base class to inform
      // the LPX about application end.
      //
      //
      // PARAMETER:
      //
      // none
      //
      //
      // RETURNVALUE:
      //
      // none
      //
      //
      // History:
      //
      // 04.08.01 CM-DI/ECC32-Brunke
      // InitialVersion
      //
      // ********************************************************************************
      virtual tVoid vTerminateMySelf ();

      //## Operation: vEntryEndNotification%3B98A5640014
      virtual tVoid vEntryEndNotification ();

      //## Attribute: hIntermediateInQueue%3A92456301B0
      //## begin ail_tclAppInterface::hIntermediateInQueue%3A92456301B0.attr preserve=no  private: OSAL_tMQueueHandle {UA} 
      OSAL_tMQueueHandle hIntermediateInQueue;
      //## end ail_tclAppInterface::hIntermediateInQueue%3A92456301B0.attr

  private:

    //## Other Operations (specified)
      //## Operation: vAppEntry%3A928EBD02B5
      virtual tVoid vAppEntry ();

      //## Operation: vAppBody%3A922A5600C2
      virtual tVoid vAppBody ();

      //## Operation: vStartAppBody%3A922A5B035E
      static tVoid vStartAppBody (tVoid* pvArg);

    // Data Members for Class Attributes

      //## Attribute: hBodyThreadID%3A92454F03C4
      //## begin ail_tclAppInterface::hBodyThreadID%3A92454F03C4.attr preserve=no  private: OSAL_tThreadID {UA} 
      OSAL_tThreadID hBodyThreadID;
      //## end ail_tclAppInterface::hBodyThreadID%3A92454F03C4.attr

      //## Attribute: u32BodyJumpStackSize%3EBB7D02016B
      //## begin ail_tclAppInterface::u32BodyJumpStackSize%3EBB7D02016B.attr preserve=no  private: tU32 {UA} 
      tU32 u32BodyJumpStackSize;
      //## end ail_tclAppInterface::u32BodyJumpStackSize%3EBB7D02016B.attr

      //## Attribute: u32BodyDestroyStackSize%3EBB7D0B0321
      //## begin ail_tclAppInterface::u32BodyDestroyStackSize%3EBB7D0B0321.attr preserve=no  private: tU32 {UA} 
      tU32 u32BodyDestroyStackSize;
      //## end ail_tclAppInterface::u32BodyDestroyStackSize%3EBB7D0B0321.attr
};


// Class ail_tclAppAdapt 

// Class ail_tclAppInterfaceRestricted 

// Class ail_tclAppInterface 

// Class ail_tclOneThreadAppInterface 

//## begin module%3A841C9C0213.epilog preserve=yes

/*************************************************************************
| dummy function declaration for DLL substitution ( skope: modul-global )
|*************************************************************************/
tVoid dummy_ail_dll(tVoid);

//## end module%3A841C9C0213.epilog


#endif
