/******************************************************************************
 * FILE:          ail_trace.cpp
 * SW-COMPONENT:  AIL
 * DESCRIPTION:   allows formatted tracing 
 * AUTHOR:        EFG32-Brunke   
 * COPYRIGHT:     (c) 2001 Robert Bosch GmbH, Hildesheim
 * HISTORY:      
 ******************************************************************************/

/******************************************************************************
| includes                                                                    
|   1)system- and project- includes
|   2)needed interfaces from external components
|   3)internal and external interfaces from this component 
|-----------------------------------------------------------------------------*/


// regular includes
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#ifndef TRACE_S_ALREADY_INCLUDE_TYPES
#define TRACE_S_IMPORT_INTERFACE_TYPES
#include "trace_if.h"
#endif

#define AIL_S_IMPORT_INTERFACE_GENERIC
#define AIL_S_IMPORT_INTERFACE_TRACE
#include "ail_if.h"

#define ERR_S_IMPORT_INTERFACE_ERRMEM
#include "err_if.h"

#define SCD_S_IMPORT_INTERFACE_GENERIC
#include "scd_if.h"

/******************************************************************************
| defines and macros (scope: modul-local)
|-----------------------------------------------------------------------------*/

// number of digits per line in hexdump of message
#define AIL_C_U32_DIGITS_PER_LINE   (tU32)32

// limitation of character to be printed out in a pure HEX dump
#define AIL_C_U32_CHARLIMIT_MSGHEADER  (tU32)32
#define AIL_C_U32_CHARLIMIT_PAYLOAD32  (tU32)64
#define AIL_C_U32_CHARLIMIT_PAYLOAD64  (tU32)96
#define AIL_C_U32_CHARLIMIT_MSGFULL    (tU32)0xFFFFFFFF

/******************************************************************************
| typedefs (scope: modul-local)
|-----------------------------------------------------------------------------*/
#ifdef AIL_MESSAGE_COUNTER_ENABLED
#define AIL_MESSAGE_COUNTER_SHMEM_NAME "AIL_MEM_MSG_CNT"
#define AIL_MESSAGE_COUNTER_FILTER_SHMEM_NAME "AIL_MEM_MSG_CNT_FILTER"
#define AIL_MESSAGE_COUNTER_NO_FILTER 0xFFFF
#endif
/******************************************************************************
| variable definition (scope: global)
|-----------------------------------------------------------------------------*/

tS32            ail_s32RefCount          = 0;
OSAL_tSemHandle hSemAilTrace             = OSAL_C_INVALID_HANDLE;
const tChar     coszAilTraceSemName[]    = "AIL_TRACE_SEMAPHORE";
tBool           bAilTraceSemphoreCreated = FALSE;

#ifdef AIL_MESSAGE_COUNTER_ENABLED
struct S_CCA_Info_Struct
{
   tU32 u32_SendedFromCounter;
   tU32 u32_SendedToCounter;
   tU32 u32_SendedFromSize;
   tU32 u32_SendedToSize;

   tU32 u32_ReceivedFromCounter;
   tU32 u32_ReceivedByCounter;
   tU32 u32_ReceivedFromSize;
   tU32 u32_ReceivedBySize;
} S_CCA_Info;

struct S_CCA_Filter_Struct
{
   tU16 nCCA_Info_Send_Filter;
   tU16 nCCA_Info_Receive_Filter;
} S_CCA_Filter;

S_CCA_Info_Struct* spCCA_Info_Array = NULL;
S_CCA_Filter_Struct* spCCA_Filter = NULL;
#endif


/******************************************************************************
| variable definition (scope: modul-local)
|-----------------------------------------------------------------------------*/

static OSAL_tIODescriptor rAilTraceIODescriptor = OSAL_ERROR;

#define ELEMENTS(array)       ((tU16)(sizeof(array)/sizeof(array[0])))

/* this table must be sorted from lower to upper value, because this is expected by the search algorithm */
const rAppOrSrvToTraceClassRef carAppToTraceClassRef[]=
{
   { CCA_C_U16_APP_SPM,                                           TR_CLASS_APPREC_AIL_SPM},
   { CCA_C_U16_APP_NAVI,                                          TR_CLASS_APPREC_AIL_NAVI},
   { CCA_C_U16_APP_OBN,                                           TR_CLASS_APPREC_AIL_OBN},
   { CCA_C_U16_APP_TIMA,                                          TR_CLASS_APPREC_AIL_TIMA},
   { CCA_C_U16_APP_MA,                                            TR_CLASS_APPREC_AIL_MA},
   { CCA_C_U16_APP_DATA_SERVER,                                   TR_CLASS_APPREC_AIL_DATA_SERVER},
   { CCA_C_U16_APP_VOICE,                                         TR_CLASS_APPREC_AIL_VOICE},
   { CCA_C_U16_APP_BASIC,                                         TR_CLASS_APPREC_AIL_BASIC},
   { CCA_C_U16_APP_TELEFON,                                       TR_CLASS_APPREC_AIL_TELEFON},
   { CCA_C_U16_APP_INFOTAINMENT,                                  TR_CLASS_APPREC_AIL_INFOTAINMENT},
   { CCA_C_U16_APP_COMCCA_GW,                                     TR_CLASS_APPREC_AIL_COMCCA_GW},
   { CCA_C_U16_APP_DOWNLOAD,                                      TR_CLASS_APPREC_AIL_DOWNLOAD},
   { CCA_C_U16_APP_SELFTEST,                                      TR_CLASS_APPREC_AIL_SELFTEST},
   { CCA_C_U16_APP_TMC,                                           TR_CLASS_APPREC_AIL_TMC},
   { CCA_C_U16_APP_SINA,                                          TR_CLASS_APPREC_AIL_SINA},
   { CCA_C_U16_APP_MCU,                                           TR_CLASS_APPREC_AIL_MCU},
   { CCA_C_U16_APP_FC_TEA,                                        TR_CLASS_APPREC_AIL_FC_TEA},
   { CCA_C_U16_APP_FC_DIAGNOSIS,                                  TR_CLASS_APPREC_AIL_FC_DIAGNOSIS},
   { CCA_C_U16_APP_FC_CLIMATE,                                    TR_CLASS_APPREC_AIL_FC_CLIMATE},
   { CCA_C_U16_APP_FC_STATISTICS,                                 TR_CLASS_APPREC_AIL_FC_STATISTICS},
   { CCA_C_U16_APP_FC_WDB,                                        TR_CLASS_APPREC_AIL_FC_WDB},
   { CCA_C_U16_APP_FC_WEBSEARCH,                                  TR_CLASS_APPREC_AIL_FC_WEBSEARCH},
   { CCA_C_U16_APP_FC_LOCINPUT,                                   TR_CLASS_APPREC_AIL_FC_LOCINPUT},
   { CCA_C_U16_APP_FC_SYNCATLANTICWIZ,                            TR_CLASS_APPREC_AIL_FC_SYNCATLANTICWIZ},
   { CCA_C_U16_APP_DEVICEMANAGER,                                 TR_CLASS_APPREC_AIL_DEVICEMANAGER},
   { CCA_C_U16_APP_SPM_SLV,                                       TR_CLASS_APPREC_AIL_SPM_SLV},
   { CCA_C_U16_APP_FC_PDC,                                        TR_CLASS_APPREC_AIL_FC_PDC},
   { CCA_C_U16_APP_VD_TOUCH,                                      TR_CLASS_APPREC_AIL_VD_TOUCH},
   { CCA_C_U16_APP_INTERACTIONLOGGER,                             TR_CLASS_APPREC_AIL_INTERACTIONLOGGER},
   { CCA_C_U16_APP_KBD,                                           TR_CLASS_APPREC_AIL_KBD},
   { CCA_C_U16_APP_MMGR,                                          TR_CLASS_APPREC_AIL_MMGR},
   { CCA_C_U16_APP_CLUSTER,                                       TR_CLASS_APPREC_AIL_CLUSTER},
   { CCA_C_U16_APP_FC_REMOTE_DISPLAY,                             TR_CLASS_APPREC_AIL_FC_REMOTE_DISPLAY},
   { CCA_C_U16_APP_VD_DIMMING,                                    TR_CLASS_APPREC_AIL_VD_DIMMING},
   { CCA_C_U16_APP_FC_UAM,                                        TR_CLASS_APPREC_AIL_FC_UAM},
   { CCA_C_U16_APP_FC_HEATCTRL,                                   TR_CLASS_APPREC_AIL_FC_HEATCTRL},
   { CCA_C_U16_APP_FC_SECURITY,                                   TR_CLASS_APPREC_AIL_FC_SECURITY},
   { CCA_C_U16_APP_VD_GRAPHIC_ABSTRACTION,                        TR_CLASS_APPREC_AIL_VD_GRAPHIC_ABSTRACTION},
   { CCA_C_U16_APP_VD_CLOCK,                                      TR_CLASS_APPREC_AIL_VD_CLOCK},
   { CCA_C_U16_APP_FC_AUXCTRL_EXTBOX,                             TR_CLASS_APPREC_AIL_FC_AUXCTRL_EXTBOX},
   { CCA_C_U16_APP_EXT_VR,                                        TR_CLASS_APPREC_AIL_EXT_VR},
   { CCA_C_U16_APP_FC_MDI,                                        TR_CLASS_APPREC_AIL_FC_MDI},
   { CCA_C_U16_APP_FC_TUNERSYNC,                                  TR_CLASS_APPREC_AIL_FC_TUNERSYNC},
   { CCA_C_U16_APP_FC_DABTUNER,                                   TR_CLASS_APPREC_AIL_FC_DABTUNER},
   { CCA_C_U16_APP_VD_VEHICLE_DATA,                               TR_CLASS_APPREC_AIL_VD_VEHICLE_DATA},
   { CCA_C_U16_APP_FC_OPS,                                        TR_CLASS_APPREC_AIL_FC_OPS},
   { CCA_C_U16_APP_VD_RVC,                                        TR_CLASS_APPREC_AIL_VD_RVC},
   { CCA_C_U16_APP_FC_CHIME,                                      TR_CLASS_APPREC_AIL_FC_CHIME},
   { CCA_C_U16_APP_FC_IPOD,                                       TR_CLASS_APPREC_AIL_FC_IPOD},
   { CCA_C_U16_APP_FC_ADASHORIZON,                                TR_CLASS_APPREC_AIL_FC_ADASHORIZON},
   { CCA_C_U16_APP_FC_NAVREPEATER,                                TR_CLASS_APPREC_AIL_FC_NAVREPEATER },
   { CCA_C_U16_APP_FC_MEDIAPLAYER_EXTBOX,                         TR_CLASS_APPREC_AIL_FC_MEDIAPLAYER_EXTBOX},
   { CCA_C_U16_APP_FC_TUNER_EXTBOX,                               TR_CLASS_APPREC_AIL_FC_TUNER_EXTBOX},
   { CCA_C_U16_APP_FC_VEHICLEFUNCTION_EXTBOX,                     TR_CLASS_APPREC_AIL_FC_VEHICLEFUNCTION_EXTBOX},
   { CCA_C_U16_APP_FC_AUDIO_EXTBOX,                               TR_CLASS_APPREC_AIL_FC_AUDIO_EXTBOX},
   { CCA_C_U16_APP_FC_XM_TUNER,                                   TR_CLASS_APPREC_AIL_FC_XM_TUNER},
   { CCA_C_U16_APP_FC_UPS,                                        TR_CLASS_APPREC_AIL_FC_UPS},
   { CCA_C_U16_APP_FC_REMOTE_CLIENT,                              TR_CLASS_APPREC_AIL_FC_REMOTE_CLIENT},
   { CCA_C_U16_APP_VD_ADASIS,                                     TR_CLASS_APPREC_AIL_VD_ADASIS},
   { CCA_C_U16_APP_FC_LOGBOOK,                                    TR_CLASS_APPREC_AIL_FC_LOGBOOK},
   { CCA_C_U16_APP_FC_VIDEO,                                      TR_CLASS_APPREC_AIL_FC_VIDEO},
   { CCA_C_U16_APP_VD_CAPCTRL,                                    TR_CLASS_APPREC_AIL_VD_CAPCTRL},
   { CCA_C_U16_APP_VD_VEHICLE_SENSOR,                             TR_CLASS_APPREC_AIL_VD_VEHICLE_SENSOR},
   { CCA_C_U16_APP_FC_ASSIST,                                     TR_CLASS_APPREC_AIL_FC_ASSIST},
   { CCA_C_U16_APP_FC_EXTKI,                                      TR_CLASS_APPREC_AIL_FC_EXTKI},
   { CCA_C_U16_APP_PREDICTIVE_DRIVING,                            TR_CLASS_APPREC_AIL_PREDICTIVE_DRIVING},
   { CCA_C_U16_APP_VD_EHPROV,                                     TR_CLASS_APPREC_AIL_VD_EHPROV},
   { CCA_C_U16_APP_FC_CBS,                                        TR_CLASS_APPREC_AIL_FC_CBS},
   { CCA_C_U16_APP_FC_DATAPROVIDER,                               TR_CLASS_APPREC_AIL_FC_DATAPROVIDER},
   { CCA_C_U16_APP_DP_TEST_CLIENT,                                TR_CLASS_APPREC_AIL_DP_TEST_CLIENT},
   { CCA_C_U16_APP_FC_MCAN_METER,                                 TR_CLASS_APPREC_AIL_FC_MCAN_METER},
   { CCA_C_U16_APP_FC_TELEMATIC,                                  TR_CLASS_APPREC_AIL_FC_TELEMATIC},
   { CCA_C_U16_APP_FC_CANCOMM,	                                  TR_CLASS_APPREC_AIL_FC_CANCOMM},
   { CCA_C_U16_APP_FC_MEMNAVIDB,	                          TR_CLASS_APPREC_AIL_FC_MEMNAVIDB},
   { CCA_C_U16_APP_MOSTTestServer,                                TR_CLASS_APPREC_AIL_MOSTTestServer},
   { CCA_C_U16_APP_SystemInfo,                                    TR_CLASS_APPREC_AIL_SystemInfo},
   { CCA_C_U16_APP_DABDATA,                                       TR_CLASS_APPREC_AIL_DABDATA},
   { CCA_C_U16_APP_AUDIOCUES,                                     TR_CLASS_APPREC_AIL_AUDIOCUES},
   { CCA_C_U16_APP_ANIMATION,                                     TR_CLASS_APPREC_AIL_ANIMATION},
   { CCA_C_U16_APP_STREAMROUTER,                                  TR_CLASS_APPREC_AIL_STREAMROUTER},
   { CCA_C_U16_APP_DRVASS_VIDEO_EARLY,                            TR_CLASS_APPREC_AIL_DRVASS_VIDEO_EARLY},
   { CCA_C_U16_APP_DRVASS_VIDEO,                                  TR_CLASS_APPREC_AIL_DRVASS_VIDEO},
   { CCA_C_U16_APP_FAVORITESBACKUP,                               TR_CLASS_APPREC_AIL_FAVORITESBACKUP},
   { CCA_C_U16_APP_TOUCHDISPLAY,                                  TR_CLASS_APPREC_AIL_TOUCHDISPLAY},
   { CCA_C_U16_APP_INTERNETAPPLICATIONS,                          TR_CLASS_APPREC_AIL_INTERNETAPPLICATIONS},
   { CCA_C_U16_APP_INTERNETRADIO,                                 TR_CLASS_APPREC_AIL_INTERNETRADIO},
   { CCA_C_U16_APP_MEDIAPLAYER,                                   TR_CLASS_APPREC_AIL_MEDIAPLAYER},
   { CCA_C_U16_APP_IPODAUTH,                                      TR_CLASS_APPREC_AIL_IPODAUTH},
   { CCA_C_U16_APP_NAVSTORAGE,                                    TR_CLASS_APPREC_AIL_NAVSTORAGE},
   { CCA_C_U16_APP_LOCATIONBASEDSERVICE,                          TR_CLASS_APPREC_AIL_LOCATIONBASEDSERVICE},
   { CCA_C_U16_APP_NAVCOPY,                                       TR_CLASS_APPREC_AIL_NAVCOPY},
   { CCA_C_U16_APP_NAVEXTHMI,                                     TR_CLASS_APPREC_AIL_NAVEXTHMI},
   { CCA_C_U16_APP_BLUETOOTH,                                     TR_CLASS_APPREC_AIL_BLUETOOTH},
   { CCA_C_U16_APP_MESSAGING,                                     TR_CLASS_APPREC_AIL_MESSAGING},
   { CCA_C_U16_APP_PHONEBOOK,                                     TR_CLASS_APPREC_AIL_PHONEBOOK},
   { CCA_C_U16_APP_RADIODATA,                                     TR_CLASS_APPREC_AIL_RADIODATA},
   { CCA_C_U16_APP_SAALS,                                         TR_CLASS_APPREC_AIL_SAALS},
   { CCA_C_U16_APP_AVMANAGER,                                     TR_CLASS_APPREC_AIL_AVMANAGER},
   { CCA_C_U16_APP_NAAGS,                                         TR_CLASS_APPREC_AIL_NAAGS},
   { CCA_C_U16_APP_IPODCONTROL,                                   TR_CLASS_APPREC_AIL_IPODCONTROL},
   { CCA_C_U16_APP_AVTESTSERVER,                                  TR_CLASS_APPREC_AIL_AVTESTSERVER},
   { CCA_C_U16_APP_VOLUMECONTROL,                                 TR_CLASS_APPREC_AIL_VOLUMECONTROL},
   { CCA_C_U16_APP_TEST_SERVER_A,                                 TR_CLASS_APPREC_AIL_TEST_SERVER_A},
   { CCA_C_U16_APP_TEST_SERVER_B,                                 TR_CLASS_APPREC_AIL_TEST_SERVER_B},
   { CCA_C_U16_APP_TEST_SERVER_C,                                 TR_CLASS_APPREC_AIL_TEST_SERVER_C},
   { CCA_C_U16_APP_TEST_SERVER_D,                                 TR_CLASS_APPREC_AIL_TEST_SERVER_D},
   { CCA_C_U16_APP_TEST_CLIENT_A1,                                TR_CLASS_APPREC_AIL_TEST_CLIENT_A1},
   { CCA_C_U16_APP_TEST_CLIENT_A2,                                TR_CLASS_APPREC_AIL_TEST_CLIENT_A2},
   { CCA_C_U16_APP_TEST_CLIENT_A3,                                TR_CLASS_APPREC_AIL_TEST_CLIENT_A3},
   { CCA_C_U16_APP_TEST_CLIENT_A4,                                TR_CLASS_APPREC_AIL_TEST_CLIENT_A4},
   { CCA_C_U16_APP_TEST_CLIENT_B1,                                TR_CLASS_APPREC_AIL_TEST_CLIENT_B1},
   { CCA_C_U16_APP_TEST_CLIENT_B2,                                TR_CLASS_APPREC_AIL_TEST_CLIENT_B2},
   { CCA_C_U16_APP_TEST_CLIENT_B3,                                TR_CLASS_APPREC_AIL_TEST_CLIENT_B3},
   { CCA_C_U16_APP_TEST_CLIENT_B4,                                TR_CLASS_APPREC_AIL_TEST_CLIENT_B4},
   { CCA_C_U16_APP_TEST_CLIENT_C1,                                TR_CLASS_APPREC_AIL_TEST_CLIENT_C1},
   { CCA_C_U16_APP_TEST_CLIENT_C2,                                TR_CLASS_APPREC_AIL_TEST_CLIENT_C2},
   { CCA_C_U16_APP_TEST_CLIENT_C3,                                TR_CLASS_APPREC_AIL_TEST_CLIENT_C3},
   { CCA_C_U16_APP_TEST_CLIENT_C4,                                TR_CLASS_APPREC_AIL_TEST_CLIENT_C4},
   { CCA_C_U16_APP_TEST_CLIENT_D1,                                TR_CLASS_APPREC_AIL_TEST_CLIENT_D1},
   { CCA_C_U16_APP_TEST_CLIENT_D2,                                TR_CLASS_APPREC_AIL_TEST_CLIENT_D2},
   { CCA_C_U16_APP_TEST_CLIENT_D3,                                TR_CLASS_APPREC_AIL_TEST_CLIENT_D3},
   { CCA_C_U16_APP_TEST_CLIENT_D4,                                TR_CLASS_APPREC_AIL_TEST_CLIENT_D4},
   { CCA_C_U16_APP_FC_APP,                                        TR_CLASS_APPREC_AIL_FC_APP},
   { CCA_C_U16_APP_FC_RECORDING,                                  TR_CLASS_APPREC_AIL_FC_RECORDING},
   { CCA_C_U16_APP_BROWSER,                                       TR_CLASS_APPREC_AIL_BROWSER},
   { CCA_C_U16_APP_BROWSER_MEDIA,                                 TR_CLASS_APPREC_AIL_BROWSER_MEDIA},
   { CCA_C_U16_APP_OPERAMINI,                                     TR_CLASS_APPREC_AIL_OPERAMINI},
   { CCA_C_U16_APP_ACT_SAFETY_DEMO,                               TR_CLASS_APPREC_AIL_ACT_SAFETY_DEMO},
   { CCA_C_U16_APP_FC_BTAUDIO,                                    TR_CLASS_APPREC_AIL_FC_BTAUDIO},
   { CCA_C_U16_APP_VD_TEM,                                        TR_CLASS_APPREC_AIL_VD_TEM},
   { CCA_C_U16_APP_CSB,                                           TR_CLASS_APPREC_AIL_CSB},
   { CCA_C_U16_APP_SREC_CTRL,                                     TR_CLASS_APPREC_AIL_SREC_CTRL},
   { CCA_C_U16_APP_VD_COMMUNITY_TELEMATICS,                       TR_CLASS_APPREC_AIL_VD_COMMUNITY_TELEMATICS},
   { CCA_C_U16_APP_FC_WIFISETTINGS,                               TR_CLASS_APPREC_AIL_FC_WIFISETTINGS},
   { CCA_C_U16_APP_FC_AUDIO_ROUTE_MGR,                            TR_CLASS_APPREC_AIL_FC_AUDIO_ROUTE_MGR},
   { CCA_C_U16_APP_FC_DIVA_SERVER,                                TR_CLASS_APPREC_AIL_FC_DIVA_SERVER},
   { CCA_C_U16_APP_CCA_TEST_MANAGER,                              TR_CLASS_APPREC_AIL_CCA_TEST_MANAGER},
   { CCA_C_U16_APP_FC_SXM,                                        TR_CLASS_APPREC_AIL_FC_SXM},
   { CCA_C_U16_APP_FC_INFOSCOUT,                                  TR_CLASS_APPREC_AIL_FC_INFOSCOUT},
   { CCA_C_U16_APP_CATALOGUE,                                     TR_CLASS_APPREC_AIL_CATALOGUE},
   { CCA_C_U16_APP_NAV_RNW_ACCESS_TEST,                           TR_CLASS_APPREC_AIL_NAV_RNW_ACCESS_TEST},
   { CCA_C_U16_APP_FC_MCAN_TCU,                                   TR_CLASS_APPREC_AIL_FC_MCAN_TCU},
   { CCA_C_U16_APP_SD_REFRESH,                                    TR_CLASS_APPREC_AIL_SD_REFRESH},
   { CCA_C_U16_APP_FC_TPEG,                                       TR_CLASS_APPREC_AIL_FC_TPEG},
   { CCA_C_U16_APP_FC_TRAFFIC,                                    TR_CLASS_APPREC_AIL_FC_TRAFFIC},
   { CCA_C_U16_APP_HMI_01,                                        TR_CLASS_APPREC_AIL_HMI_01},
   { CCA_C_U16_APP_HMI_02,                                        TR_CLASS_APPREC_AIL_HMI_02},
   { CCA_C_U16_APP_HMI_03,                                        TR_CLASS_APPREC_AIL_HMI_03},
   { CCA_C_U16_APP_HMI_04,                                        TR_CLASS_APPREC_AIL_HMI_04},
   { CCA_C_U16_APP_HMI_05,                                        TR_CLASS_APPREC_AIL_HMI_05},
   { CCA_C_U16_APP_HMI_06,                                        TR_CLASS_APPREC_AIL_HMI_06},
   { CCA_C_U16_APP_HMI_07,                                        TR_CLASS_APPREC_AIL_HMI_07},
   { CCA_C_U16_APP_HMI_08,                                        TR_CLASS_APPREC_AIL_HMI_08},
   { CCA_C_U16_APP_HMI_09,                                        TR_CLASS_APPREC_AIL_HMI_09},
   { CCA_C_U16_APP_HMI_10,                                        TR_CLASS_APPREC_AIL_HMI_10},
   { CCA_C_U16_APP_HMI_11,                                        TR_CLASS_APPREC_AIL_HMI_11},
   { CCA_C_U16_APP_HMI_12,                                        TR_CLASS_APPREC_AIL_HMI_12},
   { CCA_C_U16_APP_HMI_13,                                        TR_CLASS_APPREC_AIL_HMI_13},
   { CCA_C_U16_APP_HMI_14,                                        TR_CLASS_APPREC_AIL_HMI_14},
   { CCA_C_U16_APP_HMI_15,                                        TR_CLASS_APPREC_AIL_HMI_15},
   { CCA_C_U16_APP_APPLICATION_MANAGER,                           TR_CLASS_APPREC_AIL_APPLICATION_MANAGER},
   { CCA_C_U16_APP_SETTING_APPLICATION,                           TR_CLASS_APPREC_AIL_SETTING_APPLICATION},
   { CCA_C_U16_APP_RSE,                                           TR_CLASS_APPREC_AIL_RSE},
   { CCA_C_U16_APP_CCA_INC_ADAPTER,                               TR_CLASS_APPREC_AIL_CCA_INC_ADAPTER},
   { CCA_C_U16_APP_NAVI_SRV,                                      TR_CLASS_APPREC_AIL_NAVI_SRV},
   { CCA_C_U16_APP_FC_FILEMANAGER,                                TR_CLASS_APPREC_AIL_FC_FILEMANAGER},
   { CCA_C_U16_APP_MULTIMEDIA,                                    TR_CLASS_APPREC_AIL_MULTIMEDIA},
   { CCA_C_U16_APP_HVAC,                                          TR_CLASS_APPREC_AIL_HVAC},
   { CCA_C_U16_APP_SPEECH_UI,                                     TR_CLASS_APPREC_AIL_SPEECH_UI},
   { CCA_C_U16_APP_HMI_SYSTEM_SETTING,                            TR_CLASS_APPREC_AIL_HMI_SYSTEM_SETTING},
   { CCA_C_U16_APP_CAR_SETTING,                                   TR_CLASS_APPREC_AIL_CAR_SETTING},
   { CCA_C_U16_APP_HOME_SCREEN,                                   TR_CLASS_APPREC_AIL_HOME_SCREEN},
   { CCA_C_U16_APP_FC_LANGUAGECHANGE,                             TR_CLASS_APPREC_AIL_FC_LANGUAGECHANGE},
   { CCA_C_U16_APP_ASF_TUNER,                                     TR_CLASS_APPREC_AIL_ASF_TUNER},
   { CCA_C_U16_APP_ASF_MEDIAPLAYER,                               TR_CLASS_APPREC_AIL_ASF_MEDIAPLAYER},
   { CCA_C_U16_APP_NAVI_HMI,                                      TR_CLASS_APPREC_AIL_NAVI_HMI},
   { CCA_C_U16_APP_SPM_TEST_ADAPTOR,                              TR_CLASS_APPREC_AIL_SPM_TEST_ADAPTOR},
   { CCA_C_U16_APP_FC_USB_TCU,                                    TR_CLASS_APPREC_AIL_FC_USB_TCU},
   { CCA_C_U16_APP_HMI_TUNER,                                     TR_CLASS_APPREC_AIL_HMI_TUNER},
   { CCA_C_U16_APP_HMI_ENGINEERING_MODE,                          TR_CLASS_APPREC_AIL_HMI_ENGINEERING_MODE},
   { CCA_C_U16_APP_HMI_DRIVER_ASSISTANCE,                         TR_CLASS_APPREC_AIL_HMI_DRIVER_ASSISTANCE},
   { CCA_C_U16_APP_HMI_BTPHONE,                                   TR_CLASS_APPREC_AIL_HMI_BTPHONE},
   { CCA_C_U16_APP_HMI_DIAGNOSTICS,                               TR_CLASS_APPREC_AIL_HMI_DIAGNOSTICS},
   { CCA_C_U16_APP_HMI_STATUSBAR,                                 TR_CLASS_APPREC_AIL_HMI_STATUSBAR},
   { CCA_C_U16_APP_HMI_AUDIOAPP,                                  TR_CLASS_APPREC_AIL_HMI_AUDIOAPP},
   { CCA_C_U16_APP_FC_SW_UPDATE,                                  TR_CLASS_APPREC_AIL_FC_SW_UPDATE},
   { CCA_C_U16_APP_FC_TRAFFICINFOPROVIDER,                        TR_CLASS_APPREC_AIL_FC_TRAFFICINFOPROVIDER},
   { CCA_C_U16_APP_TIP_TEST_CLIENT,                               TR_CLASS_APPREC_AIL_TIP_TEST_CLIENT},
   { CCA_C_U16_APP_VD_VIDEO_CAMERA,                               TR_CLASS_APPREC_AIL_VD_VIDEO_CAMERA},
   { CCA_C_U16_APP_VD_RVC_EARLY,                                  TR_CLASS_APPREC_AIL_VD_RVC_EARLY},
   { CCA_C_U16_APP_SPICCADBUSADAPTER,                             TR_CLASS_APPREC_AIL_SPICCADBUSADAPTER},
   { CCA_C_U16_APP_FC_VIDEOMANAGER,                               TR_CLASS_APPREC_AIL_FC_VIDEOMANAGER},
   { CCA_C_U16_APP_FC_BTREMOTECONTROL,                            TR_CLASS_APPREC_AIL_FC_BTREMOTECONTROL},
   { CCA_C_U16_APP_MP_TEST_ADAPTOR,                               TR_CLASS_APPREC_AIL_MP_TEST_ADAPTOR},
   { CCA_C_U16_APP_PHN_TEST_ADAPTOR,                              TR_CLASS_APPREC_AIL_PHN_TEST_ADAPTOR},
   { CCA_C_U16_APP_PHNBK_TEST_ADAPTOR,                            TR_CLASS_APPREC_AIL_PHNBK_TEST_ADAPTOR},
   { CCA_C_U16_APP_BT_TEST_ADAPTOR,                               TR_CLASS_APPREC_AIL_BT_TEST_ADAPTOR},
   { CCA_C_U16_APP_MSG_TEST_ADAPTOR,                              TR_CLASS_APPREC_AIL_MSG_TEST_ADAPTOR},
   { CCA_C_U16_APP_WIFI_TEST_ADAPTOR,                             TR_CLASS_APPREC_AIL_WIFI_TEST_ADAPTOR},
   { CCA_C_U16_APP_TUN_TEST_ADAPTOR,                              TR_CLASS_APPREC_AIL_TUN_TEST_ADAPTOR},
   { CCA_C_U16_APP_TUNMSTR_TEST_ADAPTOR,                          TR_CLASS_APPREC_AIL_TUNMSTR_TEST_ADAPTOR},
   { CCA_C_U16_APP_DAB_TEST_ADAPTOR,                              TR_CLASS_APPREC_AIL_DAB_TEST_ADAPTOR},
   { CCA_C_U16_APP_FC_AUX,                                        TR_CLASS_APPREC_AIL_FC_AUX},
   { CCA_C_U16_APP_MP_MOST_TEST_ADAPTOR,                          TR_CLASS_APPREC_AIL_MP_MOST_TEST_ADAPTOR},
   { CCA_C_U16_APP_FC_DATASERVICES,                               TR_CLASS_APPREC_AIL_FC_DATASERVICES},
   { CCA_C_U16_APP_FC_REAR_VC,                                    TR_CLASS_APPREC_AIL_FC_REAR_VC},
   { CCA_C_U16_APP_VD_INPUT,                                      TR_CLASS_APPREC_AIL_VD_INPUT},
   { CCA_C_U16_APP_HIT,                                           TR_CLASS_APPREC_AIL_HIT},
   { CCA_C_U16_APP_DVDPLAYER,                                     TR_CLASS_APPREC_AIL_DVDPLAYER},
   { CCA_C_U16_APP_SWITCH_GW,                                     TR_CLASS_APPREC_AIL_SWITCH_GW},
   { CCA_C_U16_APP_ACL_SPI,                                       TR_CLASS_APPREC_AIL_ACL_SPI},
   { CCA_C_U16_APP_ACL_PHONE,                                     TR_CLASS_APPREC_AIL_ACL_PHONE},
   { CCA_C_U16_APP_ACL_CONNECTIVITY,                              TR_CLASS_APPREC_AIL_ACL_CONNECTIVITY},
   { CCA_C_U16_APP_FC_USERMANAGER,                                TR_CLASS_APPREC_AIL_FC_USERMANAGER},
   { CCA_C_U16_APP_OTA,                                           TR_CLASS_APPREC_AIL_OTA},
   { CCA_C_U16_APP_OTA_CCA,                                       TR_CLASS_APPREC_AIL_OTA_CCA},
   { CCA_C_U16_APP_FC_CONNECT,                                    TR_CLASS_APPREC_AIL_FC_CONNECT},
   { CCA_C_U16_APP_SCREENTEST,                                    TR_CLASS_APPREC_AIL_SCREENTEST},
   { CCA_C_U16_APP_FC_PARKASSIST,                                 TR_CLASS_APPREC_AIL_FC_PARKASSIST},
   { CCA_C_U16_APP_EXPORTSERVICE,                                 TR_CLASS_APPREC_AIL_EXPORTSERVICE},
   { CCA_C_U16_APP_FC_VEHFUNCMASTER,                              TR_CLASS_APPREC_AIL_FC_VEHFUNCMASTER},
   { CCA_C_U16_APP_KEYHANDLER,                                    TR_CLASS_APPREC_AIL_KEYHANDLER},
   { CCA_C_U16_APP_FC_USB,                                        TR_CLASS_APPREC_AIL_FC_USB},
   { CCA_C_U16_APP_DATACOLLECTOR,                                 TR_CLASS_APPREC_AIL_DATACOLLECTOR},
   { CCA_C_U16_APP_LEARNDATACOMM,                                 TR_CLASS_APPREC_AIL_LEARNDATACOMM},
   { CCA_C_U16_APP_GENERIC_PROXY,                                 TR_CLASS_APPREC_AIL_GENERIC_PROXY},
   { CCA_C_U16_APP_DISPLAYMANAGER,                                TR_CLASS_APPREC_AIL_DISPLAYMANAGER},
   { CCA_C_U16_APP_FC_SPEECH_AUDIO,                               TR_CLASS_APPREC_AIL_FC_SPEECH_AUDIO},
   { CCA_C_U16_APP_SMARTAPP,                                      TR_CLASS_APPREC_AIL_SMARTAPP},
   { CCA_C_U16_APP_FC_EXT_DRV,                                    TR_CLASS_APPREC_AIL_FC_EXT_DRV},
   { CCA_C_U16_APP_FC_VP2_PARKASSIST,                             TR_CLASS_APPREC_AIL_FC_VP2_PARKASSIST},
   { CCA_C_U16_APP_FC_VPAS_PARKASSIST,                            TR_CLASS_APPREC_AIL_FC_VPAS_PARKASSIST},
   { CCA_C_U16_APP_ACL_UPDATE,                                    TR_CLASS_APPREC_AIL_ACL_UPDATE},
   { CCA_C_U16_APP_MNDB_TEST_CLIENT,                              TR_CLASS_APPREC_AIL_MNDB_TEST_CLIENT},
   { CCA_C_U16_APP_ASF_AUDIOMASTER,                               TR_CLASS_APPREC_AIL_ASF_AUDIOMASTER},
   { CCA_C_U16_APP_LCM_CCA_DBUS_GATEWAY,                          TR_CLASS_APPREC_AIL_LCM_CCA_DBUS_GATEWAY},
   { CCA_C_U16_APP_NAVI_3RD_PARTY,                                TR_CLASS_APPREC_AIL_NAVI_3RD_PARTY},
   { CCA_C_U16_APP_FC_DTV,                                        TR_CLASS_APPREC_AIL_FC_DTV},
   { CCA_C_U16_APP_FC_TPEGDB,                                     TR_CLASS_APPREC_AIL_FC_TPEGDB},
   { CCA_C_U16_APP_CAREASYAPPS,                                   TR_CLASS_APPREC_AIL_CAREASYAPPS},
   { CCA_C_U16_APP_LCM_DBUS_CLIENT,                               TR_CLASS_APPREC_AIL_LCM_DBUS_CLIENT},
   { CCA_C_U16_APP_FC_VIDEOPOSITIONSUPPORT,                       TR_CLASS_APPREC_AIL_FC_VIDEOPOSITIONSUPPORT},
   { CCA_C_U16_APP_WPV,                                           TR_CLASS_APPREC_AIL_WPV},
   { CCA_C_U16_APP_FC_DUMM,                                       TR_CLASS_APPREC_AIL_FC_DUMM},
   { CCA_C_U16_APP_FD_THERMAL_MGMT,                               TR_CLASS_APPREC_AIL_FD_THERMAL_MGMT},
   { CCA_C_U16_APP_FD_SUPPLY_MGMT,                                TR_CLASS_APPREC_AIL_FD_SUPPLY_MGMT},
   { CCA_C_U16_APP_FD_PWR_MASTER,                                 TR_CLASS_APPREC_AIL_FD_PWR_MASTER},
   { CCA_C_U16_APP_FD_SYSTEM_SM,                                  TR_CLASS_APPREC_AIL_FD_SYSTEM_SM},
   { CCA_C_U16_APP_AUTO_DRIVE,                                    TR_CLASS_APPREC_AIL_AUTO_DRIVE},
   { CCA_C_U16_APP_VIDEO_MANAGER,                                 TR_CLASS_APPREC_AIL_VIDEO_MANAGER},
   { CCA_C_U16_APP_WEBPORTAL,                                     TR_CLASS_APPREC_AIL_WEBPORTAL},
   { CCA_C_U16_APP_RMT_APP_CTRL,                                  TR_CLASS_APPREC_AIL_RMT_APP_CTRL},
   { CCA_C_U16_APP_SUGGESTION_AND_NOTIFICATION_MANAGER,           TR_CLASS_APPREC_AIL_SUGGESTION_AND_NOTIFICATION_MANAGER},
   { CCA_C_U16_APP_DIAGLOG,                                       TR_CLASS_APPREC_AIL_DIAGLOG},
   { CCA_C_U16_APP_FC_STC,                                        TR_CLASS_APPREC_AIL_FC_STC},
   { CCA_C_U16_APP_TEST_SERVER_E,                                 TR_CLASS_APPREC_AIL_TEST_SERVER_E},
   { CCA_C_U16_APP_EARLYWPVCONFIG,                                TR_CLASS_APPREC_AIL_EARLYWPVCONFIG},
   { CCA_C_U16_APP_USER_REMOTE_SYNC_CTRL,                         TR_CLASS_APPREC_AIL_USER_REMOTE_SYNC_CTRL},
   { CCA_C_U16_APP_DCM_ADRAMPLIFIER,                              TR_CLASS_APPREC_AIL_DCM_ADRAMPLIFIER},
   { CCA_C_U16_APP_DRVFUNC,                                       TR_CLASS_APPREC_AIL_DRVFUNC},
   { CCA_C_U16_APP_AUDIO,                                         TR_CLASS_APPREC_AIL_AUDIO},
   { CCA_C_U16_APP_TUNER,                                         TR_CLASS_APPREC_AIL_TUNER},
   { CCA_C_U16_APP_UI,                                            TR_CLASS_APPREC_AIL_UI},
   { CCA_C_U16_APP_DCM_AMFMTUNER,                                 TR_CLASS_APPREC_AIL_DCM_AMFMTUNER},
   { CCA_C_U16_APP_SPI,                                           TR_CLASS_APPREC_AIL_SPI},
   { CCA_C_U16_APP_DCM_XMTUNER,                                   TR_CLASS_APPREC_AIL_DCM_XMTUNER},
   { CCA_C_U16_APP_MP3,                                           TR_CLASS_APPREC_AIL_MP3},
   { CCA_C_U16_APP_CDVD,                                          TR_CLASS_APPREC_AIL_CDVD},
   { CCA_C_U16_APP_CDCVD,                                         TR_CLASS_APPREC_AIL_CDCVD},
   { CCA_C_U16_APP_DIAGDEBUG,                                     TR_CLASS_APPREC_AIL_DIAGDEBUG},
   { CCA_C_U16_APP_GATEWAY,                                       TR_CLASS_APPREC_AIL_GATEWAY},
   { CCA_C_U16_APP_VOICE_GATEWAY,                                 TR_CLASS_APPREC_AIL_VOICE_GATEWAY},
   { CCA_C_U16_APP_TMC_GATEWAY,                                   TR_CLASS_APPREC_AIL_TMC_GATEWAY},
   { CCA_C_U16_APP_DIAG_GATEWAY,                                  TR_CLASS_APPREC_AIL_DIAG_GATEWAY},
   { CCA_C_U16_APP_TRCSFWGW,                                      TR_CLASS_APPREC_AIL_TRCSFWGW},
   { CCA_C_U16_APP_RFD,                                           TR_CLASS_APPREC_AIL_RFD},
   { CCA_C_U16_APP_FC_LBS,                                        TR_CLASS_APPREC_AIL_FC_LBS},
   { CCA_C_U16_APP_SMARTPHONEINTEGRATION,                         TR_CLASS_APPREC_AIL_SMARTPHONEINTEGRATION},
   { CCA_C_U16_APP_TUNERMASTER,                                   TR_CLASS_APPREC_AIL_TUNERMASTER},
   { CCA_C_U16_APP_SEAMLESS_PAIRING_IPCM,                         TR_CLASS_APPREC_AIL_SEAMLESS_PAIRING_IPCM},
   { CCA_C_U16_APP_CONTEXTMANAGER,                                TR_CLASS_APPREC_AIL_CONTEXTMANAGER},
   { CCA_C_U16_APP_NAVIFUNC,                                      TR_CLASS_APPREC_AIL_NAVIFUNC},
   { CCA_C_U16_APP_MAPPREP,                                       TR_CLASS_APPREC_AIL_MAPPREP},
   { CCA_C_U16_APP_SUGGESTION_AND_NOTIFICATION_PUSHMESSAGE_PROXY, TR_CLASS_APPREC_AIL_SUGGESTION_AND_NOTIFICATION_PUSHMESSAGE_PROXY},
   { CCA_C_U16_APP_SUGGESTION_AND_NOTIFICATION_ACTIONHANDLER,     TR_CLASS_APPREC_AIL_SUGGESTION_AND_NOTIFICATION_ACTIONHANDLER},
   { CCA_C_U16_APP_VALET_MODE_MANAGER,                            TR_CLASS_APPREC_AIL_VALET_MODE_MANAGER},
   { CCA_C_U16_APP_WIFI_BUSINESS_LOGIC,                           TR_CLASS_APPREC_AIL_WIFI_BUSINESS_LOGIC},
   { CCA_C_U16_APP_FC_EXT_MEDIA_IN,                               TR_CLASS_APPREC_AIL_FC_EXT_MEDIA_IN},
   { CCA_C_U16_APP_FC_SXM_360L,                                   TR_CLASS_APPREC_AIL_FC_SXM_360L},
   { CCA_C_U16_APP_AMFM_AUD,                                      TR_CLASS_APPREC_AIL_AMFM_AUD},
   { CCA_C_U16_APP_FC_MAPUPDATE,                                  TR_CLASS_APPREC_AIL_FC_MAPUPDATE},
   { CCA_C_U16_APP_ACR_HANDLER,                                   TR_CLASS_APPREC_AIL_ACR_HANDLER},
   { CCA_C_U16_APP_DCM_TUNERMASTER,                               TR_CLASS_APPREC_AIL_DCM_TUNERMASTER},
   { CCA_C_U16_APP_DCM_BROWSER,                                   TR_CLASS_APPREC_AIL_DCM_BROWSER},
   { CCA_C_U16_APP_DCM_IPODCTRL,                                  TR_CLASS_APPREC_AIL_DCM_IPODCTRL},
   { CCA_C_U16_APP_DCM_PWMAMPLIFIER,                              TR_CLASS_APPREC_AIL_DCM_PWMAMPLIFIER},
   { CCA_C_U16_APP_DCM_AMPLIFIER,                                 TR_CLASS_APPREC_AIL_DCM_AMPLIFIER},
   { CCA_C_U16_APP_DCM_CHIME,                                     TR_CLASS_APPREC_AIL_DCM_CHIME},
   { CCA_C_U16_APP_DCM_MEDIAPLAYER,                               TR_CLASS_APPREC_AIL_DCM_MEDIAPLAYER},
   { CCA_C_U16_APP_CONNECTIONMASTER,                              TR_CLASS_APPREC_AIL_CONNECTIONMASTER},
   { CCA_C_U16_APP_AUDIOMASTER,                                   TR_CLASS_APPREC_AIL_AUDIOMASTER},
   { CCA_C_U16_APP_DCM_PROFILECTRL,                               TR_CLASS_APPREC_AIL_DCM_PROFILECTRL},
   { CCA_C_U16_APP_FCM_CARCUSTOMIZATION,                          TR_CLASS_APPREC_AIL_FCM_CARCUSTOMIZATION},
   { CCA_C_U16_APP_FCM_ELECTRONICCLIMATECONTROL,                  TR_CLASS_APPREC_AIL_FCM_ELECTRONICCLIMATECONTROL},
   { CCA_C_U16_APP_FCM_SILVERBOX,                                 TR_CLASS_APPREC_AIL_FCM_SILVERBOX},
   { CCA_C_U16_APP_FCM_ONSTAR,                                    TR_CLASS_APPREC_AIL_FCM_ONSTAR},
   { CCA_C_U16_APP_FCM_UNIVERSALHANDSFREEPHONE,                   TR_CLASS_APPREC_AIL_FCM_UNIVERSALHANDSFREEPHONE},
   { CCA_C_U16_APP_FCM_DABTUNER,                                  TR_CLASS_APPREC_AIL_FCM_DABTUNER},
   { CCA_C_U16_APP_DCM_ODI_GATEWAY,                               TR_CLASS_APPREC_AIL_DCM_ODI_GATEWAY},
   { CCA_C_U16_APP_DCM_OPTICAL_DISK,                              TR_CLASS_APPREC_AIL_DCM_OPTICAL_DISK},
   { CCA_C_U16_APP_DCM_AUDARBITMASTER,                            TR_CLASS_APPREC_AIL_DCM_AUDARBITMASTER},
   { CCA_C_U16_APP_DCM_PHONE,                                     TR_CLASS_APPREC_AIL_DCM_PHONE},
   { CCA_C_U16_APP_DCM_PHONE_PROXY,                               TR_CLASS_APPREC_AIL_DCM_PHONE_PROXY},
   { CCA_C_U16_APP_DCM_AUD_ARBIT_MASTER,                          TR_CLASS_APPREC_AIL_DCM_AUD_ARBIT_MASTER},
   { CCA_C_U16_APP_DCM_AUX_JACK,                                  TR_CLASS_APPREC_AIL_DCM_AUX_JACK},
   { CCA_C_U16_APP_DCM_USB,                                       TR_CLASS_APPREC_AIL_DCM_USB},
   { CCA_C_U16_APP_DCM_PDIM,                                      TR_CLASS_APPREC_AIL_DCM_PDIM},
   { CCA_C_U16_APP_DDL_TEST,                                      TR_CLASS_APPREC_AIL_DDL_TEST},
   { CCA_C_U16_APP_TMC_IP,                                        TR_CLASS_APPREC_AIL_TMC_IP},
   { CCA_C_U16_APP_FC_PROFILER,                                   TR_CLASS_APPREC_AIL_FC_PROFILER},
   { CCA_C_U16_APP_FC_CDPLAYER,                                   TR_CLASS_APPREC_AIL_FC_CDPLAYER},
   { CCA_C_U16_APP_FC_BTDEVICEMANAGER,                            TR_CLASS_APPREC_AIL_FC_BTDEVICEMANAGER},
   { CCA_C_U16_APP_FC_ATB,                                        TR_CLASS_APPREC_AIL_FC_ATB},
   { CCA_C_U16_APP_FC_SERVICEMGR,                                 TR_CLASS_APPREC_AIL_FC_SERVICEMGR},
   { CCA_C_U16_APP_MAP_3D,                                        TR_CLASS_APPREC_AIL_MAP_3D},
   { CCA_C_U16_APP_MID_MAP_ENGINE,                                TR_CLASS_APPREC_AIL_MID_MAP_ENGINE},
   { CCA_C_U16_APP_FRAMETEST_NAVI,                                TR_CLASS_APPREC_AIL_FRAMETEST_NAVI},
   { CCA_C_U16_APP_FRAMETEST_MONA,                                TR_CLASS_APPREC_AIL_FRAMETEST_MONA},
   { CCA_C_U16_APP_FRAMETEST_TIMA,                                TR_CLASS_APPREC_AIL_FRAMETEST_TIMA},
   { CCA_C_U16_APP_STA_SERVER,                                    TR_CLASS_APPREC_AIL_STA_SERVER},
   { CCA_C_U16_APP_STA_CLIENT,                                    TR_CLASS_APPREC_AIL_STA_CLIENT},
   { CCA_C_U16_APP_CSFW_CCA_TEST_CLIENT,                          TR_CLASS_APPREC_AIL_CSFW_CCA_TEST_CLIENT},
   { CCA_C_U16_APP_CSFW_CCA_TEST_SERVER,                          TR_CLASS_APPREC_AIL_CSFW_CCA_TEST_SERVER},
   { CCA_C_U16_APP_CSFW_CCA_SAMPLE_CLIENT,                        TR_CLASS_APPREC_AIL_CSFW_CCA_SAMPLE_CLIENT},
   { CCA_C_U16_APP_CSFW_CCA_SAMPLE_SERVER,                        TR_CLASS_APPREC_AIL_CSFW_CCA_SAMPLE_SERVER},
   { CCA_C_U16_APP_DEMO_CLIENT_CORE_1,                            TR_CLASS_APPREC_AIL_DEMO_CLIENT_CORE_1},
   { CCA_C_U16_APP_DEMO_SERVER_CORE_1,                            TR_CLASS_APPREC_AIL_DEMO_SERVER_CORE_1},
   { CCA_C_U16_APP_DEMO_CLIENT_CORE_2,                            TR_CLASS_APPREC_AIL_DEMO_CLIENT_CORE_2},
   { CCA_C_U16_APP_DEMO_SERVER_CORE_2,                            TR_CLASS_APPREC_AIL_DEMO_SERVER_CORE_2},
   { CCA_C_U16_APP_SDS_VOICE_CONTROL,                             TR_CLASS_APPREC_AIL_SDS_VOICE_CONTROL},
   { CCA_C_U16_APP_SDS_RECOGNIZER,                                TR_CLASS_APPREC_AIL_SDS_RECOGNIZER},
   { CCA_C_U16_APP_SDS_TTS,                                       TR_CLASS_APPREC_AIL_SDS_TTS},
   { CCA_C_U16_APP_SDS_PROMPT_PLAYER,                             TR_CLASS_APPREC_AIL_SDS_PROMPT_PLAYER},
   { CCA_C_U16_APP_SDS_RECORDER,                                  TR_CLASS_APPREC_AIL_SDS_RECORDER},
   { CCA_C_U16_APP_SDS_SPEECH_DATA_PROVIDER,                      TR_CLASS_APPREC_AIL_SDS_SPEECH_DATA_PROVIDER},
   { CCA_C_U16_APP_SDS_TEST_BASEAPP,                              TR_CLASS_APPREC_AIL_SDS_TEST_BASEAPP},
   { CCA_C_U16_APP_SDS_TEST_SERVER_BASEAPP,                       TR_CLASS_APPREC_AIL_SDS_TEST_SERVER_BASEAPP},
   { CCA_C_U16_APP_ACRHANDLER,                                    TR_CLASS_APPREC_AIL_ACRHANDLER},
   { CCA_C_U16_APP_TRANSCRIPTIONSERVICE,                          TR_CLASS_APPREC_AIL_TRANSCRIPTIONSERVICE},
   { CCA_C_U16_APP_SDS_WRAPPER,                                   TR_CLASS_APPREC_AIL_SDS_WRAPPER},
   { CCA_C_U16_APP_SDS_TESTAPP,                                   TR_CLASS_APPREC_AIL_SDS_TESTAPP},
   { CCA_C_U16_APP_IPSIM,                                         TR_CLASS_APPREC_AIL_IPSIM},
   { CCA_C_U16_APP_FC_EXT_KI,                                     TR_CLASS_APPREC_AIL_FC_EXT_KI},
   { CCA_C_U16_APP_GENIVIAUDIO,                                   TR_CLASS_APPREC_AIL_GENIVIAUDIO},
   { CCA_C_U16_APP_SENSOR,                                        TR_CLASS_APPREC_AIL_SENSOR},
   { CCA_C_U16_APP_PV,                                            TR_CLASS_APPREC_AIL_PV},
   { CCA_C_U16_APP_MOSTCCAGW,                                     TR_CLASS_APPREC_AIL_MOSTCCAGW},
   { CCA_C_U16_APP_SDS_REMOTE_CLIENT,                             TR_CLASS_APPREC_AIL_SDS_REMOTE_CLIENT}
};

/* this table must be sorted from lower to upper value, because this is expected by the search algorithm */
const rAppOrSrvToTraceClassRef carSrvToTraceClassRef[]=
{
   { CCA_C_U16_SRV_DIAGNOSIS,                                 TR_CLASS_SRVREC_AIL_DIAGNOSIS},            
   { CCA_C_U16_SRV_HANDLE_DIAGNOSIS,                          TR_CLASS_SRVREC_AIL_HANDLE_DIAGNOSIS},
   { CCA_C_U16_SRV_REPORT_MEMORY,                             TR_CLASS_SRVREC_AIL_REPORT_MEMORY},     
   { CCA_C_U16_SRV_SBS_LISTMATCHING,                          TR_CLASS_SRVREC_AIL_SBS_LISTMATCHING},
   { CCA_C_U16_SRV_DVD_MGNT,                                  TR_CLASS_SRVREC_AIL_DVD_MGNT},          
   { CCA_C_U16_SRV_TRAFFIC_MESSAGE_TELEMATIC,                 TR_CLASS_SRVREC_AIL_TRAFFIC_MESSAGE_TELEMATIC},
   { CCA_C_U16_SRV_RESOURCE_INFORMATION,                      TR_CLASS_SRVREC_AIL_RESOURCE_INFORMATION},
   { CCA_C_U16_SRV_RAW_DATA,                                  TR_CLASS_SRVREC_AIL_RAW_DATA},
   { CCA_C_U16_SRV_LOCATION_INPUT,                            TR_CLASS_SRVREC_AIL_LOCATION_INPUT},
   { CCA_C_U16_SRV_SBS_SUPPORT,                               TR_CLASS_SRVREC_AIL_SBS_SUPPORT},
   { CCA_C_U16_SRV_NAVI,                                      TR_CLASS_SRVREC_AIL_NAVI},
   { CCA_C_U16_SRV_SENSORS,                                   TR_CLASS_SRVREC_AIL_SENSORS},
   { CCA_C_U16_SRV_TRAFFIC_MESSAGE_PRESENTATION,              TR_CLASS_SRVREC_AIL_TRAFFIC_MESSAGE_PRESENTATION},
   { CCA_C_U16_SRV_TRAFFIC_MESSAGE_DATA,                      TR_CLASS_SRVREC_AIL_TRAFFIC_MESSAGE_DATA},
   { CCA_C_U16_SRV_TRAFFIC_MESSAGE_BROADCAST,                 TR_CLASS_SRVREC_AIL_TRAFFIC_MESSAGE_BROADCAST},
   { CCA_C_U16_SRV_VOICE,                                     TR_CLASS_SRVREC_AIL_VOICE},
   { CCA_C_U16_SRV_TMC_LIST_DATA,                             TR_CLASS_SRVREC_AIL_TMC_LIST_DATA},
   { CCA_C_U16_SRV_DAPI_ROADNETWORK,                          TR_CLASS_SRVREC_AIL_DAPI_ROADNETWORK},
   { CCA_C_U16_SRV_DAPI_ARCHIVE,                              TR_CLASS_SRVREC_AIL_DAPI_ARCHIVE},
   { CCA_C_U16_SRV_RDD,                                       TR_CLASS_SRVREC_AIL_RDD},
   { CCA_C_U16_SRV_NAVI_INTERNAL,                             TR_CLASS_SRVREC_AIL_NAVI_INTERNAL},
   { CCA_C_U16_SRV_ARCHIVE_CONTROL,                           TR_CLASS_SRVREC_AIL_ARCHIVE_CONTROL},
   { CCA_C_U16_SRV_LIM,                                       TR_CLASS_SRVREC_AIL_LIM},
   { CCA_C_U16_SRV_RC_ENGINEERING,                            TR_CLASS_SRVREC_AIL_RC_ENGINEERING},
   { CCA_C_U16_SRV_MCNET_MANAGEMENT,                          TR_CLASS_SRVREC_AIL_MCNET_MANAGEMENT},
   { CCA_C_U16_SRV_DESTMEM_MANAGEMENT,                        TR_CLASS_SRVREC_AIL_DESTMEM_MANAGEMENT},
   { CCA_C_U16_SRV_RG_ENGINEERING,                            TR_CLASS_SRVREC_AIL_RG_ENGINEERING},
   { CCA_C_U16_SRV_RTF,                                       TR_CLASS_SRVREC_AIL_RTF},
   { CCA_C_U16_SRV_POSITION,                                  TR_CLASS_SRVREC_AIL_POSITION},
   { CCA_C_U16_SRV_GUIDANCE,                                  TR_CLASS_SRVREC_AIL_GUIDANCE},
   { CCA_C_U16_SRV_SENSORS_IERROR,                            TR_CLASS_SRVREC_AIL_SENSORS_IERROR},
   { CCA_C_U16_SRV_OBN,                                       TR_CLASS_SRVREC_AIL_OBN},
   { CCA_C_U16_SRV_DAPI_ARCHIVE_INTERN,                       TR_CLASS_SRVREC_AIL_DAPI_ARCHIVE_INTERN},
   { CCA_C_U16_SRV_MAP_INTERNAL,                              TR_CLASS_SRVREC_AIL_MAP_INTERNAL},
   { CCA_C_U16_SRV_EDM_ENGINEERING,                           TR_CLASS_SRVREC_AIL_EDM_ENGINEERING},
   { CCA_C_U16_SRV_VR_HMI,                                    TR_CLASS_SRVREC_AIL_VR_HMI},
   { CCA_C_U16_SRV_FASTMAP,                                   TR_CLASS_SRVREC_AIL_FASTMAP},
   { CCA_C_U16_SRV_VD_DIMMING,                                TR_CLASS_SRVREC_AIL_VD_DIMMING},
   { CCA_C_U16_SRV_TELEFON,                                   TR_CLASS_SRVREC_AIL_TELEFON},
   { CCA_C_U16_SRV_SINA_ENGINEERING,                          TR_CLASS_SRVREC_AIL_SINA_ENGINEERING},
   { CCA_C_U16_SRV_HEATCTRL,                                  TR_CLASS_SRVREC_AIL_HEATCTRL},
   { CCA_C_U16_SRV_SECURITY,                                  TR_CLASS_SRVREC_AIL_SECURITY},
   { CCA_C_U16_SRV_ROUTECALCULATION,                          TR_CLASS_SRVREC_AIL_ROUTECALCULATION},
   { CCA_C_U16_SRV_EDM_INTERNAL,                              TR_CLASS_SRVREC_AIL_EDM_INTERNAL},
   { CCA_C_U16_SRV_TMC_TUNER,                                 TR_CLASS_SRVREC_AIL_TMC_TUNER},
   { CCA_C_U16_SRV_AUXCTRL_EXTBOX,                            TR_CLASS_SRVREC_AIL_AUXCTRL_EXTBOX},
   { CCA_C_U16_SRV_TEA,                                       TR_CLASS_SRVREC_AIL_TEA},
   { CCA_C_U16_SRV_UAM,                                       TR_CLASS_SRVREC_AIL_UAM},
   { CCA_C_U16_SRV_WEATHER,                                   TR_CLASS_SRVREC_AIL_WEATHER},
   { CCA_C_U16_SRV_WEATHER_TUNER,                             TR_CLASS_SRVREC_AIL_WEATHER_TUNER},
   { CCA_C_U16_SRV_WDB_INTERNAL,                              TR_CLASS_SRVREC_AIL_WDB_INTERNAL},
   { CCA_C_U16_SRV_CLIMATE_CONTROL,                           TR_CLASS_SRVREC_AIL_CLIMATE_CONTROL},
   { CCA_C_U16_SRV_CLOCK,                                     TR_CLASS_SRVREC_AIL_CLOCK},
   { CCA_C_U16_SRV_STATISTICS,                                TR_CLASS_SRVREC_AIL_STATISTICS},
   { CCA_C_U16_SRV_EXT_VR,                                    TR_CLASS_SRVREC_AIL_EXT_VR},
   { CCA_C_U16_SRV_MDI,                                       TR_CLASS_SRVREC_AIL_MDI},
   { CCA_C_U16_SRV_PHONE_GENERAL,                             TR_CLASS_SRVREC_AIL_PHONE_GENERAL},
   { CCA_C_U16_SRV_PHONE_AUDIO ,                              TR_CLASS_SRVREC_AIL_PHONE_AUDIO },
   { CCA_C_U16_SRV_REGION_SELECTION,                          TR_CLASS_SRVREC_AIL_REGION_SELECTION},
   { CCA_C_U16_SRV_REGION_KNITTER,                            TR_CLASS_SRVREC_AIL_REGION_KNITTER},
   { CCA_C_U16_SRV_TUNERSYNC,                                 TR_CLASS_SRVREC_AIL_TUNERSYNC},
   { CCA_C_U16_SRV_VEHICLE_DATA,                              TR_CLASS_SRVREC_AIL_VEHICLE_DATA},
   { CCA_C_U16_SRV_OPS,                                       TR_CLASS_SRVREC_AIL_OPS},
   { CCA_C_U16_SRV_RVC,                                       TR_CLASS_SRVREC_AIL_RVC},
   { CCA_C_U16_SRV_CHIME,                                     TR_CLASS_SRVREC_AIL_CHIME},
   { CCA_C_U16_SRV_IPOD,                                      TR_CLASS_SRVREC_AIL_IPOD},
   { CCA_C_U16_SRV_ADASIS,                                    TR_CLASS_SRVREC_AIL_ADASIS},
   { CCA_C_U16_SRV_NAVREPEATER,                               TR_CLASS_SRVREC_AIL_NAVREPEATER},
   { CCA_C_U16_SRV_MEDIAPLAYER_EXTBOX,                        TR_CLASS_SRVREC_AIL_MEDIAPLAYER_EXTBOX},
   { CCA_C_U16_SRV_TUNER_EXTBOX,                              TR_CLASS_SRVREC_AIL_TUNER_EXTBOX},
   { CCA_C_U16_SRV_VEHICLEFUNCTION_EXTBOX,                    TR_CLASS_SRVREC_AIL_VEHICLEFUNCTION_EXTBOX},
   { CCA_C_U16_SRV_AUDIO_EXTBOX,                              TR_CLASS_SRVREC_AIL_AUDIO_EXTBOX},
   { CCA_C_U16_SRV_XM_TUNER,                                  TR_CLASS_SRVREC_AIL_XM_TUNER},
   { CCA_C_U16_SRV_TEA_ENGINEERING,                           TR_CLASS_SRVREC_AIL_TEA_ENGINEERING},
   { CCA_C_U16_SRV_UPS,                                       TR_CLASS_SRVREC_AIL_UPS},
   { CCA_C_U16_SRV_PHONE_NDI,                                 TR_CLASS_SRVREC_AIL_PHONE_NDI},
   { CCA_C_U16_SRV_REMOTE_CLIENT,                             TR_CLASS_SRVREC_AIL_REMOTE_CLIENT},
   { CCA_C_U16_SRV_MCAN_PHONE,                                TR_CLASS_SRVREC_AIL_MCAN_PHONE},
   { CCA_C_U16_SRV_VEHICLE_CONFIG,                            TR_CLASS_SRVREC_AIL_VEHICLE_CONFIG},
   { CCA_C_U16_SRV_LOGBOOK,                                   TR_CLASS_SRVREC_AIL_LOGBOOK},
   { CCA_C_U16_SRV_MDB_ENGINEERING,                           TR_CLASS_SRVREC_AIL_MDB_ENGINEERING},
   { CCA_C_U16_SRV_TSD,                                       TR_CLASS_SRVREC_AIL_TSD},
   { CCA_C_U16_SRV_VEHICLE_SENSOR,                            TR_CLASS_SRVREC_AIL_VEHICLE_SENSOR},
   { CCA_C_U16_SRV_ASSIST,                                    TR_CLASS_SRVREC_AIL_ASSIST},
   { CCA_C_U16_SRV_DAPI_POI,                                  TR_CLASS_SRVREC_AIL_DAPI_POI},
   { CCA_C_U16_SRV_PREDICTIVE_DRIVING,                        TR_CLASS_SRVREC_AIL_PREDICTIVE_DRIVING},
   { CCA_C_U16_SRV_DATA_ACCESS,                               TR_CLASS_SRVREC_AIL_DATA_ACCESS},
   { CCA_C_U16_SRV_MCAN_METER,                                TR_CLASS_SRVREC_AIL_MCAN_METER},
   { CCA_C_U16_SRV_DATA_LOADER,                               TR_CLASS_SRVREC_AIL_DATA_LOADER},
   { CCA_C_U16_SRV_DATA_RESOURCE_MANAGER,                     TR_CLASS_SRVREC_AIL_DATA_RESOURCE_MANAGER},
   { CCA_C_U16_SRV_TELEMATIC,                                 TR_CLASS_SRVREC_AIL_TELEMATIC},
   { CCA_C_U16_SRV_SYNC_AUDIO,                                TR_CLASS_SRVREC_AIL_SYNC_AUDIO},
   { CCA_C_U16_SRV_DEVICEMANAGER,                             TR_CLASS_SRVREC_AIL_DEVICEMANAGER},
   { CCA_C_U16_SRV_SPM_SLV,                                   TR_CLASS_SRVREC_AIL_SPM_SLV},
   { CCA_C_U16_SRV_PDC,                                       TR_CLASS_SRVREC_AIL_PDC},
   { CCA_C_U16_SRV_SYNC_DISPLAY,                              TR_CLASS_SRVREC_AIL_SYNC_DISPLAY},
   { CCA_C_U16_SRV_VD_TOUCH,                                  TR_CLASS_SRVREC_AIL_VD_TOUCH},
   { CCA_C_U16_SRV_INTERACTIONLOGGER,                         TR_CLASS_SRVREC_AIL_INTERACTIONLOGGER},
   { CCA_C_U16_SRV_WEB_SEARCH,                                TR_CLASS_SRVREC_AIL_WEB_SEARCH},
   { CCA_C_U16_SRV_NAAGS,                                     TR_CLASS_SRVREC_AIL_NAAGS},
   { CCA_C_U16_SRV_IPODCONTROL,                               TR_CLASS_SRVREC_AIL_IPODCONTROL},
   { CCA_C_U16_SRV_AVTESTSERVER,                              TR_CLASS_SRVREC_AIL_AVTESTSERVER},
   { CCA_C_U16_SRV_VOLUMECONTROL,                             TR_CLASS_SRVREC_AIL_VOLUMECONTROL},
   { CCA_C_U16_SRV_TMC_TUNER_CTRL,                            TR_CLASS_SRVREC_AIL_TMC_TUNER_CTRL},
   { CCA_C_U16_SRV_FB_DEVELOPMENTSCREENCLIENT_2,              TR_CLASS_SRVREC_AIL_FB_DEVELOPMENTSCREENCLIENT_2},
   { CCA_C_U16_SRV_FB_DEVELOPMENTSCREENCLIENT_INTERNAL,       TR_CLASS_SRVREC_AIL_FB_DEVELOPMENTSCREENCLIENT_INTERNAL},
   { CCA_C_U16_SRV_HMI_LAYER_SYNC,                            TR_CLASS_SRVREC_AIL_HMI_LAYER_SYNC},
   { CCA_C_U16_SRV_HMI_GESTURE,                               TR_CLASS_SRVREC_AIL_HMI_GESTURE},
   { CCA_C_U16_SRV_RFD,                                       TR_CLASS_SRVREC_AIL_RFD},
   { CCA_C_U16_SRV_FB_DEVELOPMENTSCREENCLIENT_3,              TR_CLASS_SRVREC_AIL_FB_DEVELOPMENTSCREENCLIENT_3},
   { CCA_C_U16_SRV_DIAGLOG,                                   TR_CLASS_SRVREC_AIL_DIAGLOG},
   { CCA_C_U16_SRV_DIAGLIB,                                   TR_CLASS_SRVREC_AIL_DIAGLIB},
   { CCA_C_U16_SRV_DIAG_DEFSET,                               TR_CLASS_SRVREC_AIL_DIAG_DEFSET},
   { CCA_C_U16_SRV_TEST_A,                                    TR_CLASS_SRVREC_AIL_TEST_A},
   { CCA_C_U16_SRV_TEST_B,                                    TR_CLASS_SRVREC_AIL_TEST_B},
   { CCA_C_U16_SRV_TEST_C,                                    TR_CLASS_SRVREC_AIL_TEST_C},
   { CCA_C_U16_SRV_TEST_D,                                    TR_CLASS_SRVREC_AIL_TEST_D},
   { CCA_C_U16_SRV_IPOD_APP,                                  TR_CLASS_SRVREC_AIL_IPOD_APP},
   { CCA_C_U16_SRV_APP_PANDORA,                               TR_CLASS_SRVREC_AIL_APP_PANDORA},
   { CCA_C_U16_SRV_IPOD_APP_CONTROL,                          TR_CLASS_SRVREC_AIL_IPOD_APP_CONTROL},
   { CCA_C_U16_SRV_RECORDING,                                 TR_CLASS_SRVREC_AIL_RECORDING},
   { CCA_C_U16_SRV_SPEECHSETTINGS,                            TR_CLASS_SRVREC_AIL_SPEECHSETTINGS},
   { CCA_C_U16_SRV_DAB_TUNER,                                 TR_CLASS_SRVREC_AIL_DAB_TUNER},
   { CCA_C_U16_SRV_FUELPRICES,                                TR_CLASS_SRVREC_AIL_FUELPRICES},
   { CCA_C_U16_SRV_MOVIETIMES,                                TR_CLASS_SRVREC_AIL_MOVIETIMES},
   { CCA_C_U16_SRV_DAPI_DEVICEMANAGER,                        TR_CLASS_SRVREC_AIL_DAPI_DEVICEMANAGER},
   { CCA_C_U16_SRV_LEARNING_DATA,                             TR_CLASS_SRVREC_AIL_LEARNING_DATA},
   { CCA_C_U16_SRV_TRACK_DATA_STORAGE,                        TR_CLASS_SRVREC_AIL_TRACK_DATA_STORAGE},
   { CCA_C_U16_SRV_DAB_MECA,                                  TR_CLASS_SRVREC_AIL_DAB_MECA},
   { CCA_C_U16_SRV_GEOGRAPHIC_REFERENCE,                      TR_CLASS_SRVREC_AIL_GEOGRAPHIC_REFERENCE},
   { CCA_C_U16_SRV_FB_MICROPHONEINPUT_2,                      TR_CLASS_SRVREC_AIL_FB_MICROPHONEINPUT_2},
   { CCA_C_U16_SRV_MOSTTestServer,                            TR_CLASS_SRVREC_AIL_MOSTTestServer},
   { CCA_C_U16_SRV_MOSTFilter,                                TR_CLASS_SRVREC_AIL_MOSTFilter},
   { CCA_C_U16_SRV_DAB_DATA,                                  TR_CLASS_SRVREC_AIL_DAB_DATA},
   { CCA_C_U16_SRV_BROWSER,                                   TR_CLASS_SRVREC_AIL_BROWSER},
   { CCA_C_U16_SRV_BROWSER_MEDIA,                             TR_CLASS_SRVREC_AIL_BROWSER_MEDIA},
   { CCA_C_U16_SRV_APP_OPERAMINI,                             TR_CLASS_SRVREC_AIL_APP_OPERAMINI},
   { CCA_C_U16_SRV_APP_ACT_SAFETY_DEMO,                       TR_CLASS_SRVREC_AIL_APP_ACT_SAFETY_DEMO},
   { CCA_C_U16_SRV_FC_BTAUDIO,                                TR_CLASS_SRVREC_AIL_FC_BTAUDIO},
   { CCA_C_U16_SRV_VD_TEM,                                    TR_CLASS_SRVREC_AIL_VD_TEM},
   { CCA_C_U16_SRV_APP_CSB,                                   TR_CLASS_SRVREC_AIL_APP_CSB},
   { CCA_C_U16_SRV_RADIODATA_IDU,                             TR_CLASS_SRVREC_AIL_RADIODATA_IDU},
   { CCA_C_U16_SRV_SREC_CTRL,                                 TR_CLASS_SRVREC_AIL_SREC_CTRL},
   { CCA_C_U16_SRV_COMMUNITY_TELEMATICS,                      TR_CLASS_SRVREC_AIL_COMMUNITY_TELEMATICS},
   { CCA_C_U16_SRV_COMMUNITY_MANAGEMENT,                      TR_CLASS_SRVREC_AIL_COMMUNITY_MANAGEMENT},
   { CCA_C_U16_SRV_AUDIO_ROUTE_MGR,                           TR_CLASS_SRVREC_AIL_AUDIO_ROUTE_MGR},
   { CCA_C_U16_SRV_DIVA_SERVER,                               TR_CLASS_SRVREC_AIL_DIVA_SERVER},
   { CCA_C_U16_SRV_AUD_SRC_ROUTE,                             TR_CLASS_SRVREC_AIL_AUD_SRC_ROUTE},
   { CCA_C_U16_SRV_SXM_AUDIO,                                 TR_CLASS_SRVREC_AIL_SXM_AUDIO},
   { CCA_C_U16_SRV_SXM_FUEL,                                  TR_CLASS_SRVREC_AIL_SXM_FUEL},
   { CCA_C_U16_SRV_SXM_GRAPHICAL_WEATHER,                     TR_CLASS_SRVREC_AIL_SXM_GRAPHICAL_WEATHER},
   { CCA_C_U16_SRV_SXM_TABULAR_WEATHER,                       TR_CLASS_SRVREC_AIL_SXM_TABULAR_WEATHER},
   { CCA_C_U16_SRV_SXM_SPORTS,                                TR_CLASS_SRVREC_AIL_SXM_SPORTS},
   { CCA_C_U16_SRV_SXM_STOCKS,                                TR_CLASS_SRVREC_AIL_SXM_STOCKS},
   { CCA_C_U16_SRV_SXM_MOVIES,                                TR_CLASS_SRVREC_AIL_SXM_MOVIES},
   { CCA_C_U16_SRV_INFOSCOUT,                                 TR_CLASS_SRVREC_AIL_INFOSCOUT},
   { CCA_C_U16_SRV_SXM_TRAFFIC,                               TR_CLASS_SRVREC_AIL_SXM_TRAFFIC},
   { CCA_C_U16_SRV_SXM_SAFETY_CAMERA,                         TR_CLASS_SRVREC_AIL_SXM_SAFETY_CAMERA},
   { CCA_C_U16_SRV_CATALOGUE,                                 TR_CLASS_SRVREC_AIL_CATALOGUE},
   { CCA_C_U16_SRV_SXM_CHANNEL_ART,                           TR_CLASS_SRVREC_AIL_SXM_CHANNEL_ART},
   { CCA_C_U16_SRV_POI,                                       TR_CLASS_SRVREC_AIL_POI},
   { CCA_C_U16_SRV_MCAN_TCU,                                  TR_CLASS_SRVREC_AIL_MCAN_TCU},
   { CCA_C_U16_SRV_SD_REFRESH_CLIENT,                         TR_CLASS_SRVREC_AIL_SD_REFRESH_CLIENT},
   { CCA_C_U16_SRV_FC_TPEG,                                   TR_CLASS_SRVREC_AIL_FC_TPEG},
   { CCA_C_U16_SRV_RSE,                                       TR_CLASS_SRVREC_AIL_RSE},
   { CCA_C_U16_SRV_CAN_PROXY,                                 TR_CLASS_SRVREC_AIL_CAN_PROXY},
   { CCA_C_U16_SRV_LANGUAGECHANGE,                            TR_CLASS_SRVREC_AIL_LANGUAGECHANGE},
   { CCA_C_U16_SRV_POS_ENGINEERING,                           TR_CLASS_SRVREC_AIL_POS_ENGINEERING},
   { CCA_C_U16_SRV_POI_HANDLER,                               TR_CLASS_SRVREC_AIL_POI_HANDLER},
   { CCA_C_U16_SRV_USB_TCU,                                   TR_CLASS_SRVREC_AIL_USB_TCU},
   { CCA_C_U16_SRV_TRAFFIC_INFORMATION,                       TR_CLASS_SRVREC_AIL_TRAFFIC_INFORMATION},
   { CCA_C_U16_SRV_VIDEO_CAMERA,                              TR_CLASS_SRVREC_AIL_VIDEO_CAMERA},
   { CCA_C_U16_SRV_RVC_EARLY,                                 TR_CLASS_SRVREC_AIL_RVC_EARLY},
   { CCA_C_U16_SRV_BTREMOTECONTROL,                           TR_CLASS_SRVREC_AIL_BTREMOTECONTROL},
   { CCA_C_U16_SRV_SENSOR_LOCATION,                           TR_CLASS_SRVREC_AIL_SENSOR_LOCATION},
   { CCA_C_U16_SRV_AUX,                                       TR_CLASS_SRVREC_AIL_AUX},
   { CCA_C_U16_SRV_DATASERVICES,                              TR_CLASS_SRVREC_AIL_DATASERVICES},
   { CCA_C_U16_SRV_DP_DB_ACCESS,                              TR_CLASS_SRVREC_AIL_DP_DB_ACCESS},
   { CCA_C_U16_SRV_REAR_VC,                                   TR_CLASS_SRVREC_AIL_REAR_VC},
   { CCA_C_U16_SRV_VD_INPUT,                                  TR_CLASS_SRVREC_AIL_VD_INPUT},
   { CCA_C_U16_SRV_HIT,                                       TR_CLASS_SRVREC_AIL_HIT},
   { CCA_C_U16_SRV_DVDPLAYER,                                 TR_CLASS_SRVREC_AIL_DVDPLAYER},
   { CCA_C_U16_SRV_SWITCH_GW,                                 TR_CLASS_SRVREC_AIL_SWITCH_GW},
   { CCA_C_U16_SRV_ACL_SPI,                                   TR_CLASS_SRVREC_AIL_ACL_SPI},
   { CCA_C_U16_SRV_OTA,                                       TR_CLASS_SRVREC_AIL_OTA},
   { CCA_C_U16_SRV_PARKASSIST,                                TR_CLASS_SRVREC_AIL_PARKASSIST},
   { CCA_C_U16_SRV_SXM_WEATHER_ALERTS,                        TR_CLASS_SRVREC_AIL_SXM_WEATHER_ALERTS},
   { CCA_C_U16_SRV_SXM_CANADIAN_FUEL,                         TR_CLASS_SRVREC_AIL_SXM_CANADIAN_FUEL},
   { CCA_C_U16_SRV_SXM_PARKING,                               TR_CLASS_SRVREC_AIL_SXM_PARKING},
   { CCA_C_U16_SRV_DATACOLLECTOR,                             TR_CLASS_SRVREC_AIL_DATACOLLECTOR},
   { CCA_C_U16_SRV_LEARNDATACOMM,                             TR_CLASS_SRVREC_AIL_LEARNDATACOMM},
   { CCA_C_U16_SRV_SXM_PHONETICS,                             TR_CLASS_SRVREC_AIL_SXM_PHONETICS},
   { CCA_C_U16_SRV_GENERIC_PROXY,                             TR_CLASS_SRVREC_AIL_GENERIC_PROXY},
   { CCA_C_U16_SRV_PV,                                        TR_CLASS_SRVREC_AIL_PV},
   { CCA_C_U16_SRV_CONNECT_TRAFFIC,                           TR_CLASS_SRVREC_AIL_CONNECT_TRAFFIC},
   { CCA_C_U16_SRV_EXT_DRV,                                   TR_CLASS_SRVREC_AIL_EXT_DRV},
   { CCA_C_U16_SRV_NAVI_3RD_PARTY,                            TR_CLASS_SRVREC_AIL_NAVI_3RD_PARTY},
   { CCA_C_U16_SRV_VEHICLEFUNCTION_SR_EXTBOX,                 TR_CLASS_SRVREC_AIL_VEHICLEFUNCTION_SR_EXTBOX},
   { CCA_C_U16_SRV_VEHICLEFUNCTION_MEX_EXTBOX,                TR_CLASS_SRVREC_AIL_VEHICLEFUNCTION_MEX_EXTBOX},
   { CCA_C_U16_SRV_VEHICLEFUNCTION_EV_EXTBOX,                 TR_CLASS_SRVREC_AIL_VEHICLEFUNCTION_EV_EXTBOX},
   { CCA_C_U16_SRV_VEHICLEFUNCTION_DRV_ASST_EXTBOX,           TR_CLASS_SRVREC_AIL_VEHICLEFUNCTION_DRV_ASST_EXTBOX},
   { CCA_C_U16_SRV_VEHICLEFUNCTION_CLIMATE_EXTBOX,            TR_CLASS_SRVREC_AIL_VEHICLEFUNCTION_CLIMATE_EXTBOX},
   { CCA_C_U16_SRV_VEHICLEFUNCTION_HVAC_EXTBOX,               TR_CLASS_SRVREC_AIL_VEHICLEFUNCTION_HVAC_EXTBOX},
   { CCA_C_U16_SRV_VEHICLEFUNCTION_TPMS_EXTBOX,               TR_CLASS_SRVREC_AIL_VEHICLEFUNCTION_TPMS_EXTBOX},
   { CCA_C_U16_SRV_VEHICLEFUNCTION_CLINOMETER_EXTBOX,         TR_CLASS_SRVREC_AIL_VEHICLEFUNCTION_CLINOMETER_EXTBOX},
   { CCA_C_U16_SRV_VEHICLEFUNCTION_DRV_ECO_EXTBOX,            TR_CLASS_SRVREC_AIL_VEHICLEFUNCTION_DRV_ECO_EXTBOX},
   { CCA_C_U16_SRV_VEHICLEFUNCTION_RES_EXTBOX,                TR_CLASS_SRVREC_AIL_VEHICLEFUNCTION_RES_EXTBOX},
   { CCA_C_U16_SRV_VEHICLEFUNCTION_AIR_QTY_EXTBOX,            TR_CLASS_SRVREC_AIL_VEHICLEFUNCTION_AIR_QTY_EXTBOX},
   { CCA_C_U16_SRV_VEHICLEFUNCTION_BODY_EQP_EXTBOX,           TR_CLASS_SRVREC_AIL_VEHICLEFUNCTION_BODY_EQP_EXTBOX},
   { CCA_C_U16_SRV_CONNECT,                                   TR_CLASS_SRVREC_AIL_CONNECT},
   { CCA_C_U16_SRV_CONNECT_TPEG,                              TR_CLASS_SRVREC_AIL_CONNECT_TPEG},
   { CCA_C_U16_SRV_TPEGDATA,                                  TR_CLASS_SRVREC_AIL_TPEGDATA},
   { CCA_C_U16_SRV_USERMANAGER,                               TR_CLASS_SRVREC_AIL_USERMANAGER},
   { CCA_C_U16_SRV_LCM_DBUS_CLIENT,                           TR_CLASS_SRVREC_AIL_LCM_DBUS_CLIENT},
   { CCA_C_U16_SRV_FC_VIDEOPOSITIONSUPPORT,                   TR_CLASS_SRVREC_AIL_FC_VIDEOPOSITIONSUPPORT},
   { CCA_C_U16_SRV_VEHICLEFUNCTION_DRV_COMP_EXTBOX,           TR_CLASS_SRVREC_AIL_VEHICLEFUNCTION_DRV_COMP_EXTBOX},
   { CCA_C_U16_SRV_VEHICLEFUNCTION_DRV_ASST_PIVI_EXTBOX,      TR_CLASS_SRVREC_AIL_VEHICLEFUNCTION_DRV_ASST_PIVI_EXTBOX},
   { CCA_C_U16_SRV_VEHICLEFUNCTION_HUD_EXTBOX,                TR_CLASS_SRVREC_AIL_VEHICLEFUNCTION_HUD_EXTBOX},
   { CCA_C_U16_SRV_VEHICLEFUNCTION_MAIN_INFO_EXTBOX,          TR_CLASS_SRVREC_AIL_VEHICLEFUNCTION_MAIN_INFO_EXTBOX},
   { CCA_C_U16_SRV_VEHICLEFUNCTION_HVAC_PIVI_EXTBOX,          TR_CLASS_SRVREC_AIL_VEHICLEFUNCTION_HVAC_PIVI_EXTBOX},
   { CCA_C_U16_SRV_WPV,                                       TR_CLASS_SRVREC_AIL_WPV},
   { CCA_C_U16_SRV_FC_DUMM,                                   TR_CLASS_SRVREC_AIL_FC_DUMM},
   { CCA_C_U16_SRV_FD_THERMAL_MGMT,                           TR_CLASS_SRVREC_AIL_FD_THERMAL_MGMT},
   { CCA_C_U16_SRV_FD_SUPPLY_MGMT,                            TR_CLASS_SRVREC_AIL_FD_SUPPLY_MGMT},
   { CCA_C_U16_SRV_FD_PWR_MASTER,                             TR_CLASS_SRVREC_AIL_FD_PWR_MASTER},
   { CCA_C_U16_SRV_FD_SYSTEM_SM,                              TR_CLASS_SRVREC_AIL_FD_SYSTEM_SM},
   { CCA_C_U16_SRV_AUTO_DRIVE,                                TR_CLASS_SRVREC_AIL_AUTO_DRIVE},
   { CCA_C_U16_SRV_VIDEO_MANAGER,                             TR_CLASS_SRVREC_AIL_VIDEO_MANAGER},
   { CCA_C_U16_SRV_TPEGSIMULATION,                            TR_CLASS_SRVREC_AIL_TPEGSIMULATION},
   { CCA_C_U16_SRV_SEAMLESS_PAIRING_IPCM,                     TR_CLASS_SRVREC_AIL_SEAMLESS_PAIRING_IPCM},
   { CCA_C_U16_SRV_MEDIA_CONTENT_SHARING,                     TR_CLASS_SRVREC_AIL_MEDIA_CONTENT_SHARING},
   { CCA_C_U16_SRV_FC_EXT_MEDIA_IN,                           TR_CLASS_SRVREC_AIL_FC_EXT_MEDIA_IN},
   { CCA_C_U16_SRV_SPM,                                       TR_CLASS_SRVREC_AIL_SPM},
   { CCA_C_U16_SRV_CONTEXTMANAGER,                            TR_CLASS_SRVREC_AIL_CONTEXTMANAGER},
   { CCA_C_U16_SRV_AUDIOFUNC,                                 TR_CLASS_SRVREC_AIL_AUDIOFUNC},
   { CCA_C_U16_SRV_TUNERCONTROL,                              TR_CLASS_SRVREC_AIL_TUNERCONTROL},
   { CCA_C_U16_SRV_SPI,                                       TR_CLASS_SRVREC_AIL_SPI},
   { CCA_C_U16_SRV_SMARTPHONEINTEGRATION,                     TR_CLASS_SRVREC_AIL_SMARTPHONEINTEGRATION},
   { CCA_C_U16_SRV_CDVD,                                      TR_CLASS_SRVREC_AIL_CDVD},
   { CCA_C_U16_SRV_MP3,                                       TR_CLASS_SRVREC_AIL_MP3},
   { CCA_C_U16_SRV_DIAGDEBUG,                                 TR_CLASS_SRVREC_AIL_DIAGDEBUG},
   { CCA_C_U16_SRV_DOWNLOAD,                                  TR_CLASS_SRVREC_AIL_DOWNLOAD},
   { CCA_C_U16_SRV_GATEWAY,                                   TR_CLASS_SRVREC_AIL_GATEWAY},
   { CCA_C_U16_SRV_CHKSUM,                                    TR_CLASS_SRVREC_AIL_CHKSUM},
   { CCA_C_U16_SRV_TUNERMASTERCONTROL,                        TR_CLASS_SRVREC_AIL_TUNERMASTERCONTROL},
   { CCA_C_U16_SRV_SPI_RADIO,                                 TR_CLASS_SRVREC_AIL_SPI_RADIO},
   { CCA_C_U16_SRV_SPI_KEYBOARD,                              TR_CLASS_SRVREC_AIL_SPI_KEYBOARD},
   { CCA_C_U16_SRV_SPI_DISPLAY,                               TR_CLASS_SRVREC_AIL_SPI_DISPLAY},
   { CCA_C_U16_SRV_NAVIFUNC_NAVI,                             TR_CLASS_SRVREC_AIL_NAVIFUNC_NAVI},
   { CCA_C_U16_SRV_NAVIFUNC_SENSOR,                           TR_CLASS_SRVREC_AIL_NAVIFUNC_SENSOR},
   { CCA_C_U16_SRV_NAVIFUNC_TIMA,                             TR_CLASS_SRVREC_AIL_NAVIFUNC_TIMA},
   { CCA_C_U16_SRV_DRVFUNC_CDC,                               TR_CLASS_SRVREC_AIL_DRVFUNC_CDC},
   { CCA_C_U16_SRV_DRVFUNC_CD,                                TR_CLASS_SRVREC_AIL_DRVFUNC_CD},
   { CCA_C_U16_SRV_AUDIO_SRC,                                 TR_CLASS_SRVREC_AIL_AUDIO_SRC},
   { CCA_C_U16_SRV_UIDIAG,                                    TR_CLASS_SRVREC_AIL_UIDIAG},
   { CCA_C_U16_SRV_MAPCTRL,                                   TR_CLASS_SRVREC_AIL_MAPCTRL},
   { CCA_C_U16_SRV_AUDIODIAG,                                 TR_CLASS_SRVREC_AIL_AUDIODIAG},
   { CCA_C_U16_SRV_TUNERDIAG,                                 TR_CLASS_SRVREC_AIL_TUNERDIAG},
   { CCA_C_U16_SRV_DDL_TEST,                                  TR_CLASS_SRVREC_AIL_DDL_TEST},
   { CCA_C_U16_SRV_AMFM_AUD,                                  TR_CLASS_SRVREC_AIL_AMFM_AUD},
   { CCA_C_U16_SRV_AUDIO_DIAG,                                TR_CLASS_SRVREC_AIL_AUDIO_DIAG},
   { CCA_C_U16_SRV_AMFM_AUD_TUN,                              TR_CLASS_SRVREC_AIL_AMFM_AUD_TUN},
   { CCA_C_U16_SRV_AMFM_AUD_AUD,                              TR_CLASS_SRVREC_AIL_AMFM_AUD_AUD},
   { CCA_C_U16_SRV_AMFM_AUD_DAB,                              TR_CLASS_SRVREC_AIL_AMFM_AUD_DAB},
   { CCA_C_U16_SRV_KBD,                                       TR_CLASS_SRVREC_AIL_KBD},
   { CCA_C_U16_SRV_MMGR,                                      TR_CLASS_SRVREC_AIL_MMGR},
   { CCA_C_U16_SRV_CLUSTER,                                   TR_CLASS_SRVREC_AIL_CLUSTER},
   { CCA_C_U16_SRV_CAPCTRL,                                   TR_CLASS_SRVREC_AIL_CAPCTRL},
   { CCA_C_U16_SRV_EXTKI,                                     TR_CLASS_SRVREC_AIL_EXTKI},
   { CCA_C_U16_SRV_HMI,                                       TR_CLASS_SRVREC_AIL_HMI},
   { CCA_C_U16_SRV_CANCOMM,                                   TR_CLASS_SRVREC_AIL_CANCOMM},
   { CCA_C_U16_SRV_VIDEO,                                     TR_CLASS_SRVREC_AIL_VIDEO},
   { CCA_C_U16_SRV_SDS_VOICE_CONTROL,                         TR_CLASS_SRVREC_AIL_SDS_VOICE_CONTROL},
   { CCA_C_U16_SRV_SDS_RECOGNIZER,                            TR_CLASS_SRVREC_AIL_SDS_RECOGNIZER},
   { CCA_C_U16_SRV_SDS_TTS,                                   TR_CLASS_SRVREC_AIL_SDS_TTS},
   { CCA_C_U16_SRV_SDS_PROMPT_PLAYER,                         TR_CLASS_SRVREC_AIL_SDS_PROMPT_PLAYER},
   { CCA_C_U16_SRV_SDS_RECORDER,                              TR_CLASS_SRVREC_AIL_SDS_RECORDER},
   { CCA_C_U16_SRV_SDS_SPEECH_DATA_PROVIDER,                  TR_CLASS_SRVREC_AIL_SDS_SPEECH_DATA_PROVIDER},
   { CCA_C_U16_SRV_SDS_TEST_BASEAPP,                          TR_CLASS_SRVREC_AIL_SDS_TEST_BASEAPP},
   { CCA_C_U16_SRV_SDS_TRANSCRIPTIONSERVICE,                  TR_CLASS_SRVREC_AIL_SDS_TRANSCRIPTIONSERVICE},
   { CCA_C_U16_SRV_ACR,                                       TR_CLASS_SRVREC_AIL_ACR},
   { CCA_C_U16_SRV_SDS_VOCONSERVICE,                          TR_CLASS_SRVREC_AIL_SDS_VOCONSERVICE},
   { CCA_C_U16_SRV_SDS_WRAPPER,                               TR_CLASS_SRVREC_AIL_SDS_WRAPPER},
   { CCA_C_U16_SRV_SDS_TESTAPP,                               TR_CLASS_SRVREC_AIL_SDS_TESTAPP},
   { CCA_C_U16_SRV_FB_ALERTMANAGER,                           TR_CLASS_SRVREC_AIL_FB_ALERTMANAGER},
   { CCA_C_U16_SRV_FB_AMPLIFIER,                              TR_CLASS_SRVREC_AIL_FB_AMPLIFIER},
   { CCA_C_U16_SRV_FB_AMTUNER,                                TR_CLASS_SRVREC_AIL_FB_AMTUNER},
   { CCA_C_U16_SRV_FB_AUDIOCUES,                              TR_CLASS_SRVREC_AIL_FB_AUDIOCUES},
   { CCA_C_U16_SRV_FB_AUDIODISKPLAYER,                        TR_CLASS_SRVREC_AIL_FB_AUDIODISKPLAYER},
   { CCA_C_U16_SRV_FB_AVMANAGER,                              TR_CLASS_SRVREC_AIL_FB_AVMANAGER},
   { CCA_C_U16_SRV_FB_AUXILIARYINPUTJACK,                     TR_CLASS_SRVREC_AIL_FB_AUXILIARYINPUTJACK},
   { CCA_C_U16_SRV_FB_BLUETOOTHSETTINGS,                      TR_CLASS_SRVREC_AIL_FB_BLUETOOTHSETTINGS},
   { CCA_C_U16_SRV_FB_CENTERSTACKHMI,                         TR_CLASS_SRVREC_AIL_FB_CENTERSTACKHMI},
   { CCA_C_U16_SRV_FB_CUSTOMIZATIONBCM,                       TR_CLASS_SRVREC_AIL_FB_CUSTOMIZATIONBCM},
   { CCA_C_U16_SRV_FB_CUSTOMIZATIONDOORSLOCKS,                TR_CLASS_SRVREC_AIL_FB_CUSTOMIZATIONDOORSLOCKS},
   { CCA_C_U16_SRV_FB_CUSTOMIZATIONECC,                       TR_CLASS_SRVREC_AIL_FB_CUSTOMIZATIONECC},
   { CCA_C_U16_SRV_FB_CUSTOMIZATIONIPC,                       TR_CLASS_SRVREC_AIL_FB_CUSTOMIZATIONIPC},
   { CCA_C_U16_SRV_FB_CUSTOMIZATIONMEMORYSETTINGS,            TR_CLASS_SRVREC_AIL_FB_CUSTOMIZATIONMEMORYSETTINGS},
   { CCA_C_U16_SRV_FB_CUSTOMIZATIONOBJECTCOMPUTATIONSETTINGS, TR_CLASS_SRVREC_AIL_FB_CUSTOMIZATIONOBJECTCOMPUTATIONSETTINGS},
   { CCA_C_U16_SRV_FB_CUSTOMIZATIONPA,                        TR_CLASS_SRVREC_AIL_FB_CUSTOMIZATIONPA},
   { CCA_C_U16_SRV_FB_CUSTOMIZATIONSBZA,                      TR_CLASS_SRVREC_AIL_FB_CUSTOMIZATIONSBZA},
   { CCA_C_U16_SRV_FB_DABTUNER,                               TR_CLASS_SRVREC_AIL_FB_DABTUNER},
   { CCA_C_U16_SRV_FB_DEVELOPMENTSCREENCLIENT,                TR_CLASS_SRVREC_AIL_FB_DEVELOPMENTSCREENCLIENT},
   { CCA_C_U16_SRV_FB_ENHANCEDTESTABILITY,                    TR_CLASS_SRVREC_AIL_FB_ENHANCEDTESTABILITY},
   { CCA_C_U16_SRV_FB_FAVORITESBACKUPMANAGER,                 TR_CLASS_SRVREC_AIL_FB_FAVORITESBACKUPMANAGER},
   { CCA_C_U16_SRV_FB_FAVORITESMANAGER,                       TR_CLASS_SRVREC_AIL_FB_FAVORITESMANAGER},
   { CCA_C_U16_SRV_FB_FMTUNER,                                TR_CLASS_SRVREC_AIL_FB_FMTUNER},
   { CCA_C_U16_SRV_FB_GMLANGATEWAY,                           TR_CLASS_SRVREC_AIL_FB_GMLANGATEWAY},
   { CCA_C_U16_SRV_FB_HEADPHONE,                              TR_CLASS_SRVREC_AIL_FB_HEADPHONE},
   { CCA_C_U16_SRV_FB_HVACSETTINGS,                           TR_CLASS_SRVREC_AIL_FB_HVACSETTINGS},
   { CCA_C_U16_SRV_FB_ICSCONTROLS,                            TR_CLASS_SRVREC_AIL_FB_ICSCONTROLS},
   { CCA_C_U16_SRV_FB_INTERNETAPPLICATIONS,                   TR_CLASS_SRVREC_AIL_FB_INTERNETAPPLICATIONS},
   { CCA_C_U16_SRV_FB_INTERNETRADIO,                          TR_CLASS_SRVREC_AIL_FB_INTERNETRADIO},
   { CCA_C_U16_SRV_FB_LVMINTERFACE,                           TR_CLASS_SRVREC_AIL_FB_LVMINTERFACE},
   { CCA_C_U16_SRV_FB_MEDIAPLAYER,                            TR_CLASS_SRVREC_AIL_FB_MEDIAPLAYER},
   { CCA_C_U16_SRV_FB_MESSAGING,                              TR_CLASS_SRVREC_AIL_FB_MESSAGING},
   { CCA_C_U16_SRV_FB_MICROPHONEINPUT,                        TR_CLASS_SRVREC_AIL_FB_MICROPHONEINPUT},
   { CCA_C_U16_SRV_FB_NAVIGATION,                             TR_CLASS_SRVREC_AIL_FB_NAVIGATION},
   { CCA_C_U16_SRV_FB_NETBLOCK,                               TR_CLASS_SRVREC_AIL_FB_NETBLOCK},
   { CCA_C_U16_SRV_FB_NETBLOCK_TIMINGMASTER,                  TR_CLASS_SRVREC_AIL_FB_NETBLOCK_TIMINGMASTER},
   { CCA_C_U16_SRV_FB_NETWORKMASTER,                          TR_CLASS_SRVREC_AIL_FB_NETWORKMASTER},
   { CCA_C_U16_SRV_FB_ONSTARAUDIO,                            TR_CLASS_SRVREC_AIL_FB_ONSTARAUDIO},
   { CCA_C_U16_SRV_FB_ONSTARDATASETTINGS,                     TR_CLASS_SRVREC_AIL_FB_ONSTARDATASETTINGS},
   { CCA_C_U16_SRV_FB_ONSTARPERSONALCALLING,                  TR_CLASS_SRVREC_AIL_FB_ONSTARPERSONALCALLING},
   { CCA_C_U16_SRV_FB_ONSTARTBTNAVIGATION,                    TR_CLASS_SRVREC_AIL_FB_ONSTARTBTNAVIGATION},
   { CCA_C_U16_SRV_FB_PHONEBOOK,                              TR_CLASS_SRVREC_AIL_FB_PHONEBOOK},
   { CCA_C_U16_SRV_FB_PROGRAMMINGMASTER,                      TR_CLASS_SRVREC_AIL_FB_PROGRAMMINGMASTER},
   { CCA_C_U16_SRV_FB_SDARS,                                  TR_CLASS_SRVREC_AIL_FB_SDARS},
   { CCA_C_U16_SRV_FB_SPEECHHMI,                              TR_CLASS_SRVREC_AIL_FB_SPEECHHMI},
   { CCA_C_U16_SRV_FB_SYSTEMSTATE,                            TR_CLASS_SRVREC_AIL_FB_SYSTEMSTATE},
   { CCA_C_U16_SRV_FB_TELEPHONE,                              TR_CLASS_SRVREC_AIL_FB_TELEPHONE},
   { CCA_C_U16_SRV_FB_TEXTTOSPEECH,                           TR_CLASS_SRVREC_AIL_FB_TEXTTOSPEECH},
   { CCA_C_U16_SRV_FB_AUXTOUCHSCREEN,                         TR_CLASS_SRVREC_AIL_FB_AUXTOUCHSCREEN},
   { CCA_C_U16_SRV_FB_DOWNLOAD,                               TR_CLASS_SRVREC_AIL_FB_DOWNLOAD},
   { CCA_C_U16_SRV_FB_GPS,                                    TR_CLASS_SRVREC_AIL_FB_GPS},
   { CCA_C_U16_SRV_FB_RSEPLAYER,                              TR_CLASS_SRVREC_AIL_FB_RSEPLAYER},
   { CCA_C_U16_SRV_FB_SPEECHRECOGNITIONTESTSERVER,            TR_CLASS_SRVREC_AIL_FB_SPEECHRECOGNITIONTESTSERVER},
   { CCA_C_U16_SRV_FB_ICSCONTROLS_2,                          TR_CLASS_SRVREC_AIL_FB_ICSCONTROLS_2},
   { CCA_C_U16_SRV_FB_SDARS_2,                                TR_CLASS_SRVREC_AIL_FB_SDARS_2},
   { CCA_C_U16_SRV_FB_FMTUNER_2,                              TR_CLASS_SRVREC_AIL_FB_FMTUNER_2},
   { CCA_C_U16_SRV_FB_CLUSTERHMI,                             TR_CLASS_SRVREC_AIL_FB_CLUSTERHMI},
   { CCA_C_U16_SRV_FB_TOUCHPAD,                               TR_CLASS_SRVREC_AIL_FB_TOUCHPAD},
   { CCA_C_U16_SRV_FB_WIFISETTINGS,                           TR_CLASS_SRVREC_AIL_FB_WIFISETTINGS},
   { CCA_C_U16_SRV_FB_DEVICEPROJECTION,                       TR_CLASS_SRVREC_AIL_FB_DEVICEPROJECTION},
   { CCA_C_U16_SRV_ANIMATION,                                 TR_CLASS_SRVREC_AIL_ANIMATION},
   { CCA_C_U16_SRV_STREAMROUTER,                              TR_CLASS_SRVREC_AIL_STREAMROUTER},
   { CCA_C_U16_SRV_DRVASS_VIDEO_EARLY,                        TR_CLASS_SRVREC_AIL_DRVASS_VIDEO_EARLY},
   { CCA_C_U16_SRV_DRVASS_VIDEO,                              TR_CLASS_SRVREC_AIL_DRVASS_VIDEO},
   { CCA_C_U16_SRV_TOUCHDISPLAY,                              TR_CLASS_SRVREC_AIL_TOUCHDISPLAY},
   { CCA_C_U16_SRV_IPODAUTH,                                  TR_CLASS_SRVREC_AIL_IPODAUTH},
   { CCA_C_U16_SRV_IPOD_PANDORA,                              TR_CLASS_SRVREC_AIL_IPOD_PANDORA},
   { CCA_C_U16_SRV_NAVSTORAGE,                                TR_CLASS_SRVREC_AIL_NAVSTORAGE},
   { CCA_C_U16_SRV_LOCATIONBASEDSERVICE,                      TR_CLASS_SRVREC_AIL_LOCATIONBASEDSERVICE},
   { CCA_C_U16_SRV_NAVCOPY,                                   TR_CLASS_SRVREC_AIL_NAVCOPY},
   { CCA_C_U16_SRV_NAV_EXTENDED,                              TR_CLASS_SRVREC_AIL_NAV_EXTENDED},
   { CCA_C_U16_SRV_RADIODATA_WEATHER,                         TR_CLASS_SRVREC_AIL_RADIODATA_WEATHER},
   { CCA_C_U16_SRV_RADIODATA_TRAFFIC,                         TR_CLASS_SRVREC_AIL_RADIODATA_TRAFFIC},
   { CCA_C_U16_SRV_RADIODATA_LOCATIONBASEDSERVICES,           TR_CLASS_SRVREC_AIL_RADIODATA_LOCATIONBASEDSERVICES},
   { CCA_C_U16_SRV_RADIODATA_RELIABLEFILE,                    TR_CLASS_SRVREC_AIL_RADIODATA_RELIABLEFILE},
   { CCA_C_U16_SRV_SAAL,                                      TR_CLASS_SRVREC_AIL_SAAL},
   { CCA_C_U16_SRV_RADIODATA_MOVIE,                           TR_CLASS_SRVREC_AIL_RADIODATA_MOVIE},
   { CCA_C_U16_SRV_RADIODATA_FUEL,                            TR_CLASS_SRVREC_AIL_RADIODATA_FUEL},
   { CCA_C_U16_SRV_RADIODATA_SONGTAG,                         TR_CLASS_SRVREC_AIL_RADIODATA_SONGTAG},
   { CCA_C_U16_SRV_RADIODATA_DLPLUS,                          TR_CLASS_SRVREC_AIL_RADIODATA_DLPLUS},
   { CCA_C_U16_SRV_PROFILERSERVICE,                           TR_CLASS_SRVREC_AIL_PROFILERSERVICE},
   { CCA_C_U16_SRV_CDPLAYER,                                  TR_CLASS_SRVREC_AIL_CDPLAYER},
   { CCA_C_U16_SRV_BTDEVICEMANAGER,                           TR_CLASS_SRVREC_AIL_BTDEVICEMANAGER},
   { CCA_C_U16_SRV_ADVANCEDPARKASSIST,                        TR_CLASS_SRVREC_AIL_ADVANCEDPARKASSIST},
   { CCA_C_U16_SRV_MAPUPDATE,                                 TR_CLASS_SRVREC_AIL_MAPUPDATE},
   { CCA_C_U16_SRV_MAP_3D_CTRL,                               TR_CLASS_SRVREC_AIL_MAP_3D_CTRL},
   { CCA_C_U16_SRV_FMWORKER_INTERNAL,                         TR_CLASS_SRVREC_AIL_FMWORKER_INTERNAL},
   { CCA_C_U16_SRV_CONNECT_MAP,                               TR_CLASS_SRVREC_AIL_CONNECT_MAP},
   { CCA_C_U16_SRV_PDIM,                                      TR_CLASS_SRVREC_AIL_PDIM},
   { CCA_C_U16_SRV_FRAMETEST_ADDITIONAL_TEST_SERVICE,         TR_CLASS_SRVREC_AIL_FRAMETEST_ADDITIONAL_TEST_SERVICE},
   { CCA_C_U16_SRV_FRAMETEST_TEST_SERVICE,                    TR_CLASS_SRVREC_AIL_FRAMETEST_TEST_SERVICE},
   { CCA_C_U16_SRV_CSFW_CCA_TEST_SERVICE,                     TR_CLASS_SRVREC_AIL_CSFW_CCA_TEST_SERVICE},
   { CCA_C_U16_SRV_CSFW_CCA_SAMPLE_SERVICE,                   TR_CLASS_SRVREC_AIL_CSFW_CCA_SAMPLE_SERVICE},
   { CCA_C_U16_SRV_DEMO_SERVICE_CORE_1,                       TR_CLASS_SRVREC_AIL_DEMO_SERVICE_CORE_1},
   { CCA_C_U16_SRV_DEMO_SERVICE_CORE_2,                       TR_CLASS_SRVREC_AIL_DEMO_SERVICE_CORE_2},
   { CCA_C_U16_SRV_DEMO_MESSAGE_SERVICE,                      TR_CLASS_SRVREC_AIL_DEMO_MESSAGE_SERVICE},
   { CCA_C_U16_SRV_MOSTCCAGWSERVICE,                          TR_CLASS_SRVREC_AIL_MOSTCCAGWSERVICE},
   { CCA_C_U16_SRV_IPSIM,                                     TR_CLASS_SRVREC_AIL_IPSIM},
   { CCA_C_U16_SRV_FC_EXT_KI,                                 TR_CLASS_SRVREC_AIL_FC_EXT_KI},
   { CCA_C_U16_SRV_APPINFO,                                   TR_CLASS_SRVREC_AIL_APPINFO}
};

/******************************************************************************
| defines and macros (scope: local)
|-----------------------------------------------------------------------------*/

/******************************************************************************
| function prototype (scope: modul-local)
|-----------------------------------------------------------------------------*/

tVoid ail_TTFis_Callback(tU8 const * pu8Data);

#ifdef AIL_MESSAGE_COUNTER_ENABLED
tVoid ail_Trace_CCA_Blocks(tVoid);
tVoid ail_Clear_CCA_Blocks(tVoid);
tVoid ail_Set_CCA_Counter_Send_Filter(tU16 nFilter);
tVoid ail_Set_CCA_Counter_Receive_Filter(tU16 nFilter);
#endif

/******************************************************************************
| function implementation (scope: modul-local)
|-----------------------------------------------------------------------------*/


/******************************************************************************
| function implementation (scope: global)
|-----------------------------------------------------------------------------*/


/*******************************************************************************
 *FUNCTION:    ail_bInitAilTrace()  
 *DESCRIPTION: Does all initialization for AIL_TRACE 
 *PARAMETER:   none 
 *                
 *                
 *RETURNVALUE: tBool 
 *             TRUE = getting success
 *                
 *HISTORY:
 *18.02.2001 Initial Version  
 ******************************************************************************/
tBool ail_bInitAilTrace()
{
   tBool bRet = TRUE;

   if (ail_s32RefCount == 0)
   {
     ail_s32RefCount = 1;

     /* --------------------------------------------------------------------- */
     /* Open TTFis trace device.                                              */
     /* --------------------------------------------------------------------- */

     rAilTraceIODescriptor = OSAL_IOOpen(OSAL_C_STRING_DEVICE_TRACE, OSAL_EN_READWRITE);

     if (rAilTraceIODescriptor == OSAL_ERROR)
     {
       bRet = FALSE;
     }
     else
     {
       /* --------------------------------------------------------------------- */
       /* Install TTFis callback handler for command inputs.                    */
       /* --------------------------------------------------------------------- */

       OSAL_trIOCtrlLaunchChannel oTraceChannel;

       oTraceChannel.pCallback      = (OSAL_tpfCallback)ail_TTFis_Callback;
       oTraceChannel.enTraceChannel = (TR_tenTraceChan) TR_TTFIS_CCATRACE_P0;

       if (OSAL_s32IOControl(rAilTraceIODescriptor, 
                             OSAL_C_S32_IOCTRL_CALLBACK_REG, 
                             (intptr_t) &oTraceChannel) == OSAL_ERROR)
       {
         tU32 u32ErrorCode = OSAL_u32ErrorCode();

         if (OSAL_E_ALREADYEXISTS != u32ErrorCode)
         {
           ail_vTraceMsg(TR_LEVEL_FATAL, "ail_bInitAilTrace() : Could not register for tracechannel. Error code = 0x%08x", u32ErrorCode);

           bRet = FALSE;
         }
       }

       /* --------------------------------------------------------------------- */
       /* Open or create AIL-trace semaphore.                                   */
       /* --------------------------------------------------------------------- */

       tS32 s32ProcessId = OSAL_ProcessWhoAmI();

       // Try to open the semaphore.
       if(OSAL_OK != OSAL_s32SemaphoreOpen(coszAilTraceSemName, &hSemAilTrace))
       {
         // If semaphore open fails we expect that it doesn't exist and create it.
         if(OSAL_OK != OSAL_s32SemaphoreCreate(coszAilTraceSemName, &hSemAilTrace, 1))
         {
           if (OSAL_E_ALREADYEXISTS == OSAL_u32ErrorCode())
           {
             // The creation may have failed due to race conditions. Another task 
             // with higher priority was called between the above open/create calls 
             // and created the semaphore in the meantime. Now try to open the 
             // semaphore for the second time.

             if(OSAL_OK != OSAL_s32SemaphoreOpen(coszAilTraceSemName, &hSemAilTrace))
             {
               NORMAL_M_ASSERT_ALWAYS();

               bRet = FALSE;
             }
             else
             {
               ail_vTraceMsg(TR_LEVEL_SYSTEM_MIN, "ail_bInitAilTrace() : Opened semaphore %s from process %d", coszAilTraceSemName, s32ProcessId);
             }
           }
           else
           {
             NORMAL_M_ASSERT_ALWAYS();

             bRet = FALSE;
           }
         }
         else
         {
           ail_vTraceMsg(TR_LEVEL_SYSTEM_MIN, "ail_bInitAilTrace() : Created semaphore %s from process %d", coszAilTraceSemName, s32ProcessId);

           bAilTraceSemphoreCreated = TRUE;
         }
       }
       else
       {
         ail_vTraceMsg(TR_LEVEL_SYSTEM_MIN, "ail_bInitAilTrace() : Opened semaphore %s from process %d", coszAilTraceSemName, s32ProcessId);
       }
     }

     /* --------------------------------------------------------------------- */
     /* Create and open shared memory area for message counting.              */
     /* --------------------------------------------------------------------- */

     #ifdef AIL_MESSAGE_COUNTER_ENABLED

     if (ail_s32RefCount == 1)
     {
       #define MEM_SIZE_AIL_MSG_CNT (sizeof(S_CCA_Info_Struct)*CCA_INFO_ARRAY_SIZE)
         // Initialize the shared memory handle.
       OSAL_tShMemHandle localSMHandle = OSAL_SharedMemoryCreate(AIL_MESSAGE_COUNTER_SHMEM_NAME, OSAL_EN_READWRITE, MEM_SIZE_AIL_MSG_CNT);

       if (localSMHandle == OSAL_ERROR)
       {
         localSMHandle = OSAL_SharedMemoryOpen( AIL_MESSAGE_COUNTER_SHMEM_NAME, OSAL_EN_READWRITE);
       }

       if (localSMHandle != OSAL_ERROR)
       {
         spCCA_Info_Array = (S_CCA_Info_Struct*) OSAL_pvSharedMemoryMap( localSMHandle, OSAL_EN_READWRITE, MEM_SIZE_AIL_MSG_CNT, 0);
         if (spCCA_Info_Array != NULL)
         {
           OSAL_pvMemorySet(spCCA_Info_Array,0,MEM_SIZE_AIL_MSG_CNT); 
         }
       }

       // Initialize the shared memory handle for the filter.
       localSMHandle = OSAL_SharedMemoryCreate(AIL_MESSAGE_COUNTER_FILTER_SHMEM_NAME, OSAL_EN_READWRITE, sizeof(S_CCA_Filter_Struct));

       if (localSMHandle == OSAL_ERROR)
       {
         localSMHandle = OSAL_SharedMemoryOpen( AIL_MESSAGE_COUNTER_FILTER_SHMEM_NAME, OSAL_EN_READWRITE);
       }

       if (localSMHandle != OSAL_ERROR)
       {
         spCCA_Filter = (S_CCA_Filter_Struct*) OSAL_pvSharedMemoryMap( localSMHandle, OSAL_EN_READWRITE, sizeof(S_CCA_Filter_Struct), 0);
         if (spCCA_Filter != NULL)
         {
           spCCA_Filter->nCCA_Info_Receive_Filter = AIL_MESSAGE_COUNTER_NO_FILTER;
           spCCA_Filter->nCCA_Info_Send_Filter = AIL_MESSAGE_COUNTER_NO_FILTER;
         }
       }
     }

     #endif
   }
   else
   {
     ail_s32RefCount++;
   }

   return (bRet);
}

/*******************************************************************************
 *FUNCTION:    ail_vExitAilTrace()  
 *DESCRIPTION: Does all initialization for AIL_TRACE 
 *PARAMETER:   none 
 *                
 *                
 *RETURNVALUE: none 
 *
 *HISTORY:
 *18.02.2001 Initial Version  
 ******************************************************************************/
tVoid ail_vExitAilTrace()
{
  if (ail_s32RefCount > 1)
  {
    ail_s32RefCount--;
  }
  else if (ail_s32RefCount == 1)
  {
    ail_s32RefCount = 0;

    if (OSAL_C_INVALID_HANDLE != hSemAilTrace)
    {
      tS32 s32ProcessId = OSAL_ProcessWhoAmI();

      if (OSAL_s32SemaphoreClose(hSemAilTrace) == OSAL_OK)
      {
        ail_vTraceMsg(TR_LEVEL_SYSTEM_MIN, "ail_vExitAilTrace() : Closed semaphore %s from process %d", coszAilTraceSemName, s32ProcessId);

        // Only the process which created the AIL trace semaphore 
        // should delete or rather try to delete it.
        if (TRUE == bAilTraceSemphoreCreated)
        {
          if (OSAL_s32SemaphoreDelete(coszAilTraceSemName) == OSAL_OK)
          {
            // If the semaphore is still opened by another AIL using process
            // then OSAL_s32SemaphoreDelete() also returns OSAL_OK but doesn't 
            // really deletes the semaphore because of the still pending 
            // semaphore access. In such a case the semaphore is only booked 
            // for deletion and the semaphore is deleted later on with the 
            // execution of the final OSAL_s32SemaphoreClose() operation from 
            // one of the other AIL using processes.

            ail_vTraceMsg(TR_LEVEL_SYSTEM_MIN, "ail_vExitAilTrace() : Deleted OR booked semaphore %s for deletion at final close from process %d", coszAilTraceSemName, s32ProcessId);
          }
          else
          {
            NORMAL_M_ASSERT_ALWAYS();
          }

          bAilTraceSemphoreCreated = FALSE;
        }
      }
      else
      {
        NORMAL_M_ASSERT_ALWAYS();
      }
    }

    if (rAilTraceIODescriptor != OSAL_ERROR)
    {
      OSAL_s32IOClose(rAilTraceIODescriptor); //lint !e522: Expected void type, assignment, increment or decrement
      rAilTraceIODescriptor = OSAL_ERROR; // set trace device handle to initial state after close of device
    }
  }
}


/*******************************************************************************
 *FUNCTION:    ail_vTraceMsg
 *DESCRIPTION: Trace Message to OSAL-Trace-Device
 *PARAMETER:   TR_tenTraceLevel  enTraceLevel ( I )
 *                trace level according to trace concept
 *             const tChar       *coszFormatString ( ->I )         
 *                buffer to prepare character output string,
 *                must be located on callers user stack
 *             ...
 *                
 *RETURNVALUE: tVoid
 *
 *HISTORY:
 *26.02.2003 Initial Version  
 ******************************************************************************/
tVoid ail_vTraceMsg( TR_tenTraceLevel enTraceLevel, const tChar *coszFormatString, ... )
{
   if ( OSAL_ERROR != rAilTraceIODescriptor )
   {
      if ( ail_bIsTraceActive( enTraceLevel ) )
      {
         // create formated string
         tChar* pcBuffer = OSAL_NEW tChar[AIL_C_U16_MAX_TRACE_BUF + 1];

         if ( pcBuffer != OSAL_NULL )
         {
            pcBuffer[0] = AIL_C_U8_TRACE_TYPE_STRING;
            tChar* pcStringBuffer = &pcBuffer[1];

            OSAL_tVarArgList ArgList; 
            OSAL_VarArgStart(ArgList, coszFormatString); //lint !e530
            OSAL_s32VarNPrintFormat(pcStringBuffer, AIL_C_U16_MAX_TRACE_BUF, coszFormatString, ArgList); //lint !e530
            OSAL_VarArgEnd(ArgList);
            tU32 u32NumOfBytes = (tU32)OSAL_u32StringLength(pcStringBuffer);

            // trace string
            OSALUTIL_s32TraceWrite
            (
               rAilTraceIODescriptor,
               (tU32)enTraceLevel,
               (tU32)TR_CLASS_AIL,
               (tPCS8)pcBuffer,
               u32NumOfBytes + 1
            ); //lint !e522: Expected void type, assignment, increment or decrement

            if (enTraceLevel == TR_LEVEL_FATAL)
            {
               err_tclErrMem oErrMem;
               oErrMem.s32WriteErrorString(eErrmemEntryInfo, 
                                           (tU16)TR_CLASS_AIL & (tU16)0xFF00 /*u16TraceComp*/, 
                                           AIL_C_U8_ERR_REQUEST_ERROR_END /*u8SpecificErrorCode*/, 
                                           pcStringBuffer);

            }

            OSAL_DELETE [] pcBuffer; // any problem in heap defragmentation visible?
            pcBuffer = OSAL_NULL;
         }
      }
   }
}

/*******************************************************************************
 *FUNCTION:    ail_vTraceMsg
 *DESCRIPTION: Trace Message to OSAL-Trace-Device
 *PARAMETER:   TR_tenTraceClass  enTraceClass ( I )
 *                trace class according to trace concept
 *             TR_tenTraceLevel  enTraceLevel ( I )
 *                trace level according to trace concept
 *             const tChar       *coszFormatString ( ->I )
 *                buffer to prepare character output string,
 *                must be located on callers user stack
 *             ...
 *                
 *RETURNVALUE: tVoid
 *
 *HISTORY:
 *26.02.2003 Initial Version  
 ******************************************************************************/
tVoid ail_vTraceClassMsg( TR_tenTraceClass enTraceClass, TR_tenTraceLevel enTraceLevel, const tChar *coszFormatString, ... )
{
   if ( OSAL_ERROR != rAilTraceIODescriptor )
   {
      if ( ail_bIsTraceClassActive( enTraceClass, enTraceLevel ) )
      {
         // create formated string
         tChar* pcBuffer = OSAL_NEW tChar[AIL_C_U16_MAX_TRACE_BUF + 1];

         if ( pcBuffer != OSAL_NULL )
         {
            pcBuffer[0] = AIL_C_U8_TRACE_TYPE_STRING;
            tChar* pcStringBuffer = &pcBuffer[1];

            OSAL_tVarArgList ArgList; 
            OSAL_VarArgStart(ArgList, coszFormatString); //lint !e530
            OSAL_s32VarNPrintFormat(pcStringBuffer, AIL_C_U16_MAX_TRACE_BUF, coszFormatString, ArgList); //lint !e530
            OSAL_VarArgEnd(ArgList);
            tU32 u32NumOfBytes = (tU32)OSAL_u32StringLength(pcStringBuffer);

            // trace string
            OSALUTIL_s32TraceWrite
            (
               rAilTraceIODescriptor,
               (tU32)enTraceLevel,
               (tU32)enTraceClass,
               (tPCS8)pcBuffer,
               u32NumOfBytes + 1
            ); //lint !e522: Expected void type, assignment, increment or decrement
            OSAL_DELETE [] pcBuffer; // any problem in heap defragmentation visible?
            pcBuffer = OSAL_NULL;
         }
      }
   }
}

/*******************************************************************************
 *FUNCTION:    ail_vTraceHexMsg
 *DESCRIPTION: Trace Message to OSAL-Trace-Device
 *PARAMETER:   TR_tenTraceClass  enTraceClass   ( ->I )
 *                trace class according to trace concept
 *             TR_tenTraceLevel  enTraceLevel ( ->I )
 *                trace level according to trace concept
 *             tU32              u32DumpBufferSize ( I )         
 *                size of buffer to be converted to hex-ascii-msg
 *             tPCU8             pcu8DumpBuffer ( ->I )         
 *                pointer to buffer to be converted to hex-ascii-msg
 *             const tChar       *coszFormatString ( ->I )         
 *                buffer to prepare character output string,
 *                must be located on callers user stack
 *             ...
 *                
 *RETURNVALUE: tVoid
 *
 *HISTORY:
 *26.02.2003 Initial Version  
 ******************************************************************************/
tVoid ail_vTraceHexMsg( TR_tenTraceClass enTraceClass, TR_tenTraceLevel enTraceLevel, tBool bForceUnlimitedRequest, tU32 u32DumpBufferSize, tPCU8 pcu8DumpBuffer, const tChar *coszFormatString, ... )
{
   if ( OSAL_ERROR != rAilTraceIODescriptor )
   {
      if ( ail_bIsTraceClassActive( enTraceClass, enTraceLevel ) )
      {
         // create formated string
         tPChar acBuffer;
         tU32 u32BufferSize = (tU32)AIL_C_U16_MAX_TRACE_BUF;
         acBuffer = OSAL_NEW tChar[u32BufferSize + 1];
         if ( acBuffer != OSAL_NULL )
         {
            acBuffer[0] = AIL_C_U8_TRACE_TYPE_STRING;
            tChar* pcStringBuffer = &acBuffer[1];
            OSAL_tVarArgList ArgList; 
            OSAL_VarArgStart(ArgList, coszFormatString); //lint !e530
            OSAL_s32VarNPrintFormat(pcStringBuffer, u32BufferSize, coszFormatString, ArgList); //lint !e530
            OSAL_VarArgEnd(ArgList);
            tU32 u32NumOfBytes = (tU32)OSAL_u32StringLength(pcStringBuffer);

            // trace string
            OSALUTIL_s32TraceWrite
            (
               rAilTraceIODescriptor,
               (tU32)enTraceLevel,
               (tU32)enTraceClass,
               (tPCS8)acBuffer,
               u32NumOfBytes + 1
            ); //lint !e522: Expected void type, assignment, increment or decrement

            #ifndef AIL_S_HEXTRACE_UNLIMITED
            {
               if ( bForceUnlimitedRequest == FALSE )
               {
                  // limit hexdump, only trace first line (AIL_C_U32_DIGITS_PER_LINE bytes)
                  u32DumpBufferSize = u32DumpBufferSize > AIL_C_U32_DIGITS_PER_LINE ? AIL_C_U32_DIGITS_PER_LINE : u32DumpBufferSize;
               }
            }
            #endif //AIL_S_HEXTRACE_UNLIMITED

            // trace the message in packets of AIL_C_U32_DIGITS_PER_LINE bytes
            if ( pcu8DumpBuffer && ( u32DumpBufferSize > 0 ) )
            {
               tU32  u32NumberOfLines = ( ( u32DumpBufferSize - 1 ) / AIL_C_U32_DIGITS_PER_LINE ) + 1;
               tU32  u32FirstIndex = 0;
               tU32  u32LastIndex;
               tU32  u32NumberOfBytes;

               acBuffer[0] = AIL_C_U8_TRACE_TYPE_DATADUMP;

               for ( tU32 u32LineIndex = 0; u32LineIndex < u32NumberOfLines; u32LineIndex++ )
               {
                  if ( u32LineIndex < ( u32NumberOfLines - 1 ) )
                  {
                     u32NumberOfBytes = AIL_C_U32_DIGITS_PER_LINE;
                  }
                  else  // this is the last line
                  {
                     u32NumberOfBytes = u32DumpBufferSize % AIL_C_U32_DIGITS_PER_LINE;

                     // last line also contains AIL_C_U32_DIGITS_PER_LINE bytes?
                     if ( 0 == u32NumberOfBytes )
                     {
                        u32NumberOfBytes = AIL_C_U32_DIGITS_PER_LINE;
                     }
                  }
                  u32LastIndex = u32FirstIndex + u32NumberOfBytes - 1;

                  acBuffer[1] = (tChar)( (u32FirstIndex       ) & 0x000000FF );
                  acBuffer[2] = (tChar)( (u32FirstIndex >>  8 ) & 0x000000FF );
                  acBuffer[3] = (tChar)( (u32FirstIndex >> 16 ) & 0x000000FF );
                  acBuffer[4] = (tChar)( (u32FirstIndex >> 24 ) & 0x000000FF );

                  acBuffer[5] = (tChar)( (u32LastIndex       ) & 0x000000FF );
                  acBuffer[6] = (tChar)( (u32LastIndex >>  8 ) & 0x000000FF );
                  acBuffer[7] = (tChar)( (u32LastIndex >> 16 ) & 0x000000FF );
                  acBuffer[8] = (tChar)( (u32LastIndex >> 24 ) & 0x000000FF );

                  OSAL_pvMemoryCopy( &( acBuffer[9] ), &( pcu8DumpBuffer[u32FirstIndex] ), u32NumberOfBytes );

                  OSALUTIL_s32TraceWrite
                  (
                     rAilTraceIODescriptor,
                     (tU32)enTraceLevel,
                     (tU32)enTraceClass,
                     (tPCS8)acBuffer,
                     9 + u32NumberOfBytes
                  ); //lint !e522: Expected void type, assignment, increment or decrement

                  u32FirstIndex += AIL_C_U32_DIGITS_PER_LINE;
               }
            }

            OSAL_DELETE [] acBuffer;
            acBuffer = OSAL_NULL;
         } // else malloc-error
      } // end if trace-level < max-trace-level
   } // end if TraceIODescriptor!=OSAL_ERROR
}

/*******************************************************************************
*
* FUNCTION: ail_vTraceMessageDump()
*
* DESCRIPTION: Trace a CCA message by performing a memory dump of the passed 
*              CCA message buffer. The output is a byte-stream which follows 
*              the CCA protocol.
*
* PARAMETER: [IN] enTraceClass = Trace class to be used.
*            [IN] enTraceLevel = Trace level to be used.
*            [IN] pcu8MessageBuffer = Message buffer to dump.
*            [IN] u32MessageBufferSize = Size of the message buffer in bytes.
*            [IN] nMsgOffset = Offset of this message in the shared memory.
*            [IN] u8MsgDirection = Flag if CCA message is received or sent.
*
*                 Possibles values = - AIL_C_U8_TRACE_MSG_RECEIVED
*                                    - AIL_C_U8_TRACE_MSG_SENT
*
*            [IN] u32Prio = Priority of the message to be traced.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid ail_vTraceMessageDump(TR_tenTraceClass enTraceClass, 
                            TR_tenTraceLevel enTraceLevel, 
                            tPCU8            pcu8MessageBuffer,
                            tU32             u32MessageBufferSize,
                            uintptr_t        nMsgOffset,
                            tU8              u8MsgDirection,
                            tU32             u32Prio)
{
  if (pcu8MessageBuffer != OSAL_NULL)
  {
     tU8    u8NumPrefixBytes = 14;
     tChar* pcTraceBuffer    = OSAL_NEW tChar[u8NumPrefixBytes + u32MessageBufferSize];

     if (pcTraceBuffer != OSAL_NULL)
     {
       pcTraceBuffer[0] = AIL_C_U8_TRACE_TYPE_MESSAGEDUMP;
       pcTraceBuffer[1] = u8MsgDirection;

       pcTraceBuffer[2] = (tChar) (nMsgOffset & 0x000000FF);
       pcTraceBuffer[3] = (tChar)((nMsgOffset & 0x0000FF00) >> 8);
       pcTraceBuffer[4] = (tChar)((nMsgOffset & 0x00FF0000) >> 16);
       pcTraceBuffer[5] = (tChar)((nMsgOffset & 0xFF000000) >> 24);
       pcTraceBuffer[6] = 0;
       pcTraceBuffer[7] = 0;
       pcTraceBuffer[8] = 0;
       pcTraceBuffer[9] = 0;

       if (sizeof(nMsgOffset) > 4) {
          pcTraceBuffer[6] = (tChar)((nMsgOffset & 0x000000FF00000000) >> 32);
          pcTraceBuffer[7] = (tChar)((nMsgOffset & 0x0000FF0000000000) >> 40);
          pcTraceBuffer[8] = (tChar)((nMsgOffset & 0x00FF000000000000) >> 48);
          pcTraceBuffer[9] = (tChar)((nMsgOffset & 0xFF00000000000000) >> 56);
       }

       pcTraceBuffer[10] = (tChar) (u32Prio      & 0x000000FF);
       pcTraceBuffer[11] = (tChar)((u32Prio      & 0x0000FF00) >> 8);
       pcTraceBuffer[12] = (tChar)((u32Prio      & 0x00FF0000) >> 16);
       pcTraceBuffer[13] = (tChar)((u32Prio      & 0xFF000000) >> 24);

       OSAL_pvMemoryCopy((tChar*) &pcTraceBuffer[u8NumPrefixBytes], 
                         pcu8MessageBuffer, 
                         u32MessageBufferSize);

       OSALUTIL_s32TraceWrite
       (
          rAilTraceIODescriptor,
          (tU32)enTraceLevel,
          (tU32)enTraceClass,
          (tPCS8)pcTraceBuffer,
          (u8NumPrefixBytes + u32MessageBufferSize)
       ); //lint !e522: Expected void type, assignment, increment or decrement

       OSAL_DELETE[] pcTraceBuffer;

       pcTraceBuffer = OSAL_NULL;
     }
  }
}

/*******************************************************************************
*
* FUNCTION: ail_vTraceApplicationMessage()
*
* DESCRIPTION: Trace application related CCA messages.
*
* PARAMETER: [IN] enTraceClass = Trace class to be used.
*            [IN] enTraceLevel = Trace level to be used.
*            [IN] poMsgObject = Pointer to the CCA messages object.
*            [IN] u8MsgDirection = Flag if CCA message is received or sent.
*
*                 Possibles values = - AIL_C_U8_TRACE_MSG_RECEIVED
*                                    - AIL_C_U8_TRACE_MSG_SENT
*
*            [IN] u32Prio = Priority of the message to be traced.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid ail_vTraceApplicationMessage(TR_tenTraceClass    enTraceClass, 
                                   TR_tenTraceLevel    enTraceLevel, 
                                   amt_tclBaseMessage* poMsgObject,
                                   tU8                 u8MsgDirection,
                                   tU32                u32Prio)
{
  if (OSAL_ERROR != rAilTraceIODescriptor)
  {
    if (OSAL_s32SemaphoreWait(hSemAilTrace, OSAL_C_U32_INFINITE) == OSAL_OK)
    {
      if (ail_bIsTraceClassActive(enTraceClass, enTraceLevel))
      {
        if (poMsgObject != NULL)
        {
          tU32      u32MessageBufferSize = poMsgObject->u32GetSize();
          tPCU8     pcu8MessageBuffer    = poMsgObject->pu8GetSharedMemBase();
          uintptr_t nMsgOffset           = 0;

          if (poMsgObject->prGetOSALMsgHandle() != NULL)
          {
            nMsgOffset = poMsgObject->prGetOSALMsgHandle()->u32Offset; // u32Offset is of type uintptr_t although the prefix u32 tells something different
          }

          ail_vTraceMessageDump(enTraceClass, 
                                enTraceLevel, 
                                pcu8MessageBuffer,
                                u32MessageBufferSize,
                                nMsgOffset,
                                u8MsgDirection,
                                u32Prio);
        }
        else
        {
          ail_vTraceMsg(TR_LEVEL_FATAL, "ail_vTraceApplicationMessage() : Passed invalid parameter amt_tclBaseMessage = NULL.");
        }
      } 

      if (OSAL_s32SemaphorePost(hSemAilTrace) == OSAL_ERROR)
      {
        NORMAL_M_ASSERT_ALWAYS();
      }
    }
    else
    {
      NORMAL_M_ASSERT_ALWAYS();
    }
  }
}

/*******************************************************************************
*
* FUNCTION: ail_vTraceServiceMessage()
*
* DESCRIPTION: Trace service related CCA messages.
*
* PARAMETER: [IN] enTraceClass = Trace class to be used.
*            [IN] enTraceLevel = Trace level to be used.
*            [IN] poMsgObject = Pointer to the CCA messages object.
*            [IN] u8MsgDirection = Flag if CCA message is received or sent.
*
*                 Possibles values = - AIL_C_U8_TRACE_MSG_RECEIVED
*                                    - AIL_C_U8_TRACE_MSG_SENT
*
*            [IN] u32Prio = Priority of the message to be traced.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid ail_vTraceServiceMessage(TR_tenTraceClass    enTraceClass, 
                               TR_tenTraceLevel    enTraceLevel, 
                               amt_tclBaseMessage* poMsgObject,
                               tU8                 u8MsgDirection,
                               tU32                u32Prio)
{
   if ( OSAL_ERROR != rAilTraceIODescriptor )
   {
      if (OSAL_s32SemaphoreWait(hSemAilTrace, OSAL_C_U32_INFINITE) == OSAL_OK)
      {
         if ( ail_bIsTraceClassActive( enTraceClass, enTraceLevel ) )
         {
            TR_tenTraceLevel  enLengthLimiter;
            tBool             bBreakSearch = FALSE;
            tU32              u32PureHexdumpCharlimit = AIL_C_U32_CHARLIMIT_MSGHEADER;
            tU32              u32TempLengthLimit = AIL_C_U32_CHARLIMIT_MSGFULL;
            tU32              u32PayloadBufferSize = 0;
            tPCU8             pcu8PaylodDumpBuffer = 0;
            
            if (poMsgObject != NULL)
            {
               tU32      u32MessageBufferSize = poMsgObject->u32GetSize();
               tPCU8     pcu8MessageBuffer    = poMsgObject->pu8GetSharedMemBase();
               uintptr_t nMsgOffset           = 0;

               if (poMsgObject->prGetOSALMsgHandle() != NULL)
               {
                 nMsgOffset = poMsgObject->prGetOSALMsgHandle()->u32Offset; // u32Offset is of type uintptr_t although the prefix u32 tells something different
               }

               if (enTraceLevel != TR_LEVEL_ERRORS)
               {
                 // For message length limitation, the user set TraceLevel is 
                 // used in all TraceSubClasses of TR_CLASS_SRVREC_AIL for message
                 // length limitation.

                 for ( tU8 i = 1; i < 5 && bBreakSearch == FALSE; i++ )
                 {
                    if ( i == 1 )
                    {
                       enLengthLimiter = TR_LEVEL_USER_1;
                       u32PureHexdumpCharlimit = AIL_C_U32_CHARLIMIT_MSGHEADER;
                    }
                    else if ( i == 2 )
                    {
                       enLengthLimiter = TR_LEVEL_USER_2;
                       u32PureHexdumpCharlimit = AIL_C_U32_CHARLIMIT_PAYLOAD32;
                    }
                    else if ( i == 3 )
                    {
                       enLengthLimiter = TR_LEVEL_USER_3;
                       u32PureHexdumpCharlimit = AIL_C_U32_CHARLIMIT_PAYLOAD64;
                    }
                    else
                    {
                       enLengthLimiter = TR_LEVEL_USER_4;
                       u32PureHexdumpCharlimit = AIL_C_U32_CHARLIMIT_MSGFULL;
                    }

                    if ( ail_bIsTraceClassActive( enTraceClass, enLengthLimiter ) == TRUE )
                    {
                       /* set the extern activated TraceLevel as intern used */
                       enTraceLevel = enLengthLimiter;

                       if ( u32MessageBufferSize > u32PureHexdumpCharlimit )
                       /* set temporary limitation */
                       {
                          u32TempLengthLimit = u32PureHexdumpCharlimit;
                       }
                       else
                       /* reset limitation to default */
                       {
                          u32TempLengthLimit = AIL_C_U32_CHARLIMIT_MSGFULL;
                       }
                    }
                    else
                    {
                       bBreakSearch = TRUE;
                    }
                 }
               }
               else
               {
                 if (u32MessageBufferSize > AIL_C_U32_CHARLIMIT_PAYLOAD32)
                 /* set temporary limitation */
                 {
                   u32TempLengthLimit = AIL_C_U32_CHARLIMIT_PAYLOAD32;
                 }
                 else
                 /* reset limitation to default */
                 {
                   u32TempLengthLimit = AIL_C_U32_CHARLIMIT_MSGFULL;
                 }
               }

               if ( enTraceLevel == TR_LEVEL_USER_4 )
               /* on TR_LEVEL_USER_4 always trace payload data in own string printouts */
               {
                  /* the printout of a string can only be separated from TRC-trace by manipulation of the TraceLevel */
                  enTraceLevel = TR_LEVEL_COMPONENT;
            
                  if ( u32MessageBufferSize > AIL_C_U32_CHARLIMIT_MSGHEADER )
                  {
                     u32PayloadBufferSize = u32MessageBufferSize - AIL_C_U32_CHARLIMIT_MSGHEADER;
                     u32MessageBufferSize = AIL_C_U32_CHARLIMIT_MSGHEADER;

                     if ( u32PayloadBufferSize != 0)
                     {
                        pcu8PaylodDumpBuffer = (tPCU8)(pcu8MessageBuffer + AIL_C_U32_CHARLIMIT_MSGHEADER);
                     }
                  }
               }
               else
               /* in other levels trace playload only as pure date in one HEX-line */
               {
                  if ( u32TempLengthLimit != AIL_C_U32_CHARLIMIT_MSGFULL )
                  /* limit the pure hexdump */
                  {
                     if (u32MessageBufferSize > u32TempLengthLimit)
                     {
                        u32MessageBufferSize = u32TempLengthLimit;
                     }
                  }
                  // else: keep u32MessageBufferSize as it is */
               }

               ail_vTraceMessageDump(enTraceClass, 
                                     enTraceLevel, 
                                     pcu8MessageBuffer,
                                     u32MessageBufferSize,
                                     nMsgOffset,
                                     u8MsgDirection,
                                     u32Prio);

               if ( pcu8PaylodDumpBuffer != 0 )
               /* it can't be guaranteed that there is not interrupt in printorder of payload */ 
               {
                  ail_vTraceHexMsg
                     (
                        enTraceClass,
                        TR_LEVEL_USER_4,
                        TRUE,
                        u32PayloadBufferSize,
                        pcu8PaylodDumpBuffer,
                        "Printing Payload:"
                     );
               }
            }
            else
            {
              ail_vTraceMsg(TR_LEVEL_FATAL, "ail_vTraceServiceMessage() : Passed invalid parameter amt_tclBaseMessage = NULL.");
            }
         } 

         if (OSAL_s32SemaphorePost(hSemAilTrace) == OSAL_ERROR)
         {
           NORMAL_M_ASSERT_ALWAYS();
         }
      }
      else
      {
        NORMAL_M_ASSERT_ALWAYS();
      }
   }
}

/*******************************************************************************
*
* FUNCTION: ail_bIsCcaRecorderTraceClassActive()
*
* DESCRIPTION: Determines if and which trace class for a CCA application or
*              service is active with a defined trace level.
*
* PARAMETER: [IN]  arAppOrSrvToTraceClassRef[] = Array with either CCA 
*                                                applications or services 
*                                                and their respective trace 
*                                                class.
*            [IN]  u16NumberOfElements = Number of elements of the passed array.
*            [OUT] rf_enTraceClass = Reference to the trace class to be 
*                                    determined.
*            [IN]  enTraceLevel = Trace level to check.
*            [IN]  u16AppOrSrvId = CCA application or service ID to be used for 
*                                  the check of the active trace class.
*
* RETURNVALUE: TRUE  = Trace class for this CCA application or service was 
*                      found and is active.
*              FALSE = No trace class for this CCA application or service 
*                      found or the respective trace is not active.
*
*******************************************************************************/
tBool ail_bIsCcaRecorderTraceClassActive(const rAppOrSrvToTraceClassRef carAppOrSrvToTraceClassRef[],
                                         tU16 u16NumberOfElements,
                                         TR_tenTraceClass& rf_enTraceClass, 
                                         TR_tenTraceLevel enTraceLevel, 
                                         tU16 u16AppOrSrvId)
{
   tBool bRet = FALSE;

   if ( OSAL_ERROR != rAilTraceIODescriptor )
   {
      tU16 u16Start = 0;
      tU16 u16End = (tU16)(u16NumberOfElements - 1U);
      tU16 u16Mid = (tU16)((u16NumberOfElements - 1U) / 2U);
      tU16 u16RefAppOrSrvId = 0;
      tBool bFound = FALSE;         
      
      for ( ; bFound == FALSE; )
      {
         u16RefAppOrSrvId = carAppOrSrvToTraceClassRef[u16Mid].u16AppOrSrvId;
         
         if ( u16AppOrSrvId == u16RefAppOrSrvId )
         {
            bFound = TRUE;
            break;
         }
         else if ( u16Start == u16End )
         /* no element matches  */
         {
            break;
         }

         if ( u16AppOrSrvId > u16RefAppOrSrvId  )
         {
            u16Start = u16Mid;
            u16Mid = (tU16)(u16Start + ( (u16End-u16Start) / 2U ));

            if ( u16Mid == u16Start )
            /* in case of last element is searched */
            {
               u16Mid = u16End;
               u16Start = u16End;
            }
         }
         else /* u16AppOrSrvId < u16RefAppOrSrvId */
         {
            u16End = u16Mid;
            u16Mid = (tU16)(u16Start + ( (u16End-u16Start) / 2U ));
            
            if ( u16Mid == u16Start )
            /* in case of first element is searched */
            {
               u16End = u16Start;
            }
         }
      }
      
      if ( bFound == TRUE )
      {
         OSAL_trIOCtrlActivTrace rActive;

         rActive.enTraceClass = (TR_tenTraceClass)carAppOrSrvToTraceClassRef[u16Mid].u16TraceClass;
         rActive.enTraceLevel = (TR_tenTraceLevel)enTraceLevel;
         rActive.bIsActive = FALSE;


        if (OSAL_OK == OSAL_s32IOControl(rAilTraceIODescriptor,
                                          OSAL_C_S32_IOCTRL_ISACTIVE,
                                          (intptr_t)&rActive))
         {
            bRet = rActive.bIsActive;
            rf_enTraceClass = rActive.enTraceClass;
         }
      }         

   }
   return bRet;
}

/*******************************************************************************
 *FUNCTION:    ail_bIsTraceActive
 *DESCRIPTION: checks, if TR_CLASS_AIL is active for trace output
 *PARAMETER:   TR_tenTraceLevel enTraceLevel   ( ->I )
 *                trace level according to trace concept
 *                
 *RETURNVALUE: tBool 
 *
 *HISTORY:
 *26.02.2003 Initial Version  
 ******************************************************************************/
tBool ail_bIsTraceActive( TR_tenTraceLevel enTraceLevel )
{
   return ( ail_bIsTraceClassActive( TR_CLASS_AIL, enTraceLevel ) );
}

/*******************************************************************************
 *FUNCTION:    ail_bIsTraceClassActive
 *DESCRIPTION: checks, if hand over trace class and trace level is active for trace output
 *PARAMETER:   TR_tenTraceClass  enTraceClass   ( ->I )
 *                trace class according to trace concept
 *             TR_tenTraceLevel enTraceLevel   ( ->I )
 *                trace level according to trace concept
 *                
 *RETURNVALUE: tBool 
 *
 *HISTORY:
 *26.02.2003 Initial Version  
 ******************************************************************************/
tBool ail_bIsTraceClassActive( TR_tenTraceClass enTraceClass, TR_tenTraceLevel enTraceLevel )
{
   tBool bReturnValue = FALSE;
   tS32 s32Error = OSAL_ERROR;
   OSAL_trIOCtrlActivTrace rIOCtrlActivTrace;

   rIOCtrlActivTrace.enTraceClass = enTraceClass;
   rIOCtrlActivTrace.enTraceLevel = enTraceLevel;
   rIOCtrlActivTrace.bIsActive = FALSE;

   if ( OSAL_ERROR != rAilTraceIODescriptor )
   {
      s32Error = OSAL_s32IOControl( rAilTraceIODescriptor, OSAL_C_S32_IOCTRL_ISACTIVE, (intptr_t)&rIOCtrlActivTrace );
      if (  (OSAL_OK == s32Error)
         && (TRUE == rIOCtrlActivTrace.bIsActive) )
      {
         bReturnValue = TRUE;
      }
   }

   return (bReturnValue);
}

/*******************************************************************************
 *FUNCTION:    ail_TTFis_Callback
 *DESCRIPTION: traceout cca message data
 *PARAMETER:   
 *                
 *RETURNVALUE: tVoid
 *
 *HISTORY:
 *02.11.2007 Initial Version  
 ******************************************************************************/

tVoid ail_TTFis_Callback(tU8 const * pu8Data)
{
    ail_vTraceMsg(TR_LEVEL_SYSTEM_MIN, "AIL TTFis-callback received command with size = %d", pu8Data[0]);
    
    switch (pu8Data[1])
    {
      #ifdef AIL_MESSAGE_COUNTER_ENABLED
        case 0: ail_Trace_CCA_Blocks();break;
        case 1: ail_Clear_CCA_Blocks();break;
        case 2: ail_Trace_CCA_Blocks();ail_Clear_CCA_Blocks();break;
        case 3: 
        {
             tU16 u16Filter = (pu8Data[2]<<8) | pu8Data[3];
             ail_Set_CCA_Counter_Send_Filter(u16Filter);
             break;
        }
        case 4: 
        {
             tU16 u16Filter = (pu8Data[2]<<8) | pu8Data[3];
             ail_Set_CCA_Counter_Receive_Filter(u16Filter);
             break;
        }
      #endif

      #ifdef AIL_DEBUG_APPLICATION
        case 5:
        {
           tU16 u16App = (tU16)((pu8Data[2] << 8) | pu8Data[3]);

           amt_tclDebugAppInfo oDebugApplicationMessage(u16App, 
                                                        u16App, 
                                                        AMT_C_U8_CCAMSG_DEBUG_APPLICATION_GET_APP_INFO, 
                                                        NULL, 
                                                        0);

           OSAL_tMQueueHandle hMQ = scd_OpenQueue(u16App);                  
           ail_bIpcMessagePost(u16App, hMQ, &oDebugApplicationMessage, AIL_C_U32_CCA_PRIO_MSG_DEBUG_APPLICATION);
           scd_s32CloseQueue(hMQ);
           break;
        }

        case 6:
        {
           tU16 u16App = (tU16)((pu8Data[2] << 8) | pu8Data[3]);
           tU8  u8PayloadSize = (tU8)(pu8Data[0] - 3U); // [1]=cmd, [2]=app, [3]=app => - 3

           if ((u8PayloadSize > 0 ) && (u8PayloadSize <= AMT_C_U32_DEBUG_APPLICATION_DATA_SIZE))
           {
             amt_tclDebugAppInfo oDebugApplicationMessage(u16App, 
                                                          u16App, 
                                                          AMT_C_U8_CCAMSG_DEBUG_APPLICATION_TRIGGER_USER_ACTION, 
                                                          &pu8Data[4], 
                                                          u8PayloadSize);

             OSAL_tMQueueHandle hMQ = scd_OpenQueue(u16App);                  
             ail_bIpcMessagePost(u16App, hMQ, &oDebugApplicationMessage, AIL_C_U32_CCA_PRIO_MSG_DEBUG_APPLICATION);
             scd_s32CloseQueue(hMQ);
           }
           else
           {
             ail_vTraceMsg(TR_LEVEL_FATAL, "ail_TTFis_Callback() => Received message CCA_TRIGGER_USER_ACTION with %d parameters but only 1-%d are allowed.", u8PayloadSize, AMT_C_U32_DEBUG_APPLICATION_DATA_SIZE);
           }

           break;
        }

      case 7:
        {
             tU16 u16App = (tU8)((pu8Data[2] << 8) | pu8Data[3]);
             tU16 u16PwrData1 = (tU8)((pu8Data[4] << 8) | pu8Data[5]);
             tU32 u32Result;

             amt_tclPowerMessage oPowerMessage (u16App, CCA_C_U16_APP_SPM, AMT_C_U16_PWR_USER_TRIGGER, u16PwrData1, 0);

             OSAL_tMQueueHandle hMQ = scd_OpenQueue(CCA_C_U16_APP_SPM);                  
             u32Result = ail_bIpcMessagePost(u16App, hMQ, &oPowerMessage, AIL_C_U32_CCA_PRIO_MSG_POWER);
             scd_s32CloseQueue(hMQ);

             ail_vTraceMsg(TR_LEVEL_FATAL, "ail_TTFis_Callback(): send Power message user trigger to SPM for App %d, Value %d, send result = %d ", u16App, u16PwrData1, u32Result);

           break;
        }
      #endif

        default:
        break;
    }
}

/*******************************************************************************
*
* FUNCTION: ail_vTraceCcaMessage()
*
* DESCRIPTION: Trace CCA related messages.
*
* PARAMETER: [IN] poMessage = Pointer to the CCA message data buffer.
*            [IN] u8Direction = Flag if CCA message is received or sent.
*
*                 Possibles values = - AIL_C_U8_TRACE_MSG_RECEIVED
*                                    - AIL_C_U8_TRACE_MSG_SENT
*
*            [IN] u32Prio = Priority of the message to be traced.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid ail_vTraceCcaMessage(amt_tclBaseMessage* poMessage, tU8 u8Direction, tU32 u32Prio)
{
  if ((NULL != poMessage)                              &&
      ((AIL_C_U8_TRACE_MSG_RECEIVED == u8Direction) || 
       (AIL_C_U8_TRACE_MSG_SENT == u8Direction)       )  )
  {
    tBool bDoTrace                = FALSE;
    tU8   u8Type                  = poMessage->u8GetType();
    TR_tenTraceClass enTraceClass = (TR_tenTraceClass)TR_COMP_SRVREC;
    TR_tenTraceLevel enTraceLevel = TR_LEVEL_USER_1;

    /* to cast all messages as ServicesMsgs is a dirty trick to get the ServiceID,
       but the ServiceID is for all messages at the same position ( byte 20 / 21 ) */
    if ((u8Type == AMT_C_U8_CCAMSGTYPE_SVCREGISTER)               ||
        (u8Type == AMT_C_U8_CCAMSGTYPE_SVCUNREGISTER)             ||
        (u8Type == AMT_C_U8_CCAMSGTYPE_SVCREGCONF)                ||
        (u8Type == AMT_C_U8_CCAMSGTYPE_SVSSTATUS)                 ||
        (u8Type == AMT_C_U8_CCAMSGTYPE_SVCDATA)                   ||
        (u8Type == AMT_C_U8_CCAMSGTYPE_SUPPLIER_STATE)            ||
        (u8Type == AMT_C_U8_CCAMSGTYPE_SUPPLIER_STATE_REGISTER)   ||
        (u8Type == AMT_C_U8_CCAMSGTYPE_SUPPLIER_STATE_UNREGISTER)   )
    {
      amt_tclServiceData oServiceData(poMessage);
      tU16               u16ServiceId = oServiceData.u16GetServiceID();

      if (ail_bIsTraceClassActive((TR_tenTraceClass)TR_COMP_SRVREC, TR_LEVEL_COMPONENT) == TRUE)
      {
        if (ail_bIsCcaRecorderTraceClassActive(carSrvToTraceClassRef,
                                               ELEMENTS(carSrvToTraceClassRef),
                                               enTraceClass, 
                                               enTraceLevel, 
                                               u16ServiceId) == TRUE)
        {
          bDoTrace = TRUE;
        }
      }
      else if (ail_bIsTraceClassActive((TR_tenTraceClass)TR_COMP_SRVREC, TR_LEVEL_ERRORS) == TRUE)
      {
        if (u8Type == AMT_C_U8_CCAMSGTYPE_SVCDATA)
        {
           tU8 u8OpCode = oServiceData.u8GetOpCode();
           if (u8OpCode == AMT_C_U8_CCAMSG_OPCODE_ERROR)
           {
              enTraceLevel = TR_LEVEL_ERRORS;

              bDoTrace = TRUE;
           }
        }
      }

      if (TRUE == bDoTrace)
      {
        ail_vTraceServiceMessage(enTraceClass, 
                                 enTraceLevel, 
                                 poMessage, 
                                 u8Direction,
                                 u32Prio);
      }
    }
    else if ((u8Type == AMT_C_U8_CCAMSGTYPE_POWER)                       ||
             (u8Type == AMT_C_U8_CCAMSGTYPE_APPLICATION_INFO)            ||
             (u8Type == AMT_C_U8_CCAMSGTYPE_APPLICATION_INFO_REGISTER)   ||
             (u8Type == AMT_C_U8_CCAMSGTYPE_APPLICATION_INFO_UNREGISTER)   )
    {
      if (ail_bIsTraceClassActive((TR_tenTraceClass)TR_COMP_APPREC, TR_LEVEL_COMPONENT) == TRUE)
      {
        tU16 u16ApplicationId = AMT_C_U16_APPID_INVALID;

        if (AIL_C_U8_TRACE_MSG_RECEIVED == u8Direction)
        {
          u16ApplicationId = poMessage->u16GetTargetAppID();
        }
        else // AIL_C_U8_TRACE_MSG_SENT == u8Direction
        {
          u16ApplicationId = poMessage->u16GetSourceAppID();
        }

        if (ail_bIsCcaRecorderTraceClassActive(carAppToTraceClassRef,
                                               ELEMENTS(carAppToTraceClassRef),
                                               enTraceClass, 
                                               enTraceLevel, 
                                               u16ApplicationId) == TRUE)
        {
          ail_vTraceApplicationMessage(enTraceClass, 
                                       enTraceLevel, 
                                       poMessage, 
                                       u8Direction,
                                       u32Prio);
        }
      }
    }
  }
  else
  {
    NORMAL_M_ASSERT_ALWAYS();
  }
}

#ifdef AIL_MESSAGE_COUNTER_ENABLED
/*******************************************************************************
 *FUNCTION:   AddCCAInfo
 *DESCRIPTION:
 *   This function collects informations about messages
 *
 *PARAMETER:   
 *   const amt_tclBaseMessage& oMsgObject
 *    pointer to message data
 *
 *RETURNVALUE:
 *   tVoid
 *
 *HISTORY:
 * 07.11.2007 TMS-Jentsch
 * Initial
 *
 ******************************************************************************/
tVoid AddCCAInfo(const amt_tclBaseMessage& oMsgObject, tBool bSend)
{
   tU16 u16TargetAppId = oMsgObject.u16GetTargetAppID();
   tU16 u16SourceAppId = oMsgObject.u16GetSourceAppID(); 
   tU32 u32Size        = oMsgObject.u32GetSize();

   if (u16SourceAppId >= CCA_INFO_ARRAY_SIZE)
      u16SourceAppId = CCA_INFO_ARRAY_SIZE - 1;
   if (u16TargetAppId >= CCA_INFO_ARRAY_SIZE)
      u16TargetAppId = CCA_INFO_ARRAY_SIZE - 1;

   if (bSend)
   {
      if ((spCCA_Filter != NULL) && ((spCCA_Filter->nCCA_Info_Send_Filter == u16TargetAppId) || (spCCA_Filter->nCCA_Info_Send_Filter == AIL_MESSAGE_COUNTER_NO_FILTER)))
      {
         spCCA_Info_Array[u16SourceAppId].u32_SendedFromCounter++;
         spCCA_Info_Array[u16SourceAppId].u32_SendedFromSize += u32Size;
         spCCA_Info_Array[u16TargetAppId].u32_SendedToCounter++;
         spCCA_Info_Array[u16TargetAppId].u32_SendedToSize += u32Size;
      }
   }
   else
   {
      if ((spCCA_Filter != NULL) && ((spCCA_Filter->nCCA_Info_Receive_Filter == u16SourceAppId) || (spCCA_Filter->nCCA_Info_Receive_Filter == AIL_MESSAGE_COUNTER_NO_FILTER)))
      {
         spCCA_Info_Array[u16SourceAppId].u32_ReceivedFromCounter++;
         spCCA_Info_Array[u16SourceAppId].u32_ReceivedFromSize += u32Size;
         spCCA_Info_Array[u16TargetAppId].u32_ReceivedByCounter++;
         spCCA_Info_Array[u16TargetAppId].u32_ReceivedBySize += u32Size;
      }
   }
}

/*******************************************************************************
 *FUNCTION:   ail_Trace_CCA_Blocks
 *DESCRIPTION:
 *   This function trace out the informations about messages
 *
 *RETURNVALUE:
 *   tVoid
 *
 *HISTORY:
 * 07.11.2007 TMS-Jentsch
 * Initial
 *
 ******************************************************************************/
tVoid ail_Trace_CCA_Blocks(tVoid)
{
    tInt i;
    tU32 u32_SendCounter = 0;
    tU32 u32_ReceiveCounter = 0;
    tU32 u32_SendSize = 0;
    tU32 u32_ReceiveSize = 0;
    
    ail_vTraceMsg( TR_LEVEL_FATAL, "============== Send ==============================");

    for (i=0; i<CCA_INFO_ARRAY_SIZE; ++i)
    {
        if ((spCCA_Info_Array[i].u32_SendedFromCounter != 0) || (spCCA_Info_Array[i].u32_SendedToCounter != 0))
        {
            ail_vTraceMsg( TR_LEVEL_FATAL, "App_ID= 0x%4x, FromNum= %6i, ToNum= %6i, FromByte = %8i, ToByte = %8i", 
             i, spCCA_Info_Array[i].u32_SendedFromCounter, spCCA_Info_Array[i].u32_SendedToCounter,
             spCCA_Info_Array[i].u32_SendedFromSize, spCCA_Info_Array[i].u32_SendedToSize);
             u32_SendCounter += spCCA_Info_Array[i].u32_SendedFromCounter;
             u32_SendSize += spCCA_Info_Array[i].u32_SendedFromSize;
        }
    }
    ail_vTraceMsg( TR_LEVEL_FATAL, "==================================================");
    ail_vTraceMsg( TR_LEVEL_FATAL, "Overall Send %i Messages with %i Bytes content.", u32_SendCounter, u32_SendSize);
    ail_vTraceMsg( TR_LEVEL_FATAL, "  ");

    ail_vTraceMsg( TR_LEVEL_FATAL, "============== Receive ===========================");

    for (i=0; i<CCA_INFO_ARRAY_SIZE; ++i)
    {
        if ((spCCA_Info_Array[i].u32_ReceivedFromCounter != 0) || (spCCA_Info_Array[i].u32_ReceivedByCounter != 0))
        {
            ail_vTraceMsg( TR_LEVEL_FATAL, "App_ID= 0x%4x, FromNum= %6i, ByNum= %6i, FromB = %8i, ByB = %8i", 
             i, spCCA_Info_Array[i].u32_ReceivedFromCounter, spCCA_Info_Array[i].u32_ReceivedByCounter,
             spCCA_Info_Array[i].u32_ReceivedFromSize, spCCA_Info_Array[i].u32_ReceivedBySize);
             u32_ReceiveCounter += spCCA_Info_Array[i].u32_ReceivedFromCounter;
             u32_ReceiveSize += spCCA_Info_Array[i].u32_ReceivedFromSize;
        }
    }
    ail_vTraceMsg( TR_LEVEL_FATAL, "==================================================");
    ail_vTraceMsg( TR_LEVEL_FATAL, "Overall Receive %i Messages with %i Bytes content.", u32_ReceiveCounter, u32_ReceiveSize);
    ail_vTraceMsg( TR_LEVEL_FATAL, "  ");
}

/*******************************************************************************
 *FUNCTION:   ail_Clear_CCA_Blocks
 *DESCRIPTION:
 *   This function clears the collected informations about messages
 *
 *RETURNVALUE:
 *   tVoid
 *
 *HISTORY:
 * 07.11.2007 TMS-Jentsch
 * Initial
 *
 ******************************************************************************/
tVoid ail_Clear_CCA_Blocks(tVoid)
{
    tInt i;
    
    for (i=0; i<CCA_INFO_ARRAY_SIZE; ++i)
    {
        spCCA_Info_Array[i].u32_SendedFromCounter = 0;
        spCCA_Info_Array[i].u32_SendedToCounter = 0;
        spCCA_Info_Array[i].u32_SendedFromSize = 0;
        spCCA_Info_Array[i].u32_SendedToSize = 0;

        spCCA_Info_Array[i].u32_ReceivedFromCounter = 0;
        spCCA_Info_Array[i].u32_ReceivedByCounter = 0;
        spCCA_Info_Array[i].u32_ReceivedFromSize = 0;
        spCCA_Info_Array[i].u32_ReceivedBySize = 0;
    }

    ail_vTraceMsg( TR_LEVEL_ERRORS, "CCA Message Counter cleared");
}

tVoid ail_Set_CCA_Counter_Send_Filter(tU16 nFilter)
{
   if (spCCA_Filter != NULL) 
   {
     spCCA_Filter->nCCA_Info_Receive_Filter = nFilter;
   }
}

tVoid ail_Set_CCA_Counter_Receive_Filter(tU16 nFilter)
{
   if (spCCA_Filter != NULL) 
   {
      spCCA_Filter->nCCA_Info_Send_Filter = nFilter;
   }
}

#endif
