//## begin module%1.4%.codegen_version preserve=yes
//   Read the documentation to learn more about C++ code generator
//   versioning.
//## end module%1.4%.codegen_version

//## begin module%3EF2CC8A0345.cm preserve=no
//	  %X% %Q% %Z% %W%
//## end module%3EF2CC8A0345.cm

//## begin module%3EF2CC8A0345.cp preserve=no
//## end module%3EF2CC8A0345.cp

//## Module: ail_Watchdog%3EF2CC8A0345; Subprogram body
//## Subsystem: Ail%3A841A8D02DE
//## Source file: e:\vasco\components\Ail\ail_Watchdog.cpp

//## begin module%3EF2CC8A0345.additionalIncludes preserve=no
//## end module%3EF2CC8A0345.additionalIncludes

//## begin module%3EF2CC8A0345.includes preserve=yes
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define AIL_S_IMPORT_INTERFACE_GENERIC
#define AIL_S_IMPORT_INTERFACE_TRACE
#include "ail_if.h"
//## end module%3EF2CC8A0345.includes

//## begin module%3EF2CC8A0345.declarations preserve=no
//## end module%3EF2CC8A0345.declarations

//## begin module%3EF2CC8A0345.additionalDeclarations preserve=yes
//## end module%3EF2CC8A0345.additionalDeclarations


// Class ail_tclWatchdog 

ail_tclWatchdog::ail_tclWatchdog (ail_tclIAppAdapt *poAilObject, TR_tenTraceClass enUseTraceClass)
  //## begin ail_tclWatchdog::ail_tclWatchdog%3EF2C60500FC.hasinit preserve=no
      : hWdgID(OSAL_C_INVALID_HANDLE),
        enTraceClass(enUseTraceClass)
  //## end ail_tclWatchdog::ail_tclWatchdog%3EF2C60500FC.hasinit
  //## begin ail_tclWatchdog::ail_tclWatchdog%3EF2C60500FC.initialization preserve=yes
  , poAil(poAilObject)
  //## end ail_tclWatchdog::ail_tclWatchdog%3EF2C60500FC.initialization
{
  //## begin ail_tclWatchdog::ail_tclWatchdog%3EF2C60500FC.body preserve=yes
  //## end ail_tclWatchdog::ail_tclWatchdog%3EF2C60500FC.body
}


ail_tclWatchdog::~ail_tclWatchdog ()
{
  //## begin ail_tclWatchdog::~ail_tclWatchdog%3EF2C60C00DD.body preserve=yes
   poAil=OSAL_NULL;
  //## end ail_tclWatchdog::~ail_tclWatchdog%3EF2C60C00DD.body
}



//## Other Operations (implementation)
tBool ail_tclWatchdog::bCreate ()
{
  //## begin ail_tclWatchdog::bCreate%3EF2C6A100E2.body preserve=yes
   tBool bCreated = FALSE;

   // pointer to wdg-list or handle available
   if (  poAil != OSAL_NULL
      && hWdgID == OSAL_C_INVALID_HANDLE )
   {
      // create object and get pointer to wdg-list
      hWdgID = poAil->hCreateWdg(enTraceClass);

      if ( hWdgID != OSAL_C_INVALID_HANDLE )
         bCreated = TRUE;
   }

   return (bCreated);
  //## end ail_tclWatchdog::bCreate%3EF2C6A100E2.body
}

tBool ail_tclWatchdog::bDelete ()
{
  //## begin ail_tclWatchdog::bDelete%3EF2C6A803D0.body preserve=yes
   tBool bDeleted = FALSE;

   // if wdg-handle is available
   if (  poAil  != OSAL_NULL
      && hWdgID != OSAL_C_INVALID_HANDLE )
   {
      poAil->vDeleteWdg( hWdgID );
      hWdgID = OSAL_C_INVALID_HANDLE;
      bDeleted = TRUE;
   }

   return (bDeleted);
  //## end ail_tclWatchdog::bDelete%3EF2C6A803D0.body
}

tBool ail_tclWatchdog::bActivate (OSAL_tMSecond WdgInterval, OSAL_tMSecond MaxInterval)
{
  //## begin ail_tclWatchdog::bActivate%3EF2C6B10344.body preserve=yes
   tBool bActivated = FALSE;

   if (  poAil  != OSAL_NULL
      && hWdgID != OSAL_C_INVALID_HANDLE )
   {
      bActivated = poAil->bActivateWdg( hWdgID, WdgInterval, MaxInterval );
   }

   return (bActivated);
  //## end ail_tclWatchdog::bActivate%3EF2C6B10344.body
}

tVoid ail_tclWatchdog::vDeactivate ()
{
  //## begin ail_tclWatchdog::vDeactivate%3EF2C6D102D7.body preserve=yes
   if (  poAil  != OSAL_NULL
      && hWdgID != OSAL_C_INVALID_HANDLE )
   {
      poAil->bDeactivateWdg( hWdgID );
   }
  //## end ail_tclWatchdog::vDeactivate%3EF2C6D102D7.body
}

tVoid ail_tclWatchdog::vTriggerWdg ()
{
  //## begin ail_tclWatchdog::vTriggerWdg%3EF2C6DB0132.body preserve=yes
   if (  poAil  != OSAL_NULL
      && hWdgID != OSAL_C_INVALID_HANDLE )
   {
      poAil->vTriggerWdgServer( hWdgID );
   }
  //## end ail_tclWatchdog::vTriggerWdg%3EF2C6DB0132.body
}

// Class ail_tclWatchdogServer 

ail_tclWatchdogServer::ail_tclWatchdogServer ()
  //## begin ail_tclWatchdogServer::ail_tclWatchdogServer%3EF2D09B01D0.hasinit preserve=no
  //## end ail_tclWatchdogServer::ail_tclWatchdogServer%3EF2D09B01D0.hasinit
  //## begin ail_tclWatchdogServer::ail_tclWatchdogServer%3EF2D09B01D0.initialization preserve=yes
  : poWatchdogList(OSAL_NULL)
  , hWdgTimer(OSAL_C_INVALID_HANDLE)
  , hNextTrigger(OSAL_C_INVALID_HANDLE)
  , enWdgState(AIL_EN_WDG_UNINITIALIZED)
  , NextTriggerTime(0)
  //## end ail_tclWatchdogServer::ail_tclWatchdogServer%3EF2D09B01D0.initialization
{
  //## begin ail_tclWatchdogServer::ail_tclWatchdogServer%3EF2D09B01D0.body preserve=yes
  //## end ail_tclWatchdogServer::ail_tclWatchdogServer%3EF2D09B01D0.body
}


ail_tclWatchdogServer::~ail_tclWatchdogServer ()
{
  //## begin ail_tclWatchdogServer::~ail_tclWatchdogServer%3EF2D0A30049.body preserve=yes
   
   // pointer member poWatchdogList deleted in vDeleteList
   vDeleteList(); //lint !e1551: Function may throw exception

   // satisfy lint
   poWatchdogList = OSAL_NULL;

  //## end ail_tclWatchdogServer::~ail_tclWatchdogServer%3EF2D0A30049.body
}



//## Other Operations (implementation)
tBool ail_tclWatchdogServer::bInit (OSAL_tpfCallback pfTimerEvent, tPVoid pvArg)
{
  //## begin ail_tclWatchdogServer::bInit%3EF2D0E802F5.body preserve=yes
   tBool bInitSuccess = FALSE;

   if ( enWdgState == AIL_EN_WDG_UNINITIALIZED )
   {
      // init watchdog-list
      poWatchdogList = OSAL_NEW ail_tclWatchdogList;
      if ( poWatchdogList != OSAL_NULL )
      {
         // init wdg-timer
         if (  pfTimerEvent != OSAL_NULL
            && OSAL_OK == OSAL_s32TimerCreate(pfTimerEvent, pvArg, &hWdgTimer) )
         {
            enWdgState = AIL_EN_WDG_INITIALIZED;
            bInitSuccess = TRUE;
         }
      }
   }

   return (bInitSuccess);
  //## end ail_tclWatchdogServer::bInit%3EF2D0E802F5.body
}

tVoid ail_tclWatchdogServer::vDeinit ()
{
  //## begin ail_tclWatchdogServer::vDeinit%3EF2D0F0011F.body preserve=yes
   if ( enWdgState == AIL_EN_WDG_INITIALIZED )
   {
      // stop and delete timer
      OSAL_s32TimerSetTime( hWdgTimer, 0, 0 ); //lint !e522: Expected void type, assignment, increment or decrement
      OSAL_s32TimerDelete( hWdgTimer ); //lint !e522: Expected void type, assignment, increment or decrement

      // delete watchdog-list
      vDeleteList();

      enWdgState = AIL_EN_WDG_UNINITIALIZED;
   }
  //## end ail_tclWatchdogServer::vDeinit%3EF2D0F0011F.body
}

ail_tWdgHandle ail_tclWatchdogServer::hCreateWdg (TR_tenTraceClass enTraceClass)
{
  //## begin ail_tclWatchdogServer::hCreateWdg%3EF2D0FB02F4.body preserve=yes
   ail_tWdgHandle hWdgHandle = OSAL_C_INVALID_HANDLE;

   if (  enWdgState == AIL_EN_WDG_INITIALIZED
      && poWatchdogList )
   {
      // new wdg-info-element
      ail_tclWatchdogInfo oWdgInfo;
      // add thread-id
      oWdgInfo.ThreadID = OSAL_ThreadWhoAmI();

      // check if this thread already exists in list
      ail_tclWatchdogIterator itWdg = FindObject( oWdgInfo.ThreadID );
      if ( itWdg.bIsDone() )
      {
         // create unique handle
         oWdgInfo.hWdgID = hGetUniqueID();

         if ( oWdgInfo.hWdgID != OSAL_C_INVALID_HANDLE )
         {
            oWdgInfo.enTraceClass = enTraceClass;

            ail_vTraceClassMsg( enTraceClass, TR_LEVEL_USER_1,
               "wdg %d (Thread %d) created",
               oWdgInfo.hWdgID,
               oWdgInfo.ThreadID );

            // return handle to this object
            hWdgHandle = oWdgInfo.hWdgID;
            // add wdg-info to list
            poWatchdogList->vAdd(oWdgInfo);
         }
      } // else thread already exists in wdg-list
   }

   return (hWdgHandle);
  //## end ail_tclWatchdogServer::hCreateWdg%3EF2D0FB02F4.body
}

tVoid ail_tclWatchdogServer::vDeleteWdg (ail_tWdgHandle hWdgHandle)
{
  //## begin ail_tclWatchdogServer::vDeleteWdg%3EF2D108011E.body preserve=yes
   if (  enWdgState == AIL_EN_WDG_INITIALIZED
      && poWatchdogList )
   {
      // find handle in list
      ail_tclWatchdogIterator itWdg = FindObject( hWdgHandle );

      if ( !itWdg.bIsDone() )
      {
         // is timer running for this wdg-object?
         ail_tclWatchdogInfo &oWdgInfo = itWdg.oItem();
         if ( hNextTrigger == oWdgInfo.hWdgID )
         {
            // stop timer, search for next trigger-time, restart timer
            vRestartTimerForNextTrigger();
         } // else timer is not running for this object, we can delete entry from list

         ail_vTraceClassMsg( oWdgInfo.enTraceClass, TR_LEVEL_USER_1,
            "wdg %d (Thread %d) deleted",
            oWdgInfo.hWdgID,
            oWdgInfo.ThreadID );

         // delete entry from list
         poWatchdogList->nRemove(oWdgInfo);

      } // else no entry with this id exists
   }
  //## end ail_tclWatchdogServer::vDeleteWdg%3EF2D108011E.body
}

tBool ail_tclWatchdogServer::bActivateWdg (ail_tWdgHandle hWdgHandle, OSAL_tMSecond WdgInterval, OSAL_tMSecond MaxInterval)
{
  //## begin ail_tclWatchdogServer::bActivateWdg%3EF2D112017B.body preserve=yes
   tBool bActivated = FALSE;

   if ( enWdgState == AIL_EN_WDG_INITIALIZED )
   {
      // find handle in list
      ail_tclWatchdogIterator itWdg = FindObject( hWdgHandle );
      if ( !itWdg.bIsDone() )
      {
         ail_tclWatchdogInfo &oWdgInfo = itWdg.oItem();

         if (  (WdgInterval != 0) // invalid wdg-interval
            || (MaxInterval && (WdgInterval > MaxInterval) ) // max-interval less than wdg-interval
            || oWdgInfo.bActive ) // wdg already active
         {
            // set state active (even if we are in state active)
            oWdgInfo.bActive = TRUE;
            // set wdg-interval (or if we are in active set new wdg-interval)
            oWdgInfo.WdgInterval = WdgInterval;
            oWdgInfo.MaxInterval = MaxInterval;

            bActivated = TRUE;

            // set next trigger-time
            OSAL_tMSecond CurrentTime = OSAL_ClockGetElapsedTime();
            OSAL_tMSecond OurTriggerTime = CurrentTime + WdgInterval;
            oWdgInfo.NextTriggerTime = OurTriggerTime;
            oWdgInfo.LastTriggerTime = CurrentTime;
            oWdgInfo.MaxTriggerTime = MaxInterval?(CurrentTime+MaxInterval):0;

            ail_vTraceClassMsg( oWdgInfo.enTraceClass, TR_LEVEL_USER_3,
               "wdg %d (Thread %d) activated with interval %d, max-interval %d",
               oWdgInfo.hWdgID,
               oWdgInfo.ThreadID,
               WdgInterval,
               MaxInterval );

            // stop timer, search for next trigger-time, restart timer
            vRestartTimerForNextTrigger();
         } // else invalid parameter
      } // else wdg-handle not found in list
   }

   return (bActivated);
  //## end ail_tclWatchdogServer::bActivateWdg%3EF2D112017B.body
}

tBool ail_tclWatchdogServer::bDeactivateWdg (ail_tWdgHandle hWdgHandle)
{
  //## begin ail_tclWatchdogServer::bDeactivateWdg%3EF2D11B011D.body preserve=yes
   tBool bDeactivated = FALSE;

   if ( enWdgState == AIL_EN_WDG_INITIALIZED )
   {
      // find handle in list
      ail_tclWatchdogIterator itWdg = FindObject( hWdgHandle );
      if ( !itWdg.bIsDone() )
      {
         ail_tclWatchdogInfo &oWdgInfo = itWdg.oItem();

         // is wdg active?
         if ( oWdgInfo.bActive == TRUE )
         {
            // set wdg to inactive
            oWdgInfo.bActive = FALSE;

            bDeactivated = TRUE;

            ail_vTraceClassMsg( oWdgInfo.enTraceClass, TR_LEVEL_USER_3,
               "wdg %d (Thread %d) deactivated",
               oWdgInfo.hWdgID,
               oWdgInfo.ThreadID );

            // is wdg next trigger-event?
            if ( hNextTrigger == oWdgInfo.hWdgID )
            {
               // stop timer, search for next trigger-time, restart timer
               vRestartTimerForNextTrigger();
            } // else wdg is not next trigger-event, do nothin'

         } // else wdg not active, return error
      } // else wdg-handle not found in list
   }

   return (bDeactivated);
  //## end ail_tclWatchdogServer::bDeactivateWdg%3EF2D11B011D.body
}

tVoid ail_tclWatchdogServer::vTriggerWdg (ail_tWdgHandle hWdgHandle)
{
  //## begin ail_tclWatchdogServer::vTriggerWdg%3EF2D12301C8.body preserve=yes
   if ( enWdgState == AIL_EN_WDG_INITIALIZED )
   {
      OSAL_tMSecond CurrentTime = OSAL_ClockGetElapsedTime();

      // find handle in list
      ail_tclWatchdogIterator itWdg = FindObject( hWdgHandle );
      if ( !itWdg.bIsDone() )
      {
         ail_tclWatchdogInfo &oWdgInfo = itWdg.oItem();

         // is wdg active?
         if ( oWdgInfo.bActive == TRUE )
         {
            if ( oWdgInfo.WdgInterval != 0 )
            {
               // get elapsed time and trace
               OSAL_tMSecond TimeElapsed = CurrentTime-oWdgInfo.LastTriggerTime;
               tU32 u32TimeElapsedPerc = TimeElapsed*100/oWdgInfo.WdgInterval;
               tU32 u32MaxTimeElapsedPerc = 0;
               if ( oWdgInfo.MaxInterval != 0 )
                  u32MaxTimeElapsedPerc = (oWdgInfo.MaxInterval-(oWdgInfo.MaxTriggerTime-CurrentTime))*100/oWdgInfo.MaxInterval;

               TR_tenTraceLevel enTraceLevel = TR_LEVEL_USER_3;
               if (  u32TimeElapsedPerc > 90
                  || u32MaxTimeElapsedPerc > 90 )
                  enTraceLevel = TR_LEVEL_SYSTEM_MIN;
               else if (   u32TimeElapsedPerc > 50
                        || u32MaxTimeElapsedPerc > 50 )
                  enTraceLevel = TR_LEVEL_COMPONENT;
               // else trace-level user3

               ail_vTraceClassMsg( oWdgInfo.enTraceClass, enTraceLevel,
                  "wdg %d (Thread %d) triggered, %d/%d ms elapsed (%d,%d)",
                  oWdgInfo.hWdgID,
                  oWdgInfo.ThreadID,
                  TimeElapsed,
                  oWdgInfo.WdgInterval,
                  u32TimeElapsedPerc,
                  u32MaxTimeElapsedPerc );
            }

            // set next trigger-time
            OSAL_tMSecond OurTriggerTime = CurrentTime + oWdgInfo.WdgInterval;

            // if MaxInterval is set and max-trigger-time reached,
            //  set next-trigger-time to max-trigger-time
            if (  oWdgInfo.MaxInterval
               && (oWdgInfo.MaxTriggerTime - OurTriggerTime) > (tU32)OSAL_C_S32_MAX )  // means negative value
            {
               OurTriggerTime = oWdgInfo.MaxTriggerTime;
            }

            oWdgInfo.NextTriggerTime = OurTriggerTime;
            oWdgInfo.LastTriggerTime = CurrentTime;

            // is wdg next trigger-event?
            if ( hNextTrigger == oWdgInfo.hWdgID )
            {
               // stop timer, search for next trigger-time, restart timer
               vRestartTimerForNextTrigger();
            } // else wdg is not next trigger-event

         } // else wdg not active
      } // else wdg-handle not found in list
   }
  //## end ail_tclWatchdogServer::vTriggerWdg%3EF2D12301C8.body
}

ail_tWdgHandle ail_tclWatchdogServer::hTimerEvent ()
{
  //## begin ail_tclWatchdogServer::hTimerEvent%3EF2D12A01B8.body preserve=yes
   ail_tWdgHandle hFailedWatchdog = OSAL_C_INVALID_HANDLE;

   if ( enWdgState == AIL_EN_WDG_INITIALIZED )
   {
      // is trigger-event valid?
      if ( hNextTrigger != OSAL_C_INVALID_HANDLE )
      {
         // get wdg from list
         ail_tclWatchdogIterator itWdg = FindObject( hNextTrigger );
         if ( !itWdg.bIsDone() )
         {
            ail_tclWatchdogInfo &oWdgInfo = itWdg.oItem();

            // is wdg active?
            if ( oWdgInfo.bActive  )
            {
               // is trigger-time reached?
               OSAL_tMSecond CurrentTime = OSAL_ClockGetElapsedTime();
               OSAL_tMSecond DiffTriggerTime = oWdgInfo.NextTriggerTime - CurrentTime;
               if (  DiffTriggerTime > (tU32)OSAL_C_S32_MAX // means negative value
                  || DiffTriggerTime < 10 ) // now or in the next 10ms
               {
                  // trigger-time reached, shutdown system
                  hFailedWatchdog = oWdgInfo.hWdgID;

                  tBool bMaxIntervalReached = FALSE;
                  if (  oWdgInfo.MaxInterval
                     && oWdgInfo.MaxTriggerTime == oWdgInfo.NextTriggerTime )
                     bMaxIntervalReached = TRUE;

                  ail_vTraceClassMsg( oWdgInfo.enTraceClass, TR_LEVEL_ERRORS,
                     "timer-event %s for wdg %d (Thread %d, wdg-interval %d, max-interval %d)",
                     bMaxIntervalReached?"(max-interval reached)":"",
                     oWdgInfo.hWdgID,
                     oWdgInfo.ThreadID,
                     oWdgInfo.WdgInterval,
                     oWdgInfo.MaxInterval );

                  if ( bMaxIntervalReached )
                  {
                     // we reached max timeout, reset max-trigger-time
                     oWdgInfo.MaxTriggerTime = CurrentTime + oWdgInfo.MaxInterval;
                  }

                  oWdgInfo.NextTriggerTime = CurrentTime + oWdgInfo.WdgInterval;
                  oWdgInfo.LastTriggerTime = CurrentTime;
               } // else trigger-time not reached
            } // else wdg not active
         } // else wdg-handle not found in list

         // start new trigger-event
         vRestartTimerForNextTrigger();
      } // else trigger-event invalid
   }

   return (hFailedWatchdog);
  //## end ail_tclWatchdogServer::hTimerEvent%3EF2D12A01B8.body
}

tBool ail_tclWatchdogServer::bGetWatchdogInfo (ail_tWdgHandle hWdgHandle, OSAL_tThreadID &rfThreadID, OSAL_tMSecond &rfWdgInterval, OSAL_tMSecond &rfMaxInterval)
{
  //## begin ail_tclWatchdogServer::bGetWatchdogInfo%3EF7FE8A03DC.body preserve=yes
   tBool bFound = FALSE;

   if ( enWdgState == AIL_EN_WDG_INITIALIZED )
   {
      // find handle in list
      ail_tclWatchdogIterator itWdg = FindObject( hWdgHandle );
      if ( !itWdg.bIsDone() )
      {
         ail_tclWatchdogInfo &oWdgInfo = itWdg.oItem();

         rfThreadID = oWdgInfo.ThreadID;
         rfWdgInterval = oWdgInfo.WdgInterval;
         rfMaxInterval = oWdgInfo.MaxInterval;

         bFound = TRUE;
      } // else wdg-handle not found in list
   }

   return (bFound);
  //## end ail_tclWatchdogServer::bGetWatchdogInfo%3EF7FE8A03DC.body
}

ail_tclWatchdogIterator ail_tclWatchdogServer::FindObject (ail_tWdgHandle hWdgHandle)
{
  //## begin ail_tclWatchdogServer::FindObject%3EF2D3C802E9.body preserve=yes
   // iterator to get thru' list
   ail_tclWatchdogIterator itWdg(poWatchdogList);

   // while end of list not reached
   while ( !itWdg.bIsDone() )
   {
      // wdg-entry with given handle found?
      if ( itWdg.oItem().hWdgID == hWdgHandle )
         break;
      // get next entry
      itWdg.vNext();
   }

   return (itWdg);
  //## end ail_tclWatchdogServer::FindObject%3EF2D3C802E9.body
}

ail_tclWatchdogIterator ail_tclWatchdogServer::FindObject (OSAL_tThreadID ThreadID)
{
  //## begin ail_tclWatchdogServer::FindObject%3EF2D3D100A7.body preserve=yes
   // iterator to get thru' list
   ail_tclWatchdogIterator itWdg(poWatchdogList);

   // while end of list not reached
   while ( !itWdg.bIsDone() )
   {
      // wdg-entry with given handle found?
      if ( itWdg.oItem().ThreadID == ThreadID )
         break;
      // get next entry
      itWdg.vNext();
   }

   return (itWdg);
  //## end ail_tclWatchdogServer::FindObject%3EF2D3D100A7.body
}

ail_tclWatchdogIterator ail_tclWatchdogServer::FindNextTriggerObject ()
{
  //## begin ail_tclWatchdogServer::FindNextTriggerObject%3EF2D3FF0102.body preserve=yes
   OSAL_tMSecond CurrentTime = OSAL_ClockGetElapsedTime();
   OSAL_tMSecond MinDiffTime = OSAL_C_U32_MAX;
   OSAL_tMSecond DiffTime = 0;

   // iterator to get thru' list
   ail_tclWatchdogIterator itWdg(poWatchdogList);
   // iterator points to next trigger-object
   ail_tclWatchdogIterator itNextTriggerWdg(poWatchdogList);
   // HACK! set itNextTriggerWdg to invalid
   while ( !itNextTriggerWdg.bIsDone() ) itNextTriggerWdg.vNext();

   // while end of list not reached
   while ( !itWdg.bIsDone() )
   {
      // is wdg-entry active?
      if ( itWdg.oItem().bActive )
      {
         // get time to next trigger (with offset of 10s, so we can't past a wdg)
         DiffTime = (itWdg.oItem().NextTriggerTime - CurrentTime) + 10000;
         // is earlier trigger-time?
         if ( DiffTime < MinDiffTime )
         {
            // set iterator 
            itNextTriggerWdg = itWdg;
            MinDiffTime = DiffTime;
         }
      }
      // get next entry
      itWdg.vNext();
   }

   return (itNextTriggerWdg);
  //## end ail_tclWatchdogServer::FindNextTriggerObject%3EF2D3FF0102.body
}

ail_tWdgHandle ail_tclWatchdogServer::hGetUniqueID ()
{
  //## begin ail_tclWatchdogServer::hGetUniqueID%3EF2D40E01DC.body preserve=yes
   // always start with 1
   ail_tWdgHandle hUniqueId = 1;
   tBool bUniqueIdFound = FALSE;

   while (  !bUniqueIdFound
         && hUniqueId != OSAL_C_INVALID_HANDLE  )
   {
      // iterator to get thru' list
      ail_tclWatchdogIterator itWdg(poWatchdogList);

      // while end of list not reached
      while ( !itWdg.bIsDone() )
      {
         // check if id already used
         if ( hUniqueId == itWdg.oItem().hWdgID )
         {
            break;
         }
         // get next entry
         itWdg.vNext();
      }

      // if we reached list-end, we found a unique id
      if ( itWdg.bIsDone() )
         bUniqueIdFound = TRUE;
      else // else try with next id
         ++hUniqueId;
   }

   return (hUniqueId);
  //## end ail_tclWatchdogServer::hGetUniqueID%3EF2D40E01DC.body
}

tVoid ail_tclWatchdogServer::vRestartTimerForNextTrigger ()
{
  //## begin ail_tclWatchdogServer::vRestartTimerForNextTrigger%3EF2D4200267.body preserve=yes
   // stop timer
   OSAL_s32TimerSetTime( hWdgTimer, 0, 0 ); //lint !e522: Expected void type, assignment, increment or decrement
   hNextTrigger = OSAL_C_INVALID_HANDLE;

   // find next trigger-event
   ail_tclWatchdogIterator itNextWdg = FindNextTriggerObject();
   if ( !itNextWdg.bIsDone() )
   {
      // store handle for next trigger-event
      hNextTrigger = itNextWdg.oItem().hWdgID;
      NextTriggerTime = itNextWdg.oItem().NextTriggerTime;

      // get next trigger-time
      OSAL_tMSecond TimeToNextTrigger = NextTriggerTime - OSAL_ClockGetElapsedTime();
      // if we are too late, call immediately
      if ( TimeToNextTrigger > (tU32)OSAL_C_S32_MAX )
         // call immediately
         TimeToNextTrigger = 1;

      // start timer
      OSAL_s32TimerSetTime( hWdgTimer, TimeToNextTrigger, 0 ); //lint !e522: Expected void type, assignment, increment or decrement

   } // else no other wdg active
  //## end ail_tclWatchdogServer::vRestartTimerForNextTrigger%3EF2D4200267.body
}

tVoid ail_tclWatchdogServer::vDeleteList ()
{
  //## begin ail_tclWatchdogServer::vDeleteList%3EF6B22C027C.body preserve=yes
   if ( poWatchdogList )
   {
      tBool bElementsInList = TRUE;

      while ( bElementsInList )
      {
         ail_tclWatchdogIterator itWdg(poWatchdogList);

         if ( !itWdg.bIsDone() )
         {
            poWatchdogList->nRemove(itWdg.oItem());
         }
         else
         {
            bElementsInList = FALSE;  
         }   
      }

      OSAL_DELETE poWatchdogList;
      poWatchdogList = OSAL_NULL;
   }
  //## end ail_tclWatchdogServer::vDeleteList%3EF6B22C027C.body
}

//## begin module%3EF2CC8A0345.epilog preserve=yes
//## end module%3EF2CC8A0345.epilog
