//## begin module%1.4%.codegen_version preserve=yes
//   Read the documentation to learn more about C++ code generator
//   versioning.
//## end module%1.4%.codegen_version

//## begin module%3A841C49000B.cm preserve=no
//	  %X% %Q% %Z% %W%
//## end module%3A841C49000B.cm

//## begin module%3A841C49000B.cp preserve=no
//## end module%3A841C49000B.cp

//## Module: ail_Storage%3A841C49000B; Subprogram body
//## Subsystem: Ail%3A841A8D02DE
//## Source file: e:\vasco\components\Ail\ail_Storage.cpp

//## begin module%3A841C49000B.additionalIncludes preserve=no
//## end module%3A841C49000B.additionalIncludes

//## begin module%3A841C49000B.includes preserve=yes
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define AIL_S_IMPORT_INTERFACE_GENERIC
#define AIL_S_IMPORT_INTERFACE_TRACE
#include "ail_if.h"
//## end module%3A841C49000B.includes

//## begin module%3A841C49000B.declarations preserve=no
//## end module%3A841C49000B.declarations

//## begin module%3A841C49000B.additionalDeclarations preserve=yes

/*****************************************************************************
 * locally used definitions
 *****************************************************************************/
#define  C_U8_WAIT_FOR_REGISTER_CONF        0x00
#define  C_U8_WAIT_FOR_SERVICEDATA_STATUS   0x01
#define  C_U8_WAIT_FOR__NOT_INITIALIZED     0xFF

//## end module%3A841C49000B.additionalDeclarations

/******************************************************************************/
/*                                                                            */
/* Methods of class 'ail_tclServiceRequest'.                                  */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: ail_tclServiceRequest::ail_tclServiceRequest()
*
* DESCRIPTION: Standard constructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
ail_tclServiceRequest::ail_tclServiceRequest()
  : m_u16ClientSubId(AMT_C_U16_SUBID_INVALID),
    m_u16ServiceMajorVersion(AMT_C_U16_SERVICE_VERSION_INVALID),
    m_u16ServiceMinorVersion(AMT_C_U16_SERVICE_VERSION_INVALID),
    m_bRegistrationConfirmed(FALSE)
{
}

/*******************************************************************************
*
* FUNCTION: ail_tclServiceRequest::ail_tclServiceRequest
*             (tU16 u16ClientSubId,
*              tU16 u16ServiceMajorVersion,
*              tU16 u16ServiceMinorVersion)
*
* DESCRIPTION: Extended constructor with parametrized initialization.
*
* PARAMETER: 
*
*  [IN] u16ClientSubId = Clients CCA sub-ID of the service request.
*  [IN] u16ServiceMajorVersion = Major version of the service request.
*  [IN] u16ServiceMinorVersion = Minor version of the service request.
*
* RETURNVALUE: None.
*
*******************************************************************************/
ail_tclServiceRequest::ail_tclServiceRequest(tU16 u16ClientSubId,
                                             tU16 u16ServiceMajorVersion,
                                             tU16 u16ServiceMinorVersion)
  : m_u16ClientSubId(u16ClientSubId),
    m_u16ServiceMajorVersion(u16ServiceMajorVersion),
    m_u16ServiceMinorVersion(u16ServiceMinorVersion),
    m_bRegistrationConfirmed(FALSE)
{
}

/*******************************************************************************
*
* FUNCTION: ail_tclServiceRequest::operator != 
*             (const ail_tclServiceRequest& oServiceRequest) const
*
* DESCRIPTION: Inequality operator to compare objects of the same class. For 
*              the comparison all member variables of this class are relevant.
*
* PARAMETER: 
*
*  [IN] oServiceRequest = Constant reference to another object of the same 
*                         class.
*
* RETURNVALUE: TRUE = Objects are not equal.
*              FALSE = Objects are equal.
*
*******************************************************************************/
tBool ail_tclServiceRequest::operator != (const ail_tclServiceRequest& oServiceRequest) const
{
  tBool bRet = FALSE;

  if ((oServiceRequest.m_u16ClientSubId         != m_u16ClientSubId        ) ||
      (oServiceRequest.m_u16ServiceMajorVersion != m_u16ServiceMajorVersion) ||
      (oServiceRequest.m_u16ServiceMinorVersion != m_u16ServiceMinorVersion) ||
      (oServiceRequest.m_bRegistrationConfirmed != m_bRegistrationConfirmed)   )
  {
    bRet = TRUE;
  }

  return (bRet);
}

/*******************************************************************************
*
* FUNCTION: ail_tclServiceRequest& ail_tclServiceRequest::operator = 
*             (const ail_tclServiceRequest& oServiceRequest)
*
* DESCRIPTION: Assignment operator to assign objects of the same class.
*
* PARAMETER: 
*
*  [IN] oServiceRequest = Constant reference to another object of the same 
*                         class.
*
* RETURNVALUE: A reference to this classes object.
*
*******************************************************************************/
ail_tclServiceRequest& ail_tclServiceRequest::operator = (const ail_tclServiceRequest& oServiceRequest)
{
  if (this != &oServiceRequest)
  {
    m_u16ClientSubId         = oServiceRequest.m_u16ClientSubId;
    m_u16ServiceMajorVersion = oServiceRequest.m_u16ServiceMajorVersion;
    m_u16ServiceMinorVersion = oServiceRequest.m_u16ServiceMinorVersion;
    m_bRegistrationConfirmed = oServiceRequest.m_bRegistrationConfirmed;
  }

  return (*this);
}

/******************************************************************************/
/*                                                                            */
/* Methods of class 'ail_tclServerApplication'.                                 */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: ail_tclServerApplication::ail_tclServerApplication()
*
* DESCRIPTION: Standard constructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
ail_tclServerApplication::ail_tclServerApplication()
  : m_u16AppId(AMT_C_U16_APPID_INVALID),
    m_u16ServiceId(AMT_C_U16_SERVICE_UNDEF),
    m_bDedicatedServer(FALSE),
    m_poServiceRequestList(NULL),
    m_enServerAppState(AIL_EN_SERVER_APP_STATE_UNKNOWN)
{
}

/*******************************************************************************
*
* FUNCTION: ail_tclServerApplication::ail_tclServerApplication
*             (tU16 u16AppId,
*              tU16 u16ServiceId,
*              const ail_tclServiceRequest& roServiceRequest,
*              ail_tenServerAppState enServerAppState)
*
* DESCRIPTION: Extended constructor with parametrized initialization.
*
*              Beside the initialization of the member variables this 
*              constructor immediately adds the first service-request to the
*              service-request-list.
*
* PARAMETER: 
*
*  [IN] u16AppId         = Server application ID.
*  [IN] u16ServiceId     = Service ID.
*  [IN] roServiceRequest = Constant reference to a service-request object.
*  [IN] enServerAppState = Enum value of the server application state.
*
* RETURNVALUE: None.
*
*******************************************************************************/
ail_tclServerApplication::ail_tclServerApplication(tU16 u16AppId,
                                                   tU16 u16ServiceId,
                                                   tBool bDedicatdedServer,
                                                   const ail_tclServiceRequest& roServiceRequest,
                                                   ail_tenServerAppState enServerAppState)
  : m_u16AppId(u16AppId),
    m_u16ServiceId(u16ServiceId),
    m_bDedicatedServer(bDedicatdedServer),
    m_poServiceRequestList(NULL),
    m_enServerAppState(enServerAppState)
{
  m_poServiceRequestList = OSAL_NEW ail_tclServiceRequestList;

  if (m_poServiceRequestList != NULL)
  {
    m_poServiceRequestList->vAdd(roServiceRequest);
  }
  else
  {
    NORMAL_M_ASSERT_ALWAYS();
  }
}

/*******************************************************************************
*
* FUNCTION: ail_tclServerApplication::~ail_tclServerApplication()
*
* DESCRIPTION: Destructor. Free allocated memory.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
ail_tclServerApplication::~ail_tclServerApplication()
{
  if (m_poServiceRequestList != NULL)
  {
    m_poServiceRequestList->vClear();

    OSAL_DELETE m_poServiceRequestList;
    m_poServiceRequestList = NULL;
  }
}

/*******************************************************************************
*
* FUNCTION: ail_tclServerApplication::ail_tclServerApplication
*             (const ail_tclServerApplication& roServerApplication)
*
* DESCRIPTION: Copy constructor (deep-copy) to initialize this object with 
*              another object of the same class.
*
* PARAMETER: 
*
*  [IN] oServiceRequest = Constant reference to another object of the same 
*                         class.
*
* RETURNVALUE: None.
*
*******************************************************************************/
ail_tclServerApplication::ail_tclServerApplication(const ail_tclServerApplication& roServerApplication)
{
  if (this != &roServerApplication)
  {
    ail_tclServiceRequestList* poServiceRequestList = roServerApplication.poGetServiceRequestList();

    m_u16AppId         = roServerApplication.u16GetAppId();
    m_u16ServiceId     = roServerApplication.u16GetServiceId();
    m_bDedicatedServer = roServerApplication.bIsDedicatedServer();
    m_enServerAppState = roServerApplication.enGetServerAppState();

    if (poServiceRequestList != NULL)
    {
      ail_tclServiceRequestIterator iter(poServiceRequestList);

      m_poServiceRequestList = OSAL_NEW ail_tclServiceRequestList;

      if (m_poServiceRequestList != NULL)
      {
        while(!iter.bIsDone())
        {
          m_poServiceRequestList->vAdd(iter.oItem());
          iter.vNext();
        }
      }
      else
      {
        NORMAL_M_ASSERT_ALWAYS();
      }
    }
    else
    {
      m_poServiceRequestList = NULL;
    }
  }
  else
  {
    m_u16AppId             = AMT_C_U16_APPID_INVALID;
    m_u16ServiceId         = AMT_C_U16_SERVICE_UNDEF;
    m_bDedicatedServer     = FALSE;
    m_enServerAppState     = AIL_EN_SERVER_APP_STATE_UNKNOWN;
    m_poServiceRequestList = NULL;

    NORMAL_M_ASSERT_ALWAYS();
  }
}

/*******************************************************************************
*
* FUNCTION: tBool ail_tclServerApplication::operator != 
*             (const ail_tclServerApplication& roServerApplication) const
*
* DESCRIPTION: Inequality operator to compare objects of the same class. For 
*              the comparison only a subset (primary key attributes) of this 
*              classes member variables is relevant.
*
*              Primary and unique key => m_u16ServiceId     + 
*                                        m_u16AppId         + 
*                                        m_bDedicatedServer
* PARAMETER: 
*
*  [IN] oServiceRequest = Constant reference to another object of the same 
*                         class.
*
* RETURNVALUE: TRUE = Objects are not equal.
*              FALSE = Objects are equal.
*
*******************************************************************************/
tBool ail_tclServerApplication::operator != (const ail_tclServerApplication& roServerApplication) const
{
  tBool bRet = FALSE;

  if ((roServerApplication.m_u16ServiceId     != m_u16ServiceId)     ||
      (roServerApplication.m_u16AppId         != m_u16AppId)         ||
      (roServerApplication.m_bDedicatedServer != m_bDedicatedServer)   )
  {
    bRet = TRUE;
  }

  return (bRet);
}

/*******************************************************************************
*
* FUNCTION: ail_tclServerApplication& ail_tclServerApplication::operator = 
*             (const ail_tclServerApplication& roServerApplication)
*
* DESCRIPTION: Assignment operator to assign objects of the same class.
*
*              This class contains dynamic allocated memory which must be 
*              explicitly considered during the copy process.
*
* PARAMETER: 
*
*  [IN] oServiceRequest = Constant reference to another object of the same 
*                         class.
*
* RETURNVALUE: A reference to this classes object.
*
*******************************************************************************/
ail_tclServerApplication& ail_tclServerApplication::operator = (const ail_tclServerApplication& roServerApplication)
{
  if (this != &roServerApplication)
  {
    ail_tclServiceRequestList* poServiceRequestList = roServerApplication.poGetServiceRequestList();

    m_u16AppId         = roServerApplication.u16GetAppId();
    m_u16ServiceId     = roServerApplication.u16GetServiceId();
    m_bDedicatedServer = roServerApplication.bIsDedicatedServer();
    m_enServerAppState = roServerApplication.enGetServerAppState();

    if (poServiceRequestList != NULL)
    {
      ail_tclServiceRequestIterator iter(poServiceRequestList);

      if (NULL == m_poServiceRequestList)
      {
        m_poServiceRequestList = OSAL_NEW ail_tclServiceRequestList;
      }
      else
      {
        m_poServiceRequestList->vClear();
      }

      if (m_poServiceRequestList != NULL)
      {
        while(!iter.bIsDone())
        {
          m_poServiceRequestList->vAdd(iter.oItem());
          iter.vNext();
        }
      }
      else
      {
        NORMAL_M_ASSERT_ALWAYS();
      }
    }
    else
    {
      if (m_poServiceRequestList != NULL)
      {
        m_poServiceRequestList->vClear();

        OSAL_DELETE m_poServiceRequestList;
        m_poServiceRequestList = NULL;
      }
    }
  }

  return (*this);
}

/*******************************************************************************
*
* FUNCTION: tVoid ail_tclServerApplication::vAddServiceRequest
*             (const ail_tclServiceRequest& roServiceRequest)
*
* DESCRIPTION: Add another service-request to the service-request-list.
*
* PARAMETER: 
*
*  [IN] oServiceRequest = Constant reference to an ail_tclServiceRequest object 
*                         which shall be added to the service-request-list.
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid ail_tclServerApplication::vAddServiceRequest(const ail_tclServiceRequest& roServiceRequest)
{
  if (m_poServiceRequestList != NULL)
  {
    m_poServiceRequestList->vAdd(roServiceRequest);
  }
  else
  {
    NORMAL_M_ASSERT_ALWAYS();
  }
}

// Class ail_tclServiceReference 

ail_tclServiceReference::ail_tclServiceReference (tU16 u16NewAppId, tU16 u16NewServiceId, tU16 u16NewRegisterId, tU16 u16NewSubId)
  //## begin ail_tclServiceReference::ail_tclServiceReference%3A76A1890340.hasinit preserve=no
  //## end ail_tclServiceReference::ail_tclServiceReference%3A76A1890340.hasinit
  //## begin ail_tclServiceReference::ail_tclServiceReference%3A76A1890340.initialization preserve=yes
  : u16ServiceId(u16NewServiceId)
  , u16ServerAppId(u16NewAppId)
  , u16RegisterId(u16NewRegisterId)
  , u8ServiceState(AMT_C_U8_SVCSTATE_NOT_AVAILABLE)
  , u16SubId(u16NewSubId)
  , u16MajorVersion(AMT_C_U16_SERVICE_VERSION_INVALID)
  , u16MinorVersion(AMT_C_U16_SERVICE_VERSION_INVALID)
  , u16PatchVersion(AMT_C_U16_SERVICE_VERSION_INVALID)
  //## end ail_tclServiceReference::ail_tclServiceReference%3A76A1890340.initialization
{
  //## begin ail_tclServiceReference::ail_tclServiceReference%3A76A1890340.body preserve=yes
  //## end ail_tclServiceReference::ail_tclServiceReference%3A76A1890340.body
}

ail_tclServiceReference::ail_tclServiceReference ()
  //## begin ail_tclServiceReference::ail_tclServiceReference%3AB07CDE037C.hasinit preserve=no
  //## end ail_tclServiceReference::ail_tclServiceReference%3AB07CDE037C.hasinit
  //## begin ail_tclServiceReference::ail_tclServiceReference%3AB07CDE037C.initialization preserve=yes
  : u16ServiceId(AMT_C_U16_SERVICE_UNDEF)
  , u16ServerAppId(AMT_C_U16_APPID_INVALID)
  , u16RegisterId(AMT_C_U16_REGID_INVALID)
  , u8ServiceState(AMT_C_U8_SVCSTATE_NOT_AVAILABLE)
  , u16SubId(AMT_C_U16_SUBID_INVALID)
  , u16MajorVersion(AMT_C_U16_SERVICE_VERSION_INVALID)
  , u16MinorVersion(AMT_C_U16_SERVICE_VERSION_INVALID)
  , u16PatchVersion(AMT_C_U16_SERVICE_VERSION_INVALID)
  //## end ail_tclServiceReference::ail_tclServiceReference%3AB07CDE037C.initialization
{
  //## begin ail_tclServiceReference::ail_tclServiceReference%3AB07CDE037C.body preserve=yes

   /* only used to create a non initialized object */

  //## end ail_tclServiceReference::ail_tclServiceReference%3AB07CDE037C.body
}



//## Other Operations (implementation)
tBool ail_tclServiceReference::operator != (const ail_tclServiceReference& oServiceReference) const
{
  //## begin ail_tclServiceReference::operator !=%3A76D3D60382.body preserve=yes
   tBool bRet = FALSE;
   if ( 
         ( oServiceReference.u16RegisterId != u16RegisterId )
         ||
         ( oServiceReference.u16ServiceId != u16ServiceId )
         ||
         ( oServiceReference.u16ServerAppId != u16ServerAppId )
         ||
         ( oServiceReference.u16SubId != u16SubId )
      )
   {
      /* for data set identifing u8ServiceState is not evaluated */
      bRet = TRUE;
   }
   return ( bRet );

  //## end ail_tclServiceReference::operator !=%3A76D3D60382.body
}

ail_tclServiceReference& ail_tclServiceReference::operator = (const ail_tclServiceReference& oServiceReference)
{
  //## begin ail_tclServiceReference::operator =%3AB07D2301FE.body preserve=yes

   if ( this != &oServiceReference )
   {
      u16RegisterId = oServiceReference.u16RegisterId;
      u16ServiceId = oServiceReference.u16ServiceId;
      u16ServerAppId = oServiceReference.u16ServerAppId;
      u8ServiceState = oServiceReference.u8ServiceState;
      u16SubId       = oServiceReference.u16SubId;
      u16MajorVersion = oServiceReference.u16MajorVersion;
      u16MinorVersion = oServiceReference.u16MinorVersion;
      u16PatchVersion = oServiceReference.u16PatchVersion;
   }

   return ( *this );

  //## end ail_tclServiceReference::operator =%3AB07D2301FE.body
}

tBool ail_tclServiceReference::bIsDataSet (tU16 u16RefServiceId, tU16 u16RefSubId) const
{
  //## begin ail_tclServiceReference::bIsDataSet%3A76CCB401D8.body preserve=yes
   tBool    bRetVal = FALSE;

   if ( ( u16RefServiceId == u16ServiceId )
        &&
        (u16RefSubId == u16SubId)
      )
   {
      bRetVal = TRUE;
   }

   return ( bRetVal );
  //## end ail_tclServiceReference::bIsDataSet%3A76CCB401D8.body
}

tBool ail_tclServiceReference::bIsDataSet (tU16 u16RefAppId, tU16 u16RefRegisterId, tU16 u16RefSubId) const
{
  //## begin ail_tclServiceReference::bIsDataSet%3AB1E0B90296.body preserve=yes

   tBool bRet = FALSE;

   if (
         u16ServerAppId == u16RefAppId
         &&
         u16RegisterId == u16RefRegisterId
         &&
         (u16RefSubId == u16SubId)
      )
   {
      bRet = TRUE;
   }

   return ( bRet );

  //## end ail_tclServiceReference::bIsDataSet%3AB1E0B90296.body
}

tBool ail_tclServiceReference::bIsDataSet (tU16 u16RefServiceId, tU16 u16RefAppId, tU16 u16RefRegisterId, tU16 u16RefSubId) const
{
  //## begin ail_tclServiceReference::bIsDataSet%3AB1E0D00311.body preserve=yes

   tBool bRet = FALSE;

   if (
         ((u16RefServiceId == u16ServiceId) || (u16RefServiceId == AMT_C_U16_SERVICE_UNDEF))
         &&
         ((u16RefAppId == u16ServerAppId) || (u16RefAppId == AMT_C_U16_APPID_INVALID))
         &&
         ((u16RefRegisterId == u16RegisterId) || (u16RefRegisterId == AMT_C_U16_REGID_INVALID))
         &&
         ((u16RefSubId == u16SubId) || (u16RefSubId == AMT_C_U16_SUBID_INVALID))
      )
   {
      bRet = TRUE;
   }

   return ( bRet );


  //## end ail_tclServiceReference::bIsDataSet%3AB1E0D00311.body
}

tVoid ail_tclServiceReference::vSetServiceState (tU8 u8NewServiceState)
{
  //## begin ail_tclServiceReference::vSetServiceState%3A76CD3C0025.body preserve=yes

   u8ServiceState = u8NewServiceState;

  //## end ail_tclServiceReference::vSetServiceState%3A76CD3C0025.body
}

tU8 ail_tclServiceReference::u8GetServiceState () const
{
  //## begin ail_tclServiceReference::u8GetServiceState%3A76CDDB01BE.body preserve=yes
   return(u8ServiceState);
  //## end ail_tclServiceReference::u8GetServiceState%3A76CDDB01BE.body
}

tU16 ail_tclServiceReference::u16GetServiceId () const
{
  //## begin ail_tclServiceReference::u16GetServiceId%3A76CE2103C8.body preserve=yes
  return(u16ServiceId);
  //## end ail_tclServiceReference::u16GetServiceId%3A76CE2103C8.body
}

tU16 ail_tclServiceReference::u16GetServerAppId () const
{
  //## begin ail_tclServiceReference::u16GetServerAppId%3A76CE5601CF.body preserve=yes
  return(u16ServerAppId);
  //## end ail_tclServiceReference::u16GetServerAppId%3A76CE5601CF.body
}

tU16 ail_tclServiceReference::u16GetRegisterId () const
{
  //## begin ail_tclServiceReference::u16GetRegisterId%3A76CE6F033E.body preserve=yes
  return(u16RegisterId);
  //## end ail_tclServiceReference::u16GetRegisterId%3A76CE6F033E.body
}

tU16 ail_tclServiceReference::u16GetSubId () const
{
  //## begin ail_tclServiceReference::u16GetSubId%3C92170D024B.body preserve=yes
   return ( u16SubId );
  //## end ail_tclServiceReference::u16GetSubId%3C92170D024B.body
}

tBool ail_tclServiceReference::bGetVersion(tU16 &rfu16MajorVersion, tU16 &rfu16MinorVersion, tU16 &rfu16PatchVersion) const
{
   rfu16MajorVersion = this->u16MajorVersion;
   rfu16MinorVersion = this->u16MinorVersion;
   rfu16PatchVersion = this->u16PatchVersion;
   return (rfu16MajorVersion != AMT_C_U16_SERVICE_VERSION_INVALID);
}

tVoid ail_tclServiceReference::vSetVersion(tU16 u16NewMajorVersion, tU16 u16NewMinorVersion, tU16 u16NewPatchVersion)
{
   this->u16MajorVersion = u16NewMajorVersion;
   this->u16MinorVersion = u16NewMinorVersion;
   this->u16PatchVersion = u16NewPatchVersion;
}

tU16 ail_tclServiceReference::u16GetMajorVersion() const
{
   return u16MajorVersion;
}

// Class ail_tclServiceSyncAnswer 

ail_tclServiceSyncAnswer::ail_tclServiceSyncAnswer ()
  //## begin ail_tclServiceSyncAnswer::ail_tclServiceSyncAnswer%3A76E48A0126.hasinit preserve=no
  //## end ail_tclServiceSyncAnswer::ail_tclServiceSyncAnswer%3A76E48A0126.hasinit
  //## begin ail_tclServiceSyncAnswer::ail_tclServiceSyncAnswer%3A76E48A0126.initialization preserve=yes
  : hAnswerEvent(OSAL_C_INVALID_HANDLE)
  , u8RequestType(C_U8_WAIT_FOR__NOT_INITIALIZED)
  , enAvailabilityType(AIL_EN_U16_SYNC_UNINITIALIZED)  // only used to create a non initialized object
  , u16ServerAppId(AMT_C_U16_APPID_INVALID)
  , u16ServiceId(AMT_C_U16_SERVICE_UNDEF)
  , u16ClientSubId(AMT_C_U16_SUBID_INVALID)
  , u16RegisterId(AMT_C_U16_REGID_INVALID)
  , u16CmdCounter(0)
  , u16FunctionId(0)
  , u8ACT(0)
  //## end ail_tclServiceSyncAnswer::ail_tclServiceSyncAnswer%3A76E48A0126.initialization
{
  //## begin ail_tclServiceSyncAnswer::ail_tclServiceSyncAnswer%3A76E48A0126.body preserve=yes
   hMessageHandle.enLocation = OSAL_EN_MEMORY_INVALID;
   hMessageHandle.u32Offset  = 0;
  //## end ail_tclServiceSyncAnswer::ail_tclServiceSyncAnswer%3A76E48A0126.body
}



//## Other Operations (implementation)
tBool ail_tclServiceSyncAnswer::bInitServiceSyncAnswerForReg (OSAL_tSemHandle hSyncSem, tU16 u16NewServerAppId, tU16 u16NewServiceId, tU16 u16NewClientSubId)
{
  //## begin ail_tclServiceSyncAnswer::bInitServiceSyncAnswerForReg%3AB080810104.body preserve=yes

   tBool bRet = FALSE;
   hAnswerEvent = hSyncSem;
   u8RequestType = C_U8_WAIT_FOR_REGISTER_CONF;   
   u16ServerAppId = u16NewServerAppId;
   u16ServiceId = u16NewServiceId;
   u16ClientSubId = u16NewClientSubId;

   if ( hAnswerEvent != OSAL_C_INVALID_HANDLE )
   {
      bRet = TRUE;
   }

   return(bRet);

  //## end ail_tclServiceSyncAnswer::bInitServiceSyncAnswerForReg%3AB080810104.body
}

tBool ail_tclServiceSyncAnswer::bInitServiceSyncAnswerForData (OSAL_tSemHandle hSyncSem, tU16 u16NewServerAppId, tU16 u16NewRegisterId, tU16 u16NewCmdCounter, tU16 u16NewServiceId, tU16 u16NewClientSubId, tU16 u16NewFunctionId, tU8 u8NewACT)
{
  //## begin ail_tclServiceSyncAnswer::bInitServiceSyncAnswerForData%3A783430003F.body preserve=yes

   tBool bRet = FALSE;
   hAnswerEvent = hSyncSem;
   u8RequestType = C_U8_WAIT_FOR_SERVICEDATA_STATUS;   
   u16ServerAppId = u16NewServerAppId;
   u16RegisterId = u16NewRegisterId;
   u16CmdCounter = u16NewCmdCounter;
   u16ServiceId = u16NewServiceId;
   u16ClientSubId = u16NewClientSubId;
   u16FunctionId = u16NewFunctionId;
   u8ACT = u8NewACT;

   if ( hAnswerEvent != OSAL_C_INVALID_HANDLE )
   {
      bRet = TRUE;
   }

   return(bRet);

  //## end ail_tclServiceSyncAnswer::bInitServiceSyncAnswerForData%3A783430003F.body
}

tVoid ail_tclServiceSyncAnswer::vDeinitServiceSyncAnswer ()
{
  //## begin ail_tclServiceSyncAnswer::vDeinitServiceSyncAnswer%3AA613BE011F.body preserve=yes

   hAnswerEvent = OSAL_C_INVALID_HANDLE;

  //## end ail_tclServiceSyncAnswer::vDeinitServiceSyncAnswer%3AA613BE011F.body
}

tBool ail_tclServiceSyncAnswer::bIsWaitForRegister (tU16 u16NewServerAppId, tU16 u16NewServiceId, tU16 u16NewClientSubId) const
{
  //## begin ail_tclServiceSyncAnswer::bIsWaitForRegister%3A7835BC00CB.body preserve=yes
   tBool bRet = FALSE;

   if ( u8RequestType == C_U8_WAIT_FOR_REGISTER_CONF )
   {
      if ( 
            u16ServerAppId == u16NewServerAppId
            &&
            u16ServiceId == u16NewServiceId
            &&
            u16ClientSubId == u16NewClientSubId
         )
      {
         bRet = TRUE;
      }
   }
   return(bRet);
  //## end ail_tclServiceSyncAnswer::bIsWaitForRegister%3A7835BC00CB.body
}

tBool ail_tclServiceSyncAnswer::bIsWaitForData () const
{
  //## begin ail_tclServiceSyncAnswer::bIsWaitForData%3CAD782B030B.body preserve=yes
   return ( ( u8RequestType == C_U8_WAIT_FOR_SERVICEDATA_STATUS ) ? TRUE : FALSE ) ;
  //## end ail_tclServiceSyncAnswer::bIsWaitForData%3CAD782B030B.body
}

tBool ail_tclServiceSyncAnswer::bIsWaitForData (tU16 u16NewServerAppId, tU16 u16NewRegisterId, tU16 u16NewCmdCounter, tU16 u16NewServiceId, tU16 u16NewClientSubId) const
{
  //## begin ail_tclServiceSyncAnswer::bIsWaitForData%3A7836240201.body preserve=yes

   tBool bRet = FALSE;

   if ( u8RequestType == C_U8_WAIT_FOR_SERVICEDATA_STATUS )
   {
      if ( 
            u16ServerAppId == u16NewServerAppId
            &&
            u16RegisterId == u16NewRegisterId
            &&
            u16CmdCounter == u16NewCmdCounter
            &&
            u16ServiceId == u16NewServiceId
            &&
            u16ClientSubId == u16NewClientSubId
         )
      {
         bRet = TRUE;
      }
   }
   return(bRet);
  
  //## end ail_tclServiceSyncAnswer::bIsWaitForData%3A7836240201.body
}

tBool ail_tclServiceSyncAnswer::bIsWaitForData (tU16 u16NewServerAppId, tU16 u16NewRegisterId, tU16 u16NewServiceId, tU16 u16NewClientSubId) const
{
  //## begin ail_tclServiceSyncAnswer::bIsWaitForData%3BAB286E0155.body preserve=yes
   tBool bRet = FALSE;

   if ( u8RequestType == C_U8_WAIT_FOR_SERVICEDATA_STATUS )
   {
      if ( 
            u16ServerAppId == u16NewServerAppId
            &&
            u16RegisterId == u16NewRegisterId
            &&
            u16ServiceId == u16NewServiceId
            &&
            u16ClientSubId == u16NewClientSubId
         )
      {
         bRet = TRUE;
      }
   }
   return(bRet);
  //## end ail_tclServiceSyncAnswer::bIsWaitForData%3BAB286E0155.body
}

tBool ail_tclServiceSyncAnswer::bIsWaitForData(tU16 u16NewServerAppId, tU16 u16NewRegisterId
                                              , tU16 u16NewCmdCounter, tU16 u16NewServiceId
                                              , tU16 u16NewClientSubId, tU16 u16NewFunctionId
                                              , tU8 u8NewAct) const
{
   tBool bRet = FALSE;

   if ( ( TRUE == bIsWaitForData( u16NewServerAppId, u16NewRegisterId, u16NewCmdCounter, u16NewServiceId, u16NewClientSubId ) )
        &&
        ( u16FunctionId == u16NewFunctionId )
        &&
        ( u8ACT == u8NewAct )
      )
   {
      bRet = TRUE;
   }

   return bRet;
}

tBool ail_tclServiceSyncAnswer::bIsAnswer (ail_tenSyncAnswerType* penAnswerType, amt_tclBaseMessage* poAnswerMessage, OSAL_tSemHandle hSyncSem) const
{
  //## begin ail_tclServiceSyncAnswer::bIsAnswer%3A78367202DF.body preserve=yes

   // only if *penAnswerType==AIL_EN_U16_SYNC_MESSAGE_ANSWER, poAnswerMessage isValid
   tBool bRet = FALSE;

   if ( hSyncSem == hAnswerEvent )
   {  
      tS32 s32Ret;

      /* yes, it is the local reference object */
      bRet = TRUE;

      if ( enAvailabilityType == AIL_EN_U16_SYNC_MESSAGE_ANSWER )
      /* getting an answer message */
      {
         /* preset error return is default */
         *penAnswerType = AIL_EN_U16_SYNC_UNDEFINED_ABORT;

         *poAnswerMessage->prGetOSALMsgHandle() = hMessageHandle;

         poAnswerMessage->pu8SharedMemBase = OSAL_pu8MessageContentGet
         (
            *poAnswerMessage->prGetOSALMsgHandle(),
            OSAL_EN_READWRITE
         );

         poAnswerMessage->vSetDynMsgSize( poAnswerMessage->u32GetSize() );

         s32Ret = 
            ((poAnswerMessage->pu8SharedMemBase == OSAL_NULL) ? OSAL_ERROR : OSAL_OK);

         if ( s32Ret == OSAL_OK )
         {
            *penAnswerType = AIL_EN_U16_SYNC_MESSAGE_ANSWER;
         }
      }
      else
      {
         /* parse the error reason */
         *penAnswerType = enAvailabilityType;
      }

   }
   /* else: not the wanted element */

   return(bRet);
  //## end ail_tclServiceSyncAnswer::bIsAnswer%3A78367202DF.body
}

tBool ail_tclServiceSyncAnswer::bForwardAnswer (amt_tclBaseMessage* poNewMessage)
{
  //## begin ail_tclServiceSyncAnswer::bForwardAnswer%3A78377801F6.body preserve=yes

   tBool bMessageForwarded = FALSE;
   if ( enAvailabilityType == AIL_EN_U16_SYNC_UNINITIALIZED )
   /* prevent to post a semaphore twice */
   {
      hMessageHandle = *poNewMessage->prGetOSALMsgHandle();

      enAvailabilityType = AIL_EN_U16_SYNC_MESSAGE_ANSWER;
      if ( OSAL_OK == OSAL_s32SemaphorePost( hAnswerEvent ) )
      {
         bMessageForwarded = TRUE;
      }
   }
   return bMessageForwarded;

  //## end ail_tclServiceSyncAnswer::bForwardAnswer%3A78377801F6.body
}

tVoid ail_tclServiceSyncAnswer::vForwardAbort (ail_tenSyncAnswerType enAbortReason)
{
  //## begin ail_tclServiceSyncAnswer::vForwardAbort%3A783A1D038A.body preserve=yes

   if ( enAvailabilityType == AIL_EN_U16_SYNC_UNINITIALIZED )
   /* prevent to post a semaphore twice */
   {
      enAvailabilityType = enAbortReason;
      OSAL_s32SemaphorePost( hAnswerEvent ); //lint !e522: Expected void type, assignment, increment or decrement
   }

  //## end ail_tclServiceSyncAnswer::vForwardAbort%3A783A1D038A.body
}

tBool ail_tclServiceSyncAnswer::operator != (const ail_tclServiceSyncAnswer& oServiceSyncAnswer) const
{
  //## begin ail_tclServiceSyncAnswer::operator !=%3A8BEB3F01E4.body preserve=yes
   tBool bRet = FALSE;

   if ( oServiceSyncAnswer.u8RequestType == C_U8_WAIT_FOR_REGISTER_CONF )
   /* request for RegisterId */
   { 
      if ( 
            ( oServiceSyncAnswer.u8RequestType != u8RequestType )
            ||
            ( oServiceSyncAnswer.u16ServiceId != u16ServiceId )
            ||
            ( oServiceSyncAnswer.u16ServerAppId != u16ServerAppId )
            ||
            ( oServiceSyncAnswer.u16ClientSubId != u16ClientSubId )
         )
      {
         /* for data set identifing u8ServiceState is not evaluated */
         bRet = TRUE;
      }
   }
   else
   /* some request for sychron ServiceData */
   {
      if ( 
            ( oServiceSyncAnswer.u8RequestType != u8RequestType )
            ||
            ( oServiceSyncAnswer.u16ServiceId != u16ServiceId )
            ||
            ( oServiceSyncAnswer.u16ServerAppId != u16ServerAppId )
            ||
            ( oServiceSyncAnswer.u16RegisterId != u16RegisterId )
            ||
            ( oServiceSyncAnswer.u16CmdCounter != u16CmdCounter )
            ||
            ( oServiceSyncAnswer.u16ClientSubId != u16ClientSubId )
            ||
            ( oServiceSyncAnswer.u16FunctionId != u16FunctionId )
            ||
            ( oServiceSyncAnswer.u8ACT != u8ACT )
         )
      {
         /* for data set identifing u8ServiceState is not evaluated */
         bRet = TRUE;
      }
   }
   return ( bRet );
  //## end ail_tclServiceSyncAnswer::operator !=%3A8BEB3F01E4.body
}

ail_tclServiceSyncAnswer& ail_tclServiceSyncAnswer::operator = (const ail_tclServiceSyncAnswer& oServiceSyncAnswer)
{
  //## begin ail_tclServiceSyncAnswer::operator =%3AB080AF00E2.body preserve=yes

   if ( this != &oServiceSyncAnswer )
   {
      enAvailabilityType = oServiceSyncAnswer.enAvailabilityType;
      hAnswerEvent = oServiceSyncAnswer.hAnswerEvent;
      hMessageHandle = oServiceSyncAnswer.hMessageHandle;
      u16CmdCounter = oServiceSyncAnswer.u16CmdCounter;
      u16RegisterId = oServiceSyncAnswer.u16RegisterId;
      u16ServerAppId = oServiceSyncAnswer.u16ServerAppId;
      u16ServiceId = oServiceSyncAnswer.u16ServiceId;
      u8RequestType = oServiceSyncAnswer.u8RequestType;
      u16ClientSubId = oServiceSyncAnswer.u16ClientSubId;
      u16FunctionId = oServiceSyncAnswer.u16FunctionId;
      u8ACT = oServiceSyncAnswer.u8ACT;
   }
   
   return ( *this );

  //## end ail_tclServiceSyncAnswer::operator =%3AB080AF00E2.body
}

void ail_tclServiceSyncAnswer::vDumpToString(tChar* szBuffer, tU16 u16Size) const
{
   if(szBuffer != NULL)
   {
      (tVoid)OSALUTIL_s32SaveNPrintFormat(szBuffer, u16Size, 
                                   "pndg sync rqTyp=%d availTyp=%d servApp=%d srv=%d clntSub=%d reg=%d cmdCntr=%d fnct=%d ACT=%d", 
                 u8RequestType,
                 enAvailabilityType,
                 u16ServerAppId,
                 u16ServiceId,
                 u16ClientSubId,
                 u16RegisterId,
                 u16CmdCounter,
                 u16FunctionId,
                 u8ACT);
   }
}

void ail_tclServiceSyncAnswer::vTraceDump(TR_tenTraceLevel enLevel) const
{
   tChar szTraceText[200];
   vDumpToString(szTraceText, sizeof(szTraceText)/sizeof(szTraceText[0]));

   ail_vTraceMsg(enLevel, "  %s", szTraceText);
}

tU16 ail_tclServiceSyncAnswer::u16GetServerAppId() const
{
   return u16ServerAppId;
}


// Class ail_tclOpenedQueue 

ail_tclOpenedQueue::ail_tclOpenedQueue (OSAL_tMQueueHandle hNewQueue, tU16 u16NewAppId)
  //## begin ail_tclOpenedQueue::ail_tclOpenedQueue%3A77BB950370.hasinit preserve=no
  //## end ail_tclOpenedQueue::ail_tclOpenedQueue%3A77BB950370.hasinit
  //## begin ail_tclOpenedQueue::ail_tclOpenedQueue%3A77BB950370.initialization preserve=yes
  : hQueue(hNewQueue)
  , u16AppId(u16NewAppId)
  //## end ail_tclOpenedQueue::ail_tclOpenedQueue%3A77BB950370.initialization
{
  //## begin ail_tclOpenedQueue::ail_tclOpenedQueue%3A77BB950370.body preserve=yes
  //## end ail_tclOpenedQueue::ail_tclOpenedQueue%3A77BB950370.body
}

ail_tclOpenedQueue::ail_tclOpenedQueue ()
  //## begin ail_tclOpenedQueue::ail_tclOpenedQueue%3AB07FB40195.hasinit preserve=no
  //## end ail_tclOpenedQueue::ail_tclOpenedQueue%3AB07FB40195.hasinit
  //## begin ail_tclOpenedQueue::ail_tclOpenedQueue%3AB07FB40195.initialization preserve=yes
  : hQueue(OSAL_C_INVALID_HANDLE)
  , u16AppId(AMT_C_U16_APPID_INVALID)
  //## end ail_tclOpenedQueue::ail_tclOpenedQueue%3AB07FB40195.initialization
{
  //## begin ail_tclOpenedQueue::ail_tclOpenedQueue%3AB07FB40195.body preserve=yes

   /* only used to create a non initialized object */

  //## end ail_tclOpenedQueue::ail_tclOpenedQueue%3AB07FB40195.body
}



//## Other Operations (implementation)
tBool ail_tclOpenedQueue::operator != (const ail_tclOpenedQueue& oOpenedQueue) const
{
  //## begin ail_tclOpenedQueue::operator !=%3A8BEA9B003A.body preserve=yes

   tBool bRet = FALSE;
   if ( 
         ( oOpenedQueue.u16AppId != u16AppId )
      )
   {
      /* for data set identifing u8ServiceState is not evaluated */
      bRet = TRUE;
   }
   return ( bRet );

  //## end ail_tclOpenedQueue::operator !=%3A8BEA9B003A.body
}

ail_tclOpenedQueue& ail_tclOpenedQueue::operator = (const ail_tclOpenedQueue& oOpenedQueue)
{
  //## begin ail_tclOpenedQueue::operator =%3AB07F5A0073.body preserve=yes

   if ( this != &oOpenedQueue)
   {
      hQueue = oOpenedQueue.hQueue;
      u16AppId = oOpenedQueue.u16AppId;
   }

   return ( *this );

  //## end ail_tclOpenedQueue::operator =%3AB07F5A0073.body
}

tU16 ail_tclOpenedQueue::u16GetAppId () const
{
  //## begin ail_tclOpenedQueue::u16GetAppId%3A78142800F4.body preserve=yes
   return ( u16AppId );
  //## end ail_tclOpenedQueue::u16GetAppId%3A78142800F4.body
}

OSAL_tMQueueHandle ail_tclOpenedQueue::hGetQueue () const
{
  //## begin ail_tclOpenedQueue::hGetQueue%3A7814400063.body preserve=yes
   return ( hQueue );
  //## end ail_tclOpenedQueue::hGetQueue%3A7814400063.body
}

tBool ail_tclOpenedQueue::bIsOpenedForApp (tU16 u16RefAppId, OSAL_tMQueueHandle* phQueue) const
{
  //## begin ail_tclOpenedQueue::bIsOpenedForApp%3A7814F501D5.body preserve=yes

   tBool bRet = FALSE;

   if ( u16AppId == u16RefAppId )
   {
      *phQueue = hQueue;

      bRet = TRUE;
   }

   return ( bRet );
  //## end ail_tclOpenedQueue::bIsOpenedForApp%3A7814F501D5.body
}

// Class ail_tclServiceRegistry 

ail_tclServiceRegistry::ail_tclServiceRegistry (tU16 u16NewRegisterId, tU16 u16NewServiceId, tU16 u16NewClientId, tU16 u16NewClientSubId)
  //## begin ail_tclServiceRegistry::ail_tclServiceRegistry%3A76D0E703D3.hasinit preserve=no
  //## end ail_tclServiceRegistry::ail_tclServiceRegistry%3A76D0E703D3.hasinit
  //## begin ail_tclServiceRegistry::ail_tclServiceRegistry%3A76D0E703D3.initialization preserve=yes
  : u16RegisterId(u16NewRegisterId)
  , u16ServiceId(u16NewServiceId)
  , u16ClientAppId(u16NewClientId)
  , u16ClientSubId(u16NewClientSubId)
  , u8ServiceState(AMT_C_U8_SVCSTATE_NOT_AVAILABLE)
  , u16MajorVersion(AMT_C_U16_SERVICE_VERSION_INVALID)
  , u16MinorVersion(AMT_C_U16_SERVICE_VERSION_INVALID)
  , u16PatchVersion(AMT_C_U16_SERVICE_VERSION_INVALID)
  //## end ail_tclServiceRegistry::ail_tclServiceRegistry%3A76D0E703D3.initialization
{
  //## begin ail_tclServiceRegistry::ail_tclServiceRegistry%3A76D0E703D3.body preserve=yes
  //## end ail_tclServiceRegistry::ail_tclServiceRegistry%3A76D0E703D3.body
}

ail_tclServiceRegistry::ail_tclServiceRegistry ()
  //## begin ail_tclServiceRegistry::ail_tclServiceRegistry%3AB07F89019D.hasinit preserve=no
  //## end ail_tclServiceRegistry::ail_tclServiceRegistry%3AB07F89019D.hasinit
  //## begin ail_tclServiceRegistry::ail_tclServiceRegistry%3AB07F89019D.initialization preserve=yes
  : u16RegisterId(AMT_C_U16_REGID_INVALID)
  , u16ServiceId(AMT_C_U16_SERVICE_UNDEF)
  , u16ClientAppId(AMT_C_U16_APPID_INVALID)
  , u16ClientSubId(AMT_C_U16_SUBID_INVALID)
  , u8ServiceState(AMT_C_U8_SVCSTATE_NOT_AVAILABLE)
  , u16MajorVersion(AMT_C_U16_SERVICE_VERSION_INVALID)
  , u16MinorVersion(AMT_C_U16_SERVICE_VERSION_INVALID)
  , u16PatchVersion(AMT_C_U16_SERVICE_VERSION_INVALID)
  //## end ail_tclServiceRegistry::ail_tclServiceRegistry%3AB07F89019D.initialization
{
  //## begin ail_tclServiceRegistry::ail_tclServiceRegistry%3AB07F89019D.body preserve=yes

   /* only used to create a non initialized object */

  //## end ail_tclServiceRegistry::ail_tclServiceRegistry%3AB07F89019D.body
}



//## Other Operations (implementation)
tBool ail_tclServiceRegistry::operator != (const ail_tclServiceRegistry& oServiceRegistry) const
{
  //## begin ail_tclServiceRegistry::operator !=%3A782F38028F.body preserve=yes
   tBool bRet = FALSE;
   if ( 
         ( oServiceRegistry.u16RegisterId != u16RegisterId )
         ||
         ( oServiceRegistry.u16ServiceId != u16ServiceId )
         ||
         ( oServiceRegistry.u16ClientAppId != u16ClientAppId )
         ||
         ( oServiceRegistry.u16ClientSubId != u16ClientSubId )
      )
   {
      /* for data set identifing u8ServiceState is not evaluated */
      bRet = TRUE;
   }
   return ( bRet );
  //## end ail_tclServiceRegistry::operator !=%3A782F38028F.body
}

ail_tclServiceRegistry& ail_tclServiceRegistry::operator = (const ail_tclServiceRegistry& oServiceRegistry)
{
  //## begin ail_tclServiceRegistry::operator =%3AB07F12005C.body preserve=yes

   if ( this != &oServiceRegistry )
   {
      u16ClientAppId = oServiceRegistry.u16ClientAppId;
      u16RegisterId = oServiceRegistry.u16RegisterId;
      u16ServiceId = oServiceRegistry.u16ServiceId;
      u8ServiceState = oServiceRegistry.u8ServiceState;
      u16ClientSubId = oServiceRegistry.u16ClientSubId;
      u16MajorVersion = oServiceRegistry.u16MajorVersion;
      u16MinorVersion = oServiceRegistry.u16MinorVersion;
      u16PatchVersion = oServiceRegistry.u16PatchVersion;
   }

   return ( *this );

  //## end ail_tclServiceRegistry::operator =%3AB07F12005C.body
}

tBool ail_tclServiceRegistry::bIsDataSet (tU16 u16RefRegisterId) const
{
  //## begin ail_tclServiceRegistry::bIsDataSet%3AC4720502DE.body preserve=yes
   tBool bRet = FALSE;
   if ( 
         ( u16RefRegisterId == u16RegisterId )
      )
   {
      /* for data set identifing u8ServiceState is not evaluated */
      bRet = TRUE;
   }
   return ( bRet );
  //## end ail_tclServiceRegistry::bIsDataSet%3AC4720502DE.body
}

tBool ail_tclServiceRegistry::bIsDataSet (tU16 u16RefRegisterId, tU16 u16RefServiceId) const
{
  //## begin ail_tclServiceRegistry::bIsDataSet%3A76D16F0021.body preserve=yes
   tBool bRet = FALSE;
   if ( 
         ( u16RefRegisterId == u16RegisterId )
         &&
         ( u16RefServiceId == u16ServiceId )
      )
   {
      /* for data set identifing u8ServiceState is not evaluated */
      bRet = TRUE;
   }
   return ( bRet );
  //## end ail_tclServiceRegistry::bIsDataSet%3A76D16F0021.body
}

tBool ail_tclServiceRegistry::bIsDataSet (tU16 u16RefRegisterId, tU16 u16RefServiceId, tU16 u16RefAppId, tU16 u16RefSubId) const
{
  //## begin ail_tclServiceRegistry::bIsDataSet%3AC472B40090.body preserve=yes
   tBool bRet = FALSE;
   if ( 
         ( ( u16RefRegisterId == u16RegisterId ) || ( AMT_C_U16_REGID_INVALID == u16RefRegisterId) )
         &&
         ( u16RefServiceId == u16ServiceId )
         &&
         ( u16RefAppId == u16ClientAppId )
         &&
         ( u16RefSubId == u16ClientSubId )
      )
   {
      /* for data set identifing u8ServiceState is not evaluated */
      bRet = TRUE;
   }
   return ( bRet );
  //## end ail_tclServiceRegistry::bIsDataSet%3AC472B40090.body
}

tVoid ail_tclServiceRegistry::vSetServiceState (tU8 u8NewServiceState)
{
  //## begin ail_tclServiceRegistry::vSetServiceState%3AD43F170318.body preserve=yes
   u8ServiceState = u8NewServiceState;
  //## end ail_tclServiceRegistry::vSetServiceState%3AD43F170318.body
}

tU8 ail_tclServiceRegistry::u8GetServiceState () const
{
  //## begin ail_tclServiceRegistry::u8GetServiceState%3AD43F4A019F.body preserve=yes
   return ( u8ServiceState );
  //## end ail_tclServiceRegistry::u8GetServiceState%3AD43F4A019F.body
}

tU16 ail_tclServiceRegistry::u16GetRegisterId () const
{
  //## begin ail_tclServiceRegistry::u16GetRegisterId%3A76D27B0026.body preserve=yes
   return ( u16RegisterId );
  //## end ail_tclServiceRegistry::u16GetRegisterId%3A76D27B0026.body
}

tU16 ail_tclServiceRegistry::u16GetServiceId () const
{
  //## begin ail_tclServiceRegistry::u16GetServiceId%3A76D28B0354.body preserve=yes
  return ( u16ServiceId );
  //## end ail_tclServiceRegistry::u16GetServiceId%3A76D28B0354.body
}

tU16 ail_tclServiceRegistry::u16GetClientAppId () const
{
  //## begin ail_tclServiceRegistry::u16GetClientAppId%3A76D298035D.body preserve=yes
  return ( u16ClientAppId );
  //## end ail_tclServiceRegistry::u16GetClientAppId%3A76D298035D.body
}

tU16 ail_tclServiceRegistry::u16GetClientSubId () const
{
  //## begin ail_tclServiceRegistry::u16GetClientSubId%3C751CBD00F1.body preserve=yes
   return (u16ClientSubId);
  //## end ail_tclServiceRegistry::u16GetClientSubId%3C751CBD00F1.body
}

tBool ail_tclServiceRegistry::bGetVersion(tU16 &rfu16MajorVersion, tU16 &rfu16MinorVersion, tU16 &rfu16PatchVersion) const
{
   rfu16MajorVersion = this->u16MajorVersion;
   rfu16MinorVersion = this->u16MinorVersion;
   rfu16PatchVersion = this->u16PatchVersion;
   return (rfu16MajorVersion != AMT_C_U16_SERVICE_VERSION_INVALID);
}

tVoid ail_tclServiceRegistry::vSetVersion(tU16 u16NewMajorVersion, tU16 u16NewMinorVersion, tU16 u16NewPatchVersion)
{
   this->u16MajorVersion = u16NewMajorVersion;
   this->u16MinorVersion = u16NewMinorVersion;
   this->u16PatchVersion = u16NewPatchVersion;
}

tU16 ail_tclServiceRegistry::u16GetMajorVersion() const
{
   return u16MajorVersion;
}

// Class ail_tclAsyncRegisterReq 

ail_tclAsyncRegisterReq::ail_tclAsyncRegisterReq (tU16 u16RefServerAppId, tU16 u16RefServiceId, tU16 u16RefClientSubId, tU32 u32RefToutCounter)
  //## begin ail_tclAsyncRegisterReq::ail_tclAsyncRegisterReq%3D60D5D202D1.hasinit preserve=no
  //## end ail_tclAsyncRegisterReq::ail_tclAsyncRegisterReq%3D60D5D202D1.hasinit
  //## begin ail_tclAsyncRegisterReq::ail_tclAsyncRegisterReq%3D60D5D202D1.initialization preserve=yes
  : u16ServerAppId(u16RefServerAppId)
  , u16ServiceId(u16RefServiceId)
  , u16ClientSubId(u16RefClientSubId)
  , u32ToutCounter(u32RefToutCounter)
  //## end ail_tclAsyncRegisterReq::ail_tclAsyncRegisterReq%3D60D5D202D1.initialization
{
  //## begin ail_tclAsyncRegisterReq::ail_tclAsyncRegisterReq%3D60D5D202D1.body preserve=yes
  //## end ail_tclAsyncRegisterReq::ail_tclAsyncRegisterReq%3D60D5D202D1.body
}



//## Other Operations (implementation)
tBool ail_tclAsyncRegisterReq::bIsAnswer (tU16 u16RefServerAppId, tU16 u16RefServiceId, tU16 u16RefClientSubId) const
{
  //## begin ail_tclAsyncRegisterReq::bIsAnswer%3D5CEAA70070.body preserve=yes
  tBool bRet = FALSE;

  if (
         u16ServerAppId == u16RefServerAppId
         &&
         u16ClientSubId == u16RefClientSubId
         &&
         u16ServiceId == u16RefServiceId
      )
  {
     bRet = TRUE;
  }

  return ( bRet );

  //## end ail_tclAsyncRegisterReq::bIsAnswer%3D5CEAA70070.body
}

tBool ail_tclAsyncRegisterReq::bIsObsolete () const
{
  //## begin ail_tclAsyncRegisterReq::bIsObsolete%3D61080901BE.body preserve=yes

   tBool bRet = FALSE;

   if ( u32ToutCounter == 0 )
   {
      bRet = TRUE;
   } 

   return ( bRet );

  //## end ail_tclAsyncRegisterReq::bIsObsolete%3D61080901BE.body
}

tBool ail_tclAsyncRegisterReq::operator != (const ail_tclAsyncRegisterReq& oAsyncRegisterReq) const
{
  //## begin ail_tclAsyncRegisterReq::operator !=%3D5CEB19013A.body preserve=yes

   tBool bRet = FALSE;
   if ( 
         ( oAsyncRegisterReq.u16ServiceId != u16ServiceId )
         ||
         ( oAsyncRegisterReq.u16ServerAppId != u16ServerAppId )
         ||
         ( oAsyncRegisterReq.u16ClientSubId != u16ClientSubId )
      )
   {
      /* for data set identifing u8ServiceState is not evaluated */
      bRet = TRUE;
   }
   return ( bRet );

  //## end ail_tclAsyncRegisterReq::operator !=%3D5CEB19013A.body
}

ail_tclAsyncRegisterReq& ail_tclAsyncRegisterReq::operator = (const ail_tclAsyncRegisterReq& oAsyncRegisterReq)
{
  //## begin ail_tclAsyncRegisterReq::operator =%3D5CEBD70054.body preserve=yes

   if ( this != &oAsyncRegisterReq )
   {
      u16ServerAppId = oAsyncRegisterReq.u16ServerAppId;
      u16ServiceId = oAsyncRegisterReq.u16ServiceId;
      u16ClientSubId = oAsyncRegisterReq.u16ClientSubId;
      u32ToutCounter = oAsyncRegisterReq.u32ToutCounter;
   }

   return ( *this );

  //## end ail_tclAsyncRegisterReq::operator =%3D5CEBD70054.body
}

tU32 ail_tclAsyncRegisterReq::u32DecrementAndGetCounter (tU32 u32DecValue)
{
  //## begin ail_tclAsyncRegisterReq::u32DecrementAndGetCounter%3D60FB0B036C.body preserve=yes

   if ( u32ToutCounter >= u32DecValue )
   {
      u32ToutCounter = (tU32)(u32ToutCounter - u32DecValue);
   }
   else
   {
      u32ToutCounter = 0;
   }

   return ( u32ToutCounter );

  //## end ail_tclAsyncRegisterReq::u32DecrementAndGetCounter%3D60FB0B036C.body
}

tVoid ail_tclAsyncRegisterReq::vGetAdressInfo (tU16* pu16ServerAppId, tU16* pu16ServiceId, tU16* pu16SubClient) const
{
  //## begin ail_tclAsyncRegisterReq::vGetAdressInfo%3D660E720044.body preserve=yes

   *pu16ServerAppId = u16ServerAppId;
   *pu16ServiceId = u16ServiceId;
   *pu16SubClient = u16ClientSubId;

  //## end ail_tclAsyncRegisterReq::vGetAdressInfo%3D660E720044.body
}

// Class ail_tclPoolSemaphore 

ail_tclPoolSemaphore::ail_tclPoolSemaphore ()
  //## begin ail_tclPoolSemaphore::ail_tclPoolSemaphore%3EA90041015F.hasinit preserve=no
  //## end ail_tclPoolSemaphore::ail_tclPoolSemaphore%3EA90041015F.hasinit
  //## begin ail_tclPoolSemaphore::ail_tclPoolSemaphore%3EA90041015F.initialization preserve=yes
  :   u16SemId(0),
      szSemName(OSAL_NULL),
      enSemStatus(AIL_EN_POOLSEM_UNINITIALIZED),
      hSemId(OSAL_C_INVALID_HANDLE)
  //## end ail_tclPoolSemaphore::ail_tclPoolSemaphore%3EA90041015F.initialization
{
  //## begin ail_tclPoolSemaphore::ail_tclPoolSemaphore%3EA90041015F.body preserve=yes
  //## end ail_tclPoolSemaphore::ail_tclPoolSemaphore%3EA90041015F.body
}

ail_tclPoolSemaphore::ail_tclPoolSemaphore (tU16 u16NewSemId, tCString coszNewSemName, ail_tenPoolSemStatus enNewSemStatus, OSAL_tSemHandle hNewSemId)
  //## begin ail_tclPoolSemaphore::ail_tclPoolSemaphore%3EA903410123.hasinit preserve=no
  //## end ail_tclPoolSemaphore::ail_tclPoolSemaphore%3EA903410123.hasinit
  //## begin ail_tclPoolSemaphore::ail_tclPoolSemaphore%3EA903410123.initialization preserve=yes
  :   u16SemId(u16NewSemId),
      szSemName(OSAL_NULL),
      enSemStatus(enNewSemStatus),
      hSemId(hNewSemId)
  //## end ail_tclPoolSemaphore::ail_tclPoolSemaphore%3EA903410123.initialization
{
  //## begin ail_tclPoolSemaphore::ail_tclPoolSemaphore%3EA903410123.body preserve=yes
   if ( coszNewSemName != OSAL_NULL )
   {
      tU32 u32NameLength = (tU32)OSAL_u32StringLength( coszNewSemName );
      szSemName = (tString) OSAL_pvMemoryAllocate( u32NameLength+1 );
      if ( szSemName != OSAL_NULL )
      {
         OSAL_szStringNCopy( (tPVoid)szSemName, (tPCVoid)coszNewSemName, u32NameLength); //lint !e522: Expected void type, assignment, increment or decrement
         szSemName[u32NameLength]='\0';
      }
   }
  //## end ail_tclPoolSemaphore::ail_tclPoolSemaphore%3EA903410123.body
}

ail_tclPoolSemaphore::ail_tclPoolSemaphore (const ail_tclPoolSemaphore &corfoPoolSemaphore)
  //## begin ail_tclPoolSemaphore::ail_tclPoolSemaphore%3EA9043D03E5.hasinit preserve=no
  //## end ail_tclPoolSemaphore::ail_tclPoolSemaphore%3EA9043D03E5.hasinit
  //## begin ail_tclPoolSemaphore::ail_tclPoolSemaphore%3EA9043D03E5.initialization preserve=yes
  :   u16SemId(corfoPoolSemaphore.u16SemId),
      szSemName(OSAL_NULL),
      enSemStatus(corfoPoolSemaphore.enSemStatus),
      hSemId(corfoPoolSemaphore.hSemId)
  //## end ail_tclPoolSemaphore::ail_tclPoolSemaphore%3EA9043D03E5.initialization
{
  //## begin ail_tclPoolSemaphore::ail_tclPoolSemaphore%3EA9043D03E5.body preserve=yes
   if ( corfoPoolSemaphore.szSemName != OSAL_NULL )
   {
      tU32 u32NameLength = (tU32) OSAL_u32StringLength( corfoPoolSemaphore.szSemName );
      szSemName = (tString) OSAL_pvMemoryAllocate( u32NameLength+1 );
      if ( szSemName != OSAL_NULL )
      {
         OSAL_szStringNCopy( (tPVoid)szSemName, (tPCVoid)corfoPoolSemaphore.szSemName, u32NameLength); //lint !e522: Expected void type, assignment, increment or decrement
         szSemName[u32NameLength]='\0';
      }
   }
  //## end ail_tclPoolSemaphore::ail_tclPoolSemaphore%3EA9043D03E5.body
}


ail_tclPoolSemaphore::~ail_tclPoolSemaphore ()
{
  //## begin ail_tclPoolSemaphore::~ail_tclPoolSemaphore%3EAE7366032E.body preserve=yes
   if ( szSemName != OSAL_NULL )
   {
      OSAL_vMemoryFree( szSemName );
   }
   szSemName = OSAL_NULL;
  //## end ail_tclPoolSemaphore::~ail_tclPoolSemaphore%3EAE7366032E.body
}



//## Other Operations (implementation)
tBool ail_tclPoolSemaphore::operator != (const ail_tclPoolSemaphore &corfoPoolSemaphore) const
{
  //## begin ail_tclPoolSemaphore::operator !=%3EA906CC01A2.body preserve=yes
   // string-compare not needed, hSemId is unique id
   if (  u16SemId != corfoPoolSemaphore.u16SemId
      && enSemStatus != corfoPoolSemaphore.enSemStatus
      && hSemId != corfoPoolSemaphore.hSemId )
     return TRUE;
   else
      return FALSE;
  //## end ail_tclPoolSemaphore::operator !=%3EA906CC01A2.body
}

ail_tclPoolSemaphore & ail_tclPoolSemaphore::operator = (const ail_tclPoolSemaphore &corfoPoolSemaphore)
{
  //## begin ail_tclPoolSemaphore::operator =%3EA90792029C.body preserve=yes
   
   if ( this != &corfoPoolSemaphore )
   {
      u16SemId = corfoPoolSemaphore.u16SemId;
      enSemStatus = corfoPoolSemaphore.enSemStatus;

      if ( hSemId != OSAL_C_INVALID_HANDLE )
      {
         ail_vTraceMsg( TR_LEVEL_COMPONENT, "AIL-Pool-Semaphore: delete valid handle, id: %d, name: %s", hSemId, szSemName );
      }
      hSemId = corfoPoolSemaphore.hSemId;

      if ( szSemName != OSAL_NULL )
      {
         OSAL_vMemoryFree( szSemName );
         szSemName = OSAL_NULL;
      }

      if ( corfoPoolSemaphore.szSemName != OSAL_NULL )
      {
         tU32 u32NameLength = (tU32) OSAL_u32StringLength( corfoPoolSemaphore.szSemName );
         szSemName = (tString) OSAL_pvMemoryAllocate( u32NameLength+1 );
         if ( szSemName != OSAL_NULL )
         {
            OSAL_szStringNCopy( (tPVoid)szSemName, (tPCVoid)corfoPoolSemaphore.szSemName, u32NameLength); //lint !e522: Expected void type, assignment, increment or decrement
            szSemName[u32NameLength]='\0';
         }
      }
   }

   return (*this);
  //## end ail_tclPoolSemaphore::operator =%3EA90792029C.body
}

tVoid ail_tclPoolSemaphore::vSetId (tU16 u16NewSemId)
{
  //## begin ail_tclPoolSemaphore::vSetId%3EA9088402AC.body preserve=yes
   this->u16SemId = u16NewSemId;
  //## end ail_tclPoolSemaphore::vSetId%3EA9088402AC.body
}

tU16 ail_tclPoolSemaphore::u16GetId () const
{
  //## begin ail_tclPoolSemaphore::u16GetId%3EA9126B0106.body preserve=yes
   return (u16SemId);
  //## end ail_tclPoolSemaphore::u16GetId%3EA9126B0106.body
}

tVoid ail_tclPoolSemaphore::vSetName (tCString coszSemName)
{
  //## begin ail_tclPoolSemaphore::vSetName%3EA912B40106.body preserve=yes
   if ( szSemName != OSAL_NULL )
   {
      OSAL_vMemoryFree( szSemName );
      szSemName = OSAL_NULL;
   }

   if ( coszSemName != OSAL_NULL )
   {
      tU32 u32NameLength = (tU32)OSAL_u32StringLength( coszSemName );
      szSemName = (tString) OSAL_pvMemoryAllocate( u32NameLength+1 );
      if ( szSemName != OSAL_NULL )
      {
         OSAL_szStringNCopy( (tPVoid)szSemName, (tPCVoid)coszSemName, u32NameLength); //lint !e522: Expected void type, assignment, increment or decrement
         szSemName[u32NameLength]='\0';
      }
   }
  //## end ail_tclPoolSemaphore::vSetName%3EA912B40106.body
}

tString ail_tclPoolSemaphore::szGetName () const
{
  //## begin ail_tclPoolSemaphore::szGetName%3EA912F00358.body preserve=yes
   // ! the caller has to delete the memory for this string
   tString szReturnString = OSAL_NULL;

   if ( szSemName != OSAL_NULL )
   {
      tU32 u32NameLength = (tU32)OSAL_u32StringLength( szSemName );
      szReturnString = (tString) OSAL_pvMemoryAllocate( u32NameLength+1 );
      if ( szReturnString != OSAL_NULL )
      {
         OSAL_szStringNCopy( (tPVoid)szReturnString, (tPCVoid)szSemName, u32NameLength); //lint !e522: Expected void type, assignment, increment or decrement
         szReturnString[u32NameLength]='\0';
      }
   }
   return (szReturnString);
  //## end ail_tclPoolSemaphore::szGetName%3EA912F00358.body
}

tVoid ail_tclPoolSemaphore::vSetStatus (ail_tenPoolSemStatus enNewSemStatus)
{
  //## begin ail_tclPoolSemaphore::vSetStatus%3EA913A402DB.body preserve=yes
   this->enSemStatus = enNewSemStatus;
  //## end ail_tclPoolSemaphore::vSetStatus%3EA913A402DB.body
}

ail_tenPoolSemStatus ail_tclPoolSemaphore::enGetStatus () const
{
  //## begin ail_tclPoolSemaphore::enGetStatus%3EA913E80089.body preserve=yes
   return (enSemStatus);
  //## end ail_tclPoolSemaphore::enGetStatus%3EA913E80089.body
}

tVoid ail_tclPoolSemaphore::vSetHandle (OSAL_tSemHandle hNewSemId)
{
  //## begin ail_tclPoolSemaphore::vSetHandle%3EAD0EDE039D.body preserve=yes
   if (  this->hSemId   != OSAL_C_INVALID_HANDLE
      && hNewSemId      != OSAL_C_INVALID_HANDLE )
   {
      ail_vTraceMsg( TR_LEVEL_COMPONENT, "AIL-Pool-Semaphore: delete valid handle, id: %d, name: %s", this->hSemId, szSemName );
   }
   this->hSemId = hNewSemId;
  //## end ail_tclPoolSemaphore::vSetHandle%3EAD0EDE039D.body
}

OSAL_tSemHandle ail_tclPoolSemaphore::hGetHandle () const
{
  //## begin ail_tclPoolSemaphore::hGetHandle%3EAD0EDE03AD.body preserve=yes
   return (hSemId);
  //## end ail_tclPoolSemaphore::hGetHandle%3EAD0EDE03AD.body
}

// Class ail_tclWatchdogInfo 

ail_tclWatchdogInfo::ail_tclWatchdogInfo ()
  //## begin ail_tclWatchdogInfo::ail_tclWatchdogInfo%3EF2C242013B.hasinit preserve=no
      : hWdgID(OSAL_C_INVALID_HANDLE),
        ThreadID(OSAL_ERROR),
        bActive(FALSE),
        WdgInterval(0),
        MaxInterval(0),
        NextTriggerTime(0),
        MaxTriggerTime(0),
        LastTriggerTime(0),
        enTraceClass(TR_CLASS_AIL)
  //## end ail_tclWatchdogInfo::ail_tclWatchdogInfo%3EF2C242013B.hasinit
  //## begin ail_tclWatchdogInfo::ail_tclWatchdogInfo%3EF2C242013B.initialization preserve=yes
  //## end ail_tclWatchdogInfo::ail_tclWatchdogInfo%3EF2C242013B.initialization
{
  //## begin ail_tclWatchdogInfo::ail_tclWatchdogInfo%3EF2C242013B.body preserve=yes
  //## end ail_tclWatchdogInfo::ail_tclWatchdogInfo%3EF2C242013B.body
}


ail_tclWatchdogInfo::~ail_tclWatchdogInfo ()
{
  //## begin ail_tclWatchdogInfo::~ail_tclWatchdogInfo%3EF2C24B0293.body preserve=yes
  //## end ail_tclWatchdogInfo::~ail_tclWatchdogInfo%3EF2C24B0293.body
}



//## Other Operations (implementation)
tBool ail_tclWatchdogInfo::operator != (const ail_tclWatchdogInfo &corfoWatchdogInfo) const
{
  //## begin ail_tclWatchdogInfo::operator !=%3EF6F133035A.body preserve=yes
   if (  hWdgID != corfoWatchdogInfo.hWdgID
      || ThreadID != corfoWatchdogInfo.ThreadID
      || bActive != corfoWatchdogInfo.bActive
      || WdgInterval != corfoWatchdogInfo.WdgInterval
      || MaxInterval != corfoWatchdogInfo.MaxInterval
      || NextTriggerTime != corfoWatchdogInfo.NextTriggerTime
      || MaxTriggerTime != corfoWatchdogInfo.MaxTriggerTime
      || LastTriggerTime != corfoWatchdogInfo.LastTriggerTime
      || enTraceClass != corfoWatchdogInfo.enTraceClass )
      return (TRUE);
   else
      return (FALSE);
  //## end ail_tclWatchdogInfo::operator !=%3EF6F133035A.body
}

ail_tclWatchdogInfo & ail_tclWatchdogInfo::operator = (const ail_tclWatchdogInfo &corfoWatchdogInfo)
{
  //## begin ail_tclWatchdogInfo::operator =%3EF6F19D033B.body preserve=yes
   
   if ( this != &corfoWatchdogInfo )
   {
      hWdgID = corfoWatchdogInfo.hWdgID;
      ThreadID = corfoWatchdogInfo.ThreadID;
      bActive = corfoWatchdogInfo.bActive;
      WdgInterval = corfoWatchdogInfo.WdgInterval;
      MaxInterval = corfoWatchdogInfo.MaxInterval;
      NextTriggerTime = corfoWatchdogInfo.NextTriggerTime;
      MaxTriggerTime = corfoWatchdogInfo.MaxTriggerTime;
      LastTriggerTime = corfoWatchdogInfo.LastTriggerTime;
      enTraceClass = corfoWatchdogInfo.enTraceClass;
   }

   return (*this);
  //## end ail_tclWatchdogInfo::operator =%3EF6F19D033B.body
}

//## begin module%3A841C49000B.epilog preserve=yes
//## end module%3A841C49000B.epilog
