//## begin module%1.4%.codegen_version preserve=yes
//   Read the documentation to learn more about C++ code generator
//   versioning.
//## end module%1.4%.codegen_version

//## begin module%3A841C2A0197.cm preserve=no
//   %X% %Q% %Z% %W%
//## end module%3A841C2A0197.cm

//## begin module%3A841C2A0197.cp preserve=no
//## end module%3A841C2A0197.cp

//## Module: ail_Interface%3A841C2A0197; Subprogram body
//## Subsystem: Ail%3A841A8D02DE
//## Source file: e:\vasco\components\Ail\ail_Interface.cpp

//## begin module%3A841C2A0197.additionalIncludes preserve=no
//## end module%3A841C2A0197.additionalIncludes

//## begin module%3A841C2A0197.includes preserve=yes

// regular includes
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#define SYSTEM_S_IMPORT_INTERFACE_REGISTRY // for body- and entry-thread-name
#include "system_pif.h"
#define SCD_S_IMPORT_INTERFACE_GENERIC
#include "scd_if.h"
#define AIL_S_IMPORT_INTERFACE_GENERIC
#define AIL_S_IMPORT_INTERFACE_TRACE
#include "ail_if.h"

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#define FW_FI_S_IMPORT_INTERFACE_FW_AILFI_TYPES
#define FW_FI_S_IMPORT_INTERFACE_FW_AILFI_FUNCTIONIDS
#define FW_FI_S_IMPORT_INTERFACE_FW_AILFI_ERRORCODES
#define FW_FI_S_IMPORT_INTERFACE_FW_AILFI_SERVICEINFO
#include "fw_fi_if.h"

#define ERR_S_IMPORT_INTERFACE_ERRMEM
#include "err_if.h"




#if (OSAL_OS == OSAL_WINNT)
#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"
#include <crtdbg.h>
#endif

//## end module%3A841C2A0197.includes

//## begin module%3A841C2A0197.declarations preserve=no
//## end module%3A841C2A0197.declarations

//## begin module%3A841C2A0197.additionalDeclarations preserve=yes

/*************************************************************************
| defines and macros (scope: modul-local)
|*************************************************************************/

/* array size includes max. of 5 char for AppId and 1 for string termination */
#define  C_U16_GENERATION_NAME_MAX 20 

/* only enable in RELEASE version, should be less than wdg period */
#define  C_U32_REGISTER_CONF_WAIT (tU32)9000

#if OSAL_OS==OSAL_TENGINE
   #define  C_U32_SYNCH_REGISTER_CONF_WAIT_TENGINE (tU32)120000
#endif

#define  C_U32_ASYNCREG_SAMPLING_TIMEVAL (tU32 ) 500


#define  C_U16_APPSTARTUP_SIM_MSEC_WAIT   (tU16)100   
#ifndef DEBUG 
  #define  C_U16_APPSTARTUP_SIMTOUT_COUNT   (tU16)20 
#endif
#define  C_RESET_MSEC_WAIT               20000

// Possible states of variable u8ServiceRegistrationState within method bRegisterAsync().
#define AIL_C_U8_SERVICE_REGISTRATION_NOT_YET_SENT                   1
#define AIL_C_U8_SERVICE_REGISTRATION_SENT_AND_CONFIRMATION_PENDING  2
#define AIL_C_U8_SERVICE_REGISTRATION_CONFIRMED                      3

// #define AIL_USE_TRY_CATCH

/*************************************************************************
| variable definition (scope: modul-local)
|*************************************************************************/

tChar const ail_coszEntryThreadGenerationName[] = { REGSTRING_AE "_" };
tChar const ail_coszBodyThreadGenerationName[] = { REGSTRING_AB "_" };
tChar const ail_coszIntermediateQueueGenerationName[] = { "MQB_" };
tChar const ail_coszGeneralListSemaphoreGenerationName[] = { "GLS_" };

//## end module%3A841C2A0197.additionalDeclarations


// Class ail_tclAppAdapt 

ail_tclAppAdapt::ail_tclAppAdapt ()
  //## begin ail_tclAppAdapt::ail_tclAppAdapt%3A879EA300B2.hasinit preserve=no
      : hLpmInQueue(OSAL_C_INVALID_HANDLE),
        u16LpmId(AMT_C_U16_APPID_INVALID),
        hMyInQueue(OSAL_C_INVALID_HANDLE),
        u16AppId(AMT_C_U16_APPID_INVALID),
        hEntryThreadID(OSAL_ERROR),
        bEntryThreadCreated(FALSE),
        hSupervisorThreadID(OSAL_ERROR),
        u32WdgTime(0),
        hWdgTimer(OSAL_C_INVALID_HANDLE),
        bMyQueueCreated(FALSE)
  //## end ail_tclAppAdapt::ail_tclAppAdapt%3A879EA300B2.hasinit
  //## begin ail_tclAppAdapt::ail_tclAppAdapt%3A879EA300B2.initialization preserve=yes
  //## end ail_tclAppAdapt::ail_tclAppAdapt%3A879EA300B2.initialization
{
  //## begin ail_tclAppAdapt::ail_tclAppAdapt%3A879EA300B2.body preserve=yes
   
   // init trace
   ail_bInitAilTrace();

  //## end ail_tclAppAdapt::ail_tclAppAdapt%3A879EA300B2.body
}


ail_tclAppAdapt::~ail_tclAppAdapt ()
{
  //## begin ail_tclAppAdapt::~ail_tclAppAdapt%3B27302901F0.body preserve=yes
  //## end ail_tclAppAdapt::~ail_tclAppAdapt%3B27302901F0.body
}



//## Other Operations (implementation)
tBool ail_tclAppAdapt::bInitInstance (tU16 u16NewLpmId, tU16 u16MyAppId, OSAL_tThreadID hExternalDispatcherThreadID)
{
  //## begin ail_tclAppAdapt::bInitInstance%3A8791E30326.body preserve=yes

   tBool bSuccess = FALSE;

   (tVoid) hExternalDispatcherThreadID; // Parameter not used.

   // create message-queue
   if ( u16MyAppId != AMT_C_U16_APPID_INVALID )
   {
      bSuccess = scd_bCreateQueue( u16MyAppId );

      if ( bSuccess )
      {
         bMyQueueCreated = TRUE;
   
         scd_trAppInterfaceConfiguration rAppConf = { };
         tU32  u32EntryThreadPrio = 0;
         tS32  s32EntryThreadStackSize = 0;
   
         // store IDs locally (if stored in bEntryThreadSetup,
         //  vDeinitInstance wouldn't close queue-handle in case of failure)
         u16LpmId = u16NewLpmId;
         u16AppId = u16MyAppId;
   
         bSuccess = scd_bGetAppInterfaceConfiguration(u16AppId, &rAppConf);
         // access to setup information failed
   
         if ( bSuccess )
         {
            u32WdgTime = rAppConf.u32WatchdogInterval;
   
            // get entry-thread-prio and -stacksize
            if ( scd_s32GetThreadConfiguration( u16AppId, (tCString)REGSTRING_AE,
               &u32EntryThreadPrio, &s32EntryThreadStackSize ) == OSAL_ERROR )
            {
               bSuccess = FALSE;
            }
         }
   
         if ( bSuccess )
         {
            bSuccess = bEntryThreadSetup (u32EntryThreadPrio, (tU32)s32EntryThreadStackSize);
         }
   
         if ( bSuccess )
         {
            /* last thread when shutdown will be the ENTRY-thread */
            hSupervisorThreadID = hEntryThreadID;
         }
   
         if ( !bSuccess )
         {
            vDeinitInstance();
         }
      }
      else
      {
         ail_vTraceMsg(TR_LEVEL_ERRORS, "Application 0x%04x: Queue could not be created (Registry entry for app missing ?)", u16MyAppId);
      }
   }
   else
   {
      ail_vTraceMsg(TR_LEVEL_ERRORS, "Initinstance called with AppId = AMT_C_U16_APPID_INVALID");
      bSuccess = FALSE;
   }

   return(bSuccess);
  //## end ail_tclAppAdapt::bInitInstance%3A8791E30326.body
}

tVoid ail_tclAppAdapt::vDeinitInstance ()
{
  //## begin ail_tclAppAdapt::vDeinitInstance%3D3D75E20199.body preserve=yes
   // delete message-queue
   if (  u16AppId != AMT_C_U16_APPID_INVALID && bMyQueueCreated )
   {
      scd_s32DeleteQueue (u16AppId);
      bMyQueueCreated = FALSE;
   }
  //## end ail_tclAppAdapt::vDeinitInstance%3D3D75E20199.body
}

tU16 ail_tclAppAdapt::u16GetLpmId () const
{
  //## begin ail_tclAppAdapt::u16GetLpmId%3A1282CB037D.body preserve=yes
  return(u16LpmId);
  //## end ail_tclAppAdapt::u16GetLpmId%3A1282CB037D.body
}

tU16 ail_tclAppAdapt::u16GetAppId () const
{
  //## begin ail_tclAppAdapt::u16GetAppId%3A879296019D.body preserve=yes
  return(u16AppId);
  //## end ail_tclAppAdapt::u16GetAppId%3A879296019D.body
}

OSAL_tMQueueHandle ail_tclAppAdapt::hGetMyInQueue () const
{
  //## begin ail_tclAppAdapt::hGetMyInQueue%3A8792B60030.body preserve=yes
  return(hMyInQueue);
  //## end ail_tclAppAdapt::hGetMyInQueue%3A8792B60030.body
}

OSAL_tMQueueHandle ail_tclAppAdapt::hGetLpmInQueue () const
{
  //## begin ail_tclAppAdapt::hGetLpmInQueue%3A8792FE00CA.body preserve=yes
  return(hLpmInQueue);
  //## end ail_tclAppAdapt::hGetLpmInQueue%3A8792FE00CA.body
}

OSAL_tThreadID ail_tclAppAdapt::hGetSupervisorThread () const
{
  //## begin ail_tclAppAdapt::hGetSupervisorThread%3BDFD04B01B3.body preserve=yes
   return(hSupervisorThreadID);
  //## end ail_tclAppAdapt::hGetSupervisorThread%3BDFD04B01B3.body
}

#ifdef ARM_EIGHTBYTEALIGNSTACKPOINTER_PRE_FUNC
    #pragma push
    #pragma Ono_tailcall
#endif
tVoid ail_tclAppAdapt::vStartAppEntry (tVoid* pvArg)
{
   //8 Byte Align Stack Pointer
   ARM_EIGHTBYTEALIGNSTACKPOINTER

  //## begin ail_tclAppAdapt::vStartAppEntry%3A87936C010E.body preserve=yes
   ail_tclAppAdapt* poAppAdapt = (ail_tclAppAdapt*)pvArg;

   /* demanded on the object pointer, it starts the BASIC or DERIVED entry function */
   poAppAdapt->vAppEntry();

  //## end ail_tclAppAdapt::vStartAppEntry%3A87936C010E.body

   //restore original Stack Pointer
   ARM_RESTORESTACKPOINTER
}
#ifdef ARM_EIGHTBYTEALIGNSTACKPOINTER_POST_FUNC
    #pragma pop
#endif

#ifdef ARM_EIGHTBYTEALIGNSTACKPOINTER_PRE_FUNC
    #pragma push
    #pragma Ono_tailcall
#endif
tVoid ail_tclAppAdapt::vTriggerWdg (tVoid* pvArg)
{
    //## begin ail_tclAppAdapt::vTriggerWdg%3BC54BD40037.body preserve=yes

    //8 Byte Align Stack Pointer
    ARM_EIGHTBYTEALIGNSTACKPOINTER

        ail_tclAppAdapt* poAppAdapt = (ail_tclAppAdapt*)pvArg;


        amt_tclPowerMessage oPowerMessageWdg(poAppAdapt->u16LpmId, poAppAdapt->u16AppId, AMT_C_U16_PWR_WDOGTIMER, 0x00, 0x00);

        if ( oPowerMessageWdg.bIsValid() )
        {
            if (ail_bIpcMessagePost(poAppAdapt->u16LpmId, poAppAdapt->hMyInQueue, 
                                    &oPowerMessageWdg, AIL_C_U32_CCA_PRIO_MSG_POWER) != OSAL_E_NOERROR)
            {
                oPowerMessageWdg.bDelete();
                ail_vTraceMsg( TR_LEVEL_ERRORS, "Application 0x%04x: failed to send wdg-trigger-msg", poAppAdapt->u16AppId );
            }
        }
        else
        {
            ail_vTraceMsg( TR_LEVEL_ERRORS, "Application 0x%04x: wdg-trigger-msg invalid", poAppAdapt->u16AppId );
        }

    //restore original Stack Pointer
    ARM_RESTORESTACKPOINTER

    //## end ail_tclAppAdapt::vTriggerWdg%3BC54BD40037.body
}
#ifdef ARM_EIGHTBYTEALIGNSTACKPOINTER_POST_FUNC
    #pragma pop
#endif

tBool ail_tclAppAdapt::bEntryThreadSetup (tU32 u32StartupPriority, tU32 u32StackSize)
{
  //## begin ail_tclAppAdapt::bEntryThreadSetup%3A8BF7EE0067.body preserve=yes
   /* preset of return value */
   tBool bSuccess = TRUE;

   /* open your own OSAL-Queue by name convention "QueueGenerationName%d" ( %d = u16AppId ) */
   hMyInQueue = scd_OpenQueue (u16AppId);
   
   if ( u16LpmId != AMT_C_U16_APPID_INVALID )
   {
      /* open the LPM OSAL-Queue by name convention "QueueGenerationName%d" ( %d = u16LpmId ) */
      hLpmInQueue = scd_OpenQueue (u16LpmId);
   }
   else
   {
      /* usage within WrapperEnvironment, no PROXY-LPM can be addressed */ 
      hLpmInQueue = OSAL_C_INVALID_HANDLE;
   }

   // note: if creation of OSAL-Queues fails, the thread must not be started
   if ( 
         hMyInQueue != OSAL_C_INVALID_HANDLE
         &&
         ( ( u16LpmId == AMT_C_U16_APPID_INVALID )
         ||
         ( u16LpmId != AMT_C_U16_APPID_INVALID && hLpmInQueue != OSAL_C_INVALID_HANDLE ) )
      )
   {
      /* all creation has got success */
      OSAL_trThreadAttribute  rAttr;
      tChar                   szCreationName[C_U16_GENERATION_NAME_MAX] = "\0";

      if (OSALUTIL_s32SaveNPrintFormat((tString)szCreationName, 
                                       sizeof(szCreationName), 
                                       "%s%X", 
                                       ail_coszEntryThreadGenerationName, 
                                       u16AppId) != OSAL_ERROR)
      {
        rAttr.szName = szCreationName;
        rAttr.s32StackSize = (tS32)u32StackSize; 
        rAttr.u32Priority = u32StartupPriority;
        /* not defined yet? */
        rAttr.pfEntry = (OSAL_tpfThreadEntry)vStartAppEntry;
        rAttr.pvArg = (tPVoid)this;
   
        /* startup thread,
          please do not replace this by a threadSpawn
          because in this case the assigned to the variable
          hEntryThreadID is not down in the moment the thread becomes running.
          This variable is used in the context of the new thread ! 
        */

        hEntryThreadID = OSAL_ThreadCreate(&rAttr);

        if ( hEntryThreadID == OSAL_ERROR )
        {
            ail_vTraceMsg(TR_LEVEL_FATAL, "Application 0x%04x: EntryThread could not be created (Prio %d, Stack %d)", u16AppId, u32StartupPriority, u32StackSize);
            bSuccess = FALSE;
        }
        else
        {
           bEntryThreadCreated = TRUE;
           // activate the entry thread and let them running
            tS32 s32Error = OSAL_s32ThreadActivate(hEntryThreadID);
            if (s32Error != OSAL_OK)
            {
              ail_vTraceMsg(TR_LEVEL_FATAL, "Application 0x%04x: EntryThread could not be activated (Prio %d, Stack %d)", u16AppId, u32StartupPriority, u32StackSize);
              bSuccess = FALSE;
            }
        }
      }
      else
      {
        NORMAL_M_ASSERT_ALWAYS();
        bSuccess = FALSE;
      }
   }
   else
   {
      bSuccess = FALSE;
   }

   if ( !bSuccess )
   {
      if ( hMyInQueue != OSAL_C_INVALID_HANDLE )
      {
         // close my own queue
         scd_s32CloseQueue ( hMyInQueue );
         // nobody looks at this queue any longer
         hMyInQueue = OSAL_C_INVALID_HANDLE;

      }

      if ( u16LpmId != AMT_C_U16_APPID_INVALID && hLpmInQueue != OSAL_C_INVALID_HANDLE )
      {
         // close LPM-Queue
         scd_s32CloseQueue ( hLpmInQueue );
         // nobody looks at this queue any longer
         hLpmInQueue = OSAL_C_INVALID_HANDLE;
      }
   }
   return ( bSuccess );
  //## end ail_tclAppAdapt::bEntryThreadSetup%3A8BF7EE0067.body
}

// Class ail_tclAppInterfaceRestricted 

ail_tclAppInterfaceRestricted::ail_tclAppInterfaceRestricted (tU32 u32SizeOfEntryJumpStackSize, tU32 u32SizeOfEntryDestroyStackSize)
  //## begin ail_tclAppInterfaceRestricted::ail_tclAppInterfaceRestricted%3A110E160122.hasinit preserve=no
      : hGeneralListAccess(OSAL_C_INVALID_HANDLE),
        enInterfaceState(AIL_EN_N_APPLICATION_NOT_REGISTERED),
        u32LastConfirmedAppState(AMT_C_U32_STATE_UNINITALIZED),
        u32ActRequestedAppState(AMT_C_U32_STATE_UNINITALIZED),
        u32StartupInfo(0),
        u32EntryJumpStackSize(u32SizeOfEntryJumpStackSize),
        u32EntryDestroyStackSize(u32SizeOfEntryDestroyStackSize),
        bWdgUntriggered(FALSE)
  //## end ail_tclAppInterfaceRestricted::ail_tclAppInterfaceRestricted%3A110E160122.hasinit
  //## begin ail_tclAppInterfaceRestricted::ail_tclAppInterfaceRestricted%3A110E160122.initialization preserve=yes
   //preset of class attributs
   ,m_poServerApplicationList(NULL)
   ,poServiceReferenceList(NULL)
   ,poOpenedQueueList(NULL)
   ,poServiceRegistryList(NULL)
   ,poServiceSyncAnswerList(NULL) 
   ,poInternalDispatch(NULL)
   ,poPoolSemaphoreList(NULL)
   ,poWatchdogServer(NULL)
   ,bHasBodyThread(FALSE)
   ,bAutoRequestTimeOnStateChange(FALSE)
   ,_hLicenseToKill(OSAL_C_INVALID_HANDLE)
   ,u16LastDestributedRegisterId(0)
  //## end ail_tclAppInterfaceRestricted::ail_tclAppInterfaceRestricted%3A110E160122.initialization
{
  //## begin ail_tclAppInterfaceRestricted::ail_tclAppInterfaceRestricted%3A110E160122.body preserve=yes
   // set enInterfaceState to not registered, waiting for external synchronization
  //## end ail_tclAppInterfaceRestricted::ail_tclAppInterfaceRestricted%3A110E160122.body
}


ail_tclAppInterfaceRestricted::~ail_tclAppInterfaceRestricted ()
{
  //## begin ail_tclAppInterfaceRestricted::~ail_tclAppInterfaceRestricted%3A87A86E0306.body preserve=yes
   if (m_poServerApplicationList)
   {
      OSAL_DELETE m_poServerApplicationList;
      m_poServerApplicationList = NULL;
   }
   if (poServiceReferenceList)
   {
      OSAL_DELETE poServiceReferenceList;
      poServiceReferenceList = NULL;
   }
   if (poOpenedQueueList)
   {
      OSAL_DELETE poOpenedQueueList;
      poOpenedQueueList = NULL;
   }
   if (poServiceRegistryList)
   {
      OSAL_DELETE poServiceRegistryList;
      poServiceRegistryList = NULL;
   }
   if (poServiceSyncAnswerList)
   {
      OSAL_DELETE poServiceSyncAnswerList;
      poServiceSyncAnswerList = NULL;
   }
   if (poInternalDispatch)
   {
      OSAL_DELETE poInternalDispatch; //lint !e1551
      poInternalDispatch = NULL;
   }
   if (poPoolSemaphoreList)
   {
      OSAL_DELETE poPoolSemaphoreList;
      poPoolSemaphoreList = NULL;
   }
   if (poWatchdogServer)
   {
      OSAL_DELETE poWatchdogServer; //lint !e1551
      poWatchdogServer = NULL;
   }
  //## end ail_tclAppInterfaceRestricted::~ail_tclAppInterfaceRestricted%3A87A86E0306.body
}



//## Other Operations (implementation)
tBool ail_tclAppInterfaceRestricted::bCheckVersionNumber (tU16 u16RequestedServiceID, tU16 &rfu16RequestedMajorNumber, tU16 &rfu16RequestedMinorNumber, tU16 &rfu16RequestedPatchNumber)
{
  //## begin ail_tclAppInterfaceRestricted::bCheckVersionNumber%3C68CE2B0038.body preserve=yes
   tBool bRetVal = FALSE;
   // intialized version variables, so server can decide which version is wanted (for multi version fi)
   tU16  u16Major = rfu16RequestedMajorNumber;
   tU16  u16Minor = rfu16RequestedMinorNumber;
   tU16  u16Patch = rfu16RequestedPatchNumber;

   tBool bVersionNumberAvailable = FALSE;

   // Service CCA_C_U16_SRV_APPINFO is always available as it is offered by the AIL itself. 
   // Just return the actual version of the CCA_C_U16_SRV_APPINFO service.
   if (CCA_C_U16_SRV_APPINFO == u16RequestedServiceID)
   {
     u16Major = FW_AILFI_C_U16_SERVICE_MAJORVERSION;
     u16Minor = FW_AILFI_C_U16_SERVICE_MINORVERSION;
     u16Patch = 0;

     bVersionNumberAvailable = TRUE;
   }
   else
   {
     bVersionNumberAvailable = bGetServiceVersion(u16RequestedServiceID, u16Major, u16Minor, u16Patch);
   }

   if (TRUE == bVersionNumberAvailable)
   {
     if ((u16Major == rfu16RequestedMajorNumber ) &&(u16Minor >= rfu16RequestedMinorNumber))
     {
        bRetVal = TRUE;
        rfu16RequestedMajorNumber = u16Major;
        rfu16RequestedMinorNumber = u16Minor;
        rfu16RequestedPatchNumber = u16Patch;
     }
     else
     {
         ail_vTraceMsg(TR_LEVEL_ERRORS, "Application 0x%04x: Versionnumber for service 0x%04x does not match. Server provides (%d %d) but client requests (%d %d)", 
                       u16AppId, u16RequestedServiceID, u16Major, u16Minor, rfu16RequestedMajorNumber, rfu16RequestedMinorNumber);
     }
   }
   else
   {
     ail_vTraceMsg(TR_LEVEL_ERRORS, "Application 0x%04x: Server doesn't provide a matching versionnumber for service 0x%04x.(%d %d) requested", 
                   u16AppId, u16RequestedServiceID, rfu16RequestedMajorNumber, rfu16RequestedMinorNumber);
   }

   return( bRetVal );
  //## end ail_tclAppInterfaceRestricted::bCheckVersionNumber%3C68CE2B0038.body
}

tVoid ail_tclAppInterfaceRestricted::vAppEntry ()
{
  //## begin ail_tclAppInterfaceRestricted::vAppEntry%3A8D1E71014A.body preserve=yes
   tBool                   bBlocked = TRUE;
   amt_tclBaseMessage      oMsgObject;
   tU32                    u32Prio;

// registration at LPM-Proxy -> CCA-Message: POWER, Typ: Register
//   
// initialization -> initalize all your local threads
//...
// confirm initialize ready -> CCA-Message: POWER, Typ: State, Data: Initialized
//...
// while ...
// -> only OSAL-messages can be received, 
// -> first activity starts after receiving CCA-Message: POWER, Typ: SetState
   {
      ail_vTraceMsg( TR_LEVEL_COMPONENT, "Application 0x%04x: Hello RESTRICTED-world!", u16AppId );

#ifdef AIL_USE_TRY_CATCH
      try
#endif
      {
         if ( u16LpmId != AMT_C_U16_APPID_INVALID )
         {
            (tVoid)bSendCCAPowerMsg (u16LpmId, hGetLpmInQueue(), AIL_C_U32_CCA_PRIO_MSG_POWER, AMT_C_U16_PWR_APP_START_REQ, 
                              (tU32) u16AppId, (tU32) 0x00);
         }

         /* application is ready to receive a command from the supervisor */
         enInterfaceState = AIL_EN_N_APPLICATION_REGISTERED;

         if ( poInternalDispatch != NULL )
         {
            while ( bBlocked )
            {
               if ( ail_bIpcMessageWait( u16AppId, hMyInQueue, &oMsgObject, &u32Prio, OSAL_C_U32_INFINITE ) )
               {
                  bBlocked = poInternalDispatch->bDispatchCCAMessages(&oMsgObject, OSAL_C_INVALID_HANDLE, FALSE, u32Prio);
               }
            }
         }
         else
         {
            ail_vTraceMsg( TR_LEVEL_ERRORS, "Application 0x%04x: poInternalDispatch==NULL" );
         }
      }
#ifdef AIL_USE_TRY_CATCH
      catch (...)
      {
         ail_vTraceMsg( TR_LEVEL_ERRORS, "Application 0x%04x: unhandled exception occured in Entry-Thread", u16AppId );
         vOnUnhandledAilException();
      }
      
#endif
   }

   /* release all basic class objects && inform LPX of correct shutdown */
   vTerminateMySelf ();

   /* from now, ail tracing is forbidden */
   ail_vExitAilTrace();

  //## end ail_tclAppInterfaceRestricted::vAppEntry%3A8D1E71014A.body
}

tBool ail_tclAppInterfaceRestricted::bInitInstance (tU16 u16NewLpmId, tU16 u16MyAppId, OSAL_tThreadID hExternalDispatcherThreadID)
{
  //## begin ail_tclAppInterfaceRestricted::bInitInstance%3A87A81101A4.body preserve=yes

   tBool bSuccess = FALSE;

   // create message-queue
   if ( u16MyAppId != AMT_C_U16_APPID_INVALID )
   {

      if (hExternalDispatcherThreadID != OSAL_ERROR)
      {
         //Queue is already created by ASF
         bSuccess = TRUE;
      }
      else
      {
         bSuccess = bMyQueueCreated = scd_bCreateQueue( u16MyAppId );
      }

      if ( bSuccess )
      {
         /* preset of all start parameters */
         scd_trAppInterfaceConfiguration rAppConf = { };
         tU32  u32EntryThreadPrio = 0;
         tS32  s32EntryThreadStackSize = 0;
         tS32  s32Ret;
         tChar szCreationName[C_U16_GENERATION_NAME_MAX] = "\0";
   
         // store IDs locally (if stored in bEntryThreadSetup,
         //  vDeinitInstance wouldn't close queue-handle in case of failure)
         u16LpmId = u16NewLpmId;
         u16AppId = u16MyAppId;
   
         // get AIL-Configuration
         bSuccess = scd_bGetAppInterfaceConfiguration(u16AppId, &rAppConf);
   
         if ( bSuccess )
         {
            u32WdgTime = rAppConf.u32WatchdogInterval;
   
            /*bAutoRequestTimeOnStateChange = (   rAppConf.u32AutoRequestTimeOnStateChange
                                             != SCD_C_U32_DONT_AUTOREQUEST_TIME_ON_STATECHANGE );*/
   
            // TEMPORARY START
            // Following code is only temporary, parameter will be moved to aif-section in next version
            tCString coszKeyname = "APP_CONFIG";
            tCString coszParametername = "AUTOREQUEST_TIME_ON_STATECHANGE";
            tU32 u32Dummy = 0;
             if ( scd_bGetAppConfigurationValue( u16AppId, coszKeyname, coszParametername, &u32Dummy)
                  && u32Dummy != 0 )
             {
                bAutoRequestTimeOnStateChange = TRUE;
             }
             else
             {
                bAutoRequestTimeOnStateChange = FALSE;
             }
             // TEMPORARY END
   
   
            // get entry-thread-prio and -stacksize
            if ( scd_s32GetThreadConfiguration( u16AppId, (tCString)REGSTRING_AE, &u32EntryThreadPrio, &s32EntryThreadStackSize ) == OSAL_ERROR )
            {
               bSuccess = FALSE;
            }
         }
   
         if ( bSuccess )
         {
            /* create the dispatcher before starting the entry thread */
            poInternalDispatch = OSAL_NEW ail_tclInternalDispatch( this );
   
            if ( !poInternalDispatch )
            {
               bSuccess = FALSE;
            }
         }
   
         if ( bSuccess )
         {
            /* create all lists */
            poOpenedQueueList = OSAL_NEW ail_tclOpenedQueueList;
            poServiceReferenceList = OSAL_NEW ail_tclServiceReferenceList;
            poServiceRegistryList = OSAL_NEW ail_tclServiceRegistryList;
            poServiceSyncAnswerList = OSAL_NEW ail_tclServiceSyncAnswerList;
            poPoolSemaphoreList = OSAL_NEW ail_tclPoolSemaphoreList;
            m_poServerApplicationList = OSAL_NEW ail_tclServerApplicationList;
   
            if ( !(  poOpenedQueueList
                  && poServiceReferenceList
                  && poServiceRegistryList
                  && poServiceSyncAnswerList
                  && poPoolSemaphoreList
                  && m_poServerApplicationList )
               )
            /* not for all lists memory could be allocated */
            {
               bSuccess = FALSE;  
            }
         }
   
         if ( bSuccess )
         {
            // create watchdog-server for supervising of worker-threads
            poWatchdogServer = OSAL_NEW ail_tclWatchdogServer();
            if ( !poWatchdogServer )
               // memory couldn't be allocated
               bSuccess = FALSE;  
            else
               // init watchdog-server
               bSuccess = poWatchdogServer->bInit(&vWdgTimerEvent, this);
         }
   
         if ( bSuccess )
         {
            /* create semaphore to protect list access */

            if (OSALUTIL_s32SaveNPrintFormat((tString)szCreationName,
                                             sizeof(szCreationName),
                                             "%s%i", 
                                             ail_coszGeneralListSemaphoreGenerationName, 
                                             u16AppId) != OSAL_ERROR)
            {
              s32Ret = OSAL_s32SemaphoreCreate ( szCreationName, &hGeneralListAccess, (tU32)1 );

              if ( s32Ret != OSAL_OK )
              {
                 hGeneralListAccess = OSAL_C_INVALID_HANDLE;
                 bSuccess = FALSE;
              }
            }
            else
            {
              NORMAL_M_ASSERT_ALWAYS();
              bSuccess = FALSE;
            }
         }

         if ( bSuccess )
         {
            if (hExternalDispatcherThreadID == OSAL_ERROR)
            {
               /* create and start the entry thread */
               bSuccess = bEntryThreadSetup( u32EntryThreadPrio, (tU32)s32EntryThreadStackSize );
   
               if ( bSuccess )
               {
                  /* last thread when shutdown will be the ENTRY-thread */
                  hSupervisorThreadID = hEntryThreadID;
               }
            }
            else
            {
               // Take over thread ID from external dispatcher thread as entry-thread-ID.
               hEntryThreadID = hExternalDispatcherThreadID;

               // No need for the creation of an entry thread (message queue is handled by an external application (e.g. ASF)).
               // Each incomming message is processed wihtin the entry thread of the external application.
	       // Here we only have to create the connection to the LCM and set the interface state to registered.

               bSuccess = FALSE;

               if (u16LpmId != AMT_C_U16_APPID_INVALID)
               {
                  hMyInQueue = scd_OpenQueue (u16AppId);

                  if (hMyInQueue != OSAL_C_INVALID_HANDLE) {

                     hLpmInQueue = scd_OpenQueue (u16LpmId);

                     if (hLpmInQueue != OSAL_C_INVALID_HANDLE) {

                        (tVoid)bSendCCAPowerMsg (u16LpmId,
                                                 hGetLpmInQueue(), 
                                                 AIL_C_U32_CCA_PRIO_MSG_POWER,
                                                 AMT_C_U16_PWR_APP_START_REQ,
                                                 (tU32) u16AppId,
                                                 (tU32) 0x00);

                        /* application is ready to receive a command from the supervisor */
                        enInterfaceState = AIL_EN_N_APPLICATION_REGISTERED;

                        hSupervisorThreadID = hExternalDispatcherThreadID;

                        ail_vTraceMsg( TR_LEVEL_COMPONENT, "Application 0x%04x: Hello CCA-DISPATCHER-world!", u16AppId);

                        bSuccess = TRUE;
                     }
                     else
                     {
                        scd_s32CloseQueue (hMyInQueue);
                        hMyInQueue = OSAL_C_INVALID_HANDLE;
                        hLpmInQueue = OSAL_C_INVALID_HANDLE;
                     }
                  }
                  else
                  {
                     ail_vTraceMsg(TR_LEVEL_FATAL, "Application 0x%04x: bInitInstance() for CCA dispatcher failed because message queue 'mbx_%i' doesn't exist", u16AppId, u16AppId);
                     ail_vTraceMsg(TR_LEVEL_FATAL, "Application 0x%04x: Please create message queue 'mbx_%i' before calling bInitInstance() of this CCA dispatcher", u16AppId, u16AppId);
                  }
               }
            }
         }

         if ( !bSuccess )
         {
            vDeinitInstance();
         }
      }
      else
      {
         ail_vTraceMsg(TR_LEVEL_ERRORS, "Application 0x%04x: Queue could not be created (Registry entry for app missing ?)", u16MyAppId);
      }
   }
   else
   {
      ail_vTraceMsg(TR_LEVEL_ERRORS, "Initinstance called with AppId = AMT_C_U16_APPID_INVALID");
   }

   return ( bSuccess );

  //## end ail_tclAppInterfaceRestricted::bInitInstance%3A87A81101A4.body
}

tVoid ail_tclAppInterfaceRestricted::vDeinitInstance ()
{
  //## begin ail_tclAppInterfaceRestricted::vDeinitInstance%3A9D206C00D1.body preserve=yes

   tChar szCreationName[C_U16_GENERATION_NAME_MAX] = "\0";

   if (bEntryThreadCreated )
   {
      /* delete the entry thread */
      OSAL_s32ThreadDelete ( hEntryThreadID ); //lint !e522: Expected void type, assignment, increment or decrement
      hEntryThreadID = OSAL_ERROR;
   }

   /* release all protection */
   if ( hGeneralListAccess != OSAL_C_INVALID_HANDLE )
   {
      tS32 s32OsRet = OSAL_s32SemaphoreClose(hGeneralListAccess);

      if ( s32OsRet == OSAL_OK )
      {
         if (OSALUTIL_s32SaveNPrintFormat((tString)szCreationName, 
                                          sizeof(szCreationName),
                                          "%s%i", 
                                          ail_coszGeneralListSemaphoreGenerationName, 
                                          u16AppId) != OSAL_ERROR)
         {
           OSAL_s32PrintFormat((tString)szCreationName, "%s%i", ail_coszGeneralListSemaphoreGenerationName, u16AppId);
           s32OsRet = OSAL_s32SemaphoreDelete ( szCreationName );
         }
         else
         {
           NORMAL_M_ASSERT_ALWAYS();
         }
      }
      hGeneralListAccess = OSAL_C_INVALID_HANDLE;
   }
   /* free all lists */
   if ( m_poServerApplicationList )
   {
      OSAL_DELETE m_poServerApplicationList;
      m_poServerApplicationList = NULL;
   }
   if ( poOpenedQueueList )
   {
      OSAL_DELETE poOpenedQueueList;
      poOpenedQueueList = NULL;
   }
   if ( poServiceReferenceList )
   {
      OSAL_DELETE poServiceReferenceList;
      poServiceReferenceList = NULL;
   }
   if ( poServiceRegistryList ) 
   {
      OSAL_DELETE poServiceRegistryList;
      poServiceRegistryList = NULL;
   }
   if ( poServiceSyncAnswerList )
   {
      OSAL_DELETE poServiceSyncAnswerList;
      poServiceSyncAnswerList = NULL;
   }
   if ( poPoolSemaphoreList )
   {
      OSAL_DELETE poPoolSemaphoreList;
      poPoolSemaphoreList = NULL;
   }
   if ( poWatchdogServer )
   {
      poWatchdogServer->vDeinit();
      OSAL_DELETE poWatchdogServer;
      poWatchdogServer = NULL;
   }
   if ( poInternalDispatch )
   {
      /* free the dispatcher */
      OSAL_DELETE poInternalDispatch;
      poInternalDispatch = NULL;
   }

   // delete message-queue before it is closed, to clear message-queue
   if (  u16AppId != AMT_C_U16_APPID_INVALID && bMyQueueCreated )
   {
      scd_s32DeleteQueue (u16AppId);
      bMyQueueCreated = FALSE;
   }

   if ( hMyInQueue != OSAL_C_INVALID_HANDLE )
   {
      // clear my own queue
      ail_vIpcClearMessageQueue( u16AppId, hMyInQueue );
      // close my own queue
      scd_s32CloseQueue ( hMyInQueue );
      hMyInQueue = OSAL_C_INVALID_HANDLE;
   }
   if ( u16LpmId != AMT_C_U16_APPID_INVALID && hLpmInQueue != OSAL_C_INVALID_HANDLE )
   {
      // close LPM-Queue
      scd_s32CloseQueue ( hLpmInQueue );
      hLpmInQueue = OSAL_C_INVALID_HANDLE;
   }

   /* from now, ail tracing is forbidden */
   ail_vExitAilTrace();

  //## end ail_tclAppInterfaceRestricted::vDeinitInstance%3A9D206C00D1.body
}

tBool ail_tclAppInterfaceRestricted::bCreateRegisterId (tU16 u16ServiceId, tU16 u16ClientAppId, tU16 u16ClientSubId, tU16* pu16RegisterId)
{
  //## begin ail_tclAppInterfaceRestricted::bCreateRegisterId%3A110D480220.body preserve=yes

   tBool                            bSuccess = FALSE;
   tU16                             u16HighestRegNo, u16ActRegNo;
   ail_tclServiceRegistry*          poServiceRegistration;

   u16HighestRegNo = 0;

   if ( ail_bTakeListAccess( hGeneralListAccess ) )
   /* list access is sheltered */
   {
      ail_tclServiceRegistryIterator   iter(poServiceRegistryList); 

      /* it always returns a new RegisterId */
      bSuccess = TRUE;

      if ( ( u16LastDestributedRegisterId + 1 ) == AMT_C_U16_REGID_INVALID )
      /* overflow -> set new start value */
      {
         u16LastDestributedRegisterId = 0;
      }
   
      // search for the highest registration number and already existing entries
      while(!iter.bIsDone())
      {
         poServiceRegistration = &(iter.oItem());

         u16ActRegNo = poServiceRegistration->u16GetRegisterId();

         if ( u16ActRegNo > 0 && u16ActRegNo != AMT_C_U16_REGID_INVALID )
         {
            /* vaild */
            if ( u16HighestRegNo < u16ActRegNo )
            {
               u16HighestRegNo = u16ActRegNo;
            }
         }

         if ( iter.oItem().bIsDataSet( AMT_C_U16_REGID_INVALID, u16ServiceId, u16ClientAppId, u16ClientSubId) )
         {
            bSuccess = FALSE;
         }

         iter.vNext();
      }

      if ( bSuccess )
      {
         if ( !u16HighestRegNo || (u16LastDestributedRegisterId >= u16HighestRegNo) )
         /* first time or first cycle a registration is requested */
         {
            /* note: it's tested before -> can never be AMT_C_U16_REGID_INVALID */
            u16LastDestributedRegisterId++; 
            *pu16RegisterId = u16LastDestributedRegisterId;
         }
         else
         /* search for a gap in the number order 
            begining form u16LastDestributedRegisterId  */
         {
            tU16     u16ReferenceRegNo = u16LastDestributedRegisterId;
            tBool    bFound = FALSE;
            tBool    bSuccessorFound = FALSE; 

            while ( !bFound )
            {
               /* set the iterator to first element in the list */
               iter.vFirst();
               
               for ( bSuccessorFound = FALSE; !iter.bIsDone() && !bSuccessorFound; iter.vNext())
               {
                  /* search, if next number in order is awarded */
                  // get access to the element
                  poServiceRegistration = &(iter.oItem());
                  // get registration number
                  u16ActRegNo = poServiceRegistration->u16GetRegisterId();

                  if ( u16ActRegNo != AMT_C_U16_REGID_INVALID )
                  /* the element has a valid Id and is not used for internal purpose */
                  {
                     if ( u16ReferenceRegNo+1 != AMT_C_U16_REGID_INVALID )
                     {
                        if ( u16ReferenceRegNo+1 == u16ActRegNo )
                        {
                           bSuccessorFound = TRUE;
                           /* prepare reference for next run */
                           u16ReferenceRegNo = u16ActRegNo;
                        }
                     }
                     else
                     /* register number overflov detected */    
                     {
                        if ( u16ActRegNo == 1 )
                        {
                           bSuccessorFound = TRUE;
                           /* prepare reference for next run */
                           u16ReferenceRegNo = u16ActRegNo;
                        }
                     }
                  }
               }

               if ( !bSuccessorFound )
               {
                  /* a free registration number is found within awarded number range */
                  bFound = TRUE;

                  /* take next reference number access */
                  u16ReferenceRegNo++;

                  if ( u16ReferenceRegNo == AMT_C_U16_REGID_INVALID )
                  {
                     /* overflow -> set to start value */
                     u16ReferenceRegNo = 1;
                  }

                  /* release new registration number */
                  u16LastDestributedRegisterId = u16ReferenceRegNo;
                  *pu16RegisterId = u16LastDestributedRegisterId;
               }
               /* else: countinue searching on incremented RegisterId */
            }
            /*if ( !bFound )     // never reach this point
            {
               // impossible to generate -> release invalid registration number
               *pu16RegisterId = AMT_C_U16_REGID_INVALID;
               u16LastDestributedRegisterId = 0;
            }*/
         }
      }
      /* release the list access */
      ail_bReleaseListAccess( hGeneralListAccess );
   }
   return ( bSuccess );

  //## end ail_tclAppInterfaceRestricted::bCreateRegisterId%3A110D480220.body
}

tVoid ail_tclAppInterfaceRestricted::vOnNewAppState (tU32 u32OldAppState, tU32 u32AppState)
{
  //## begin ail_tclAppInterfaceRestricted::vOnNewAppState%3A10FC06005C.body preserve=yes

   vAppStateChanged( u32AppState );

   #ifdef AIL_MESSAGE_TRACE_POWER_MESSAGES
   ail_vTraceMsg( TR_LEVEL_USER_1,
      "Application 0x%04x: vOnNewAppState called, old state=0x%08X, new state=0x%08X",
      u16AppId, u32OldAppState, u32AppState );
   #endif
  //## end ail_tclAppInterfaceRestricted::vOnNewAppState%3A10FC06005C.body
} //lint !e715

tVoid ail_tclAppInterfaceRestricted::vOnNewMessage (amt_tclBaseMessage* poMessage)
{
  //## begin ail_tclAppInterfaceRestricted::vOnNewMessage%3A10FC2400EA.body preserve=yes

   /* release the message object */
   poMessage->bDelete(); 

  //## end ail_tclAppInterfaceRestricted::vOnNewMessage%3A10FC2400EA.body
}

tBool ail_tclAppInterfaceRestricted::bOnAcceptNewRegister (tU16 u16ServiceId, tU16 u16ClientAppId, tU16 u16ClientSubId, tU16* pu16RegisterId)
{
  //## begin ail_tclAppInterfaceRestricted::bOnAcceptNewRegister%3A10FCBB030E.body preserve=yes

   return ( bCreateRegisterId ( u16ServiceId, u16ClientAppId, u16ClientSubId, pu16RegisterId ) );

  //## end ail_tclAppInterfaceRestricted::bOnAcceptNewRegister%3A10FCBB030E.body
}

tVoid ail_tclAppInterfaceRestricted::vOnUnregister (tU16 u16ServiceId, tU16 u16RegisterId)
{
  //## begin ail_tclAppInterfaceRestricted::vOnUnregister%3A110A260136.body preserve=yes
   #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
   ail_vTraceMsg( TR_LEVEL_USER_2,
      "Application 0x%04x: vOnUnregister called, service-id=0x%04X, register-id=0x%04X",
      u16AppId, u16ServiceId, u16RegisterId );
   #endif
  //## end ail_tclAppInterfaceRestricted::vOnUnregister%3A110A260136.body
} //lint !e715

tVoid ail_tclAppInterfaceRestricted::vOnServiceState (tU16 u16ServiceId, tU16 u16ServerId, tU16 u16RegisterId, tU8 u8ServiceState, tU16 u16SubId)
{
  //## begin ail_tclAppInterfaceRestricted::vOnServiceState%3A10FEC801DC.body preserve=yes
   #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
   ail_vTraceMsg( TR_LEVEL_USER_2,
      "Application 0x%04x: vOnServiceState called, service-id=0x%04X, server-id=0x%04X, register-id=0x%04X, service-state=0x%02X, sub-id=0x%04X",
      u16AppId, u16ServiceId, u16ServerId, u16RegisterId, u8ServiceState, u16SubId );
   #endif
  //## end ail_tclAppInterfaceRestricted::vOnServiceState%3A10FEC801DC.body
} //lint !e715

tBool ail_tclAppInterfaceRestricted::bOnInit ()
{
  //## begin ail_tclAppInterfaceRestricted::bOnInit%3A110A400007.body preserve=yes
   tBool bSuccess = TRUE;

   return ( bSuccess );
  //## end ail_tclAppInterfaceRestricted::bOnInit%3A110A400007.body
}

tVoid ail_tclAppInterfaceRestricted::vOnApplicationClose ()
{
  //## begin ail_tclAppInterfaceRestricted::vOnApplicationClose%3ADC0C8201EE.body preserve=yes
   if ( ( AMT_C_U32_STATE_OFF == u32LastConfirmedAppState )
        ||
        ( AMT_C_U32_STATE_PREPARE_DOWNLOAD == u32LastConfirmedAppState )
      )
   {
      vApplicationCloseAcknowledge ( AIL_C_U8_APP_END_SUCCESSFUL );
   }
  //## end ail_tclAppInterfaceRestricted::vOnApplicationClose%3ADC0C8201EE.body
}

tBool ail_tclAppInterfaceRestricted::bOnWatchdog ()
{
  //## begin ail_tclAppInterfaceRestricted::bOnWatchdog%3BC6F0230378.body preserve=yes

  return ( TRUE );

  //## end ail_tclAppInterfaceRestricted::bOnWatchdog%3BC6F0230378.body
}

tBool ail_tclAppInterfaceRestricted::bOnWatchdogFailed (ail_tWdgHandle hFailedWatchdog)
{
  //## begin ail_tclAppInterfaceRestricted::bOnWatchdogFailed%3EF7FA2402F0.body preserve=yes

   // overwrite this method and return FALSE, if you don't want to restart the application
   OSAL_tThreadID ThreadID = OSAL_ERROR;
   OSAL_tMSecond WdgInterval = 0;
   OSAL_tMSecond MaxInterval = 0;

   // get info about thread
   bGetWatchdogInfo( hFailedWatchdog, ThreadID, WdgInterval, MaxInterval );

   ail_vTraceMsg( TR_LEVEL_ERRORS,
      "Application 0x%04x: Watchdog for Worker-Thread failed! Handle %d, Thread 0x%04X, Interval %d, MaxInterval %d",
      u16AppId, hFailedWatchdog, ThreadID, WdgInterval, MaxInterval );

   return (TRUE);

  //## end ail_tclAppInterfaceRestricted::bOnWatchdogFailed%3EF7FA2402F0.body
}

ail_tenCommunicationError ail_tclAppInterfaceRestricted::enSendMessageFromEntry (amt_tclServiceData** ppoMessage, OSAL_tMSecond rWaitForAnswerTime, tBool &rfbDeleteMessage)
{
   rfbDeleteMessage = TRUE;

   if (bHasBodyThread == TRUE)
      return AIL_EN_N_INVALID_THREAD_CONTEXT;

   if (  !ppoMessage
      || !(*ppoMessage)
      || !(*ppoMessage)->bIsClientMessage() )
      return AIL_EN_N_INVALID_PARAMETER;

   // Martin Kalms, 06.09.2017
   // After intense discussions with multiple CCA experts (Frank Wiedemann, Udo Brunke, Roland Jentsch) we finally come to the conclusion that there is
   // no reason to restrict the transmission of synchronous service data messages if the application is currently coming from application state OFF
   // or if the application is currently on the way to application state OFF.
   // Without this restriction an application is now able to send synchronous service data messages even if it is currently on the way to application state OFF
   // (e.g. NORMAL => OFF) or coming from application state OFF (OFF => NORMAL).
   #if 0
   // synchronous message not allowed in state OFF
   if (  u32LastConfirmedAppState == AMT_C_U32_STATE_OFF
      || u32ActRequestedAppState  == AMT_C_U32_STATE_OFF )
      return AIL_EN_N_INVALID_STATE;
   #endif

   if ( enInterfaceState < AIL_EN_N_APPLICATION_CLOSE_REQ )
   {
      /* allowed to wait on answer */
      ail_tenCommunicationError enComRet = ail_enCheckClientMailValidity( u16AppId, hGeneralListAccess, *ppoMessage, poServiceReferenceList );

      if ( enComRet == AIL_EN_N_NO_ERROR )
      {
         /* set up the synchron mechanism */
         // prepare intermediate message queue
         tChar                   szCreationName[C_U16_GENERATION_NAME_MAX] = "\0";

         if (OSALUTIL_s32SaveNPrintFormat((tString)szCreationName,
                                          sizeof(szCreationName),
                                          "%s%i", 
                                          ail_coszIntermediateQueueGenerationName, 
                                          u16AppId) != OSAL_ERROR)
         {
           OSAL_tMQueueHandle hIntermediateInQueue;

           tS32 s32Ret = OSAL_s32MessageQueueCreate(szCreationName, 100, SCD_MAILBOX_MAX_MESSAGE_LENGTH, OSAL_EN_READWRITE, &hIntermediateInQueue);
           if ( s32Ret != OSAL_OK )
           {
              ail_vTraceMsg(TR_LEVEL_FATAL, "Application 0x%04x: intermediate queue could not be created (%s)", u16AppId, ail_coszOSALError(OSAL_u32ErrorCode()));
              return AIL_EN_N_UNDEFINED_ABORT;
           }

           /* go on with all checked address parameter */
           tU16 u16TargetAppId = (*ppoMessage)->u16GetTargetAppID();
           tU16 u16ServiceId = (*ppoMessage)->u16GetServiceID();
           tU16 u16RegisterId = (*ppoMessage)->u16GetRegisterID();
           tU16 u16CmdCounter = (*ppoMessage)->u16GetCmdCounter();
           tU16 u16SourceSubId = (*ppoMessage)->u16GetSourceSubID(); 

           // now post the request message
           if ( bPostIpcMessage( u16AppId, ail_hGetReceiverQueue( poOpenedQueueList, hGeneralListAccess, u16TargetAppId), *ppoMessage, AIL_C_U32_CCA_PRIO_MSG_SERVICE_DATA_CLIENT) )
           {
              // Now message is on the way and no wait for the response.
              OSAL_tMSecond      TimeMessageSend = OSAL_ClockGetElapsedTime();
              OSAL_tMSecond      TimeRemaining   = rWaitForAnswerTime;
              amt_tclBaseMessage oMsgObject;
              tU32               u32Prio;
              rfbDeleteMessage = FALSE;

              tBool bContinueWaiting;
              do
              {
                 bContinueWaiting = TRUE;

                 if ( ail_bIpcMessageWait(u16AppId, hMyInQueue, &oMsgObject, &u32Prio, TimeRemaining) )
                 {
                    tU8 u8MsgType = oMsgObject.u8GetType();
                    if (u8MsgType == AMT_C_U8_CCAMSGTYPE_SVCDATA)
                    {
                       amt_tclServiceData oSvcDataObject(oMsgObject);

                       /* go on with all checked address parameter */
                       tU16 u16IncomingSourceAppId = oSvcDataObject.u16GetSourceAppID();
                       tU16 u16IncomingServiceId   = oSvcDataObject.u16GetServiceID();
                       tU16 u16IncomingRegisterId  = oSvcDataObject.u16GetRegisterID();
                       tU16 u16IncomingCmdCounter  = oSvcDataObject.u16GetCmdCounter();
                       tU16 u16IncomingTargetSubId = oSvcDataObject.u16GetTargetSubID(); 

                       // check if this is the message i'm waiting for
                       if ((u16TargetAppId == u16IncomingSourceAppId) &&
                          (u16ServiceId   == u16IncomingServiceId) &&
                          (u16RegisterId  == u16IncomingRegisterId) &&
                          (u16CmdCounter  == u16IncomingCmdCounter) &&
                          (u16SourceSubId == u16IncomingTargetSubId))
                       {
                          // yes, it is my awaited message
                          enComRet = AIL_EN_N_NO_ERROR;
                          bContinueWaiting = FALSE;

                          *((*ppoMessage)->prGetOSALMsgHandle()) = *(oSvcDataObject.prGetOSALMsgHandle());

                          (*ppoMessage)->pu8SharedMemBase = OSAL_pu8MessageContentGet(*((*ppoMessage)->prGetOSALMsgHandle()),
                                                                                       OSAL_EN_READWRITE);

                          (*ppoMessage)->vSetDynMsgSize((*ppoMessage)->u32GetSize());
                        
                          rfbDeleteMessage = TRUE;
                       }
                    }

                    if (bContinueWaiting == TRUE)
                    {
                       // There was an message, but it is not the message I'm waiting for
                       // save the message, calculate the remaing wait time and wait again  
                       OSAL_tMSecond TimeCurrent   = OSAL_ClockGetElapsedTime();
                       if ((TimeCurrent - TimeMessageSend) >= rWaitForAnswerTime)
                       {
                          ail_vTraceMsg( TR_LEVEL_ERRORS, "Application 0x%04x: SendMessage anwser wait timed out", u16AppId );
                          bContinueWaiting = FALSE;
                          enComRet = AIL_EN_N_ANSWER_TIMEOUT;
                       }
                       else
                       {
                          TimeRemaining = rWaitForAnswerTime - (TimeCurrent - TimeMessageSend);
                       }

                       // now save message
                       tS32 s32OSRet = OSAL_s32MessageQueuePost(hIntermediateInQueue, (tCU8*)oMsgObject.prGetOSALMsgHandle(), sizeof(OSAL_trMessage), u32Prio);
                       if ( s32OSRet == OSAL_ERROR )
                       {
                          /* impossible to save the message */
                          tU32 u32ErrorReason = OSAL_u32ErrorCode();
                          ail_vTraceMsg( TR_LEVEL_FATAL,
                             "Application 0x%04x: Post to Intermediate Queue 0x%08x has failed: error 0x%08X (%s)",
                             u16AppId, hIntermediateInQueue, u32ErrorReason, ail_coszOSALError(u32ErrorReason) );

                          // try to send the message back to the normal queue and break
                          s32OSRet = OSAL_s32MessageQueuePost(hMyInQueue, (tCU8*)oMsgObject.prGetOSALMsgHandle(), sizeof(OSAL_trMessage), u32Prio);
                          if ( s32OSRet == OSAL_ERROR )
                          {
                             u32ErrorReason = OSAL_u32ErrorCode();

                             /* impossible to put back the message */
                             u32ErrorReason = OSAL_u32ErrorCode();
                             ail_vTraceMsg( TR_LEVEL_FATAL,
                                "Application 0x%04x: Put back to normal Queue 0x%08x has failed: error 0x%08X (%s)",
                                u16AppId, hMyInQueue, u32ErrorReason, ail_coszOSALError(u32ErrorReason) );

                             if ((OSAL_E_QUEUEFULL == u32ErrorReason) || (OSAL_E_TIMEOUT == u32ErrorReason) || (OSAL_E_NOSPACE == u32ErrorReason))
                             {
                               vHandleCcaMsgQueueFull(u16AppId);
                             }
                          }
                          enComRet = AIL_EN_N_UNDEFINED_ABORT;
                          bContinueWaiting = FALSE;
                    }
                 }
                 }
                 else
                 {
                    ail_vTraceMsg( TR_LEVEL_ERRORS, "Application 0x%04x: SendMessage anwser wait timed out", u16AppId );
                    enComRet = AIL_EN_N_ANSWER_TIMEOUT;
                    bContinueWaiting = FALSE;
                 }
              }
              while (bContinueWaiting);

              // now put all remembered messages back to the normal input queue
              tBool bMessageExist;

              do
              {
                 bMessageExist = ail_bIpcMessageWait(u16AppId, hIntermediateInQueue, &oMsgObject, &u32Prio, OSAL_C_TIMEOUT_NOBLOCKING );
                 if (bMessageExist)
                 {
                    tS32 s32OSRet = OSAL_s32MessageQueuePost(hMyInQueue, (tCU8*)oMsgObject.prGetOSALMsgHandle(), sizeof(OSAL_trMessage), u32Prio);
                    if ( s32OSRet == OSAL_ERROR )
                    {
                       /* impossible to put back the message */
                       tU32 u32ErrorReason = OSAL_u32ErrorCode();
                       ail_vTraceMsg( TR_LEVEL_FATAL,
                          "Application 0x%04x: Put back to normal Queue 0x%08x has failed: error 0x%08X (%s)",
                          u16AppId, hMyInQueue, u32ErrorReason, ail_coszOSALError(u32ErrorReason) );
                    }
                 }
              }
              while (bMessageExist);
           }
           else
           {
              // message send failed, delete SyncWait from list
              ail_vTraceMsg( TR_LEVEL_ERRORS, "Application 0x%04x: send message failed, leave enSendMessage", u16AppId );
              enComRet = AIL_EN_N_POST_MESSAGE_FAILED;
           }
           // remove message queue
           s32Ret = OSAL_s32MessageQueueClose(hIntermediateInQueue);
           if ( s32Ret != OSAL_OK )
           {
              ail_vTraceMsg(TR_LEVEL_FATAL, "Application 0x%04x: intermediate queue could not be closed (%s)", u16AppId, ail_coszOSALError(OSAL_u32ErrorCode()));
           }
           OSAL_s32MessageQueueDelete(szCreationName);
           if ( s32Ret != OSAL_OK )
           {
              ail_vTraceMsg(TR_LEVEL_FATAL, "Application 0x%04x: intermediate queue could not be deleted (%s)", u16AppId, ail_coszOSALError(OSAL_u32ErrorCode()));
           }
         }
         else
         {
           NORMAL_M_ASSERT_ALWAYS();
           return AIL_EN_N_UNDEFINED_ABORT;
         }
      }
      else
      {
        TR_tenTraceLevel enTraceLevel = TR_LEVEL_FATAL;

        // Reduce the severity of the trace class for some of the communication errors
        if (AIL_EN_N_SERVICE_AVAILABILITY_LOCK == enComRet)
        {
          enTraceLevel = TR_LEVEL_ERRORS;
        }

        ail_vTraceMsg( enTraceLevel, 
                       "Source-App-ID = 0x%04x, Source-Sub-ID = %d , Target-App-ID = 0x%04x, Service-ID = 0x%04x, Register-ID = 0x%04x, Function-ID = 0x%04x, OpCode = 0x%02x: enSendMessageFromEntry() failed with error = %d.", 
                       u16AppId, 
                       (*ppoMessage)->u16GetSourceSubID(),
                       (*ppoMessage)->u16GetTargetAppID(),
                       (*ppoMessage)->u16GetServiceID(),
                       (*ppoMessage)->u16GetRegisterID(),
                       (*ppoMessage)->u16GetFunctionID(),
                       (*ppoMessage)->u8GetOpCode(),
                       enComRet );

        ail_vTraceMsg( enTraceLevel, 
                       "%s => Message object must be released from caller.", 
                       ail_coszCommunicationError(enComRet) );
      }
      return enComRet;
   }

   return AIL_EN_N_INVALID_STATE;
}

ail_tenCommunicationError ail_tclAppInterfaceRestricted::enSendMessage (amt_tclServiceData** ppoMessage, OSAL_tMSecond rWaitForAnswerTime, tBool &rfbDeleteMessage)
{
  //## begin ail_tclAppInterfaceRestricted::enSendMessage%3A1102F502F2.body preserve=yes

   // PDP3-Andres: moved position of sending the message to avoid undefined behaviour
   //              of aborting the synchronous communicaton

   ail_tenCommunicationError  enComRet = AIL_EN_N_NO_ERROR;

   // only if message is sent to server and communication is aborted
   // (by user call or by timeout) the user must not delete the message.
   rfbDeleteMessage = TRUE;

   if ( !ppoMessage || !(*ppoMessage) )
   {
      return AIL_EN_N_INVALID_PARAMETER;
   }

   if ((*ppoMessage)->bIsValid() == TRUE)
   {
     // fatal error: this function must not be called in EntryThreadContext 
     if ( hEntryThreadID == OSAL_ThreadWhoAmI() )
     {
       return enSendMessageFromEntry(ppoMessage, rWaitForAnswerTime, rfbDeleteMessage);
     }

     // test the OpType -> only for client usage allowed 
     if ( !(*ppoMessage)->bIsClientMessage() )
        return AIL_EN_N_INVALID_PARAMETER;

     // Martin Kalms, 06.09.2017
     // After intense discussions with multiple CCA experts (Frank Wiedemann, Udo Brunke, Roland Jentsch) we finally come to the conclusion that there is
     // no reason to restrict the transmission of synchronous service data messages if the application is currently coming from application state OFF
     // or if the application is currently on the way to application state OFF.
     // Without this restriction an application is now able to send synchronous service data messages even if it is currently on the way to application state OFF
     // (e.g. NORMAL => OFF) or coming from application state OFF (OFF => NORMAL).
     #if 0
     // synchronous message not allowed in state OFF
     if (  u32LastConfirmedAppState == AMT_C_U32_STATE_OFF
        || u32ActRequestedAppState  == AMT_C_U32_STATE_OFF )
        return AIL_EN_N_INVALID_STATE;
     #endif

     ail_tclServiceSyncAnswer   oSyncAnswer;
     tBool                      bSyncWaitInstalled = FALSE;
     tBool                      bDeleteSyncObjectAfterwards = FALSE;

     OSAL_tSemHandle            hSyncSem = OSAL_C_INVALID_HANDLE;
     tU16  u16TargetAppId = 0;
     tU16  u16ServiceId   = 0;
     tU16  u16RegisterId  = 0;
     tU16  u16CmdCounter  = 0;
     tU16  u16SourceSubId = 0;

     // Measure time in critical section.
     // This method can be called from worker-threads with lower priority
     // and can retard application's body- and entry-thread.
     OSAL_tMSecond TimeBeforeCriticalEntered = OSAL_ClockGetElapsedTime();

     if ( ail_bTakeListAccess( hGeneralListAccess ) )
     /* access validity check for this channel and installing
        the AnswerObject must be done under locked condition */
     {
        // Measure time in critical section.
        OSAL_tMSecond TimeAfterCriticalEntered = OSAL_ClockGetElapsedTime();

        if ( enInterfaceState < AIL_EN_N_APPLICATION_CLOSE_REQ )
        /* allowed to wait on answer */
        {
           enComRet = ail_enCheckClientMailValidity( u16AppId, OSAL_C_INVALID_HANDLE, *ppoMessage, poServiceReferenceList );

           if ( enComRet == AIL_EN_N_NO_ERROR )
           /* set up the synchron mechanism */
           {
              /* go on with all checked address parameter */
              u16TargetAppId = (*ppoMessage)->u16GetTargetAppID();
              u16ServiceId = (*ppoMessage)->u16GetServiceID();
              u16RegisterId = (*ppoMessage)->u16GetRegisterID();
              u16CmdCounter = (*ppoMessage)->u16GetCmdCounter();
              // to identify the synchronous communication client the
              // source sub id has to be stored
              u16SourceSubId = (*ppoMessage)->u16GetSourceSubID(); 
            
              if ( OSAL_C_INVALID_HANDLE != (hSyncSem = ail_hGetSemaphoreFromList(
                       u16AppId,               // app-id of this application
                       OSAL_C_INVALID_HANDLE,  // semaphore to protect list-access
                       poPoolSemaphoreList     // list of created semaphores
                       ) ) )
              {
                 if ( oSyncAnswer.bInitServiceSyncAnswerForData( hSyncSem, u16TargetAppId, u16RegisterId,
                          u16CmdCounter, u16ServiceId, u16SourceSubId, (*ppoMessage)->u16GetFunctionID(),
                          (*ppoMessage)->u8GetACT() ) )
                 {
                    /* element successfully initialized */
                    if ( poServiceSyncAnswerList != NULL )
                    {
                       // send message after semaphore GeneralListAccess is released
                       // otherwise a deadlock could occur.

                       // add the new answer object to the answer list
                       poServiceSyncAnswerList->vAdd(oSyncAnswer);
                       bSyncWaitInstalled = TRUE;
                    }
                    else
                    {
                       oSyncAnswer.vDeinitServiceSyncAnswer();
                       ail_bReleaseSemaphoreInList(OSAL_C_INVALID_HANDLE,hSyncSem,poPoolSemaphoreList);
                       enComRet = AIL_EN_N_UNDEFINED_ABORT;
                    }
                 }
                 else
                 {
                    /* initializing of "WaitForAnswer"-object failed */
                    oSyncAnswer.vDeinitServiceSyncAnswer();
                    ail_bReleaseSemaphoreInList(OSAL_C_INVALID_HANDLE, hSyncSem, poPoolSemaphoreList);
                    enComRet = AIL_EN_N_UNDEFINED_ABORT;
                 }
              }
              else
              {
                 /* initializing of "WaitForAnswer"-object failed */
                 enComRet = AIL_EN_N_UNDEFINED_ABORT;
              }
           }
           else
           {
              /* trouble on service state or access denied */
              /* note: enComRet already set */
           }
        }
        else
        {
           /* prevents waiting on error reset */
           enComRet = AIL_EN_N_UNDEFINED_ABORT;
        }

        if ( bSyncWaitInstalled )
        {
           // prepare to send the request message
           bDeleteSyncObjectAfterwards = TRUE;

           #ifdef AIL_MESSAGE_TRACE_EACH_MESSAGE
           ail_vTraceMsg( TR_LEVEL_USER_4,
              "Application 0x%04x: is going to send a message! " \
              "Receiver %d ServiceId %d RegisterId %d FunctionId %d having the OPTYPE %d",
              u16AppId,
              (*ppoMessage)->u16GetTargetAppID(),
              (*ppoMessage)->u16GetServiceID(),
              (*ppoMessage)->u16GetRegisterID(),
              (*ppoMessage)->u16GetFunctionID(),
              (*ppoMessage)->u8GetOpCode() );
           #endif

           // now post synchron message
           if ( !bPostIpcMessage( u16AppId, 
                                  ail_hGetReceiverQueue( poOpenedQueueList , OSAL_C_INVALID_HANDLE , u16TargetAppId), 
                                  *ppoMessage , AIL_C_U32_CCA_PRIO_MSG_SERVICE_DATA_CLIENT ) )
           {
              // message send failed, delete SyncWait from list
              ail_vTraceMsg( TR_LEVEL_ERRORS, "Application 0x%04x: send message failed, delete SyncWait from list", u16AppId );
            
              enComRet = AIL_EN_N_POST_MESSAGE_FAILED;
           }
           else
           {
             // The message was sent successfully. Invalidate the message object to avoid further accesses 
             // to it from the side of the sender. After a successful message transmission the message 
             // must be under the control of the receiver (and ONLY the receiver).
             (*ppoMessage)->vInvalidate();
           }
        }

        // Measure time inside critical section.
        OSAL_tMSecond TimeInsideCritical = OSAL_ClockGetElapsedTime() - TimeAfterCriticalEntered;

        /* release the list access */
        ail_bReleaseListAccess( hGeneralListAccess );


        // Measure time outside critical section.
        OSAL_tMSecond TimeOutsideCritical = OSAL_ClockGetElapsedTime() - TimeBeforeCriticalEntered;

        TR_tenTraceLevel enTraceLevel = (TimeOutsideCritical>1000)?TR_LEVEL_ERRORS:(TimeOutsideCritical>200)?TR_LEVEL_SYSTEM_MIN:TR_LEVEL_USER_2;
        ail_vTraceMsg( enTraceLevel,
           "Application 0x%04x,%d: enSendMessage, time in critical section inside: %d ms, outside: %d ms",
                 u16AppId, u16SourceSubId, TimeInsideCritical, TimeOutsideCritical );

     }
     else
     {
        /* undefined list access failure */
        enComRet = AIL_EN_N_UNDEFINED_ABORT;
     }

     if( bSyncWaitInstalled )
     {
        // wait for answer message
        ail_tenSyncAnswerType   enWaitRet = AIL_EN_U16_SYNC_UNDEFINED_ABORT;
        tS32                    s32Ret;

        s32Ret = OSAL_s32SemaphoreWait( hSyncSem, rWaitForAnswerTime );

        if ( s32Ret != OSAL_OK )
        {
           /* shit has happened */
           tU32 u32OSALError = OSAL_u32ErrorCode();

           if ( u32OSALError == OSAL_E_TIMEOUT )
           {
              enComRet = AIL_EN_N_ANSWER_TIMEOUT;
           }
           else
           /* other kind of trouble has happened */
           {
              enComRet = AIL_EN_N_UNDEFINED_ABORT;
           }

           // the server has to delete the message
           rfbDeleteMessage = FALSE;

           // SemaphoreWait failed, delete SyncWait from list
           ail_vTraceMsg( TR_LEVEL_ERRORS, "Application 0x%04x: sync wait failed", u16AppId );
        }
        else
        {
           /* everthing is alright */
           tBool bFound = FALSE;

           if ( ail_bTakeListAccess( hGeneralListAccess ) )
           /* list access is sheltered */
           {
              if ( poServiceSyncAnswerList != NULL )
              {
                 ail_tclServiceSyncAnswerIterator iter(poServiceSyncAnswerList);

                 for ( ; !bFound && !iter.bIsDone(); iter.vNext())
                 {
                    if ( iter.oItem().bIsAnswer( &enWaitRet, (*ppoMessage)/* == &oBaseMessage */, hSyncSem))
                    {
                       /* found the reference */
                       bFound = TRUE;
                       break;
                    }
                 }

                 if ( bFound )
                 {
                    /* "nRemove"-operation influences the validity of the iterator */
                    poServiceSyncAnswerList->nRemove( iter.oItem() );
                    bDeleteSyncObjectAfterwards = FALSE; // SyncAnswer-object deleted, not needed to do it twice
                 }
              }
              else
              {
                 ail_vTraceMsg( TR_LEVEL_USER_3, "Application 0x%04x: poServiceSyncAnswerList==NULL", u16AppId );
              }

              /* release the list access */
              ail_bReleaseListAccess( hGeneralListAccess );
           }

           if ( bFound )
           {
              /* "WaitReturn" is valid */ 
              switch ( enWaitRet )
              {
                 case AIL_EN_U16_SYNC_MESSAGE_ANSWER:
                 {
                    #ifdef AIL_MESSAGE_TRACE_EACH_MESSAGE
                    ail_vTraceMsg( TR_LEVEL_USER_4,
                       "Application 0x%04x: enSendMessage() => Synchronous response received, transmission successful",
                       u16AppId);
                    #endif

                    enComRet = AIL_EN_N_NO_ERROR;
                    break;
                 }
                 case AIL_EN_U16_SYNC_SERVICE_NOT_AVAILABLE:
                 {
                    // set ppoMessage to invalid
                    (*ppoMessage)->pu8SharedMemBase = OSAL_NULL;

                    // ppoMessage is invalid, don't delete
                    rfbDeleteMessage = FALSE;

                    enComRet = AIL_EN_N_SERVICE_AVAILABILITY_LOCK;
                    break;
                 }
                 case AIL_EN_U16_SYNC_REGISTRATION_INVALID:
                 {
                    // set ppoMessage to invalid
                    (*ppoMessage)->pu8SharedMemBase = OSAL_NULL;

                    // ppoMessage is invalid, don't delete
                    rfbDeleteMessage = FALSE;

                    enComRet = AIL_EN_N_REGISTRATION_DENIED;
                    break;
                 }
                 case AIL_EN_U16_SYNC_UNDEFINED_ABORT:
                 case AIL_EN_U16_SYNC_UNINITIALIZED:
                 default:
                 {
                    // ppoMessage is invalid, don't delete
                    rfbDeleteMessage = FALSE;

                    // in any unexpected return
                    enComRet = AIL_EN_N_UNDEFINED_ABORT;
                    break;
                 }
              }
           }
           else
           {
              /* no belonged object found */
              // the server has to delete the message
              rfbDeleteMessage = FALSE;

              enComRet = AIL_EN_N_UNDEFINED_ABORT;
           }
        }
   
        // deinit the origin object on your stack,
        //  WaitSemphore will be released
        oSyncAnswer.vDeinitServiceSyncAnswer();
        ail_bReleaseSemaphoreInList(hGeneralListAccess, hSyncSem, poPoolSemaphoreList);

        if ( bDeleteSyncObjectAfterwards )
        {
           if ( ail_bTakeListAccess( hGeneralListAccess ) )
           {
              // list access is sheltered
              if ( poServiceSyncAnswerList != NULL )
              {
                 // search SyncWait object
                 ail_tclServiceSyncAnswerIterator iter(poServiceSyncAnswerList);

                 tBool bFound = FALSE;

                 for ( ; !bFound && !iter.bIsDone(); iter.vNext())
                 {
                    if ( iter.oItem().bIsWaitForData( u16TargetAppId,u16RegisterId,u16CmdCounter,u16ServiceId,u16SourceSubId))
                    {
                       // found the reference
                       bFound = TRUE;
                       break; // use break, otherwise iter.vNext will be called and iter could be invalid
                    }
                 }

                 if ( bFound )
                 {
                    // "nRemove"-operation influences the validity of the iterator
                    poServiceSyncAnswerList->nRemove( iter.oItem() );
                 }
              }
              else
              {
                 ail_vTraceMsg( TR_LEVEL_USER_3,"Application 0x%04x: poServiceSyncAnswerList==NULL", u16AppId );
              }

              // release the list access
              ail_bReleaseListAccess( hGeneralListAccess );
           }
        }
     }
  
     if ( enComRet != AIL_EN_N_NO_ERROR )
     {
        TR_tenTraceLevel enTraceLevel = TR_LEVEL_FATAL;

        // Reduce the severity of the trace class for some of the communication errors
        if (AIL_EN_N_SERVICE_AVAILABILITY_LOCK == enComRet)
        {
          enTraceLevel = TR_LEVEL_ERRORS;
        }

        ail_vTraceMsg( enTraceLevel, 
                       "Source-App-ID = 0x%04x, Source-Sub-ID = %d , Target-App-ID = 0x%04x, Service-ID = 0x%04x, Register-ID = 0x%04x, Function-ID = 0x%04x, OpCode = 0x%02x: enSendMessage() failed with error = %d.", 
                       u16AppId, 
                       (*ppoMessage)->u16GetSourceSubID(),
                       (*ppoMessage)->u16GetTargetAppID(),
                       (*ppoMessage)->u16GetServiceID(),
                       (*ppoMessage)->u16GetRegisterID(),
                       (*ppoMessage)->u16GetFunctionID(),
                       (*ppoMessage)->u8GetOpCode(),
                       enComRet );

        ail_vTraceMsg( enTraceLevel, 
                       "%s => Message object must be released from caller.", 
                       ail_coszCommunicationError(enComRet) );
     }
   }
   else // if ((*poMessage)->bIsValid() == TRUE)
   {
     rfbDeleteMessage = FALSE; // Don't tell the sender to delete an already invalid message object.

     enComRet = AIL_EN_N_INVALID_MESSAGE_OBJECT;

     ail_vTraceMsg( TR_LEVEL_FATAL, 
                    "Application 0x%04x,%d : enSendMessage() failed -> %s. This message might have already been sent. Don't send the same message object twice.", 
                    u16AppId, 
                    (*ppoMessage)->u16GetSourceSubID(), 
                    ail_coszCommunicationError(enComRet) );

     ail_vTraceMsg( TR_LEVEL_FATAL, 
                    "Message object : Source-App-ID = 0x%04x, Source-Sub-ID = %d , Target-App-ID = 0x%04x, Service-ID = 0x%04x, Register-ID = 0x%04x, Function-ID = 0x%04x, OpCode = 0x%02x.",
                    u16AppId, 
                    (*ppoMessage)->u16GetSourceSubID(),
                    (*ppoMessage)->u16GetTargetAppID(),
                    (*ppoMessage)->u16GetServiceID(),
                    (*ppoMessage)->u16GetRegisterID(),
                    (*ppoMessage)->u16GetFunctionID(),
                    (*ppoMessage)->u8GetOpCode());
   }

   return ( enComRet );

  //## end ail_tclAppInterfaceRestricted::enSendMessage%3A1102F502F2.body
} //lint !e818: Pointer parameter 'ppoMessage' could be declared as pointing to const

#if 0
// KSM2HI, 15.02.2017
// Commented out this method because it doesn't work as intended. There are two issues with this method.
// The clone it creates for each transmission doesn't create a new payload in the shared memory but only references the message content of the original message.
// This can't work because the first of the multiple receivers would intentionally delete the message content and all subsequent receivers would find a empty message which would lead to an error.
// Additionally there is a comparison between the message content of the original and the cloned message and if equal, the message is not transmitted.
// The comparison must always result to true because the implementation lets the clone reference to the original message content.
// As this method enPostBroadcast() can't work and is currently not used by any CCA client, I am commenting it out to avoid a usage.
// I don't want to spend any time in making an unused method work.
ail_tenCommunicationError ail_tclAppInterfaceRestricted::enPostBroadcast (amt_tclServiceData* poMessage)
{
  //## begin ail_tclAppInterfaceRestricted::enPostBroadcast%3A10FDCC011C.body preserve=yes

   ail_tenCommunicationError  enComRet = AIL_EN_N_NO_ERROR;

   // calling in server role -> only a server is allowed to broadcast an information
   if (  !poMessage
      || !poMessage->bIsServerMessage() )
      return AIL_EN_N_INVALID_PARAMETER;

   if ( ail_bTakeListAccess( hGeneralListAccess ) )
   {
      /* list access is sheltered */
      ail_tclServiceRegistryIterator   iter(poServiceRegistryList);
      tU16                             u16ServiceId, u16RefServiceId, u16Receiver, u16RegisterId;
      tBool                            bSuccess = FALSE, bEntryFound = FALSE;

      /* all registered clients for this service must be informed */
      u16RefServiceId = poMessage->u16GetServiceID();

      #ifdef AIL_MESSAGE_TRACE_EACH_MESSAGE
      ail_vTraceMsg( TR_LEVEL_USER_3,
         "Application 0x%04x: is going to post a broadcast-message! " \
         "ServiceId %d RegisterId %d FunctionId %d having the OPTYPE %d",
         u16AppId,
         poMessage->u16GetServiceID(),
         poMessage->u16GetRegisterID(),
         poMessage->u16GetFunctionID(),
         poMessage->u8GetOpCode() );
      #endif

      for ( ; !iter.bIsDone() && enComRet == AIL_EN_N_NO_ERROR; iter.vNext())
      {
         u16ServiceId = iter.oItem().u16GetServiceId();
         u16RegisterId = iter.oItem().u16GetRegisterId();

         if ( u16RegisterId != AMT_C_U16_REGID_INVALID && u16RefServiceId == u16ServiceId )
         {
            /* using valid data set -> clone the message and add the address parameters now */
            amt_tclServiceData* poClonedMessage = NULL;
            bEntryFound = TRUE; /* there is somebody to be informed */

            poClonedMessage = (amt_tclServiceData*)poMessage->poClone(); //lint !e1774: Could use dynamic_cast

            if ( NULL != poClonedMessage )
            {
               if ( !poClonedMessage->bIsValid() )
               {
                  /* message could not be cloned, may be memory error */
                  OSAL_DELETE poClonedMessage;
                  poClonedMessage = NULL;
                  enComRet = AIL_EN_N_UNDEFINED_ABORT;
               }

               if ( enComRet == AIL_EN_N_NO_ERROR && 
                     poClonedMessage->pu8GetSharedMemBase() == poMessage->pu8GetSharedMemBase() )
               {
                  /* clone function not implemented for derivated class */
                  OSAL_DELETE poClonedMessage;
                  poClonedMessage = NULL;
                  enComRet = AIL_EN_N_UNDEFINED_ABORT;
               }

               if (  enComRet == AIL_EN_N_NO_ERROR && poClonedMessage != NULL )
               {
                  poClonedMessage->vSetSourceAppID( u16AppId );
                  u16Receiver = iter.oItem().u16GetClientAppId();
                  poClonedMessage->vSetTargetAppID( u16Receiver );
                  poClonedMessage->vSetRegisterID( iter.oItem().u16GetRegisterId() );
                  poClonedMessage->vSetTargetSubID( iter.oItem().u16GetClientSubId() ); //udo

                  /* post this message to a client */  
                  bSuccess = bPostIpcMessage( u16AppId,
                        ail_hGetReceiverQueue(poOpenedQueueList, OSAL_C_INVALID_HANDLE, u16Receiver),
                        poClonedMessage, AIL_C_U32_CCA_PRIO_MSG_SERVICE_DATA_SERVER);

                  if ( !bSuccess )
                  {
                     enComRet = AIL_EN_N_POST_MESSAGE_FAILED;
                  }
                  /* delete  cloned  */
                  OSAL_DELETE poClonedMessage;
                  poClonedMessage = OSAL_NULL;
               }
            }
            else
            {
               /* message has not an own clone function, default not possible  */
               enComRet = AIL_EN_N_NOT_ALL_INFORMED;
            }
         }
      }
      if ( enComRet == AIL_EN_N_NO_ERROR && !bEntryFound )
      {
         /* there was nobody who could be informed */
         enComRet = AIL_EN_N_NOT_SEND;
      }
      /* release the list access */
      ail_bReleaseListAccess( hGeneralListAccess );
   }
   else
   {
      /* list access failed */
      enComRet = AIL_EN_N_UNDEFINED_ABORT;
   }

   // release always the origin message object 
   // poMessage->bDelete();

   return ( enComRet );

  //## end ail_tclAppInterfaceRestricted::enPostBroadcast%3A10FDCC011C.body
} //lint !e818: Pointer parameter 'poMessage' could be declared as pointing to const
#endif

ail_tenCommunicationError ail_tclAppInterfaceRestricted::enPostMessage (amt_tclServiceData* poMessage, tBool bDeleteMsgOnNoSuccess, tU32 u32Prio)
{
  //## begin ail_tclAppInterfaceRestricted::enPostMessage%3A11044E0121.body preserve=yes

   ail_tenCommunicationError  enComRet = AIL_EN_N_NO_ERROR;
   tBool                      bSuccess;

   if (poMessage->bIsValid() == TRUE)
   {
     tU16  u16Sender = poMessage->u16GetSourceAppID();
     tU16  u16Receiver = poMessage->u16GetTargetAppID();

     if ( !(u16AppId == u16Receiver && u16Sender == u16Receiver) )
     {
        /* not a LoopBack-Message -> its validity must be checked */
        if (poMessage->bIsServerMessage())
        {
           /* this is a server answer -> refer to service reference table */
           /* server and client role can be identified by the optype */
           enComRet = ail_enCheckServerMailValidity(u16AppId, hGeneralListAccess, poMessage, poServiceRegistryList);
        }
        else
        {
           /* a client is going to send a command to the server -> refer to service reference */
           enComRet = ail_enCheckClientMailValidity( u16AppId, hGeneralListAccess, poMessage, poServiceReferenceList);
        }
     }
     // Loopback-msgs will be blocked, if application is already closed.
     // We have discovered some problems with osal-timers, which were not stopped
     // on state-change to off. These could try to send loopback-msgs after
     // AIL is already closed. This can lead to unexpected behavior.
     // It's not sure to request enInterfaceState in this case because variables
     // could already be invalid, but there is no other way.
     else if ( enInterfaceState == AIL_EN_N_APPLICATION_CLOSED )
     {
        // remark: no trace available
        enComRet = AIL_EN_N_UNDEFINED_ABORT;
     }

     if ( enComRet == AIL_EN_N_NO_ERROR )
     {

        #ifdef AIL_MESSAGE_TRACE_EACH_MESSAGE
        if ( ail_bIsTraceActive(TR_LEVEL_USER_4) )
        {
        ail_vTraceMsg( TR_LEVEL_USER_4,
           "Application 0x%04x: is going to post a message! " \
           "Receiver %d ServiceId %d RegisterId %d FunctionId %d having the OPTYPE %d",
           u16AppId,
           poMessage->u16GetTargetAppID(),
           poMessage->u16GetServiceID(),
           poMessage->u16GetRegisterID(),
           poMessage->u16GetFunctionID(),
           poMessage->u8GetOpCode() );
        }
        #endif

        /* note: in case of no success,
           the caller have to release the message */ 
        bSuccess = bPostIpcMessage( u16AppId,
           ail_hGetReceiverQueue(poOpenedQueueList, hGeneralListAccess, poMessage->u16GetTargetAppID()),
           poMessage, u32Prio);

        if ( !bSuccess )
        {
           enComRet = AIL_EN_N_POST_MESSAGE_FAILED;
        }
        else
        {
           // The message was sent successfully. Invalidate the message object to avoid further accesses 
           // to it from the side of the sender. After a successful message transmission the message 
           // must be under the control of the receiver (and ONLY the receiver).
           poMessage->vInvalidate();
        }
     }
     else
     {
        TR_tenTraceLevel enTraceLevel = TR_LEVEL_FATAL;

        // Reduce the severity of the trace class for some of the communication errors
        if ((AIL_EN_N_SERVICE_AVAILABILITY_LOCK          == enComRet) ||
            (AIL_EN_N_REGISTRATION_DENIED_NOT_REGISTERED == enComRet)   )
        {
          enTraceLevel = TR_LEVEL_ERRORS;
        }

        /* logical access error */
        // the caller have to release the message object 

        ail_vTraceMsg( enTraceLevel, 
                       "Source-App-ID = 0x%04x, Source-Sub-ID = %d , Target-App-ID = 0x%04x, Service-ID = 0x%04x, Register-ID = 0x%04x, Function-ID = 0x%04x, OpCode = 0x%02x: enPostMessage() failed with error = %d.", 
                       u16AppId, 
                       poMessage->u16GetSourceSubID(),
                       poMessage->u16GetTargetAppID(),
                       poMessage->u16GetServiceID(),
                       poMessage->u16GetRegisterID(),
                       poMessage->u16GetFunctionID(),
                       poMessage->u8GetOpCode(),
                       enComRet );

        ail_vTraceMsg( enTraceLevel, 
                       "%s => Message object must be released from caller.", 
                       ail_coszCommunicationError(enComRet) );

        enComRet = AIL_EN_N_NOT_SEND;
     }

     if ( enComRet != AIL_EN_N_NO_ERROR )
     {
        if ( bDeleteMsgOnNoSuccess == TRUE )
        {
           /* 
              if the user has given the permission,
              release the message object in case of error
           */
           poMessage->bDelete();
        }
     }
   }
   else
   {
     enComRet = AIL_EN_N_INVALID_MESSAGE_OBJECT;

     ail_vTraceMsg( TR_LEVEL_FATAL, 
                    "Application 0x%04x,%d : enPostMessage() failed -> %s. This message might have already been sent. Don't send the same message object twice.", 
                    u16AppId, 
                    poMessage->u16GetSourceSubID(), 
                    ail_coszCommunicationError(enComRet) );

     ail_vTraceMsg( TR_LEVEL_FATAL, 
                    "Message object : Source-App-ID = 0x%04x, Source-Sub-ID = %d , Target-App-ID = 0x%04x, Service-ID = 0x%04x, Register-ID = 0x%04x, Function-ID = 0x%04x, OpCode = 0x%02x.",
                    u16AppId, 
                    poMessage->u16GetSourceSubID(),
                    poMessage->u16GetTargetAppID(),
                    poMessage->u16GetServiceID(),
                    poMessage->u16GetRegisterID(),
                    poMessage->u16GetFunctionID(),
                    poMessage->u8GetOpCode());
   }

   return ( enComRet );
  //## end ail_tclAppInterfaceRestricted::enPostMessage%3A11044E0121.body
}

tU16 ail_tclAppInterfaceRestricted::u16RegisterService (tU16 u16ServiceId, tU16 u16ServiceMajorVersion, tU16 u16ServiceMinorVersion, tU16 u16SourceSubID, tU16 u16ServerAppId)
{
  //## begin ail_tclAppInterfaceRestricted::u16RegisterService%3A10FE880216.body preserve=yes

   tU16                 u16RegisterId = AMT_C_U16_REGID_INVALID;
   tBool                bSyncWaitInstalled = FALSE;
   OSAL_tSemHandle      hSyncSem;

#if defined DEBUG
   OSAL_tMSecond        rWaitForAnswerTime = C_U32_REGISTER_CONF_WAIT;
#else
   OSAL_tMSecond        rWaitForAnswerTime = C_U32_REGISTER_CONF_WAIT;
#endif

#if OSAL_OS==OSAL_TENGINE
   rWaitForAnswerTime = C_U32_SYNCH_REGISTER_CONF_WAIT_TENGINE; /** workaround to avoid timeouts on slow tengine-targets */
#endif 

   #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
     ail_vTraceMsg(TR_LEVEL_USER_2, "Application 0x%04x: u16RegisterService() called. u16ServiceId=0x%04X, u16ServiceMajorVersion=0x%04X, u16ServiceMinorVersion=0x%04X, u16SourceSubID=0x%04X, u16ServerAppId=0x%04X",
                   u16AppId, u16ServiceId, u16ServiceMajorVersion, u16ServiceMinorVersion, u16SourceSubID, u16ServerAppId);
   #endif
   
   if ( hEntryThreadID == OSAL_ThreadWhoAmI() )
   {
      /* fatal error: this function must not be called in EntryThreadContext */
      return ( u16RegisterId ); 
   }

   if ( poServiceSyncAnswerList == NULL )
   {
      return (u16RegisterId);
   }

   if ( u16ServerAppId == AMT_C_U16_APPID_INVALID )
   {
      tBool          bRet;
      tU32           ulNbrOfAppInfos = 1;   
      trScdAppInfo   rScdAppInfo = { };

      bRet = scd_bGetAppIdFromServiceId(u16ServiceId, &ulNbrOfAppInfos, &rScdAppInfo);

      if ( bRet == TRUE && ulNbrOfAppInfos == 1 )
      {
         /* no error has occured and an entry was found */
         u16ServerAppId = rScdAppInfo.u16AppId;
      }
      else
      {
         /* fatal error: this service can't be found in registry */
         return ( u16RegisterId ); 
      }
   }
   /* set up the synchron mechanism */
   ail_tclServiceSyncAnswer oSyncAnswer;

   if ( OSAL_C_INVALID_HANDLE != (hSyncSem = ail_hGetSemaphoreFromList(
            u16AppId,            // app-id of this application
            hGeneralListAccess,  // semaphore to protect list-access
            poPoolSemaphoreList  // list of created semaphores
            ) ) )
   {
      if ( oSyncAnswer.bInitServiceSyncAnswerForReg( hSyncSem , u16ServerAppId, u16ServiceId, u16SourceSubID) )
      {
        // expected answer must send to client sub
        /* element successfully initialized */
         if ( ail_bTakeListAccess( hGeneralListAccess ) )
         {
            /* list access is sheltered */
            if ( enInterfaceState < AIL_EN_N_APPLICATION_CLOSE_REQ )
            {
               /* allowed to wait on answer */
               /* add the new answer object to the answer list */        
               poServiceSyncAnswerList->vAdd(oSyncAnswer);

               bSyncWaitInstalled = TRUE;
            }
            else
            {  
               /* prevents waiting on error reset */
               /* registration stays invalid */
               oSyncAnswer.vDeinitServiceSyncAnswer();
               ail_bReleaseSemaphoreInList(OSAL_C_INVALID_HANDLE,hSyncSem,poPoolSemaphoreList);
            }

            /* release the list access */
            ail_bReleaseListAccess( hGeneralListAccess );

         }
         else
         {
            /* undefined list access failure */
            /* registration stays invalid */
            oSyncAnswer.vDeinitServiceSyncAnswer();
            ail_bReleaseSemaphoreInList(hGeneralListAccess,hSyncSem,poPoolSemaphoreList);
         }
      }
   }

   if ( bSyncWaitInstalled )
   {
      amt_tclBaseMessage      oBaseMessage;
      ail_tenSyncAnswerType   enWaitRet = AIL_EN_U16_SYNC_UNDEFINED_ABORT;
      tBool                   bFound = FALSE;
      tBool                   bMsgPostSuccess = TRUE;

      /* create a new message object */
      amt_tclServiceRegister oMessageServiceRegister( u16AppId, u16ServerAppId, u16ServiceId, u16ServiceMajorVersion, u16ServiceMinorVersion, u16SourceSubID);
 
      if ( oMessageServiceRegister.bIsValid() )
      {
         // get message-queue to server
         OSAL_tMQueueHandle hMQ = OSAL_C_INVALID_HANDLE;
         hMQ = scd_OpenQueue(u16ServerAppId);   // do not use OpenedQueueList,
         // 'cause this is possibly the only message to this client if
         // server doesn't exist
         if ( hMQ != OSAL_C_INVALID_HANDLE )
         {
            /* post this message to the server */  
            bMsgPostSuccess = bPostIpcMessage(u16AppId,hMQ, (amt_tclBaseMessage*) &oMessageServiceRegister, AIL_C_U32_CCA_PRIO_MSG_SERVICE_REGISTER);

            // close message-queue to client
            scd_s32CloseQueue(hMQ);
         }
         else
         {
            bMsgPostSuccess = FALSE;

            // else couldn't send message
            ail_vTraceMsg( TR_LEVEL_ERRORS,
               "Application 0x%04x,%d: couldn't send service-register-msg to app 0x%04x for Service 0x%04x, " \
               "open queue failed, possibly application doesn't exist",
               u16AppId, u16SourceSubID, u16ServerAppId, u16ServiceId );
         }
         
         if ( !bMsgPostSuccess )
         /* posting the message failed: don't forget to delete the message object */
         {
            oMessageServiceRegister.bDelete();
         }
      }

      if ( bMsgPostSuccess )
      {
         /* message was successfully posted */
         #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
         OSAL_tMSecond startTime = OSAL_ClockGetElapsedTime();
         #endif
         tS32 s32Ret = OSAL_s32SemaphoreWait( hSyncSem, rWaitForAnswerTime );
         #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
         OSAL_tMSecond endTime = OSAL_ClockGetElapsedTime();      
         #endif
      
         if(OSAL_ERROR == s32Ret)
         {
            ail_vTraceMsg( TR_LEVEL_FATAL,"RegService timeout (app 0x%04x,%d) (Server 0x%04x Srv 0x%04x)",u16AppId, u16SourceSubID, u16ServerAppId, u16ServiceId );
         }
      
         /* --Delete the entry in list. */   
         if ( ail_bTakeListAccess( hGeneralListAccess ) )
         {
            /* list access is sheltered */
            ail_tclServiceSyncAnswerIterator iter(poServiceSyncAnswerList);

            for ( ; !iter.bIsDone() && !bFound; iter.vNext())
            {
               if ( iter.oItem().bIsAnswer( &enWaitRet, &oBaseMessage, hSyncSem ) )
               {
                  /* found the reference */
                  bFound = TRUE;
                  break;
               }
            }
            
            if ( bFound )
            {
               /* "nRemove"-operation influences the validity of the iterator */
               poServiceSyncAnswerList->nRemove( iter.oItem() );
            }

            /* release the list access */
            ail_bReleaseListAccess( hGeneralListAccess );
         }

         if ( s32Ret == OSAL_OK && bFound )
         {
            /* there was no OSAL abort and "WaitReturn" is valid */ 
            switch ( enWaitRet )
            {
               case AIL_EN_U16_SYNC_MESSAGE_ANSWER:
               {
                  amt_tclServiceRegisterConf oServiceRegisterConf(&oBaseMessage);
      
                  if ( oServiceRegisterConf.u8GetRegisterState() == AMT_C_U8_REGCONF_SUCCESS )
                  {
                     u16RegisterId = oServiceRegisterConf.u16GetRegisterID();   
                  }
                  #ifndef AIL_KEEP_MSG_QUEUE_HANDLES_TO_OTHER_APPS_UNTIL_TERMINATION
                  else
                  {
                     // Service-Register failed, check whether this client have other
                     //  registrations for this server

                     if ( ail_bTakeListAccess( hGeneralListAccess ) )
                     {
                        /* list access is sheltered */
                        // examine for other registrations to this server
                        tBool bRegFound = ail_bCheckRegistrationsToApp(poServiceReferenceList, poServiceRegistryList,
                           OSAL_C_INVALID_HANDLE, // access already protected
                           u16ServerAppId);

                        // if no other registration exists, close handle to
                        // messagequeue of this server
                        if (!bRegFound)
                        {
                           if ( poOpenedQueueList )
                           {
                              ail_bDeleteFromOpenedQueueList(poOpenedQueueList,
                                 OSAL_C_INVALID_HANDLE, // access already protected
                                 u16ServerAppId);
                           } // else poOpenedQueueList doesn't exist
                        } // else other registrations to this server exists

                        /* release the list access */
                        ail_bReleaseListAccess( hGeneralListAccess );
                     } // else no list-access
                  } // end else (register-state!=SUCCESS)
                  #endif
                  /* release message buffer immediately */
                  oServiceRegisterConf.bDelete();
                  break;
               }
               case AIL_EN_U16_SYNC_REGISTRATION_INVALID:
               case AIL_EN_U16_SYNC_SERVICE_NOT_AVAILABLE:
               case AIL_EN_U16_SYNC_UNDEFINED_ABORT:
               case AIL_EN_U16_SYNC_UNINITIALIZED:
               default:
               {
                  /* in any unexpected return, the RegisterId stays invalid */
                  break;
               }
            }
            #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
            ail_vTraceMsg( TR_LEVEL_USER_2, "RegService (app 0x%04x,%d) (Server 0x%04x Srv 0x%04x) RegID %d, time %u ms",
                                               u16AppId, u16SourceSubID, u16ServerAppId, u16ServiceId, 
                                               u16RegisterId, (tU32)(endTime - startTime));
            #endif
         }         
      }
      else
      {
         /* --Delete the entry in list. */   
         if ( ail_bTakeListAccess( hGeneralListAccess ) )
         {
            /* list access is sheltered */
            ail_tclServiceSyncAnswerIterator iter(poServiceSyncAnswerList);

            for ( ; !iter.bIsDone() && !bFound; iter.vNext())
            {
               if ( iter.oItem().bIsAnswer( &enWaitRet, &oBaseMessage, hSyncSem ) )
               {
                  /* found the reference */
                  bFound = TRUE;
                  break;
               }
            }
            
            if ( bFound )
            {
               /* "nRemove"-operation influences the validity of the iterator */
               poServiceSyncAnswerList->nRemove( iter.oItem() );
            }

            /* release the list access */
            ail_bReleaseListAccess( hGeneralListAccess );
         }
      }

      /* release the answer object at your stack */
      oSyncAnswer.vDeinitServiceSyncAnswer();
      ail_bReleaseSemaphoreInList(hGeneralListAccess,hSyncSem,poPoolSemaphoreList);
   }
  
   return ( u16RegisterId );
  //## end ail_tclAppInterfaceRestricted::u16RegisterService%3A10FE880216.body
}

tVoid ail_tclAppInterfaceRestricted::vOnAsyncRegisterConf (tU16 /*u16RegisterId*/, tU16 /*u16ServerAppId*/, tU16 /*u16ServiceId*/, tU16 /*u16TargetSubId*/)
{
  // Do nothing here. The method vOnAsyncRegisterConf() is overwritten in class 'ail_tclOneThreadAppInterface' which is 
  // derived from class 'ail_tclAppInterfaceRestricted'. Method vOnAsyncRegisterConf() is made virtual here to allow an 
  // access of ail_tclOneThreadAppInterface::vOnAsyncRegisterConf() via 'ail_tclAppInterfaceRestricted'.
};

tVoid ail_tclAppInterfaceRestricted::vOnAsyncRegisterConfExt(tU16 /*u16RegisterId*/, tU16 /*u16ServerAppId*/, tU16 /*u16ServiceId*/, tU16 /*u16TargetSubId*/, tU8 /*u8AsyncRegisterConfStatus*/)
{
  // Do nothing here. The method vOnAsyncRegisterConfExt() is overwritten in class 'ail_tclOneThreadAppInterface' which is 
  // derived from class 'ail_tclAppInterfaceRestricted'. Method vOnAsyncRegisterConfExt() is made virtual here to allow an 
  // access of ail_tclOneThreadAppInterface::vOnAsyncRegisterConfExt() via 'ail_tclAppInterfaceRestricted'.
};

tVoid ail_tclAppInterfaceRestricted::vHandleAsyncRegisterConf (tU16 u16RegisterId, tU16 u16ServerAppId, tU16 u16ServiceId, tU16 u16TargetSubId, tU8 u8AsyncRegisterConfStatus)
{
  #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
    ail_vTraceMsg(TR_LEVEL_USER_2, 
                  "Application 0x%04x: vHandleAsyncRegisterConf() | u16RegisterId = 0x%04X, u16ServerAppId = 0x%04X, u16ServiceId = 0x%04X, u16TargetSubId = 0x%04X, u8AsyncRegisterConfStatus = %u",
                  u16AppId, u16RegisterId, u16ServerAppId, u16ServiceId, u16TargetSubId, u8AsyncRegisterConfStatus);
  #endif

  // In case of AMT_C_U8_REGCONF_SUCCESS set the registration confirmed flag 
  // in the respective service-request-entry of the server-application-entry.
  if (AMT_C_U8_REGCONF_SUCCESS == u8AsyncRegisterConfStatus)
  {
    if (ail_bTakeListAccess(hGeneralListAccess))
    {
      ail_tclServerApplication* poServerApplication       = NULL;
      ail_tclServiceRequest*    poServiceRequest          = NULL;
      tBool                     bServiceRequestEntryFound = FALSE;

      ail_tclServerApplicationIterator oServerApplicationIterator(m_poServerApplicationList);

      while((oServerApplicationIterator.bIsDone() == FALSE) && (FALSE == bServiceRequestEntryFound))
      {
        poServerApplication = &(oServerApplicationIterator.oItem());

        if ((poServerApplication->u16GetAppId()     == u16ServerAppId) &&
            (poServerApplication->u16GetServiceId() == u16ServiceId)     )
        {
          ail_tclServiceRequestIterator oServiceRequestIterator(poServerApplication->poGetServiceRequestList());

          while ((oServiceRequestIterator.bIsDone() == FALSE) && (FALSE == bServiceRequestEntryFound))
          {
            poServiceRequest = &(oServiceRequestIterator.oItem());

            if (poServiceRequest->u16GetClientSubId() == u16TargetSubId)
            {
              poServiceRequest->vSetRegistrationConfirmed(TRUE);

              bServiceRequestEntryFound = TRUE;
            }

            oServiceRequestIterator.vNext();
          }
        }

        oServerApplicationIterator.vNext();
      }

      ail_bReleaseListAccess(hGeneralListAccess);

      if (FALSE == bServiceRequestEntryFound)
      {
        ail_vTraceMsg(TR_LEVEL_ERRORS, 
                      "Application 0x%04x: vHandleAsyncRegisterConf() | Service request entry not found for u16ServerAppId = 0x%04X, u16ServiceId = 0x%04X, u16ClientSubId = 0x%04X",
                      u16AppId, u16ServerAppId, u16ServiceId, u16TargetSubId);
      }
    }
  }

  // Explicit actions of the AIL for particular register confirmation status.
  if (AMT_C_U8_REGCONF_SERVER_DOES_NOT_RESPOND_TIMEOUT == u8AsyncRegisterConfStatus)
  {
    // After a no response timeout the service request entry must be 
    // removed to be able to again try to register for this service.
    vRemoveServiceRequest(u16ServiceId, u16ServerAppId, u16TargetSubId, TRUE, FALSE);
  }

  // Intentionally call vOnAsyncRegisterConfExt() before vOnAsyncRegisterConf(). In the AHL CCA extension (CCX) during the 
  // introduction phase of the new vOnAsyncRegisterConfExt() interface the method vOnAsyncRegisterConf() might still be offered
  // by the CCX user appplication just for failure indication purposes. In such a use case the CCX internal method 
  // vOnAsyncRegisterConfExt() should be called first to do its job and update CCX internal states before the indication method
  // vOnAsyncRegisterConf() is called.
  vOnAsyncRegisterConfExt(u16RegisterId, u16ServerAppId, u16ServiceId, u16TargetSubId, u8AsyncRegisterConfStatus);

  if (AMT_C_U8_REGCONF_SERVICE_REGISTRATION_PENDING == u8AsyncRegisterConfStatus)
  {
    // Intentionally don't call vOnAsyncRegisterConf() as the actual request is still pending.
  }
  else if (AMT_C_U8_REGCONF_SERVICE_DOES_NOT_EXIST == u8AsyncRegisterConfStatus)
  {
    // At AMT_C_U8_REGCONF_SERVICE_DOES_NOT_EXIST indication u16RegisterId 
    // is passed with a value of AMT_C_U16_REGID_INVALID.
    vOnAsyncRegisterConf(u16RegisterId, AMT_C_U16_APPID_INVALID, u16ServiceId, u16TargetSubId);
  }
  else
  {
    // In case of failure (u16RegisterId == AMT_C_U16_REGID_INVALID) as per lack of 
    // parameters the method vOnAsyncRegisterConf() can NOT distinguish the following 
    // between the following possible reasons :
    //
    // - AMT_C_U8_REGCONF_SERVICE_ALREADY_REGISTERED
    // - AMT_C_U8_REGCONF_SERVICE_VERSION_NOT_SUPPORTED
    // - AMT_C_U8_REGCONF_SERVER_DOES_NOT_RESPOND_TIMEOUT
    vOnAsyncRegisterConf(u16RegisterId, u16ServerAppId, u16ServiceId, u16TargetSubId);
  }
};

tBool ail_tclAppInterfaceRestricted::bRegisterAsync (tU16 /*u16ServiceId*/, tU16 /*u16ServiceMajorVersion*/, tU16 /*u16ServiceMinorVersion*/, tU16 /*u16SourceSubID*/, tU16 /*u16ServerAppId*/)
{
  // Do nothing here. The method bRegisterAsync() is overwritten in class 'ail_tclOneThreadAppInterface' which is 
  // derived from class 'ail_tclAppInterfaceRestricted'. Method bRegisterAsync() is made virtual here to allow an 
  // access of ail_tclOneThreadAppInterface::bRegisterAsync() via the interface-class 'ail_tclIAppAdapt' where
  // 'ail_tclAppInterfaceRestricted' is derived from.

  return FALSE;
};

tBool ail_tclAppInterfaceRestricted::bRegisterAsyncExecute (tU16 /*u16ServiceId*/, tU16 /*u16ServiceMajorVersion*/, tU16 /*u16ServiceMinorVersion*/, tU16 /*u16SourceSubID*/, tU16 /*u16ServerAppId*/, tBool /*bListAccessAlreadyTaken*/)
{
  // Do nothing here. The method bRegisterAsyncExecute() is overwritten in class 'ail_tclOneThreadAppInterface' which is 
  // derived from class 'ail_tclAppInterfaceRestricted'. Method bRegisterAsyncExecute() is made virtual here to allow an 
  // access of ail_tclOneThreadAppInterface::bRegisterAsyncExecute() via the interface-class 'ail_tclIAppAdapt' where
  // 'ail_tclAppInterfaceRestricted' is derived from.

  return FALSE;
};

/*******************************************************************************
*
* FUNCTION: ail_tclAppInterfaceRestricted::vRemoveAllServiceRequests()
*
* DESCRIPTION: Run through the entire server application list and call the
*              vRemoveServiceRequest() method for each of the found service 
*              request entries. By doing this the server application list will
*              be cleared completely.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid ail_tclAppInterfaceRestricted::vRemoveAllServiceRequests()
{
  #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
    ail_vTraceMsg(TR_LEVEL_USER_2, "Application 0x%04x: ail_tclAppInterfaceRestricted::vRemoveAllServiceRequests() called", u16AppId);
  #endif

  if (ail_bTakeListAccess(hGeneralListAccess))
  {
    if (bServerApplicationListAvailable() == TRUE)
    {
      tU16 u16StoredAppId     = AMT_C_U16_APPID_INVALID;
      tU16 u16StoredServiceId = AMT_C_U16_SERVICE_UNDEF;

      while (m_poServerApplicationList->nSize() > 0)
      {
        ail_tclServerApplicationIterator oServerApplicationIterator = ail_tclServerApplicationIterator(m_poServerApplicationList);

        if (oServerApplicationIterator.bIsDone() == FALSE)
        {
          u16StoredAppId     = oServerApplicationIterator.oItem().u16GetAppId();
          u16StoredServiceId = oServerApplicationIterator.oItem().u16GetServiceId();

          vRemoveServiceRequest(u16StoredServiceId, u16StoredAppId, AMT_C_U16_SUBID_INVALID, TRUE, TRUE);
        }
        else
        {
          // If nSize() returns a value > 0 bIsDone() can not be TRUE. We just check this unexpected case and
          // stop parsing the server application list to avoid an endless loop.
          ail_vTraceMsg(TR_LEVEL_FATAL, "Application 0x%04x: ail_tclAppInterfaceRestricted::vRemoveAllServiceRequests() : Unexpected internal state of server application list. nSize()=%d while bIsDone()=%d. Failsafe break while parsing the server application list.", u16AppId, m_poServerApplicationList->nSize(), oServerApplicationIterator.bIsDone());
          
          break;
        }
      }

      ail_vTraceMsg(TR_LEVEL_USER_2, "Application 0x%04x: ail_tclAppInterfaceRestricted::vRemoveAllServiceRequests() done. Removed all service requests and cleared entire server application list", u16AppId);
    }

    ail_bReleaseListAccess(hGeneralListAccess);
  }
}

/*******************************************************************************
*
* FUNCTION: ail_tclAppInterfaceRestricted::vRemoveServiceRequest()
*
* DESCRIPTION: Remove the service request entry from the service request list 
*              of the server application entry for this combination of ...
*
*               - Service-ID
*               - Server-App-ID
*               - Client-Sub-ID
*
*              ... and also remove the entire server application entry from the 
*              service request list if the just removed service request was the 
*              last one from the service request list. If a server application 
*              entry was removed and there is not another entry with the same 
*              server application ID left in the server application list then 
*              unregister for this server application from the SPM. For a 
*              dedicated server the 'Application Info Unregister' message is 
*              sent to the SPM and for a none dedicated server it is the 
*              'Service Supplier Unregister' message.
*
* PARAMETER: [IN] u16ServiceId = Service ID.
*            [IN] u16ServerAppId = Server application ID.
*            [IN] u16ClientSubId = Client sub ID. If a value of 
*                                  AMT_C_U16_SUBID_INVALID is passed then the 
*                                  Client-Sub-ID is not considered to find a 
*                                  matching service request entry and all 
*                                  service request entries which match the 
*                                  tuple of Service-ID and Server-App-ID 
*                                  are removed.
*            [IN] bConsiderServerAppId = Flag if the passed parameter 
*                                        u16ServerAppId should be 
*                                        considered to find a matching service 
*                                        request entry. If set to FALSE then 
*                                        the Server-App-ID is not considered 
*                                        and all found service request entries 
*                                        which match the tuple of Service-ID 
*                                        and Client-Sub-ID are removed.
*            [IN] bListAccessAlreadyTaken = Flag if the general list access
*                                           semaphore is already taken to avoid
*                                           taking it a second time.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid ail_tclAppInterfaceRestricted::vRemoveServiceRequest(tU16 u16ServiceId, 
                                                           tU16 u16ServerAppId, 
                                                           tU16 u16ClientSubId, 
                                                           tBool bConsiderServerAppId, 
                                                           tBool bListAccessAlreadyTaken)
{
  tBool bListAccessTaken = FALSE;

  #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
    ail_vTraceMsg(TR_LEVEL_USER_2, "Application 0x%04x: ail_tclAppInterfaceRestricted::vRemoveServiceRequest() called. ServiceID=0x%04X, ServerAppID=0x%04X, ClientSubID=0x%04X, bConsiderServerAppId=%d, ListAccessAlreadyTaken=%d",
                  u16AppId, u16ServiceId, u16ServerAppId, u16ClientSubId, bConsiderServerAppId, bListAccessAlreadyTaken);
  #endif

  if (FALSE == bListAccessAlreadyTaken)
  {
    bListAccessTaken = ail_bTakeListAccess(hGeneralListAccess);
  }
  else
  {
    bListAccessTaken = TRUE;
  }

  if (TRUE == bListAccessTaken)
  {
    tU16                       u16StoredAppId                         = AMT_C_U16_APPID_INVALID;
    tU16                       u16StoredServiceId                     = AMT_C_U16_SERVICE_UNDEF;
    tU16                       u16StoredClientSubId                   = AMT_C_U16_SUBID_INVALID;
    tBool                      bDedicatedServer                       = FALSE;
    tBool                      bServerApplicationEntryRemoved         = FALSE;
    tBool                      bExactlySpecifiedServiceRequestRemoved = FALSE;
    ail_tclServiceRequestList* poServiceRequestList                   = NULL;

    if (bServerApplicationListAvailable() == TRUE)
    {
      // Run through server application list to find the service request entry(ies) to be removed.
      do
      {
        ail_tclServerApplicationIterator oServerApplicationIterator1(m_poServerApplicationList);

        bServerApplicationEntryRemoved = FALSE;

        while((bServerApplicationEntryRemoved == FALSE)         &&
              (oServerApplicationIterator1.bIsDone() == FALSE)  && 
              (bExactlySpecifiedServiceRequestRemoved == FALSE)   )
        {
          u16StoredServiceId   = oServerApplicationIterator1.oItem().u16GetServiceId();
          u16StoredAppId       = oServerApplicationIterator1.oItem().u16GetAppId();
          poServiceRequestList = oServerApplicationIterator1.oItem().poGetServiceRequestList();
          bDedicatedServer     = oServerApplicationIterator1.oItem().bIsDedicatedServer();

          // Check service-ID and application-ID search criteria.
          if ((u16StoredServiceId == u16ServiceId)                                      &&
              ((FALSE == bConsiderServerAppId) || (u16StoredAppId == u16ServerAppId)  ))
          {
            // Combination of passed service-ID and application-ID is found. 

            // Now check the service request list of this server application entry and 
            // remove its service request(s).
            ail_tclServiceRequestIterator oServiceRequestIterator(poServiceRequestList);

            if (oServiceRequestIterator.bIsDone() == TRUE)
            {
              // The service request list of this server application entry is empty. 
              
              // This should not happen but if so ... remove the server application entry 
              // because it may not exist with an empty service request list.
              m_poServerApplicationList->nRemove(oServerApplicationIterator1.oItem());
              
              bServerApplicationEntryRemoved = TRUE;

              #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
                ail_vTraceMsg(TR_LEVEL_FATAL, "Application 0x%04x: ail_tclAppInterfaceRestricted::vRemoveServiceRequest() => Service request list of server application entry with ServiceID=0x%04X and ServerAppID=0x%04X is not allowed to be empty.",
                              u16AppId, u16ServiceId, u16StoredAppId);
              #endif
            }
            else // The service request list of this server application entry is NOT empty.
            {
              // Run through service request list to find the service request entry(ies) to be removed.
              while(oServiceRequestIterator.bIsDone() == FALSE)
              {
                u16StoredClientSubId = oServiceRequestIterator.oItem().u16GetClientSubId();

                // Check sub-ID search criteria.
                if ((u16StoredClientSubId    == u16ClientSubId) ||
                    (AMT_C_U16_SUBID_INVALID == u16ClientSubId)   )
                {
                  poServiceRequestList->nRemove(oServiceRequestIterator.oItem());

                  // Check criteria if an exactly specified service request entry was just removed and set 
                  // flag to leave the outer loop as well as the whole method vRemoveServiceRequest() because 
                  // our job is done now.
                  if ((TRUE == bConsiderServerAppId) && (u16ClientSubId != AMT_C_U16_SUBID_INVALID))
                  {
                    bExactlySpecifiedServiceRequestRemoved = TRUE;
                  }

                  #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
                    ail_vTraceMsg(TR_LEVEL_USER_2, "Application 0x%04x: ail_tclAppInterfaceRestricted::vRemoveServiceRequest() => Removed service request from server application entry. ServiceID=0x%04X, ServerAppID=0x%04X, ClientSubID=0x%04X",
                                  u16AppId, u16ServiceId, u16StoredAppId, u16StoredClientSubId);
                  #endif

                  // If the just removed service request was the last one from the service
                  // request list then remove the entire server application entry from the 
                  // server application list.
                  if (poServiceRequestList->nSize() == 0)
                  {
                    m_poServerApplicationList->nRemove(oServerApplicationIterator1.oItem());

                    #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
                      ail_vTraceMsg(TR_LEVEL_USER_2, "Application 0x%04x: ail_tclAppInterfaceRestricted::vRemoveServiceRequest() => Removed server application entry. ServiceID=0x%04X, ServerAppID=0x%04X",
                                    u16AppId, u16ServiceId, u16StoredAppId);
                    #endif

                    bServerApplicationEntryRemoved = TRUE;
                  }

                  break;
                }

                oServiceRequestIterator.vNext();
              }
            }

            // If a server application entry was removed then it could be nessecary to either send a 
            // 'Service Supplier Unregister' or a 'Application Info Unregister' to the SPM as there 
            // is no need anymore to be informed about state changes of a server application. 
            if (TRUE == bServerApplicationEntryRemoved)
            {
              // If we just removed a server application entry which belongs to a dedicated server (registered at
              // with 'Application Info Register') then it must be checked if there is another entry left 
              // in the server application list with the same server application ID. This can happen if 
              // a client is registered for the same service at different server applications. The 
              // 'Application Info Unregister' message is only allowed to be send to the SPM if the just
              // removed server application entry was the last one from the server application list with
              // this server application ID
              if (TRUE == bDedicatedServer)
              {
                tBool bServerApplicationEntryFound = FALSE;

                ail_tclServerApplicationIterator oServerApplicationIterator2(m_poServerApplicationList);

                while(oServerApplicationIterator2.bIsDone() == FALSE)
                {
                  if ((oServerApplicationIterator2.oItem().bIsDedicatedServer() == TRUE)           &&
                      (oServerApplicationIterator2.oItem().u16GetAppId()        == u16StoredAppId)   )
                  {
                    bServerApplicationEntryFound = TRUE;

                    break;
                  }

                  oServerApplicationIterator2.vNext();
                }

                // The just removed server application entry was the last one from the server application 
                // list with this server application ID. Now we can send the 'Application Info Unregister'
                // message.
                if (FALSE == bServerApplicationEntryFound)
                {
                  if (bSendAppInfoMsg(u16StoredAppId, FALSE, FALSE, TRUE) == FALSE)
                  {
                    ail_vTraceMsg(TR_LEVEL_FATAL, "Application 0x%04x: ail_tclAppInterfaceRestricted::vRemoveServiceRequest() / Post message ApplicationInfoUnregister is invalid", u16AppId);
                  }
                }
              }
              // We just unregistered for a service which belongs to a none dedicated server (registered
              // at with 'Service Supplier Register'). As the just removed server application entry must
              // be the only one with this service ID there is no futher check required before sending the
              // 'Service Supplier Unregister'message to the SPM. So just send this message to the SPM.
              else
              {
                if (bSendCCASrvSupplierMsg(u16ServiceId, FALSE, FALSE) == FALSE)
                {
                  ail_vTraceMsg(TR_LEVEL_FATAL,"App 0x%04x: ail_tclAppInterfaceRestricted::vRemoveServiceRequest() / Post message ServiceSupplierUnregister is invalid", u16AppId);
                }
              }
            }
            else
            {
              // Get the next server application entry .... but only if we don't have just removed one of it 
              // and if the client-sub-ID is used to find a matching service request. If we don't use the 
              // client-sub-ID to find a matching service request (u16ClientSubId == AMT_C_U16_SUBID_INVALID)
              // then ALL service request entries for this tuple of application-ID and service-ID shall be 
              // removed. If all service request entries are removed then finally the whole server application 
              // entry is removed as well.
              if (u16ClientSubId != AMT_C_U16_SUBID_INVALID)
              {
                oServerApplicationIterator1.vNext();
              }
            }
          }
          else // Combination of passed service-ID and application-ID is NOT found. 
          {
            // Just get the next combination of service-ID and application-ID from the server application list.
            oServerApplicationIterator1.vNext();
          }
        }
      } while ((bServerApplicationEntryRemoved == TRUE) && (bExactlySpecifiedServiceRequestRemoved == FALSE));
    }

    if (FALSE == bListAccessAlreadyTaken)
    {
      ail_bReleaseListAccess(hGeneralListAccess);
    }
  }

  #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
    ail_vTraceMsg(TR_LEVEL_USER_2, "Application 0x%04x: ail_tclAppInterfaceRestricted::vRemoveServiceRequest() done." ,u16AppId);
  #endif
}

tVoid ail_tclAppInterfaceRestricted::vUnregisterService (tU16 u16ServiceId, tU16 u16ServerAppId, tU16 u16RegisterId, tU16 u16SourceSubID)
{
  //## begin ail_tclAppInterfaceRestricted::vUnregisterService%3A1100FF01F6.body preserve=yes

   tBool bFound = FALSE;

   if (AMT_C_U16_SERVICE_UNDEF == u16ServiceId)
   {
     ail_vTraceMsg(TR_LEVEL_FATAL, "Application 0x%04x: ail_tclAppInterfaceRestricted::vUnregisterService() / Invalid ServiceId = 0xFFFF", u16AppId);

     return;
   }
   else
   {
     #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
       ail_vTraceMsg(TR_LEVEL_USER_2, "Application 0x%04x: vUnregisterService() called. u16ServiceId=0x%04X, u16ServerAppId=0x%04X, u16RegisterId=0x%04X, u16SourceSubID=0x%04X",
                     u16AppId, u16ServiceId, u16ServerAppId, u16RegisterId, u16SourceSubID);
     #endif
   }

   if ( (u16ServerAppId != AMT_C_U16_APPID_INVALID) && (u16RegisterId != AMT_C_U16_REGID_INVALID))
   {
      /* exactly specified what to be released */
      if ( ail_bTakeListAccess( hGeneralListAccess ) )
      {
         /* list access is sheltered */
         if ( poServiceReferenceList != NULL )
         {
            ail_tclServiceReferenceIterator  iter(poServiceReferenceList);

            for ( ; !iter.bIsDone() && !bFound; iter.vNext())
            {
               if ( iter.oItem().bIsDataSet( u16ServiceId, u16ServerAppId, u16RegisterId, u16SourceSubID ) )
               {
                  /* found the reference */
                  bFound = TRUE;
                  break;
               }
            }

            if ( bFound )
            {
               /* "nRemove"-operation influences the validity of the iterator */
               poServiceReferenceList->nRemove( iter.oItem() );

               #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
                 ail_vTraceMsg(TR_LEVEL_USER_2, "Application 0x%04x: vUnregisterService() => Service reference removed. u16ServiceId=0x%04X, u16ServerAppId=0x%04X, u16RegisterId=0x%04X, u16SourceSubID=0x%04X",
                               u16AppId, u16ServiceId, u16ServerAppId, u16RegisterId, u16SourceSubID);
               #endif
            }
         }
         else
         {
            ail_vTraceMsg( TR_LEVEL_ERRORS, "Application 0x%04x: vUnregisterService(): poServiceReferenceList==NULL", u16AppId );
         }
         /* release the list access */
         ail_bReleaseListAccess( hGeneralListAccess );
      }

      if ( bFound )
      {
         /* RegisterId to be released was found in the reference table */
         amt_tclServiceUnregister oServiceUnregister( u16AppId, u16ServerAppId, u16ServiceId, u16RegisterId, u16SourceSubID);

         if ( oServiceUnregister.bIsValid() )
         {
            /* post this message to the server */
            if ( !bPostIpcMessage(u16AppId,
                     ail_hGetReceiverQueue( poOpenedQueueList, hGeneralListAccess, u16ServerAppId),
                     (amt_tclBaseMessage*) &oServiceUnregister, AIL_C_U32_CCA_PRIO_MSG_SERVICE_UNREGISTER ) )
            {
               // send failed, delete msg
               oServiceUnregister.bDelete();

               ail_vTraceMsg( TR_LEVEL_ERRORS, "Application 0x%04x: vUnregisterService(): failed to send service-unregister-msg, ServerApp: 0x%04x, RegisterId: %d", u16AppId, u16ServerAppId, u16RegisterId );
            }
         }
         else
         {
            ail_vTraceMsg( TR_LEVEL_ERRORS, "Application 0x%04x: vUnregisterService(): service-unregister-msg invalid, ServerApp: 0x%04x, RegisterId: %d", u16AppId, u16ServerAppId, u16RegisterId );
         }

         #ifndef AIL_KEEP_MSG_QUEUE_HANDLES_TO_OTHER_APPS_UNTIL_TERMINATION
         // possibly last message to this server, close queue
         if ( ail_bTakeListAccess( hGeneralListAccess ) )
         {
            /* list access is sheltered */
            // examine for other registrations to this server
            tBool bRegistrationFound = ail_bCheckRegistrationsToApp( poServiceReferenceList, poServiceRegistryList,
               OSAL_C_INVALID_HANDLE, // access already protected
               u16ServerAppId);

            // if no other registration exists, close handle to
            // messagequeue of this server
            if (!bRegistrationFound)
            {
               if ( poOpenedQueueList )
               {
                  ail_bDeleteFromOpenedQueueList(poOpenedQueueList,
                     OSAL_C_INVALID_HANDLE, // access already protected
                     u16ServerAppId);
               } // else poOpenedQueueList doesn't exist
            } // else other registrations to this server exists
            /* release the list access */
            ail_bReleaseListAccess( hGeneralListAccess );
         } // else no list-access
         #endif
      }
   }
   else
   {
      /* it might be possible more than one connection could be concerned */
      tU16  u16RefServerId = AMT_C_U16_APPID_INVALID;
      tU16  u16RefRegisterId = AMT_C_U16_REGID_INVALID;
      do
      {
         bFound = FALSE;

         if ( ail_bTakeListAccess( hGeneralListAccess ) )
         {
            /* it might be possible more than one connection could be concerned */
            if ( poServiceReferenceList != NULL )
            {
               ail_tclServiceReferenceIterator  iter(poServiceReferenceList);

               for ( ; !iter.bIsDone() && !bFound; iter.vNext())
               {
                  if ( iter.oItem().bIsDataSet( u16ServiceId, u16SourceSubID ) )
                  {
                     /* store ServerId and ServiceId to generate
                        the Unregister-Message later on */
                     u16RefServerId = iter.oItem().u16GetServerAppId();
                     u16RefRegisterId = iter.oItem().u16GetRegisterId();

                     if ( u16ServerAppId == AMT_C_U16_APPID_INVALID )
                     /* every shot is a hit */
                     {
                        /* found the reference */
                        bFound = TRUE;
                     }
                     else if ( u16ServerAppId == u16RefServerId )
                     /* only get a hit, if ServiceId is identical */
                     {
                        /* found the reference */
                        bFound = TRUE;
                     }

                     if ( bFound )
                     {
                        break;
                     }
                  }
               }

               if ( bFound )
               {
                  /* "nRemove"-operation influences the validity of the iterator */
                  poServiceReferenceList->nRemove( iter.oItem() );

                  #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
                    ail_vTraceMsg(TR_LEVEL_USER_2, "Application 0x%04x: vUnregisterService() => Service reference removed. ServiceID=0x%04X, SourceSubID=0x%04X",
                                  u16AppId, u16ServiceId, u16SourceSubID);
                  #endif
               }
            }
            /* release the list access */
            ail_bReleaseListAccess( hGeneralListAccess );
         }
         if ( bFound )
         {
            /* RegisterId to be released was found in the reference table */
            amt_tclServiceUnregister oServiceUnregister( u16AppId, u16RefServerId, u16ServiceId, u16RefRegisterId, u16SourceSubID);

            if ( oServiceUnregister.bIsValid() )
            {
               /* post this message to the server */  
               if ( !bPostIpcMessage(u16AppId,
                        ail_hGetReceiverQueue( poOpenedQueueList, hGeneralListAccess, u16RefServerId),
                        (amt_tclBaseMessage*) &oServiceUnregister, AIL_C_U32_CCA_PRIO_MSG_SERVICE_UNREGISTER ) )
               {
                  // send failed, delete msg
                  oServiceUnregister.bDelete();
                  ail_vTraceMsg( TR_LEVEL_ERRORS, "Application 0x%04x: vUnregisterService(): failed to send service-unregister-msg", u16AppId );
               }
            }
            else
            {
               ail_vTraceMsg( TR_LEVEL_ERRORS, "Application 0x%04x: vUnregisterService(): service-unregister-msg invalid", u16AppId );
            }

            #ifndef AIL_KEEP_MSG_QUEUE_HANDLES_TO_OTHER_APPS_UNTIL_TERMINATION
            // possibly last message to this server, close queue
            if ( ail_bTakeListAccess( hGeneralListAccess ) )
            {
               /* list access is sheltered */
               // examine for other registrations to this server
               tBool bRegistrationFound = ail_bCheckRegistrationsToApp(poServiceReferenceList, poServiceRegistryList,
                  OSAL_C_INVALID_HANDLE, // access already protected
                  u16RefServerId);

               // if no other registration exists, close handle to
               // messagequeue of this server
               if (!bRegistrationFound)
               {
                  if ( poOpenedQueueList )
                  {
                     ail_bDeleteFromOpenedQueueList(poOpenedQueueList, OSAL_C_INVALID_HANDLE, // access already protected
                        u16RefServerId);
                  } // else poOpenedQueueList doesn't exist
               } // else other registrations to this server exists
               /* release the list access */
               ail_bReleaseListAccess( hGeneralListAccess );
            } // else no list-access
            #endif
         }
      }
      while ( bFound );
   }

  // With unregistering a service we must remove the service-request 
  // entry from the Server-Application-List.
  vRemoveServiceRequest(u16ServiceId, 
                        u16ServerAppId, 
                        u16SourceSubID, 
                        (u16ServerAppId == AMT_C_U16_APPID_INVALID) ? FALSE : TRUE, 
                        FALSE);
   
  //## end ail_tclAppInterfaceRestricted::vUnregisterService%3A1100FF01F6.body
}

tVoid ail_tclAppInterfaceRestricted::vUnknownRegisterConf (amt_tclServiceRegisterConf& rfoServiceRegisterConf)
{
  //## begin ail_tclAppInterfaceRestricted::vUnknownRegisterConf%3D5A6748022D.body preserve=yes
   #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
   tU16 u16RegId =  rfoServiceRegisterConf.u16GetRegisterID();
   tU8  u8RegState = rfoServiceRegisterConf.u8GetRegisterState();
   tU16 u16SourceId = rfoServiceRegisterConf.u16GetSourceAppID();
   //tU16 u16ServiceId = rfoServiceRegisterConf.u16GetServiceID();
   //tU16 u16TargetSubId = rfoServiceRegisterConf.u16GetTargetSubID();

   ail_vTraceMsg( TR_LEVEL_USER_2, "Application 0x%04x: vUnknownRegisterConf called, register-state=0x%02X, register-id=0x%04X, server-app-id=0x%04X",//, service-id=0x%04X, target-sub-id=0x%04X",
      u16AppId, u8RegState, u16RegId, u16SourceId );//, u16ServiceId, u16TargetSubId );
   #endif
  //## end ail_tclAppInterfaceRestricted::vUnknownRegisterConf%3D5A6748022D.body
} //lint !e715

void ail_tclAppInterfaceRestricted::vTracePendingSyncComm(TR_tenTraceLevel enLevel)
{
   // list must be protected
   if ( ail_bTakeListAccess( hGeneralListAccess ) )
   {
      if( poServiceSyncAnswerList )
      {
         ail_tclServiceSyncAnswerIterator iter(poServiceSyncAnswerList);

         // are there pending synchronous communications?
         if( !iter.bIsDone() ) 
         {
            // prepare for entries in error memory. do entries only if trace level is fatal
            err_tclErrMem oErrMem;
            tChar pcText[ERRMEM_MAX_ENTRY_LENGTH];

            ail_vTraceMsg(enLevel, "Pending sync. comm app 0x%04x (see errmem for details)...", u16GetAppId());

            // iterate over all elements
            while ( !iter.bIsDone() )
            {
               // trace element contents
               iter.oItem().vTraceDump(enLevel);

               (tVoid)OSALUTIL_s32SaveNPrintFormat(pcText, ERRMEM_MAX_ENTRY_LENGTH, "app 0x%04x ", this->u16AppId);
               tU32 u32Length = (tU32)OSAL_u32StringLength(pcText);

               iter.oItem().vDumpToString(pcText + u32Length, (tU16)(ERRMEM_MAX_ENTRY_LENGTH - u32Length));

               if(enLevel == TR_LEVEL_FATAL)
               {
                  oErrMem.s32WriteErrorString(eErrmemEntryInfo, 
                                              (tU16)(TR_CLASS_AIL) & (tU16)0xFF00 /*u16TraceComp*/, 
                                              AIL_C_U8_ERR_PENDING_SYNC_COMM /*u8SpecificErrorCode*/, 
                                              pcText);
                  ail_vTraceMsg(TR_LEVEL_ERRORS, pcText);
               }
               else
               {
                  ail_vTraceMsg(enLevel, pcText);
               }
            
               // send request to trace internal state to pending application
               amt_tclDebugAppInfo oDebugApplicationMessage(iter.oItem().u16GetServerAppId(), 
                                                            iter.oItem().u16GetServerAppId(), 
                                                            AMT_C_U8_CCAMSG_DEBUG_APPLICATION_GET_APP_INFO, 
                                                            NULL, 
                                                            0);
      
               OSAL_tMQueueHandle hMQ = scd_OpenQueue(iter.oItem().u16GetServerAppId());                  
               ail_bIpcMessagePost(iter.oItem().u16GetServerAppId(), hMQ, &oDebugApplicationMessage, AIL_C_U32_CCA_PRIO_MSG_DEBUG_APPLICATION);
               scd_s32CloseQueue(hMQ);

               iter.vNext();
            }
         }
      }

      // release list
      ail_bReleaseListAccess( hGeneralListAccess );
   }
   else
   {
      NORMAL_M_ASSERT_ALWAYS();
   }
}

void ail_tclAppInterfaceRestricted::vTraceInternalState(TR_tenTraceLevel enLevel)
{
   ail_vTraceMsg(enLevel, "Trace Info on App 0x%04X ...",            u16GetAppId());
   ail_vTraceMsg(enLevel, "  Thread ID:                    0x%08X" , OSAL_ThreadWhoAmI());
   ail_vTraceMsg(enLevel, "  LastConfirmedAppState:        0x%08X ", u32LastConfirmedAppState);
   ail_vTraceMsg(enLevel, "  ActRequestedAppState:         0x%08X ", u32ActRequestedAppState);
   ail_vTraceMsg(enLevel, "  StartupInfo:                  0x%08X ", u32StartupInfo);
   ail_vTraceMsg(enLevel, "  InterfaceState:               0x%04X ", enInterfaceState);
   ail_vTraceMsg(enLevel, "  HasBodyThread:                %d",      bHasBodyThread);
   ail_vTraceMsg(enLevel, "  AutoRequestTimeOnStateChange: %d",      bAutoRequestTimeOnStateChange);
   ail_vTraceMsg(enLevel, "  LastDestributedRegisterId:    %d",      u16LastDestributedRegisterId);

   /* ========================================================================= */

   if (poServiceReferenceList != NULL)
   {
      if ( ail_bTakeListAccess( hGeneralListAccess ) )
      {
         ail_vTraceMsg(enLevel, " ServiceReferenceList (my app is registered at %d services)", poServiceReferenceList->nSize());
   
         ail_tclServiceReferenceIterator  iter(poServiceReferenceList);
      
         for ( ; !iter.bIsDone() ; iter.vNext())
         {
            tU16 u16MajorVersion, u16MinorVersion, u16PatchVersion;
            iter.oItem().bGetVersion(u16MajorVersion, u16MinorVersion, u16PatchVersion);
            ail_vTraceMsg(enLevel, "  ServiceId=0x%04X, ServerAppId=0x%04X, ServiceState=%d, RegisterId=0x%04X, SourceSubId=0x%04X, Version Maj=%d, Min=%d, Patch=%d", 
                          iter.oItem().u16GetServiceId(), 
                          iter.oItem().u16GetServerAppId(),
                          iter.oItem().u8GetServiceState(),
                          iter.oItem().u16GetRegisterId(),
                          iter.oItem().u16GetSubId(),
                          u16MajorVersion, 
                          u16MinorVersion,
                          u16PatchVersion
                          );
         }
      }
      else
      {
         ail_vTraceMsg(enLevel, " ServiceReferenceList no list access");
      }

      /* release the list access */
      ail_bReleaseListAccess( hGeneralListAccess );
   }
   else
   {
      ail_vTraceMsg(enLevel, "App 0x%04x: ail_tclAppInterfaceRestricted::vTraceInternalState() / poServiceReferenceList == NULL", u16AppId);
   }

   /* ========================================================================= */

   if (poServiceRegistryList != NULL)
   {
     tU16 u16NumOfferedServices   = 0;
     tU16 u16NumRegisteredClients = 0;

     if (ail_bTakeListAccess(hGeneralListAccess))
     {
       ail_tclServiceRegistryIterator iter(poServiceRegistryList);

       for ( ; !iter.bIsDone() ; iter.vNext())
       {
         if (iter.oItem().u16GetRegisterId() == AMT_C_U16_REGID_INVALID)
         {
           u16NumOfferedServices++;
         }
       }

       ail_bReleaseListAccess(hGeneralListAccess);
     }
     else
     {
       ail_vTraceMsg(enLevel, " ServiceRegistryList no list access");
     }

     ail_vTraceMsg(enLevel, " ServiceRegistryList (my app offers %d services)", u16NumOfferedServices);

     /* -------------------------------------------------------------- */

     if (ail_bTakeListAccess(hGeneralListAccess))
     {
       ail_tclServiceRegistryIterator iter(poServiceRegistryList);

       for ( ; !iter.bIsDone() ; iter.vNext())
       {
         if (iter.oItem().u16GetRegisterId() == AMT_C_U16_REGID_INVALID)
         {
           ail_vTraceMsg(enLevel, "  ServiceId=0x%04X,  ServiceState=%d", 
                         iter.oItem().u16GetServiceId(), 
                         iter.oItem().u8GetServiceState());
         }
       }

       ail_bReleaseListAccess(hGeneralListAccess);
     }
     else
     {
        ail_vTraceMsg(enLevel, " ServiceRegistryList no list access");
     }

     /* -------------------------------------------------------------- */

     if (ail_bTakeListAccess(hGeneralListAccess))
     {
       ail_tclServiceRegistryIterator iter(poServiceRegistryList);

       for ( ; !iter.bIsDone() ; iter.vNext())
       {
          if (iter.oItem().u16GetRegisterId() != AMT_C_U16_REGID_INVALID)
          {
            u16NumRegisteredClients++;
          }
       }

       ail_bReleaseListAccess(hGeneralListAccess);
     }
     else
     {
        ail_vTraceMsg(enLevel, " ServiceRegistryList no list access");
     }

     ail_vTraceMsg(enLevel, " ServiceRegistryList (%d clients have registered to my services)", u16NumRegisteredClients);

     /* -------------------------------------------------------------- */

     if (ail_bTakeListAccess(hGeneralListAccess))
     {
       ail_tclServiceRegistryIterator iter(poServiceRegistryList);

       for ( ; !iter.bIsDone() ; iter.vNext())
       {
         if (iter.oItem().u16GetRegisterId() != AMT_C_U16_REGID_INVALID)
         {
           tU16 u16MajorVersion, u16MinorVersion, u16PatchVersion;
           iter.oItem().bGetVersion(u16MajorVersion, u16MinorVersion, u16PatchVersion);
           ail_vTraceMsg(enLevel, "  ServiceId=0x%04X, ClientAppId=0x%04X, ServiceState=%d, RegisterId=0x%04X, DestSubId=0x%04X, Version Maj=%d, Min=%d, Patch=%d", 
                         iter.oItem().u16GetServiceId(), 
                         iter.oItem().u16GetClientAppId(),
                         iter.oItem().u8GetServiceState(),
                         iter.oItem().u16GetRegisterId(),
                         iter.oItem().u16GetClientSubId(),
                         u16MajorVersion, 
                         u16MinorVersion,
                         u16PatchVersion
                         );
         }
       }

       ail_bReleaseListAccess(hGeneralListAccess);
     }
     else
     {
       ail_vTraceMsg(enLevel, " ServiceRegistryList no list access");
     }

     /* -------------------------------------------------------------- */
   }
   else
   {
      ail_vTraceMsg(enLevel, "App 0x%04x: ail_tclAppInterfaceRestricted::vTraceInternalState() / poServiceRegistryList == NULL", u16AppId);
   }

   /* ========================================================================= */

   if (bServerApplicationListAvailable() == TRUE)
   {
     if (ail_bTakeListAccess(hGeneralListAccess))
     {
       ail_tclServerApplication* poServerApplication = NULL;
       ail_tclServiceRequest* poServiceRequest = NULL;

       ail_vTraceMsg(enLevel, " ServerApplicationList (my app is registered at %d server applications)", m_poServerApplicationList->nSize());
   
       ail_tclServerApplicationIterator oServerApplicationIterator(m_poServerApplicationList);

       while(oServerApplicationIterator.bIsDone() == FALSE)
       {
         poServerApplication = &(oServerApplicationIterator.oItem());

         ail_vTraceMsg(enLevel, "   for ServiceId=0x%04X at AppId=0x%04X (dedicated = %d) with ServerApplicationState=%d", 
                       poServerApplication->u16GetServiceId(),
                       poServerApplication->u16GetAppId(),
                       poServerApplication->bIsDedicatedServer(),
                       poServerApplication->enGetServerAppState()
                      );

         ail_tclServiceRequestIterator oServiceRequestIterator(poServerApplication->poGetServiceRequestList());

         while (oServiceRequestIterator.bIsDone() == FALSE)
         {
           poServiceRequest = &(oServiceRequestIterator.oItem());

           ail_vTraceMsg(enLevel, "     with SubId=0x%04X, ServiceMajorVersion=0x%04X, ServiceMinorVersion=0x%04X, RegistrationConfirmed=%d", 
                         poServiceRequest->u16GetClientSubId(),
                         poServiceRequest->u16GetServiceMajorVersion(),
                         poServiceRequest->u16GetServiceMinorVersion(),
                         poServiceRequest->bIsRegistrationConfirmed()
                        );

           oServiceRequestIterator.vNext();
         }

         oServerApplicationIterator.vNext();
       }

       ail_bReleaseListAccess( hGeneralListAccess );
     }
     else
     {
       ail_vTraceMsg(enLevel, "App 0x%04x: ail_tclAppInterfaceRestricted::vTraceInternalState() / No acces to semaphore hGeneralListAccess", u16AppId);
     }
   }

   /* ========================================================================= */

   vTracePendingSyncComm(enLevel);
}

void ail_tclAppInterfaceRestricted::vOnTriggerUserAction(tU8* /*pu8Data*/)
{
  ail_vTraceMsg(TR_LEVEL_FATAL, "ail_tclAppInterfaceRestricted::vOnTriggerUserAction() called. Overwrite this method to gain control from user application.");
}

tVoid ail_tclAppInterfaceRestricted::vAppStateChanged (tU32 u32AppState, OSAL_tMSecond rApproximatedChangeTime)
{
  //## begin ail_tclAppInterfaceRestricted::vAppStateChanged%3A10FFFD01F5.body preserve=yes

   if ( rApproximatedChangeTime == 0 )
   {
      // protect access to u32LastConfirmedAppState
      //  (possible conflict with entry-thread during AutomaticRequestTimeOnStateChange)
      if ( ail_bTakeListAccess( hGeneralListAccess ) )
      {
         u32LastConfirmedAppState = u32AppState;

         // release the list access
         ail_bReleaseListAccess( hGeneralListAccess );
      }
   }

   if ( u16LpmId != AMT_C_U16_APPID_INVALID )
   {
      // suppress requests for extra-time if not explicitly desired
      if (  rApproximatedChangeTime == 0
         || !bRequestTimeOnStateChangeAutomatically() )
      {
         (tVoid)bSendCCAPowerMsg (u16LpmId,hLpmInQueue,AIL_C_U32_CCA_PRIO_MSG_POWER,
                           AMT_C_U16_PWR_APP_STATE_ACK, u32AppState, (tU32) rApproximatedChangeTime);
      }
      else
      {
         #ifdef AIL_MESSAGE_TRACE_POWER_MESSAGES
         ail_vTraceMsg( TR_LEVEL_USER_1, "Application 0x%04x: send of request for extra time (%d) suppressed", u16AppId, rApproximatedChangeTime );
         #endif
      }
   }

  //## end ail_tclAppInterfaceRestricted::vAppStateChanged%3A10FFFD01F5.body
}

tBool ail_tclAppInterfaceRestricted::bRequestTimeOnStateChangeAutomatically() const
{
   return (bAutoRequestTimeOnStateChange);
}

tVoid ail_tclAppInterfaceRestricted::vServiceAvailabilityChanged (tU16 u16ServiceId, tU8 u8ServiceState)
{
  //## begin ail_tclAppInterfaceRestricted::vServiceAvailabilityChanged%3A10FDFD0339.body preserve=yes

   if ( ail_bTakeListAccess( hGeneralListAccess ) )
   /* list access is sheltered */
   {
      ail_tclServiceRegistryIterator   iter(poServiceRegistryList);
      tBool                            bRefValStored = FALSE;

      for ( ; !iter.bIsDone(); iter.vNext())
      /* check the interest */
      {
         if ( iter.oItem().u16GetServiceId() == u16ServiceId )
         {
            tU8  u8PreviousServiceState = iter.oItem().u8GetServiceState();
            tU16 u16Receiver            = iter.oItem().u16GetClientAppId();
            tU16 u16RegisterId          = iter.oItem().u16GetRegisterId();

            /* there is an entry for this service */
            if ( u16Receiver == u16AppId )
            {
               /* don't forget to store the new state by using the own u16AppId  */
               /* it's needed to know the current service state when a client
                  registers for this service first time */
               iter.oItem().vSetServiceState( u8ServiceState );
               bRefValStored = TRUE;
            }

            /* found an already registered client */

            /* Inform other and even the own application about the a service-state change. */
            /* The own application must also be informed about any change in the service-state because one and the same application can consist of a client as well as a server part. */
            /* When the server part changes the service-state the client part of the same application must be notified about the current state via a service-status message. */
            if ( (u8PreviousServiceState != u8ServiceState) && (u16RegisterId != AMT_C_U16_REGID_INVALID) )
            {
               /* inform the client about the changed service state and keep the last sent service state for this channel */
               iter.oItem().vSetServiceState( u8ServiceState );

               #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
               ail_vTraceMsg( TR_LEVEL_USER_3,
                  "Application 0x%04x: Send ServiceState %d for Service 0x%04x to Client %d using RegisterId %d",
                  u16AppId, u8ServiceState, u16ServiceId, u16Receiver, u16RegisterId );
               #endif

               /* create a new message object */
               amt_tclServiceStatus oServiceStatus(  u16AppId, u16Receiver, u16ServiceId, u16RegisterId, u8ServiceState, AMT_C_U16_SUBID_DEFAULT, iter.oItem().u16GetClientSubId());

               if ( oServiceStatus.bIsValid() )
               {
                  if ( !bPostIpcMessage( u16AppId,
                           ail_hGetReceiverQueue( poOpenedQueueList, OSAL_C_INVALID_HANDLE, u16Receiver),
                           &oServiceStatus, AIL_C_U32_CCA_PRIO_MSG_SERVICE_STATUS ) )
                  {
                     // send failed, delete msg
                     oServiceStatus.bDelete();
                     ail_vTraceMsg( TR_LEVEL_ERRORS, "Application 0x%04x: vServiceAvailabilityChanged(): failed to send service-status-msg", u16AppId );
                  }
               }
               else
               {
                  ail_vTraceMsg( TR_LEVEL_ERRORS, "Application 0x%04x: vServiceAvailabilityChanged(): service-status-msg invalid", u16AppId );
               }
            }
         }
      }
      if ( !bRefValStored )
      {
         /* create a reference value for this service */
         if ( poServiceRegistryList != NULL )
         {
            ail_tclServiceRegistry oServiceRegistry(AMT_C_U16_REGID_INVALID, u16ServiceId, u16AppId, AMT_C_U16_SUBID_INVALID);
            oServiceRegistry.vSetServiceState( u8ServiceState );

            /* add the the element to the normal registration list */        
            poServiceRegistryList->vAdd(oServiceRegistry);
         }
         else
         {
            ail_vTraceMsg( TR_LEVEL_ERRORS,
                  "Application 0x%04x: poServiceRegistryList==NULL", u16AppId );
         }
      }
      /* release the list access */
      ail_bReleaseListAccess( hGeneralListAccess );

   }
  //## end ail_tclAppInterfaceRestricted::vServiceAvailabilityChanged%3A10FDFD0339.body
}

tBool ail_tclAppInterfaceRestricted::bExternSynchronizeInterface ()
{
  //## begin ail_tclAppInterfaceRestricted::bExternSynchronizeInterface%3A9F687800A3.body preserve=yes

  tBool bSuccess = FALSE;
     
  if ( enInterfaceState < AIL_EN_N_APPLICATION_INITIALIZED )
  {  

    #ifndef DEBUG 

    tS16 s16AppStartupSimToutCount = C_U16_APPSTARTUP_SIMTOUT_COUNT;

    while ((enInterfaceState != AIL_EN_N_APPLICATION_REGISTERED) && 
           (s16AppStartupSimToutCount > 0)                         )
    /* wait for startup registration ( simulation of system management ) */
    {
      OSAL_s32ThreadWait(C_U16_APPSTARTUP_SIM_MSEC_WAIT); //lint !e522: Expected void type, assignment, increment or decrement
      s16AppStartupSimToutCount--;
    }

    /* interface is ready to accept commands */
    if (s16AppStartupSimToutCount > 0)
    {
      bSuccess = bOnInit();

      if ( bSuccess )
      {
         /* application ready initialized */
        /* application is free now to process all message */
        enInterfaceState = AIL_EN_N_APPLICATION_INITIALIZED;
        /* ApplicationPowerState == SY_STATE_INITIALIZED */
        u32LastConfirmedAppState = AMT_C_U32_STATE_INITIALIZED;
        /* note: not guarded by a semphore, because it's done in one instruction */

        if ( u32WdgTime )
        /* a watchdog has to be installed */
        {
          tS32 s32OsalError = OSAL_s32TimerCreate(&vTriggerWdg, (tPVoid)this, &hWdgTimer);
          if ( s32OsalError == OSAL_OK )
          {
            s32OsalError = OSAL_s32TimerSetTime( hWdgTimer, u32WdgTime, 0);
          }
        }
        /* else: no watchdog time base available */
      }
      /* else: any abort message is required to inform the interface thread */
    }
    /* else: interface thread is not succesfully registered */

   #else

    while (enInterfaceState != AIL_EN_N_APPLICATION_REGISTERED)
    {
       /* wait for startup registration ( simulation of system management ) */
      OSAL_s32ThreadWait(C_U16_APPSTARTUP_SIM_MSEC_WAIT); //lint !e522: Expected void type, assignment, increment or decrement
    }

    bSuccess = bOnInit();

    if ( bSuccess )
    {
       /* application ready initialized */
      /* application is free now to process all message */
      enInterfaceState = AIL_EN_N_APPLICATION_INITIALIZED;
      /* ApplicationPowerState == SY_STATE_INITIALIZED */
      u32LastConfirmedAppState = AMT_C_U32_STATE_INITIALIZED;
      /* note: not guarded by a semphore, because it's done in one instruction */

      if ( u32WdgTime )
      {
         /* a watchdog has to be installed */
        tS32 s32OsalError = OSAL_s32TimerCreate(&vTriggerWdg, (tPVoid)this, &hWdgTimer);
        if ( s32OsalError == OSAL_OK )
        {
          s32OsalError = OSAL_s32TimerSetTime( hWdgTimer, u32WdgTime, 0);
        }
      }
      /* else: no watchdog time base available */
    }
    /* else: any abort message is required to inform the interface thread */

#endif

  }
  /* else: sequence error */

  if ( !bSuccess )
  {
     /* try to involve somebody to end the application */
     ail_vTraceMsg(TR_LEVEL_FATAL,
           "Application 0x%04x: RequestErrorEnd, bOnInitFailed or already initialized", u16AppId );
     vApplicationRequestErrorEnd(AIL_C_U32_ERROR_ONINIT_FAILED);
  }

  return ( bSuccess );

  //## end ail_tclAppInterfaceRestricted::bExternSynchronizeInterface%3A9F687800A3.body
}

tVoid ail_tclAppInterfaceRestricted::vApplicationCloseAcknowledge (tU8 u8SuccessType)
{
  //## begin ail_tclAppInterfaceRestricted::vApplicationCloseAcknowledge%3ADC0DEB01B1.body preserve=yes

   if ( u8SuccessType == AIL_C_U8_APP_END_SUCCESSFUL )
   {
      /* SUCCESS -> confirm to own framework */
      // send AMT_C_U16_PWR_APP_END_SUCCESSFUL to myself, to shutdown application
      (tVoid)bSendCCAPowerMsg (u16AppId, hMyInQueue, AIL_C_U32_CCA_PRIO_MSG_POWER,
                        AMT_C_U16_PWR_APP_END_SUCCESSFUL, u32LastConfirmedAppState, (tU32) 0x00);
   }
   else
   {
      /* FAILED */
      // send AMT_C_U16_PWR_APP_END_FAILURE to LPM to reset this process
      (tVoid)bSendCCAPowerMsg (u16LpmId, hLpmInQueue, AIL_C_U32_CCA_PRIO_MSG_POWER, AMT_C_U16_PWR_APP_END_FAILURE,
                        u32LastConfirmedAppState, (tU32) 0x00);

      // send AMT_C_U16_PWR_APP_END_FAILURE to myself, to shutdown application
      (tVoid)bSendCCAPowerMsg (u16AppId, hMyInQueue, AIL_C_U32_CCA_PRIO_MSG_POWER,
                        AMT_C_U16_PWR_APP_END_FAILURE, u32LastConfirmedAppState, (tU32) 0x00);
   }

   /* from now loop back message no longer forwarded to the application */
   enInterfaceState = AIL_EN_N_APPLICATION_CLOSED;

  //## end ail_tclAppInterfaceRestricted::vApplicationCloseAcknowledge%3ADC0DEB01B1.body
}

tVoid ail_tclAppInterfaceRestricted::vApplicationRequestErrorEnd (tU32 u32ErrorReason)
{
  //## begin ail_tclAppInterfaceRestricted::vApplicationRequestErrorEnd%3BD9276502B4.body preserve=yes

   
   /****************************************************************/
   /* IMPORTANT INFO FOR THOSE WHO DEBUG, REDUCE LINT-WARNINGS,    */
   /* COMPILER-WARNINGS AND SO ON.                                 */
   /*                                                              */
   /* If an error occured, a hard error will be forced here, so    */
   /* the current call-stack can be found in the error-memory.     */
   /*                                                              */
   /* Otherwise the LPM would try to shutdown the system.          */
   /* This will fail and a reboot occurs later anyway but without  */
   /* any information about the origin reason in the error-memory. */
   /*                                                              */
   /* DO NOT CHANGE THESE LINES DUE TO BEAUTIFICATION              */
   /****************************************************************/

   #if ! (defined NORMAL_M_ASSERT_ALWAYS && defined FATAL_M_ASSERT_ALWAYS)

   tU32  u32ForcedError;
   tU32  u32a = 5;
   tU32  u32b = 0;
   tU32  *pu32Alignmentmiss = (tU32 *) 0x00000003;
   tU32  *pu32Ptr = &u32b; 

   *pu32Alignmentmiss = u32a;

//   u32ForcedError = u32a/u32b; //lint !e414 -> LINT-warning couldn't be suppressed
   u32ForcedError = u32a/(*pu32Ptr); // this is a wanted divison by zero, needed for BUG-hunting 

   if ( u32ForcedError < 1)
   {
      return;
   }

   #else

   /****************************************************************/
   /* END OF FORCED ERROR                                          */
   /****************************************************************/

   // make a error memory entry
   NORMAL_M_ASSERT_ALWAYS();

   // request shutdown on SPM with all informations what are the reason
   (tVoid)bSendCCAPowerMsg (u16LpmId, hLpmInQueue, AIL_C_U32_CCA_PRIO_MSG_POWER, AMT_C_U16_PWR_APP_ERROR_DETECT, 
                     u32LastConfirmedAppState, u32ErrorReason);

   // check if there anything hanging
   vTracePendingSyncComm(TR_LEVEL_FATAL);

   // trace the internal state of the app
   vTraceInternalState(TR_LEVEL_FATAL);

   // give the message a chance to reach the SPM
   OSAL_s32ThreadWait(C_RESET_MSEC_WAIT);

   // if SPM doesn't react make the reset by ourself
   FATAL_M_ASSERT_ALWAYS();

   #endif

  //## end ail_tclAppInterfaceRestricted::vApplicationRequestErrorEnd%3BD9276502B4.body
}

tVoid ail_tclAppInterfaceRestricted::vOnRegistrationRemoved(tU16 u16ServiceId, tU16 u16ServerAppId, tU16 u16SourceSubId)
{
   ail_vTraceMsg(TR_LEVEL_USER_1, 
                 "Application 0x%04X: vOnRegistrationRemoved() called, ServiceId = 0x%04X, ServerAppId = 0x%04X, SourceSubId = 0x%04X",
                  u16AppId, u16ServiceId, u16ServerAppId, u16SourceSubId);
}

tVoid ail_tclAppInterfaceRestricted::vOnServiceSupplierStatus(tU16 u16ServiceId, tU16 u16ServerAppId, tU8 u8SrvSupplierState)
{
  //## begin ail_tclAppInterfaceRestricted::vOnServiceSupplierStatus%3CC52AB70192.body preserve=yes
   ail_vTraceMsg( TR_LEVEL_USER_1,
                     "Application 0x%04x: vOnServiceSupplierStatus received, Srv = 0x%04x, App = 0x%04x, State = %d", u16AppId, u16ServiceId, u16ServerAppId, u8SrvSupplierState);
  //## end ail_tclAppInterfaceRestricted::vOnServiceSupplierStatus%3CC52AB70192.body
}

tVoid ail_tclAppInterfaceRestricted::vOnApplicationInfoStatus(tU16 u16ServerAppId, tU8 u8AppState)
{
  //## begin ail_tclAppInterfaceRestricted::vOnApplicationInfoStatus%3CC52AB70192.body preserve=yes
   ail_vTraceMsg( TR_LEVEL_USER_1,
                     "Application 0x%04x: vOnApplicationInfoStatus received, App = 0x%04x, State = %d", u16AppId, u16ServerAppId, u8AppState);
  //## end ail_tclAppInterfaceRestricted::vOnApplicationInfoStatus%3CC52AB70192.body
}

tVoid ail_tclAppInterfaceRestricted::vTerminateMySelf ()
{
  //## begin ail_tclAppInterfaceRestricted::vTerminateMySelf%3B948C3E0323.body preserve=yes

   /**************************** start killing yourself *****************************/


   tBool bElementsInList = TRUE;
   tBool bListEmpty = TRUE;

   /* clear all lists */
   if ( poOpenedQueueList )
   {
      /* better would be a self-clearing list */
      bElementsInList = TRUE;
      bListEmpty = TRUE;

      while ( bElementsInList )
      {
         ail_tclOpenedQueueIterator iter(poOpenedQueueList);

         if ( !iter.bIsDone() )
         {
            scd_s32CloseQueue(iter.oItem().hGetQueue());
            poOpenedQueueList->nRemove(iter.oItem());
            bListEmpty = FALSE;
         }
         else
         {
            bElementsInList = FALSE;  
         }   
      }
      if ( !bListEmpty )
      {
         ail_vTraceMsg( TR_LEVEL_SYSTEM,"Application 0x%04x: vTerminateMySelf: opened-queue-list isn't empty!", u16AppId );
      }
   }
   if ( poServiceReferenceList )
   {
      /* better would be a self-clearing list */
      bElementsInList = TRUE;
      bListEmpty = TRUE;

      while ( bElementsInList )
      {
         ail_tclServiceReferenceIterator  iter(poServiceReferenceList);

         if ( !iter.bIsDone() )
         {
            poServiceReferenceList->nRemove(iter.oItem());
            bListEmpty = FALSE;
         }
         else
         {
            bElementsInList = FALSE;  
         }   
      }
      if ( !bListEmpty )
      {
         ail_vTraceMsg( TR_LEVEL_SYSTEM,
            "Application 0x%04x: vTerminateMySelf: service-reference-list isn't empty!", u16AppId );
      }
   }
   if ( poServiceRegistryList ) 
   {
      /* better would be a self-clearing list */
      bElementsInList = TRUE;
      bListEmpty = TRUE;

      while ( bElementsInList )
      {
         ail_tclServiceRegistryIterator  iter(poServiceRegistryList);

         if ( !iter.bIsDone() )
         {
            poServiceRegistryList->nRemove(iter.oItem());
            bListEmpty = FALSE;
         }
         else
         {
            bElementsInList = FALSE;  
         }   
      }
      if ( !bListEmpty )
      {
         ail_vTraceMsg( TR_LEVEL_SYSTEM,"Application 0x%04x: vTerminateMySelf: service-registry-list isn't empty!", u16AppId );
      }
   }
   if ( poServiceSyncAnswerList )
   {
      /* better would be a self-clearing list */
      bElementsInList = TRUE;
      bListEmpty = TRUE;

      while ( bElementsInList )
      {
         ail_tclServiceSyncAnswerIterator iter(poServiceSyncAnswerList);

         if ( !iter.bIsDone() )
         {
            poServiceSyncAnswerList->nRemove(iter.oItem());
            bListEmpty = FALSE;
         }
         else
         {
            bElementsInList = FALSE;  
         }   
      }
      if ( !bListEmpty )
      {
         ail_vTraceMsg( TR_LEVEL_SYSTEM,
            "Application 0x%04x: vTerminateMySelf: service-sync-answer-list isn't empty!", u16AppId );
      }
   }
   if ( poPoolSemaphoreList )
   {
      ail_bDeleteSemaphoresFromList
      (
         OSAL_C_INVALID_HANDLE,
         poPoolSemaphoreList
      );
   }

   /******************** inform LPM about your sudden death *************************/
   if ( (u16LpmId != AMT_C_U16_APPID_INVALID) && (hLpmInQueue != OSAL_C_INVALID_HANDLE))
   {
      tU16 u16PowerCode = AMT_C_U16_PWR_APP_END_SUCCESSFUL;

      if ( enInterfaceState < AIL_EN_N_APPLICATION_INITIALIZED )
      {
         /* self terminating without being initialized */
         u16PowerCode = AMT_C_U16_PWR_APP_RESTART;
      }

      /* that's all for today - say good bye boy - */
      (tVoid)bSendCCAPowerMsg (u16LpmId, hLpmInQueue, AIL_C_U32_CCA_PRIO_MSG_POWER, u16PowerCode, u32LastConfirmedAppState, (tU32) 0x00);
   }

   /* last thread of an application live longest at lowest priority */
   if (hSupervisorThreadID != OSAL_ERROR)
   {
      OSAL_s32ThreadPriority(hSupervisorThreadID,OSAL_C_U32_THREAD_PRIORITY_LOWEST); //lint !e522: Expected void type, assignment, increment or decrement
   }

   // inform who ever is waiting that I'm done
   if (_hLicenseToKill != OSAL_C_INVALID_HANDLE)
   {
      OSAL_s32SemaphorePost(_hLicenseToKill);
   }

   /***************************** thread exits itself *******************************/

  //## end ail_tclAppInterfaceRestricted::vTerminateMySelf%3B948C3E0323.body
}

tBool ail_tclAppInterfaceRestricted::bGetServiceVersion (tU16 u16ServiceID, tU16 &rfu16MajorVersion, tU16 &rfu16MinorVersion, tU16 &rfu16PatchVersion)
{
  //## begin ail_tclAppInterfaceRestricted::bGetServiceVersion%3C67F1FB02CF.body preserve=yes
   #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
   ail_vTraceMsg( TR_LEVEL_USER_1,
      "Application 0x%04x: bGetServiceVersion called for service 0x%04X, return invalid version", u16AppId, u16ServiceID );
   #endif
   rfu16MajorVersion = AMT_C_U16_SERVICE_VERSION_INVALID;
   rfu16MinorVersion = AMT_C_U16_SERVICE_VERSION_INVALID;
   rfu16PatchVersion = AMT_C_U16_SERVICE_VERSION_INVALID;
   return(FALSE);
  //## end ail_tclAppInterfaceRestricted::bGetServiceVersion%3C67F1FB02CF.body
} //lint !e715


tU8 ail_tclAppInterfaceRestricted::u8GetServiceAvailability (tU16 u16ServiceId)
{
  //## begin ail_tclAppInterfaceRestricted::u8GetServiceAvailability%3CB3DFBB0092.body preserve=yes
   tU8      u8RetVal = AMT_C_U8_SVCSTATE_NOT_AVAILABLE;

   if ( ail_bTakeListAccess( hGeneralListAccess ) )
   {
      /* list access is sheltered */
      ail_tclServiceRegistryIterator   iter(poServiceRegistryList);

      for ( ; !iter.bIsDone(); iter.vNext())
      {
         if ( ( iter.oItem().u16GetServiceId() == u16ServiceId )
              &&
              ( iter.oItem().u16GetClientAppId() == u16AppId )
            )
         {
            u8RetVal = iter.oItem().u8GetServiceState();
         }
      }
      ail_bReleaseListAccess( hGeneralListAccess );
   }

   return ( u8RetVal );
  //## end ail_tclAppInterfaceRestricted::u8GetServiceAvailability%3CB3DFBB0092.body
}

tVoid ail_tclAppInterfaceRestricted::vOnAppStateAckFailed (tU32 u32OldAppState, tU32 u32AppState)
{
  //## begin ail_tclAppInterfaceRestricted::vOnAppStateAckFailed%3CC5234C001F.body preserve=yes

   // ksm2hi, 24.11.2017 : Intentionally commented out below call of vAppStateChanged() to avoid
   //                      an automated state change acknowlegde on vOnAppStateAckFailed() and
   //                      thereby remind derived applications to overload this method who might
   //                      have forgotten to do so.
   //
   //                      The LCM will reset the system if there was a missing state change
   //                      acknowlegde on vOnNewAppState() followed by a missing state change
   //                      acknowlegde on vOnAppStateAckFailed().

   // vAppStateChanged( u32AppState );

   ail_vTraceMsg( TR_LEVEL_SYSTEM_MIN,
                     "Application 0x%04x: vOnAppStateAckFailed called, old app-state=0x%04X, requested app-state=0x%04X",
                     u16AppId, u32OldAppState, u32AppState );

   //## end ail_tclAppInterfaceRestricted::vOnAppStateAckFailed%3CC5234C001F.body
}

tVoid ail_tclAppInterfaceRestricted::vOnCVMEvent (tU32 u32CVMEvent)
{
  //## begin ail_tclAppInterfaceRestricted::vOnCVMEvent%3CC52AB70192.body preserve=yes
   ail_vTraceMsg( TR_LEVEL_USER_1,
                     "Application 0x%04x: CVM-msg received, VoltageSignal = %d", u16AppId, u32CVMEvent );
  //## end ail_tclAppInterfaceRestricted::vOnCVMEvent%3CC52AB70192.body
}

tU32 ail_tclAppInterfaceRestricted::u32GetStartupInfo () const
{
  //## begin ail_tclAppInterfaceRestricted::u32GetStartupInfo%3CC52BC60065.body preserve=yes
   return u32StartupInfo;
  //## end ail_tclAppInterfaceRestricted::u32GetStartupInfo%3CC52BC60065.body
}

tVoid ail_tclAppInterfaceRestricted::vRAMInitReady ()
{
  //## begin ail_tclAppInterfaceRestricted::vRAMInitReady%3CC54C5001C2.body preserve=yes

   /* all necessary heap is allocated, as the system managment wishes - */
   if (bSendCCAPowerMsg (u16LpmId, hLpmInQueue, AIL_C_U32_CCA_PRIO_MSG_POWER, AMT_C_U16_PWR_APP_RAM_INIT_READY,  (tU32)u16AppId, (tU32) 0x00) == FALSE)
   {
      ail_vTraceMsg(TR_LEVEL_FATAL, "%x send of RAM_INIT_READY to SPM failed", u16AppId);
   }

  //## end ail_tclAppInterfaceRestricted::vRAMInitReady%3CC54C5001C2.body
}

tVoid ail_tclAppInterfaceRestricted::vSetSystemState (tU32 u32RequestedSysState)
{
  //## begin ail_tclAppInterfaceRestricted::vSetSystemState%3CC54CD903DC.body preserve=yes

   /* an application wants the system to change to a certain state - */
   (tVoid)bSendCCAPowerMsg (u16LpmId, hLpmInQueue, AIL_C_U32_CCA_PRIO_MSG_POWER, AMT_C_U16_PWR_APP_REQ_SYSTEM_STATE,  (tU32)u16AppId, u32RequestedSysState);

  //## end ail_tclAppInterfaceRestricted::vSetSystemState%3CC54CD903DC.body
}

tBool ail_tclAppInterfaceRestricted::bSendCCAPowerMsg (tU16 u16RecvId, OSAL_tMQueueHandle hQueueHandle, tU32 u32MsgPrio, tU16 u16PwrType, tU32 u32PwrData1, tU32 u32PwrData2)
{
  //## begin ail_tclAppInterfaceRestricted::bSendCCAPowerMsg%3CC54DAA0256.body preserve=yes
   tBool bRetVal = FALSE;

   amt_tclPowerMessage oPowerMessage (u16AppId, u16RecvId, u16PwrType, u32PwrData1, u32PwrData2);

   if ( oPowerMessage.bIsValid() )
   {
      bRetVal = bPostIpcMessage(u16AppId, hQueueHandle, &oPowerMessage, u32MsgPrio);

      if ( !bRetVal )
      {
         oPowerMessage.bDelete();
         ail_vTraceMsg( TR_LEVEL_FATAL, "Application 0x%04x: failed to send power-msg of type %d ", u16AppId, u16PwrType );
      }
   }
   else
   {
      ail_vTraceMsg( TR_LEVEL_FATAL, "Application 0x%04x: power-msg of type invalid %d", u16AppId, u16PwrType);
   }

   if ( (u16PwrType == AMT_C_U16_PWR_APP_ERROR_DETECT) && (bRetVal == FALSE) )
   {
      // we failed to send an error-detect-msg to the SPM.
      // there is no other way to shutdown, call assert.
      OSAL_vAssert(FALSE); //lint !e506
   }

   return bRetVal;
  //## end ail_tclAppInterfaceRestricted::bSendCCAPowerMsg%3CC54DAA0256.body
}

tBool ail_tclAppInterfaceRestricted::bSendCCASrvSupplierMsg(tU16 u16Service, tBool bRegister, tBool bUserApplication)
{
  tBool bRetVal = FALSE;

  #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
    ail_vTraceMsg(TR_LEVEL_USER_2, "Application 0x%04x: ail_tclAppInterfaceRestricted::bSendCCASrvSupplierMsg() called. ServiceId=0x%04X, bRegister=%d, UserApp=%d",
                  u16AppId, u16Service, bRegister, bUserApplication);
  #endif

  if (FALSE == bUserApplication)
  {
    if (TRUE == bRegister)
    {
      #ifndef VARIANT_S_FTR_ENABLE_AIL_ASYNC_SRV_REG_SPM_SHORTCUT

        amt_tclServiceSupplierRegister oSuppRegisterMsg(u16AppId, CCA_C_U16_APP_SPM, u16Service);

        if (oSuppRegisterMsg.bIsValid() == TRUE)
        {
          bRetVal = bPostIpcMessage(u16AppId, hGetLpmInQueue(), &oSuppRegisterMsg, AIL_C_U32_CCA_PRIO_MSG_SERVICE_SUPPLIER_REGISTER);

          if (FALSE == bRetVal)
          {
            oSuppRegisterMsg.bDelete();
            ail_vTraceMsg( TR_LEVEL_FATAL, "Application 0x%04x: failed to send service supplier register ", u16AppId);
          }
          else
          {
            #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
              ail_vTraceMsg(TR_LEVEL_USER_2, "Application 0x%04x: bSendCCASrvSupplierMsg() => Register. ServiceId=0x%04X",
                            u16AppId, u16Service);
            #endif
          }
        }
        else
        {
          ail_vTraceMsg(TR_LEVEL_FATAL, "Application 0x%04x: service supplier register msg invalid", u16AppId);
        }

      #else

        tU32         u32NbrOfAppInfos = 1;   
        trScdAppInfo rScdAppInfo;

        if (scd_bGetAppIdFromServiceId(u16Service, &u32NbrOfAppInfos, &rScdAppInfo) == TRUE)
        {
          if (u32NbrOfAppInfos == 1)
          {
            amt_tclServiceSupplierStatus oServiceSupplierState(CCA_C_U16_APP_SPM, 
                                                               u16AppId, 
                                                               u16Service, 
                                                               rScdAppInfo.u16AppId, 
                                                               AMT_C_U8_CCAMSG_SUPPLIER_STATE_AVAILABLE);

            bRetVal = bPostIpcMessage(u16AppId, hGetMyInQueue(), &oServiceSupplierState, AIL_C_U32_CCA_PRIO_MSG_SERVICE_SUPPLIER_STATUS);

            if (FALSE == bRetVal)
            {
              oServiceSupplierState.bDelete();
              ail_vTraceMsg(TR_LEVEL_FATAL, "Application 0x%04x: bSendCCASrvSupplierMsg() => Failed to send ServiceSupplierStatus SHORTCUT message", u16AppId);
            }
            else
            {
              #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
                ail_vTraceMsg(TR_LEVEL_USER_2, "Application 0x%04x: bSendCCASrvSupplierMsg() => ServiceSupplierStatus SHORTCUT message successfully sent (UserApp = %d). ServerAppId=0x%04X",
                              u16AppId, bUserApplication, rScdAppInfo.u16AppId);
              #endif
            }
          }
          else if (u32NbrOfAppInfos > 1)
          {
            NORMAL_M_ASSERT_ALWAYS();
          }
          else /* u32NbrOfAppInfos == 0 */
          {
            ail_vTraceMsg(TR_LEVEL_FATAL, "Application 0x%04x: bSendCCASrvSupplierMsg() => ServiceId 0x%04X not found in registry", u16AppId, u16Service);
          }
        }
        else
        {
          NORMAL_M_ASSERT_ALWAYS();
        }
      #endif
    }
    else
    {
      #ifndef VARIANT_S_FTR_ENABLE_AIL_ASYNC_SRV_REG_SPM_SHORTCUT

        amt_tclServiceSupplierUnregister oSuppUnregisterMsg(u16AppId, CCA_C_U16_APP_SPM, u16Service);

        if (oSuppUnregisterMsg.bIsValid())
        {
          bRetVal = bPostIpcMessage(u16AppId, hGetLpmInQueue(), &oSuppUnregisterMsg, AIL_C_U32_CCA_PRIO_MSG_SERVICE_SUPPLIER_UNREGISTER);

          if (FALSE == bRetVal)
          {
             oSuppUnregisterMsg.bDelete();
             ail_vTraceMsg( TR_LEVEL_FATAL, "Application 0x%04x: failed to send service supplier unregister ", u16AppId);
          }
          else
          {
            #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
              ail_vTraceMsg(TR_LEVEL_USER_2, "Application 0x%04x: bSendCCASrvSupplierMsg() => Unregister. ServiceId=0x%04X",
                            u16AppId, u16Service);
            #endif
          }
        }
        else
        {
           ail_vTraceMsg(TR_LEVEL_FATAL, "Application 0x%04x: service supplier unregister msg invalid", u16AppId );
        }
      #else
        bRetVal = TRUE;
      #endif
    }
  }
  else
  {
    ail_vTraceMsg(TR_LEVEL_FATAL, "Application 0x%04x: ail_tclAppInterfaceRestricted::bSendCCASrvSupplierMsg() should not be called from outside the AIL.", u16AppId);
  }

  return bRetVal;
}

tBool ail_tclAppInterfaceRestricted::bSendAppInfoMsg(tU16 u16ApplicationId, tBool bRegister, tBool bUserApplication, tBool bListAccessAlreadyTaken)
{
  tBool bRetVal                      = FALSE;
  tBool bSendMessage                 = FALSE;
  tBool bDedicatedServer             = FALSE;
  tBool bServerApplicationEntryFound = FALSE;
  tBool bListAccessTaken             = FALSE;
  tU16  u16StoredServiceId           = AMT_C_U16_SERVICE_UNDEF;
  tU16  u16StoredAppId               = AMT_C_U16_APPID_INVALID;     

  #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
    ail_vTraceMsg(TR_LEVEL_USER_2, "Application 0x%04x: ail_tclAppInterfaceRestricted::bSendAppInfoMsg() called. ServerAppId=0x%04X, bRegister=%d, UserApp=%d, ListAccessAlreadyTaken=%d",
                  u16AppId, u16ApplicationId, bRegister, bUserApplication, bListAccessAlreadyTaken);
  #endif

  if (TRUE == bRegister)
  {
    if (TRUE == bUserApplication)
    {
      if (FALSE == bListAccessAlreadyTaken)
      {
        bListAccessTaken = ail_bTakeListAccess(hGeneralListAccess);
      }
      else
      {
        bListAccessTaken = TRUE;
      }

      ail_tenServerAppState enServerAppState = AIL_EN_SERVER_APP_STATE_UNKNOWN;

      if (TRUE == bListAccessTaken)
      {
        if (bServerApplicationListAvailable() == TRUE)
        {
          ail_tclServerApplicationIterator oServerApplicationIterator(m_poServerApplicationList);

          while(oServerApplicationIterator.bIsDone() == FALSE)
          {
            u16StoredServiceId = oServerApplicationIterator.oItem().u16GetServiceId();
            u16StoredAppId     = oServerApplicationIterator.oItem().u16GetAppId();
            bDedicatedServer   = oServerApplicationIterator.oItem().bIsDedicatedServer();

            if (u16StoredAppId == u16ApplicationId)
            {
              if (bDedicatedServer == TRUE)
              {
                enServerAppState = oServerApplicationIterator.oItem().enGetServerAppState();
            
                if (u16StoredServiceId == AMT_C_U16_SERVICE_UNDEF)
                {
                  bServerApplicationEntryFound = TRUE;

                  break;
                }
              }
            }

            oServerApplicationIterator.vNext();
          }

          if (FALSE == bServerApplicationEntryFound)
          {
            if (enServerAppState == AIL_EN_SERVER_APP_STATE_UNKNOWN)
            {
              enServerAppState = AIL_EN_SERVER_APP_STATE_REQUESTED;
              bSendMessage = TRUE;
            }

            ail_tclServerApplication oServerApplication(u16ApplicationId, AMT_C_U16_SERVICE_UNDEF,
                                                        TRUE, // DedicatedServer = TRUE
                                                        ail_tclServiceRequest (0xFFFF, 0xFFFF, 0xFFFF),
                                                        enServerAppState);

            m_poServerApplicationList->vAdd(oServerApplication);

            #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
              ail_vTraceMsg(TR_LEVEL_USER_2, "Application 0x%04x: ail_tclAppInterfaceRestricted::bSendAppInfoMsg() => Added server application entry. ServiceID=0x%04X, ServerAppID=0x%04X",
                            u16AppId, AMT_C_U16_SERVICE_UNDEF, u16ApplicationId);
            #endif
          }
          else
          {
            ail_vTraceMsg(TR_LEVEL_FATAL, "Application 0x%04x: bSendAppInfoMsg() => Failed to send AppInfoRegister message. Already registered for ServerAppId=0x%04X",
                          u16AppId, u16ApplicationId);
          }
        }

        if (FALSE == bListAccessAlreadyTaken)
        {
          ail_bReleaseListAccess(hGeneralListAccess);
        }

        if (enServerAppState == AIL_EN_SERVER_APP_STATE_AVAILABLE)
        {
          vOnApplicationInfoStatus(u16ApplicationId, (tU8)enServerAppState);
        }
      }
    }
    else
    {
      bSendMessage = TRUE;
    }

    if (TRUE == bSendMessage)
    {
      #ifndef VARIANT_S_FTR_ENABLE_AIL_ASYNC_SRV_REG_SPM_SHORTCUT

        amt_tclApplicationInfoRegister oAppInfoRegisterMsg(u16AppId, CCA_C_U16_APP_SPM, u16ApplicationId);

        if (oAppInfoRegisterMsg.bIsValid() == TRUE)
        {
          bRetVal = bPostIpcMessage(u16AppId, hGetLpmInQueue(), &oAppInfoRegisterMsg, AIL_C_U32_CCA_PRIO_MSG_APPLICATION_INFO_REGISTER);

          if (FALSE == bRetVal)
          {
            oAppInfoRegisterMsg.bDelete();
            ail_vTraceMsg(TR_LEVEL_FATAL, "Application 0x%04x: bSendAppInfoMsg() => Failed to send AppInfoRegister message", u16AppId);
          }
          else
          {
            #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
              ail_vTraceMsg(TR_LEVEL_USER_2, "Application 0x%04x: bSendAppInfoMsg() => AppInfoRegister message successfully sent (UserApp = %d). ServerAppId=0x%04X",
                            u16AppId, bUserApplication, u16ApplicationId);
            #endif
          }
        }
        else
        {
          ail_vTraceMsg(TR_LEVEL_FATAL, "Application 0x%04x: bSendAppInfoMsg() => AppInfoRegister message invalid", u16AppId);
        }

      #else

        amt_tclApplicationInfoStatus oAppInfoState(CCA_C_U16_APP_SPM, u16AppId, u16ApplicationId, AMT_C_U8_CCAMSG_APPLICATION_INFO_AVAILABLE);

        bRetVal = bPostIpcMessage(u16AppId, hGetMyInQueue(), &oAppInfoState, AIL_C_U32_CCA_PRIO_MSG_APPLICATION_INFO_STATUS);

        if (FALSE == bRetVal)
        {
           oAppInfoState.bDelete();
           ail_vTraceMsg(TR_LEVEL_FATAL, "Application 0x%04x: bSendAppInfoMsg() => Failed to send AppInfoStatus SHORTCUT message", u16AppId);
        }
        else
        {
          #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
            ail_vTraceMsg(TR_LEVEL_USER_2, "Application 0x%04x: bSendAppInfoMsg() => AppInfoStatus SHORTCUT message successfully sent (UserApp = %d). ServerAppId=0x%04X",
                          u16AppId, bUserApplication, u16ApplicationId);
          #endif
        }

      #endif
    }
  }
  else
  {
    if (TRUE == bUserApplication)
    {
      if (FALSE == bListAccessAlreadyTaken)
      {
        bListAccessTaken = ail_bTakeListAccess(hGeneralListAccess);
      }
      else
      {
        bListAccessTaken = TRUE;
      }

      if (TRUE == bListAccessTaken)
      {
        if (bServerApplicationListAvailable() == TRUE)
        {
          ail_tclServerApplicationIterator oServerApplicationIterator1(m_poServerApplicationList);

          while(oServerApplicationIterator1.bIsDone() == FALSE)
          {
            u16StoredServiceId = oServerApplicationIterator1.oItem().u16GetServiceId();
            u16StoredAppId     = oServerApplicationIterator1.oItem().u16GetAppId();
            bDedicatedServer   = oServerApplicationIterator1.oItem().bIsDedicatedServer();

            if ((bDedicatedServer == TRUE)                      &&
                (u16StoredAppId == u16ApplicationId)            && 
                (u16StoredServiceId == AMT_C_U16_SERVICE_UNDEF)   )
            {
              m_poServerApplicationList->nRemove(oServerApplicationIterator1.oItem());

              #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
                ail_vTraceMsg(TR_LEVEL_USER_2, "Application 0x%04x: ail_tclAppInterfaceRestricted::bSendAppInfoMsg() => Removed server application entry. ServiceID=0x%04X, ServerAppID=0x%04X",
                              u16AppId, u16StoredServiceId, u16StoredAppId);
              #endif

              bServerApplicationEntryFound = TRUE;

              break;
            }

            oServerApplicationIterator1.vNext();
          }

          if (TRUE == bServerApplicationEntryFound)
          {
            ail_tclServerApplicationIterator oServerApplicationIterator2(m_poServerApplicationList);

            // Send final ApplicationInfoUnregister message if we don't 
            // find another dedicated server entry with this application ID.
            bSendMessage = TRUE;

            while(oServerApplicationIterator2.bIsDone() == FALSE)
            {
              u16StoredAppId   = oServerApplicationIterator2.oItem().u16GetAppId();
              bDedicatedServer = oServerApplicationIterator2.oItem().bIsDedicatedServer();

              if ((bDedicatedServer == TRUE)           &&
                  (u16StoredAppId == u16ApplicationId)   )
              {
                bSendMessage = FALSE;

                break;
              }

              oServerApplicationIterator2.vNext();
            }
          }
          else
          {
            ail_vTraceMsg(TR_LEVEL_FATAL, "Application 0x%04x: bSendAppInfoMsg() => Failed to send AppInfoUnregister message. No yet sent a preceding AppInfoRegister message for ServerAppId=0x%04X",
                          u16AppId, u16ApplicationId);
          }
        }

        if (FALSE == bListAccessAlreadyTaken)
        {
          ail_bReleaseListAccess(hGeneralListAccess);
        }
      }
    }
    else
    {
      bSendMessage = TRUE;
    }

    if (TRUE == bSendMessage)
    {
      #ifndef VARIANT_S_FTR_ENABLE_AIL_ASYNC_SRV_REG_SPM_SHORTCUT

        amt_tclApplicationInfoUnregister oAppInfoUnregisterMsg(u16AppId, CCA_C_U16_APP_SPM, u16ApplicationId);

        if (oAppInfoUnregisterMsg.bIsValid())
        {
          bRetVal = bPostIpcMessage(u16AppId, hGetLpmInQueue(), &oAppInfoUnregisterMsg, AIL_C_U32_CCA_PRIO_MSG_APPLICATION_INFO_UNREGISTER);

          if ( !bRetVal )
          {
             oAppInfoUnregisterMsg.bDelete();
             ail_vTraceMsg( TR_LEVEL_FATAL, "Application 0x%04x: failed to send app info unregister ", u16AppId);
          }
          else
          {
            #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
              ail_vTraceMsg(TR_LEVEL_USER_2, "Application 0x%04x: bSendAppInfoMsg() => AppInfoUnregister message successfully sent (UserApp = %d). ServerAppId=0x%04X",
                            u16AppId, bUserApplication, u16ApplicationId);
            #endif
          }
        }
        else
        {
           ail_vTraceMsg( TR_LEVEL_FATAL, "Application 0x%04x: service app info unregister msg invalid", u16AppId );
        }

      #else
        bRetVal = TRUE;
      #endif
    }
  }

  return bRetVal;
}

tBool ail_tclAppInterfaceRestricted::bSendCCAPowerUserTrigger (tU32 u32PwrData1)
{
  //## begin ail_tclAppInterfaceRestricted::bSendCCAPowerUserTrigger%3CC54DAA0256.body preserve=yes
   tBool bRetVal = FALSE;

   if (u32LastConfirmedAppState > AMT_C_U32_STATE_INITIALIZED)
   {

       amt_tclPowerMessage oPowerMessage (u16AppId, CCA_C_U16_APP_SPM, AMT_C_U16_PWR_USER_TRIGGER, u32PwrData1, 0);

       if ( oPowerMessage.bIsValid() )
       {
          bRetVal = bPostIpcMessage(u16AppId, hGetLpmInQueue(), &oPowerMessage, AIL_C_U32_CCA_PRIO_MSG_POWER);

          if ( !bRetVal )
          {
             oPowerMessage.bDelete();
             ail_vTraceMsg( TR_LEVEL_FATAL, "Application 0x%04x: failed to send power-msg user trigger", u16AppId );
          }
       }
       else
       {
          ail_vTraceMsg( TR_LEVEL_FATAL, "Application 0x%04x: power-msg user trigger invalid", u16AppId );
       }
   }
   else
   {
     ail_vTraceMsg( TR_LEVEL_FATAL, "Application 0x%04x: sending power-msg user trigger is only allowed if application initialized", u16AppId );
   }

   return bRetVal;
  //## end ail_tclAppInterfaceRestricted::bSendCCAPowerMsg%3CC54DAA0256.body
}

tVoid ail_tclAppInterfaceRestricted::vOnUnhandledAilException ()
{
  //## begin ail_tclAppInterfaceRestricted::vOnUnhandledAilException%3EBF3EEF0345.body preserve=yes
   
   // an unhandled exception occured --> assert
   OSAL_vAssert( FALSE ); //lint !e506

  //## end ail_tclAppInterfaceRestricted::vOnUnhandledAilException%3EBF3EEF0345.body
}

tVoid ail_tclAppInterfaceRestricted::vShutdownRequired (tBool bCondition, tCString coszFilename, tU32 u32Line)
{
  //## begin ail_tclAppInterfaceRestricted::vShutdownRequired%3EC9F531010D.body preserve=yes

   if ( !bCondition )
   {
      // Write message into trace stream
      ail_vTraceMsg( TR_LEVEL_FATAL,
         "Application 0x%04x: ShutdownRequired called from thread %d in file %s line %d",
         u16AppId, OSAL_ThreadWhoAmI(), (coszFilename ? coszFilename : "unknown"), u32Line );

      // send error-detected to LPM
      vOnRequiredShutdown();
   }

  //## end ail_tclAppInterfaceRestricted::vShutdownRequired%3EC9F531010D.body
}

tVoid ail_tclAppInterfaceRestricted::vOnRequiredShutdown ()
{
  //## begin ail_tclAppInterfaceRestricted::vOnRequiredShutdown%3ECCC312005B.body preserve=yes
   
   // send error-detect-msg to SPM
   vApplicationRequestErrorEnd(AIL_C_U32_ERROR_ONSHUTDOWN_REQUIRED);

  //## end ail_tclAppInterfaceRestricted::vOnRequiredShutdown%3ECCC312005B.body
}

ail_tWdgHandle ail_tclAppInterfaceRestricted::hCreateWdg (TR_tenTraceClass enTraceClass)
{
  //## begin ail_tclAppInterfaceRestricted::hCreateWdg%3EF6C4580255.body preserve=yes
   ail_tWdgHandle hWdg = OSAL_C_INVALID_HANDLE;

   if ( ail_bTakeListAccess( hGeneralListAccess ) )
   {
      if ( poWatchdogServer != OSAL_NULL )
         hWdg = poWatchdogServer->hCreateWdg(enTraceClass);
      ail_bReleaseListAccess( hGeneralListAccess );
   }

   return (hWdg);
  //## end ail_tclAppInterfaceRestricted::hCreateWdg%3EF6C4580255.body
}

tVoid ail_tclAppInterfaceRestricted::vDeleteWdg (ail_tWdgHandle hWdgHandle)
{
  //## begin ail_tclAppInterfaceRestricted::vDeleteWdg%3EF6C482037D.body preserve=yes
   if ( ail_bTakeListAccess( hGeneralListAccess ) )
   {
      if ( poWatchdogServer != OSAL_NULL )
         poWatchdogServer->vDeleteWdg(hWdgHandle);
      ail_bReleaseListAccess( hGeneralListAccess );
   }
  //## end ail_tclAppInterfaceRestricted::vDeleteWdg%3EF6C482037D.body
}

tBool ail_tclAppInterfaceRestricted::bActivateWdg (ail_tWdgHandle hWdgHandle, OSAL_tMSecond WdgInterval, OSAL_tMSecond MaxInterval)
{
  //## begin ail_tclAppInterfaceRestricted::bActivateWdg%3EF6C4A8024E.body preserve=yes
   tBool bActivated = FALSE;

   if ( ail_bTakeListAccess( hGeneralListAccess ) )
   {
      if ( poWatchdogServer != OSAL_NULL )
         bActivated = poWatchdogServer->bActivateWdg(hWdgHandle, WdgInterval, MaxInterval);
      ail_bReleaseListAccess( hGeneralListAccess );
   }

   return (bActivated);
  //## end ail_tclAppInterfaceRestricted::bActivateWdg%3EF6C4A8024E.body
}

tBool ail_tclAppInterfaceRestricted::bDeactivateWdg (ail_tWdgHandle hWdgHandle)
{
  //## begin ail_tclAppInterfaceRestricted::bDeactivateWdg%3EF6C4EA00EF.body preserve=yes
   tBool bDeactivated = FALSE;

   if ( ail_bTakeListAccess( hGeneralListAccess ) )
   {
      if ( poWatchdogServer != OSAL_NULL )
         bDeactivated = poWatchdogServer->bDeactivateWdg(hWdgHandle);
      ail_bReleaseListAccess( hGeneralListAccess );
   }

   return (bDeactivated);
  //## end ail_tclAppInterfaceRestricted::bDeactivateWdg%3EF6C4EA00EF.body
}

tVoid ail_tclAppInterfaceRestricted::vTriggerWdgServer (ail_tWdgHandle hWdgHandle)
{
  //## begin ail_tclAppInterfaceRestricted::vTriggerWdgServer%3EF6C5050085.body preserve=yes
   if ( ail_bTakeListAccess( hGeneralListAccess ) )
   {
      if ( poWatchdogServer != OSAL_NULL )
         poWatchdogServer->vTriggerWdg(hWdgHandle);
      ail_bReleaseListAccess( hGeneralListAccess );
   }
  //## end ail_tclAppInterfaceRestricted::vTriggerWdgServer%3EF6C5050085.body
}

#ifdef ARM_EIGHTBYTEALIGNSTACKPOINTER_PRE_FUNC
    #pragma push
    #pragma Ono_tailcall
#endif
tVoid ail_tclAppInterfaceRestricted::vWdgTimerEvent (tPVoid pvArg)
{
    //## begin ail_tclAppInterfaceRestricted::vWdgTimerEvent%3EF6CC7402B4.body preserve=yes

    //8 Byte Align Stack Pointer
    ARM_EIGHTBYTEALIGNSTACKPOINTER

        ail_tclAppInterfaceRestricted* poAil = static_cast<ail_tclAppInterfaceRestricted*>(pvArg);

        if ( poAil != OSAL_NULL )
        {
            amt_tclPowerMessage oPowerMessageWdg(poAil->u16LpmId,poAil->u16AppId,AMT_C_U16_PWR_WDOGTIMER,0x01,0x00);

            if ( oPowerMessageWdg.bIsValid() )
            {
                if (ail_bIpcMessagePost(poAil->u16LpmId, poAil->hMyInQueue, &oPowerMessageWdg, AIL_C_U32_CCA_PRIO_MSG_POWER ) != OSAL_E_NOERROR)
                {
                    oPowerMessageWdg.bDelete();
                    ail_vTraceMsg( TR_LEVEL_ERRORS, "Application 0x%04x: failed to send wdg-trigger-msg", poAil->u16AppId );
                }
            }
            else
            {
                ail_vTraceMsg( TR_LEVEL_ERRORS, "Application 0x%04x: wdg-trigger-msg invalid", poAil->u16AppId );
            }
        }

    //restore original Stack Pointer
    ARM_RESTORESTACKPOINTER
    //## end ail_tclAppInterfaceRestricted::vWdgTimerEvent%3EF6CC7402B4.body
}
#ifdef ARM_EIGHTBYTEALIGNSTACKPOINTER_POST_FUNC
    #pragma pop
#endif

tBool ail_tclAppInterfaceRestricted::bGetWatchdogInfo (ail_tWdgHandle hWdgHandle, OSAL_tThreadID &rfThreadID, OSAL_tMSecond &rfWdgInterval, OSAL_tMSecond &rfMaxInterval)
{
  //## begin ail_tclAppInterfaceRestricted::bGetWatchdogInfo%3EF7FE18015B.body preserve=yes
   tBool bFound = FALSE;
   if ( ail_bTakeListAccess( hGeneralListAccess ) )
   {
      if ( poWatchdogServer != OSAL_NULL )
         bFound = poWatchdogServer->bGetWatchdogInfo( hWdgHandle, rfThreadID, rfWdgInterval, rfMaxInterval );
      ail_bReleaseListAccess( hGeneralListAccess );
   }
   return (bFound);
  //## end ail_tclAppInterfaceRestricted::bGetWatchdogInfo%3EF7FE18015B.body
}

tBool ail_tclAppInterfaceRestricted::bGetServerRegisteredVersion(tU16 u16ServerAppId, tU16 u16ClientSubId, tU16 u16ServiceId, tU16 u16RegisterId, tU16& rfu16MajorVersion, tU16& rfu16MinorVersion, tU16& rfu16PatchVersion)
{
   tBool bSuccess = FALSE;
   tBool bFound = FALSE;   

   if (u16RegisterId == AIL_C_U16_INTERNAL_REGISTERID)
   {
      rfu16MajorVersion = AMT_C_U16_SERVICE_VERSION_INVALID;
      rfu16MinorVersion = AMT_C_U16_SERVICE_VERSION_INVALID;
      rfu16PatchVersion = AMT_C_U16_SERVICE_VERSION_INVALID;
      bSuccess = bGetServiceVersion(u16ServiceId,rfu16MajorVersion,rfu16MinorVersion,rfu16PatchVersion);
   }
   else
   {
      if (ail_bTakeListAccess(hGeneralListAccess))
      {
        ail_tclServiceReferenceIterator  iter(poServiceReferenceList);

        for ( ; !iter.bIsDone() && !bFound; iter.vNext())
        {
           if ( iter.oItem().bIsDataSet( u16ServiceId, u16ServerAppId, u16RegisterId, u16ClientSubId ) )
           {
              /* found the reference */
              bFound = TRUE;
              break;
           }
        }
   
        if ( bFound )
        {
           bSuccess = iter.oItem().bGetVersion(rfu16MajorVersion, rfu16MinorVersion, rfu16PatchVersion);
        }

        ail_bReleaseListAccess(hGeneralListAccess);
      }
   }

   return bSuccess;
}

tU16 ail_tclAppInterfaceRestricted::u16GetServerRegisteredMajorVersion(tU16 u16ServerAppId, tU16 u16ClientSubId, tU16 u16ServiceId, tU16 u16RegisterId)
{
   tU16 u16MajorVersion = AMT_C_U16_SERVICE_VERSION_INVALID;
   tBool bFound = FALSE;

   if (u16RegisterId == AIL_C_U16_INTERNAL_REGISTERID)
   {
      tU16 u16MinorVersion = AMT_C_U16_SERVICE_VERSION_INVALID;
      tU16 u16PatchVersion = AMT_C_U16_SERVICE_VERSION_INVALID;
      if (!bGetServiceVersion(u16ServiceId,u16MajorVersion,u16MinorVersion,u16PatchVersion))
      {
         u16MajorVersion = AMT_C_U16_SERVICE_VERSION_INVALID;
      }
   }
   else
   {
      if (ail_bTakeListAccess(hGeneralListAccess))
      {
        ail_tclServiceReferenceIterator  iter(poServiceReferenceList);

        for ( ; !iter.bIsDone() && !bFound; iter.vNext())
        {
           if ( iter.oItem().bIsDataSet( u16ServiceId, u16ServerAppId, u16RegisterId, u16ClientSubId ) )
           {
              /* found the reference */
              bFound = TRUE;
              break;
           }
        }
   
        if ( bFound )
        {
           u16MajorVersion = iter.oItem().u16GetMajorVersion();
        }

        ail_bReleaseListAccess(hGeneralListAccess);
      }
   }
   return u16MajorVersion;
}

tBool ail_tclAppInterfaceRestricted::bGetClientRegisteredVersion(tU16 u16ServiceId, tU16 u16RegisterId, tU16& u16MajorVersion, tU16& u16MinorVersion, tU16& u16PatchVersion)
{
   tBool bSuccess = FALSE;
   tBool bFound = FALSE;

   if (u16RegisterId == AIL_C_U16_INTERNAL_REGISTERID)
   {
      u16MajorVersion = AMT_C_U16_SERVICE_VERSION_INVALID;
      u16MinorVersion = AMT_C_U16_SERVICE_VERSION_INVALID;
      u16PatchVersion = AMT_C_U16_SERVICE_VERSION_INVALID;
      bSuccess = bGetServiceVersion(u16ServiceId,u16MajorVersion,u16MinorVersion,u16PatchVersion);
   }
   else
   {
      if (ail_bTakeListAccess(hGeneralListAccess))
      {
        ail_tclServiceRegistryIterator  iter(poServiceRegistryList);

        for ( ; !iter.bIsDone() && !bFound; iter.vNext())
        {
           if ( iter.oItem().bIsDataSet( u16RegisterId ) )
           {
              /* found the reference */
              bFound = TRUE;
              break;
           }
        }
   
        if ( bFound )
        {
           bSuccess = iter.oItem().bGetVersion(u16MajorVersion,u16MinorVersion,u16PatchVersion);
        }

        ail_bReleaseListAccess(hGeneralListAccess);
      }
   }
   return bSuccess;
}

tU16 ail_tclAppInterfaceRestricted::u16GetClientRegisteredMajorVersion(tU16 u16ServiceId, tU16 u16RegisterId)
{
   tU16 u16MajorVersion = AMT_C_U16_SERVICE_VERSION_INVALID;
   tBool bFound = FALSE;
   
   if (u16RegisterId == AIL_C_U16_INTERNAL_REGISTERID)
   {
      tU16 u16MinorVersion = AMT_C_U16_SERVICE_VERSION_INVALID;
      tU16 u16PatchVersion = AMT_C_U16_SERVICE_VERSION_INVALID;
      if (!bGetServiceVersion(u16ServiceId,u16MajorVersion,u16MinorVersion,u16PatchVersion))
      {
         u16MajorVersion = AMT_C_U16_SERVICE_VERSION_INVALID;
      }
   }
   else
   {
      if (ail_bTakeListAccess(hGeneralListAccess))
      {
        ail_tclServiceRegistryIterator  iter(poServiceRegistryList);

        for ( ; !iter.bIsDone() && !bFound; iter.vNext())
        {
           if ( iter.oItem().bIsDataSet( u16RegisterId ) )
           {
              /* found the reference */
              bFound = TRUE;
              break;
           }
        }
   
        if ( bFound )
        {
           u16MajorVersion = iter.oItem().u16GetMajorVersion();
        }

        ail_bReleaseListAccess(hGeneralListAccess);
      }
   }
   return u16MajorVersion;
}

/*******************************************************************************
*
* FUNCTION: ail_tclAppInterfaceRestricted::bServerApplicationListAvailable()
*
* DESCRIPTION: Check if the server application list represented by the member 
*              variable m_poServerApplicationList is initialized and ready for 
*              use. 
*
*              Throw an assert if the server application list is not initialized.
*              The initialization of the server application list is already done 
*              in the bInitInstance() method which is always called before this 
*              method bServerApplicationListAvailable() and therefore the server 
*              application list should be initialized at this point.
*
* PARAMETER: None.
*
* RETURNVALUE: TRUE  = The server application list is available.
*              FALSE = The server application list is NOT available.
*
*******************************************************************************/
tBool ail_tclAppInterfaceRestricted::bServerApplicationListAvailable()
{
  tBool bResult = TRUE;

  if (m_poServerApplicationList == NULL)
  {
    bResult = FALSE;

    NORMAL_M_ASSERT_ALWAYS();
  }

  return bResult;
}

// Class ail_tclAppInterface 

ail_tclAppInterface::ail_tclAppInterface (tU32 u32SizeOfEntryJumpStackSize, tU32 u32SizeOfEntryDestroyStackSize, tU32 u32SizeOfBodyJumpStackSize, tU32 u32SizeOfBodyDestroyStackSize)
  //## begin ail_tclAppInterface::ail_tclAppInterface%3B2F22D70014.hasinit preserve=no
  //## end ail_tclAppInterface::ail_tclAppInterface%3B2F22D70014.hasinit
  //## begin ail_tclAppInterface::ail_tclAppInterface%3B2F22D70014.initialization preserve=yes
  : ail_tclOneThreadAppInterface(u32SizeOfEntryJumpStackSize,u32SizeOfEntryDestroyStackSize)
  , hIntermediateInQueue(OSAL_C_INVALID_HANDLE)
  , hBodyThreadID(OSAL_ERROR)
  , u32BodyJumpStackSize(u32SizeOfBodyJumpStackSize)
  , u32BodyDestroyStackSize(u32SizeOfBodyDestroyStackSize)
  //## end ail_tclAppInterface::ail_tclAppInterface%3B2F22D70014.initialization
{
  //## begin ail_tclAppInterface::ail_tclAppInterface%3B2F22D70014.body preserve=yes
  //## end ail_tclAppInterface::ail_tclAppInterface%3B2F22D70014.body
}


ail_tclAppInterface::~ail_tclAppInterface ()
{
  //## begin ail_tclAppInterface::~ail_tclAppInterface%3B2F22FA0190.body preserve=yes
  //## end ail_tclAppInterface::~ail_tclAppInterface%3B2F22FA0190.body
}



//## Other Operations (implementation)
tBool ail_tclAppInterface::bInitInstance (tU16 u16NewLpmId, tU16 u16MyAppId, OSAL_tThreadID hExternalDispatcherThreadID)
{
  //## begin ail_tclAppInterface::bInitInstance%3A9229FC0145.body preserve=yes

   tBool bSuccess = FALSE;

   (tVoid) hExternalDispatcherThreadID; // Parameter not used.

   poAsyncRegisterReqList = OSAL_NEW ail_tclAsyncRegisterReqList;

   if ( poAsyncRegisterReqList )
   {
      // create message-queue
      if ( u16MyAppId != AMT_C_U16_APPID_INVALID )
      {
         bSuccess = scd_bCreateQueue( u16MyAppId );
   
         if ( bSuccess )
         {
            bMyQueueCreated = TRUE;
      
            /* preset of all start parameters */
            scd_trAppInterfaceConfiguration rAppConf = { };
            tU32  u32EntryThreadPrio = 0, u32BodyThreadPrio = 0;
            tS32  s32EntryThreadStackSize = 0, s32BodyThreadStackSize = 0;
            tU32  u32IntermediateMbxSize = 0, u32GeneralMessageSize = 0;
            tS32  s32Ret;
            tChar szCreationName[C_U16_GENERATION_NAME_MAX] = "\0";
      
            // store IDs locally (if stored in bEntryThreadSetup,
            //  vDeinitInstance wouldn't close queue-handle in case of failure)
            u16LpmId = u16NewLpmId;
            u16AppId = u16MyAppId;
      
            bSuccess = scd_bGetAppInterfaceConfiguration(u16AppId, &rAppConf);
      
            if ( bSuccess )
            {
               u32IntermediateMbxSize = rAppConf.u32MsgCountIntermediateMbx;
               u32WdgTime = rAppConf.u32WatchdogInterval;
      
               /*bAutoRequestTimeOnStateChange = (   rAppConf.u32AutoRequestTimeOnStateChange
                                                != SCD_C_U32_DONT_AUTOREQUEST_TIME_ON_STATECHANGE );*/
      
               // TEMPORARY START
               // Following code is only temporary, parameter will be moved to aif-section in next version
               tCString coszKeyname = "APP_CONFIG";
               tCString coszParametername = "AUTOREQUEST_TIME_ON_STATECHANGE";
               tU32 u32Dummy = 0;
                if (    scd_bGetAppConfigurationValue( u16AppId, coszKeyname, coszParametername, &u32Dummy)
                     && u32Dummy != 0 )
                {
                   bAutoRequestTimeOnStateChange = TRUE;
                }
                else
                {
                   bAutoRequestTimeOnStateChange = FALSE;
                }
                // TEMPORARY END
      
      
               // get entry-thread-prio and -stacksize
               if ( scd_s32GetThreadConfiguration( u16AppId, (tCString)REGSTRING_AE, &u32EntryThreadPrio, &s32EntryThreadStackSize ) == OSAL_ERROR )
               {
                  bSuccess = FALSE;
                  ail_vTraceMsg(TR_LEVEL_FATAL, "Application 0x%04x: AppConfig could not be readed", u16AppId);
               }
            }
            else
            {
               ail_vTraceMsg(TR_LEVEL_FATAL, "Application 0x%04x: AppInterfaceConfiguration could not be readed", u16AppId);
            }
      
            if ( bSuccess )
            {
               // get body-thread-prio and -stacksize
               if ( scd_s32GetThreadConfiguration( u16AppId, (tCString)REGSTRING_AB, &u32BodyThreadPrio, &s32BodyThreadStackSize ) == OSAL_ERROR )
               {
                  ail_vTraceMsg(TR_LEVEL_FATAL, "Application 0x%04x: ThreadConfiguration could not be readed", u16AppId);
                  bSuccess = FALSE;
               }
            }
      
            if ( bSuccess )
            {
               u32GeneralMessageSize = SCD_MAILBOX_MAX_MESSAGE_LENGTH;
      
               /* create the dispatcher before starting the entry thread */
               if ( poInternalDispatch == NULL )
               {
                  poInternalDispatch = OSAL_NEW ail_tclInternalDispatch( this );
      
                  if ( !poInternalDispatch )
                  {
                     bSuccess = FALSE;
                     ail_vTraceMsg(TR_LEVEL_FATAL, "Application 0x%04x: dispatcher could not be created", u16AppId);
                  }
               }
            }
            
            if ( bSuccess )
            {
               /* open the intermediate queue between entry and body thread,
                  in a way like "IntermediateQueueGenerationName%d" ( %d = u16AppId ) */
               if (OSALUTIL_s32SaveNPrintFormat((tString)szCreationName, 
                                                sizeof(szCreationName),
                                                "%s%i", 
                                                ail_coszIntermediateQueueGenerationName, 
                                                u16AppId) != OSAL_ERROR)
               {
                 s32Ret = OSAL_s32MessageQueueCreate(szCreationName, u32IntermediateMbxSize, u32GeneralMessageSize, OSAL_EN_READWRITE, &hIntermediateInQueue);
                 if ( s32Ret != OSAL_OK )
                 {
                    hIntermediateInQueue = OSAL_C_INVALID_HANDLE;
                    bSuccess = FALSE;
                    ail_vTraceMsg(TR_LEVEL_FATAL, "Application 0x%04x: intermediate queue could not be created", u16AppId);
                 }
               }
               else
               {
                 NORMAL_M_ASSERT_ALWAYS();
                 hIntermediateInQueue = OSAL_C_INVALID_HANDLE;
                 bSuccess = FALSE;
               }
            }
      
            if ( bSuccess )
            {
               /* create semaphore to protect list access */
               if (OSALUTIL_s32SaveNPrintFormat((tString)szCreationName,
                                                sizeof(szCreationName),
                                                "%s%i", 
                                                ail_coszGeneralListSemaphoreGenerationName, 
                                                u16AppId) != OSAL_ERROR)
               {
                 s32Ret = OSAL_s32SemaphoreCreate ( szCreationName, &hGeneralListAccess, (tU32)1 );

                 if ( s32Ret != OSAL_OK )
                 {
                    hGeneralListAccess = OSAL_C_INVALID_HANDLE;
                    bSuccess = FALSE;
                    ail_vTraceMsg(TR_LEVEL_FATAL, "Application 0x%04x: semaphore to protect list could not be created", u16AppId);
                 }
               }
               else
               {
                 NORMAL_M_ASSERT_ALWAYS();
                 hIntermediateInQueue = OSAL_C_INVALID_HANDLE;
                 bSuccess = FALSE;
               }
            }
      
            if ( bSuccess )
            {
               /* create all lists */
               if ( poOpenedQueueList==NULL )
                  poOpenedQueueList = OSAL_NEW ail_tclOpenedQueueList;
               if ( poServiceReferenceList==NULL )
                  poServiceReferenceList = OSAL_NEW ail_tclServiceReferenceList;
               if ( poServiceRegistryList==NULL )
                  poServiceRegistryList = OSAL_NEW ail_tclServiceRegistryList;
               if ( poServiceSyncAnswerList==NULL )
                  poServiceSyncAnswerList = OSAL_NEW ail_tclServiceSyncAnswerList;
               if ( poPoolSemaphoreList==NULL )
                  poPoolSemaphoreList = OSAL_NEW ail_tclPoolSemaphoreList;
               if ( m_poServerApplicationList==NULL )
                  m_poServerApplicationList = OSAL_NEW ail_tclServerApplicationList;
      
               if ( !(  poOpenedQueueList
                     && poServiceReferenceList
                     && poServiceRegistryList
                     && poServiceSyncAnswerList
                     && poPoolSemaphoreList
                     && m_poServerApplicationList )
                  )
               {
                  /* not for all lists memory could be allocated */
                  bSuccess = FALSE;  
                  ail_vTraceMsg(TR_LEVEL_FATAL, "Application 0x%04x: one of the lists could not be created", u16AppId);
               }
            }
      
            if ( bSuccess )
            {
               if ( poWatchdogServer==NULL )
                  poWatchdogServer = OSAL_NEW ail_tclWatchdogServer();
               if ( !poWatchdogServer )
               {
                  // memory couldn't be allocated
                  bSuccess = FALSE;  
                  ail_vTraceMsg(TR_LEVEL_FATAL, "Application 0x%04x: WatchdogServer could not be created", u16AppId);
               }
               else
               {
                  // init watchdog-server
                  bSuccess = poWatchdogServer->bInit(&vWdgTimerEvent, this);
                  if (bSuccess != TRUE)
                  { 
                    ail_vTraceMsg(TR_LEVEL_FATAL, "Application 0x%04x: WatchdogServer could not be initialized", u16AppId);
                  }
               }
            }
      
            if ( bSuccess )
            {
               /* create and start the entry thread */
               bSuccess = bEntryThreadSetup( u32EntryThreadPrio, (tU32)s32EntryThreadStackSize );
               if (bSuccess != TRUE)
               {
                  ail_vTraceMsg(TR_LEVEL_FATAL, "Application 0x%04x: bEntryThreadSetup returns error", u16AppId);
               }
            }
      
            if ( bSuccess )
            {
               /* note: if creation of OSAL-Queues fails, the thread must not be started */
               OSAL_trThreadAttribute  rAttr;
            
               // create body-thread-name
               if (OSALUTIL_s32SaveNPrintFormat((tString)szCreationName,
                                                sizeof(szCreationName),
                                                "%s%X", 
                                                ail_coszBodyThreadGenerationName, 
                                                u16AppId) != OSAL_ERROR)
               {
                 rAttr.szName = szCreationName;
                 rAttr.s32StackSize = s32BodyThreadStackSize; 
                 rAttr.u32Priority = u32BodyThreadPrio;
                 rAttr.pfEntry = (OSAL_tpfThreadEntry)vStartAppBody;
                 rAttr.pvArg = (tPVoid)this;
         
                 hBodyThreadID = OSAL_ThreadSpawn(&rAttr);
      
                 if ( hBodyThreadID == OSAL_ERROR )
                 {
                     ail_vTraceMsg(TR_LEVEL_FATAL, 
                                   "Application 0x%04x: BodyThread could not be spawned (Name '%s', Prio %u, Stack %d). OSAL_ThreadSpawn() returns error '%s' ",
                                   u16AppId, 
                                   rAttr.szName, 
                                   rAttr.u32Priority, 
                                   rAttr.s32StackSize, 
                                   OSAL_coszErrorText(OSAL_u32ErrorCode()));

                     bSuccess = FALSE;
                 }
               }
               else
               {
                 NORMAL_M_ASSERT_ALWAYS();
                 bSuccess = FALSE;  
               }
            }
         
            if ( bSuccess )
            {
               /* last thread when shutdown will be the BODY-thread */
               hSupervisorThreadID = hBodyThreadID;
      
               // remember that we have a body-thread (needed for automatic request time for state-change in entry-thread)
               bHasBodyThread = TRUE;
            }
      
            if ( !bSuccess )
            {
               /* deinit of all add-ons of the derivated class */
               vDeinitInstance();
            }
         }
         else
         {
            ail_vTraceMsg(TR_LEVEL_ERRORS, "Application 0x%04x: Queue could not be created (Registry entry for app missing ?)", u16MyAppId);
         }
      }
      else
      {
         ail_vTraceMsg(TR_LEVEL_ERRORS, "Initinstance called with AppId = AMT_C_U16_APPID_INVALID");
      }
   }
   else
   {
      ail_vTraceMsg( TR_LEVEL_FATAL, "Application 0x%04x: failed to create ail_tclAsyncRegisterReqList", u16MyAppId );
   }

   return ( bSuccess );
  //## end ail_tclAppInterface::bInitInstance%3A9229FC0145.body
}

tVoid ail_tclAppInterface::vDeinitInstance ()
{
  //## begin ail_tclAppInterface::vDeinitInstance%3A9D20AA03D3.body preserve=yes

   if ( hBodyThreadID != OSAL_ERROR )
   {
      /* delete the body thread */
      OSAL_s32ThreadDelete ( hBodyThreadID ); //lint !e522: Expected void type, assignment, increment or decrement
      hBodyThreadID = OSAL_ERROR;
   }

   /* deinit of the base class */
   ail_tclOneThreadAppInterface::vDeinitInstance();

   if ( hIntermediateInQueue != OSAL_C_INVALID_HANDLE )
   {
      // close & delete the own intermediate queue
      tChar szCreationName[C_U16_GENERATION_NAME_MAX] = "\0";

      ail_vIpcClearMessageQueue( u16AppId, hIntermediateInQueue );

      if ( OSAL_s32MessageQueueClose( hIntermediateInQueue ) != OSAL_OK )
         ail_vTraceMsg( TR_LEVEL_ERRORS, "Application 0x%04x: can't close intermediate-queue %d", u16AppId, hIntermediateInQueue );

      hIntermediateInQueue = OSAL_C_INVALID_HANDLE;

      if (OSALUTIL_s32SaveNPrintFormat((tString)szCreationName,
                                       sizeof(szCreationName),
                                       "%s%i", 
                                       ail_coszIntermediateQueueGenerationName, 
                                       u16AppId) != OSAL_ERROR)
      {
        if ( OSAL_s32MessageQueueDelete ( szCreationName ) != OSAL_OK )
           ail_vTraceMsg( TR_LEVEL_ERRORS, "Application 0x%04x: can't delete queue %s", u16AppId, szCreationName );
      }
      else
      {
        NORMAL_M_ASSERT_ALWAYS();
      }
   }

  //## end ail_tclAppInterface::vDeinitInstance%3A9D20AA03D3.body
}

tVoid ail_tclAppInterface::vAppEntry ()
{
  //## begin ail_tclAppInterface::vAppEntry%3A928EBD02B5.body preserve=yes
   tBool                   bBlocked = TRUE;
   amt_tclBaseMessage      oMsgObject;
   tU32                    u32Prio;
   {
      ail_vTraceMsg( TR_LEVEL_COMPONENT,"Application 0x%04x: I'm the AppEntry of ail_tclAppInterface!", u16AppId );

#ifdef AIL_USE_TRY_CATCH
      try
#endif
      {
         if ( poInternalDispatch!=NULL )
         {
            while ( bBlocked )
            {
               if ( ail_bIpcMessageWait( u16AppId, hMyInQueue, &oMsgObject, &u32Prio, OSAL_C_U32_INFINITE ) )
               {
                  bBlocked = poInternalDispatch->bDispatchCCAMessages(&oMsgObject, hIntermediateInQueue, FALSE, u32Prio);
               }
            }
         }
         else
         {
            ail_vTraceMsg( TR_LEVEL_FATAL, "Application 0x%04x: poInternalDispatch==NULL", u16AppId );
         }
      }
#ifdef AIL_USE_TRY_CATCH
      catch (...)
      {
         ail_vTraceMsg( TR_LEVEL_ERRORS, "Application 0x%04x: unhandled exception occured in Entry-Thread", u16AppId );
         vOnUnhandledAilException();
      }
      
#endif
   }

   // give a trigger to body-thread that your job is done
   vEntryEndNotification();

  //## end ail_tclAppInterface::vAppEntry%3A928EBD02B5.body
}

tVoid ail_tclAppInterface::vAppBody ()
{
  //## begin ail_tclAppInterface::vAppBody%3A922A5600C2.body preserve=yes
   tBool                   bBlocked = TRUE;
   amt_tclBaseMessage      oMsgObject;
   tU32                    u32Prio;
   {
      ail_vTraceMsg( TR_LEVEL_COMPONENT,"Application 0x%04x: I'm the AppBody of ail_tclAppInterface!", u16AppId );

#ifdef AIL_USE_TRY_CATCH
      try
#endif
      {
         /* application is ready to receive a command from the supervisor */
         enInterfaceState = AIL_EN_N_APPLICATION_REGISTERED;

         if ( u16LpmId != AMT_C_U16_APPID_INVALID )
         {
            (tVoid)bSendCCAPowerMsg (u16LpmId, hGetLpmInQueue(), AIL_C_U32_CCA_PRIO_MSG_POWER, AMT_C_U16_PWR_APP_START_REQ, (tU32)u16AppId, (tU32)0x00);
         }

         if ( poInternalDispatch!=NULL )
         {
            while ( bBlocked )
            {
               if ( ail_bIpcMessageWait( u16AppId, hIntermediateInQueue, &oMsgObject, &u32Prio, OSAL_C_U32_INFINITE ) )
               {
                  bBlocked = poInternalDispatch->bDispatchCCAMessages(&oMsgObject, OSAL_C_INVALID_HANDLE, FALSE, u32Prio);
               }
            }
         }
         else
         {
            ail_vTraceMsg( TR_LEVEL_ERRORS, "Application 0x%04x: poInternalDispatch==NULL", u16AppId );
         }
      }
#ifdef AIL_USE_TRY_CATCH
      catch (...)
      {
         ail_vTraceMsg( TR_LEVEL_ERRORS, "Application 0x%04x: unhandled exception occured in Body-Thread", u16AppId );
         vOnUnhandledAilException();
      }
      
#endif
   }

   /* release all basic class objects && inform LPX of correct shutdown */
   vTerminateMySelf ();

   /* from now, ail tracing is forbidden */
   ail_vExitAilTrace();

  //## end ail_tclAppInterface::vAppBody%3A922A5600C2.body
}

#ifdef ARM_EIGHTBYTEALIGNSTACKPOINTER_PRE_FUNC
    #pragma push
    #pragma Ono_tailcall
#endif
tVoid ail_tclAppInterface::vStartAppBody (tVoid* pvArg)
{
   //8 Byte Align Stack Pointer
   ARM_EIGHTBYTEALIGNSTACKPOINTER

   //## begin ail_tclAppInterface::vStartAppBody%3A922A5B035E.body preserve=yes

   ail_tclAppInterface* poAppInterface = (ail_tclAppInterface*)pvArg;

   /* demanded on the object pointer, it starts the BASIC or DERIVED entry function */
   poAppInterface->vAppBody();

   //## end ail_tclAppInterface::vStartAppBody%3A922A5B035E.body

   //restore original Stack Pointer
   ARM_RESTORESTACKPOINTER
}
#ifdef ARM_EIGHTBYTEALIGNSTACKPOINTER_POST_FUNC
    #pragma pop
#endif

OSAL_tMQueueHandle ail_tclAppInterface::hGetIntermediateInQueue () const
{
  //## begin ail_tclAppInterface::hGetIntermediateInQueue%3B937C1300A2.body preserve=yes
  return ( hIntermediateInQueue );
  //## end ail_tclAppInterface::hGetIntermediateInQueue%3B937C1300A2.body
}

tVoid ail_tclAppInterface::vTerminateMySelf ()
{
  //## begin ail_tclAppInterface::vTerminateMySelf%3B98A32100EE.body preserve=yes

   // terminating my own objects

   /* terminating all objects of the base class */
   ail_tclOneThreadAppInterface::vTerminateMySelf ();

  //## end ail_tclAppInterface::vTerminateMySelf%3B98A32100EE.body
}

tVoid ail_tclAppInterface::vEntryEndNotification ()
{
  //## begin ail_tclAppInterface::vEntryEndNotification%3B98A5640014.body preserve=yes

   /* that's all for today - say good bye boy - */
   (tVoid)bSendCCAPowerMsg (u16AppId, hIntermediateInQueue, AIL_C_U32_CCA_PRIO_MSG_POWER, AMT_C_U16_PWR_APP_END_SUCCESSFUL, 
                     u32LastConfirmedAppState, (tU32) 0x00);
  //## end ail_tclAppInterface::vEntryEndNotification%3B98A5640014.body
}

// Class ail_tclOneThreadAppInterface 

ail_tclOneThreadAppInterface::ail_tclOneThreadAppInterface (tU32 u32SizeOfEntryJumpStackSize, tU32 u32SizeOfEntryDestroyStackSize)
  //## begin ail_tclOneThreadAppInterface::ail_tclOneThreadAppInterface%3D60A0150046.hasinit preserve=no
  //## end ail_tclOneThreadAppInterface::ail_tclOneThreadAppInterface%3D60A0150046.hasinit
  //## begin ail_tclOneThreadAppInterface::ail_tclOneThreadAppInterface%3D60A0150046.initialization preserve=yes
  :ail_tclAppInterfaceRestricted(u32SizeOfEntryJumpStackSize,u32SizeOfEntryDestroyStackSize)
  //## end ail_tclOneThreadAppInterface::ail_tclOneThreadAppInterface%3D60A0150046.initialization
{
  //## begin ail_tclOneThreadAppInterface::ail_tclOneThreadAppInterface%3D60A0150046.body preserve=yes

  poAsyncRegisterReqList = NULL;
  hAsyncRegisterTimer = OSAL_C_INVALID_HANDLE;

  //## end ail_tclOneThreadAppInterface::ail_tclOneThreadAppInterface%3D60A0150046.body
}


ail_tclOneThreadAppInterface::~ail_tclOneThreadAppInterface ()
{
  //## begin ail_tclOneThreadAppInterface::~ail_tclOneThreadAppInterface%3D60A0390383.body preserve=yes
   if ( poAsyncRegisterReqList )
   {
      OSAL_DELETE poAsyncRegisterReqList;
      poAsyncRegisterReqList = NULL;
   }
  //## end ail_tclOneThreadAppInterface::~ail_tclOneThreadAppInterface%3D60A0390383.body
}



//## Other Operations (implementation)
tBool ail_tclOneThreadAppInterface::bInitInstance (tU16 u16NewLpmId, tU16 u16MyAppId, OSAL_tThreadID hExternalDispatcherThreadID)
{
  //## begin ail_tclOneThreadAppInterface::bInitInstance%3D609C960306.body preserve=yes

   tBool bSuccess = FALSE;

   poAsyncRegisterReqList = OSAL_NEW ail_tclAsyncRegisterReqList;

   if ( poAsyncRegisterReqList )
   {
      bSuccess = TRUE;
   }
   else
   {
      ail_vTraceMsg( TR_LEVEL_ERRORS, "Application 0x%04x: failed to create ail_tclAsyncRegisterReqList", u16MyAppId );
   }

   if ( bSuccess )
   {
      bSuccess = ail_tclAppInterfaceRestricted::bInitInstance ( u16NewLpmId, u16MyAppId, hExternalDispatcherThreadID);
   }

   return ( bSuccess );
   
  //## end ail_tclOneThreadAppInterface::bInitInstance%3D609C960306.body
}

tVoid ail_tclOneThreadAppInterface::vDeinitInstance ()
{
  //## begin ail_tclOneThreadAppInterface::vDeinitInstance%3D609CAC039F.body preserve=yes

   /* free all lists */
   if ( poAsyncRegisterReqList )
   {
      OSAL_DELETE poAsyncRegisterReqList;
      poAsyncRegisterReqList = NULL;
   }

   ail_tclAppInterfaceRestricted::vDeinitInstance();

  //## end ail_tclOneThreadAppInterface::vDeinitInstance%3D609CAC039F.body
}

tVoid ail_tclOneThreadAppInterface::vTerminateMySelf ()
{
  //## begin ail_tclOneThreadAppInterface::vTerminateMySelf%3D60B041039D.body preserve=yes

   if ( hAsyncRegisterTimer != OSAL_C_INVALID_HANDLE )
   {
      /* don't forget to release the timer */
      /* stop timer */
      OSAL_s32TimerSetTime( hAsyncRegisterTimer, 0, 0 ); //lint !e522: Expected void type, assignment, increment or decrement
      /* and release timer */
      OSAL_s32TimerDelete( hAsyncRegisterTimer ); //lint !e522: Expected void type, assignment, increment or decrement
      hAsyncRegisterTimer = OSAL_C_INVALID_HANDLE;
   }

   /* terminating all objects of the base class */
   ail_tclAppInterfaceRestricted::vTerminateMySelf ();

  //## end ail_tclOneThreadAppInterface::vTerminateMySelf%3D60B041039D.body
}

tVoid ail_tclOneThreadAppInterface::vUnknownRegisterConf (amt_tclServiceRegisterConf& rfoServiceRegisterConf)
{
  //## begin ail_tclOneThreadAppInterface::vUnknownRegisterConf%3D5A6882017A.body preserve=yes
   tU8 u8RegisterState = rfoServiceRegisterConf.u8GetRegisterState();
   tU16 u16RegisterId = rfoServiceRegisterConf.u16GetRegisterID();
   tU16 u16ServerAppId = rfoServiceRegisterConf.u16GetSourceAppID();
   tU16 u16ServiceId = rfoServiceRegisterConf.u16GetServiceID();
   tU16 u16TargetSubId = rfoServiceRegisterConf.u16GetTargetSubID();

   #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
   tU16 u16TargetAppId = rfoServiceRegisterConf.u16GetTargetAppID();
   ail_vTraceMsg( TR_LEVEL_USER_2, "Application 0x%04x: OneThread Function vUnknownRegisterConf called, server-app-id=%x, service-id=%x, register-state=%x, register-id=%x, target-id=%x, target-sub-id=%x",
      u16AppId, u16ServerAppId, u16ServiceId, u8RegisterState, u16RegisterId, u16TargetAppId, u16TargetSubId );
   #endif

   if ( ail_bTakeListAccess( hGeneralListAccess ) )
   {
      /* list access is sheltered */
      tBool bFound = FALSE, bFreeTimer = FALSE;

      if (  poAsyncRegisterReqList
         && poServiceReferenceList
         && poAsyncRegisterReqList->nSize() )
      {
         /* an asynchronous answer is awaited */
         #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
         ail_vTraceMsg( TR_LEVEL_USER_2, "Application 0x%04x: An asynchronous answer is awaited", u16AppId );
         #endif

         ail_tclAsyncRegisterReqIterator  iter(poAsyncRegisterReqList);
         
         for (; !iter.bIsDone() && !bFound; iter.vNext())
         {
            if ( iter.oItem().bIsAnswer( u16ServerAppId, u16ServiceId, u16TargetSubId ) )
            {
               #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
               ail_vTraceMsg( TR_LEVEL_USER_2, "Application 0x%04x: Found item in list", u16AppId);
               #endif

               if ( u8RegisterState == AMT_C_U8_REGCONF_SUCCESS )
               {
                  /* fill the reference table first */
                  ail_tclServiceReference oServiceReference(u16ServerAppId, u16ServiceId, u16RegisterId, u16TargetSubId);
                  oServiceReference.vSetVersion(rfoServiceRegisterConf.u16GetServiceMajorVersion(),
                     rfoServiceRegisterConf.u16GetServiceMinorVersion(),rfoServiceRegisterConf.u16GetServicePatchVersion());
                  /* add the new registration request to registration list */        
                  poServiceReferenceList->vAdd(oServiceReference);
               }
               else
               {
                  if ((u8RegisterState == AMT_C_U8_REGCONF_SERVICE_VERSION_NOT_SUPPORTED) ||
                      (u8RegisterState == AMT_C_U8_REGCONF_NO_SUCCESS)                      )
                  {
                    // If an asynchronous service registration fails due to SERVICE_VERSION_NOT_SUPPORTED 
                    // we must remove the service-request entry from the Server-Application-List to again
                    // allow a service registration with ANOTHER major/minor service version number.

                    // AMT_C_U8_REGCONF_NO_SUCCESS is not sent anymore by this version of the AIL
                    // but we might run in a system environment where other processes still use older AIL 
                    // versions which still sends the unspecific reject reason of AMT_C_U8_REGCONF_NO_SUCCESS. 
                    // For such a case we must assume a reason for this AMT_C_U8_REGCONF_NO_SUCCESS and at 
                    // this place we just assume a 'service version not supported' reason. Therefore we remove 
                    // the service request also for the unspecific reject reason of AMT_C_U8_REGCONF_NO_SUCCESS.
                    vRemoveServiceRequest(u16ServiceId, u16ServerAppId, u16TargetSubId, TRUE, TRUE);
                  }

                  if ((u8RegisterState != AMT_C_U8_REGCONF_SERVICE_REGISTRATION_PENDING) &&
                      (u8RegisterState != AMT_C_U8_REGCONF_SERVICE_ALREADY_REGISTERED)     )
                  {
                    // Service-Register failed, check whether this client has other
                    //  registrations for this server
                    ail_vTraceMsg( TR_LEVEL_ERRORS, "Application 0x%04x: Service-Register failed, check this client", u16AppId);

                    #ifndef AIL_KEEP_MSG_QUEUE_HANDLES_TO_OTHER_APPS_UNTIL_TERMINATION
                    // examine for other registrations to this server
                    tBool bRegistrationFound = ail_bCheckRegistrationsToApp(poServiceReferenceList, poServiceRegistryList,
                       OSAL_C_INVALID_HANDLE, // access already protected
                       u16ServerAppId);

                    // if no other registration exists, close handle to
                    // messagequeue of this server
                    if (!bRegistrationFound)
                    {
                       if ( poOpenedQueueList )
                       {
                          ail_bDeleteFromOpenedQueueList(poOpenedQueueList,
                             OSAL_C_INVALID_HANDLE, // access already protected
                             u16ServerAppId);
                       } // else poOpenedQueueList doesn't exist
                    } // else other registrations to this server exists
                    #endif
                  }
               } // end else (register-state!=SUCCESS)

               /* found the reference */
               bFound = TRUE;
               break;
            }
         }

         if ( bFound )
         {
            if ((u8RegisterState != AMT_C_U8_REGCONF_SERVICE_REGISTRATION_PENDING) &&
                (u8RegisterState != AMT_C_U8_REGCONF_SERVICE_ALREADY_REGISTERED)     )
            {
              /* "nRemove"-operation influences the validity of the iterator */
              /* removed the found answer condition */
              poAsyncRegisterReqList->nRemove(iter.oItem());
            }
         }

         if ( !poAsyncRegisterReqList->nSize() )
         {
            /* timer is no more required */ 
            #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
            ail_vTraceMsg( TR_LEVEL_USER_2, "Application 0x%04x: Register Timer is no more required", u16AppId);
            #endif
            bFreeTimer = TRUE;
         }
      }
      else
      {
        if ((u8RegisterState != AMT_C_U8_REGCONF_SERVICE_REGISTRATION_PENDING) &&
            (u8RegisterState != AMT_C_U8_REGCONF_SERVICE_ALREADY_REGISTERED)     )
        {
          ail_vTraceMsg( TR_LEVEL_ERRORS, "Application 0x%04x: An asynchronous answer is not awaited !!!!!!", u16AppId );
        }
      }
      /* release the list access */
      ail_bReleaseListAccess( hGeneralListAccess );

      if ( hAsyncRegisterTimer != OSAL_C_INVALID_HANDLE  && bFreeTimer )
      {
         /* stop timer */
         OSAL_s32TimerSetTime( hAsyncRegisterTimer, 0, 0 ); //lint !e522: Expected void type, assignment, increment or decrement
         /* be carfull in using resources -> also release timer */
         OSAL_s32TimerDelete( hAsyncRegisterTimer ); //lint !e522: Expected void type, assignment, increment or decrement
         hAsyncRegisterTimer = OSAL_C_INVALID_HANDLE;
      }

      if ((bFound)                                                           || 
          (u8RegisterState == AMT_C_U8_REGCONF_SERVICE_REGISTRATION_PENDING) ||
          (u8RegisterState == AMT_C_U8_REGCONF_SERVICE_ALREADY_REGISTERED)     )
      {
         vHandleAsyncRegisterConf(u16RegisterId, u16ServerAppId, u16ServiceId, u16TargetSubId, u8RegisterState);
      }
      /* else synchronisation problem? -> unregister service automatically */
   }

  //## end ail_tclOneThreadAppInterface::vUnknownRegisterConf%3D5A6882017A.body
}

tVoid ail_tclOneThreadAppInterface::vOnAsyncRegisterConf (tU16 u16RegisterId, tU16 u16ServerAppId, tU16 u16ServiceId, tU16 u16TargetSubId)
{
  //## begin ail_tclOneThreadAppInterface::vOnAsyncRegisterConf%3D591F130006.body preserve=yes
   ail_vTraceMsg( TR_LEVEL_USER_2, "Application 0x%04x: Function vOnAsyncRegisterConf() called, register-id=0x%04X, server-app-id=0x%04X, service-id=0x%04X, target-sub-id=0x%04X",
      u16AppId, u16RegisterId, u16ServerAppId,u16ServiceId, u16TargetSubId );
  //## end ail_tclOneThreadAppInterface::vOnAsyncRegisterConf%3D591F130006.body
}

tVoid ail_tclOneThreadAppInterface::vOnAsyncRegisterConfExt(tU16 u16RegisterId, tU16 u16ServerAppId, tU16 u16ServiceId, tU16 u16TargetSubId, tU8 u8AsyncRegisterConfStatus)
{
   ail_vTraceMsg( TR_LEVEL_USER_2, "Application 0x%04x: Function vOnAsyncRegisterConfExt() called, register-id=0x%04X, server-app-id=0x%04X, service-id=0x%04X, target-sub-id=0x%04X, async-register-conf-status=%u",
      u16AppId, u16RegisterId, u16ServerAppId,u16ServiceId, u16TargetSubId, u8AsyncRegisterConfStatus );
}

/*******************************************************************************
*
* FUNCTION: tBool ail_tclOneThreadAppInterface::bRegisterAsync()
*
* DESCRIPTION: This method registers a client for a service. 
*
*              The server application which offers the service can be specified
*              (dedicated server) or unknown (none dedicated server).
*
*              Before the registration is performed at the server application the
*              availablity of the server application is determined by the use of
*              the SPM messages 'Service Supplier Register' (none dedicated server)
*              and 'Application Info Register' (dedicated server).
*
*              If the SPM states the server application which offers the requested
*              service as AVAILABLE then the service registration is performed.
*
* PARAMETER: [IN] u16ServiceId = Service ID to register for.
*            [IN] u16ServiceMajorVersion = Major version of the service.
*            [IN] u16ServiceMinorVersion = Minor version of the service,
*            [IN] u16SourceSubID = Source Sub-ID of the client.
*            [IN] u16ServerAppId = Application ID of the server which offers the 
*                                  service to register for (dedicated server) or
*                                  AMT_C_U16_APPID_INVALID to let the SPM 
*                                  determine the server application which offers
*                                  the service (none dedicated server).
*
* RETURNVALUE: TRUE  = Registration successfully performed.
*              FALSE = Registration failed.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadApp::vOnTimer().
*******************************************************************************/
tBool ail_tclOneThreadAppInterface::bRegisterAsync (tU16 u16ServiceId, tU16 u16ServiceMajorVersion, tU16 u16ServiceMinorVersion, tU16 u16SourceSubID, tU16 u16ServerAppId)
{
  tBool                      bRet                             = TRUE;
  ail_tenServerAppState      enServerAppState                 = AIL_EN_SERVER_APP_STATE_UNKNOWN;
  ail_tclServerApplication*  poServerApplication              = NULL;
  tBool                      bDedicatedServer                 = FALSE;    
  tU8                        u8ServiceRegistrationState       = AIL_C_U8_SERVICE_REGISTRATION_NOT_YET_SENT;
  tU8                        u8RegisterState                  = AMT_C_U8_REGCONF_NO_SUCCESS;

  ail_tclServiceRequest oServiceRequest(u16SourceSubID,
                                        u16ServiceMajorVersion,
                                        u16ServiceMinorVersion);

  #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
    ail_vTraceMsg(TR_LEVEL_USER_2, "Application 0x%04x: bRegisterAsync() called. ServiceID=0x%04X, MajorVersion=0x%04X, MinorVersion=0x%04X, SourceSubID=0x%04X, ServerAppID=0x%04X", 
                  u16AppId, u16ServiceId, u16ServiceMajorVersion, u16ServiceMinorVersion, u16SourceSubID, u16ServerAppId);
  #endif

  if (ail_bTakeListAccess(hGeneralListAccess))
  {
    if (bServerApplicationListAvailable() == TRUE)
    {
      ail_tclServerApplicationIterator oServerApplicationIterator(m_poServerApplicationList);

      /* --------------------------------------------------------------------------------- */
      /* Determine the server application state of the requested service by running        */
      /* through the server application list and find a matching server application        */
      /* entry by use of the passed service ID and/or the application ID.                  */
      /*                                                                                   */
      /* If the passed parameter for u16ServerAppId is AMT_C_U16_APPID_INVALID then this   */
      /* is a none dedicated service registration where a client registers for a service   */
      /* without knowing from which application this service is offered. If the passed     */
      /* parameter u16ServerAppId contains a valid application ID then this is a dedicated */
      /* service registration where the client knows the application which offers the      */
      /* requested service. For dedicated service registrations both passed parameters     */
      /* u16ServerAppId and u16ServiceId are used for the lookup of a matching server      */
      /* application entry in the server application list. For none dedicated service      */
      /* registrations only the u16ServiceId can be used for the lookup as the application */
      /* which offers the service not (yet) known.                                         */
      /*                                                                                   */
      /* If a server application entry is found in the server application list then the    */
      /* client has already registered at the SPM to get informed about the state changes  */
      /* of the server application. In this case the actual server application state       */
      /* can be one of ...                                                                 */
      /*                                                                                   */
      /*  - AIL_EN_SERVER_APP_STATE_REQUESTED                                              */
      /*  - AIL_EN_SERVER_APP_STATE_AVAILABLE                                              */
      /*  - AIL_EN_SERVER_APP_STATE_UNAVAILABLE                                            */
      /*                                                                                   */
      /* If there is no server application entry is found in the server application list   */
      /* then the client has not yet registered at the SPM to get informed about the state */
      /* changes of the server application. In this case the actual server application     */
      /* state is  ...                                                                     */
      /*                                                                                   */
      /*  - AIL_EN_SERVER_APP_STATE_UNKNOWN                                                */
      /* --------------------------------------------------------------------------------- */
      while(oServerApplicationIterator.bIsDone() == FALSE)
      {
        tU16  u16StoredAppId     = oServerApplicationIterator.oItem().u16GetAppId();
        tU16  u16StoredServiceId = oServerApplicationIterator.oItem().u16GetServiceId();
        
        bDedicatedServer = oServerApplicationIterator.oItem().bIsDedicatedServer();

        /* ------------------------------------------------------------------------ */
        /* Server application to register at is UNKNOWN.                            */
        /*                                                                          */
        /* Server application state determination by use of the 'Service Supplier'. */
        /*                                                                          */
        /* => Check the service ID only.                                            */
        /* ------------------------------------------------------------------------ */
        if (u16ServerAppId == AMT_C_U16_APPID_INVALID)
        {
          if (u16StoredServiceId == u16ServiceId)
          {
            if (bDedicatedServer == FALSE)
            {
              poServerApplication = &(oServerApplicationIterator.oItem());

              enServerAppState = poServerApplication->enGetServerAppState();

              // Take the eventually already known server application ID which 
              // might have been set by a received 'Service Supplier Status' 
              // message with status AMT_C_U8_CCAMSG_SUPPLIER_STATE_AVAILABLE.
              u16ServerAppId = u16StoredAppId;

              break;
            }
          }
        }

        /* ------------------------------------------------------------------------ */
        /* Server application to register at is KNOWN.                              */
        /*                                                                          */
        /* Server application state determination by use of the 'Application Info'. */
        /*                                                                          */
        /* => Check the service ID and the server application ID.                   */
        /* ------------------------------------------------------------------------ */
        else
        {
          if (u16StoredAppId == u16ServerAppId)
          {
            if (bDedicatedServer == TRUE)
            {
              // For dedicated server applications it can happen that a server application
              // is found on the basis of the application ID but the also passed service ID
              // doesn't match. This can happen due to the fact that it is allowed for a 
              // client to register for different services at the same server application.
            
              // In this case only the server application state is taken from the found entry
              // and this is allowed because the server application state for entries with 
              // the same server application ID is maintained with the same state. 

              enServerAppState = oServerApplicationIterator.oItem().enGetServerAppState();
            
              // If the service ID doesn't match then the reference pointer to the server 
              // application entry stays NULL because not all search criterias are fullfilled.
              if (u16StoredServiceId == u16ServiceId)
              {
                poServerApplication = &(oServerApplicationIterator.oItem());

                break;
              }
            }
          }
        }

        oServerApplicationIterator.vNext();
      }

      /* -------------------------------------------------------------------------- */
      /* If a server application entry was found ...                                */
      /*                                                                            */
      /* ... check if the just passed source-sub-ID for this service registration   */
      /*     is already used and if this service registration has already been      */
      /*     confirmed.                                                             */
      /* -------------------------------------------------------------------------- */

      if (poServerApplication != NULL)
      {
        ail_tclServiceRequestIterator oServiceRequestIterator(poServerApplication->poGetServiceRequestList());

        while(oServiceRequestIterator.bIsDone() == FALSE)
        {
          if (u16SourceSubID == oServiceRequestIterator.oItem().u16GetClientSubId())
          {
            // SubID found so the service registration is at least requested.
            u8ServiceRegistrationState = AIL_C_U8_SERVICE_REGISTRATION_SENT_AND_CONFIRMATION_PENDING;

            if  (TRUE == oServiceRequestIterator.oItem().bIsRegistrationConfirmed())
            {
              // Service registration is found as confirmed.
              u8ServiceRegistrationState = AIL_C_U8_SERVICE_REGISTRATION_CONFIRMED;
            }

            break;
          }

          oServiceRequestIterator.vNext();
        }
      }

      /* -------------------------------------------------------------------------- */
      /* If this service registration has not yet already been sen ...              */
      /*                                                                            */
      /* ... then do it now and perform the necessary actions for the service       */
      /*     registration.                                                          */
      /* -------------------------------------------------------------------------- */

      if (AIL_C_U8_SERVICE_REGISTRATION_NOT_YET_SENT == u8ServiceRegistrationState)
      {
        /* -------------------------------------------------------------------------- */
        /* The server application state is AIL_EN_SERVER_APP_STATE_UNKNOWN and the    */
        /* SPM is not yet requested to supervise the availablity of the application.  */
        /*                                                                            */
        /* => Send 'Service Supplier' or 'Application Info' message to the SPM and    */
        /*    add a server application entry with an initial service request to the   */
        /*    server application list                                                 */
        /* -------------------------------------------------------------------------- */
        if (AIL_EN_SERVER_APP_STATE_UNKNOWN == enServerAppState)
        {
          // Check if service ID to be added is valid.
          if (u16ServiceId != AMT_C_U16_SERVICE_UNDEF)
          {
            /* ------------------------------------------------------------- */
            /* ID of the application which offers the service is NOT known.  */
            /*                                                               */
            /* Use the 'Service Supplier Register' message to be informed    */
            /* by the SPM when an application which offers the requested     */
            /* service is being activated.                                   */
            /* ------------------------------------------------------------- */
            if (AMT_C_U16_APPID_INVALID == u16ServerAppId)
            {
              ail_tclServerApplication oServerApplication(u16ServerAppId, u16ServiceId,
                                                          FALSE, // DedicatedServer = FALSE
                                                          oServiceRequest, AIL_EN_SERVER_APP_STATE_REQUESTED);

              m_poServerApplicationList->vAdd(oServerApplication);

              #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
                ail_vTraceMsg(TR_LEVEL_USER_2, "Application 0x%04x: bRegisterAsync() => Added service reguest. Dedicated=0, ServerAppState=0x%04X, ServiceID=0x%04X, MajorVersion=0x%04X, MinorVersion=0x%04X, SourceSubID=0x%04X, ServerAppID=0x%04X", 
                              u16AppId, enServerAppState, u16ServiceId, u16ServiceMajorVersion, u16ServiceMinorVersion, u16SourceSubID, u16ServerAppId);
              #endif

              if (bSendCCASrvSupplierMsg(u16ServiceId, TRUE, FALSE) == FALSE)
              {
                ail_vTraceMsg(TR_LEVEL_FATAL, "Application 0x%04x: bRegisterAsync() => Post message ServiceSupplierRegister failed", u16AppId);

                bRet = FALSE;
              }
            }

            /* ------------------------------------------------------------- */
            /* ID of the application which offers the service IS known.      */
            /*                                                               */
            /* Use the 'Application Info Register' message to be informed    */
            /* by the SPM when an application which offers the requested     */
            /* service is being activated.                                   */
            /* ------------------------------------------------------------- */
            else
            {
              ail_tclServerApplication oServerApplication(u16ServerAppId, u16ServiceId, TRUE, oServiceRequest, AIL_EN_SERVER_APP_STATE_REQUESTED);

              m_poServerApplicationList->vAdd(oServerApplication);

              #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
                ail_vTraceMsg(TR_LEVEL_USER_2, "Application 0x%04x: bRegisterAsync() => Added service reguest. Dedicated=1, ServerAppState=0x%04X, ServiceID=0x%04X, MajorVersion=0x%04X, MinorVersion=0x%04X, SourceSubID=0x%04X, ServerAppID=0x%04X", 
                              u16AppId, enServerAppState, u16ServiceId, u16ServiceMajorVersion, u16ServiceMinorVersion, u16SourceSubID, u16ServerAppId);
              #endif

              if (bSendAppInfoMsg(u16ServerAppId, TRUE, FALSE, TRUE) == FALSE)
              {
                ail_vTraceMsg(TR_LEVEL_FATAL, "Application 0x%04x: bRegisterAsync() => Post message ApplicationInfoRegister failed", u16AppId);

                bRet = FALSE;
              }
            }
          }
          else
          {
            ail_vTraceMsg(TR_LEVEL_FATAL, "Application 0x%04x: bRegisterAsync() => Passed Service-ID is not allowed to be 0x%04X (AMT_C_U16_SERVICE_UNDEF). MajorVersion=0x%04X, MinorVersion=0x%04X, SourceSubID=0x%04X, ServerAppID=0x%04X", 
                          u16AppId, u16ServiceId, u16ServiceMajorVersion, u16ServiceMinorVersion, u16SourceSubID, u16ServerAppId);

            bRet = FALSE;
          }
        }

        /* -------------------------------------------------------------------------- */
        /* A server application entry exists and the server application state is ...  */
        /*                                                                            */
        /*  - AIL_EN_SERVER_APP_STATE_REQUESTED                                       */
        /*  - AIL_EN_SERVER_APP_STATE_AVAILABLE                                       */
        /*  - AIL_EN_SERVER_APP_STATE_UNAVAILABLE                                     */
        /*                                                                            */
        /* => Update the existing server application entry by adding another service  */
        /*    request or add another server application entry beside the already      */
        /*    existing one.                                                           */
        /* -------------------------------------------------------------------------- */
        else
        {
          /* --------------------------------------------------------------------- */
          /* Server application entry found (application ID and service ID match). */
          /*                                                                       */
          /* Update the existing server application entry by adding another        */
          /* service request.                                                      */
          /* --------------------------------------------------------------------- */
          if (poServerApplication != NULL)
          {
            poServerApplication->vAddServiceRequest(oServiceRequest);

            #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
              ail_vTraceMsg(TR_LEVEL_USER_2, "Application 0x%04x: bRegisterAsync() => Added service reguest. Dedicated=%1d, ServerAppState=0x%04X,  ServiceID=0x%04X, MajorVersion=0x%04X, MinorVersion=0x%04X, SourceSubID=0x%04X, ServerAppID=0x%04X", 
                            u16AppId, bDedicatedServer, enServerAppState, u16ServiceId, u16ServiceMajorVersion, u16ServiceMinorVersion, u16SourceSubID, u16ServerAppId);
            #endif
          }

          /* --------------------------------------------------------------------- */
          /* No server application entry found (only the application ID matches).  */
          /*                                                                       */
          /* Add another server application entry for this pair of service ID      */
          /* and application ID. This must be a dedicated server as only           */
          /* dedicated servers can have multiple server application entries with   */
          /* the same application ID and different service IDs.                    */
          /* --------------------------------------------------------------------- */
          else
          {
            ail_tclServerApplication oServerApplication(u16ServerAppId, u16ServiceId, TRUE, oServiceRequest, enServerAppState);

            m_poServerApplicationList->vAdd(oServerApplication);

            #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
              ail_vTraceMsg(TR_LEVEL_USER_2, "Application 0x%04x: bRegisterAsync() => Added service reguest. Dedicated=1, ServerAppState=0x%04X,  ServiceID=0x%04X, MajorVersion=0x%04X, MinorVersion=0x%04X, SourceSubID=0x%04X, ServerAppID=0x%04X", 
                            u16AppId, enServerAppState, u16ServiceId, u16ServiceMajorVersion, u16ServiceMinorVersion, u16SourceSubID, u16ServerAppId);
            #endif
          }
        }

        /* -------------------------------------------------------------------------- */
        /* Update of the server application list has been handled above.              */
        /*                                                                            */
        /* Server application state is AIL_EN_SERVER_APP_STATE_AVAILABLE.             */
        /*                                                                            */
        /* Perform the service registration by calling the final service registration */
        /* method bRegisterAsyncExecute().                                            */
        /* -------------------------------------------------------------------------- */
        if (AIL_EN_SERVER_APP_STATE_AVAILABLE == enServerAppState)
        {
          #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
            ail_vTraceMsg(TR_LEVEL_USER_2, "Application 0x%04x: bRegisterAsync() => Call bRegisterAsyncExecute()", u16AppId);
          #endif

          bRet = bRegisterAsyncExecute(u16ServiceId, u16ServiceMajorVersion, u16ServiceMinorVersion, u16SourceSubID, u16ServerAppId, TRUE);

          if (FALSE == bRet)
          {
            ail_vTraceMsg(TR_LEVEL_FATAL, "Application 0x%04x: bRegisterAsyncExecute() returned FALSE with ServiceId = 0x%04X, ServiceMajorVersion = 0x%04X, ServiceMinorVersion = 0x%04X, SourceSubId = 0x%04X, ServerAppId = 0x%04X",
                          u16AppId, u16ServiceId, u16ServiceMajorVersion, u16ServiceMinorVersion, u16SourceSubID, u16ServerAppId);
          }
        }
      }
    }

    ail_bReleaseListAccess(hGeneralListAccess); /* release the list access */
  }

  /* -------------------------------------------------------------------------- */
  /* If this service registration has already been sent ...                     */
  /*                                                                            */
  /* ... then check if the actual state of the service registration is at       */
  /*     CONFIRMATION_PENDING or CONFIRMED and indicate this state via an       */
  /*     amt_tclServiceRegisterConf self message with parameter                 */
  /*     AMT_C_U8_REGCONF_SERVICE_REGISTRATION_PENDING or                       */
  /*     AMT_C_U8_REGCONF_SERVICE_ALREADY_REGISTERED.                           */
  /* -------------------------------------------------------------------------- */

  if (u8ServiceRegistrationState != AIL_C_U8_SERVICE_REGISTRATION_NOT_YET_SENT)
  {
    if (AIL_C_U8_SERVICE_REGISTRATION_SENT_AND_CONFIRMATION_PENDING == u8ServiceRegistrationState)
    {
      #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
        ail_vTraceMsg(TR_LEVEL_ERROR, "Application 0x%04x: bRegisterAsync() rejected because a registration for ServiceID=0x%04X, MajorVersion=0x%04X, MinorVersion=0x%04X, SourceSubID=0x%04X, ServerAppID=0x%04X is already pending", 
                      u16AppId, u16ServiceId, u16ServiceMajorVersion, u16ServiceMinorVersion, u16SourceSubID, u16ServerAppId);
      #endif

      u8RegisterState = AMT_C_U8_REGCONF_SERVICE_REGISTRATION_PENDING;
    }
    else // AIL_C_U8_SERVICE_REGISTRATION_CONFIRMED
    {
      #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
        ail_vTraceMsg(TR_LEVEL_FATAL, "Application 0x%04x: bRegisterAsync() failed for ServiceID=0x%04X, MajorVersion=0x%04X, MinorVersion=0x%04X, SourceSubID=0x%04X, ServerAppID=0x%04X because this service is already registered", 
                      u16AppId, u16ServiceId, u16ServiceMajorVersion, u16ServiceMinorVersion, u16SourceSubID, u16ServerAppId);
      #endif

      u8RegisterState = AMT_C_U8_REGCONF_SERVICE_ALREADY_REGISTERED;
    }

    amt_tclServiceRegisterConf oMessageRegisterConf(u16ServerAppId,
                                                    u16AppId,
                                                    u16ServiceId,
                                                    AMT_C_U16_REGID_INVALID,
                                                    u8RegisterState,
                                                    u16ServiceMajorVersion,
                                                    u16ServiceMinorVersion,
                                                    AMT_C_U16_SERVICE_VERSION_INVALID,
                                                    AMT_C_U16_DEFAULT_NULL,            // source sub id
                                                    u16SourceSubID);                   // target sub id
    if (oMessageRegisterConf.bIsValid())
    {
      if (bPostIpcMessage(u16AppId,
                          ail_hGetReceiverQueue(poOpenedQueueList,
                                                hGeneralListAccess,
                                                u16AppId),
                          &oMessageRegisterConf,
                          AIL_C_U32_CCA_PRIO_MSG_SERVICE_CONFIRMATION) == FALSE)
      {
         oMessageRegisterConf.bDelete();
         ail_vTraceMsg(TR_LEVEL_FATAL, "Application 0x%04x: bRegisterAsync() => Failed to send message amt_tclServiceRegisterConf", u16AppId);
      }
    }
    else
    {
      ail_vTraceMsg(TR_LEVEL_FATAL, "Application 0x%04x: bRegisterAsync() => Failed to create message amt_tclServiceRegisterConf", u16AppId);
    }
  }

  return (bRet);
}

tBool ail_tclOneThreadAppInterface::bRegisterAsyncExecute (tU16 u16ServiceId, tU16 u16ServiceMajorVersion, tU16 u16ServiceMinorVersion, tU16 u16SourceSubID, tU16 u16ServerAppId, tBool bListAccessAlreadyTaken)
{
    tBool bRet             = TRUE;
    tBool bListAccessTaken = FALSE;

    #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
    ail_vTraceMsg(TR_LEVEL_USER_2, "Application 0x%04x: Function bRegisterAsyncExecute() called, ServiceID=0x%04X, MajorVersion=0x%04X, MinorVersion=0x%04X, SourceSubID=0x%04X, ServerAppID=0x%04X, ListAccessAlreadyTaken=%d", 
                  u16AppId, u16ServiceId, u16ServiceMajorVersion, u16ServiceMinorVersion, u16SourceSubID, u16ServerAppId, bListAccessAlreadyTaken);
    #endif

    if (FALSE == bListAccessAlreadyTaken)
    {
      bListAccessTaken = ail_bTakeListAccess(hGeneralListAccess);
    }
    else
    {
      bListAccessTaken = TRUE;
    }

    if (TRUE == bListAccessTaken)
    {
       /* list access is sheltered */
       if (  poAsyncRegisterReqList && poAsyncRegisterReqList->nSize() )
       {  
          /* there is an asynchronous answer awaited */
          ail_tclAsyncRegisterReqIterator  iter(poAsyncRegisterReqList);

          for (; !iter.bIsDone() && bRet == TRUE; iter.vNext())
          {
             if ( iter.oItem().bIsAnswer( u16ServerAppId, u16ServiceId, u16SourceSubID ) )
             {
                ail_vTraceMsg( TR_LEVEL_ERRORS, "Application 0x%04x: This service is already requested to be registered!!!!!!!", u16AppId );

                /* logical error: this service is already requested to be registered */
                bRet = FALSE; 
             }
          }
       }

       if ( bRet == TRUE )
       {
          /* parameter check is all ok */
          /* create a new message object */
          amt_tclServiceRegister oMessageServiceRegister(u16AppId, u16ServerAppId, u16ServiceId, u16ServiceMajorVersion, u16ServiceMinorVersion, u16SourceSubID);

          bRet = oMessageServiceRegister.bIsValid();

          if ( bRet == TRUE )
          {
             /* post this message to the server */  
             bRet = bPostIpcMessage( u16AppId,
                   ail_hGetReceiverQueue( poOpenedQueueList, OSAL_C_INVALID_HANDLE, u16ServerAppId ),
                      (amt_tclBaseMessage*) &oMessageServiceRegister, AIL_C_U32_CCA_PRIO_MSG_SERVICE_REGISTER);

             if ( bRet == FALSE )
             {
                ail_vTraceMsg( TR_LEVEL_ERRORS, "Application 0x%04x: Post message ServiceRegister is invalid", u16AppId );

                oMessageServiceRegister.bDelete();

                #ifndef AIL_KEEP_MSG_QUEUE_HANDLES_TO_OTHER_APPS_UNTIL_TERMINATION
                // examine for other registrations to this server
                tBool bFound = ail_bCheckRegistrationsToApp(poServiceReferenceList, poServiceRegistryList,
                   OSAL_C_INVALID_HANDLE, // access already protected
                   u16ServerAppId); 

                // if no other registration exists, close handle to
                // messagequeue of this server
                if (!bFound)
                {
                   if ( poOpenedQueueList )
                   {
                      ail_bDeleteFromOpenedQueueList( poOpenedQueueList,
                         OSAL_C_INVALID_HANDLE, // access already protected
                         u16ServerAppId);
                   } // else poOpenedQueueList doesn't exist
                } // else other registrations to this server exists
                #endif
             }
             else
             {
                if ( poAsyncRegisterReqList )
                {
                   tBool bTimerStartRequired = FALSE;

                   if ( hAsyncRegisterTimer == OSAL_C_INVALID_HANDLE )
                   {
                      if ( OSAL_ERROR == OSAL_s32TimerCreate(vTriggerAsyncRegisterTout,(tPVoid)this,&hAsyncRegisterTimer ) )
                      {
                         ail_vTraceMsg( TR_LEVEL_ERRORS, "Application 0x%04x: bRegisterAsync: timer-create failed", u16AppId );
                      }
                   }

                   if ( !poAsyncRegisterReqList->nSize() )
                   {
                      /* Timer is not running */
                      bTimerStartRequired = TRUE;
                   }

                   ail_tclAsyncRegisterReq oAsyncRegisterReq(u16ServerAppId, u16ServiceId, u16SourceSubID, C_U32_REGISTER_CONF_WAIT);

                   #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
                   ail_vTraceMsg( TR_LEVEL_USER_2, "Application 0x%04x: Add the new registration request to registration list", u16AppId );
                   #endif

                   /* add the new registration request to registration list */        
                   poAsyncRegisterReqList->vAdd(oAsyncRegisterReq);

                   if ( bTimerStartRequired && hAsyncRegisterTimer != OSAL_C_INVALID_HANDLE )
                   {
                      /* if now no timer exits, start to pray, that system never hangs */
                      if ( OSAL_ERROR == OSAL_s32TimerSetTime( hAsyncRegisterTimer,C_U32_REGISTER_CONF_WAIT,0 ) )
                      {
                         ail_vTraceMsg( TR_LEVEL_ERRORS, "Application 0x%04x: bRegisterAsync: timer-create failed", u16AppId );
                      }
                   }
                }
                else
                {
                   ail_vTraceMsg( TR_LEVEL_ERRORS, "Application 0x%04x: poAsyncRegisterReqList==NULL", u16AppId );
                }
             }
          }
          else
          {
             ail_vTraceMsg( TR_LEVEL_ERRORS, "Application 0x%04x: Msg is invalid", u16AppId );
          }
       }

       if (FALSE == bListAccessAlreadyTaken)
       {
          /* release the list access */
          ail_bReleaseListAccess( hGeneralListAccess );
       }
    }
  
    return ( bRet );
}

#ifdef ARM_EIGHTBYTEALIGNSTACKPOINTER_PRE_FUNC
    #pragma push
    #pragma Ono_tailcall
#endif
tVoid ail_tclOneThreadAppInterface::vTriggerAsyncRegisterTout (tVoid* pvArg)
{
   //## begin ail_tclOneThreadAppInterface::vTriggerAsyncRegisterTout%3D60EB9D0074.body preserve=yes
   //8 Byte Align Stack Pointer
   ARM_EIGHTBYTEALIGNSTACKPOINTER
      
   tBool bElementsRemained = FALSE;
   ail_tclAsyncRegisterReqList   oHelpList;
   ail_tclOneThreadAppInterface* poOneThreadAppInterface = (ail_tclOneThreadAppInterface*)pvArg;
   
   if ( ail_bTakeListAccess( poOneThreadAppInterface->hGeneralListAccess ) )
   {
      /* list access is sheltered */
      if ( poOneThreadAppInterface->poAsyncRegisterReqList )
      {
         /* there is a list existing */
         if ( poOneThreadAppInterface->poAsyncRegisterReqList->nSize() )
         {
            ail_tclAsyncRegisterReqIterator  iter(poOneThreadAppInterface->poAsyncRegisterReqList);
            for (; !iter.bIsDone(); iter.vNext())
            {
               if ( !iter.oItem().bIsObsolete() )
               {
                  /* add only not signaled elements to help list */
                  tU32 u32Counter = iter.oItem().u32DecrementAndGetCounter( C_U32_ASYNCREG_SAMPLING_TIMEVAL );
                     
                  if ( u32Counter == 0 )
                  {
                     /* store to help list */
                     oHelpList.vAdd( iter.oItem() );
                  }
                  else
                  {
                     /* there is one element remained */
                     bElementsRemained = TRUE;
                  }
               }
            }
         }
      }
      
      /* release the list access */
      ail_bReleaseListAccess( poOneThreadAppInterface->hGeneralListAccess );
      
      if ( bElementsRemained )
      {
         /* trigger timer again */
         if ( OSAL_ERROR == OSAL_s32TimerSetTime(poOneThreadAppInterface->hAsyncRegisterTimer,C_U32_REGISTER_CONF_WAIT,0 ) )
         {
            ail_vTraceMsg( TR_LEVEL_ERRORS, "Application 0x%04x: bRegisterAsync: timer-create failed", poOneThreadAppInterface->u16AppId );
         }
      }
      
      if ( oHelpList.nSize() )
      {
         /* there is someone to be informed */
         ail_tclAsyncRegisterReqIterator  iter(&oHelpList);
         
         for (; !iter.bIsDone(); iter.vNext())
         {
            tU16 u16ServerAppId;
            tU16 u16ServiceId;
            tU16 u16TargetSubId;
            
            iter.oItem().vGetAdressInfo( &u16ServerAppId, &u16ServiceId, &u16TargetSubId );
         
            // Remove failed service registration from async-register-request list.
            ail_tclAsyncRegisterReqIterator iter2(poOneThreadAppInterface->poAsyncRegisterReqList);

            for (; !iter2.bIsDone(); iter2.vNext())
            {
              if (iter2.oItem().bIsAnswer(u16ServerAppId, u16ServiceId, u16TargetSubId) == TRUE)
              {
                poOneThreadAppInterface->poAsyncRegisterReqList->nRemove(iter2.oItem());

                break;
              }
            }
            // Indicate failed service registration due to register timeout to user application.
            poOneThreadAppInterface->vHandleAsyncRegisterConf(AMT_C_U16_REGID_INVALID, 
                                                              u16ServerAppId, 
                                                              u16ServiceId, 
                                                              u16TargetSubId, 
                                                              AMT_C_U8_REGCONF_SERVER_DOES_NOT_RESPOND_TIMEOUT);
         }
         /* note: HelpList is cleared automatically */
      }

      #ifdef AIL_MESSAGE_TRACE_SVC_MESSAGES
      ail_vTraceMsg(TR_LEVEL_USER_2,
         "TimerTick for asynchron registration of application 0x%04x: %s",
         poOneThreadAppInterface->u16AppId, 
         (( bElementsRemained ) ? "Elements remained == TRUE" : "Elements remained == FALSE") );
       #endif
        }
        
        //restore original Stack Pointer
        ARM_RESTORESTACKPOINTER
           
           //## end ail_tclOneThreadAppInterface::vTriggerAsyncRegisterTout%3D60EB9D0074.body
}
#ifdef ARM_EIGHTBYTEALIGNSTACKPOINTER_POST_FUNC
    #pragma pop
#endif

/*******************************************************************************
*
* FUNCTION: ail_tclAppInterfaceRestricted::bPostIpcMessage()
*
* DESCRIPTION: Asynchronously posts a CCA message.
*
* PARAMETER: [IN] u16MyAppId  = ID of the application which posts the 
*                               message (sender).
*            [IN] hMQ         = Handle of the message queue the message should 
*                               be posted to (receiver queue).
*            [IN] poMsgObject = Pointer to the message to be posted.
*            [IN] u32Prio     = Priority with which the message shall be posted.
*            [IN] bTraceMsg   = Flag to trace CCA message or not.
*
* RETURNVALUE: TRUE  = Message posted successfully.
*              FALSE = Failed to post message.
*
*******************************************************************************/
tBool ail_tclAppInterfaceRestricted::bPostIpcMessage(tU16 u16MyAppId, 
                                                     OSAL_tMQueueHandle hMQ,  
                                                     amt_tclBaseMessage* poMsgObject, 
                                                     tU32 u32Prio,
                                                     tBool bTraceMsg)
{
  tBool bResult          = TRUE;
  tU32  u32OsalErrorCode = OSAL_E_NOERROR;

  poMsgObject->vSetTimestamp(OSAL_ClockGetElapsedTime());

  if (TRUE == bTraceMsg)
  {
    ail_vTraceCcaMessage(poMsgObject, AIL_C_U8_TRACE_MSG_SENT, u32Prio);
  }

  u32OsalErrorCode = ail_bIpcMessagePost(u16MyAppId, hMQ, poMsgObject, u32Prio);

  if (u32OsalErrorCode != OSAL_E_NOERROR)
  {
     ail_vTraceMsg(TR_LEVEL_ERRORS, "Application 0x%04x: CCA message could not be sent", u16MyAppId);
     
     // Special handling if a service data messages could not be sent
     // due to a full message queue of the receiver application.
     if ((OSAL_E_QUEUEFULL == u32OsalErrorCode) || (OSAL_E_TIMEOUT == u32OsalErrorCode) || (OSAL_E_NOSPACE == u32OsalErrorCode))
     {
       if (poMsgObject->u8GetType() == AMT_C_U8_CCAMSGTYPE_SVCDATA)
       {
         vHandleCcaMsgQueueFull(poMsgObject->u16GetTargetAppID());
       }
     }

     bResult = FALSE;
  }

  return (bResult);
}

/*******************************************************************************
*
* FUNCTION: ail_tclAppInterfaceRestricted::vHandleCcaMsgQueueFull()
*
* DESCRIPTION: This function should be called in case a CCA message could not 
*              be sent to another CCA application because of a full message 
*              queue. 
*
*              In such a case the SPM is informed about this circumstance by 
*              sending a power message of type 
*              AMT_C_U16_PWR_APP_CCA_MSG_QUEUE_FULL with the ID of the CCA 
*              application whose message queue was just detected to be full.
*
* PARAMETER: [IN] u16TargetAppId  = Application ID of the receiver which rejects 
*                                   to receive a CCA message because of a full 
*                                   message queue.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid ail_tclAppInterfaceRestricted::vHandleCcaMsgQueueFull(tU16 u16TargetAppId)
{
  ail_vTraceMsg(TR_LEVEL_FATAL, "Application 0x%04x: Failed to post CCA message to queue 'mbx_%u' because message queue is full", u16AppId, u16TargetAppId);

  // check if there anything hanging
  vTracePendingSyncComm(TR_LEVEL_FATAL);

  if (bSendCCAPowerMsg(u16LpmId, 
                       hLpmInQueue, 
                       AIL_C_U32_CCA_PRIO_MSG_POWER, 
                       AMT_C_U16_PWR_APP_CCA_MSG_QUEUE_FULL, 
                       u16TargetAppId,
                       0) == FALSE)
  {
    ail_vTraceMsg(TR_LEVEL_FATAL, "Application 0x%04x: Failed to post CCA message AMT_C_U16_PWR_APP_CCA_MSG_QUEUE_FULL to spm");
    // not possible to send the message to the SPM -> give the SPM the chance to detect his blocking for his own
    OSAL_s32ThreadWait(5 * C_RESET_MSEC_WAIT);  // The SPM reacts after about > 30 seconds. This is the minimum time to delay.
  }
  else
  {
    // give the message a chance to reach the SPM
    OSAL_s32ThreadWait(C_RESET_MSEC_WAIT);
  }

  #if (OSAL_OS == OSAL_WINNT)
     reg_tclRegKey regKey;   
     tBool bBreakInsteadAssert = FALSE;
     char szString[100];
     OSAL_s32PrintFormat(szString,"/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/SYSTEM");
     if(regKey.bOpen(szString))
     {
        tU32 u32Value = 0;   
        if(regKey.bQueryU32("DBG_BREAK_INSTEAD_ASSERT",&u32Value))
        {
           if(u32Value != 0)
           {
              bBreakInsteadAssert = TRUE;
           }   
        }
     }
     if(bBreakInsteadAssert)
     {
        _CrtDbgBreak(); // In windows environment only halt process (necessary for tooling debugging)
     } else
     {
        // if SPM doesn't react make the reset by ourself
        FATAL_M_ASSERT_ALWAYS();
     }
  #else
     // if SPM doesn't react make the reset by ourself
     FATAL_M_ASSERT_ALWAYS();
  #endif
}

/*******************************************************************************
*
* FUNCTION: ail_tclAppInterfaceRestricted::bDispatchCCAMessages()
*
* DESCRIPTION: This function forwards a CCA message to the internal dispatcher
*              with the passed priority.
*
*              The function is typically used by CCA dispatcher applications
*              where the receiver queue as well as the receiver thread is
*              created and under control of another external application which
*              just needs the AIL to dispatch the received CCA message.
*
* PARAMETER: [IN] poMessage = CCA message to dispatch 
*            [IN] u32Prio   = priority of the CCA message
*
* RETURNVALUE: TRUE  = Continue dispatching
*              FALSE = Stop dispatching
*
*******************************************************************************/
tBool ail_tclAppInterfaceRestricted::bDispatchCCAMessages (amt_tclBaseMessage* poMessage, 
                                                           tU32 u32Prio) 
{
    tBool bContinueDispatching = TRUE;

    if (poInternalDispatch) 
    {
        bContinueDispatching = poInternalDispatch->bDispatchCCAMessages(
		poMessage, 
		OSAL_C_INVALID_HANDLE,
		FALSE,
		u32Prio);
    }

    return bContinueDispatching;
}
//## begin module%3A841C2A0197.epilog preserve=yes

/*************************************************************************
| dummy function definition for DLL substitution ( skope: modul-global )
|*************************************************************************/

tVoid dummy_ail_dll(tVoid) {}

//## end module%3A841C2A0197.epilog
