/*****************************************************************************
 * FILE:          FIVersion.h
 * SW-COMPONENT:  
 * DESCRIPTION:   
 *                
 * AUTHOR:        CM-DI/ESA2-Bruns
 * COPYRIGHT:     (c) 2004 Blaupunkt Werke GmbH
 * HISTORY:       
 *                19.04.04 Rev. 1.0 CM-DI/ESA2-Bruns
 *                         Initial Revision;
 *****************************************************************************/
#ifndef VERSION_H
   #define VERSION_H




/*****************************************************************************
| includes of component-internal interfaces, if necessary
| (scope: component-local)
|----------------------------------------------------------------------------*/
#include "FISettings.h"
#include "DLLMain.h"

#include <vector>
#include <list>
#include <string>
using namespace std;




/*****************************************************************************
| typedefs (scope: global)
|----------------------------------------------------------------------------*/
#define FI_VERSION_LIMIT_LOW  "0.0.0"
#define FI_VERSION_LIMIT_HIGH "65535.65535.65535"



/*****************************************************************************
| function prototypes (scope: global)
|----------------------------------------------------------------------------*/




/*****************************************************************************
 * Encapsulation of version information
 *****************************************************************************/
class FIOBJECTTREEDLL_API tclFIVersion
{
   int               iMajor;
   int               iMinor;
   int               iPatch;

public:
                     tclFIVersion();
                     tclFIVersion(string &oStringWithVersion);
                     tclFIVersion(int iMajor, int iMinor, int iPatch);
                     ~tclFIVersion();

   bool              operator<(const tclFIVersion &left) const;
   bool              operator>(const tclFIVersion &left) const;
   bool              operator==(const tclFIVersion &left) const; //, const tclFIVersion &right);
   bool              operator<=(const tclFIVersion &left) const;
   bool              operator>=(const tclFIVersion &left) const;

   void              vSetVersion(string &oStringWithVersion);
   int               iGetMinor() const { return iMinor; }
   int               iGetMajor() const { return iMajor; }
   int               iGetPatch() const { return iPatch; }

   // returns "true" if content matches ...LIMIT_LOW or LIMIT_HIGH
   bool              bHasNoLimit();
};




typedef vector<tclFIVersion>            _tclFIVersionList;
typedef _tclFIVersionList::const_iterator tclFIVersionListIterator;




/*****************************************************************************
 * list of version objects, only used in "tclFIServiceTree" (and Extractor)
 *****************************************************************************/
class tclFIVersionList : public _tclFIVersionList
{
public:
                           tclFIVersionList();
                          ~tclFIVersionList();
   // Standard-API
   bool                    bIsValid();
   void                    vPrintOut(int iSpaces);
};




class FIOBJECTTREEDLL_API tclFIVersionRange
{
   tclFIVersion      oMinVersion;
   tclFIVersion      oMaxVersion;

public:
                     tclFIVersionRange();
                     ~tclFIVersionRange();

   void              vSetVersionRange(const tclFIVersion &oMinVersion, const tclFIVersion &oMaxVersion);
   void              vSetVersionRange(string &oMinVersionString, string &oMaxVersionString);

   tclFIVersion      &oGetMinVersion() { return oMinVersion; }
   tclFIVersion      &oGetMaxVersion() { return oMaxVersion; }

   bool              bIsInside(tclFIVersionRange *poCandidate);
};




#endif