/*****************************************************************************
 * FILE:          FIDependency.cpp
 * SW-COMPONENT:  
 * DESCRIPTION:   
 *                
 * AUTHOR:        CM-DI/ESA2-Bruns
 * COPYRIGHT:     (c) 2004 Blaupunkt Werke GmbH
 * HISTORY:       
 *                19.04.04 Rev. 1.0 CM-DI/ESA2-Bruns
 *                         Initial Revision;
 *****************************************************************************/



#include "stdlib.h"
#include "string.h"

//-----------------------------------------------------------------------------
// General includes
//-----------------------------------------------------------------------------
#include "FIVersion.h"




/*****************************************************************************
| function implementation
|-----------------------------------------------------------------------------*/
tclFIVersion::tclFIVersion()
{
   iMajor = iMinor = iPatch = 0;
}



tclFIVersion::tclFIVersion(int iNewMajor, int iNewMinor, int iNewPatch) 
   : iMajor(iNewMajor), iMinor(iNewMinor), iPatch(iNewPatch)
{
}




tclFIVersion::tclFIVersion(string &oStringWithVersion)
{
   vSetVersion(oStringWithVersion);
}




tclFIVersion::~tclFIVersion()
{
}




bool tclFIVersion::bHasNoLimit()
{
   bool bResult = false;
   string oStringLocalString(FI_VERSION_LIMIT_LOW);
   string oStringLocalString2(FI_VERSION_LIMIT_HIGH);

   if(((*this) == tclFIVersion(oStringLocalString)) ||
      ((*this) == tclFIVersion(oStringLocalString2)))
   {
      bResult = true;
   }
   return bResult;
}





void tclFIVersion::vSetVersion(string &oStringWithVersion)
{
   iMinor = iMajor = iPatch = 0;
   int iMajorMinorDotPosition = oStringWithVersion.find_first_of('.');
   if(iMajorMinorDotPosition  >= 0)
   {
      string oPatchString, oMinorString, oMajorString;
      
      oMajorString = oStringWithVersion.substr(0, iMajorMinorDotPosition);
      int iMinorPatchDotPosition = oStringWithVersion.find_first_of('.', iMajorMinorDotPosition+1);


      if(iMinorPatchDotPosition >= 0)
      {
         oMinorString = oStringWithVersion.substr(iMajorMinorDotPosition+1 , iMinorPatchDotPosition-(iMajorMinorDotPosition+1));
         oPatchString = oStringWithVersion.substr(iMinorPatchDotPosition+1 , oStringWithVersion.length());
      }
      else
         oMinorString = oStringWithVersion.substr(iMajorMinorDotPosition+1 , oStringWithVersion.length());

      iMinor = atoi(oMinorString.c_str());
      iMajor = atoi(oMajorString.c_str());
      iPatch = atoi(oPatchString.c_str());
   }
   else
   {
      iMajor = atoi(oStringWithVersion.c_str());
   }
}




bool tclFIVersion::operator<(const tclFIVersion &right) const
{
   int caBufferThis[3];
   int caBufferRight[3];
   caBufferThis[0] = iMajor;
   caBufferThis[1] = iMinor;
   caBufferThis[2] = iPatch;

   caBufferRight[0] = right.iMajor;
   caBufferRight[1] = right.iMinor;
   caBufferRight[2] = right.iPatch;

   return (memcmp(caBufferThis, caBufferRight, (sizeof(int)*3)) < 0);
}




bool tclFIVersion::operator>(const tclFIVersion &right) const
{
   return !((*this) < right);
}




bool tclFIVersion::operator<=(const tclFIVersion &left) const
{
   bool bSuccess= ((*this) < left);
   if(false == bSuccess)
   {
      bSuccess = ((*this) == left);
   }
   return bSuccess;
}




bool tclFIVersion::operator>=(const tclFIVersion &left) const
{
   return (((*this) > left) || ((*this) == left));
}


   
   
bool tclFIVersion::operator==(const tclFIVersion &right) const
{
   return ((iMajor == right.iMajor) && (iMinor == right.iMinor));
}




/*****************************************************************************
 * tclFIVersionList
 *****************************************************************************/
tclFIVersionList::tclFIVersionList()
{
}




tclFIVersionList::~tclFIVersionList()
{
}




bool tclFIVersionList::bIsValid()
{
   // toDo: add code
   return false;
}





/*****************************************************************************
 * tclFIVersionRange
 *****************************************************************************/
tclFIVersionRange::tclFIVersionRange()
{
	string oStringLocalString(FI_VERSION_LIMIT_LOW);
	string oStringLocalString2(FI_VERSION_LIMIT_HIGH);

   oMinVersion = tclFIVersion(oStringLocalString);
   oMaxVersion = tclFIVersion(oStringLocalString2);
}




tclFIVersionRange::~tclFIVersionRange()
{
}




void tclFIVersionRange::vSetVersionRange(
               const tclFIVersion &oNewMinVersion, 
               const tclFIVersion &oNewMaxVersion)
{
   oMinVersion = oNewMinVersion;
   oMaxVersion = oNewMaxVersion;
}




void tclFIVersionRange::vSetVersionRange(
               string &oMinVersionString, 
               string &oMaxVersionString)
{
   oMinVersion = tclFIVersion(oMinVersionString);
   oMaxVersion = tclFIVersion(oMaxVersionString);
}



// check whether this range is inside window
bool tclFIVersionRange::bIsInside(tclFIVersionRange *poWindow)
{
   bool bSuccess = false;
   tclFIVersion oWindowMin = poWindow->oGetMinVersion();
   tclFIVersion oWindowMax = poWindow->oGetMaxVersion();

   tclFIVersion oTypeMin = this->oGetMinVersion();
   tclFIVersion oTypeMax = this->oGetMaxVersion();

   // inside: if lower range of this object inside window
   //         || upper range of this object inside window
   if(   ((oTypeMin <= oWindowMin) && (oWindowMin <= oTypeMax))
      || ((oTypeMin <= oWindowMax) && (oWindowMax <= oTypeMax))
      || ((oWindowMin <= oTypeMin) && (oTypeMax <= oWindowMax)) )
/*
   if(   ((oWindowMin <= this->oGetMinVersion()) && (this->oGetMinVersion() <= oWindowMax))
      || ((oWindowMin <= this->oGetMaxVersion()) && (this->oGetMaxVersion() <= oWindowMax))
      || ((oWindowMin <= this->oGetMinVersion()) && (this->oGetMaxVersion() <= oWindowMax)) )
*/
   {
      bSuccess = true;
   }

   return bSuccess;
}

