/*****************************************************************************
 * FILE:          FIDependency.cpp
 * SW-COMPONENT:  
 * DESCRIPTION:   
 *                
 * AUTHOR:        CM-DI/ESA2-Bruns
 * COPYRIGHT:     (c) 2004 Blaupunkt Werke GmbH
 * HISTORY:       
 *                19.04.04 Rev. 1.0 CM-DI/ESA2-Bruns
 *                         Initial Revision;
 *****************************************************************************/




//-----------------------------------------------------------------------------
// General includes
//-----------------------------------------------------------------------------
#include "FISettings.h"
#include "FIServiceTree.h"
#include "FINode.h"
#include "FINodePool.h"
#include "FIDependency.h"
#include "FIParser.h"
#include "FIUtil.h"
#include "FIVersion.h"
#include "FIValidator.h"
#include "FIExtractor.h"


// RAW-Printout for debugging
//#include "DocumentPrinter.h"




/*****************************************************************************
| function implementation
|-----------------------------------------------------------------------------*/
tclFIServiceTree::tclFIServiceTree(tclFITypeNodePool *poGlobalTypePool, tclFITypeNodePool *poGlobalErrorPool)
{
   //poDOMDoc   = 0;
   oFilename  = "";
   oShortname = "";
   oFullname  = "";
   iServiceID = 0;
   poParser   = new tclDOMParser;
   poUsedGlobalTypePool = poGlobalTypePool;
   poUsedGlobalErrorPool = poGlobalErrorPool;
   poMessagePool = new tclFIMessageNodePool;
}




tclFIServiceTree::~tclFIServiceTree()
{
   if(0 != poParser)
   {
      delete poParser;
      poParser = 0;
   }
   if(0 != poMessagePool)
   {
      delete poMessagePool;
      poMessagePool = 0;
   }
}




bool tclFIServiceTree::bIsValid()
{
   return (0 != poMessagePool);
}




void tclFIServiceTree::vSetShortname(string oNewShortName)
{
   oShortname = oNewShortName;
}




void tclFIServiceTree::vSetFullname(string oNewFullName)
{
   oFullname = oNewFullName;
}




void tclFIServiceTree::vSetServiceID(int iNewServiceID)
{
   iServiceID = iNewServiceID;
}



bool tclFIServiceTree::bAddCatalogueVersion(tclFIVersion &oNewVersion)
{
   // toDO: add error handling
   oCatalogueVersionList.push_back(oNewVersion);
   return true;
}




int tclFIServiceTree::iGetNumMessages()
{
   int iMessageCounter = 0;
   for(int i=0; i < poMessagePool->iGetNumNodes(); i++)
   {
      tclFINode *poType = poMessagePool->poGetNode(i, EN_NONE);
      if(0 != poType)
      {
         if((EN_OBJTYPE_MESSAGE_METHOD   == poType->enGetType()) ||
            (EN_OBJTYPE_MESSAGE_PROPERTY == poType->enGetType()))
         {
            iMessageCounter++;
         }
      }
   }

   return iMessageCounter;
}




bool tclFIServiceTree::bReadService(char *pcFilename)
{
   bool bResult = false;
   
   if(true == poParser->bParse(pcFilename))
   {
      DOMDocument *poDOMDoc = poParser->pGetDocument();
      oFilename = string(pcFilename);
      if(0 != poDOMDoc)
      {
         tclFIExtractor oExtractor(poDOMDoc, this);
         bResult  = oExtractor.bExtract();
      }
   }
   return bResult;
}



DOMDocument* tclFIServiceTree::poGetDOMDoc()
{
   return poParser->pGetDocument();
}



bool tclFIServiceTree::bValidate()
{
   bool bResult = false;
   // toDo: Add validator check here

   tclFIValidator oValidator;
   if(oValidator.bIsValid())
   {
      bResult = oValidator.bValidate(this);
   }
   return bResult;
}




/*****************************************************************************
 * tclFIServiceTreeList
 *****************************************************************************/
tclFIServiceTreeList::tclFIServiceTreeList()
{
}




tclFIServiceTreeList::~tclFIServiceTreeList()
{
}




bool tclFIServiceTreeList::bIsValid()
{
   return true;
}



