/*****************************************************************************
 * FILE:          FIServiceGroup.h
 * SW-COMPONENT:  
 * DESCRIPTION:   
 *                
 * AUTHOR:        CM-DI/ESA2-Bruns
 * COPYRIGHT:     (c) 2004 Blaupunkt Werke GmbH
 * HISTORY:       
 *                19.04.04 Rev. 1.0 CM-DI/ESA2-Bruns
 *                         Initial Revision;
 *****************************************************************************/

#ifndef FI_SERVICE_GROUP_H
   #define FI_SERVICE_GROUP_H




/*****************************************************************************
| includes of component-internal interfaces, if necessary
| (scope: component-local)
|----------------------------------------------------------------------------*/
#include "FISettings.h"
#include "DLLMain.h"
#include "FIServiceGroup.h"
#include "FIServiceTree.h"
#include "FINode.h"
#include "FINodePool.h"
#include "FIVersion.h"
#include <vector>
#include <string>

using namespace std;




/*****************************************************************************
| typedefs (scope: global)
|----------------------------------------------------------------------------*/
typedef list<char*>                       tclServiceList;




/*****************************************************************************
| function prototypes (scope: global)
|----------------------------------------------------------------------------*/
class FIOBJECTTREEDLL_API tclFIServiceTreeList;
class FIOBJECTTREEDLL_API tclFINodeList;
class FIOBJECTTREEDLL_API tclFIServiceGroup
{
   tclFIServiceTreeList    oServiceTreeList;
   tclFITypeNodePool       *poTypePool;
   tclFITypeNodePool       *poErrorPool;

public:
                           tclFIServiceGroup();
                          ~tclFIServiceGroup();

   // Standard-API
   bool                    bIsValid();

   // ServiceGroup specific API
   bool                    bReadService(char *filename);
//   bool                    bReadServiceList(tclServiceList *poServiceList);
   int                     iGetNumServices();
   tclFITypeNodePool      *poGetTypePool();
   tclFITypeNodePool      *poGetErrorPool();
   tclFIServiceTree        *poGetServiceTree(char *filename);
   tclFIServiceTree        *poGetServiceTree(int i);
   tclFIServiceTreeList    *poGetServiceTreeList() { return &oServiceTreeList; }
   void                    vSetVerbosity(bool bNewVerbosity);
};


#endif // FI_SERVICEGROUP_H