/*****************************************************************************
 * FILE:          FIServiceGroup.cpp
 * SW-COMPONENT:  
 * DESCRIPTION:   
 *                
 * AUTHOR:        CM-DI/ESA2-Bruns
 * COPYRIGHT:     (c) 2004 Blaupunkt Werke GmbH
 * HISTORY:       
 *                19.04.04 Rev. 1.0 CM-DI/ESA2-Bruns
 *                         Initial Revision;
 *****************************************************************************/




//-----------------------------------------------------------------------------
// General includes
//-----------------------------------------------------------------------------
#include "FISettings.h"
#include "FIServiceGroup.h"
#include "FIServiceTree.h"
#include "FINode.h"
#include "FINodePool.h"
#include "FIVersion.h"
#include "FIUtil.h"
// #include "FIValidator.h"




#include <vector>
#include <list>

#include <string>
#include <iostream>

using namespace std;




/*****************************************************************************
| function implementation
|-----------------------------------------------------------------------------*/
tclFIServiceGroup::tclFIServiceGroup()
{
   poTypePool = new tclFITypeNodePool;
   poErrorPool= new tclFITypeNodePool;
}




tclFIServiceGroup::~tclFIServiceGroup()
{
   if(0 != poTypePool)
   {
      delete poTypePool;
      poTypePool = 0;
   }
   if(0 != poErrorPool)
   {
      delete poErrorPool;
      poErrorPool = 0;
   }
}



void tclFIServiceGroup::vSetVerbosity(bool bNewVerbosity)
{
   ::vSetVerbosity(bNewVerbosity);
}




bool tclFIServiceGroup::bIsValid()
{
   return ((0 != poTypePool) && (0 != poErrorPool));
}




bool tclFIServiceGroup::bReadService(char *pcFilename)
{
   bool bResult = false;
   tclFIServiceTree *pNewServiceTree = new tclFIServiceTree(poTypePool, poErrorPool);
   if(0 != pNewServiceTree)
   {
      if(true == pNewServiceTree->bReadService(pcFilename))
      {
         if(true == pNewServiceTree->bValidate())
         {
            // toDo: Add error handling of STL
            oServiceTreeList.push_back(pNewServiceTree);
            
            bResult = true;
         }
      }

      // Clean-up in case of errors
      if(false == bResult)
      {
         delete pNewServiceTree;
         pNewServiceTree = 0;
      }
   }
   
   return bResult;
}




int tclFIServiceGroup::iGetNumServices()
{
   return oServiceTreeList.size();
}




tclFITypeNodePool* tclFIServiceGroup::poGetTypePool()
{
   return poTypePool;
}




tclFITypeNodePool* tclFIServiceGroup::poGetErrorPool()
{
   return poErrorPool;
}



tclFIServiceTree*
tclFIServiceGroup::poGetServiceTree(int i)
{
   tclFIServiceTree *pResult = 0;
 
   tclFIServiceTreeListIterator iter = oServiceTreeList.begin();
   while(iter != oServiceTreeList.end() && i > 0)
   {
      i--;
      ++iter;
   }
   pResult = *iter;
   return pResult;
}




tclFIServiceTree* tclFIServiceGroup::poGetServiceTree(char *filename)
{
   tclFIServiceTree *pResult = 0;
 
   tclFIServiceTreeListIterator iter = oServiceTreeList.begin();
   while(iter != oServiceTreeList.end())
   {
      if((*iter)->oGetFilename() == string(filename))
      {
         pResult = *iter;
      }
      ++iter;
   }

   return pResult;
}


