/*****************************************************************************
 * FILE:          FINodePool.h
 * SW-COMPONENT:  
 * DESCRIPTION:   
 *                
 * AUTHOR:        CM-DI/ESA2-Bruns
 * COPYRIGHT:     (c) 2004 Blaupunkt Werke GmbH
 * HISTORY:       
 *                19.04.04 Rev. 1.0 CM-DI/ESA2-Bruns
 *                         Initial Revision;
 *****************************************************************************/

#ifndef FI_NODE_POOL_H
   #define FI_NODE_POOL_H



 
 /*****************************************************************************
| includes of component-internal interfaces, if necessary
| (scope: component-local)
|----------------------------------------------------------------------------*/
#include "FINode.h"

#include <vector>
using namespace std;




/*****************************************************************************
| typedefs (scope: global)
|----------------------------------------------------------------------------*/
typedef enum 
{
   EN_NONE,
   EN_BYDEPENDENCY,
   EN_BYALPHABET
} enFINodeSortOption;





class FIOBJECTTREEDLL_API tclFINodePool
{
   friend class tclFIExtractor;

   vector<tclFINode*>      *poNodeList;

   // quick access
   map<string, tclFINode*> *poNodeMap;

   enFINodeSortOption      enCurrentSortOption;
   bool                    SortTypes(enFINodeSortOption);


public:
                           tclFINodePool();
                          ~tclFINodePool();
   // Standard-API
   bool                    bIsValid();
   bool                    bExist(string &oTypeName);
   bool                    bAdd(tclFINode *poFINode);
   int                     iGetNumNodes();
   tclFINode*              poGetNode(int i, enFINodeSortOption enSortOption);
   tclFINode*              poGetNode(const char *pcName);
};




typedef FIOBJECTTREEDLL_API tclFINodePool tclFITypeNodePool;
typedef FIOBJECTTREEDLL_API tclFINodePool tclFIMessageNodePool;




#endif   // FI_NODE_POOL_H