/*****************************************************************************
 * FILE:          FINodePool.cpp
 * SW-COMPONENT:  
 * DESCRIPTION:   
 *                
 * AUTHOR:        CM-DI/ESA2-Bruns
 * COPYRIGHT:     (c) 2004 Blaupunkt Werke GmbH
 * HISTORY:       
 *                19.04.04 Rev. 1.0 CM-DI/ESA2-Bruns
 *                         Initial Revision;
 *****************************************************************************/

#pragma warning( disable : 4786 )  



//-----------------------------------------------------------------------------
// General includes
//-----------------------------------------------------------------------------
#include "FISettings.h"
#include "FIDependency.h"
#include "FINode.h"
#include "FINodePool.h"



tclFINodePool::tclFINodePool()
{
   poNodeList = new vector<tclFINode*>;
   poNodeMap  = new map<string, tclFINode*>;
   enCurrentSortOption = EN_NONE;
}




tclFINodePool::~tclFINodePool()
{
   if(0 != poNodeList)
   {
      delete poNodeList;
      poNodeList = 0;;
   }
   if(0 != poNodeMap)
   {
      delete poNodeMap;
      poNodeMap = 0;
   }
}




bool tclFINodePool::bIsValid()
{
   return ((0!=poNodeList) && (0!=poNodeMap));
}

   
   

int tclFINodePool::iGetNumNodes()
{
   int iResult = 0;
   if(0 != poNodeList)
      iResult = poNodeList->size();
   return iResult;
}





bool tclFINodePool::bExist(string &oTypeName)
{
   bool bFound = false;

   tclFINode *poNode = (*poNodeMap)[oTypeName];
   if(0 != poNode)
   {
      bFound = true;
   }
   return bFound;
}




// toDO: add STL exception handling
bool tclFINodePool::bAdd(tclFINode *poFINode)
{
   bool bSuccess = true;
   string oNodeName = poFINode->oGetName();
   if(!bExist(oNodeName))
   {
      (*poNodeMap)[oNodeName] = poFINode;
      poNodeList->push_back(poFINode);
      bSuccess = true;
   }
   return bSuccess;
}




tclFINode* tclFINodePool::poGetNode(const char *pcName)
{
   tclFINode *pResultNode =(*poNodeMap)[pcName];
   return pResultNode;
}



tclFINode* tclFINodePool::poGetNode(int i, enFINodeSortOption enSortOption)
{
   tclFINode *poResultNode = 0;
   if((EN_NONE != enSortOption) && (enSortOption != enCurrentSortOption))
   {
      if(SortTypes(enSortOption))
      {
         poResultNode = (*poNodeList)[i];
      }
   }
   else
   {
      poResultNode = (*poNodeList)[i];
   }
   return poResultNode;
}



// A simple bubblesort 
// criteria=none (use old sort-order, by dependency, by alphabet)
bool tclFINodePool::SortTypes(enFINodeSortOption enNewSortOrder)
{
   bool bResult = true;
   // Sort by dependency
   int iMaxSize = poNodeList->size();
   for (int idx1 = 0; idx1 < iMaxSize-1; ++idx1)
   {
      bool bReDo;
      do 
      {
         bReDo = false;
         for (int idx2 = idx1 + 1; idx2 < poNodeList->size(); ++idx2)
         {

/*            cout << "------------------------------------------" << endl;
            // poNodeList = poMessagePool->poNodeList;
            for (int i=0; i< poNodeList->size(); i++)
            {
               tclFINode *poNode = (*poNodeList)[i];
               cout << "Name: " << poNode->oGetName() << endl;
            }
            cout << "------------------------------------------" << endl;
*/
            tclFINode *pNode1 = (*poNodeList)[idx1];
            tclFINode *pNode2 = (*poNodeList)[idx2];

            // need for switching two elements
            bool bSwitch = false;

            // Sort criterium
            if(EN_BYDEPENDENCY == enNewSortOrder)
            {
               bSwitch = pNode1->bDependsOn(pNode2);
            }
            else if(EN_BYALPHABET == enNewSortOrder)
            {
               bSwitch = (pNode1->oGetName() < pNode2->oGetName());
            }

            if (bSwitch)
            {
               (*poNodeList)[idx1] = pNode2;
               (*poNodeList)[idx2] = pNode1;
               bReDo = true;
            }
         }
      } while (bReDo);
   }
   enCurrentSortOption = enNewSortOrder;
   return bResult;
}
