/*****************************************************************************
 * FILE:          FIExtractor.h
 * SW-COMPONENT:  
 * DESCRIPTION:   
 *                
 * AUTHOR:        CM-DI/ESA2-Bruns
 * COPYRIGHT:     (c) 2004 Blaupunkt Werke GmbH
 * HISTORY:       
 *                19.04.04 Rev. 1.0 CM-DI/ESA2-Bruns
 *                         Initial Revision;
 *****************************************************************************/
#ifndef FIEXTRACTOR_H
   #define FIEXTRACTOR_H




/*****************************************************************************
| includes of component-internal interfaces, if necessary
| (scope: component-local)
|----------------------------------------------------------------------------*/
#include "FISettings.h"
#include "DLLMain.h"
#include "FIVersion.h"
#include "FIDocumentation.h"
#include "FIDependency.h"
#include "FINode.h"
#include "FINodePool.h"
#include "FIServiceTree.h"

#include <vector>
#include <list>
#include <map>
#include <string>
using namespace std;

#include <xercesc/util/PlatformUtils.hpp>
#include <xercesc/parsers/XercesDOMParser.hpp>
#include <xercesc/sax/HandlerBase.hpp>
#include <xercesc/util/XMLString.hpp>
#include "xercesc/dom/DOM.hpp"
using namespace xercesc;




/*****************************************************************************
| typedefs (scope: global)
|----------------------------------------------------------------------------*/
class tclFIServiceTree;




/*****************************************************************************
| function prototypes (scope: global)
|----------------------------------------------------------------------------*/
class tclFIExtractor
{
private:
   // 
   DOMDocument             *poDOMDoc;
   tclFIServiceTree        *poServiceTree;

   bool                    bExtractTypeType(
                                    tenFINodeType &enResultTyoe, 
                                    DOMNode *pDOMNode);
   bool                    bExtractVersion(
                                    tclFIVersionRange &oResultVersionRange, 
                                    DOMElement *pDOMElement);
   bool                    bExtractDescription(
                                    tclFIDocumentation &oDescription, 
                                    DOMElement *poDOMElement);

   bool                    bExtractDependencyLink(
                                    tclFINode         *poTargetLinkNode,
                                    tclFITypeNodePool *poWhereToSearchTypeOfLink,
                                    DOMNode           *poDOMNode, 
                                    char              *pcNameTag, 
                                    char              *pcBaseTypeTag, 
                                    char              *pcValueTag,
                                    char              *pcFallbackTag,
                                    tenFIDependencyClass enClass,
                                    bool              bBaseTypeGlobal,
                                    bool              bBasetypeFromLength = false);

/*
   tclFITypeDependency     *poCreateTypeDependencyLink(
                                    tclFITypeNodePool *poSourceTypePool,
                                    DOMNode *poDOMNode, 
                                    char *pcNameTag, 
                                    char *pcBaseTypeTag, 
                                    char* pcValueTag,
                                    tenFIDependencyClass enClass,
                                    bool bBaseTypeGlobal);
*/
   bool                    bExtractDependencyData(
                                    tclFINode   *poTargetNode,
                                    tclFITypeNodePool *poSourceTypePool,
                                    DOMElement *poDOMStartNode, 
                                    char *pcSelector1Tag, 
                                    char *pcSelector2Tag, 
                                    char *pcBaseTypeTag,
                                    char *pcNameTag,
                                    char *pcValueTag,
                                    char *pcFallbackTag,
                                    tenFIDependencyClass enClass,
                                    bool bBaseTypeGlobal,
                                    bool bBaseTypeFromLength = false);

   bool                    bExtractDependencyData2(
                                    tclFINode   *poTargetNode,
                                    tclFITypeNodePool *poSourceTypePool,
                                    DOMElement *poDOMStartNode, 
                                    char *pcSelector1Tag, 
//                                  char *pcSelector2Tag, 
                                    char *pcBaseTypeTag,
                                    char *pcNameTag,
                                    char *pcValueTag,
                                    char *pcFallbackTag,
//                                  tenFIDependencyClass enClass,
                                    bool bBaseTypeGlobal);

   tclFINode*              poGetFINodeFromDOMNode(
                                    tclFINodePool *pcTargetNodePool,
                                    DOMNode *poDOMNode, 
                                    char *pcNameTag, 
                                    char* pcValueTag,
                                    tenFINodeType enType,
                                    char *pcNamePrefixForCreation);

   bool                    bExtractMessageOpCodes(
                                    tclFITypeNodePool *poTargetPool,
                                    tclFINode *poMsgMainNode,
                                    char *pcOpCodeTypeTag);

protected:
   // Extract routines (called from "bExtract")
   bool                    bExtractTypes(tclFITypeNodePool *poTargetPool,
                                    char *pcTypeTag, char *pcNameTag, char *pcValueTag,
                                    bool bCalculateType, tenFINodeType enType=EN_OBJTYPE_UNDEFINED);

   bool                    bExtractMessages(
                                    tclFITypeNodePool *poTargetPool,
                                    char *pcTypeTag, 
                                    char *pcNameTag, 
                                    char *pcValueTag,
                                    bool bCalculateType, 
                                    tenFINodeType enType,
                                    char *pcOpCodeTypeTag);
                                             
   bool                    bExtractService();

   bool                    bExtractDependencies(tclFINodePool *poSourceTypePool, 
                                                tclFINodePool *poSourceErrorPool, 
                                                tclFINodePool *poIteratePool);

   bool                    bCalculateTypeSize(tclFINodePool *poIteratePool);
   int                     iCalculateTypeSize(tclFINode *poNode);
public:
                           tclFIExtractor(DOMDocument *poDOMDoc, tclFIServiceTree *poServiceTree);
                          ~tclFIExtractor();

   bool                    bIsValid();
   bool                    bExtract();
};



#endif   // FIPATTERN_H