/*****************************************************************************
 * FILE:          FIDependency.cpp
 * SW-COMPONENT:  
 * DESCRIPTION:   
 *                
 * AUTHOR:        CM-DI/ESA2-Bruns
 * COPYRIGHT:     (c) 2004 Blaupunkt Werke GmbH
 * HISTORY:       
 *                19.04.04 Rev. 1.0 CM-DI/ESA2-Bruns
 *                         Initial Revision;
 *****************************************************************************/




//-----------------------------------------------------------------------------
// General includes
//-----------------------------------------------------------------------------
#include "FISettings.h"
#include "FIDependency.h"
#include "FINode.h"




/*****************************************************************************
| function implementation
|-----------------------------------------------------------------------------*/
tclFITypeDependency::tclFITypeDependency(
               string               oNewName,
               tenFIDependencyClass enNewClass,
               string               oNewDefaultValue,
               string               oNewFallbackValue,
               tclFIVersionRange    oNewVersionRange,
               tclFINode            *poNewTarget,
               tclFIDocumentation   &oNewDescription)
{
 oName         = oNewName;
 enClass       = enNewClass;
 oDefaultValue = oNewDefaultValue;
 oFallbackValue= oNewFallbackValue;
 oVersionRange = oNewVersionRange;
 poTarget      = poNewTarget;
 oDescription  = oNewDescription;
}




tclFITypeDependency::~tclFITypeDependency()
{
}



string tclFITypeDependency::oGetDependencyClassString()
{
   string oClassString = "";
   switch(enClass)
   {
      case EN_DEPENDENCY_CLASS_DERIVED:oClassString = "derived"; break;
      case EN_DEPENDENCY_CLASS_ERRORDEF:oClassString = "errordef"; break;
      case EN_DEPENDENCY_CLASS_FIELD:  oClassString = "field"; break;
      case EN_DEPENDENCY_CLASS_LIST:   oClassString = "list"; break;
      case EN_DEPENDENCY_CLASS_UNION:  oClassString = "union"; break;
      case EN_DEPENDENCY_CLASS_PARAM:  oClassString = "param"; break;
      case EN_DEPENDENCY_CLASS_OPCODE:  oClassString = "opcode"; break;
      case EN_DEPENDENCY_CLASS_BITFIELD:  oClassString = "value"; break;
      case EN_DEPENDENCY_CLASS_ENUMERATION:  oClassString = "value"; break;
      default: ;
   }

   return oClassString;
}



bool tclFITypeDependency::bHasVersionInformation()
{
   return (!(oVersionRange.oGetMinVersion().bHasNoLimit() &&
       (oVersionRange.oGetMaxVersion().bHasNoLimit())));
}




/*****************************************************************************
 * tclFITypeDependencyList
 *****************************************************************************/
tclFITypeDependencyList::tclFITypeDependencyList()
{
}




tclFITypeDependencyList::~tclFITypeDependencyList()
{
}




