/*****************************************************************************
 * FILE:          FICodeGenMostExt.h
 * SW-COMPONENT:  
 * DESCRIPTION:   Generation of additional, MOST-compatible data types for use with
 *                FI code generator based on c++ fi tooling
 *                
 * AUTHOR:        CM-AI/PJ-GM54  Koch, Martin
 * COPYRIGHT:     (c) 2010 Robert Bosch Car Multimedia GmbH
 * HISTORY:       
 *                22.04.10 Rev. 1.0  CM-AI/PJ-GM54  Koch, Martin
 *                         Initial Version;
 *****************************************************************************/

extern string oBaseMessageClassName;

bool b_MOST_UseNonStandardOpcodeId(string oOpcode, int& iOpcodeId);
bool b_MOST_UseNonStandardTypeMethods(tclFINode *poType, ostream &out);
bool b_MOST_IsStandardErrorMessage(tclFINode *poType);

bool b_MOST_GenerateTypeClass (tclFINode *poType, ostream &out, tclFIServiceTree* poServiceTree, bool& bNeedsDestroy, bool& bSuccess);
bool b_MOST_GenerateTypeCopyConstructor (tclFINode *poType, ostream &out,string oPrefix);
bool b_MOST_GenerateTypeAssignmentOp (tclFINode *poType, ostream &out,string oPrefix);
bool b_MOST_GenerateTypeGetSizeMethod (tclFINode* poType, ostream &out,tclFIServiceTree* poServiceTree);
bool b_MOST_GenerateTypeCompareMethod (tclFINode* poType, ostream &out,string oPrefix);
bool b_MOST_GenerateTypeReadMethod (tclFINode *poType, ostream &out,string oPrefix);
bool b_MOST_GenerateTypeWriteMethod (tclFINode* poType, ostream &out,string oPrefix);
bool b_MOST_GenerateTypeMembers (tclFINode* poType, ostream &out,string oPrefix);

bool b_MOST_NeedsDestroy(tclFINode* poType);
bool b_MOST_GenerateTypeDestructor( tclFINode *poType, ostream &out, string oPrefix );
bool b_MOST_GenerateDestroyMethod( tclFINode *poType, ostream &out, string oPrefix );

bool b_MOST_GenerateDefaultErrorMessage(ostream &out, tclFIServiceTree* poServiceTree, bool bGenerateImplementation);
bool b_MOST_GenerateDefaultErrorMessageDecl(ostream &out, tclFIServiceTree* poServiceTree, bool bGenerateImplementation);

