/*****************************************************************************
 * FILE:          FICodeGenCmdLine.h
 * SW-COMPONENT:  
 * DESCRIPTION:   Command-Line handling for FICodeGen (using globals!).
 *                
 * AUTHOR:        CM-DI/ESN1-Bruns,J
 * COPYRIGHT:     (c) 2004 Blaupunkt Werke GmbH
 * HISTORY:       
 *                04.03.04 Rev. 1.0 CM-DI/ESN1-Bruns,J
 *                         Initial Revision;
 *****************************************************************************/
#ifndef CMDLINE_H
   #define CMDLINE_H




 /*****************************************************************************
| includes of component-internal interfaces, if necessary
| (scope: component-local)
|----------------------------------------------------------------------------*/
#include <string>
#include <iostream>
#include <fstream>
#include <list>
#include "FIVersion.h"
#include "FINodePool.h"
using namespace std;




/*****************************************************************************
| typedefs (scope: global)
|----------------------------------------------------------------------------*/
typedef list<char*>                       tclStringList;
typedef tclStringList::const_iterator     tclStringListIterator;
typedef enum { EXTENSION_NONE = 0, EXTENSION_MOST } tenExtension;

/*****************************************************************************
 * Exchange variables: 
 * The command line handles these global variables which are used for programm
 * control switches.
 *****************************************************************************/
extern bool                bBeVerbose;
extern int                 iNumXMLFiles;
extern tclStringList       oFileList;
extern tclFIVersionRange   oVersionRange;
extern string              goFIBaseDir;
extern bool                bgPrintSummary;
extern string              goFIPrefix;
extern string              goFIGroup;
extern string              goOutputDir;
extern bool                bUseAllTypes;
extern bool                bGenerateTypeFactoryOnly;
extern bool                bGeneratePrecompiledHeader;
extern bool                bMixedCaseTokens;
extern bool                bEnableDeepCopy;
extern bool                bGenerateErrorMessages;
extern tenExtension        enGeneratorExtension;
/*
extern bool                bPrintRaw;
extern bool                bPrintAllErrors;
extern bool                bPrintAllMethods;
extern bool                bPrintAllProperties;
extern bool                bPrintDescription;
extern bool                gbPrintRecursive;
extern bool                gbPrintEnumBitfield;
extern string              goMatchPatternName;
//extern bool                gbPrintDetails;
extern bool                gbAlwaysPrintSize;
extern bool                gbAlwaysPrintOrigin;
extern bool                gbPrintPoolOrigin;
//extern bool                gbOverridePattern;
extern bool                gbAlwaysPrintVersionInfo;
extern bool                gbAlwaysPrintDefValue;
extern enFINodeSortOption  genSortOption;
*/

/*****************************************************************************
| function prototypes (scope: global)
|----------------------------------------------------------------------------*/
bool vParseCommandLine(int argc, char *argv[]);
void vPrintUsage();



#endif