/*****************************************************************************
 * FILE:          FICodeGenCmdLine.cpp
 * SW-COMPONENT:  
 * DESCRIPTION:   Command-Line handling for FICodeGen (using globals!).
 *                
 * AUTHOR:        CM-DI/ESN1-Bruns,J
 * COPYRIGHT:     (c) 2004 Blaupunkt Werke GmbH
 * HISTORY:       
 *                04.03.04 Rev. 1.0 CM-DI/ESN1-Bruns,J
 *                         Initial Revision;
 *****************************************************************************/




//-----------------------------------------------------------------------------
// General includes
//-----------------------------------------------------------------------------

#include <string>
#include <list>
#include <iostream>
#include "FIVersion.h"
#include "FICodeGenCmdLine.h"
using namespace std;



/*****************************************************************************
 * Exchange variables
 *
 * The command line handles these global variables which are used for programm
 * control switches.
 *****************************************************************************/
// char *pXMLFile;
string            oOutDir        = "";
bool              bBeVerbose     = false;
int               iNumXMLFiles   = 0;
bool              bgPrintSummary = false;
string            goFIBaseDir    = "";
string            goOutputDir    = "";
tclStringList     oFileList;
tclFIVersionRange oVersionRange;
string            goFIPrefix;
string            goFIGroup;
bool              bUseAllTypes   = false;
bool              bGenerateTypeFactoryOnly = false;
bool              bGeneratePrecompiledHeader = false;
bool              bMixedCaseTokens = false;
bool              bEnableDeepCopy = true;
bool              bGenerateErrorMessages = false;
tenExtension      enGeneratorExtension = EXTENSION_NONE;

/*
bool bPrintRaw                = false;
bool bPrintAllTypes           = false;
bool bPrintAllErrors          = false;
bool bPrintAllMethods         = false;
bool bPrintAllProperties      = false;
bool bPrintDescription        = false;
bool gbPrintRecursive         = false;
bool gbPrintEnumBitfield      = false;
bool gbAlwaysPrintSize        = false;
bool gbAlwaysPrintOrigin      = false;

//bool gbPrintDetails           = false;

bool gbAlwaysPrintVersionInfo = false;
bool gbAlwaysPrintDefValue    = false;
enFINodeSortOption genSortOption = EN_BYDEPENDENCY;
bool gbPrintPoolOrigin        = true;
string goMatchPatternName  = "";
*/



/*****************************************************************************
| function implementation
|-----------------------------------------------------------------------------*/
void vPrintUsage()
{
   cerr << endl << "USAGE: FICodeGen2 [options] <xml-files>" << endl << endl;
   cerr << "  Where options can be one of the following" << endl;
   cerr << "  -?              Help" << endl;
   cerr << "  -v              Be verbose (more output while examining file(s)" << endl;
   cerr << "  -bdir <basedir> Set FI base directory (used as prefix to all xml-files)" << endl;
   cerr << "  -at             Force usage of all types" << endl;
   cerr << "  -g <group>      Set FI group prefix to <group>" << endl;
   cerr << "  -t              Generate type factory only" << endl;
   cerr << "  -x <extension>  Name of extension for code generator (currently implemented: most)" << endl;
   /*
   cerr << "  -d              Use detailed display format (force version,value,size,origin)" << endl;
   cerr << "  -doc            Display element documentation." << endl;
   cerr << "  -fbe            Display values of bitfields and enumerations" << endl;
   cerr << "  -fe             Force display of all errors" << endl;
   cerr << "  -fm             Force display of all methods" << endl;
   cerr << "  -fp             Force display of all properties" << endl;
   cerr << "  -fv             Force display of version information" << endl;
   cerr << "  -fd             Force display of default values" << endl;
   cerr << "  -p <pattern>    Print only names that match <pattern>" << endl;
   cerr << "  -po             Display pool origin of nodes" << endl;
   cerr << "  -r              Display all elements and subelements recursively." << endl;
   cerr << "  -raw            Raw output of all DOM nodes in every examined file" << endl;
   cerr << "  -sa             Use sort option 'by alphabet'." << endl;
   cerr << "  -sd             Use sort option 'by dependency' (default)." << endl;
   */
   cerr << "  -summary        Display service catalogue summary" << endl;
   cerr << "  -vMin <version>" << endl;
   cerr << "  -vMax <version>" << endl;
   cerr << "                  Output of version dependent content." << endl;
   cerr << "                  <version> = a.b.c" << endl;
   cerr << "                  0.0.0 or 'unlimited' for unlimited" << endl;
   cerr << "  -vSingle <version>" << endl;
   cerr << "                  Same as -vMin=version -vMax=version" << endl;
   cerr << "  -MixedCaseTokens" << endl;
   cerr << "                  create token names using upper and lower case characters" << endl;
   cerr << "  -NoDeepCopy     suppresses generation of deep copy constructor and assignment operator" << endl;
   cerr << "  -GenErrMsg      does not suppress generation of message classes for OpCode ERROR" << endl;
   cerr << "  -p              Generate sources for precompiled headers" << endl;
   cerr << "  -o <dir>        Generate sources in base directory <dir>" << endl;
}

bool vParseCommandLine(int argc, char *argv[])
{
   bool bSuccess = true;
   string oVersionMinString;
   string oVersionMaxString;
   iNumXMLFiles = 0;

   int argInd = 1;
   while(argInd < argc)
   {
      // Break out on first parm not starting with a dash
      if (argv[argInd][0] != '-')
      {
         // add one to result of strlen since it doesn't
         // count the terminating zero
         char *oFilename = new char[strlen(argv[argInd])+1];
         strcpy(oFilename, argv[argInd]);

         oFileList.push_back(oFilename);
         iNumXMLFiles++;
      }
      // Watch for special case help request
      else if (!strcmp(argv[argInd], "-?"))
      {
         vPrintUsage();
      } 
      else if (!strcmp(argv[argInd], "-v"))
      {
         bBeVerbose = true;
      } 
      else if (!strcmp(argv[argInd], "-summary"))
      {
         bgPrintSummary = true;
      } 
      else if (!strcmp(argv[argInd], "-at"))
      {
         bUseAllTypes = true;
      } 
      else if (!strcmp(argv[argInd], "-t"))
      {
         bGenerateTypeFactoryOnly = true;
      } 
      else if (!strcmp(argv[argInd], "-x"))
      {
         string sExtension = argv[++argInd];
         if (sExtension == "most")
         {
            cerr << "using Generator extension: most" << endl;
            enGeneratorExtension = EXTENSION_MOST;
         }
         else 
            cerr << "WARNING: unknown generator extension: "
                 << sExtension << endl << endl;
      }
      else if (!strcmp(argv[argInd], "-g"))
      {
         goFIGroup = argv[++argInd];
      } 
      else if (!strcmp(argv[argInd], "-vMin"))
      {
         oVersionMinString = argv[++argInd];
      } 
      else if (!strcmp(argv[argInd], "-vMax"))
      {
         oVersionMaxString = argv[++argInd];
      } 
      else if (!strcmp(argv[argInd], "-vSingle"))
      {
         oVersionMinString = argv[++argInd];
         oVersionMaxString = oVersionMinString;
      }
      else if (!strcmp(argv[argInd], "-bdir"))
      {
         goFIBaseDir = argv[++argInd];
         if(goFIBaseDir.length() > 0)
         {
            if(goFIBaseDir[goFIBaseDir.length()-1] != '/')
               goFIBaseDir += '/';
         }
      }
      else if (!strcmp(argv[argInd], "-o"))
      {
         goOutputDir = argv[++argInd];
         if(goOutputDir.length() > 0)
         {
            if(goOutputDir[goOutputDir.length()-1] != '/')
               goOutputDir += '/';
         }
      }
      else if (!strcmp(argv[argInd], "-MixedCaseTokens"))
      {
         bMixedCaseTokens = true;
      } 
      else if (!strcmp(argv[argInd], "-NoDeepCopy"))
      {
         bEnableDeepCopy = false;
      } 
      else if (!strcmp(argv[argInd], "-GenErrMsg"))
      {
         bGenerateErrorMessages = true;
      } 
      else if (!strcmp(argv[argInd], "-p"))
      {
         bGeneratePrecompiledHeader = true;
      } 
      else
      {
         cerr << "Unknown option '" << argv[argInd] << "'" << endl;
         bSuccess = false;
      }
      argInd++;
   }

   if(0 == oVersionMinString.length())
      oVersionMinString = string(FI_VERSION_LIMIT_LOW);
   if(0 == oVersionMaxString.length())
      oVersionMaxString = string(FI_VERSION_LIMIT_HIGH);

   oVersionRange.vSetVersionRange(oVersionMinString, oVersionMaxString);
   
   // consistency checks...
   if(oFileList.size() == 0)
   {
      cerr << "ERROR: missing file(s) to read - Abort!" << endl;
      bSuccess = false;
   }

   return bSuccess;
}

