/************************************************************************
 
 *FILE:           fivisitoramtmsg.cpp
 
 *SW-COMPONENT:   fi, Functional Interface Framework
 
 *DESCRIPTION:    Method implementations for the amt_Visitor messages and data type
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY: $Log:   //hi230124/projects/Vasco/swnavi/archives/components/fi/msgfw/fivisitoramtmsg.cpp-arc  $
 * 
 *    Rev 1.8   Apr 27 2004 11:24:24   bnj2hi
 * Update to MultiVersionFI.
 * 
 *    Rev 1.7   Jul 22 2003 15:16:58   bnj2hi
 * use correct interface for AMT.
 * 
 *    Rev 1.6   Mar 07 2003 11:23:46   bnj2hi
 * Corrected interface includes.
 * 
 *    Rev 1.5   Sep 04 2002 17:16:12   bnj2hi
 * Asserts removed.
 * 
 *    Rev 1.4   Jun 10 2002 12:05:12   bnj2hi
 * Added memory check assertion, minor changes
 * 
 *    Rev 1.3   Jun 03 2002 16:09:14   bnj2hi
 * Bugfix: constructor with FIType now sets the message size.
 * 
 *    Rev 1.2   May 28 2002 14:54:48   bnj2hi
 * set correct message length are initialization.
 * 
 *    Rev 1.1   May 14 2002 18:57:30   bnj2hi
 * New method s32GetData().
 * 
 *    Rev 1.0   Apr 23 2002 17:20:10   bnj2hi
 * Initial revision.
   
 ************************************************************************/

#include "precompiled.hh"

#define AMT_S_IMPORT_INTERFACE_GENERIC
#include "amt_if.h"

#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "fi_msgfw_if.h"

tU8* fi_tclVisitorData::pu8GetDataPointer(const amt_tclMappableMessage* const prMMsg) const
{
   return (tPU8)((prMMsg->pu8GetSharedMemBase()) + u32Offset);
  //return (tPU8)pcGetDataPointer(prMMsg);
}

tU32 fi_tclVisitorData::u32GetSizeOfType() const
{ 
   return u32SizeOfData;
}

tU32 fi_tclVisitorData::u32Link(const amt_tclServiceData& corfoMsg) {
   OSAL_vAssert(corfoMsg.pu8GetSharedMemBase());

   // amt_tclBaseMessage poMsg(const &pMMsg);
   u32SizeOfData = corfoMsg.u32GetSize() - corfoMsg.u32GetDynMsgSize();
   return u32SizeOfData;
}

// contructor for allocation of memory only
fi_tclVisitorMessage::fi_tclVisitorMessage(tU32 u32MsgSize)
      :amt_tclServiceData()
{
   //new message -> init & allocate
   oData.vSetDataSize(u32MsgSize);
   vAddType(&oData);
   bMsgValid = bAllocateMessage();
   if(bMsgValid)
   {
      vSetSize(u32GetDynMsgSize());
   }
   else
   {
      // RTF_M_TRACE("tclVisitorMessage: Msg allocation failed!\n");
   }
}

// contructor for initialization from filled Data
fi_tclVisitorMessage::fi_tclVisitorMessage(const fi_tclTypeBase& oFIData, tU16 u16MajorVersion)
      :amt_tclServiceData()
{
  //new message -> init & allocate
   oData.vSetDataSize(oFIData.u32GetSize(u16MajorVersion));
   vAddType(&oData);
   bMsgValid = bAllocateMessage();
   if (bMsgValid)
   {
      vSetSize(u32GetDynMsgSize());
      tU8* const pu8MsgData   = pu8GetDataPointer();
      
      // set property data in reply message
      if (pu8MsgData != NULL)
      {
         //create outcontext to write a message in a given buffer
         fi_tclOutContext oMsgOutContext(pu8MsgData, pu8MsgData+u32GetDataSize(),u16MajorVersion, oFIData.enGetByteOrder());
         oMsgOutContext << oFIData;
      }
      
   }
   else
   {
      // RTF_M_TRACE("tclVisitorMessage: Msg allocation failed!\n");
   }
}

tS32 fi_tclVisitorMessage::s32GetData(fi_tclTypeBase &oFIData, tU16 u16MajorVersion) const
{
   tS32 s32Result = OSAL_OK;
   tU8* const pu8MsgData   = pu8GetDataPointer();

   // set property data in reply message
   if (pu8MsgData != NULL)
   {
      //create outcontext to write a message in a given buffer
      fi_tclInContext oMsgInContext(pu8MsgData, pu8MsgData+u32GetDataSize(),u16MajorVersion, oFIData.enGetByteOrder());
      oMsgInContext >> oFIData;
      if (!oMsgInContext.bIsValid())
      {
         s32Result = OSAL_ERROR;
      }
   } 
   else
   {
      s32Result = OSAL_ERROR;
   }
   return s32Result;
}

//-- constructor for initializing a received message
fi_tclVisitorMessage::fi_tclVisitorMessage(amt_tclBaseMessage * poBaseMsg)
  :amt_tclServiceData(poBaseMsg)
{
  //get data region from OSAL message handle
  bEnableAccess();
  //get data size from message
  oData.u32Link(*this);
  vAddType(&oData);
  bMsgValid = TRUE;
}

//-- access to message data
tU8* fi_tclVisitorMessage::pu8GetDataPointer() const
{
  if(bMsgValid == TRUE)
    {
      return oData.pu8GetDataPointer(this);
    }
  else
    {
      return NULL;
    }
}

//-- message data size
tU32 fi_tclVisitorMessage::u32GetDataSize() const
{
  if(bMsgValid == TRUE)
    {
      return oData.u32GetSizeOfType();
    }
  else
    {
      return 0;
    }
}
