/************************************************************************
 
 *FILE:           fitypes.h
 
 *SW-COMPONENT:   fi, Functional Interface Framework
 
 *DESCRIPTION:    Interface for general type definitions of FI
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY: $Log:   //hi230124/projects/Vasco/swnavi/archives/components/fi/msgfw/fitypes.h-arc  $
 * 
 *    Rev 1.9   May 11 2004 19:39:06   bnj2hi
 * Bugfix for string compare
 * 
 *    Rev 1.8   Apr 27 2004 11:24:22   bnj2hi
 * Update to MultiVersionFI.
 * 
 *    Rev 1.7   Jul 22 2003 15:18:02   bnj2hi
 * added "virtual" modifier to reduce warnings.
 * 
 *    Rev 1.6   Jul 15 2003 16:46:06   bnj2hi
 * changed for new generation
 * 
 *    Rev 1.5   May 20 2003 10:16:56   bnj2hi
 * Addedn prototype for FI_u32StringLength
 * 
 *    Rev 1.4   Jan 21 2003 14:56:42   bnj2hi
 * minor clean up.
 * 
 *    Rev 1.3   Oct 07 2002 18:10:32   bnj2hi
 * made ARM compatible.
 * 
 *    Rev 1.2   May 28 2002 14:57:52   bnj2hi
 * Added new method vDestroy() for freeing memory (not done in destructor anymore).
 * 
 *    Rev 1.1   May 22 2002 13:34:14   bnj2hi
 * Fix for wrong tString.u32GetSize().
 * Input and output operators are not inlined anymore.
 * 
 *    Rev 1.0   Apr 23 2002 17:20:08   bnj2hi
 * Initial revision.
   
 ************************************************************************/

#ifndef FITYPES_HEADER
#define FITYPES_HEADER

class fi_tclVisitorBase;

/* --NAFI-Basistypen (General Navigation Data Types)
   Es werden alle Basistypen als Klassen definiert, um eine einheitliche 
   Handhabe zu gewaehrleisten. Der Standardkonstruktor sorgt dafuer, dass
   alle Objekte bei der Erzeugung einen definierten Wert erhalten. 
   Zugriffsmethoden auf einzelne Elemente der Objekte werden z.Zt. noch 
   nicht bereitgestellt. --*/

tU32 FI_u32StringLength(tCString coszValue);

class MY_DECL fi_tclTypeBase {
 public:
  enum { EN_TYPE = fi_tclToken::EN_UNKNOWN };
  
  fi_tclTypeBase() {}
  virtual ~fi_tclTypeBase() {}
     
  //--Die spezialisierten Klassen muessen die folgenden Methoden implementieren
  virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const =0;
  virtual tVoid vDestroy() {}
//  virtual tBool operator==(const fi_tclTypeBase&/* oCmp*/) const {return false;}
//#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
//  virtual fi_tclTypeBase& operator=(const fi_tclTypeBase& coRef) { return *this; }
//#endif
  virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const =0;
  virtual fi_tclInContext& oRead(fi_tclInContext& oInContext) =0;
  virtual tS32 s32GetTypeId() const { return (tS32)fi_tclToken::EN_UNKNOWN;}
  virtual fi_tclIOContextBase::tenByteOrder
     enGetByteOrder() const 
        { return fi_tclIOContextBase::EN_INTEL; }
  tBool bClone(const fi_tclTypeBase& corfoInit, tU16 u16MajorVersion);
};
//lint -esym(1774,fi_tclTypeBase) Could use dynamic_cast to downcast polymorphic type 'fi_tclTypeBase', because of special FI construct a cast is needed but dynamic cast should not be used (RTTI required, performance, bigger executable)

/** ***************************************************************************
* pure virtual interface definition for fi message objects. This interface
* allows to request serviceID, functionID and OpCode of the message. 
* Additionally it provides access to the fi_tclTypeBase of the curren object.
**************************************************************************** */
class MY_DECL fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const = 0;
   virtual tU16 u16GetFunctionID() const = 0;
   virtual tU8  u8GetOpCode() const = 0;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const = 0;
   virtual fi_tclTypeBase& rfoGetTypeBase() = 0;
   virtual ~fi_tclMessageBase(){};
};

#ifdef FI_S_FAST_WRITING
inline fi_tclOutContext& operator<<(fi_tclOutContext& oOutContext, 
				    const fi_tclTypeBase& oTypeBase) {
  return oTypeBase.oWrite(oOutContext);
}

inline fi_tclInContext& operator>>(fi_tclInContext& oInContext, 
				   fi_tclTypeBase& oTypeBase) {
  return oTypeBase.oRead(oInContext);
}
#else
fi_tclOutContext& operator<<(fi_tclOutContext& oOutContext, const fi_tclTypeBase& oTypeBase);
fi_tclInContext& operator>>(fi_tclInContext& oInContext, fi_tclTypeBase& oTypeBase);
#endif




#endif
