#ifndef FICONTEXT_HEADER
#define FICONTEXT_HEADER


// --Basisklasse fr Ausgabekontext
class MY_DECL fi_tclOutContext : public fi_tclIOContextBase {
public:

  // --Konstruktor
#ifndef FI_DEFAULT_VERSION
#pragma message("You have to set the define: 'FI_DEFAULT_VERSION=' or something like 'FI_DEFAULT_VERSION=3'")
#else
/*#define FI_TMP_DEFINE 0=FI_DEFAULT_VERSION =0
#if !FI_TMP_DEFINE
#pragma message("using default major version!")
#endif*/
#endif
// #pragma message("default major version for OutContext!")
  fi_tclOutContext(tU8* const pu8Start, tU8* const pu8End, tU16 u16Version FI_DEFAULT_VERSION, tenByteOrder enEndianess =EN_INTEL):
    fi_tclIOContextBase(pu8Start,pu8End,u16Version,enEndianess) {}

  // --Destruktor
  virtual ~fi_tclOutContext() {}

  // --Methoden zum Schreiben von einzelnen Werten
  fi_tclOutContext& oWrite(bool bValue);
  fi_tclOutContext& oWrite(tU8 u8Value);
  fi_tclOutContext& oWrite(tU16 u16Value);
  fi_tclOutContext& oWrite(const tU24& u24Value);
  fi_tclOutContext& oWrite(tU32 u32Value);
  fi_tclOutContext& oWrite(tU64 u64Value);


  fi_tclOutContext& oWrite(tS8 s8Value);
  fi_tclOutContext& oWrite(tS16 s16Value);
  fi_tclOutContext& oWrite(const tS24& u24Value);
  fi_tclOutContext& oWrite(tS32 s32Value);
  fi_tclOutContext& oWrite(tS64 s64Value);

  fi_tclOutContext& oWrite(tFloat f32Value);
  fi_tclOutContext& oWrite(tDouble f64Value);

  virtual fi_tclOutContext& oWrite(tString szValue);

  // --Virtuelle Methoden koennen von Spezialisierungen ueberladen werden
  virtual tU32 u32WriteAt(tU8 u8Value, tPU8 pu8AtPosition);
  virtual tU32 u32WriteAt(tU16 u16Value, tPU8 pu8AtPosition);
  virtual tU32 u32WriteAt(tU24 u24Value, tPU8 pu8AtPosition);
  virtual tU32 u32WriteAt(tU32 u32Value, tPU8 pu8AtPosition);
  virtual tU32 u32WriteAt(tU64 u64Value, tPU8 pu8AtPosition);

  virtual tU32 u32WriteAt(tS8 s8Value, tPU8 pu8AtPosition);
  virtual tU32 u32WriteAt(tS16 s16Value, tPU8 pu8AtPosition);
  virtual tU32 u32WriteAt(tS24 s24Value, tPU8 pu8AtPosition);
  virtual tU32 u32WriteAt(tS32 s32Value, tPU8 pu8AtPosition);
  virtual tU32 u32WriteAt(tS64 s64Value, tPU8 pu8AtPosition);

  virtual tU32 u32WriteAt(tFloat f32Value, tPU8 pu8AtPosition);
  virtual tU32 u32WriteAt(tDouble f64Value, tPU8 pu8AtPosition);
private:
  fi_tclOutContext(); //lint !e1704 no default construction allowed!
};

// --Basisklasse fr Eingabekontext
class MY_DECL fi_tclInContext : public fi_tclIOContextBase {
 public:

  // --Konstruktor
// #pragma message("default major version for InContext!")
  fi_tclInContext(tU8* const pu8Start, tU8* const pu8End, tU16 u16Version FI_DEFAULT_VERSION, tenByteOrder enEndianess =EN_INTEL):
    fi_tclIOContextBase(pu8Start,pu8End,u16Version,enEndianess) {}

  // --Destruktor
  virtual ~fi_tclInContext() {}

  // --Methoden zum Lesen von einzelnen Werten
  fi_tclInContext& oRead(bool& bValue);
  fi_tclInContext& oRead(tU8& u8Value);
  fi_tclInContext& oRead(tU16& u16Value);
  fi_tclInContext& oRead(tU24& u24Value);
  fi_tclInContext& oRead(tU32& u32Value);
  fi_tclInContext& oRead(tU64& u64Value);

  fi_tclInContext& oRead(tS8& s8Value);
  fi_tclInContext& oRead(tS16& s16Value);
  fi_tclInContext& oRead(tS24& s24Value);
  fi_tclInContext& oRead(tS32& s32Value);
  fi_tclInContext& oRead(tS64& s64Value);

  fi_tclInContext& oRead(tFloat& f32Value);
  fi_tclInContext& oRead(tDouble& f64Value);
  fi_tclInContext& oRead(tString& szValue);

  // --Virtuelle Methoden koennen von Spezialisierungen ueberladen werden
  virtual tU32 u32ReadAt(tU8& u8Value, tPU8 pu8AtPosition);
  virtual tU32 u32ReadAt(tU16& u16Value, tPU8 pu8AtPosition);
  virtual tU32 u32ReadAt(tU24& u24Value, tPU8 pu8AtPosition);
  virtual tU32 u32ReadAt(tU32& u32Value, tPU8 pu8AtPosition);
  virtual tU32 u32ReadAt(tU64& u64Value, tPU8 pu8AtPosition);

  virtual tU32 u32ReadAt(tS8& u8Value, tPU8 pu8AtPosition);
  virtual tU32 u32ReadAt(tS16& u16Value, tPU8 pu8AtPosition);
  virtual tU32 u32ReadAt(tS24& s24Value, tPU8 pu8AtPosition);
  virtual tU32 u32ReadAt(tS32& u32Value, tPU8 pu8AtPosition);
  virtual tU32 u32ReadAt(tS64& u64Value, tPU8 pu8AtPosition);

  virtual tU32 u32ReadAt(tFloat& f32Value, tPU8 pu8AtPosition);
  virtual tU32 u32ReadAt(tDouble& f64Value, tPU8 pu8AtPosition);
private:
  fi_tclInContext(); //lint !e1704 no default construction allowed!
};


// --Inline-Implementierungen

inline fi_tclOutContext& fi_tclOutContext::oWrite(bool bValue) {
   // --Schreibe ans Ende
   tU8 u8Value = bValue? 1 : 0;
   pu8Position+=u32WriteAt(u8Value,pu8Position);
   return *this;
}

inline fi_tclOutContext& fi_tclOutContext::oWrite(tU8 u8Value) {
  // --Schreibe ans Ende
  pu8Position+=u32WriteAt(u8Value,pu8Position);
  return *this;
}

inline fi_tclOutContext& fi_tclOutContext::oWrite(tU16 u16Value) {
  // --Schreibe ans Ende
  pu8Position+=u32WriteAt(u16Value,pu8Position);
  return *this;
}

inline fi_tclOutContext& fi_tclOutContext::oWrite(const tU24& u24Value) {
  // --Schreibe ans Ende
  pu8Position+=u32WriteAt(u24Value,pu8Position);
  return *this;
}

inline fi_tclOutContext& fi_tclOutContext::oWrite(tU32 u32Value) {
  // --Schreibe ans Ende
  pu8Position+=u32WriteAt(u32Value,pu8Position);
  return *this;
}

inline fi_tclOutContext& fi_tclOutContext::oWrite(tU64 u64Value) {
  // --Schreibe ans Ende
  pu8Position+=u32WriteAt(u64Value,pu8Position);
  return *this;
}

inline fi_tclOutContext& fi_tclOutContext::oWrite(tS8 s8Value) {
  // --Schreibe ans Ende
  pu8Position+=u32WriteAt(s8Value,pu8Position);
  return *this;
}

inline fi_tclOutContext& fi_tclOutContext::oWrite(tS16 s16Value) {
  // --Schreibe ans Ende
  pu8Position+=u32WriteAt(s16Value,pu8Position);
  return *this;
}

inline fi_tclOutContext& fi_tclOutContext::oWrite(const tS24& s24Value) {
  // --Schreibe ans Ende
  pu8Position+=u32WriteAt(s24Value,pu8Position);
  return *this;
}

inline fi_tclOutContext& fi_tclOutContext::oWrite(tS32 s32Value) {
  // --Schreibe ans Ende
  pu8Position+=u32WriteAt(s32Value,pu8Position);
  return *this;
}

inline fi_tclOutContext& fi_tclOutContext::oWrite(tS64 s64Value) {
  // --Schreibe ans Ende
  pu8Position+=u32WriteAt(s64Value,pu8Position);
  return *this;
}

inline fi_tclOutContext& fi_tclOutContext::oWrite(tFloat f32Value) {
  // --Schreibe ans Ende
  pu8Position+=u32WriteAt(f32Value,pu8Position);
  return *this;
}

inline fi_tclOutContext& fi_tclOutContext::oWrite(tDouble f64Value) {
  // --Schreibe ans Ende
  pu8Position+=u32WriteAt(f64Value,pu8Position);
  return *this;
}


// streaming operators as ordinary functions

inline fi_tclOutContext& operator<<(fi_tclOutContext& oOut, bool bValue) {
   return oOut.oWrite(bValue);
}

inline fi_tclOutContext& operator<<(fi_tclOutContext& oOut, tU8 u8Value) {
  return oOut.oWrite(u8Value);
}

inline fi_tclOutContext& operator<<(fi_tclOutContext& oOut, tU16 u16Value) {
  return oOut.oWrite(u16Value);
}

inline fi_tclOutContext& operator<<(fi_tclOutContext& oOut, const tU24& u24Value) {
  return oOut.oWrite(u24Value);
}

inline fi_tclOutContext& operator<<(fi_tclOutContext& oOut, tU32 u32Value) {
  return oOut.oWrite(u32Value);
}

inline fi_tclOutContext& operator<<(fi_tclOutContext& oOut, tU64 u64Value) {
  return oOut.oWrite(u64Value);
}

inline fi_tclOutContext& operator<<(fi_tclOutContext& oOut, tS8 s8Value) {
  return oOut.oWrite(s8Value);
}

inline fi_tclOutContext& operator<<(fi_tclOutContext& oOut, tS16 s16Value) {
  return oOut.oWrite(s16Value);
}

inline fi_tclOutContext& operator<<(fi_tclOutContext& oOut, const tS24& s24Value) {
  return oOut.oWrite(s24Value);
}

inline fi_tclOutContext& operator<<(fi_tclOutContext& oOut, tS32 s32Value) {
  return oOut.oWrite(s32Value);
}

inline fi_tclOutContext& operator<<(fi_tclOutContext& oOut, tS64 s64Value) {
  return oOut.oWrite(s64Value);
}

inline fi_tclOutContext& operator<<(fi_tclOutContext& oOut, tFloat f32Value) {
  return oOut.oWrite(f32Value);
}

inline fi_tclOutContext& operator<<(fi_tclOutContext& oOut, tDouble f64Value) {
  return oOut.oWrite(f64Value);
}

inline fi_tclOutContext& operator<<(fi_tclOutContext& oOut, tString szValue) {
  return oOut.oWrite(szValue);
}

inline fi_tclInContext& fi_tclInContext::oRead(bool& bValue) {
   // --Lese vom Ende
   tU8 u8Value;
   pu8Position+=u32ReadAt(u8Value,pu8Position);
   bValue = u8Value > 0;
   return *this;
}

inline fi_tclInContext& fi_tclInContext::oRead(tU8& u8Value) {
   // --Lese vom Ende
   pu8Position+=u32ReadAt(u8Value,pu8Position);
   return *this;
}

inline fi_tclInContext& fi_tclInContext::oRead(tU16& u16Value) {
  // --Lese vom Ende
  pu8Position+=u32ReadAt(u16Value,pu8Position);
  return *this;
}

inline fi_tclInContext& fi_tclInContext::oRead(tU24& u24Value) {
  // --Lese vom Ende
  pu8Position+=u32ReadAt(u24Value,pu8Position);
  return *this;
}

inline fi_tclInContext& fi_tclInContext::oRead(tU32& u32Value) {
  // --Lese vom Ende
  pu8Position+=u32ReadAt(u32Value,pu8Position);
  return *this;
}

inline fi_tclInContext& fi_tclInContext::oRead(tU64& u64Value) {
  // --Lese vom Ende
  pu8Position+=u32ReadAt(u64Value,pu8Position);
  return *this;
}

inline fi_tclInContext& fi_tclInContext::oRead(tS8& s8Value) {
  // --Lese vom Ende
  pu8Position+=u32ReadAt(s8Value,pu8Position);
  return *this;
}

inline fi_tclInContext& fi_tclInContext::oRead(tS16& s16Value) {
  // --Lese vom Ende
  pu8Position+=u32ReadAt(s16Value,pu8Position);
  return *this;
}

inline fi_tclInContext& fi_tclInContext::oRead(tS24& s24Value) {
  // --Lese vom Ende
  pu8Position+=u32ReadAt(s24Value,pu8Position);
  return *this;
}

inline fi_tclInContext& fi_tclInContext::oRead(tS32& s32Value) {
  // --Lese vom Ende
  pu8Position+=u32ReadAt(s32Value,pu8Position);
  return *this;
}

inline fi_tclInContext& fi_tclInContext::oRead(tS64& s64Value) {
  // --Lese vom Ende
  pu8Position+=u32ReadAt(s64Value,pu8Position);
  return *this;
}

inline fi_tclInContext& fi_tclInContext::oRead(tFloat& f32Value) {
  // --Lese vom Ende
  pu8Position+=u32ReadAt(f32Value,pu8Position);
  return *this;
}

inline fi_tclInContext& fi_tclInContext::oRead(tDouble& f64Value) {
  // --Lese vom Ende
  pu8Position+=u32ReadAt(f64Value,pu8Position);
  return *this;
}


// streaming operators as ordinary functions

inline fi_tclInContext& operator>>(fi_tclInContext& oIn, bool& bValue) {
   return oIn.oRead(bValue);
}

inline fi_tclInContext& operator>>(fi_tclInContext& oIn, tU8& u8Value) {
   return oIn.oRead(u8Value);
}

inline fi_tclInContext& operator>>(fi_tclInContext& oIn, tU16& u16Value) {
  return oIn.oRead(u16Value);
}

inline fi_tclInContext& operator>>(fi_tclInContext& oIn, tU24& u24Value) {
  return oIn.oRead(u24Value);
}

inline fi_tclInContext& operator>>(fi_tclInContext& oIn, tU32& u32Value) {
  return oIn.oRead(u32Value);
}

inline fi_tclInContext& operator>>(fi_tclInContext& oIn, tU64& u64Value) {
  return oIn.oRead(u64Value);
}

inline fi_tclInContext& operator>>(fi_tclInContext& oIn, tS8& s8Value) {
  return oIn.oRead(s8Value);
}

inline fi_tclInContext& operator>>(fi_tclInContext& oIn, tS16& s16Value) {
  return oIn.oRead(s16Value);
}

inline fi_tclInContext& operator>>(fi_tclInContext& oIn, tS24& s24Value) {
  return oIn.oRead(s24Value);
}

inline fi_tclInContext& operator>>(fi_tclInContext& oIn, tS32& s32Value) {
  return oIn.oRead(s32Value);
}

inline fi_tclInContext& operator>>(fi_tclInContext& oIn, tS64& s64Value) {
  return oIn.oRead(s64Value);
}

inline fi_tclInContext& operator>>(fi_tclInContext& oIn, tFloat& f32Value) {
  return oIn.oRead(f32Value);
}

inline fi_tclInContext& operator>>(fi_tclInContext& oIn, tDouble& f64Value) {
  return oIn.oRead(f64Value);
}

inline fi_tclInContext& operator>>(fi_tclInContext& oIn, tString& szValue) {
  return oIn.oRead(szValue);
}

class MY_DECL fi_tclCounterContext : public fi_tclOutContext {
public:

//#pragma message("default major version for CounterContext!")
	fi_tclCounterContext(tU16 u16Version FI_DEFAULT_VERSION):fi_tclOutContext(0,0,u16Version),u32Length(0) {}

	virtual tU32 u32WriteAt(tU8 /*u8Value*/, tPU8 /*pu8AtPosition*/) { u32Length+=sizeof(tU8); return 0; }
	virtual tU32 u32WriteAt(tU16 /*u16Value*/, tPU8 /*pu8AtPosition*/) { u32Length+=sizeof(tU16); return 0; }
	virtual tU32 u32WriteAt(tU32 /*u32Value*/, tPU8 /*pu8AtPosition*/) { u32Length+=sizeof(tU32); return 0; }
	virtual tU32 u32WriteAt(tU64 /*u32Value*/, tPU8 /*pu8AtPosition*/) { u32Length+=sizeof(tU64); return 0; }
   // hack !
	virtual tU32 u32WriteAt(tU24 /*u24Value*/, tPU8 /*pu8AtPosition*/) { u32Length+=3; return 0; }

  virtual tU32 u32WriteAt(tS8 /*s8Value*/, tPU8 /*pu8AtPosition*/) { u32Length+=sizeof(tS8); return 0; }
  virtual tU32 u32WriteAt(tS16 /*s16Value*/, tPU8 /*pu8AtPosition*/) { u32Length+=sizeof(tS16); return 0; }
  virtual tU32 u32WriteAt(tS24 /*s24Value*/, tPU8 /*pu8AtPosition*/) { u32Length+=3; return 0; }
  virtual tU32 u32WriteAt(tS32 /*s32Value*/, tPU8 /*pu8AtPosition*/) { u32Length+=sizeof(tS32); return 0; }
  virtual tU32 u32WriteAt(tS64 /*s32Value*/, tPU8 /*pu8AtPosition*/) { u32Length+=sizeof(tS64); return 0; }

  virtual tU32 u32WriteAt(tFloat /*f32Value*/, tPU8 /*pu8AtPosition*/) { u32Length+=sizeof(tFloat); return 0; }
  virtual tU32 u32WriteAt(tDouble /*f64Value*/, tPU8 /*pu8AtPosition*/) { u32Length+=sizeof(tDouble); return 0; }

  virtual fi_tclOutContext& oWrite(tString szValue);

	tU32 u32Length;
};

#endif
