#include "precompiled.hh"
   
fi_tclOutContext& fi_tclOutContext::oWrite(tString szValue) {
   // --Schreibe ans Ende
   if (szValue == 0) 
   {
      pu8Position+=u32WriteAt((tS8)0,pu8Position);
   } 
   else
   {
#ifdef FI_S_UTFMODE_TRANSPARENT
      tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
      if (u32UTFStringLength <= u32GetFreeSize())
      {
         (void)OSAL_szStringCopy((tString)pu8Position,szValue);
         pu8Position += u32UTFStringLength;
      }
      else
      {
         Invalidate();
      }
#else
      pu8Position += utfutil_u32ConvertISOMod2UTF8(
         (tChar*)pu8Position,
         u32GetFreeSize(),
         szValue,
         OSAL_u32StringLength(szValue) + 1
      );
#endif
   }
   return *this;
}

fi_tclInContext& fi_tclInContext::oRead(tString& szValue) {
   // --Lese vom Ende
   if (0 < u32GetFreeSize())
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength((tString)pu8Position) + 1;
      if (u32UTFStringLength <= u32GetFreeSize())
      {
   #ifdef FI_S_UTFMODE_TRANSPARENT
         tU32 u32ISOStringLength = u32UTFStringLength;
   #else
         tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
            0,
            0,
            (tChar*)(pu8Position),
            u32UTFStringLength
         );
   #endif
         // how about freeing the pointer before allocating new memory? Possible MemLeak!
         // on the other hand, not sure if this was a problem at least in the past -> some leaks occured in 2016, so call delete now!
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
   #ifdef FI_S_UTFMODE_TRANSPARENT
            (void)OSAL_szStringCopy(szValue,(tString)pu8Position);
   #else
            utfutil_u32ConvertUTF82ISOMod(
               szValue,
               u32ISOStringLength,
               (tString)pu8Position,
               u32UTFStringLength
            );
   #endif
         }
         else
         {
            // No memory for converted string, how to proceed?
         }
         pu8Position += u32UTFStringLength;
      }
      else
      {
         Invalidate();
      }
   }
   else
   {
      Invalidate();
   }

   return *this;
}

fi_tclOutContext& fi_tclCounterContext::oWrite(tString szValue)
{
   u32Length+=FI_u32StringLength(szValue)+1; return *this;
}

// --Implementierungen der Methoden zum Schreiben
tU32 fi_tclOutContext::u32WriteAt(tU8 u8Value, tPU8 pu8AtPosition) 
{
   // --Schreibe das Byte an die entsprechenden Stelle
   tU32 u32Size=sizeof(tU8);
   if (pu8AtPosition+u32Size<=pu8EndPosition)
   {
      *pu8AtPosition=u8Value;
   }
   else
   {
      u32Size=0;
      Invalidate();
   }
   return u32Size;
}

tU32 fi_tclOutContext::u32WriteAt(tU16 u16Value, tPU8 pu8AtPosition) 
{
  // --Schreibe das Low/High-Byte in der richtigen Reihenfolge
  tU32 u32Size=sizeof(tU16);
  if (pu8AtPosition+u32Size<=pu8EndPosition)
  {
    *(pu8AtPosition+acou8TwoByteOrder[enByteOrder][0])=u8LeastSignificantByte(u16Value);
    *(pu8AtPosition+acou8TwoByteOrder[enByteOrder][1])=u8MostSignificantByte(u16Value);
  } 
  else
  {
     Invalidate();
    u32Size=0;
  }
  return u32Size;
}

tU32 fi_tclOutContext::u32WriteAt(tU32 u32Value, tPU8 pu8AtPosition) 
{
  tU32 u32Size=sizeof(tU32);
  if (pu8AtPosition+u32Size<=pu8EndPosition) 
  {
    *(pu8AtPosition+acou8FourByteOrder[enByteOrder][0])=u8LeastSignificantByte(u32Value);
    *(pu8AtPosition+acou8FourByteOrder[enByteOrder][1])=u8LessSignificantByte(u32Value);
    *(pu8AtPosition+acou8FourByteOrder[enByteOrder][2])=u8MoreSignificantByte(u32Value);
    *(pu8AtPosition+acou8FourByteOrder[enByteOrder][3])=u8MostSignificantByte(u32Value);
  } 
  else
  {
    u32Size=0;
    Invalidate();
  }
  return u32Size;
}

tU32 fi_tclOutContext::u32WriteAt(tU64 u64Value, tPU8 pu8AtPosition) 
{
  tU32 u32Size=sizeof(tU64);
  if (pu8AtPosition+u32Size<=pu8EndPosition) 
  {
    tU8* pu8U64Value = (tU8*)&u64Value;
    *(pu8AtPosition) = *(pu8U64Value++);
    *(pu8AtPosition+1) = *(pu8U64Value++);
    *(pu8AtPosition+2) = *(pu8U64Value++);
    *(pu8AtPosition+3) = *(pu8U64Value++);
    *(pu8AtPosition+4) = *(pu8U64Value++);
    *(pu8AtPosition+5) = *(pu8U64Value++);
    *(pu8AtPosition+6) = *(pu8U64Value++);
    *(pu8AtPosition+7) = *(pu8U64Value++);
  } 
  else
  {
    u32Size=0;
    Invalidate();
  }
  return u32Size;
}

tU32 fi_tclOutContext::u32WriteAt(tFloat f32Value, tPU8 pu8AtPosition) 
{
  tU32 f32Size=sizeof(tFloat);
  tU8* pu8FloatValue = (tU8*)&f32Value;
  if (pu8AtPosition+f32Size<=pu8EndPosition) 
  {
    *(pu8AtPosition) = *(pu8FloatValue++);
    *(pu8AtPosition+1) = *(pu8FloatValue++);
    *(pu8AtPosition+2) = *(pu8FloatValue++);
    *(pu8AtPosition+3) = *(pu8FloatValue++);
  } 
  else
  {
    f32Size=0;
    Invalidate();
  }
  return f32Size;
}

tU32 fi_tclOutContext::u32WriteAt(tDouble f64Value, tPU8 pu8AtPosition) 
{
  tU32 f64Size=sizeof(tDouble);
  tU8* pu8DoubleValue = (tU8*)&f64Value;
  if (pu8AtPosition+f64Size<=pu8EndPosition) 
  {
    *(pu8AtPosition) = *(pu8DoubleValue++);
    *(pu8AtPosition+1) = *(pu8DoubleValue++);
    *(pu8AtPosition+2) = *(pu8DoubleValue++);
    *(pu8AtPosition+3) = *(pu8DoubleValue++);
    *(pu8AtPosition+4) = *(pu8DoubleValue++);
    *(pu8AtPosition+5) = *(pu8DoubleValue++);
    *(pu8AtPosition+6) = *(pu8DoubleValue++);
    *(pu8AtPosition+7) = *(pu8DoubleValue++);
  }
  else
  {
    f64Size=0;
    Invalidate();
  }
  return f64Size;
}

tU32 fi_tclOutContext::u32WriteAt(tU24 u24Value, tPU8 pu8AtPosition) 
{
  // ATTENTION, this (nonstandard) type ignores endianess
  tU32 u24Size=3;
  tU8* pu8U24Value = (tU8*)&u24Value;
  if (pu8AtPosition+u24Size<=pu8EndPosition) 
  {
    *(pu8AtPosition)=*(pu8U24Value++);
    *(pu8AtPosition+1)=*(pu8U24Value++);
    *(pu8AtPosition+2)=*(pu8U24Value++);
  } 
  else
  {
    u24Size=0;
    Invalidate();
  }
  return u24Size;
}

/* --Wir reduzieren das Problem der vorzeichenbehafteten Typen einfach auf das Problem der 
	vorzeichenlosen (alter Indianertrick). */

tU32 fi_tclOutContext::u32WriteAt(tS8 s8Value,tPU8 pu8AtPosition) {
	return u32WriteAt((tU8)s8Value,pu8AtPosition);
}

tU32 fi_tclOutContext::u32WriteAt(tS16 s16Value,tPU8 pu8AtPosition) {
	return u32WriteAt((tU16)s16Value,pu8AtPosition);
}

tU32 fi_tclOutContext::u32WriteAt(tS24 s24Value,tPU8 pu8AtPosition) {
	return u32WriteAt((tU24)s24Value,pu8AtPosition);
}

tU32 fi_tclOutContext::u32WriteAt(tS32 s32Value,tPU8 pu8AtPosition) {
	return u32WriteAt((tU32)s32Value,pu8AtPosition);
}

tU32 fi_tclOutContext::u32WriteAt(tS64 s64Value,tPU8 pu8AtPosition) {
	return u32WriteAt((tU64)s64Value,pu8AtPosition);
}

// --Implementierungen der Methoden zum Lesen
tU32 fi_tclInContext::u32ReadAt(tU8& u8Value, tPU8 pu8AtPosition) 
{
  // --Lese das Byte von der entsprechenden Stelle
  tU32 u32Size=sizeof(tU8);
  if (pu8AtPosition+u32Size<=pu8EndPosition)
  {
    u8Value=*pu8AtPosition;
  }
  else
  {
    u32Size=0;
    u8Value = 0;
    Invalidate();
  }
  return u32Size;
}

tU32 fi_tclInContext::u32ReadAt(tU16& u16Value, tPU8 pu8AtPosition) 
{
  // --Lese das Low/High-Byte in der richtigen Reihenfolge
  tU32 u32Size=sizeof(tU16);
  if (pu8AtPosition+u32Size<=pu8EndPosition) 
  {
    vLeastSignificantByte(u16Value,*(pu8AtPosition+acou8TwoByteOrder[enByteOrder][0]));
    vMostSignificantByte(u16Value,*(pu8AtPosition+acou8TwoByteOrder[enByteOrder][1]));
  }
  else
  {
    u32Size=0;
    u16Value = 0;
    Invalidate();
  }
  return u32Size;
}

tU32 fi_tclInContext::u32ReadAt(tU32& u32Value, tPU8 pu8AtPosition) 
{
  tU32 u32Size=sizeof(tU32);
  if (pu8AtPosition+u32Size<=pu8EndPosition) 
  {
    vLeastSignificantByte(u32Value,*(pu8AtPosition+acou8FourByteOrder[enByteOrder][0]));
    vLessSignificantByte(u32Value,*(pu8AtPosition+acou8FourByteOrder[enByteOrder][1]));
    vMoreSignificantByte(u32Value,*(pu8AtPosition+acou8FourByteOrder[enByteOrder][2]));
    vMostSignificantByte(u32Value,*(pu8AtPosition+acou8FourByteOrder[enByteOrder][3]));
  } 
  else
  {
    u32Size=0;
    u32Value = 0;
    Invalidate();
  }
  return u32Size;
}

tU32 fi_tclInContext::u32ReadAt(tU64& u64Value, tPU8 pu8AtPosition) 
{
  tU32 u32Size=sizeof(tU64);
  // OUCH!!!!!! The following is VERY ugly
  tU8* pu8U64Value = (tU8*)&u64Value;
  if (pu8AtPosition+u32Size<=pu8EndPosition) 
  {
    *(pu8U64Value++) = *(pu8AtPosition);
    *(pu8U64Value++) = *(pu8AtPosition+1);
    *(pu8U64Value++) = *(pu8AtPosition+2);
    *(pu8U64Value++) = *(pu8AtPosition+3);
    *(pu8U64Value++) = *(pu8AtPosition+4);
    *(pu8U64Value++) = *(pu8AtPosition+5);
    *(pu8U64Value++) = *(pu8AtPosition+6);
    *(pu8U64Value++) = *(pu8AtPosition+7);
  } 
  else
  {
    u32Size=0;
    u64Value = 0;
    Invalidate();
  }
  return u32Size;
}

tU32 fi_tclInContext::u32ReadAt(tFloat& f32Value, tPU8 pu8AtPosition) 
{
  tU32 f32Size=sizeof(tFloat);
  // OUCH!!!!!! The following is VERY ugly
  tU8* pu8FloatValue = (tU8*)&f32Value;
  if (pu8AtPosition+f32Size<=pu8EndPosition) 
  {
    *(pu8FloatValue++) = *(pu8AtPosition);
    *(pu8FloatValue++) = *(pu8AtPosition+1);
    *(pu8FloatValue++) = *(pu8AtPosition+2);
    *(pu8FloatValue++) = *(pu8AtPosition+3);
  } 
  else
  {
    f32Size=0;
    f32Value = 0.0;
    Invalidate();
  }
  return f32Size;
}

tU32 fi_tclInContext::u32ReadAt(tDouble& f64Value, tPU8 pu8AtPosition) 
{
  tU32 f64Size=sizeof(tDouble);
  // OUCH!!!!!! The following is VERY ugly
  tU8* pu8FloatValue = (tU8*)&f64Value;
  if (pu8AtPosition+f64Size<=pu8EndPosition) 
  {
    *(pu8FloatValue++) = *(pu8AtPosition);
    *(pu8FloatValue++) = *(pu8AtPosition+1);
    *(pu8FloatValue++) = *(pu8AtPosition+2);
    *(pu8FloatValue++) = *(pu8AtPosition+3);
    *(pu8FloatValue++) = *(pu8AtPosition+4);
    *(pu8FloatValue++) = *(pu8AtPosition+5);
    *(pu8FloatValue++) = *(pu8AtPosition+6);
    *(pu8FloatValue++) = *(pu8AtPosition+7);
  } 
  else
  {
    f64Size=0;
    f64Value = 0.0;
    Invalidate();
  }
  return f64Size;
}

tU32 fi_tclInContext::u32ReadAt(tU24& u24Value, tPU8 pu8AtPosition) 
{
  tU32 u24Size=3;
  tU8* pu8U24Value = (tU8*)&u24Value;
  if (pu8AtPosition+u24Size<=pu8EndPosition) 
  {
     *(pu8U24Value++) = *(pu8AtPosition);
     *(pu8U24Value++) = *(pu8AtPosition+1);
     *(pu8U24Value++) = *(pu8AtPosition+2);
    *(pu8U24Value++) = 0; // fill MSB with 0, since not in context.
  }
  else
  {
    u24Size=0;
    u24Value = 0;
    Invalidate();
  }
  return u24Size;
}

// --s.o.
tU32 fi_tclInContext::u32ReadAt(tS8& s8Value, tPU8 pu8AtPosition) 
{
	tU8 u8Value=(tU8)s8Value;
	tU32 u32ReturnValue=u32ReadAt(u8Value,pu8AtPosition);
	s8Value=(tS8)u8Value;	
	return u32ReturnValue;
}

tU32 fi_tclInContext::u32ReadAt(tS16& s16Value, tPU8 pu8AtPosition) 
{
	tU16 u16Value=(tU16)s16Value;
	tU32 u32ReturnValue=u32ReadAt(u16Value,pu8AtPosition);
	s16Value=(tS16)u16Value;	
	return u32ReturnValue;
}

tU32 fi_tclInContext::u32ReadAt(tS32& s32Value, tPU8 pu8AtPosition) 
{
	tU32 u32Value=(tU32)s32Value;
	tU32 u32ReturnValue=u32ReadAt(u32Value,pu8AtPosition);
	s32Value=(tS32)u32Value;	
	return u32ReturnValue;
}

tU32 fi_tclInContext::u32ReadAt(tS64& s64Value, tPU8 pu8AtPosition) 
{
	tU64 u64Value=(tU64)s64Value;
	tU32 u32ReturnValue=u32ReadAt(u64Value,pu8AtPosition);
	s64Value=(tS64)u64Value;	
	return u32ReturnValue;
}

tU32 fi_tclInContext::u32ReadAt(tS24& s24Value, tPU8 pu8AtPosition) 
{
	// ugly hack !
	tU24 u24Value=s24Value;
	tU32 u32ReturnValue=u32ReadAt(u24Value,pu8AtPosition);
	s24Value=(tS24)u24Value;	
/*	if ((s24Value & 0x800000) != 0)
	  s24Value |= 0xFF000000;	*/
	return u32ReturnValue;
}
