#ifndef FIBASE_HEADER
#define FIBASE_HEADER

// used for map messages, no real OSAL/pctypes types

class tU24;
class tS24
{
public:
   tS24& operator =(tS32 s32Value) { s24Value = s32Value; return *this; }
   tS24(const tS32 s32Value):s24Value(s32Value) {}
   tS24(const tU24& oU24);
   tS24():s24Value(0) {}
  int s24Value;
}; //lint !e1721 (assignment of integer instead of tS24 is intentional, to be more useful! (J.Bruns)
tBool operator ==(const tS24& corfS24_1, const tS24& corfS24_2);

class tU24
{
public:
   tU24& operator=(tU32 u32Value) { u24Value = (u32Value & 0xFFFFFF); return *this; }
   tU24(const tU32 u32Value):u24Value(u32Value & 0xFFFFFF) {}
   tU24(const tS24& oS24);
   tU24():u24Value(0) {}
   unsigned int u24Value;
}; //lint !e1721 (assignment of integer instead of tS24 is intentional, to be more useful! (J.Bruns)
tBool operator ==(const tU24& corfU24_1, const tU24& corfU24_2);

class MY_DECL fi_tclIOContextBase {
 public:

  // --Byteanordnung (Intel[little]/Motorola[big])
  enum tenByteOrder { EN_LITTLE =0, EN_BIG =1, EN_INTEL=EN_LITTLE, EN_MOTOROLA=EN_BIG};

  // --Konstruktor
  fi_tclIOContextBase(tU8* const pu8Start, tU8* const pu8End, tU16 u16MajorVersion, tenByteOrder enOrder=EN_INTEL);

  // --Destruktor
  virtual ~fi_tclIOContextBase() {} //lint !e1540 (freeing ptrs is prohibited, zeroing is unneccessary)

  // --Zugriff auf bestimmte Positionen des Kontextes
  const tU8* pu8GetStartPosition() const { return pu8StartPosition; }
  const tU8* pu8GetEndPosition() const { return pu8EndPosition; }
  const tU8* pu8GetPosition() const { return pu8Position; }
  
  // --(Freie) Gre 
  tU32 u32GetSize() const { return (pu8EndPosition-pu8StartPosition)>0?(tU32)(pu8EndPosition-pu8StartPosition):0; }
  tU32 u32GetFilledSize() const { return (pu8Position-pu8StartPosition)>0?(tU32)(pu8Position-pu8StartPosition):0; }
  tU32 u32GetFreeSize() const { return (pu8EndPosition-pu8Position)>0?(tU32)(pu8EndPosition-pu8Position):0; }
  tBool bCheckPlace(tU32 u32CheckSize) const { 
     return ((pu8Position + u32CheckSize)<pu8EndPosition) ? (tBool)TRUE : (tBool) FALSE; }

  // --Bereits voll?
  tBool bIsFull() const { return pu8Position<pu8EndPosition ? (tBool)FALSE : (tBool)TRUE; }

  // --Byteanordnung
  tenByteOrder enGetByteOrder() const { return enByteOrder; }

  // Gltigkeit des Kontextes
  tBool bIsValid() const { return bContextIsValid; }
  tVoid Invalidate() { bContextIsValid = FALSE; }
  
  tU16 u16GetMajorVersion() const { return u16MajorVersion; }
  tU16 u16SetMajorVersion(tU16 u16NewMajorVersion) { 
     tU16 u16TmpVersion = u16MajorVersion;
     u16MajorVersion = u16NewMajorVersion; 
     return u16TmpVersion; 
  }

protected:

  tU16 u16MajorVersion;
  // --Zerlege 16/32-bittige Zahl
  tU8 u8MostSignificantByte(tU16 u16Value) const;
  tU8 u8LeastSignificantByte(tU16 u16Value) const;

  tU8 u8MostSignificantByte(tU32 u32Value) const;
  tU8 u8MoreSignificantByte(tU32 u32Value) const;
  tU8 u8LessSignificantByte(tU32 u32Value) const;
  tU8 u8LeastSignificantByte(tU32 u32Value) const;

  tVoid vMostSignificantByte(tU16& u16Value, tU8 u8Value) const;
  tVoid vLeastSignificantByte(tU16& u16Value, tU8 u8Value) const;

  tVoid vMostSignificantByte(tU32& u32Value, tU8 u8Value) const;
  tVoid vMoreSignificantByte(tU32& u32Value, tU8 u8Value) const;
  tVoid vLessSignificantByte(tU32& u32Value, tU8 u8Value) const;
  tVoid vLeastSignificantByte(tU32& u32Value, tU8 u8Value) const;

  // --Konstanten fr die beiden Endian-Formate
  static const tU8 acou8TwoByteOrder[2][2];
  static const tU8 acou8FourByteOrder[2][4];

  tU8* const pu8StartPosition;
  tU8* const pu8EndPosition; // --Eine Position hinter dem letzten Zeichen
  tPU8 pu8Position;

  tenByteOrder enByteOrder;
  
private:
  tBool bContextIsValid;
  fi_tclIOContextBase(); //lint !e1704 no default construction allowed!
};

// --Inline-Implementierungen der Zerlege-Methoden
inline tU8 fi_tclIOContextBase::u8MostSignificantByte(tU16 u16Value) const {
  return tU8(u16Value>>8);
}

inline tU8 fi_tclIOContextBase::u8LeastSignificantByte(tU16 u16Value) const {
  return tU8(u16Value);
}

inline tU8 fi_tclIOContextBase::u8MostSignificantByte(tU32 u32Value) const {
  return tU8(u32Value>>24);
}

inline tU8 fi_tclIOContextBase::u8MoreSignificantByte(tU32 u32Value) const {
  return tU8(u32Value>>16);
}

inline tU8 fi_tclIOContextBase::u8LessSignificantByte(tU32 u32Value) const {
  return tU8(u32Value>>8);
}

inline tU8 fi_tclIOContextBase::u8LeastSignificantByte(tU32 u32Value) const {
  return tU8(u32Value);
}

inline tVoid fi_tclIOContextBase::vMostSignificantByte(tU16& u16Value, tU8 u8Value) const {
  u16Value=(tU16)((((tU16)u8Value)<<8)|(u16Value&0x00ff));
}

inline tVoid fi_tclIOContextBase::vLeastSignificantByte(tU16& u16Value, tU8 u8Value) const {
  u16Value=(tU16)(((tU16)u8Value)|(u16Value&0xff00));
}

inline tVoid fi_tclIOContextBase::vMostSignificantByte(tU32& u32Value, tU8 u8Value) const {
  u32Value=(((tU32)u8Value)<<24)|(u32Value&0x00ffffff);
}

inline tVoid fi_tclIOContextBase::vMoreSignificantByte(tU32& u32Value, tU8 u8Value) const {
  u32Value=(((tU32)u8Value)<<16)|(u32Value&0xff00ffff);
}

inline tVoid fi_tclIOContextBase::vLessSignificantByte(tU32& u32Value, tU8 u8Value) const {
  u32Value=(((tU32)u8Value)<<8)|(u32Value&0xffff00ff);
}

inline tVoid fi_tclIOContextBase::vLeastSignificantByte(tU32& u32Value, tU8 u8Value) const {
  u32Value=((tU32)u8Value)|(u32Value&0xffffff00);
}



tVoid dump(const fi_tclIOContextBase& oContext);

#endif
