/* --DO NOT PROTECT THIS FILE AGAINST DOUBLE INCLUDE !!! */
/************************************************************* +IHDR * .IA *

 .DATEI                [ fi_msgfw_if.h       ]

 .BESCHREIBUNG

  ---General Information to the Component Maintainer

     Please remind that a modification of an interface can cause some trouble
     to the components which import the interface. The interface file may only
     export files from the component or another interface file.

 ---COMPONENT INTERFACE(S)

     Interface: BASE_TYPES
                definition of the basic framework parts used by all FIs.

     Interface: MESSAGE
                access to message handling functions

     Interface: PROPERTYTEMPLATE
                definition of a FI property template

 .COPYRIGHT            [ (c) 2002 Robert Bosch GmbH, Hildesheim           ]
 .AUTOR                [ J. Bruns                                         ]

  Datum    | Name          Modifikation
 ----------|---------------------------------------------------------------
  15.06.05 | CM-DI/ESN1-Br neu
************************************************************** -IHDR * .IE */

   #ifdef MAKE_FI_DLL
     #define MY_DECL  __declspec(dllexport)
   #else
     #ifdef USE_FI_DLL
       #define MY_DECL  __declspec(dllimport)
     #else
       #define MY_DECL
     #endif
   #endif

#if (defined OSAL_OS) || (defined OSAL_CONF)
   #define OSAL_S_IMPORT_INTERFACE_GENERIC
   #include "osal_if.h"
#endif

// always import FI_VERSION
#define FI_S_IMPORT_INTERFACE_FI_VERSION

/* to control the usage of interfaces */
#define FI_MSGFW_S_NO_IMPORT_INTERFACE

#ifdef FI_S_IMPORT_INTERFACE_FI_VERSION
#undef FI_S_NO_IMPORT_INTERFACE
/* import declaration of version struct */
#include "msgfw/fiversion.h"
#endif


/* -------------------------------------------------------------------------- */

/*
 *   Interface: FI_TYPEFACTORY
 *              factory for all types of the navi fi group
 */
#ifdef FI_S_IMPORT_INTERFACE_TYPEFACTORY
#undef FI_S_NO_IMPORT_INTERFACE

/* --Protection against double include of the interface. */
#ifndef FI_S_ALREADY_INCLUDE_TYPEFACTORY
#define FI_S_ALREADY_INCLUDE_TYPEFACTORY
/* -- Dependencies on other Interfaces */

/* --Includes. */
#include "msgfw/fibase.h"
#include "msgfw/ficontext.h"
#include "msgfw/fitoken.h"
#include "msgfw/fistack.h"
#include "msgfw/fitypes.h"
#include "msgfw/alltypefactory.h"

#endif /* --FI_S_ALREADY_INCLUDE_TYPEFACTORY */
#endif /* --FI_S_IMPORT_INTERFACE_TYPEFACTORY */

/*
 *   Interface: BASE_TYPES
 *              definition of the basic framework parts used by all FIs.
 */
#ifdef FI_S_IMPORT_INTERFACE_BASE_TYPES
   #undef FI_MSGFW_S_NO_IMPORT_INTERFACE

/* --Protection against double include of the interface. */
#ifndef FI_S_ALREADY_INCLUDE_BASE_TYPES
   #define FI_S_ALREADY_INCLUDE_BASE_TYPES
   /* -- Dependencies on other Interfaces */

   /* --Includes. */
   #include "msgfw/fibase.h"
   #include "msgfw/ficontext.h"
   #include "msgfw/fitoken.h"
   #include "msgfw/fistack.h"
   #include "msgfw/fitypes.h"

#endif /* --FI_S_ALREADY_INCLUDE_BASE_TYPES */
#endif /* --FI_S_IMPORT_INTERFACE_BASE_TYPES */


/*
 *   Interface: MESSAGE
 *              definition of an AMT class suitable but not exclusively usable
 *              together with the visitor and type framework.
 */
#ifdef FI_S_IMPORT_INTERFACE_FI_MESSAGE
   #undef FI_MSGFW_S_NO_IMPORT_INTERFACE

   /* --Protection against double include of the interface. */
   #ifndef FI_S_ALREADY_INCLUDE_FI_MESSAGE
      #define FI_S_ALREADY_INCLUDE_FI_MESSAGE
      /* -- Dependencies on other Interfaces */
      #define S_IMPORT_SUB_INTERFACE
         #define AMT_S_IMPORT_INTERFACE_GENERIC
         #include "amt_if.h"
      #undef S_IMPORT_SUB_INTERFACE

      /* --Includes. */
      #include "msgfw/fibase.h"
      #include "msgfw/ficontext.h"
      #include "msgfw/fitoken.h"
      #include "msgfw/fistack.h"
      #include "msgfw/fitypes.h"
      #include "msgfw/fivisitoramtmsg.h"

   #endif /* --FI_S_ALREADY_INCLUDE_FI_MESSAGE */
#endif /* --FI_S_IMPORT_INTERFACE_FI_MESSAGE */


/*
 *   Interface: PROPERTYTEMPLATE
 *              definition of a FI property template
 */
#ifdef FI_S_IMPORT_INTERFACE_FI_PROPERTYTEMPLATE
   #undef FI_MSGFW_S_NO_IMPORT_INTERFACE

   /* --Protection against double include of the interface. */
   #ifndef FI_S_ALREADY_INCLUDE_FI_PROPERTYTEMPLATE
      #define FI_S_ALREADY_INCLUDE_FI_PROPERTYTEMPLATE
      /* -- Dependencies on other Interfaces */
      #define S_IMPORT_SUB_INTERFACE
         #define RTF_S_IMPORT_INTERFACE_GENERIC
         #include "rtf_if.h"
      #undef S_IMPORT_SUB_INTERFACE

      /* --additional includes of fi_message */
      #include "msgfw/fibase.h"
      #include "msgfw/ficontext.h"
      #include "msgfw/fitoken.h"
      #include "msgfw/fistack.h"
      #include "msgfw/fitypes.h"
      #include "msgfw/fivisitoramtmsg.h"

      /* --Includes */
      #include "msgfw/firtfpropertytemplate"

   #endif /* --FI_S_ALREADY_INCLUDE_FI_PROPERTYTEMPLATE */
#endif /* --FI_S_IMPORT_INTERFACE_FI_PROPERTYTEMPLATE */

/* end of file */
