/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#include "precompiled.hh"
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weathertunerfi_tclMsgGetMetarDataMethodStart::weathertunerfi_tclMsgGetMetarDataMethodStart(const weathertunerfi_tclMsgGetMetarDataMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weathertunerfi_tclMsgGetMetarDataMethodStart& weathertunerfi_tclMsgGetMetarDataMethodStart::operator=(const weathertunerfi_tclMsgGetMetarDataMethodStart& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weathertunerfi_tclMsgGetMetarDataMethodStart::u16GetServiceID() const {return WEATHERTUNERFI_C_U16_SERVICE_ID;}
tU16 weathertunerfi_tclMsgGetMetarDataMethodStart::u16GetFunctionID() const {return WEATHERTUNERFI_C_U16_GETMETARDATA;}
tU8 weathertunerfi_tclMsgGetMetarDataMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 weathertunerfi_tclMsgGetMetarDataMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weathertunerfi_tclMsgGetMetarDataMethodStart::operator==(const weathertunerfi_tclMsgGetMetarDataMethodStart& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weathertunerfi_tclMsgGetMetarDataMethodStart::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weathertunerfi_tclMsgGetMetarDataMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weathertunerfi_tclMsgGetMetarDataMethodResult::weathertunerfi_tclMsgGetMetarDataMethodResult(const weathertunerfi_tclMsgGetMetarDataMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   MetarBlockId = coRef.MetarBlockId;
   GenerationTime = coRef.GenerationTime;
   MetarData = coRef.MetarData;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weathertunerfi_tclMsgGetMetarDataMethodResult& weathertunerfi_tclMsgGetMetarDataMethodResult::operator=(const weathertunerfi_tclMsgGetMetarDataMethodResult& coRef)
{
   if (this == &coRef) return *this;
   MetarBlockId = coRef.MetarBlockId;
   GenerationTime = coRef.GenerationTime;
   MetarData = coRef.MetarData;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weathertunerfi_tclMsgGetMetarDataMethodResult::u16GetServiceID() const {return WEATHERTUNERFI_C_U16_SERVICE_ID;}
tU16 weathertunerfi_tclMsgGetMetarDataMethodResult::u16GetFunctionID() const {return WEATHERTUNERFI_C_U16_GETMETARDATA;}
tU8 weathertunerfi_tclMsgGetMetarDataMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid weathertunerfi_tclMsgGetMetarDataMethodResult::vDestroy()
{
   GenerationTime.vDestroy(); 
   MetarData.clear();
}

tU32 weathertunerfi_tclMsgGetMetarDataMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 12+MetarData.size()*1;
}

tBool weathertunerfi_tclMsgGetMetarDataMethodResult::operator==(const weathertunerfi_tclMsgGetMetarDataMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (MetarBlockId == rfoCmp.MetarBlockId);
      bResult = bResult && (GenerationTime == rfoCmp.GenerationTime);
      bResult = bResult && (MetarData.size() == rfoCmp.MetarData.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < MetarData.size()); ++u32Idx)
            bResult = bResult && (MetarData[u32Idx] == rfoCmp.MetarData[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& weathertunerfi_tclMsgGetMetarDataMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> MetarBlockId;
   oIn >> GenerationTime;
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      MetarData.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> MetarData[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& weathertunerfi_tclMsgGetMetarDataMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << MetarBlockId;
   oOut << GenerationTime;
   oOut << (tU32)MetarData.size();
   {
      for (tU32 u32Idx = 0; u32Idx < MetarData.size(); ++u32Idx)
         oOut << MetarData[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weathertunerfi_tclMsgGetMetarDataMethodResultFirst::weathertunerfi_tclMsgGetMetarDataMethodResultFirst(const weathertunerfi_tclMsgGetMetarDataMethodResultFirst& coRef):fi_tclVisitableTypeBase(coRef)
{
   MetarBlockId = coRef.MetarBlockId;
   GenerationTime = coRef.GenerationTime;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weathertunerfi_tclMsgGetMetarDataMethodResultFirst& weathertunerfi_tclMsgGetMetarDataMethodResultFirst::operator=(const weathertunerfi_tclMsgGetMetarDataMethodResultFirst& coRef)
{
   if (this == &coRef) return *this;
   MetarBlockId = coRef.MetarBlockId;
   GenerationTime = coRef.GenerationTime;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weathertunerfi_tclMsgGetMetarDataMethodResultFirst::u16GetServiceID() const {return WEATHERTUNERFI_C_U16_SERVICE_ID;}
tU16 weathertunerfi_tclMsgGetMetarDataMethodResultFirst::u16GetFunctionID() const {return WEATHERTUNERFI_C_U16_GETMETARDATA;}
tU8 weathertunerfi_tclMsgGetMetarDataMethodResultFirst::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULTFIRST;}

tVoid weathertunerfi_tclMsgGetMetarDataMethodResultFirst::vDestroy()
{
   GenerationTime.vDestroy(); 
}

tU32 weathertunerfi_tclMsgGetMetarDataMethodResultFirst::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

tBool weathertunerfi_tclMsgGetMetarDataMethodResultFirst::operator==(const weathertunerfi_tclMsgGetMetarDataMethodResultFirst& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (MetarBlockId == rfoCmp.MetarBlockId);
      bResult = bResult && (GenerationTime == rfoCmp.GenerationTime);
   return bResult;
}

fi_tclInContext& weathertunerfi_tclMsgGetMetarDataMethodResultFirst::oRead(fi_tclInContext& oIn)
{
   oIn >> MetarBlockId;
   oIn >> GenerationTime;
   return oIn;
}

fi_tclOutContext& weathertunerfi_tclMsgGetMetarDataMethodResultFirst::oWrite(fi_tclOutContext& oOut) const
{
   oOut << MetarBlockId;
   oOut << GenerationTime;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weathertunerfi_tclMsgGetMetarDataMethodResultMiddle::weathertunerfi_tclMsgGetMetarDataMethodResultMiddle(const weathertunerfi_tclMsgGetMetarDataMethodResultMiddle& coRef):fi_tclVisitableTypeBase(coRef)
{
   MetarData = coRef.MetarData;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weathertunerfi_tclMsgGetMetarDataMethodResultMiddle& weathertunerfi_tclMsgGetMetarDataMethodResultMiddle::operator=(const weathertunerfi_tclMsgGetMetarDataMethodResultMiddle& coRef)
{
   if (this == &coRef) return *this;
   MetarData = coRef.MetarData;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weathertunerfi_tclMsgGetMetarDataMethodResultMiddle::u16GetServiceID() const {return WEATHERTUNERFI_C_U16_SERVICE_ID;}
tU16 weathertunerfi_tclMsgGetMetarDataMethodResultMiddle::u16GetFunctionID() const {return WEATHERTUNERFI_C_U16_GETMETARDATA;}
tU8 weathertunerfi_tclMsgGetMetarDataMethodResultMiddle::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULTMIDDLE;}

tVoid weathertunerfi_tclMsgGetMetarDataMethodResultMiddle::vDestroy()
{
   MetarData.clear();
}

tU32 weathertunerfi_tclMsgGetMetarDataMethodResultMiddle::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+MetarData.size()*1;
}

tBool weathertunerfi_tclMsgGetMetarDataMethodResultMiddle::operator==(const weathertunerfi_tclMsgGetMetarDataMethodResultMiddle& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (MetarData.size() == rfoCmp.MetarData.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < MetarData.size()); ++u32Idx)
            bResult = bResult && (MetarData[u32Idx] == rfoCmp.MetarData[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& weathertunerfi_tclMsgGetMetarDataMethodResultMiddle::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      MetarData.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> MetarData[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& weathertunerfi_tclMsgGetMetarDataMethodResultMiddle::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)MetarData.size();
   {
      for (tU32 u32Idx = 0; u32Idx < MetarData.size(); ++u32Idx)
         oOut << MetarData[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weathertunerfi_tclMsgGetMetarDataMethodResultLast::weathertunerfi_tclMsgGetMetarDataMethodResultLast(const weathertunerfi_tclMsgGetMetarDataMethodResultLast& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weathertunerfi_tclMsgGetMetarDataMethodResultLast& weathertunerfi_tclMsgGetMetarDataMethodResultLast::operator=(const weathertunerfi_tclMsgGetMetarDataMethodResultLast& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weathertunerfi_tclMsgGetMetarDataMethodResultLast::u16GetServiceID() const {return WEATHERTUNERFI_C_U16_SERVICE_ID;}
tU16 weathertunerfi_tclMsgGetMetarDataMethodResultLast::u16GetFunctionID() const {return WEATHERTUNERFI_C_U16_GETMETARDATA;}
tU8 weathertunerfi_tclMsgGetMetarDataMethodResultLast::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULTLAST;}

tU32 weathertunerfi_tclMsgGetMetarDataMethodResultLast::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weathertunerfi_tclMsgGetMetarDataMethodResultLast::operator==(const weathertunerfi_tclMsgGetMetarDataMethodResultLast& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weathertunerfi_tclMsgGetMetarDataMethodResultLast::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weathertunerfi_tclMsgGetMetarDataMethodResultLast::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weathertunerfi_tclMsgGetCCFDataMethodStart::weathertunerfi_tclMsgGetCCFDataMethodStart(const weathertunerfi_tclMsgGetCCFDataMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weathertunerfi_tclMsgGetCCFDataMethodStart& weathertunerfi_tclMsgGetCCFDataMethodStart::operator=(const weathertunerfi_tclMsgGetCCFDataMethodStart& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weathertunerfi_tclMsgGetCCFDataMethodStart::u16GetServiceID() const {return WEATHERTUNERFI_C_U16_SERVICE_ID;}
tU16 weathertunerfi_tclMsgGetCCFDataMethodStart::u16GetFunctionID() const {return WEATHERTUNERFI_C_U16_GETCCFDATA;}
tU8 weathertunerfi_tclMsgGetCCFDataMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 weathertunerfi_tclMsgGetCCFDataMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weathertunerfi_tclMsgGetCCFDataMethodStart::operator==(const weathertunerfi_tclMsgGetCCFDataMethodStart& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weathertunerfi_tclMsgGetCCFDataMethodStart::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weathertunerfi_tclMsgGetCCFDataMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weathertunerfi_tclMsgGetCCFDataMethodResult::weathertunerfi_tclMsgGetCCFDataMethodResult(const weathertunerfi_tclMsgGetCCFDataMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   CCFBlockId = coRef.CCFBlockId;
   GenerationTime = coRef.GenerationTime;
   CCFData = coRef.CCFData;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weathertunerfi_tclMsgGetCCFDataMethodResult& weathertunerfi_tclMsgGetCCFDataMethodResult::operator=(const weathertunerfi_tclMsgGetCCFDataMethodResult& coRef)
{
   if (this == &coRef) return *this;
   CCFBlockId = coRef.CCFBlockId;
   GenerationTime = coRef.GenerationTime;
   CCFData = coRef.CCFData;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weathertunerfi_tclMsgGetCCFDataMethodResult::u16GetServiceID() const {return WEATHERTUNERFI_C_U16_SERVICE_ID;}
tU16 weathertunerfi_tclMsgGetCCFDataMethodResult::u16GetFunctionID() const {return WEATHERTUNERFI_C_U16_GETCCFDATA;}
tU8 weathertunerfi_tclMsgGetCCFDataMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid weathertunerfi_tclMsgGetCCFDataMethodResult::vDestroy()
{
   GenerationTime.vDestroy(); 
   CCFData.clear();
}

tU32 weathertunerfi_tclMsgGetCCFDataMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 12+CCFData.size()*1;
}

tBool weathertunerfi_tclMsgGetCCFDataMethodResult::operator==(const weathertunerfi_tclMsgGetCCFDataMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (CCFBlockId == rfoCmp.CCFBlockId);
      bResult = bResult && (GenerationTime == rfoCmp.GenerationTime);
      bResult = bResult && (CCFData.size() == rfoCmp.CCFData.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < CCFData.size()); ++u32Idx)
            bResult = bResult && (CCFData[u32Idx] == rfoCmp.CCFData[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& weathertunerfi_tclMsgGetCCFDataMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> CCFBlockId;
   oIn >> GenerationTime;
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      CCFData.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> CCFData[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& weathertunerfi_tclMsgGetCCFDataMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << CCFBlockId;
   oOut << GenerationTime;
   oOut << (tU32)CCFData.size();
   {
      for (tU32 u32Idx = 0; u32Idx < CCFData.size(); ++u32Idx)
         oOut << CCFData[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weathertunerfi_tclMsgMetarDataChangedGet::weathertunerfi_tclMsgMetarDataChangedGet(const weathertunerfi_tclMsgMetarDataChangedGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weathertunerfi_tclMsgMetarDataChangedGet& weathertunerfi_tclMsgMetarDataChangedGet::operator=(const weathertunerfi_tclMsgMetarDataChangedGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weathertunerfi_tclMsgMetarDataChangedGet::u16GetServiceID() const {return WEATHERTUNERFI_C_U16_SERVICE_ID;}
tU16 weathertunerfi_tclMsgMetarDataChangedGet::u16GetFunctionID() const {return WEATHERTUNERFI_C_U16_METARDATACHANGED;}
tU8 weathertunerfi_tclMsgMetarDataChangedGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 weathertunerfi_tclMsgMetarDataChangedGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weathertunerfi_tclMsgMetarDataChangedGet::operator==(const weathertunerfi_tclMsgMetarDataChangedGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weathertunerfi_tclMsgMetarDataChangedGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weathertunerfi_tclMsgMetarDataChangedGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weathertunerfi_tclMsgMetarDataChangedUpReg::weathertunerfi_tclMsgMetarDataChangedUpReg(const weathertunerfi_tclMsgMetarDataChangedUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weathertunerfi_tclMsgMetarDataChangedUpReg& weathertunerfi_tclMsgMetarDataChangedUpReg::operator=(const weathertunerfi_tclMsgMetarDataChangedUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weathertunerfi_tclMsgMetarDataChangedUpReg::u16GetServiceID() const {return WEATHERTUNERFI_C_U16_SERVICE_ID;}
tU16 weathertunerfi_tclMsgMetarDataChangedUpReg::u16GetFunctionID() const {return WEATHERTUNERFI_C_U16_METARDATACHANGED;}
tU8 weathertunerfi_tclMsgMetarDataChangedUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 weathertunerfi_tclMsgMetarDataChangedUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weathertunerfi_tclMsgMetarDataChangedUpReg::operator==(const weathertunerfi_tclMsgMetarDataChangedUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weathertunerfi_tclMsgMetarDataChangedUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weathertunerfi_tclMsgMetarDataChangedUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weathertunerfi_tclMsgMetarDataChangedRelUpReg::weathertunerfi_tclMsgMetarDataChangedRelUpReg(const weathertunerfi_tclMsgMetarDataChangedRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weathertunerfi_tclMsgMetarDataChangedRelUpReg& weathertunerfi_tclMsgMetarDataChangedRelUpReg::operator=(const weathertunerfi_tclMsgMetarDataChangedRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weathertunerfi_tclMsgMetarDataChangedRelUpReg::u16GetServiceID() const {return WEATHERTUNERFI_C_U16_SERVICE_ID;}
tU16 weathertunerfi_tclMsgMetarDataChangedRelUpReg::u16GetFunctionID() const {return WEATHERTUNERFI_C_U16_METARDATACHANGED;}
tU8 weathertunerfi_tclMsgMetarDataChangedRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 weathertunerfi_tclMsgMetarDataChangedRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weathertunerfi_tclMsgMetarDataChangedRelUpReg::operator==(const weathertunerfi_tclMsgMetarDataChangedRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weathertunerfi_tclMsgMetarDataChangedRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weathertunerfi_tclMsgMetarDataChangedRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weathertunerfi_tclMsgMetarDataChangedStatus::weathertunerfi_tclMsgMetarDataChangedStatus(const weathertunerfi_tclMsgMetarDataChangedStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   MetarBlockId = coRef.MetarBlockId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weathertunerfi_tclMsgMetarDataChangedStatus& weathertunerfi_tclMsgMetarDataChangedStatus::operator=(const weathertunerfi_tclMsgMetarDataChangedStatus& coRef)
{
   if (this == &coRef) return *this;
   MetarBlockId = coRef.MetarBlockId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weathertunerfi_tclMsgMetarDataChangedStatus::u16GetServiceID() const {return WEATHERTUNERFI_C_U16_SERVICE_ID;}
tU16 weathertunerfi_tclMsgMetarDataChangedStatus::u16GetFunctionID() const {return WEATHERTUNERFI_C_U16_METARDATACHANGED;}
tU8 weathertunerfi_tclMsgMetarDataChangedStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 weathertunerfi_tclMsgMetarDataChangedStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool weathertunerfi_tclMsgMetarDataChangedStatus::operator==(const weathertunerfi_tclMsgMetarDataChangedStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (MetarBlockId == rfoCmp.MetarBlockId);
   return bResult;
}

fi_tclInContext& weathertunerfi_tclMsgMetarDataChangedStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> MetarBlockId;
   return oIn;
}

fi_tclOutContext& weathertunerfi_tclMsgMetarDataChangedStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << MetarBlockId;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weathertunerfi_tclMsgCCFDataChangedGet::weathertunerfi_tclMsgCCFDataChangedGet(const weathertunerfi_tclMsgCCFDataChangedGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weathertunerfi_tclMsgCCFDataChangedGet& weathertunerfi_tclMsgCCFDataChangedGet::operator=(const weathertunerfi_tclMsgCCFDataChangedGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weathertunerfi_tclMsgCCFDataChangedGet::u16GetServiceID() const {return WEATHERTUNERFI_C_U16_SERVICE_ID;}
tU16 weathertunerfi_tclMsgCCFDataChangedGet::u16GetFunctionID() const {return WEATHERTUNERFI_C_U16_CCFDATACHANGED;}
tU8 weathertunerfi_tclMsgCCFDataChangedGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 weathertunerfi_tclMsgCCFDataChangedGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weathertunerfi_tclMsgCCFDataChangedGet::operator==(const weathertunerfi_tclMsgCCFDataChangedGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weathertunerfi_tclMsgCCFDataChangedGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weathertunerfi_tclMsgCCFDataChangedGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weathertunerfi_tclMsgCCFDataChangedUpReg::weathertunerfi_tclMsgCCFDataChangedUpReg(const weathertunerfi_tclMsgCCFDataChangedUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weathertunerfi_tclMsgCCFDataChangedUpReg& weathertunerfi_tclMsgCCFDataChangedUpReg::operator=(const weathertunerfi_tclMsgCCFDataChangedUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weathertunerfi_tclMsgCCFDataChangedUpReg::u16GetServiceID() const {return WEATHERTUNERFI_C_U16_SERVICE_ID;}
tU16 weathertunerfi_tclMsgCCFDataChangedUpReg::u16GetFunctionID() const {return WEATHERTUNERFI_C_U16_CCFDATACHANGED;}
tU8 weathertunerfi_tclMsgCCFDataChangedUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 weathertunerfi_tclMsgCCFDataChangedUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weathertunerfi_tclMsgCCFDataChangedUpReg::operator==(const weathertunerfi_tclMsgCCFDataChangedUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weathertunerfi_tclMsgCCFDataChangedUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weathertunerfi_tclMsgCCFDataChangedUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weathertunerfi_tclMsgCCFDataChangedRelUpReg::weathertunerfi_tclMsgCCFDataChangedRelUpReg(const weathertunerfi_tclMsgCCFDataChangedRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weathertunerfi_tclMsgCCFDataChangedRelUpReg& weathertunerfi_tclMsgCCFDataChangedRelUpReg::operator=(const weathertunerfi_tclMsgCCFDataChangedRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weathertunerfi_tclMsgCCFDataChangedRelUpReg::u16GetServiceID() const {return WEATHERTUNERFI_C_U16_SERVICE_ID;}
tU16 weathertunerfi_tclMsgCCFDataChangedRelUpReg::u16GetFunctionID() const {return WEATHERTUNERFI_C_U16_CCFDATACHANGED;}
tU8 weathertunerfi_tclMsgCCFDataChangedRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 weathertunerfi_tclMsgCCFDataChangedRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weathertunerfi_tclMsgCCFDataChangedRelUpReg::operator==(const weathertunerfi_tclMsgCCFDataChangedRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weathertunerfi_tclMsgCCFDataChangedRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weathertunerfi_tclMsgCCFDataChangedRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weathertunerfi_tclMsgCCFDataChangedStatus::weathertunerfi_tclMsgCCFDataChangedStatus(const weathertunerfi_tclMsgCCFDataChangedStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   CCFBlockId = coRef.CCFBlockId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weathertunerfi_tclMsgCCFDataChangedStatus& weathertunerfi_tclMsgCCFDataChangedStatus::operator=(const weathertunerfi_tclMsgCCFDataChangedStatus& coRef)
{
   if (this == &coRef) return *this;
   CCFBlockId = coRef.CCFBlockId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weathertunerfi_tclMsgCCFDataChangedStatus::u16GetServiceID() const {return WEATHERTUNERFI_C_U16_SERVICE_ID;}
tU16 weathertunerfi_tclMsgCCFDataChangedStatus::u16GetFunctionID() const {return WEATHERTUNERFI_C_U16_CCFDATACHANGED;}
tU8 weathertunerfi_tclMsgCCFDataChangedStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 weathertunerfi_tclMsgCCFDataChangedStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool weathertunerfi_tclMsgCCFDataChangedStatus::operator==(const weathertunerfi_tclMsgCCFDataChangedStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (CCFBlockId == rfoCmp.CCFBlockId);
   return bResult;
}

fi_tclInContext& weathertunerfi_tclMsgCCFDataChangedStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> CCFBlockId;
   return oIn;
}

fi_tclOutContext& weathertunerfi_tclMsgCCFDataChangedStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << CCFBlockId;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weathertunerfi_tclMsgCountyWarningDataChangedGet::weathertunerfi_tclMsgCountyWarningDataChangedGet(const weathertunerfi_tclMsgCountyWarningDataChangedGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weathertunerfi_tclMsgCountyWarningDataChangedGet& weathertunerfi_tclMsgCountyWarningDataChangedGet::operator=(const weathertunerfi_tclMsgCountyWarningDataChangedGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weathertunerfi_tclMsgCountyWarningDataChangedGet::u16GetServiceID() const {return WEATHERTUNERFI_C_U16_SERVICE_ID;}
tU16 weathertunerfi_tclMsgCountyWarningDataChangedGet::u16GetFunctionID() const {return WEATHERTUNERFI_C_U16_COUNTYWARNINGDATACHANGED;}
tU8 weathertunerfi_tclMsgCountyWarningDataChangedGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 weathertunerfi_tclMsgCountyWarningDataChangedGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weathertunerfi_tclMsgCountyWarningDataChangedGet::operator==(const weathertunerfi_tclMsgCountyWarningDataChangedGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weathertunerfi_tclMsgCountyWarningDataChangedGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weathertunerfi_tclMsgCountyWarningDataChangedGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weathertunerfi_tclMsgCountyWarningDataChangedUpReg::weathertunerfi_tclMsgCountyWarningDataChangedUpReg(const weathertunerfi_tclMsgCountyWarningDataChangedUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weathertunerfi_tclMsgCountyWarningDataChangedUpReg& weathertunerfi_tclMsgCountyWarningDataChangedUpReg::operator=(const weathertunerfi_tclMsgCountyWarningDataChangedUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weathertunerfi_tclMsgCountyWarningDataChangedUpReg::u16GetServiceID() const {return WEATHERTUNERFI_C_U16_SERVICE_ID;}
tU16 weathertunerfi_tclMsgCountyWarningDataChangedUpReg::u16GetFunctionID() const {return WEATHERTUNERFI_C_U16_COUNTYWARNINGDATACHANGED;}
tU8 weathertunerfi_tclMsgCountyWarningDataChangedUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 weathertunerfi_tclMsgCountyWarningDataChangedUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weathertunerfi_tclMsgCountyWarningDataChangedUpReg::operator==(const weathertunerfi_tclMsgCountyWarningDataChangedUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weathertunerfi_tclMsgCountyWarningDataChangedUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weathertunerfi_tclMsgCountyWarningDataChangedUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weathertunerfi_tclMsgCountyWarningDataChangedRelUpReg::weathertunerfi_tclMsgCountyWarningDataChangedRelUpReg(const weathertunerfi_tclMsgCountyWarningDataChangedRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weathertunerfi_tclMsgCountyWarningDataChangedRelUpReg& weathertunerfi_tclMsgCountyWarningDataChangedRelUpReg::operator=(const weathertunerfi_tclMsgCountyWarningDataChangedRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weathertunerfi_tclMsgCountyWarningDataChangedRelUpReg::u16GetServiceID() const {return WEATHERTUNERFI_C_U16_SERVICE_ID;}
tU16 weathertunerfi_tclMsgCountyWarningDataChangedRelUpReg::u16GetFunctionID() const {return WEATHERTUNERFI_C_U16_COUNTYWARNINGDATACHANGED;}
tU8 weathertunerfi_tclMsgCountyWarningDataChangedRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 weathertunerfi_tclMsgCountyWarningDataChangedRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weathertunerfi_tclMsgCountyWarningDataChangedRelUpReg::operator==(const weathertunerfi_tclMsgCountyWarningDataChangedRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weathertunerfi_tclMsgCountyWarningDataChangedRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weathertunerfi_tclMsgCountyWarningDataChangedRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weathertunerfi_tclMsgCountyWarningDataChangedStatus::weathertunerfi_tclMsgCountyWarningDataChangedStatus(const weathertunerfi_tclMsgCountyWarningDataChangedStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   CountyWarningBlockId = coRef.CountyWarningBlockId;
   GenerationTime = coRef.GenerationTime;
   CountyWarningData = coRef.CountyWarningData;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weathertunerfi_tclMsgCountyWarningDataChangedStatus& weathertunerfi_tclMsgCountyWarningDataChangedStatus::operator=(const weathertunerfi_tclMsgCountyWarningDataChangedStatus& coRef)
{
   if (this == &coRef) return *this;
   CountyWarningBlockId = coRef.CountyWarningBlockId;
   GenerationTime = coRef.GenerationTime;
   CountyWarningData = coRef.CountyWarningData;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weathertunerfi_tclMsgCountyWarningDataChangedStatus::u16GetServiceID() const {return WEATHERTUNERFI_C_U16_SERVICE_ID;}
tU16 weathertunerfi_tclMsgCountyWarningDataChangedStatus::u16GetFunctionID() const {return WEATHERTUNERFI_C_U16_COUNTYWARNINGDATACHANGED;}
tU8 weathertunerfi_tclMsgCountyWarningDataChangedStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid weathertunerfi_tclMsgCountyWarningDataChangedStatus::vDestroy()
{
   GenerationTime.vDestroy(); 
   CountyWarningData.clear();
}

tU32 weathertunerfi_tclMsgCountyWarningDataChangedStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 12+CountyWarningData.size()*1;
}

tBool weathertunerfi_tclMsgCountyWarningDataChangedStatus::operator==(const weathertunerfi_tclMsgCountyWarningDataChangedStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (CountyWarningBlockId == rfoCmp.CountyWarningBlockId);
      bResult = bResult && (GenerationTime == rfoCmp.GenerationTime);
      bResult = bResult && (CountyWarningData.size() == rfoCmp.CountyWarningData.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < CountyWarningData.size()); ++u32Idx)
            bResult = bResult && (CountyWarningData[u32Idx] == rfoCmp.CountyWarningData[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& weathertunerfi_tclMsgCountyWarningDataChangedStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> CountyWarningBlockId;
   oIn >> GenerationTime;
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      CountyWarningData.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> CountyWarningData[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& weathertunerfi_tclMsgCountyWarningDataChangedStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << CountyWarningBlockId;
   oOut << GenerationTime;
   oOut << (tU32)CountyWarningData.size();
   {
      for (tU32 u32Idx = 0; u32Idx < CountyWarningData.size(); ++u32Idx)
         oOut << CountyWarningData[u32Idx];
   }
   return oOut;
}

