/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#include "precompiled.hh"
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGetCurrentWeatherDataMethodStart::weatherfi_tclMsgGetCurrentWeatherDataMethodStart(const weatherfi_tclMsgGetCurrentWeatherDataMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   PositionList = coRef.PositionList;
   MaxDistance = coRef.MaxDistance;
   MaxNumberOfStations = coRef.MaxNumberOfStations;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGetCurrentWeatherDataMethodStart& weatherfi_tclMsgGetCurrentWeatherDataMethodStart::operator=(const weatherfi_tclMsgGetCurrentWeatherDataMethodStart& coRef)
{
   if (this == &coRef) return *this;
   PositionList = coRef.PositionList;
   MaxDistance = coRef.MaxDistance;
   MaxNumberOfStations = coRef.MaxNumberOfStations;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgGetCurrentWeatherDataMethodStart::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgGetCurrentWeatherDataMethodStart::u16GetFunctionID() const {return WEATHERFI_C_U16_GETCURRENTWEATHERDATA;}
tU8 weatherfi_tclMsgGetCurrentWeatherDataMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid weatherfi_tclMsgGetCurrentWeatherDataMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < PositionList.size(); ++u32Idx)
         PositionList[u32Idx].vDestroy();
   }
   PositionList.clear();
}

tU32 weatherfi_tclMsgGetCurrentWeatherDataMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9+PositionList.size()*8;
}

tBool weatherfi_tclMsgGetCurrentWeatherDataMethodStart::operator==(const weatherfi_tclMsgGetCurrentWeatherDataMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (PositionList.size() == rfoCmp.PositionList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PositionList.size()); ++u32Idx)
            bResult = bResult && (PositionList[u32Idx] == rfoCmp.PositionList[u32Idx]);
      }
      bResult = bResult && (MaxDistance == rfoCmp.MaxDistance);
      bResult = bResult && (MaxNumberOfStations == rfoCmp.MaxNumberOfStations);
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgGetCurrentWeatherDataMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < PositionList.size(); ++u32Idx)
      {
         PositionList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      PositionList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> PositionList[u32Idx];
      }
   }
   oIn >> MaxDistance;
   oIn >> MaxNumberOfStations;
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgGetCurrentWeatherDataMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)PositionList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < PositionList.size(); ++u32Idx)
         oOut << PositionList[u32Idx];
   }
   oOut << MaxDistance;
   oOut << MaxNumberOfStations;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGetCurrentWeatherDataMethodResult::weatherfi_tclMsgGetCurrentWeatherDataMethodResult(const weatherfi_tclMsgGetCurrentWeatherDataMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   MetarBlockId = coRef.MetarBlockId;
   WeatherForPosition = coRef.WeatherForPosition;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGetCurrentWeatherDataMethodResult& weatherfi_tclMsgGetCurrentWeatherDataMethodResult::operator=(const weatherfi_tclMsgGetCurrentWeatherDataMethodResult& coRef)
{
   if (this == &coRef) return *this;
   MetarBlockId = coRef.MetarBlockId;
   WeatherForPosition = coRef.WeatherForPosition;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgGetCurrentWeatherDataMethodResult::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgGetCurrentWeatherDataMethodResult::u16GetFunctionID() const {return WEATHERFI_C_U16_GETCURRENTWEATHERDATA;}
tU8 weatherfi_tclMsgGetCurrentWeatherDataMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid weatherfi_tclMsgGetCurrentWeatherDataMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < WeatherForPosition.size(); ++u32Idx)
         WeatherForPosition[u32Idx].vDestroy();
   }
   WeatherForPosition.clear();
}

tU32 weatherfi_tclMsgGetCurrentWeatherDataMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < WeatherForPosition.size(); ++u32ListIdx)
      u32DynamicSize += WeatherForPosition[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8;
}

tBool weatherfi_tclMsgGetCurrentWeatherDataMethodResult::operator==(const weatherfi_tclMsgGetCurrentWeatherDataMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (MetarBlockId == rfoCmp.MetarBlockId);
      bResult = bResult && (WeatherForPosition.size() == rfoCmp.WeatherForPosition.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < WeatherForPosition.size()); ++u32Idx)
            bResult = bResult && (WeatherForPosition[u32Idx] == rfoCmp.WeatherForPosition[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgGetCurrentWeatherDataMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> MetarBlockId;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < WeatherForPosition.size(); ++u32Idx)
      {
         WeatherForPosition[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      WeatherForPosition.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> WeatherForPosition[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgGetCurrentWeatherDataMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << MetarBlockId;
   oOut << (tU32)WeatherForPosition.size();
   {
      for (tU32 u32Idx = 0; u32Idx < WeatherForPosition.size(); ++u32Idx)
         oOut << WeatherForPosition[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGetWeatherForecastDataMethodStart::weatherfi_tclMsgGetWeatherForecastDataMethodStart(const weatherfi_tclMsgGetWeatherForecastDataMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   PositionList = coRef.PositionList;
   MaxDistance = coRef.MaxDistance;
   MaxNumberOfCities = coRef.MaxNumberOfCities;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGetWeatherForecastDataMethodStart& weatherfi_tclMsgGetWeatherForecastDataMethodStart::operator=(const weatherfi_tclMsgGetWeatherForecastDataMethodStart& coRef)
{
   if (this == &coRef) return *this;
   PositionList = coRef.PositionList;
   MaxDistance = coRef.MaxDistance;
   MaxNumberOfCities = coRef.MaxNumberOfCities;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgGetWeatherForecastDataMethodStart::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgGetWeatherForecastDataMethodStart::u16GetFunctionID() const {return WEATHERFI_C_U16_GETWEATHERFORECASTDATA;}
tU8 weatherfi_tclMsgGetWeatherForecastDataMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid weatherfi_tclMsgGetWeatherForecastDataMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < PositionList.size(); ++u32Idx)
         PositionList[u32Idx].vDestroy();
   }
   PositionList.clear();
}

tU32 weatherfi_tclMsgGetWeatherForecastDataMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9+PositionList.size()*8;
}

tBool weatherfi_tclMsgGetWeatherForecastDataMethodStart::operator==(const weatherfi_tclMsgGetWeatherForecastDataMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (PositionList.size() == rfoCmp.PositionList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PositionList.size()); ++u32Idx)
            bResult = bResult && (PositionList[u32Idx] == rfoCmp.PositionList[u32Idx]);
      }
      bResult = bResult && (MaxDistance == rfoCmp.MaxDistance);
      bResult = bResult && (MaxNumberOfCities == rfoCmp.MaxNumberOfCities);
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgGetWeatherForecastDataMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < PositionList.size(); ++u32Idx)
      {
         PositionList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      PositionList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> PositionList[u32Idx];
      }
   }
   oIn >> MaxDistance;
   oIn >> MaxNumberOfCities;
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgGetWeatherForecastDataMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)PositionList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < PositionList.size(); ++u32Idx)
         oOut << PositionList[u32Idx];
   }
   oOut << MaxDistance;
   oOut << MaxNumberOfCities;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGetWeatherForecastDataMethodResult::weatherfi_tclMsgGetWeatherForecastDataMethodResult(const weatherfi_tclMsgGetWeatherForecastDataMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   CCFBlockId = coRef.CCFBlockId;
   WeatherForecastsForPosition = coRef.WeatherForecastsForPosition;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGetWeatherForecastDataMethodResult& weatherfi_tclMsgGetWeatherForecastDataMethodResult::operator=(const weatherfi_tclMsgGetWeatherForecastDataMethodResult& coRef)
{
   if (this == &coRef) return *this;
   CCFBlockId = coRef.CCFBlockId;
   WeatherForecastsForPosition = coRef.WeatherForecastsForPosition;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgGetWeatherForecastDataMethodResult::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgGetWeatherForecastDataMethodResult::u16GetFunctionID() const {return WEATHERFI_C_U16_GETWEATHERFORECASTDATA;}
tU8 weatherfi_tclMsgGetWeatherForecastDataMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid weatherfi_tclMsgGetWeatherForecastDataMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < WeatherForecastsForPosition.size(); ++u32Idx)
         WeatherForecastsForPosition[u32Idx].vDestroy();
   }
   WeatherForecastsForPosition.clear();
}

tU32 weatherfi_tclMsgGetWeatherForecastDataMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < WeatherForecastsForPosition.size(); ++u32ListIdx)
      u32DynamicSize += WeatherForecastsForPosition[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8;
}

tBool weatherfi_tclMsgGetWeatherForecastDataMethodResult::operator==(const weatherfi_tclMsgGetWeatherForecastDataMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (CCFBlockId == rfoCmp.CCFBlockId);
      bResult = bResult && (WeatherForecastsForPosition.size() == rfoCmp.WeatherForecastsForPosition.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < WeatherForecastsForPosition.size()); ++u32Idx)
            bResult = bResult && (WeatherForecastsForPosition[u32Idx] == rfoCmp.WeatherForecastsForPosition[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgGetWeatherForecastDataMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> CCFBlockId;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < WeatherForecastsForPosition.size(); ++u32Idx)
      {
         WeatherForecastsForPosition[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      WeatherForecastsForPosition.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> WeatherForecastsForPosition[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgGetWeatherForecastDataMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << CCFBlockId;
   oOut << (tU32)WeatherForecastsForPosition.size();
   {
      for (tU32 u32Idx = 0; u32Idx < WeatherForecastsForPosition.size(); ++u32Idx)
         oOut << WeatherForecastsForPosition[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGetCountyWarningDataMethodStart::weatherfi_tclMsgGetCountyWarningDataMethodStart(const weatherfi_tclMsgGetCountyWarningDataMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   Position = coRef.Position;
   MaxDistance = coRef.MaxDistance;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGetCountyWarningDataMethodStart& weatherfi_tclMsgGetCountyWarningDataMethodStart::operator=(const weatherfi_tclMsgGetCountyWarningDataMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Position = coRef.Position;
   MaxDistance = coRef.MaxDistance;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgGetCountyWarningDataMethodStart::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgGetCountyWarningDataMethodStart::u16GetFunctionID() const {return WEATHERFI_C_U16_GETCOUNTYWARNINGDATA;}
tU8 weatherfi_tclMsgGetCountyWarningDataMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid weatherfi_tclMsgGetCountyWarningDataMethodStart::vDestroy()
{
   Position.vDestroy(); 
}

tU32 weatherfi_tclMsgGetCountyWarningDataMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 12;
}

tBool weatherfi_tclMsgGetCountyWarningDataMethodStart::operator==(const weatherfi_tclMsgGetCountyWarningDataMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Position == rfoCmp.Position);
      bResult = bResult && (MaxDistance == rfoCmp.MaxDistance);
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgGetCountyWarningDataMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> Position;
   oIn >> MaxDistance;
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgGetCountyWarningDataMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Position;
   oOut << MaxDistance;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGetCountyWarningDataMethodResult::weatherfi_tclMsgGetCountyWarningDataMethodResult(const weatherfi_tclMsgGetCountyWarningDataMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   CountyWarningId = coRef.CountyWarningId;
   CountyWarningSubId = coRef.CountyWarningSubId;
   CountyWarnings = coRef.CountyWarnings;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGetCountyWarningDataMethodResult& weatherfi_tclMsgGetCountyWarningDataMethodResult::operator=(const weatherfi_tclMsgGetCountyWarningDataMethodResult& coRef)
{
   if (this == &coRef) return *this;
   CountyWarningId = coRef.CountyWarningId;
   CountyWarningSubId = coRef.CountyWarningSubId;
   CountyWarnings = coRef.CountyWarnings;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgGetCountyWarningDataMethodResult::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgGetCountyWarningDataMethodResult::u16GetFunctionID() const {return WEATHERFI_C_U16_GETCOUNTYWARNINGDATA;}
tU8 weatherfi_tclMsgGetCountyWarningDataMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid weatherfi_tclMsgGetCountyWarningDataMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < CountyWarnings.size(); ++u32Idx)
         CountyWarnings[u32Idx].vDestroy();
   }
   CountyWarnings.clear();
}

tU32 weatherfi_tclMsgGetCountyWarningDataMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (2 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < CountyWarnings.size(); ++u32ListIdx)
      u32DynamicSize += CountyWarnings[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8;
}

tBool weatherfi_tclMsgGetCountyWarningDataMethodResult::operator==(const weatherfi_tclMsgGetCountyWarningDataMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (CountyWarningId == rfoCmp.CountyWarningId);
      bResult = bResult && (CountyWarningSubId == rfoCmp.CountyWarningSubId);
      bResult = bResult && (CountyWarnings.size() == rfoCmp.CountyWarnings.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < CountyWarnings.size()); ++u32Idx)
            bResult = bResult && (CountyWarnings[u32Idx] == rfoCmp.CountyWarnings[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgGetCountyWarningDataMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> CountyWarningId;
   if (2 <= oIn.u16GetMajorVersion())
   {
      oIn >> CountyWarningSubId;
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < CountyWarnings.size(); ++u32Idx)
      {
         CountyWarnings[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      CountyWarnings.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> CountyWarnings[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgGetCountyWarningDataMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << CountyWarningId;
   if (2 <= oOut.u16GetMajorVersion())
   {
      oOut << CountyWarningSubId;
   }
   oOut << (tU32)CountyWarnings.size();
   {
      for (tU32 u32Idx = 0; u32Idx < CountyWarnings.size(); ++u32Idx)
         oOut << CountyWarnings[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGetForecastCityListMethodStart::weatherfi_tclMsgGetForecastCityListMethodStart(const weatherfi_tclMsgGetForecastCityListMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGetForecastCityListMethodStart& weatherfi_tclMsgGetForecastCityListMethodStart::operator=(const weatherfi_tclMsgGetForecastCityListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgGetForecastCityListMethodStart::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgGetForecastCityListMethodStart::u16GetFunctionID() const {return WEATHERFI_C_U16_GETFORECASTCITYLIST;}
tU8 weatherfi_tclMsgGetForecastCityListMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 weatherfi_tclMsgGetForecastCityListMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weatherfi_tclMsgGetForecastCityListMethodStart::operator==(const weatherfi_tclMsgGetForecastCityListMethodStart& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgGetForecastCityListMethodStart::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgGetForecastCityListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGetForecastCityListMethodResult::weatherfi_tclMsgGetForecastCityListMethodResult(const weatherfi_tclMsgGetForecastCityListMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   ForecastCities = coRef.ForecastCities;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGetForecastCityListMethodResult& weatherfi_tclMsgGetForecastCityListMethodResult::operator=(const weatherfi_tclMsgGetForecastCityListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ForecastCities = coRef.ForecastCities;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgGetForecastCityListMethodResult::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgGetForecastCityListMethodResult::u16GetFunctionID() const {return WEATHERFI_C_U16_GETFORECASTCITYLIST;}
tU8 weatherfi_tclMsgGetForecastCityListMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid weatherfi_tclMsgGetForecastCityListMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ForecastCities.size(); ++u32Idx)
         ForecastCities[u32Idx].vDestroy();
   }
   ForecastCities.clear();
}

tU32 weatherfi_tclMsgGetForecastCityListMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < ForecastCities.size(); ++u32ListIdx)
      u32DynamicSize += ForecastCities[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool weatherfi_tclMsgGetForecastCityListMethodResult::operator==(const weatherfi_tclMsgGetForecastCityListMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ForecastCities.size() == rfoCmp.ForecastCities.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ForecastCities.size()); ++u32Idx)
            bResult = bResult && (ForecastCities[u32Idx] == rfoCmp.ForecastCities[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgGetForecastCityListMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ForecastCities.size(); ++u32Idx)
      {
         ForecastCities[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ForecastCities.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ForecastCities[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgGetForecastCityListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)ForecastCities.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ForecastCities.size(); ++u32Idx)
         oOut << ForecastCities[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGetForecastForCityMethodStart::weatherfi_tclMsgGetForecastForCityMethodStart(const weatherfi_tclMsgGetForecastForCityMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   CityCode = coRef.CityCode;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGetForecastForCityMethodStart& weatherfi_tclMsgGetForecastForCityMethodStart::operator=(const weatherfi_tclMsgGetForecastForCityMethodStart& coRef)
{
   if (this == &coRef) return *this;
   CityCode = coRef.CityCode;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgGetForecastForCityMethodStart::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgGetForecastForCityMethodStart::u16GetFunctionID() const {return WEATHERFI_C_U16_GETFORECASTFORCITY;}
tU8 weatherfi_tclMsgGetForecastForCityMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 weatherfi_tclMsgGetForecastForCityMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool weatherfi_tclMsgGetForecastForCityMethodStart::operator==(const weatherfi_tclMsgGetForecastForCityMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (CityCode == rfoCmp.CityCode);
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgGetForecastForCityMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> CityCode;
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgGetForecastForCityMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << CityCode;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGetForecastForCityMethodResult::weatherfi_tclMsgGetForecastForCityMethodResult(const weatherfi_tclMsgGetForecastForCityMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   WeatherForecastId = coRef.WeatherForecastId;
   WeatherForecast = coRef.WeatherForecast;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGetForecastForCityMethodResult& weatherfi_tclMsgGetForecastForCityMethodResult::operator=(const weatherfi_tclMsgGetForecastForCityMethodResult& coRef)
{
   if (this == &coRef) return *this;
   WeatherForecastId = coRef.WeatherForecastId;
   WeatherForecast = coRef.WeatherForecast;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgGetForecastForCityMethodResult::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgGetForecastForCityMethodResult::u16GetFunctionID() const {return WEATHERFI_C_U16_GETFORECASTFORCITY;}
tU8 weatherfi_tclMsgGetForecastForCityMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid weatherfi_tclMsgGetForecastForCityMethodResult::vDestroy()
{
   WeatherForecast.vDestroy(); 
}

tU32 weatherfi_tclMsgGetForecastForCityMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+WeatherForecast.u32GetSize(u16MajorVersion);
}

tBool weatherfi_tclMsgGetForecastForCityMethodResult::operator==(const weatherfi_tclMsgGetForecastForCityMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (WeatherForecastId == rfoCmp.WeatherForecastId);
      bResult = bResult && (WeatherForecast == rfoCmp.WeatherForecast);
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgGetForecastForCityMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> WeatherForecastId;
   oIn >> WeatherForecast;
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgGetForecastForCityMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << WeatherForecastId;
   oOut << WeatherForecast;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGetTabularWeatherDataMethodStart::weatherfi_tclMsgGetTabularWeatherDataMethodStart(const weatherfi_tclMsgGetTabularWeatherDataMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   PositionList = coRef.PositionList;
   MaxDistance = coRef.MaxDistance;
   MaxNumber = coRef.MaxNumber;
   ForecastType = coRef.ForecastType;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGetTabularWeatherDataMethodStart& weatherfi_tclMsgGetTabularWeatherDataMethodStart::operator=(const weatherfi_tclMsgGetTabularWeatherDataMethodStart& coRef)
{
   if (this == &coRef) return *this;
   PositionList = coRef.PositionList;
   MaxDistance = coRef.MaxDistance;
   MaxNumber = coRef.MaxNumber;
   ForecastType = coRef.ForecastType;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgGetTabularWeatherDataMethodStart::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgGetTabularWeatherDataMethodStart::u16GetFunctionID() const {return WEATHERFI_C_U16_GETTABULARWEATHERDATA;}
tU8 weatherfi_tclMsgGetTabularWeatherDataMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid weatherfi_tclMsgGetTabularWeatherDataMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < PositionList.size(); ++u32Idx)
         PositionList[u32Idx].vDestroy();
   }
   PositionList.clear();
}

tU32 weatherfi_tclMsgGetTabularWeatherDataMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 11+PositionList.size()*8;
}

tBool weatherfi_tclMsgGetTabularWeatherDataMethodStart::operator==(const weatherfi_tclMsgGetTabularWeatherDataMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (PositionList.size() == rfoCmp.PositionList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PositionList.size()); ++u32Idx)
            bResult = bResult && (PositionList[u32Idx] == rfoCmp.PositionList[u32Idx]);
      }
      bResult = bResult && (MaxDistance == rfoCmp.MaxDistance);
      bResult = bResult && (MaxNumber == rfoCmp.MaxNumber);
      bResult = bResult && (ForecastType == rfoCmp.ForecastType);
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgGetTabularWeatherDataMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < PositionList.size(); ++u32Idx)
      {
         PositionList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      PositionList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> PositionList[u32Idx];
      }
   }
   oIn >> MaxDistance;
   oIn >> MaxNumber;
   oIn >> ForecastType;
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgGetTabularWeatherDataMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)PositionList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < PositionList.size(); ++u32Idx)
         oOut << PositionList[u32Idx];
   }
   oOut << MaxDistance;
   oOut << MaxNumber;
   oOut << ForecastType;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGetTabularWeatherDataMethodResult::weatherfi_tclMsgGetTabularWeatherDataMethodResult(const weatherfi_tclMsgGetTabularWeatherDataMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   VersionsForForecasts = coRef.VersionsForForecasts;
   TabularWeatherForPosition = coRef.TabularWeatherForPosition;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGetTabularWeatherDataMethodResult& weatherfi_tclMsgGetTabularWeatherDataMethodResult::operator=(const weatherfi_tclMsgGetTabularWeatherDataMethodResult& coRef)
{
   if (this == &coRef) return *this;
   VersionsForForecasts = coRef.VersionsForForecasts;
   TabularWeatherForPosition = coRef.TabularWeatherForPosition;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgGetTabularWeatherDataMethodResult::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgGetTabularWeatherDataMethodResult::u16GetFunctionID() const {return WEATHERFI_C_U16_GETTABULARWEATHERDATA;}
tU8 weatherfi_tclMsgGetTabularWeatherDataMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid weatherfi_tclMsgGetTabularWeatherDataMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < VersionsForForecasts.size(); ++u32Idx)
         VersionsForForecasts[u32Idx].vDestroy();
   }
   VersionsForForecasts.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < TabularWeatherForPosition.size(); ++u32Idx)
         TabularWeatherForPosition[u32Idx].vDestroy();
   }
   TabularWeatherForPosition.clear();
}

tU32 weatherfi_tclMsgGetTabularWeatherDataMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < TabularWeatherForPosition.size(); ++u32ListIdx)
      u32DynamicSize += TabularWeatherForPosition[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8+VersionsForForecasts.size()*5;
}

tBool weatherfi_tclMsgGetTabularWeatherDataMethodResult::operator==(const weatherfi_tclMsgGetTabularWeatherDataMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (VersionsForForecasts.size() == rfoCmp.VersionsForForecasts.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < VersionsForForecasts.size()); ++u32Idx)
            bResult = bResult && (VersionsForForecasts[u32Idx] == rfoCmp.VersionsForForecasts[u32Idx]);
      }
      bResult = bResult && (TabularWeatherForPosition.size() == rfoCmp.TabularWeatherForPosition.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TabularWeatherForPosition.size()); ++u32Idx)
            bResult = bResult && (TabularWeatherForPosition[u32Idx] == rfoCmp.TabularWeatherForPosition[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgGetTabularWeatherDataMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < VersionsForForecasts.size(); ++u32Idx)
      {
         VersionsForForecasts[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      VersionsForForecasts.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> VersionsForForecasts[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TabularWeatherForPosition.size(); ++u32Idx)
      {
         TabularWeatherForPosition[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      TabularWeatherForPosition.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> TabularWeatherForPosition[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgGetTabularWeatherDataMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)VersionsForForecasts.size();
   {
      for (tU32 u32Idx = 0; u32Idx < VersionsForForecasts.size(); ++u32Idx)
         oOut << VersionsForForecasts[u32Idx];
   }
   oOut << (tU32)TabularWeatherForPosition.size();
   {
      for (tU32 u32Idx = 0; u32Idx < TabularWeatherForPosition.size(); ++u32Idx)
         oOut << TabularWeatherForPosition[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGetTabularWeatherSkiConditionDataMethodStart::weatherfi_tclMsgGetTabularWeatherSkiConditionDataMethodStart(const weatherfi_tclMsgGetTabularWeatherSkiConditionDataMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   PositionList = coRef.PositionList;
   MaxDistance = coRef.MaxDistance;
   MaxNumber = coRef.MaxNumber;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGetTabularWeatherSkiConditionDataMethodStart& weatherfi_tclMsgGetTabularWeatherSkiConditionDataMethodStart::operator=(const weatherfi_tclMsgGetTabularWeatherSkiConditionDataMethodStart& coRef)
{
   if (this == &coRef) return *this;
   PositionList = coRef.PositionList;
   MaxDistance = coRef.MaxDistance;
   MaxNumber = coRef.MaxNumber;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgGetTabularWeatherSkiConditionDataMethodStart::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgGetTabularWeatherSkiConditionDataMethodStart::u16GetFunctionID() const {return WEATHERFI_C_U16_GETTABULARWEATHERSKICONDITIONDATA;}
tU8 weatherfi_tclMsgGetTabularWeatherSkiConditionDataMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid weatherfi_tclMsgGetTabularWeatherSkiConditionDataMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < PositionList.size(); ++u32Idx)
         PositionList[u32Idx].vDestroy();
   }
   PositionList.clear();
}

tU32 weatherfi_tclMsgGetTabularWeatherSkiConditionDataMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9+PositionList.size()*8;
}

tBool weatherfi_tclMsgGetTabularWeatherSkiConditionDataMethodStart::operator==(const weatherfi_tclMsgGetTabularWeatherSkiConditionDataMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (PositionList.size() == rfoCmp.PositionList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PositionList.size()); ++u32Idx)
            bResult = bResult && (PositionList[u32Idx] == rfoCmp.PositionList[u32Idx]);
      }
      bResult = bResult && (MaxDistance == rfoCmp.MaxDistance);
      bResult = bResult && (MaxNumber == rfoCmp.MaxNumber);
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgGetTabularWeatherSkiConditionDataMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < PositionList.size(); ++u32Idx)
      {
         PositionList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      PositionList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> PositionList[u32Idx];
      }
   }
   oIn >> MaxDistance;
   oIn >> MaxNumber;
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgGetTabularWeatherSkiConditionDataMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)PositionList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < PositionList.size(); ++u32Idx)
         oOut << PositionList[u32Idx];
   }
   oOut << MaxDistance;
   oOut << MaxNumber;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGetTabularWeatherSkiConditionDataMethodResult::weatherfi_tclMsgGetTabularWeatherSkiConditionDataMethodResult(const weatherfi_tclMsgGetTabularWeatherSkiConditionDataMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   TabularWeatherSkiConditionVersionId = coRef.TabularWeatherSkiConditionVersionId;
   SkiConditionForPosition = coRef.SkiConditionForPosition;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGetTabularWeatherSkiConditionDataMethodResult& weatherfi_tclMsgGetTabularWeatherSkiConditionDataMethodResult::operator=(const weatherfi_tclMsgGetTabularWeatherSkiConditionDataMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TabularWeatherSkiConditionVersionId = coRef.TabularWeatherSkiConditionVersionId;
   SkiConditionForPosition = coRef.SkiConditionForPosition;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgGetTabularWeatherSkiConditionDataMethodResult::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgGetTabularWeatherSkiConditionDataMethodResult::u16GetFunctionID() const {return WEATHERFI_C_U16_GETTABULARWEATHERSKICONDITIONDATA;}
tU8 weatherfi_tclMsgGetTabularWeatherSkiConditionDataMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid weatherfi_tclMsgGetTabularWeatherSkiConditionDataMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < SkiConditionForPosition.size(); ++u32Idx)
         SkiConditionForPosition[u32Idx].vDestroy();
   }
   SkiConditionForPosition.clear();
}

tU32 weatherfi_tclMsgGetTabularWeatherSkiConditionDataMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < SkiConditionForPosition.size(); ++u32ListIdx)
      u32DynamicSize += SkiConditionForPosition[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8;
}

tBool weatherfi_tclMsgGetTabularWeatherSkiConditionDataMethodResult::operator==(const weatherfi_tclMsgGetTabularWeatherSkiConditionDataMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TabularWeatherSkiConditionVersionId == rfoCmp.TabularWeatherSkiConditionVersionId);
      bResult = bResult && (SkiConditionForPosition.size() == rfoCmp.SkiConditionForPosition.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SkiConditionForPosition.size()); ++u32Idx)
            bResult = bResult && (SkiConditionForPosition[u32Idx] == rfoCmp.SkiConditionForPosition[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgGetTabularWeatherSkiConditionDataMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> TabularWeatherSkiConditionVersionId;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < SkiConditionForPosition.size(); ++u32Idx)
      {
         SkiConditionForPosition[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      SkiConditionForPosition.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> SkiConditionForPosition[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgGetTabularWeatherSkiConditionDataMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TabularWeatherSkiConditionVersionId;
   oOut << (tU32)SkiConditionForPosition.size();
   {
      for (tU32 u32Idx = 0; u32Idx < SkiConditionForPosition.size(); ++u32Idx)
         oOut << SkiConditionForPosition[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGetWeatherAlertDataMethodStart::weatherfi_tclMsgGetWeatherAlertDataMethodStart(const weatherfi_tclMsgGetWeatherAlertDataMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   PositionList = coRef.PositionList;
   MaxDistance = coRef.MaxDistance;
   MaxNumber = coRef.MaxNumber;
   StateFilter = coRef.StateFilter;
   StateZoneFilter = coRef.StateZoneFilter;
   TwelveHourTimePresentation = coRef.TwelveHourTimePresentation;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGetWeatherAlertDataMethodStart& weatherfi_tclMsgGetWeatherAlertDataMethodStart::operator=(const weatherfi_tclMsgGetWeatherAlertDataMethodStart& coRef)
{
   if (this == &coRef) return *this;
   PositionList = coRef.PositionList;
   MaxDistance = coRef.MaxDistance;
   MaxNumber = coRef.MaxNumber;
   StateFilter = coRef.StateFilter;
   StateZoneFilter = coRef.StateZoneFilter;
   TwelveHourTimePresentation = coRef.TwelveHourTimePresentation;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgGetWeatherAlertDataMethodStart::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgGetWeatherAlertDataMethodStart::u16GetFunctionID() const {return WEATHERFI_C_U16_GETWEATHERALERTDATA;}
tU8 weatherfi_tclMsgGetWeatherAlertDataMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid weatherfi_tclMsgGetWeatherAlertDataMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < PositionList.size(); ++u32Idx)
         PositionList[u32Idx].vDestroy();
   }
   PositionList.clear();
   StateFilter.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < StateZoneFilter.size(); ++u32Idx)
         StateZoneFilter[u32Idx].vDestroy();
   }
   StateZoneFilter.clear();
}

tU32 weatherfi_tclMsgGetWeatherAlertDataMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (u16MajorVersion <= 3)
   {
      u32DynamicSize += 4;
      u32DynamicSize += StateFilter.size()*4;
   }
   if (4 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
      u32DynamicSize += StateZoneFilter.size()*3;
   }
   return u32DynamicSize+10+PositionList.size()*8;
}

tBool weatherfi_tclMsgGetWeatherAlertDataMethodStart::operator==(const weatherfi_tclMsgGetWeatherAlertDataMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (PositionList.size() == rfoCmp.PositionList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PositionList.size()); ++u32Idx)
            bResult = bResult && (PositionList[u32Idx] == rfoCmp.PositionList[u32Idx]);
      }
      bResult = bResult && (MaxDistance == rfoCmp.MaxDistance);
      bResult = bResult && (MaxNumber == rfoCmp.MaxNumber);
      bResult = bResult && (StateFilter.size() == rfoCmp.StateFilter.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < StateFilter.size()); ++u32Idx)
            bResult = bResult && (StateFilter[u32Idx] == rfoCmp.StateFilter[u32Idx]);
      }
      bResult = bResult && (StateZoneFilter.size() == rfoCmp.StateZoneFilter.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < StateZoneFilter.size()); ++u32Idx)
            bResult = bResult && (StateZoneFilter[u32Idx] == rfoCmp.StateZoneFilter[u32Idx]);
      }
      bResult = bResult && (TwelveHourTimePresentation == rfoCmp.TwelveHourTimePresentation);
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgGetWeatherAlertDataMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < PositionList.size(); ++u32Idx)
      {
         PositionList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      PositionList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> PositionList[u32Idx];
      }
   }
   oIn >> MaxDistance;
   oIn >> MaxNumber;
   if (oIn.u16GetMajorVersion() <= 3)
   {
      {
         tU32 u32Length;
         tU32 u32Idx;
         oIn >> u32Length;
         StateFilter.resize(u32Length);
         for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
         {
            oIn >> StateFilter[u32Idx];
         }
      }
   }
   if (4 <= oIn.u16GetMajorVersion())
   {
      {
         tU32 u32Length;
         tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
         for (u32Idx = 0; u32Idx < StateZoneFilter.size(); ++u32Idx)
         {
            StateZoneFilter[u32Idx].vDestroy();
         }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
         oIn >> u32Length;
         StateZoneFilter.resize(u32Length);
         for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
         {
            oIn >> StateZoneFilter[u32Idx];
         }
      }
   }
   oIn >> TwelveHourTimePresentation;
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgGetWeatherAlertDataMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)PositionList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < PositionList.size(); ++u32Idx)
         oOut << PositionList[u32Idx];
   }
   oOut << MaxDistance;
   oOut << MaxNumber;
   if (oOut.u16GetMajorVersion() <= 3)
   {
      oOut << (tU32)StateFilter.size();
      {
         for (tU32 u32Idx = 0; u32Idx < StateFilter.size(); ++u32Idx)
            oOut << StateFilter[u32Idx];
      }
   }
   if (4 <= oOut.u16GetMajorVersion())
   {
      oOut << (tU32)StateZoneFilter.size();
      {
         for (tU32 u32Idx = 0; u32Idx < StateZoneFilter.size(); ++u32Idx)
            oOut << StateZoneFilter[u32Idx];
      }
   }
   oOut << TwelveHourTimePresentation;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGetWeatherAlertDataMethodResult::weatherfi_tclMsgGetWeatherAlertDataMethodResult(const weatherfi_tclMsgGetWeatherAlertDataMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   StatesAndVersionPerLanguage = coRef.StatesAndVersionPerLanguage;
   WeatherAlertsForPosition = coRef.WeatherAlertsForPosition;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGetWeatherAlertDataMethodResult& weatherfi_tclMsgGetWeatherAlertDataMethodResult::operator=(const weatherfi_tclMsgGetWeatherAlertDataMethodResult& coRef)
{
   if (this == &coRef) return *this;
   StatesAndVersionPerLanguage = coRef.StatesAndVersionPerLanguage;
   WeatherAlertsForPosition = coRef.WeatherAlertsForPosition;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgGetWeatherAlertDataMethodResult::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgGetWeatherAlertDataMethodResult::u16GetFunctionID() const {return WEATHERFI_C_U16_GETWEATHERALERTDATA;}
tU8 weatherfi_tclMsgGetWeatherAlertDataMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid weatherfi_tclMsgGetWeatherAlertDataMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < StatesAndVersionPerLanguage.size(); ++u32Idx)
         StatesAndVersionPerLanguage[u32Idx].vDestroy();
   }
   StatesAndVersionPerLanguage.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < WeatherAlertsForPosition.size(); ++u32Idx)
         WeatherAlertsForPosition[u32Idx].vDestroy();
   }
   WeatherAlertsForPosition.clear();
}

tU32 weatherfi_tclMsgGetWeatherAlertDataMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < StatesAndVersionPerLanguage.size(); ++u32ListIdx)
      u32DynamicSize += StatesAndVersionPerLanguage[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < WeatherAlertsForPosition.size(); ++u32ListIdx)
      u32DynamicSize += WeatherAlertsForPosition[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8;
}

tBool weatherfi_tclMsgGetWeatherAlertDataMethodResult::operator==(const weatherfi_tclMsgGetWeatherAlertDataMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (StatesAndVersionPerLanguage.size() == rfoCmp.StatesAndVersionPerLanguage.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < StatesAndVersionPerLanguage.size()); ++u32Idx)
            bResult = bResult && (StatesAndVersionPerLanguage[u32Idx] == rfoCmp.StatesAndVersionPerLanguage[u32Idx]);
      }
      bResult = bResult && (WeatherAlertsForPosition.size() == rfoCmp.WeatherAlertsForPosition.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < WeatherAlertsForPosition.size()); ++u32Idx)
            bResult = bResult && (WeatherAlertsForPosition[u32Idx] == rfoCmp.WeatherAlertsForPosition[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgGetWeatherAlertDataMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < StatesAndVersionPerLanguage.size(); ++u32Idx)
      {
         StatesAndVersionPerLanguage[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      StatesAndVersionPerLanguage.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> StatesAndVersionPerLanguage[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < WeatherAlertsForPosition.size(); ++u32Idx)
      {
         WeatherAlertsForPosition[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      WeatherAlertsForPosition.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> WeatherAlertsForPosition[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgGetWeatherAlertDataMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)StatesAndVersionPerLanguage.size();
   {
      for (tU32 u32Idx = 0; u32Idx < StatesAndVersionPerLanguage.size(); ++u32Idx)
         oOut << StatesAndVersionPerLanguage[u32Idx];
   }
   oOut << (tU32)WeatherAlertsForPosition.size();
   {
      for (tU32 u32Idx = 0; u32Idx < WeatherAlertsForPosition.size(); ++u32Idx)
         oOut << WeatherAlertsForPosition[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgConfirmGraphicalWeatherRasterTileSharedMemoryMethodStart::weatherfi_tclMsgConfirmGraphicalWeatherRasterTileSharedMemoryMethodStart(const weatherfi_tclMsgConfirmGraphicalWeatherRasterTileSharedMemoryMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   ProductType = coRef.ProductType;
   PictureType = coRef.PictureType;
   Open = coRef.Open;
   SharedMemoryOverview = coRef.SharedMemoryOverview;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgConfirmGraphicalWeatherRasterTileSharedMemoryMethodStart& weatherfi_tclMsgConfirmGraphicalWeatherRasterTileSharedMemoryMethodStart::operator=(const weatherfi_tclMsgConfirmGraphicalWeatherRasterTileSharedMemoryMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ProductType = coRef.ProductType;
   PictureType = coRef.PictureType;
   Open = coRef.Open;
   SharedMemoryOverview = coRef.SharedMemoryOverview;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgConfirmGraphicalWeatherRasterTileSharedMemoryMethodStart::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgConfirmGraphicalWeatherRasterTileSharedMemoryMethodStart::u16GetFunctionID() const {return WEATHERFI_C_U16_CONFIRMGRAPHICALWEATHERRASTERTILESHAREDMEMORY;}
tU8 weatherfi_tclMsgConfirmGraphicalWeatherRasterTileSharedMemoryMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid weatherfi_tclMsgConfirmGraphicalWeatherRasterTileSharedMemoryMethodStart::vDestroy()
{
   SharedMemoryOverview.vDestroy(); 
}

tU32 weatherfi_tclMsgConfirmGraphicalWeatherRasterTileSharedMemoryMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 3+SharedMemoryOverview.u32GetSize(u16MajorVersion);
}

tBool weatherfi_tclMsgConfirmGraphicalWeatherRasterTileSharedMemoryMethodStart::operator==(const weatherfi_tclMsgConfirmGraphicalWeatherRasterTileSharedMemoryMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ProductType == rfoCmp.ProductType);
      bResult = bResult && (PictureType == rfoCmp.PictureType);
      bResult = bResult && (Open == rfoCmp.Open);
      bResult = bResult && (SharedMemoryOverview == rfoCmp.SharedMemoryOverview);
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgConfirmGraphicalWeatherRasterTileSharedMemoryMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> ProductType;
   oIn >> PictureType;
   oIn >> Open;
   oIn >> SharedMemoryOverview;
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgConfirmGraphicalWeatherRasterTileSharedMemoryMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ProductType;
   oOut << PictureType;
   oOut << Open;
   oOut << SharedMemoryOverview;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgConfirmGraphicalWeatherRasterTileSharedMemoryMethodResult::weatherfi_tclMsgConfirmGraphicalWeatherRasterTileSharedMemoryMethodResult(const weatherfi_tclMsgConfirmGraphicalWeatherRasterTileSharedMemoryMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   ProductType = coRef.ProductType;
   PictureType = coRef.PictureType;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgConfirmGraphicalWeatherRasterTileSharedMemoryMethodResult& weatherfi_tclMsgConfirmGraphicalWeatherRasterTileSharedMemoryMethodResult::operator=(const weatherfi_tclMsgConfirmGraphicalWeatherRasterTileSharedMemoryMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ProductType = coRef.ProductType;
   PictureType = coRef.PictureType;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgConfirmGraphicalWeatherRasterTileSharedMemoryMethodResult::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgConfirmGraphicalWeatherRasterTileSharedMemoryMethodResult::u16GetFunctionID() const {return WEATHERFI_C_U16_CONFIRMGRAPHICALWEATHERRASTERTILESHAREDMEMORY;}
tU8 weatherfi_tclMsgConfirmGraphicalWeatherRasterTileSharedMemoryMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 weatherfi_tclMsgConfirmGraphicalWeatherRasterTileSharedMemoryMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (28 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   if (28 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+0;
}

tBool weatherfi_tclMsgConfirmGraphicalWeatherRasterTileSharedMemoryMethodResult::operator==(const weatherfi_tclMsgConfirmGraphicalWeatherRasterTileSharedMemoryMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ProductType == rfoCmp.ProductType);
      bResult = bResult && (PictureType == rfoCmp.PictureType);
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgConfirmGraphicalWeatherRasterTileSharedMemoryMethodResult::oRead(fi_tclInContext& oIn)
{
   if (28 <= oIn.u16GetMajorVersion())
   {
      oIn >> ProductType;
   }
   if (28 <= oIn.u16GetMajorVersion())
   {
      oIn >> PictureType;
   }
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgConfirmGraphicalWeatherRasterTileSharedMemoryMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   if (28 <= oOut.u16GetMajorVersion())
   {
      oOut << ProductType;
   }
   if (28 <= oOut.u16GetMajorVersion())
   {
      oOut << PictureType;
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgConfirmGraphicalWeatherTilePictureDataMethodStart::weatherfi_tclMsgConfirmGraphicalWeatherTilePictureDataMethodStart(const weatherfi_tclMsgConfirmGraphicalWeatherTilePictureDataMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   ProductType = coRef.ProductType;
   PictureType = coRef.PictureType;
   UsedTiles = coRef.UsedTiles;
   BackgroundTiles = coRef.BackgroundTiles;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgConfirmGraphicalWeatherTilePictureDataMethodStart& weatherfi_tclMsgConfirmGraphicalWeatherTilePictureDataMethodStart::operator=(const weatherfi_tclMsgConfirmGraphicalWeatherTilePictureDataMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ProductType = coRef.ProductType;
   PictureType = coRef.PictureType;
   UsedTiles = coRef.UsedTiles;
   BackgroundTiles = coRef.BackgroundTiles;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgConfirmGraphicalWeatherTilePictureDataMethodStart::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgConfirmGraphicalWeatherTilePictureDataMethodStart::u16GetFunctionID() const {return WEATHERFI_C_U16_CONFIRMGRAPHICALWEATHERTILEPICTUREDATA;}
tU8 weatherfi_tclMsgConfirmGraphicalWeatherTilePictureDataMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid weatherfi_tclMsgConfirmGraphicalWeatherTilePictureDataMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < UsedTiles.size(); ++u32Idx)
         UsedTiles[u32Idx].vDestroy();
   }
   UsedTiles.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < BackgroundTiles.size(); ++u32Idx)
         BackgroundTiles[u32Idx].vDestroy();
   }
   BackgroundTiles.clear();
}

tU32 weatherfi_tclMsgConfirmGraphicalWeatherTilePictureDataMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < UsedTiles.size(); ++u32ListIdx)
      u32DynamicSize += UsedTiles[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < BackgroundTiles.size(); ++u32ListIdx)
      u32DynamicSize += BackgroundTiles[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+10;
}

tBool weatherfi_tclMsgConfirmGraphicalWeatherTilePictureDataMethodStart::operator==(const weatherfi_tclMsgConfirmGraphicalWeatherTilePictureDataMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ProductType == rfoCmp.ProductType);
      bResult = bResult && (PictureType == rfoCmp.PictureType);
      bResult = bResult && (UsedTiles.size() == rfoCmp.UsedTiles.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < UsedTiles.size()); ++u32Idx)
            bResult = bResult && (UsedTiles[u32Idx] == rfoCmp.UsedTiles[u32Idx]);
      }
      bResult = bResult && (BackgroundTiles.size() == rfoCmp.BackgroundTiles.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < BackgroundTiles.size()); ++u32Idx)
            bResult = bResult && (BackgroundTiles[u32Idx] == rfoCmp.BackgroundTiles[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgConfirmGraphicalWeatherTilePictureDataMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> ProductType;
   oIn >> PictureType;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < UsedTiles.size(); ++u32Idx)
      {
         UsedTiles[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      UsedTiles.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> UsedTiles[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < BackgroundTiles.size(); ++u32Idx)
      {
         BackgroundTiles[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      BackgroundTiles.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> BackgroundTiles[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgConfirmGraphicalWeatherTilePictureDataMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ProductType;
   oOut << PictureType;
   oOut << (tU32)UsedTiles.size();
   {
      for (tU32 u32Idx = 0; u32Idx < UsedTiles.size(); ++u32Idx)
         oOut << UsedTiles[u32Idx];
   }
   oOut << (tU32)BackgroundTiles.size();
   {
      for (tU32 u32Idx = 0; u32Idx < BackgroundTiles.size(); ++u32Idx)
         oOut << BackgroundTiles[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgConfirmGraphicalWeatherTilePictureDataMethodResult::weatherfi_tclMsgConfirmGraphicalWeatherTilePictureDataMethodResult(const weatherfi_tclMsgConfirmGraphicalWeatherTilePictureDataMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   ProductType = coRef.ProductType;
   PictureType = coRef.PictureType;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgConfirmGraphicalWeatherTilePictureDataMethodResult& weatherfi_tclMsgConfirmGraphicalWeatherTilePictureDataMethodResult::operator=(const weatherfi_tclMsgConfirmGraphicalWeatherTilePictureDataMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ProductType = coRef.ProductType;
   PictureType = coRef.PictureType;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgConfirmGraphicalWeatherTilePictureDataMethodResult::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgConfirmGraphicalWeatherTilePictureDataMethodResult::u16GetFunctionID() const {return WEATHERFI_C_U16_CONFIRMGRAPHICALWEATHERTILEPICTUREDATA;}
tU8 weatherfi_tclMsgConfirmGraphicalWeatherTilePictureDataMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 weatherfi_tclMsgConfirmGraphicalWeatherTilePictureDataMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (28 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   if (28 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+0;
}

tBool weatherfi_tclMsgConfirmGraphicalWeatherTilePictureDataMethodResult::operator==(const weatherfi_tclMsgConfirmGraphicalWeatherTilePictureDataMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ProductType == rfoCmp.ProductType);
      bResult = bResult && (PictureType == rfoCmp.PictureType);
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgConfirmGraphicalWeatherTilePictureDataMethodResult::oRead(fi_tclInContext& oIn)
{
   if (28 <= oIn.u16GetMajorVersion())
   {
      oIn >> ProductType;
   }
   if (28 <= oIn.u16GetMajorVersion())
   {
      oIn >> PictureType;
   }
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgConfirmGraphicalWeatherTilePictureDataMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   if (28 <= oOut.u16GetMajorVersion())
   {
      oOut << ProductType;
   }
   if (28 <= oOut.u16GetMajorVersion())
   {
      oOut << PictureType;
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGetSurfaceDataMethodStart::weatherfi_tclMsgGetSurfaceDataMethodStart(const weatherfi_tclMsgGetSurfaceDataMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   FrontFilter = coRef.FrontFilter;
   IsobarFilter = coRef.IsobarFilter;
   PressureCenterFilter = coRef.PressureCenterFilter;
   RequestedBinContainerVersion = coRef.RequestedBinContainerVersion;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGetSurfaceDataMethodStart& weatherfi_tclMsgGetSurfaceDataMethodStart::operator=(const weatherfi_tclMsgGetSurfaceDataMethodStart& coRef)
{
   if (this == &coRef) return *this;
   FrontFilter = coRef.FrontFilter;
   IsobarFilter = coRef.IsobarFilter;
   PressureCenterFilter = coRef.PressureCenterFilter;
   RequestedBinContainerVersion = coRef.RequestedBinContainerVersion;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgGetSurfaceDataMethodStart::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgGetSurfaceDataMethodStart::u16GetFunctionID() const {return WEATHERFI_C_U16_GETSURFACEDATA;}
tU8 weatherfi_tclMsgGetSurfaceDataMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 weatherfi_tclMsgGetSurfaceDataMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool weatherfi_tclMsgGetSurfaceDataMethodStart::operator==(const weatherfi_tclMsgGetSurfaceDataMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (FrontFilter == rfoCmp.FrontFilter);
      bResult = bResult && (IsobarFilter == rfoCmp.IsobarFilter);
      bResult = bResult && (PressureCenterFilter == rfoCmp.PressureCenterFilter);
      bResult = bResult && (RequestedBinContainerVersion == rfoCmp.RequestedBinContainerVersion);
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgGetSurfaceDataMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> FrontFilter;
   oIn >> IsobarFilter;
   oIn >> PressureCenterFilter;
   oIn >> RequestedBinContainerVersion;
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgGetSurfaceDataMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << FrontFilter;
   oOut << IsobarFilter;
   oOut << PressureCenterFilter;
   oOut << RequestedBinContainerVersion;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGetSurfaceDataMethodResult::weatherfi_tclMsgGetSurfaceDataMethodResult(const weatherfi_tclMsgGetSurfaceDataMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   UpdateCounter = coRef.UpdateCounter;
   Fronts = coRef.Fronts;
   Isobars = coRef.Isobars;
   PressureCenters = coRef.PressureCenters;
   SurfaceShapes = coRef.SurfaceShapes;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGetSurfaceDataMethodResult& weatherfi_tclMsgGetSurfaceDataMethodResult::operator=(const weatherfi_tclMsgGetSurfaceDataMethodResult& coRef)
{
   if (this == &coRef) return *this;
   UpdateCounter = coRef.UpdateCounter;
   Fronts = coRef.Fronts;
   Isobars = coRef.Isobars;
   PressureCenters = coRef.PressureCenters;
   SurfaceShapes = coRef.SurfaceShapes;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgGetSurfaceDataMethodResult::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgGetSurfaceDataMethodResult::u16GetFunctionID() const {return WEATHERFI_C_U16_GETSURFACEDATA;}
tU8 weatherfi_tclMsgGetSurfaceDataMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid weatherfi_tclMsgGetSurfaceDataMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Fronts.size(); ++u32Idx)
         Fronts[u32Idx].vDestroy();
   }
   Fronts.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < Isobars.size(); ++u32Idx)
         Isobars[u32Idx].vDestroy();
   }
   Isobars.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < PressureCenters.size(); ++u32Idx)
         PressureCenters[u32Idx].vDestroy();
   }
   PressureCenters.clear();
   SurfaceShapes.vDestroy(); 
}

tU32 weatherfi_tclMsgGetSurfaceDataMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < Fronts.size(); ++u32ListIdx)
      u32DynamicSize += Fronts[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < Isobars.size(); ++u32ListIdx)
      u32DynamicSize += Isobars[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+16+PressureCenters.size()*21+SurfaceShapes.u32GetSize(u16MajorVersion);
}

tBool weatherfi_tclMsgGetSurfaceDataMethodResult::operator==(const weatherfi_tclMsgGetSurfaceDataMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UpdateCounter == rfoCmp.UpdateCounter);
      bResult = bResult && (Fronts.size() == rfoCmp.Fronts.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Fronts.size()); ++u32Idx)
            bResult = bResult && (Fronts[u32Idx] == rfoCmp.Fronts[u32Idx]);
      }
      bResult = bResult && (Isobars.size() == rfoCmp.Isobars.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Isobars.size()); ++u32Idx)
            bResult = bResult && (Isobars[u32Idx] == rfoCmp.Isobars[u32Idx]);
      }
      bResult = bResult && (PressureCenters.size() == rfoCmp.PressureCenters.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PressureCenters.size()); ++u32Idx)
            bResult = bResult && (PressureCenters[u32Idx] == rfoCmp.PressureCenters[u32Idx]);
      }
      bResult = bResult && (SurfaceShapes == rfoCmp.SurfaceShapes);
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgGetSurfaceDataMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> UpdateCounter;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Fronts.size(); ++u32Idx)
      {
         Fronts[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      Fronts.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> Fronts[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Isobars.size(); ++u32Idx)
      {
         Isobars[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      Isobars.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> Isobars[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < PressureCenters.size(); ++u32Idx)
      {
         PressureCenters[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      PressureCenters.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> PressureCenters[u32Idx];
      }
   }
   oIn >> SurfaceShapes;
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgGetSurfaceDataMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UpdateCounter;
   oOut << (tU32)Fronts.size();
   {
      for (tU32 u32Idx = 0; u32Idx < Fronts.size(); ++u32Idx)
         oOut << Fronts[u32Idx];
   }
   oOut << (tU32)Isobars.size();
   {
      for (tU32 u32Idx = 0; u32Idx < Isobars.size(); ++u32Idx)
         oOut << Isobars[u32Idx];
   }
   oOut << (tU32)PressureCenters.size();
   {
      for (tU32 u32Idx = 0; u32Idx < PressureCenters.size(); ++u32Idx)
         oOut << PressureCenters[u32Idx];
   }
   oOut << SurfaceShapes;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGetStormAttributesDataMethodStart::weatherfi_tclMsgGetStormAttributesDataMethodStart(const weatherfi_tclMsgGetStormAttributesDataMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   StormAttributesFilter = coRef.StormAttributesFilter;
   RequestedBinContainerVersion = coRef.RequestedBinContainerVersion;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGetStormAttributesDataMethodStart& weatherfi_tclMsgGetStormAttributesDataMethodStart::operator=(const weatherfi_tclMsgGetStormAttributesDataMethodStart& coRef)
{
   if (this == &coRef) return *this;
   StormAttributesFilter = coRef.StormAttributesFilter;
   RequestedBinContainerVersion = coRef.RequestedBinContainerVersion;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgGetStormAttributesDataMethodStart::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgGetStormAttributesDataMethodStart::u16GetFunctionID() const {return WEATHERFI_C_U16_GETSTORMATTRIBUTESDATA;}
tU8 weatherfi_tclMsgGetStormAttributesDataMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 weatherfi_tclMsgGetStormAttributesDataMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

tBool weatherfi_tclMsgGetStormAttributesDataMethodStart::operator==(const weatherfi_tclMsgGetStormAttributesDataMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (StormAttributesFilter == rfoCmp.StormAttributesFilter);
      bResult = bResult && (RequestedBinContainerVersion == rfoCmp.RequestedBinContainerVersion);
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgGetStormAttributesDataMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> StormAttributesFilter;
   oIn >> RequestedBinContainerVersion;
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgGetStormAttributesDataMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << StormAttributesFilter;
   oOut << RequestedBinContainerVersion;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGetStormAttributesDataMethodResult::weatherfi_tclMsgGetStormAttributesDataMethodResult(const weatherfi_tclMsgGetStormAttributesDataMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   UpdateCounter = coRef.UpdateCounter;
   StormAttributes = coRef.StormAttributes;
   StormAttributeShapes = coRef.StormAttributeShapes;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGetStormAttributesDataMethodResult& weatherfi_tclMsgGetStormAttributesDataMethodResult::operator=(const weatherfi_tclMsgGetStormAttributesDataMethodResult& coRef)
{
   if (this == &coRef) return *this;
   UpdateCounter = coRef.UpdateCounter;
   StormAttributes = coRef.StormAttributes;
   StormAttributeShapes = coRef.StormAttributeShapes;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgGetStormAttributesDataMethodResult::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgGetStormAttributesDataMethodResult::u16GetFunctionID() const {return WEATHERFI_C_U16_GETSTORMATTRIBUTESDATA;}
tU8 weatherfi_tclMsgGetStormAttributesDataMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid weatherfi_tclMsgGetStormAttributesDataMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < StormAttributes.size(); ++u32Idx)
         StormAttributes[u32Idx].vDestroy();
   }
   StormAttributes.clear();
   StormAttributeShapes.vDestroy(); 
}

tU32 weatherfi_tclMsgGetStormAttributesDataMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < StormAttributes.size(); ++u32ListIdx)
      u32DynamicSize += StormAttributes[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8+StormAttributeShapes.u32GetSize(u16MajorVersion);
}

tBool weatherfi_tclMsgGetStormAttributesDataMethodResult::operator==(const weatherfi_tclMsgGetStormAttributesDataMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UpdateCounter == rfoCmp.UpdateCounter);
      bResult = bResult && (StormAttributes.size() == rfoCmp.StormAttributes.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < StormAttributes.size()); ++u32Idx)
            bResult = bResult && (StormAttributes[u32Idx] == rfoCmp.StormAttributes[u32Idx]);
      }
      bResult = bResult && (StormAttributeShapes == rfoCmp.StormAttributeShapes);
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgGetStormAttributesDataMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> UpdateCounter;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < StormAttributes.size(); ++u32Idx)
      {
         StormAttributes[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      StormAttributes.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> StormAttributes[u32Idx];
      }
   }
   oIn >> StormAttributeShapes;
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgGetStormAttributesDataMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UpdateCounter;
   oOut << (tU32)StormAttributes.size();
   {
      for (tU32 u32Idx = 0; u32Idx < StormAttributes.size(); ++u32Idx)
         oOut << StormAttributes[u32Idx];
   }
   oOut << StormAttributeShapes;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGetStormTrackDataMethodStart::weatherfi_tclMsgGetStormTrackDataMethodStart(const weatherfi_tclMsgGetStormTrackDataMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   StormPositionFilter = coRef.StormPositionFilter;
   WindRadiusFilter = coRef.WindRadiusFilter;
   RequestedBinContainerVersion = coRef.RequestedBinContainerVersion;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGetStormTrackDataMethodStart& weatherfi_tclMsgGetStormTrackDataMethodStart::operator=(const weatherfi_tclMsgGetStormTrackDataMethodStart& coRef)
{
   if (this == &coRef) return *this;
   StormPositionFilter = coRef.StormPositionFilter;
   WindRadiusFilter = coRef.WindRadiusFilter;
   RequestedBinContainerVersion = coRef.RequestedBinContainerVersion;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgGetStormTrackDataMethodStart::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgGetStormTrackDataMethodStart::u16GetFunctionID() const {return WEATHERFI_C_U16_GETSTORMTRACKDATA;}
tU8 weatherfi_tclMsgGetStormTrackDataMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 weatherfi_tclMsgGetStormTrackDataMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

tBool weatherfi_tclMsgGetStormTrackDataMethodStart::operator==(const weatherfi_tclMsgGetStormTrackDataMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (StormPositionFilter == rfoCmp.StormPositionFilter);
      bResult = bResult && (WindRadiusFilter == rfoCmp.WindRadiusFilter);
      bResult = bResult && (RequestedBinContainerVersion == rfoCmp.RequestedBinContainerVersion);
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgGetStormTrackDataMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> StormPositionFilter;
   oIn >> WindRadiusFilter;
   oIn >> RequestedBinContainerVersion;
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgGetStormTrackDataMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << StormPositionFilter;
   oOut << WindRadiusFilter;
   oOut << RequestedBinContainerVersion;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGetStormTrackDataMethodResult::weatherfi_tclMsgGetStormTrackDataMethodResult(const weatherfi_tclMsgGetStormTrackDataMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   UpdateCounter = coRef.UpdateCounter;
   StormTracks = coRef.StormTracks;
   StormTrackShapes = coRef.StormTrackShapes;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGetStormTrackDataMethodResult& weatherfi_tclMsgGetStormTrackDataMethodResult::operator=(const weatherfi_tclMsgGetStormTrackDataMethodResult& coRef)
{
   if (this == &coRef) return *this;
   UpdateCounter = coRef.UpdateCounter;
   StormTracks = coRef.StormTracks;
   StormTrackShapes = coRef.StormTrackShapes;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgGetStormTrackDataMethodResult::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgGetStormTrackDataMethodResult::u16GetFunctionID() const {return WEATHERFI_C_U16_GETSTORMTRACKDATA;}
tU8 weatherfi_tclMsgGetStormTrackDataMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid weatherfi_tclMsgGetStormTrackDataMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < StormTracks.size(); ++u32Idx)
         StormTracks[u32Idx].vDestroy();
   }
   StormTracks.clear();
   StormTrackShapes.vDestroy(); 
}

tU32 weatherfi_tclMsgGetStormTrackDataMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < StormTracks.size(); ++u32ListIdx)
      u32DynamicSize += StormTracks[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8+StormTrackShapes.u32GetSize(u16MajorVersion);
}

tBool weatherfi_tclMsgGetStormTrackDataMethodResult::operator==(const weatherfi_tclMsgGetStormTrackDataMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UpdateCounter == rfoCmp.UpdateCounter);
      bResult = bResult && (StormTracks.size() == rfoCmp.StormTracks.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < StormTracks.size()); ++u32Idx)
            bResult = bResult && (StormTracks[u32Idx] == rfoCmp.StormTracks[u32Idx]);
      }
      bResult = bResult && (StormTrackShapes == rfoCmp.StormTrackShapes);
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgGetStormTrackDataMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> UpdateCounter;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < StormTracks.size(); ++u32Idx)
      {
         StormTracks[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      StormTracks.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> StormTracks[u32Idx];
      }
   }
   oIn >> StormTrackShapes;
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgGetStormTrackDataMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UpdateCounter;
   oOut << (tU32)StormTracks.size();
   {
      for (tU32 u32Idx = 0; u32Idx < StormTracks.size(); ++u32Idx)
         oOut << StormTracks[u32Idx];
   }
   oOut << StormTrackShapes;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgConfirmRasterTileSharedMemoryMethodStart::weatherfi_tclMsgConfirmRasterTileSharedMemoryMethodStart(const weatherfi_tclMsgConfirmRasterTileSharedMemoryMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   ConfirmedSharedMemories = coRef.ConfirmedSharedMemories;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgConfirmRasterTileSharedMemoryMethodStart& weatherfi_tclMsgConfirmRasterTileSharedMemoryMethodStart::operator=(const weatherfi_tclMsgConfirmRasterTileSharedMemoryMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ConfirmedSharedMemories = coRef.ConfirmedSharedMemories;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgConfirmRasterTileSharedMemoryMethodStart::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgConfirmRasterTileSharedMemoryMethodStart::u16GetFunctionID() const {return WEATHERFI_C_U16_CONFIRMRASTERTILESHAREDMEMORY;}
tU8 weatherfi_tclMsgConfirmRasterTileSharedMemoryMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid weatherfi_tclMsgConfirmRasterTileSharedMemoryMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ConfirmedSharedMemories.size(); ++u32Idx)
         ConfirmedSharedMemories[u32Idx].vDestroy();
   }
   ConfirmedSharedMemories.clear();
}

tU32 weatherfi_tclMsgConfirmRasterTileSharedMemoryMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < ConfirmedSharedMemories.size(); ++u32ListIdx)
      u32DynamicSize += ConfirmedSharedMemories[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool weatherfi_tclMsgConfirmRasterTileSharedMemoryMethodStart::operator==(const weatherfi_tclMsgConfirmRasterTileSharedMemoryMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ConfirmedSharedMemories.size() == rfoCmp.ConfirmedSharedMemories.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ConfirmedSharedMemories.size()); ++u32Idx)
            bResult = bResult && (ConfirmedSharedMemories[u32Idx] == rfoCmp.ConfirmedSharedMemories[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgConfirmRasterTileSharedMemoryMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ConfirmedSharedMemories.size(); ++u32Idx)
      {
         ConfirmedSharedMemories[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ConfirmedSharedMemories.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ConfirmedSharedMemories[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgConfirmRasterTileSharedMemoryMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)ConfirmedSharedMemories.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ConfirmedSharedMemories.size(); ++u32Idx)
         oOut << ConfirmedSharedMemories[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgConfirmRasterTileSharedMemoryMethodResult::weatherfi_tclMsgConfirmRasterTileSharedMemoryMethodResult(const weatherfi_tclMsgConfirmRasterTileSharedMemoryMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   ConfirmedSharedMemories = coRef.ConfirmedSharedMemories;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgConfirmRasterTileSharedMemoryMethodResult& weatherfi_tclMsgConfirmRasterTileSharedMemoryMethodResult::operator=(const weatherfi_tclMsgConfirmRasterTileSharedMemoryMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ConfirmedSharedMemories = coRef.ConfirmedSharedMemories;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgConfirmRasterTileSharedMemoryMethodResult::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgConfirmRasterTileSharedMemoryMethodResult::u16GetFunctionID() const {return WEATHERFI_C_U16_CONFIRMRASTERTILESHAREDMEMORY;}
tU8 weatherfi_tclMsgConfirmRasterTileSharedMemoryMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid weatherfi_tclMsgConfirmRasterTileSharedMemoryMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ConfirmedSharedMemories.size(); ++u32Idx)
         ConfirmedSharedMemories[u32Idx].vDestroy();
   }
   ConfirmedSharedMemories.clear();
}

tU32 weatherfi_tclMsgConfirmRasterTileSharedMemoryMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ConfirmedSharedMemories.size()*3;
}

tBool weatherfi_tclMsgConfirmRasterTileSharedMemoryMethodResult::operator==(const weatherfi_tclMsgConfirmRasterTileSharedMemoryMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ConfirmedSharedMemories.size() == rfoCmp.ConfirmedSharedMemories.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ConfirmedSharedMemories.size()); ++u32Idx)
            bResult = bResult && (ConfirmedSharedMemories[u32Idx] == rfoCmp.ConfirmedSharedMemories[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgConfirmRasterTileSharedMemoryMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ConfirmedSharedMemories.size(); ++u32Idx)
      {
         ConfirmedSharedMemories[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ConfirmedSharedMemories.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ConfirmedSharedMemories[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgConfirmRasterTileSharedMemoryMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)ConfirmedSharedMemories.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ConfirmedSharedMemories.size(); ++u32Idx)
         oOut << ConfirmedSharedMemories[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgConfirmRasterTilePicturesMethodStart::weatherfi_tclMsgConfirmRasterTilePicturesMethodStart(const weatherfi_tclMsgConfirmRasterTilePicturesMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   ConfirmedTileTypes = coRef.ConfirmedTileTypes;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgConfirmRasterTilePicturesMethodStart& weatherfi_tclMsgConfirmRasterTilePicturesMethodStart::operator=(const weatherfi_tclMsgConfirmRasterTilePicturesMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ConfirmedTileTypes = coRef.ConfirmedTileTypes;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgConfirmRasterTilePicturesMethodStart::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgConfirmRasterTilePicturesMethodStart::u16GetFunctionID() const {return WEATHERFI_C_U16_CONFIRMRASTERTILEPICTURES;}
tU8 weatherfi_tclMsgConfirmRasterTilePicturesMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid weatherfi_tclMsgConfirmRasterTilePicturesMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ConfirmedTileTypes.size(); ++u32Idx)
         ConfirmedTileTypes[u32Idx].vDestroy();
   }
   ConfirmedTileTypes.clear();
}

tU32 weatherfi_tclMsgConfirmRasterTilePicturesMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ConfirmedTileTypes.size()*3;
}

tBool weatherfi_tclMsgConfirmRasterTilePicturesMethodStart::operator==(const weatherfi_tclMsgConfirmRasterTilePicturesMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ConfirmedTileTypes.size() == rfoCmp.ConfirmedTileTypes.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ConfirmedTileTypes.size()); ++u32Idx)
            bResult = bResult && (ConfirmedTileTypes[u32Idx] == rfoCmp.ConfirmedTileTypes[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgConfirmRasterTilePicturesMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ConfirmedTileTypes.size(); ++u32Idx)
      {
         ConfirmedTileTypes[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ConfirmedTileTypes.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ConfirmedTileTypes[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgConfirmRasterTilePicturesMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)ConfirmedTileTypes.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ConfirmedTileTypes.size(); ++u32Idx)
         oOut << ConfirmedTileTypes[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgConfirmRasterTilePicturesMethodResult::weatherfi_tclMsgConfirmRasterTilePicturesMethodResult(const weatherfi_tclMsgConfirmRasterTilePicturesMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   ConfirmedTileTypes = coRef.ConfirmedTileTypes;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgConfirmRasterTilePicturesMethodResult& weatherfi_tclMsgConfirmRasterTilePicturesMethodResult::operator=(const weatherfi_tclMsgConfirmRasterTilePicturesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ConfirmedTileTypes = coRef.ConfirmedTileTypes;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgConfirmRasterTilePicturesMethodResult::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgConfirmRasterTilePicturesMethodResult::u16GetFunctionID() const {return WEATHERFI_C_U16_CONFIRMRASTERTILEPICTURES;}
tU8 weatherfi_tclMsgConfirmRasterTilePicturesMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid weatherfi_tclMsgConfirmRasterTilePicturesMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ConfirmedTileTypes.size(); ++u32Idx)
         ConfirmedTileTypes[u32Idx].vDestroy();
   }
   ConfirmedTileTypes.clear();
}

tU32 weatherfi_tclMsgConfirmRasterTilePicturesMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ConfirmedTileTypes.size()*3;
}

tBool weatherfi_tclMsgConfirmRasterTilePicturesMethodResult::operator==(const weatherfi_tclMsgConfirmRasterTilePicturesMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ConfirmedTileTypes.size() == rfoCmp.ConfirmedTileTypes.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ConfirmedTileTypes.size()); ++u32Idx)
            bResult = bResult && (ConfirmedTileTypes[u32Idx] == rfoCmp.ConfirmedTileTypes[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgConfirmRasterTilePicturesMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ConfirmedTileTypes.size(); ++u32Idx)
      {
         ConfirmedTileTypes[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ConfirmedTileTypes.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ConfirmedTileTypes[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgConfirmRasterTilePicturesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)ConfirmedTileTypes.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ConfirmedTileTypes.size(); ++u32Idx)
         oOut << ConfirmedTileTypes[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgCurrentWeatherDataChangedGet::weatherfi_tclMsgCurrentWeatherDataChangedGet(const weatherfi_tclMsgCurrentWeatherDataChangedGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgCurrentWeatherDataChangedGet& weatherfi_tclMsgCurrentWeatherDataChangedGet::operator=(const weatherfi_tclMsgCurrentWeatherDataChangedGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgCurrentWeatherDataChangedGet::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgCurrentWeatherDataChangedGet::u16GetFunctionID() const {return WEATHERFI_C_U16_CURRENTWEATHERDATACHANGED;}
tU8 weatherfi_tclMsgCurrentWeatherDataChangedGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 weatherfi_tclMsgCurrentWeatherDataChangedGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weatherfi_tclMsgCurrentWeatherDataChangedGet::operator==(const weatherfi_tclMsgCurrentWeatherDataChangedGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgCurrentWeatherDataChangedGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgCurrentWeatherDataChangedGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgCurrentWeatherDataChangedUpReg::weatherfi_tclMsgCurrentWeatherDataChangedUpReg(const weatherfi_tclMsgCurrentWeatherDataChangedUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgCurrentWeatherDataChangedUpReg& weatherfi_tclMsgCurrentWeatherDataChangedUpReg::operator=(const weatherfi_tclMsgCurrentWeatherDataChangedUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgCurrentWeatherDataChangedUpReg::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgCurrentWeatherDataChangedUpReg::u16GetFunctionID() const {return WEATHERFI_C_U16_CURRENTWEATHERDATACHANGED;}
tU8 weatherfi_tclMsgCurrentWeatherDataChangedUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 weatherfi_tclMsgCurrentWeatherDataChangedUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weatherfi_tclMsgCurrentWeatherDataChangedUpReg::operator==(const weatherfi_tclMsgCurrentWeatherDataChangedUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgCurrentWeatherDataChangedUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgCurrentWeatherDataChangedUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgCurrentWeatherDataChangedRelUpReg::weatherfi_tclMsgCurrentWeatherDataChangedRelUpReg(const weatherfi_tclMsgCurrentWeatherDataChangedRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgCurrentWeatherDataChangedRelUpReg& weatherfi_tclMsgCurrentWeatherDataChangedRelUpReg::operator=(const weatherfi_tclMsgCurrentWeatherDataChangedRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgCurrentWeatherDataChangedRelUpReg::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgCurrentWeatherDataChangedRelUpReg::u16GetFunctionID() const {return WEATHERFI_C_U16_CURRENTWEATHERDATACHANGED;}
tU8 weatherfi_tclMsgCurrentWeatherDataChangedRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 weatherfi_tclMsgCurrentWeatherDataChangedRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weatherfi_tclMsgCurrentWeatherDataChangedRelUpReg::operator==(const weatherfi_tclMsgCurrentWeatherDataChangedRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgCurrentWeatherDataChangedRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgCurrentWeatherDataChangedRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgCurrentWeatherDataChangedStatus::weatherfi_tclMsgCurrentWeatherDataChangedStatus(const weatherfi_tclMsgCurrentWeatherDataChangedStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   CurrentWeatherId = coRef.CurrentWeatherId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgCurrentWeatherDataChangedStatus& weatherfi_tclMsgCurrentWeatherDataChangedStatus::operator=(const weatherfi_tclMsgCurrentWeatherDataChangedStatus& coRef)
{
   if (this == &coRef) return *this;
   CurrentWeatherId = coRef.CurrentWeatherId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgCurrentWeatherDataChangedStatus::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgCurrentWeatherDataChangedStatus::u16GetFunctionID() const {return WEATHERFI_C_U16_CURRENTWEATHERDATACHANGED;}
tU8 weatherfi_tclMsgCurrentWeatherDataChangedStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 weatherfi_tclMsgCurrentWeatherDataChangedStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool weatherfi_tclMsgCurrentWeatherDataChangedStatus::operator==(const weatherfi_tclMsgCurrentWeatherDataChangedStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (CurrentWeatherId == rfoCmp.CurrentWeatherId);
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgCurrentWeatherDataChangedStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> CurrentWeatherId;
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgCurrentWeatherDataChangedStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << CurrentWeatherId;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgWeatherForecastDataChangedGet::weatherfi_tclMsgWeatherForecastDataChangedGet(const weatherfi_tclMsgWeatherForecastDataChangedGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgWeatherForecastDataChangedGet& weatherfi_tclMsgWeatherForecastDataChangedGet::operator=(const weatherfi_tclMsgWeatherForecastDataChangedGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgWeatherForecastDataChangedGet::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgWeatherForecastDataChangedGet::u16GetFunctionID() const {return WEATHERFI_C_U16_WEATHERFORECASTDATACHANGED;}
tU8 weatherfi_tclMsgWeatherForecastDataChangedGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 weatherfi_tclMsgWeatherForecastDataChangedGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weatherfi_tclMsgWeatherForecastDataChangedGet::operator==(const weatherfi_tclMsgWeatherForecastDataChangedGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgWeatherForecastDataChangedGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgWeatherForecastDataChangedGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgWeatherForecastDataChangedUpReg::weatherfi_tclMsgWeatherForecastDataChangedUpReg(const weatherfi_tclMsgWeatherForecastDataChangedUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgWeatherForecastDataChangedUpReg& weatherfi_tclMsgWeatherForecastDataChangedUpReg::operator=(const weatherfi_tclMsgWeatherForecastDataChangedUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgWeatherForecastDataChangedUpReg::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgWeatherForecastDataChangedUpReg::u16GetFunctionID() const {return WEATHERFI_C_U16_WEATHERFORECASTDATACHANGED;}
tU8 weatherfi_tclMsgWeatherForecastDataChangedUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 weatherfi_tclMsgWeatherForecastDataChangedUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weatherfi_tclMsgWeatherForecastDataChangedUpReg::operator==(const weatherfi_tclMsgWeatherForecastDataChangedUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgWeatherForecastDataChangedUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgWeatherForecastDataChangedUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgWeatherForecastDataChangedRelUpReg::weatherfi_tclMsgWeatherForecastDataChangedRelUpReg(const weatherfi_tclMsgWeatherForecastDataChangedRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgWeatherForecastDataChangedRelUpReg& weatherfi_tclMsgWeatherForecastDataChangedRelUpReg::operator=(const weatherfi_tclMsgWeatherForecastDataChangedRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgWeatherForecastDataChangedRelUpReg::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgWeatherForecastDataChangedRelUpReg::u16GetFunctionID() const {return WEATHERFI_C_U16_WEATHERFORECASTDATACHANGED;}
tU8 weatherfi_tclMsgWeatherForecastDataChangedRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 weatherfi_tclMsgWeatherForecastDataChangedRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weatherfi_tclMsgWeatherForecastDataChangedRelUpReg::operator==(const weatherfi_tclMsgWeatherForecastDataChangedRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgWeatherForecastDataChangedRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgWeatherForecastDataChangedRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgWeatherForecastDataChangedStatus::weatherfi_tclMsgWeatherForecastDataChangedStatus(const weatherfi_tclMsgWeatherForecastDataChangedStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   WeatherForecastId = coRef.WeatherForecastId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgWeatherForecastDataChangedStatus& weatherfi_tclMsgWeatherForecastDataChangedStatus::operator=(const weatherfi_tclMsgWeatherForecastDataChangedStatus& coRef)
{
   if (this == &coRef) return *this;
   WeatherForecastId = coRef.WeatherForecastId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgWeatherForecastDataChangedStatus::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgWeatherForecastDataChangedStatus::u16GetFunctionID() const {return WEATHERFI_C_U16_WEATHERFORECASTDATACHANGED;}
tU8 weatherfi_tclMsgWeatherForecastDataChangedStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 weatherfi_tclMsgWeatherForecastDataChangedStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool weatherfi_tclMsgWeatherForecastDataChangedStatus::operator==(const weatherfi_tclMsgWeatherForecastDataChangedStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (WeatherForecastId == rfoCmp.WeatherForecastId);
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgWeatherForecastDataChangedStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> WeatherForecastId;
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgWeatherForecastDataChangedStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << WeatherForecastId;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgCountyWarningDataChangedGet::weatherfi_tclMsgCountyWarningDataChangedGet(const weatherfi_tclMsgCountyWarningDataChangedGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgCountyWarningDataChangedGet& weatherfi_tclMsgCountyWarningDataChangedGet::operator=(const weatherfi_tclMsgCountyWarningDataChangedGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgCountyWarningDataChangedGet::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgCountyWarningDataChangedGet::u16GetFunctionID() const {return WEATHERFI_C_U16_COUNTYWARNINGDATACHANGED;}
tU8 weatherfi_tclMsgCountyWarningDataChangedGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 weatherfi_tclMsgCountyWarningDataChangedGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weatherfi_tclMsgCountyWarningDataChangedGet::operator==(const weatherfi_tclMsgCountyWarningDataChangedGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgCountyWarningDataChangedGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgCountyWarningDataChangedGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgCountyWarningDataChangedUpReg::weatherfi_tclMsgCountyWarningDataChangedUpReg(const weatherfi_tclMsgCountyWarningDataChangedUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgCountyWarningDataChangedUpReg& weatherfi_tclMsgCountyWarningDataChangedUpReg::operator=(const weatherfi_tclMsgCountyWarningDataChangedUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgCountyWarningDataChangedUpReg::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgCountyWarningDataChangedUpReg::u16GetFunctionID() const {return WEATHERFI_C_U16_COUNTYWARNINGDATACHANGED;}
tU8 weatherfi_tclMsgCountyWarningDataChangedUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 weatherfi_tclMsgCountyWarningDataChangedUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weatherfi_tclMsgCountyWarningDataChangedUpReg::operator==(const weatherfi_tclMsgCountyWarningDataChangedUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgCountyWarningDataChangedUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgCountyWarningDataChangedUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgCountyWarningDataChangedRelUpReg::weatherfi_tclMsgCountyWarningDataChangedRelUpReg(const weatherfi_tclMsgCountyWarningDataChangedRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgCountyWarningDataChangedRelUpReg& weatherfi_tclMsgCountyWarningDataChangedRelUpReg::operator=(const weatherfi_tclMsgCountyWarningDataChangedRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgCountyWarningDataChangedRelUpReg::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgCountyWarningDataChangedRelUpReg::u16GetFunctionID() const {return WEATHERFI_C_U16_COUNTYWARNINGDATACHANGED;}
tU8 weatherfi_tclMsgCountyWarningDataChangedRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 weatherfi_tclMsgCountyWarningDataChangedRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weatherfi_tclMsgCountyWarningDataChangedRelUpReg::operator==(const weatherfi_tclMsgCountyWarningDataChangedRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgCountyWarningDataChangedRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgCountyWarningDataChangedRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgCountyWarningDataChangedStatus::weatherfi_tclMsgCountyWarningDataChangedStatus(const weatherfi_tclMsgCountyWarningDataChangedStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   CountyWarningId = coRef.CountyWarningId;
   CountyWarningSubId = coRef.CountyWarningSubId;
   SubstantialChange = coRef.SubstantialChange;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgCountyWarningDataChangedStatus& weatherfi_tclMsgCountyWarningDataChangedStatus::operator=(const weatherfi_tclMsgCountyWarningDataChangedStatus& coRef)
{
   if (this == &coRef) return *this;
   CountyWarningId = coRef.CountyWarningId;
   CountyWarningSubId = coRef.CountyWarningSubId;
   SubstantialChange = coRef.SubstantialChange;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgCountyWarningDataChangedStatus::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgCountyWarningDataChangedStatus::u16GetFunctionID() const {return WEATHERFI_C_U16_COUNTYWARNINGDATACHANGED;}
tU8 weatherfi_tclMsgCountyWarningDataChangedStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 weatherfi_tclMsgCountyWarningDataChangedStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (2 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   return u32DynamicSize+5;
}

tBool weatherfi_tclMsgCountyWarningDataChangedStatus::operator==(const weatherfi_tclMsgCountyWarningDataChangedStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (CountyWarningId == rfoCmp.CountyWarningId);
      bResult = bResult && (CountyWarningSubId == rfoCmp.CountyWarningSubId);
      bResult = bResult && (SubstantialChange == rfoCmp.SubstantialChange);
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgCountyWarningDataChangedStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> CountyWarningId;
   if (2 <= oIn.u16GetMajorVersion())
   {
      oIn >> CountyWarningSubId;
   }
   oIn >> SubstantialChange;
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgCountyWarningDataChangedStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << CountyWarningId;
   if (2 <= oOut.u16GetMajorVersion())
   {
      oOut << CountyWarningSubId;
   }
   oOut << SubstantialChange;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgTabularWeatherDataGet::weatherfi_tclMsgTabularWeatherDataGet(const weatherfi_tclMsgTabularWeatherDataGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgTabularWeatherDataGet& weatherfi_tclMsgTabularWeatherDataGet::operator=(const weatherfi_tclMsgTabularWeatherDataGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgTabularWeatherDataGet::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgTabularWeatherDataGet::u16GetFunctionID() const {return WEATHERFI_C_U16_TABULARWEATHERDATA;}
tU8 weatherfi_tclMsgTabularWeatherDataGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 weatherfi_tclMsgTabularWeatherDataGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weatherfi_tclMsgTabularWeatherDataGet::operator==(const weatherfi_tclMsgTabularWeatherDataGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgTabularWeatherDataGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgTabularWeatherDataGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgTabularWeatherDataUpReg::weatherfi_tclMsgTabularWeatherDataUpReg(const weatherfi_tclMsgTabularWeatherDataUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgTabularWeatherDataUpReg& weatherfi_tclMsgTabularWeatherDataUpReg::operator=(const weatherfi_tclMsgTabularWeatherDataUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgTabularWeatherDataUpReg::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgTabularWeatherDataUpReg::u16GetFunctionID() const {return WEATHERFI_C_U16_TABULARWEATHERDATA;}
tU8 weatherfi_tclMsgTabularWeatherDataUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 weatherfi_tclMsgTabularWeatherDataUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weatherfi_tclMsgTabularWeatherDataUpReg::operator==(const weatherfi_tclMsgTabularWeatherDataUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgTabularWeatherDataUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgTabularWeatherDataUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgTabularWeatherDataRelUpReg::weatherfi_tclMsgTabularWeatherDataRelUpReg(const weatherfi_tclMsgTabularWeatherDataRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgTabularWeatherDataRelUpReg& weatherfi_tclMsgTabularWeatherDataRelUpReg::operator=(const weatherfi_tclMsgTabularWeatherDataRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgTabularWeatherDataRelUpReg::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgTabularWeatherDataRelUpReg::u16GetFunctionID() const {return WEATHERFI_C_U16_TABULARWEATHERDATA;}
tU8 weatherfi_tclMsgTabularWeatherDataRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 weatherfi_tclMsgTabularWeatherDataRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weatherfi_tclMsgTabularWeatherDataRelUpReg::operator==(const weatherfi_tclMsgTabularWeatherDataRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgTabularWeatherDataRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgTabularWeatherDataRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgTabularWeatherDataStatus::weatherfi_tclMsgTabularWeatherDataStatus(const weatherfi_tclMsgTabularWeatherDataStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   VersionsForForecasts = coRef.VersionsForForecasts;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgTabularWeatherDataStatus& weatherfi_tclMsgTabularWeatherDataStatus::operator=(const weatherfi_tclMsgTabularWeatherDataStatus& coRef)
{
   if (this == &coRef) return *this;
   VersionsForForecasts = coRef.VersionsForForecasts;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgTabularWeatherDataStatus::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgTabularWeatherDataStatus::u16GetFunctionID() const {return WEATHERFI_C_U16_TABULARWEATHERDATA;}
tU8 weatherfi_tclMsgTabularWeatherDataStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid weatherfi_tclMsgTabularWeatherDataStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < VersionsForForecasts.size(); ++u32Idx)
         VersionsForForecasts[u32Idx].vDestroy();
   }
   VersionsForForecasts.clear();
}

tU32 weatherfi_tclMsgTabularWeatherDataStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+VersionsForForecasts.size()*5;
}

tBool weatherfi_tclMsgTabularWeatherDataStatus::operator==(const weatherfi_tclMsgTabularWeatherDataStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (VersionsForForecasts.size() == rfoCmp.VersionsForForecasts.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < VersionsForForecasts.size()); ++u32Idx)
            bResult = bResult && (VersionsForForecasts[u32Idx] == rfoCmp.VersionsForForecasts[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgTabularWeatherDataStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < VersionsForForecasts.size(); ++u32Idx)
      {
         VersionsForForecasts[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      VersionsForForecasts.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> VersionsForForecasts[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgTabularWeatherDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)VersionsForForecasts.size();
   {
      for (tU32 u32Idx = 0; u32Idx < VersionsForForecasts.size(); ++u32Idx)
         oOut << VersionsForForecasts[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgTabularWeatherSkiConditionDataGet::weatherfi_tclMsgTabularWeatherSkiConditionDataGet(const weatherfi_tclMsgTabularWeatherSkiConditionDataGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgTabularWeatherSkiConditionDataGet& weatherfi_tclMsgTabularWeatherSkiConditionDataGet::operator=(const weatherfi_tclMsgTabularWeatherSkiConditionDataGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgTabularWeatherSkiConditionDataGet::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgTabularWeatherSkiConditionDataGet::u16GetFunctionID() const {return WEATHERFI_C_U16_TABULARWEATHERSKICONDITIONDATA;}
tU8 weatherfi_tclMsgTabularWeatherSkiConditionDataGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 weatherfi_tclMsgTabularWeatherSkiConditionDataGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weatherfi_tclMsgTabularWeatherSkiConditionDataGet::operator==(const weatherfi_tclMsgTabularWeatherSkiConditionDataGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgTabularWeatherSkiConditionDataGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgTabularWeatherSkiConditionDataGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgTabularWeatherSkiConditionDataUpReg::weatherfi_tclMsgTabularWeatherSkiConditionDataUpReg(const weatherfi_tclMsgTabularWeatherSkiConditionDataUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgTabularWeatherSkiConditionDataUpReg& weatherfi_tclMsgTabularWeatherSkiConditionDataUpReg::operator=(const weatherfi_tclMsgTabularWeatherSkiConditionDataUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgTabularWeatherSkiConditionDataUpReg::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgTabularWeatherSkiConditionDataUpReg::u16GetFunctionID() const {return WEATHERFI_C_U16_TABULARWEATHERSKICONDITIONDATA;}
tU8 weatherfi_tclMsgTabularWeatherSkiConditionDataUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 weatherfi_tclMsgTabularWeatherSkiConditionDataUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weatherfi_tclMsgTabularWeatherSkiConditionDataUpReg::operator==(const weatherfi_tclMsgTabularWeatherSkiConditionDataUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgTabularWeatherSkiConditionDataUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgTabularWeatherSkiConditionDataUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgTabularWeatherSkiConditionDataRelUpReg::weatherfi_tclMsgTabularWeatherSkiConditionDataRelUpReg(const weatherfi_tclMsgTabularWeatherSkiConditionDataRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgTabularWeatherSkiConditionDataRelUpReg& weatherfi_tclMsgTabularWeatherSkiConditionDataRelUpReg::operator=(const weatherfi_tclMsgTabularWeatherSkiConditionDataRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgTabularWeatherSkiConditionDataRelUpReg::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgTabularWeatherSkiConditionDataRelUpReg::u16GetFunctionID() const {return WEATHERFI_C_U16_TABULARWEATHERSKICONDITIONDATA;}
tU8 weatherfi_tclMsgTabularWeatherSkiConditionDataRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 weatherfi_tclMsgTabularWeatherSkiConditionDataRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weatherfi_tclMsgTabularWeatherSkiConditionDataRelUpReg::operator==(const weatherfi_tclMsgTabularWeatherSkiConditionDataRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgTabularWeatherSkiConditionDataRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgTabularWeatherSkiConditionDataRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgTabularWeatherSkiConditionDataStatus::weatherfi_tclMsgTabularWeatherSkiConditionDataStatus(const weatherfi_tclMsgTabularWeatherSkiConditionDataStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   TabularWeatherSkConditionVersionId = coRef.TabularWeatherSkConditionVersionId;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgTabularWeatherSkiConditionDataStatus& weatherfi_tclMsgTabularWeatherSkiConditionDataStatus::operator=(const weatherfi_tclMsgTabularWeatherSkiConditionDataStatus& coRef)
{
   if (this == &coRef) return *this;
   TabularWeatherSkConditionVersionId = coRef.TabularWeatherSkConditionVersionId;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgTabularWeatherSkiConditionDataStatus::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgTabularWeatherSkiConditionDataStatus::u16GetFunctionID() const {return WEATHERFI_C_U16_TABULARWEATHERSKICONDITIONDATA;}
tU8 weatherfi_tclMsgTabularWeatherSkiConditionDataStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 weatherfi_tclMsgTabularWeatherSkiConditionDataStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool weatherfi_tclMsgTabularWeatherSkiConditionDataStatus::operator==(const weatherfi_tclMsgTabularWeatherSkiConditionDataStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TabularWeatherSkConditionVersionId == rfoCmp.TabularWeatherSkConditionVersionId);
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgTabularWeatherSkiConditionDataStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> TabularWeatherSkConditionVersionId;
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgTabularWeatherSkiConditionDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TabularWeatherSkConditionVersionId;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgWeatherAlertDataGet::weatherfi_tclMsgWeatherAlertDataGet(const weatherfi_tclMsgWeatherAlertDataGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgWeatherAlertDataGet& weatherfi_tclMsgWeatherAlertDataGet::operator=(const weatherfi_tclMsgWeatherAlertDataGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgWeatherAlertDataGet::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgWeatherAlertDataGet::u16GetFunctionID() const {return WEATHERFI_C_U16_WEATHERALERTDATA;}
tU8 weatherfi_tclMsgWeatherAlertDataGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 weatherfi_tclMsgWeatherAlertDataGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weatherfi_tclMsgWeatherAlertDataGet::operator==(const weatherfi_tclMsgWeatherAlertDataGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgWeatherAlertDataGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgWeatherAlertDataGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgWeatherAlertDataUpReg::weatherfi_tclMsgWeatherAlertDataUpReg(const weatherfi_tclMsgWeatherAlertDataUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgWeatherAlertDataUpReg& weatherfi_tclMsgWeatherAlertDataUpReg::operator=(const weatherfi_tclMsgWeatherAlertDataUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgWeatherAlertDataUpReg::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgWeatherAlertDataUpReg::u16GetFunctionID() const {return WEATHERFI_C_U16_WEATHERALERTDATA;}
tU8 weatherfi_tclMsgWeatherAlertDataUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 weatherfi_tclMsgWeatherAlertDataUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weatherfi_tclMsgWeatherAlertDataUpReg::operator==(const weatherfi_tclMsgWeatherAlertDataUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgWeatherAlertDataUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgWeatherAlertDataUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgWeatherAlertDataRelUpReg::weatherfi_tclMsgWeatherAlertDataRelUpReg(const weatherfi_tclMsgWeatherAlertDataRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgWeatherAlertDataRelUpReg& weatherfi_tclMsgWeatherAlertDataRelUpReg::operator=(const weatherfi_tclMsgWeatherAlertDataRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgWeatherAlertDataRelUpReg::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgWeatherAlertDataRelUpReg::u16GetFunctionID() const {return WEATHERFI_C_U16_WEATHERALERTDATA;}
tU8 weatherfi_tclMsgWeatherAlertDataRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 weatherfi_tclMsgWeatherAlertDataRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weatherfi_tclMsgWeatherAlertDataRelUpReg::operator==(const weatherfi_tclMsgWeatherAlertDataRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgWeatherAlertDataRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgWeatherAlertDataRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgWeatherAlertDataStatus::weatherfi_tclMsgWeatherAlertDataStatus(const weatherfi_tclMsgWeatherAlertDataStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   StatesAndAreasPerLanguage = coRef.StatesAndAreasPerLanguage;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgWeatherAlertDataStatus& weatherfi_tclMsgWeatherAlertDataStatus::operator=(const weatherfi_tclMsgWeatherAlertDataStatus& coRef)
{
   if (this == &coRef) return *this;
   StatesAndAreasPerLanguage = coRef.StatesAndAreasPerLanguage;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgWeatherAlertDataStatus::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgWeatherAlertDataStatus::u16GetFunctionID() const {return WEATHERFI_C_U16_WEATHERALERTDATA;}
tU8 weatherfi_tclMsgWeatherAlertDataStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid weatherfi_tclMsgWeatherAlertDataStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < StatesAndAreasPerLanguage.size(); ++u32Idx)
         StatesAndAreasPerLanguage[u32Idx].vDestroy();
   }
   StatesAndAreasPerLanguage.clear();
}

tU32 weatherfi_tclMsgWeatherAlertDataStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < StatesAndAreasPerLanguage.size(); ++u32ListIdx)
      u32DynamicSize += StatesAndAreasPerLanguage[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool weatherfi_tclMsgWeatherAlertDataStatus::operator==(const weatherfi_tclMsgWeatherAlertDataStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (StatesAndAreasPerLanguage.size() == rfoCmp.StatesAndAreasPerLanguage.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < StatesAndAreasPerLanguage.size()); ++u32Idx)
            bResult = bResult && (StatesAndAreasPerLanguage[u32Idx] == rfoCmp.StatesAndAreasPerLanguage[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgWeatherAlertDataStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < StatesAndAreasPerLanguage.size(); ++u32Idx)
      {
         StatesAndAreasPerLanguage[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      StatesAndAreasPerLanguage.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> StatesAndAreasPerLanguage[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgWeatherAlertDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)StatesAndAreasPerLanguage.size();
   {
      for (tU32 u32Idx = 0; u32Idx < StatesAndAreasPerLanguage.size(); ++u32Idx)
         oOut << StatesAndAreasPerLanguage[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryGet::weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryGet(const weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryGet& weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryGet::operator=(const weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryGet::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryGet::u16GetFunctionID() const {return WEATHERFI_C_U16_GRAPHICALWEATHERRASTERTILESHAREDMEMORY;}
tU8 weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryGet::operator==(const weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryUpReg::weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryUpReg(const weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryUpReg& weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryUpReg::operator=(const weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryUpReg::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryUpReg::u16GetFunctionID() const {return WEATHERFI_C_U16_GRAPHICALWEATHERRASTERTILESHAREDMEMORY;}
tU8 weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryUpReg::operator==(const weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryRelUpReg::weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryRelUpReg(const weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryRelUpReg& weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryRelUpReg::operator=(const weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryRelUpReg::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryRelUpReg::u16GetFunctionID() const {return WEATHERFI_C_U16_GRAPHICALWEATHERRASTERTILESHAREDMEMORY;}
tU8 weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryRelUpReg::operator==(const weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryStatus::weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryStatus(const weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   ProductType = coRef.ProductType;
   PictureType = coRef.PictureType;
   FormatVersion = coRef.FormatVersion;
   Open = coRef.Open;
   SharedMemoryOverview = coRef.SharedMemoryOverview;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryStatus& weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryStatus::operator=(const weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryStatus& coRef)
{
   if (this == &coRef) return *this;
   ProductType = coRef.ProductType;
   PictureType = coRef.PictureType;
   FormatVersion = coRef.FormatVersion;
   Open = coRef.Open;
   SharedMemoryOverview = coRef.SharedMemoryOverview;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryStatus::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryStatus::u16GetFunctionID() const {return WEATHERFI_C_U16_GRAPHICALWEATHERRASTERTILESHAREDMEMORY;}
tU8 weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryStatus::vDestroy()
{
   SharedMemoryOverview.vDestroy(); 
}

tU32 weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+SharedMemoryOverview.u32GetSize(u16MajorVersion);
}

tBool weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryStatus::operator==(const weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ProductType == rfoCmp.ProductType);
      bResult = bResult && (PictureType == rfoCmp.PictureType);
      bResult = bResult && (FormatVersion == rfoCmp.FormatVersion);
      bResult = bResult && (Open == rfoCmp.Open);
      bResult = bResult && (SharedMemoryOverview == rfoCmp.SharedMemoryOverview);
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> ProductType;
   oIn >> PictureType;
   oIn >> FormatVersion;
   oIn >> Open;
   oIn >> SharedMemoryOverview;
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgGraphicalWeatherRasterTileSharedMemoryStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ProductType;
   oOut << PictureType;
   oOut << FormatVersion;
   oOut << Open;
   oOut << SharedMemoryOverview;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryGet::weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryGet(const weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryGet& weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryGet::operator=(const weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryGet::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryGet::u16GetFunctionID() const {return WEATHERFI_C_U16_GRAPHICALWEATHERRADARANIMATIONSHAREDMEMORY;}
tU8 weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryGet::operator==(const weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryUpReg::weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryUpReg(const weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryUpReg& weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryUpReg::operator=(const weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryUpReg::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryUpReg::u16GetFunctionID() const {return WEATHERFI_C_U16_GRAPHICALWEATHERRADARANIMATIONSHAREDMEMORY;}
tU8 weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryUpReg::operator==(const weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryRelUpReg::weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryRelUpReg(const weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryRelUpReg& weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryRelUpReg::operator=(const weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryRelUpReg::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryRelUpReg::u16GetFunctionID() const {return WEATHERFI_C_U16_GRAPHICALWEATHERRADARANIMATIONSHAREDMEMORY;}
tU8 weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryRelUpReg::operator==(const weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryStatus::weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryStatus(const weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   ProductType = coRef.ProductType;
   PictureType = coRef.PictureType;
   FormatVersion = coRef.FormatVersion;
   Open = coRef.Open;
   SharedMemoryOverview = coRef.SharedMemoryOverview;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryStatus& weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryStatus::operator=(const weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryStatus& coRef)
{
   if (this == &coRef) return *this;
   ProductType = coRef.ProductType;
   PictureType = coRef.PictureType;
   FormatVersion = coRef.FormatVersion;
   Open = coRef.Open;
   SharedMemoryOverview = coRef.SharedMemoryOverview;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryStatus::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryStatus::u16GetFunctionID() const {return WEATHERFI_C_U16_GRAPHICALWEATHERRADARANIMATIONSHAREDMEMORY;}
tU8 weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryStatus::vDestroy()
{
   SharedMemoryOverview.vDestroy(); 
}

tU32 weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+SharedMemoryOverview.u32GetSize(u16MajorVersion);
}

tBool weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryStatus::operator==(const weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ProductType == rfoCmp.ProductType);
      bResult = bResult && (PictureType == rfoCmp.PictureType);
      bResult = bResult && (FormatVersion == rfoCmp.FormatVersion);
      bResult = bResult && (Open == rfoCmp.Open);
      bResult = bResult && (SharedMemoryOverview == rfoCmp.SharedMemoryOverview);
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> ProductType;
   oIn >> PictureType;
   oIn >> FormatVersion;
   oIn >> Open;
   oIn >> SharedMemoryOverview;
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgGraphicalWeatherRadarAnimationSharedMemoryStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ProductType;
   oOut << PictureType;
   oOut << FormatVersion;
   oOut << Open;
   oOut << SharedMemoryOverview;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGraphicalWeatherTilePictureDataGet::weatherfi_tclMsgGraphicalWeatherTilePictureDataGet(const weatherfi_tclMsgGraphicalWeatherTilePictureDataGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGraphicalWeatherTilePictureDataGet& weatherfi_tclMsgGraphicalWeatherTilePictureDataGet::operator=(const weatherfi_tclMsgGraphicalWeatherTilePictureDataGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgGraphicalWeatherTilePictureDataGet::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgGraphicalWeatherTilePictureDataGet::u16GetFunctionID() const {return WEATHERFI_C_U16_GRAPHICALWEATHERTILEPICTUREDATA;}
tU8 weatherfi_tclMsgGraphicalWeatherTilePictureDataGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 weatherfi_tclMsgGraphicalWeatherTilePictureDataGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weatherfi_tclMsgGraphicalWeatherTilePictureDataGet::operator==(const weatherfi_tclMsgGraphicalWeatherTilePictureDataGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgGraphicalWeatherTilePictureDataGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgGraphicalWeatherTilePictureDataGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGraphicalWeatherTilePictureDataUpReg::weatherfi_tclMsgGraphicalWeatherTilePictureDataUpReg(const weatherfi_tclMsgGraphicalWeatherTilePictureDataUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGraphicalWeatherTilePictureDataUpReg& weatherfi_tclMsgGraphicalWeatherTilePictureDataUpReg::operator=(const weatherfi_tclMsgGraphicalWeatherTilePictureDataUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgGraphicalWeatherTilePictureDataUpReg::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgGraphicalWeatherTilePictureDataUpReg::u16GetFunctionID() const {return WEATHERFI_C_U16_GRAPHICALWEATHERTILEPICTUREDATA;}
tU8 weatherfi_tclMsgGraphicalWeatherTilePictureDataUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 weatherfi_tclMsgGraphicalWeatherTilePictureDataUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weatherfi_tclMsgGraphicalWeatherTilePictureDataUpReg::operator==(const weatherfi_tclMsgGraphicalWeatherTilePictureDataUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgGraphicalWeatherTilePictureDataUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgGraphicalWeatherTilePictureDataUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGraphicalWeatherTilePictureDataRelUpReg::weatherfi_tclMsgGraphicalWeatherTilePictureDataRelUpReg(const weatherfi_tclMsgGraphicalWeatherTilePictureDataRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGraphicalWeatherTilePictureDataRelUpReg& weatherfi_tclMsgGraphicalWeatherTilePictureDataRelUpReg::operator=(const weatherfi_tclMsgGraphicalWeatherTilePictureDataRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgGraphicalWeatherTilePictureDataRelUpReg::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgGraphicalWeatherTilePictureDataRelUpReg::u16GetFunctionID() const {return WEATHERFI_C_U16_GRAPHICALWEATHERTILEPICTUREDATA;}
tU8 weatherfi_tclMsgGraphicalWeatherTilePictureDataRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 weatherfi_tclMsgGraphicalWeatherTilePictureDataRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weatherfi_tclMsgGraphicalWeatherTilePictureDataRelUpReg::operator==(const weatherfi_tclMsgGraphicalWeatherTilePictureDataRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgGraphicalWeatherTilePictureDataRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgGraphicalWeatherTilePictureDataRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGraphicalWeatherTilePictureDataStatus::weatherfi_tclMsgGraphicalWeatherTilePictureDataStatus(const weatherfi_tclMsgGraphicalWeatherTilePictureDataStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   ProductType = coRef.ProductType;
   PictureType = coRef.PictureType;
   UsedTiles = coRef.UsedTiles;
   BackgroundTiles = coRef.BackgroundTiles;
   PresentedPictures = coRef.PresentedPictures;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGraphicalWeatherTilePictureDataStatus& weatherfi_tclMsgGraphicalWeatherTilePictureDataStatus::operator=(const weatherfi_tclMsgGraphicalWeatherTilePictureDataStatus& coRef)
{
   if (this == &coRef) return *this;
   ProductType = coRef.ProductType;
   PictureType = coRef.PictureType;
   UsedTiles = coRef.UsedTiles;
   BackgroundTiles = coRef.BackgroundTiles;
   PresentedPictures = coRef.PresentedPictures;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgGraphicalWeatherTilePictureDataStatus::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgGraphicalWeatherTilePictureDataStatus::u16GetFunctionID() const {return WEATHERFI_C_U16_GRAPHICALWEATHERTILEPICTUREDATA;}
tU8 weatherfi_tclMsgGraphicalWeatherTilePictureDataStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid weatherfi_tclMsgGraphicalWeatherTilePictureDataStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < UsedTiles.size(); ++u32Idx)
         UsedTiles[u32Idx].vDestroy();
   }
   UsedTiles.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < BackgroundTiles.size(); ++u32Idx)
         BackgroundTiles[u32Idx].vDestroy();
   }
   BackgroundTiles.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < PresentedPictures.size(); ++u32Idx)
         PresentedPictures[u32Idx].vDestroy();
   }
   PresentedPictures.clear();
}

tU32 weatherfi_tclMsgGraphicalWeatherTilePictureDataStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < UsedTiles.size(); ++u32ListIdx)
      u32DynamicSize += UsedTiles[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < BackgroundTiles.size(); ++u32ListIdx)
      u32DynamicSize += BackgroundTiles[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < PresentedPictures.size(); ++u32ListIdx)
      u32DynamicSize += PresentedPictures[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+14;
}

tBool weatherfi_tclMsgGraphicalWeatherTilePictureDataStatus::operator==(const weatherfi_tclMsgGraphicalWeatherTilePictureDataStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ProductType == rfoCmp.ProductType);
      bResult = bResult && (PictureType == rfoCmp.PictureType);
      bResult = bResult && (UsedTiles.size() == rfoCmp.UsedTiles.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < UsedTiles.size()); ++u32Idx)
            bResult = bResult && (UsedTiles[u32Idx] == rfoCmp.UsedTiles[u32Idx]);
      }
      bResult = bResult && (BackgroundTiles.size() == rfoCmp.BackgroundTiles.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < BackgroundTiles.size()); ++u32Idx)
            bResult = bResult && (BackgroundTiles[u32Idx] == rfoCmp.BackgroundTiles[u32Idx]);
      }
      bResult = bResult && (PresentedPictures.size() == rfoCmp.PresentedPictures.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PresentedPictures.size()); ++u32Idx)
            bResult = bResult && (PresentedPictures[u32Idx] == rfoCmp.PresentedPictures[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgGraphicalWeatherTilePictureDataStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> ProductType;
   oIn >> PictureType;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < UsedTiles.size(); ++u32Idx)
      {
         UsedTiles[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      UsedTiles.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> UsedTiles[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < BackgroundTiles.size(); ++u32Idx)
      {
         BackgroundTiles[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      BackgroundTiles.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> BackgroundTiles[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < PresentedPictures.size(); ++u32Idx)
      {
         PresentedPictures[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      PresentedPictures.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> PresentedPictures[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgGraphicalWeatherTilePictureDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ProductType;
   oOut << PictureType;
   oOut << (tU32)UsedTiles.size();
   {
      for (tU32 u32Idx = 0; u32Idx < UsedTiles.size(); ++u32Idx)
         oOut << UsedTiles[u32Idx];
   }
   oOut << (tU32)BackgroundTiles.size();
   {
      for (tU32 u32Idx = 0; u32Idx < BackgroundTiles.size(); ++u32Idx)
         oOut << BackgroundTiles[u32Idx];
   }
   oOut << (tU32)PresentedPictures.size();
   {
      for (tU32 u32Idx = 0; u32Idx < PresentedPictures.size(); ++u32Idx)
         oOut << PresentedPictures[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataGet::weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataGet(const weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataGet& weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataGet::operator=(const weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataGet::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataGet::u16GetFunctionID() const {return WEATHERFI_C_U16_GRAPHICALWEATHERRADARANIMATIONPICTUREDATA;}
tU8 weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataGet::operator==(const weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataUpReg::weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataUpReg(const weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataUpReg& weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataUpReg::operator=(const weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataUpReg::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataUpReg::u16GetFunctionID() const {return WEATHERFI_C_U16_GRAPHICALWEATHERRADARANIMATIONPICTUREDATA;}
tU8 weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataUpReg::operator==(const weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataRelUpReg::weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataRelUpReg(const weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataRelUpReg& weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataRelUpReg::operator=(const weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataRelUpReg::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataRelUpReg::u16GetFunctionID() const {return WEATHERFI_C_U16_GRAPHICALWEATHERRADARANIMATIONPICTUREDATA;}
tU8 weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataRelUpReg::operator==(const weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataStatus::weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataStatus(const weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   ProductType = coRef.ProductType;
   PictureType = coRef.PictureType;
   UsedTiles = coRef.UsedTiles;
   BackgroundTiles = coRef.BackgroundTiles;
   PresentedPictures = coRef.PresentedPictures;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataStatus& weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataStatus::operator=(const weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataStatus& coRef)
{
   if (this == &coRef) return *this;
   ProductType = coRef.ProductType;
   PictureType = coRef.PictureType;
   UsedTiles = coRef.UsedTiles;
   BackgroundTiles = coRef.BackgroundTiles;
   PresentedPictures = coRef.PresentedPictures;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataStatus::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataStatus::u16GetFunctionID() const {return WEATHERFI_C_U16_GRAPHICALWEATHERRADARANIMATIONPICTUREDATA;}
tU8 weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < UsedTiles.size(); ++u32Idx)
         UsedTiles[u32Idx].vDestroy();
   }
   UsedTiles.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < BackgroundTiles.size(); ++u32Idx)
         BackgroundTiles[u32Idx].vDestroy();
   }
   BackgroundTiles.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < PresentedPictures.size(); ++u32Idx)
         PresentedPictures[u32Idx].vDestroy();
   }
   PresentedPictures.clear();
}

tU32 weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < UsedTiles.size(); ++u32ListIdx)
      u32DynamicSize += UsedTiles[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < BackgroundTiles.size(); ++u32ListIdx)
      u32DynamicSize += BackgroundTiles[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < PresentedPictures.size(); ++u32ListIdx)
      u32DynamicSize += PresentedPictures[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+14;
}

tBool weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataStatus::operator==(const weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ProductType == rfoCmp.ProductType);
      bResult = bResult && (PictureType == rfoCmp.PictureType);
      bResult = bResult && (UsedTiles.size() == rfoCmp.UsedTiles.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < UsedTiles.size()); ++u32Idx)
            bResult = bResult && (UsedTiles[u32Idx] == rfoCmp.UsedTiles[u32Idx]);
      }
      bResult = bResult && (BackgroundTiles.size() == rfoCmp.BackgroundTiles.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < BackgroundTiles.size()); ++u32Idx)
            bResult = bResult && (BackgroundTiles[u32Idx] == rfoCmp.BackgroundTiles[u32Idx]);
      }
      bResult = bResult && (PresentedPictures.size() == rfoCmp.PresentedPictures.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PresentedPictures.size()); ++u32Idx)
            bResult = bResult && (PresentedPictures[u32Idx] == rfoCmp.PresentedPictures[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> ProductType;
   oIn >> PictureType;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < UsedTiles.size(); ++u32Idx)
      {
         UsedTiles[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      UsedTiles.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> UsedTiles[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < BackgroundTiles.size(); ++u32Idx)
      {
         BackgroundTiles[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      BackgroundTiles.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> BackgroundTiles[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < PresentedPictures.size(); ++u32Idx)
      {
         PresentedPictures[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      PresentedPictures.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> PresentedPictures[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgGraphicalWeatherRadarAnimationPictureDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ProductType;
   oOut << PictureType;
   oOut << (tU32)UsedTiles.size();
   {
      for (tU32 u32Idx = 0; u32Idx < UsedTiles.size(); ++u32Idx)
         oOut << UsedTiles[u32Idx];
   }
   oOut << (tU32)BackgroundTiles.size();
   {
      for (tU32 u32Idx = 0; u32Idx < BackgroundTiles.size(); ++u32Idx)
         oOut << BackgroundTiles[u32Idx];
   }
   oOut << (tU32)PresentedPictures.size();
   {
      for (tU32 u32Idx = 0; u32Idx < PresentedPictures.size(); ++u32Idx)
         oOut << PresentedPictures[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgSurfaceDataUpReg::weatherfi_tclMsgSurfaceDataUpReg(const weatherfi_tclMsgSurfaceDataUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgSurfaceDataUpReg& weatherfi_tclMsgSurfaceDataUpReg::operator=(const weatherfi_tclMsgSurfaceDataUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgSurfaceDataUpReg::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgSurfaceDataUpReg::u16GetFunctionID() const {return WEATHERFI_C_U16_SURFACEDATA;}
tU8 weatherfi_tclMsgSurfaceDataUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 weatherfi_tclMsgSurfaceDataUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weatherfi_tclMsgSurfaceDataUpReg::operator==(const weatherfi_tclMsgSurfaceDataUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgSurfaceDataUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgSurfaceDataUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgSurfaceDataRelUpReg::weatherfi_tclMsgSurfaceDataRelUpReg(const weatherfi_tclMsgSurfaceDataRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgSurfaceDataRelUpReg& weatherfi_tclMsgSurfaceDataRelUpReg::operator=(const weatherfi_tclMsgSurfaceDataRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgSurfaceDataRelUpReg::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgSurfaceDataRelUpReg::u16GetFunctionID() const {return WEATHERFI_C_U16_SURFACEDATA;}
tU8 weatherfi_tclMsgSurfaceDataRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 weatherfi_tclMsgSurfaceDataRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weatherfi_tclMsgSurfaceDataRelUpReg::operator==(const weatherfi_tclMsgSurfaceDataRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgSurfaceDataRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgSurfaceDataRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgSurfaceDataGet::weatherfi_tclMsgSurfaceDataGet(const weatherfi_tclMsgSurfaceDataGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgSurfaceDataGet& weatherfi_tclMsgSurfaceDataGet::operator=(const weatherfi_tclMsgSurfaceDataGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgSurfaceDataGet::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgSurfaceDataGet::u16GetFunctionID() const {return WEATHERFI_C_U16_SURFACEDATA;}
tU8 weatherfi_tclMsgSurfaceDataGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 weatherfi_tclMsgSurfaceDataGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weatherfi_tclMsgSurfaceDataGet::operator==(const weatherfi_tclMsgSurfaceDataGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgSurfaceDataGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgSurfaceDataGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgSurfaceDataStatus::weatherfi_tclMsgSurfaceDataStatus(const weatherfi_tclMsgSurfaceDataStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   UpdateCounter = coRef.UpdateCounter;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgSurfaceDataStatus& weatherfi_tclMsgSurfaceDataStatus::operator=(const weatherfi_tclMsgSurfaceDataStatus& coRef)
{
   if (this == &coRef) return *this;
   UpdateCounter = coRef.UpdateCounter;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgSurfaceDataStatus::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgSurfaceDataStatus::u16GetFunctionID() const {return WEATHERFI_C_U16_SURFACEDATA;}
tU8 weatherfi_tclMsgSurfaceDataStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 weatherfi_tclMsgSurfaceDataStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool weatherfi_tclMsgSurfaceDataStatus::operator==(const weatherfi_tclMsgSurfaceDataStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UpdateCounter == rfoCmp.UpdateCounter);
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgSurfaceDataStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> UpdateCounter;
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgSurfaceDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UpdateCounter;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgStormAttributesDataUpReg::weatherfi_tclMsgStormAttributesDataUpReg(const weatherfi_tclMsgStormAttributesDataUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgStormAttributesDataUpReg& weatherfi_tclMsgStormAttributesDataUpReg::operator=(const weatherfi_tclMsgStormAttributesDataUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgStormAttributesDataUpReg::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgStormAttributesDataUpReg::u16GetFunctionID() const {return WEATHERFI_C_U16_STORMATTRIBUTESDATA;}
tU8 weatherfi_tclMsgStormAttributesDataUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 weatherfi_tclMsgStormAttributesDataUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weatherfi_tclMsgStormAttributesDataUpReg::operator==(const weatherfi_tclMsgStormAttributesDataUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgStormAttributesDataUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgStormAttributesDataUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgStormAttributesDataRelUpReg::weatherfi_tclMsgStormAttributesDataRelUpReg(const weatherfi_tclMsgStormAttributesDataRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgStormAttributesDataRelUpReg& weatherfi_tclMsgStormAttributesDataRelUpReg::operator=(const weatherfi_tclMsgStormAttributesDataRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgStormAttributesDataRelUpReg::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgStormAttributesDataRelUpReg::u16GetFunctionID() const {return WEATHERFI_C_U16_STORMATTRIBUTESDATA;}
tU8 weatherfi_tclMsgStormAttributesDataRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 weatherfi_tclMsgStormAttributesDataRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weatherfi_tclMsgStormAttributesDataRelUpReg::operator==(const weatherfi_tclMsgStormAttributesDataRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgStormAttributesDataRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgStormAttributesDataRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgStormAttributesDataGet::weatherfi_tclMsgStormAttributesDataGet(const weatherfi_tclMsgStormAttributesDataGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgStormAttributesDataGet& weatherfi_tclMsgStormAttributesDataGet::operator=(const weatherfi_tclMsgStormAttributesDataGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgStormAttributesDataGet::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgStormAttributesDataGet::u16GetFunctionID() const {return WEATHERFI_C_U16_STORMATTRIBUTESDATA;}
tU8 weatherfi_tclMsgStormAttributesDataGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 weatherfi_tclMsgStormAttributesDataGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weatherfi_tclMsgStormAttributesDataGet::operator==(const weatherfi_tclMsgStormAttributesDataGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgStormAttributesDataGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgStormAttributesDataGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgStormAttributesDataStatus::weatherfi_tclMsgStormAttributesDataStatus(const weatherfi_tclMsgStormAttributesDataStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   UpdateCounter = coRef.UpdateCounter;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgStormAttributesDataStatus& weatherfi_tclMsgStormAttributesDataStatus::operator=(const weatherfi_tclMsgStormAttributesDataStatus& coRef)
{
   if (this == &coRef) return *this;
   UpdateCounter = coRef.UpdateCounter;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgStormAttributesDataStatus::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgStormAttributesDataStatus::u16GetFunctionID() const {return WEATHERFI_C_U16_STORMATTRIBUTESDATA;}
tU8 weatherfi_tclMsgStormAttributesDataStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 weatherfi_tclMsgStormAttributesDataStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool weatherfi_tclMsgStormAttributesDataStatus::operator==(const weatherfi_tclMsgStormAttributesDataStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UpdateCounter == rfoCmp.UpdateCounter);
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgStormAttributesDataStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> UpdateCounter;
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgStormAttributesDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UpdateCounter;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgStormTrackDataUpReg::weatherfi_tclMsgStormTrackDataUpReg(const weatherfi_tclMsgStormTrackDataUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgStormTrackDataUpReg& weatherfi_tclMsgStormTrackDataUpReg::operator=(const weatherfi_tclMsgStormTrackDataUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgStormTrackDataUpReg::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgStormTrackDataUpReg::u16GetFunctionID() const {return WEATHERFI_C_U16_STORMTRACKDATA;}
tU8 weatherfi_tclMsgStormTrackDataUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 weatherfi_tclMsgStormTrackDataUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weatherfi_tclMsgStormTrackDataUpReg::operator==(const weatherfi_tclMsgStormTrackDataUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgStormTrackDataUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgStormTrackDataUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgStormTrackDataRelUpReg::weatherfi_tclMsgStormTrackDataRelUpReg(const weatherfi_tclMsgStormTrackDataRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgStormTrackDataRelUpReg& weatherfi_tclMsgStormTrackDataRelUpReg::operator=(const weatherfi_tclMsgStormTrackDataRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgStormTrackDataRelUpReg::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgStormTrackDataRelUpReg::u16GetFunctionID() const {return WEATHERFI_C_U16_STORMTRACKDATA;}
tU8 weatherfi_tclMsgStormTrackDataRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 weatherfi_tclMsgStormTrackDataRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weatherfi_tclMsgStormTrackDataRelUpReg::operator==(const weatherfi_tclMsgStormTrackDataRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgStormTrackDataRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgStormTrackDataRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgStormTrackDataGet::weatherfi_tclMsgStormTrackDataGet(const weatherfi_tclMsgStormTrackDataGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgStormTrackDataGet& weatherfi_tclMsgStormTrackDataGet::operator=(const weatherfi_tclMsgStormTrackDataGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgStormTrackDataGet::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgStormTrackDataGet::u16GetFunctionID() const {return WEATHERFI_C_U16_STORMTRACKDATA;}
tU8 weatherfi_tclMsgStormTrackDataGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 weatherfi_tclMsgStormTrackDataGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weatherfi_tclMsgStormTrackDataGet::operator==(const weatherfi_tclMsgStormTrackDataGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgStormTrackDataGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgStormTrackDataGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgStormTrackDataStatus::weatherfi_tclMsgStormTrackDataStatus(const weatherfi_tclMsgStormTrackDataStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   UpdateCounter = coRef.UpdateCounter;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgStormTrackDataStatus& weatherfi_tclMsgStormTrackDataStatus::operator=(const weatherfi_tclMsgStormTrackDataStatus& coRef)
{
   if (this == &coRef) return *this;
   UpdateCounter = coRef.UpdateCounter;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgStormTrackDataStatus::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgStormTrackDataStatus::u16GetFunctionID() const {return WEATHERFI_C_U16_STORMTRACKDATA;}
tU8 weatherfi_tclMsgStormTrackDataStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 weatherfi_tclMsgStormTrackDataStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool weatherfi_tclMsgStormTrackDataStatus::operator==(const weatherfi_tclMsgStormTrackDataStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UpdateCounter == rfoCmp.UpdateCounter);
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgStormTrackDataStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> UpdateCounter;
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgStormTrackDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UpdateCounter;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgRasterTileSharedMemoriesGet::weatherfi_tclMsgRasterTileSharedMemoriesGet(const weatherfi_tclMsgRasterTileSharedMemoriesGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgRasterTileSharedMemoriesGet& weatherfi_tclMsgRasterTileSharedMemoriesGet::operator=(const weatherfi_tclMsgRasterTileSharedMemoriesGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgRasterTileSharedMemoriesGet::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgRasterTileSharedMemoriesGet::u16GetFunctionID() const {return WEATHERFI_C_U16_RASTERTILESHAREDMEMORIES;}
tU8 weatherfi_tclMsgRasterTileSharedMemoriesGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 weatherfi_tclMsgRasterTileSharedMemoriesGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weatherfi_tclMsgRasterTileSharedMemoriesGet::operator==(const weatherfi_tclMsgRasterTileSharedMemoriesGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgRasterTileSharedMemoriesGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgRasterTileSharedMemoriesGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgRasterTileSharedMemoriesUpReg::weatherfi_tclMsgRasterTileSharedMemoriesUpReg(const weatherfi_tclMsgRasterTileSharedMemoriesUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgRasterTileSharedMemoriesUpReg& weatherfi_tclMsgRasterTileSharedMemoriesUpReg::operator=(const weatherfi_tclMsgRasterTileSharedMemoriesUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgRasterTileSharedMemoriesUpReg::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgRasterTileSharedMemoriesUpReg::u16GetFunctionID() const {return WEATHERFI_C_U16_RASTERTILESHAREDMEMORIES;}
tU8 weatherfi_tclMsgRasterTileSharedMemoriesUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 weatherfi_tclMsgRasterTileSharedMemoriesUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weatherfi_tclMsgRasterTileSharedMemoriesUpReg::operator==(const weatherfi_tclMsgRasterTileSharedMemoriesUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgRasterTileSharedMemoriesUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgRasterTileSharedMemoriesUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgRasterTileSharedMemoriesRelUpReg::weatherfi_tclMsgRasterTileSharedMemoriesRelUpReg(const weatherfi_tclMsgRasterTileSharedMemoriesRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgRasterTileSharedMemoriesRelUpReg& weatherfi_tclMsgRasterTileSharedMemoriesRelUpReg::operator=(const weatherfi_tclMsgRasterTileSharedMemoriesRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgRasterTileSharedMemoriesRelUpReg::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgRasterTileSharedMemoriesRelUpReg::u16GetFunctionID() const {return WEATHERFI_C_U16_RASTERTILESHAREDMEMORIES;}
tU8 weatherfi_tclMsgRasterTileSharedMemoriesRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 weatherfi_tclMsgRasterTileSharedMemoriesRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weatherfi_tclMsgRasterTileSharedMemoriesRelUpReg::operator==(const weatherfi_tclMsgRasterTileSharedMemoriesRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgRasterTileSharedMemoriesRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgRasterTileSharedMemoriesRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgRasterTileSharedMemoriesStatus::weatherfi_tclMsgRasterTileSharedMemoriesStatus(const weatherfi_tclMsgRasterTileSharedMemoriesStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   SharedMemories = coRef.SharedMemories;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgRasterTileSharedMemoriesStatus& weatherfi_tclMsgRasterTileSharedMemoriesStatus::operator=(const weatherfi_tclMsgRasterTileSharedMemoriesStatus& coRef)
{
   if (this == &coRef) return *this;
   SharedMemories = coRef.SharedMemories;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgRasterTileSharedMemoriesStatus::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgRasterTileSharedMemoriesStatus::u16GetFunctionID() const {return WEATHERFI_C_U16_RASTERTILESHAREDMEMORIES;}
tU8 weatherfi_tclMsgRasterTileSharedMemoriesStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid weatherfi_tclMsgRasterTileSharedMemoriesStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < SharedMemories.size(); ++u32Idx)
         SharedMemories[u32Idx].vDestroy();
   }
   SharedMemories.clear();
}

tU32 weatherfi_tclMsgRasterTileSharedMemoriesStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < SharedMemories.size(); ++u32ListIdx)
      u32DynamicSize += SharedMemories[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool weatherfi_tclMsgRasterTileSharedMemoriesStatus::operator==(const weatherfi_tclMsgRasterTileSharedMemoriesStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (SharedMemories.size() == rfoCmp.SharedMemories.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SharedMemories.size()); ++u32Idx)
            bResult = bResult && (SharedMemories[u32Idx] == rfoCmp.SharedMemories[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgRasterTileSharedMemoriesStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < SharedMemories.size(); ++u32Idx)
      {
         SharedMemories[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      SharedMemories.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> SharedMemories[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgRasterTileSharedMemoriesStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)SharedMemories.size();
   {
      for (tU32 u32Idx = 0; u32Idx < SharedMemories.size(); ++u32Idx)
         oOut << SharedMemories[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgRadarStaticPictureDataGet::weatherfi_tclMsgRadarStaticPictureDataGet(const weatherfi_tclMsgRadarStaticPictureDataGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgRadarStaticPictureDataGet& weatherfi_tclMsgRadarStaticPictureDataGet::operator=(const weatherfi_tclMsgRadarStaticPictureDataGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgRadarStaticPictureDataGet::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgRadarStaticPictureDataGet::u16GetFunctionID() const {return WEATHERFI_C_U16_RADARSTATICPICTUREDATA;}
tU8 weatherfi_tclMsgRadarStaticPictureDataGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 weatherfi_tclMsgRadarStaticPictureDataGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weatherfi_tclMsgRadarStaticPictureDataGet::operator==(const weatherfi_tclMsgRadarStaticPictureDataGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgRadarStaticPictureDataGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgRadarStaticPictureDataGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgRadarStaticPictureDataUpReg::weatherfi_tclMsgRadarStaticPictureDataUpReg(const weatherfi_tclMsgRadarStaticPictureDataUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgRadarStaticPictureDataUpReg& weatherfi_tclMsgRadarStaticPictureDataUpReg::operator=(const weatherfi_tclMsgRadarStaticPictureDataUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgRadarStaticPictureDataUpReg::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgRadarStaticPictureDataUpReg::u16GetFunctionID() const {return WEATHERFI_C_U16_RADARSTATICPICTUREDATA;}
tU8 weatherfi_tclMsgRadarStaticPictureDataUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 weatherfi_tclMsgRadarStaticPictureDataUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weatherfi_tclMsgRadarStaticPictureDataUpReg::operator==(const weatherfi_tclMsgRadarStaticPictureDataUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgRadarStaticPictureDataUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgRadarStaticPictureDataUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgRadarStaticPictureDataRelUpReg::weatherfi_tclMsgRadarStaticPictureDataRelUpReg(const weatherfi_tclMsgRadarStaticPictureDataRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgRadarStaticPictureDataRelUpReg& weatherfi_tclMsgRadarStaticPictureDataRelUpReg::operator=(const weatherfi_tclMsgRadarStaticPictureDataRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgRadarStaticPictureDataRelUpReg::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgRadarStaticPictureDataRelUpReg::u16GetFunctionID() const {return WEATHERFI_C_U16_RADARSTATICPICTUREDATA;}
tU8 weatherfi_tclMsgRadarStaticPictureDataRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 weatherfi_tclMsgRadarStaticPictureDataRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weatherfi_tclMsgRadarStaticPictureDataRelUpReg::operator==(const weatherfi_tclMsgRadarStaticPictureDataRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgRadarStaticPictureDataRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgRadarStaticPictureDataRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgRadarStaticPictureDataStatus::weatherfi_tclMsgRadarStaticPictureDataStatus(const weatherfi_tclMsgRadarStaticPictureDataStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   PresentedPicture = coRef.PresentedPicture;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgRadarStaticPictureDataStatus& weatherfi_tclMsgRadarStaticPictureDataStatus::operator=(const weatherfi_tclMsgRadarStaticPictureDataStatus& coRef)
{
   if (this == &coRef) return *this;
   PresentedPicture = coRef.PresentedPicture;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgRadarStaticPictureDataStatus::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgRadarStaticPictureDataStatus::u16GetFunctionID() const {return WEATHERFI_C_U16_RADARSTATICPICTUREDATA;}
tU8 weatherfi_tclMsgRadarStaticPictureDataStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid weatherfi_tclMsgRadarStaticPictureDataStatus::vDestroy()
{
   PresentedPicture.vDestroy(); 
}

tU32 weatherfi_tclMsgRadarStaticPictureDataStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+PresentedPicture.u32GetSize(u16MajorVersion);
}

tBool weatherfi_tclMsgRadarStaticPictureDataStatus::operator==(const weatherfi_tclMsgRadarStaticPictureDataStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (PresentedPicture == rfoCmp.PresentedPicture);
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgRadarStaticPictureDataStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> PresentedPicture;
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgRadarStaticPictureDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << PresentedPicture;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgRadarAnimationDataGet::weatherfi_tclMsgRadarAnimationDataGet(const weatherfi_tclMsgRadarAnimationDataGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgRadarAnimationDataGet& weatherfi_tclMsgRadarAnimationDataGet::operator=(const weatherfi_tclMsgRadarAnimationDataGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgRadarAnimationDataGet::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgRadarAnimationDataGet::u16GetFunctionID() const {return WEATHERFI_C_U16_RADARANIMATIONDATA;}
tU8 weatherfi_tclMsgRadarAnimationDataGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 weatherfi_tclMsgRadarAnimationDataGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weatherfi_tclMsgRadarAnimationDataGet::operator==(const weatherfi_tclMsgRadarAnimationDataGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgRadarAnimationDataGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgRadarAnimationDataGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgRadarAnimationDataUpReg::weatherfi_tclMsgRadarAnimationDataUpReg(const weatherfi_tclMsgRadarAnimationDataUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgRadarAnimationDataUpReg& weatherfi_tclMsgRadarAnimationDataUpReg::operator=(const weatherfi_tclMsgRadarAnimationDataUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgRadarAnimationDataUpReg::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgRadarAnimationDataUpReg::u16GetFunctionID() const {return WEATHERFI_C_U16_RADARANIMATIONDATA;}
tU8 weatherfi_tclMsgRadarAnimationDataUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 weatherfi_tclMsgRadarAnimationDataUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weatherfi_tclMsgRadarAnimationDataUpReg::operator==(const weatherfi_tclMsgRadarAnimationDataUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgRadarAnimationDataUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgRadarAnimationDataUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgRadarAnimationDataRelUpReg::weatherfi_tclMsgRadarAnimationDataRelUpReg(const weatherfi_tclMsgRadarAnimationDataRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgRadarAnimationDataRelUpReg& weatherfi_tclMsgRadarAnimationDataRelUpReg::operator=(const weatherfi_tclMsgRadarAnimationDataRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgRadarAnimationDataRelUpReg::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgRadarAnimationDataRelUpReg::u16GetFunctionID() const {return WEATHERFI_C_U16_RADARANIMATIONDATA;}
tU8 weatherfi_tclMsgRadarAnimationDataRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 weatherfi_tclMsgRadarAnimationDataRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weatherfi_tclMsgRadarAnimationDataRelUpReg::operator==(const weatherfi_tclMsgRadarAnimationDataRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgRadarAnimationDataRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgRadarAnimationDataRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgRadarAnimationDataStatus::weatherfi_tclMsgRadarAnimationDataStatus(const weatherfi_tclMsgRadarAnimationDataStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   PresentedPictures = coRef.PresentedPictures;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgRadarAnimationDataStatus& weatherfi_tclMsgRadarAnimationDataStatus::operator=(const weatherfi_tclMsgRadarAnimationDataStatus& coRef)
{
   if (this == &coRef) return *this;
   PresentedPictures = coRef.PresentedPictures;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgRadarAnimationDataStatus::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgRadarAnimationDataStatus::u16GetFunctionID() const {return WEATHERFI_C_U16_RADARANIMATIONDATA;}
tU8 weatherfi_tclMsgRadarAnimationDataStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid weatherfi_tclMsgRadarAnimationDataStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < PresentedPictures.size(); ++u32Idx)
         PresentedPictures[u32Idx].vDestroy();
   }
   PresentedPictures.clear();
}

tU32 weatherfi_tclMsgRadarAnimationDataStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < PresentedPictures.size(); ++u32ListIdx)
      u32DynamicSize += PresentedPictures[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

tBool weatherfi_tclMsgRadarAnimationDataStatus::operator==(const weatherfi_tclMsgRadarAnimationDataStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (PresentedPictures.size() == rfoCmp.PresentedPictures.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PresentedPictures.size()); ++u32Idx)
            bResult = bResult && (PresentedPictures[u32Idx] == rfoCmp.PresentedPictures[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgRadarAnimationDataStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < PresentedPictures.size(); ++u32Idx)
      {
         PresentedPictures[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      PresentedPictures.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> PresentedPictures[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgRadarAnimationDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)PresentedPictures.size();
   {
      for (tU32 u32Idx = 0; u32Idx < PresentedPictures.size(); ++u32Idx)
         oOut << PresentedPictures[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgWindStaticPictureDataGet::weatherfi_tclMsgWindStaticPictureDataGet(const weatherfi_tclMsgWindStaticPictureDataGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgWindStaticPictureDataGet& weatherfi_tclMsgWindStaticPictureDataGet::operator=(const weatherfi_tclMsgWindStaticPictureDataGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgWindStaticPictureDataGet::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgWindStaticPictureDataGet::u16GetFunctionID() const {return WEATHERFI_C_U16_WINDSTATICPICTUREDATA;}
tU8 weatherfi_tclMsgWindStaticPictureDataGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 weatherfi_tclMsgWindStaticPictureDataGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weatherfi_tclMsgWindStaticPictureDataGet::operator==(const weatherfi_tclMsgWindStaticPictureDataGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgWindStaticPictureDataGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgWindStaticPictureDataGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgWindStaticPictureDataUpReg::weatherfi_tclMsgWindStaticPictureDataUpReg(const weatherfi_tclMsgWindStaticPictureDataUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgWindStaticPictureDataUpReg& weatherfi_tclMsgWindStaticPictureDataUpReg::operator=(const weatherfi_tclMsgWindStaticPictureDataUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgWindStaticPictureDataUpReg::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgWindStaticPictureDataUpReg::u16GetFunctionID() const {return WEATHERFI_C_U16_WINDSTATICPICTUREDATA;}
tU8 weatherfi_tclMsgWindStaticPictureDataUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 weatherfi_tclMsgWindStaticPictureDataUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weatherfi_tclMsgWindStaticPictureDataUpReg::operator==(const weatherfi_tclMsgWindStaticPictureDataUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgWindStaticPictureDataUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgWindStaticPictureDataUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgWindStaticPictureDataRelUpReg::weatherfi_tclMsgWindStaticPictureDataRelUpReg(const weatherfi_tclMsgWindStaticPictureDataRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgWindStaticPictureDataRelUpReg& weatherfi_tclMsgWindStaticPictureDataRelUpReg::operator=(const weatherfi_tclMsgWindStaticPictureDataRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgWindStaticPictureDataRelUpReg::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgWindStaticPictureDataRelUpReg::u16GetFunctionID() const {return WEATHERFI_C_U16_WINDSTATICPICTUREDATA;}
tU8 weatherfi_tclMsgWindStaticPictureDataRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 weatherfi_tclMsgWindStaticPictureDataRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weatherfi_tclMsgWindStaticPictureDataRelUpReg::operator==(const weatherfi_tclMsgWindStaticPictureDataRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgWindStaticPictureDataRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgWindStaticPictureDataRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgWindStaticPictureDataStatus::weatherfi_tclMsgWindStaticPictureDataStatus(const weatherfi_tclMsgWindStaticPictureDataStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   PresentedMagnitudePicture = coRef.PresentedMagnitudePicture;
   PresentedDirectionPicture = coRef.PresentedDirectionPicture;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgWindStaticPictureDataStatus& weatherfi_tclMsgWindStaticPictureDataStatus::operator=(const weatherfi_tclMsgWindStaticPictureDataStatus& coRef)
{
   if (this == &coRef) return *this;
   PresentedMagnitudePicture = coRef.PresentedMagnitudePicture;
   PresentedDirectionPicture = coRef.PresentedDirectionPicture;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgWindStaticPictureDataStatus::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgWindStaticPictureDataStatus::u16GetFunctionID() const {return WEATHERFI_C_U16_WINDSTATICPICTUREDATA;}
tU8 weatherfi_tclMsgWindStaticPictureDataStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid weatherfi_tclMsgWindStaticPictureDataStatus::vDestroy()
{
   PresentedMagnitudePicture.vDestroy(); 
   PresentedDirectionPicture.vDestroy(); 
}

tU32 weatherfi_tclMsgWindStaticPictureDataStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+PresentedMagnitudePicture.u32GetSize(u16MajorVersion)+PresentedDirectionPicture.u32GetSize(u16MajorVersion);
}

tBool weatherfi_tclMsgWindStaticPictureDataStatus::operator==(const weatherfi_tclMsgWindStaticPictureDataStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (PresentedMagnitudePicture == rfoCmp.PresentedMagnitudePicture);
      bResult = bResult && (PresentedDirectionPicture == rfoCmp.PresentedDirectionPicture);
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgWindStaticPictureDataStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> PresentedMagnitudePicture;
   oIn >> PresentedDirectionPicture;
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgWindStaticPictureDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << PresentedMagnitudePicture;
   oOut << PresentedDirectionPicture;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgEngineeringTextGet::weatherfi_tclMsgEngineeringTextGet(const weatherfi_tclMsgEngineeringTextGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgEngineeringTextGet& weatherfi_tclMsgEngineeringTextGet::operator=(const weatherfi_tclMsgEngineeringTextGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgEngineeringTextGet::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgEngineeringTextGet::u16GetFunctionID() const {return WEATHERFI_C_U16_ENGINEERINGTEXT;}
tU8 weatherfi_tclMsgEngineeringTextGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 weatherfi_tclMsgEngineeringTextGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weatherfi_tclMsgEngineeringTextGet::operator==(const weatherfi_tclMsgEngineeringTextGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgEngineeringTextGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgEngineeringTextGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgEngineeringTextUpReg::weatherfi_tclMsgEngineeringTextUpReg(const weatherfi_tclMsgEngineeringTextUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgEngineeringTextUpReg& weatherfi_tclMsgEngineeringTextUpReg::operator=(const weatherfi_tclMsgEngineeringTextUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgEngineeringTextUpReg::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgEngineeringTextUpReg::u16GetFunctionID() const {return WEATHERFI_C_U16_ENGINEERINGTEXT;}
tU8 weatherfi_tclMsgEngineeringTextUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 weatherfi_tclMsgEngineeringTextUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weatherfi_tclMsgEngineeringTextUpReg::operator==(const weatherfi_tclMsgEngineeringTextUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgEngineeringTextUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgEngineeringTextUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgEngineeringTextRelUpReg::weatherfi_tclMsgEngineeringTextRelUpReg(const weatherfi_tclMsgEngineeringTextRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgEngineeringTextRelUpReg& weatherfi_tclMsgEngineeringTextRelUpReg::operator=(const weatherfi_tclMsgEngineeringTextRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgEngineeringTextRelUpReg::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgEngineeringTextRelUpReg::u16GetFunctionID() const {return WEATHERFI_C_U16_ENGINEERINGTEXT;}
tU8 weatherfi_tclMsgEngineeringTextRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 weatherfi_tclMsgEngineeringTextRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool weatherfi_tclMsgEngineeringTextRelUpReg::operator==(const weatherfi_tclMsgEngineeringTextRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgEngineeringTextRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgEngineeringTextRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgEngineeringTextStatus::weatherfi_tclMsgEngineeringTextStatus(const weatherfi_tclMsgEngineeringTextStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   Message = coRef.Message;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
weatherfi_tclMsgEngineeringTextStatus& weatherfi_tclMsgEngineeringTextStatus::operator=(const weatherfi_tclMsgEngineeringTextStatus& coRef)
{
   if (this == &coRef) return *this;
   Message = coRef.Message;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 weatherfi_tclMsgEngineeringTextStatus::u16GetServiceID() const {return WEATHERFI_C_U16_SERVICE_ID;}
tU16 weatherfi_tclMsgEngineeringTextStatus::u16GetFunctionID() const {return WEATHERFI_C_U16_ENGINEERINGTEXT;}
tU8 weatherfi_tclMsgEngineeringTextStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid weatherfi_tclMsgEngineeringTextStatus::vDestroy()
{
   Message.vDestroy();
}

tU32 weatherfi_tclMsgEngineeringTextStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+Message.u32GetSize(u16MajorVersion);
}

tBool weatherfi_tclMsgEngineeringTextStatus::operator==(const weatherfi_tclMsgEngineeringTextStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Message == rfoCmp.Message);
   return bResult;
}

fi_tclInContext& weatherfi_tclMsgEngineeringTextStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> Message;
   return oIn;
}

fi_tclOutContext& weatherfi_tclMsgEngineeringTextStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Message;
   return oOut;
}

