#ifndef WEATHERFILANGUAGE_HEADER
#define WEATHERFILANGUAGE_HEADER

class weatherfi_tclInContext;
class weatherfi_tclOutContext;
class weatherfi_tclVisitorBase;

class MY_DECL weatherfi_tclDescription {
 public:
  enum tenType { EN_PARSING, EN_GENERATING };	
  
  weatherfi_tclDescription(fi_tclInContext* poIn, weatherfi_tclVisitorBase* poVisit);
  weatherfi_tclDescription(fi_tclOutContext* poOut, weatherfi_tclVisitorBase* poVisit);
  
  /* --Hier kommen nun die Methoden, die einzelne Nachrichten entspr. NaFI 
		erzeugen (EN_GENERATING) bzw. einlesen (EN_PARSING). */

  tBool bInitMessage(weatherfi_tclToken::tenType enMsgToken);
  tBool bProcessMessage();

  // tBool bProcessElement(); 

  tBool bDoIt(fi_tclVisitableTypeBase& poBaseType);
#ifndef FI_S_EXTERNAL_FI
  void vEnableSpecialBinContainer() { bUseSpecialBinContainer = true; }
#endif

 private:
  /* default constructor */ weatherfi_tclDescription();  //lint !e1704 // always use parameters
  tenType enType; //--read or write?

  union {
    fi_tclInContext* poInContext;
    fi_tclOutContext* poOutContext;
  };

  weatherfi_tclVisitorBase* poVisitor;

  // typedef navifi_tclTraversePath::tclKnot tclKnot;

  tBool bUseSpecialBinContainer;  
  
 public:
  
  // --Traversierungspfad
  fi_tclTraversePath<weatherfi_tclKnot> oPath;
  //   navifi_tclTraversePath oPath;
  fi_tclTraversePath<weatherfi_tclKnot> oCallStack;
   //  navifi_tclTraversePath oCallStack;
  
};

// --Inline-Implementierungen
inline weatherfi_tclDescription::weatherfi_tclDescription(fi_tclInContext* poIn, weatherfi_tclVisitorBase* poVisit):
  enType(EN_PARSING),poInContext(poIn),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

inline weatherfi_tclDescription::weatherfi_tclDescription(fi_tclOutContext* poOut, weatherfi_tclVisitorBase* poVisit):
  enType(EN_GENERATING),poOutContext(poOut),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

#endif

