/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef TMPRESFITYPES_HEADER
#define TMPRESFITYPES_HEADER

// #include <vector>
// 


class tmpresfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

class tmpresfi_tclMsgTrafficInfoSourceMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmpresfi_tclMsgTrafficInfoSourceMethodStart():TrafficMessageSource() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmpresfi_tclMsgTrafficInfoSourceMethodStart& operator=(const tmpresfi_tclMsgTrafficInfoSourceMethodStart& coRef);
   tmpresfi_tclMsgTrafficInfoSourceMethodStart(const tmpresfi_tclMsgTrafficInfoSourceMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_b32_TrafficMessageSource TrafficMessageSource;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmpresfi_tclMsgTrafficInfoSourceMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmpresfi_tclToken::EN_MSG_TRAFFICINFOSOURCEMETHODSTART;}
};

class tmpresfi_tclMsgTrafficInfoSourceMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmpresfi_tclMsgTrafficInfoSourceMethodResult():TrafficMessageSource() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmpresfi_tclMsgTrafficInfoSourceMethodResult& operator=(const tmpresfi_tclMsgTrafficInfoSourceMethodResult& coRef);
   tmpresfi_tclMsgTrafficInfoSourceMethodResult(const tmpresfi_tclMsgTrafficInfoSourceMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_b32_TrafficMessageSource TrafficMessageSource;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmpresfi_tclMsgTrafficInfoSourceMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmpresfi_tclToken::EN_MSG_TRAFFICINFOSOURCEMETHODRESULT;}
};

class tmpresfi_tclMsgTranslateExtendedMessageMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmpresfi_tclMsgTranslateExtendedMessageMethodStart():CodedMessage(),LanguageId() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmpresfi_tclMsgTranslateExtendedMessageMethodStart& operator=(const tmpresfi_tclMsgTranslateExtendedMessageMethodStart& coRef);
   tmpresfi_tclMsgTranslateExtendedMessageMethodStart(const tmpresfi_tclMsgTranslateExtendedMessageMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_BinContainer CodedMessage;
   fi_tcl_LanguageID LanguageId;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmpresfi_tclMsgTranslateExtendedMessageMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmpresfi_tclToken::EN_MSG_TRANSLATEEXTENDEDMESSAGEMETHODSTART;}
};

class tmpresfi_tclMsgTranslateExtendedMessageMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmpresfi_tclMsgTranslateExtendedMessageMethodResult():StringInXML() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmpresfi_tclMsgTranslateExtendedMessageMethodResult& operator=(const tmpresfi_tclMsgTranslateExtendedMessageMethodResult& coRef);
   tmpresfi_tclMsgTranslateExtendedMessageMethodResult(const tmpresfi_tclMsgTranslateExtendedMessageMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tclString StringInXML;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmpresfi_tclMsgTranslateExtendedMessageMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmpresfi_tclToken::EN_MSG_TRANSLATEEXTENDEDMESSAGEMETHODRESULT;}
};

class tmpresfi_tclMsgTrafficSourceGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmpresfi_tclMsgTrafficSourceGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmpresfi_tclMsgTrafficSourceGet& operator=(const tmpresfi_tclMsgTrafficSourceGet& coRef);
   tmpresfi_tclMsgTrafficSourceGet(const tmpresfi_tclMsgTrafficSourceGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmpresfi_tclMsgTrafficSourceGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmpresfi_tclToken::EN_MSG_TRAFFICSOURCEGET;}
};

class tmpresfi_tclMsgTrafficSourceStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmpresfi_tclMsgTrafficSourceStatus():TrafficMessageSource() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmpresfi_tclMsgTrafficSourceStatus& operator=(const tmpresfi_tclMsgTrafficSourceStatus& coRef);
   tmpresfi_tclMsgTrafficSourceStatus(const tmpresfi_tclMsgTrafficSourceStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_b32_TrafficMessageSource TrafficMessageSource;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmpresfi_tclMsgTrafficSourceStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmpresfi_tclToken::EN_MSG_TRAFFICSOURCESTATUS;}
};

class tmpresfi_tclMsgAvailableLanguagesGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmpresfi_tclMsgAvailableLanguagesGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmpresfi_tclMsgAvailableLanguagesGet& operator=(const tmpresfi_tclMsgAvailableLanguagesGet& coRef);
   tmpresfi_tclMsgAvailableLanguagesGet(const tmpresfi_tclMsgAvailableLanguagesGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmpresfi_tclMsgAvailableLanguagesGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmpresfi_tclToken::EN_MSG_AVAILABLELANGUAGESGET;}
};

class tmpresfi_tclMsgAvailableLanguagesStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmpresfi_tclMsgAvailableLanguagesStatus() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmpresfi_tclMsgAvailableLanguagesStatus& operator=(const tmpresfi_tclMsgAvailableLanguagesStatus& coRef);
   tmpresfi_tclMsgAvailableLanguagesStatus(const tmpresfi_tclMsgAvailableLanguagesStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_LanguageID, std::allocator<fi_tcl_LanguageID> > ListOfLanguageIds;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmpresfi_tclMsgAvailableLanguagesStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmpresfi_tclToken::EN_MSG_AVAILABLELANGUAGESSTATUS;}
};

class tmpresfi_tclMsgEngineeringTextGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmpresfi_tclMsgEngineeringTextGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmpresfi_tclMsgEngineeringTextGet& operator=(const tmpresfi_tclMsgEngineeringTextGet& coRef);
   tmpresfi_tclMsgEngineeringTextGet(const tmpresfi_tclMsgEngineeringTextGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmpresfi_tclMsgEngineeringTextGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmpresfi_tclToken::EN_MSG_ENGINEERINGTEXTGET;}
};

class tmpresfi_tclMsgEngineeringTextUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmpresfi_tclMsgEngineeringTextUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmpresfi_tclMsgEngineeringTextUpReg& operator=(const tmpresfi_tclMsgEngineeringTextUpReg& coRef);
   tmpresfi_tclMsgEngineeringTextUpReg(const tmpresfi_tclMsgEngineeringTextUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmpresfi_tclMsgEngineeringTextUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmpresfi_tclToken::EN_MSG_ENGINEERINGTEXTUPREG;}
};

class tmpresfi_tclMsgEngineeringTextRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmpresfi_tclMsgEngineeringTextRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmpresfi_tclMsgEngineeringTextRelUpReg& operator=(const tmpresfi_tclMsgEngineeringTextRelUpReg& coRef);
   tmpresfi_tclMsgEngineeringTextRelUpReg(const tmpresfi_tclMsgEngineeringTextRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmpresfi_tclMsgEngineeringTextRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmpresfi_tclToken::EN_MSG_ENGINEERINGTEXTRELUPREG;}
};

class tmpresfi_tclMsgEngineeringTextStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmpresfi_tclMsgEngineeringTextStatus():Message() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmpresfi_tclMsgEngineeringTextStatus& operator=(const tmpresfi_tclMsgEngineeringTextStatus& coRef);
   tmpresfi_tclMsgEngineeringTextStatus(const tmpresfi_tclMsgEngineeringTextStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tclString Message;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmpresfi_tclMsgEngineeringTextStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmpresfi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS;}
};


#endif
