/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef TMDATAFITYPES_HEADER
#define TMDATAFITYPES_HEADER

// #include <vector>
// 


class tmdatafi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

class tmdatafi_tclMsgNavTima_RdbIdHandlingMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmdatafi_tclMsgNavTima_RdbIdHandlingMethodStart() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmdatafi_tclMsgNavTima_RdbIdHandlingMethodStart& operator=(const tmdatafi_tclMsgNavTima_RdbIdHandlingMethodStart& coRef);
   tmdatafi_tclMsgNavTima_RdbIdHandlingMethodStart(const tmdatafi_tclMsgNavTima_RdbIdHandlingMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_RDBId, std::allocator<fi_tcl_RDBId> > ListOfRdbIdLight;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmdatafi_tclMsgNavTima_RdbIdHandlingMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmdatafi_tclToken::EN_MSG_NAVTIMA_RDBIDHANDLINGMETHODSTART;}
};

class tmdatafi_tclMsgNavTima_RdbIdHandlingMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmdatafi_tclMsgNavTima_RdbIdHandlingMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmdatafi_tclMsgNavTima_RdbIdHandlingMethodResult& operator=(const tmdatafi_tclMsgNavTima_RdbIdHandlingMethodResult& coRef);
   tmdatafi_tclMsgNavTima_RdbIdHandlingMethodResult(const tmdatafi_tclMsgNavTima_RdbIdHandlingMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmdatafi_tclMsgNavTima_RdbIdHandlingMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmdatafi_tclToken::EN_MSG_NAVTIMA_RDBIDHANDLINGMETHODRESULT;}
};

class tmdatafi_tclMsgNavTima_SetAbsFilterMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmdatafi_tclMsgNavTima_SetAbsFilterMethodStart():SwitchOnOff(0),BottomLeft(),UpperRight() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmdatafi_tclMsgNavTima_SetAbsFilterMethodStart& operator=(const tmdatafi_tclMsgNavTima_SetAbsFilterMethodStart& coRef);
   tmdatafi_tclMsgNavTima_SetAbsFilterMethodStart(const tmdatafi_tclMsgNavTima_SetAbsFilterMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tBool SwitchOnOff;
   fi_tcl_PositionWGS84 BottomLeft;
   fi_tcl_PositionWGS84 UpperRight;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmdatafi_tclMsgNavTima_SetAbsFilterMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmdatafi_tclToken::EN_MSG_NAVTIMA_SETABSFILTERMETHODSTART;}
};

class tmdatafi_tclMsgNavTima_SetAbsFilterMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmdatafi_tclMsgNavTima_SetAbsFilterMethodResult():FilterValid(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmdatafi_tclMsgNavTima_SetAbsFilterMethodResult& operator=(const tmdatafi_tclMsgNavTima_SetAbsFilterMethodResult& coRef);
   tmdatafi_tclMsgNavTima_SetAbsFilterMethodResult(const tmdatafi_tclMsgNavTima_SetAbsFilterMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tBool FilterValid;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmdatafi_tclMsgNavTima_SetAbsFilterMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmdatafi_tclToken::EN_MSG_NAVTIMA_SETABSFILTERMETHODRESULT;}
};

class tmdatafi_tclMsgNavTima_SetRelFilterMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmdatafi_tclMsgNavTima_SetRelFilterMethodStart():SwitchOnOff(0),Width(0),Height(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmdatafi_tclMsgNavTima_SetRelFilterMethodStart& operator=(const tmdatafi_tclMsgNavTima_SetRelFilterMethodStart& coRef);
   tmdatafi_tclMsgNavTima_SetRelFilterMethodStart(const tmdatafi_tclMsgNavTima_SetRelFilterMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tBool SwitchOnOff;
   tU32 Width;
   tU32 Height;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmdatafi_tclMsgNavTima_SetRelFilterMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmdatafi_tclToken::EN_MSG_NAVTIMA_SETRELFILTERMETHODSTART;}
};

class tmdatafi_tclMsgNavTima_SetRelFilterMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmdatafi_tclMsgNavTima_SetRelFilterMethodResult():FilterValid(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmdatafi_tclMsgNavTima_SetRelFilterMethodResult& operator=(const tmdatafi_tclMsgNavTima_SetRelFilterMethodResult& coRef);
   tmdatafi_tclMsgNavTima_SetRelFilterMethodResult(const tmdatafi_tclMsgNavTima_SetRelFilterMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tBool FilterValid;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmdatafi_tclMsgNavTima_SetRelFilterMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmdatafi_tclToken::EN_MSG_NAVTIMA_SETRELFILTERMETHODRESULT;}
};

class tmdatafi_tclMsgNavTima_SwitchAbsFilterMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmdatafi_tclMsgNavTima_SwitchAbsFilterMethodStart() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmdatafi_tclMsgNavTima_SwitchAbsFilterMethodStart& operator=(const tmdatafi_tclMsgNavTima_SwitchAbsFilterMethodStart& coRef);
   tmdatafi_tclMsgNavTima_SwitchAbsFilterMethodStart(const tmdatafi_tclMsgNavTima_SwitchAbsFilterMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmdatafi_tclMsgNavTima_SwitchAbsFilterMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmdatafi_tclToken::EN_MSG_NAVTIMA_SWITCHABSFILTERMETHODSTART;}
};

class tmdatafi_tclMsgNavTima_SwitchAbsFilterMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmdatafi_tclMsgNavTima_SwitchAbsFilterMethodResult():FilterSwitched(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmdatafi_tclMsgNavTima_SwitchAbsFilterMethodResult& operator=(const tmdatafi_tclMsgNavTima_SwitchAbsFilterMethodResult& coRef);
   tmdatafi_tclMsgNavTima_SwitchAbsFilterMethodResult(const tmdatafi_tclMsgNavTima_SwitchAbsFilterMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tBool FilterSwitched;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmdatafi_tclMsgNavTima_SwitchAbsFilterMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmdatafi_tclToken::EN_MSG_NAVTIMA_SWITCHABSFILTERMETHODRESULT;}
};

class tmdatafi_tclMsgNavTima_SwitchRelFilterMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmdatafi_tclMsgNavTima_SwitchRelFilterMethodStart() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmdatafi_tclMsgNavTima_SwitchRelFilterMethodStart& operator=(const tmdatafi_tclMsgNavTima_SwitchRelFilterMethodStart& coRef);
   tmdatafi_tclMsgNavTima_SwitchRelFilterMethodStart(const tmdatafi_tclMsgNavTima_SwitchRelFilterMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmdatafi_tclMsgNavTima_SwitchRelFilterMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmdatafi_tclToken::EN_MSG_NAVTIMA_SWITCHRELFILTERMETHODSTART;}
};

class tmdatafi_tclMsgNavTima_SwitchRelFilterMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmdatafi_tclMsgNavTima_SwitchRelFilterMethodResult():FilterSwitched(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmdatafi_tclMsgNavTima_SwitchRelFilterMethodResult& operator=(const tmdatafi_tclMsgNavTima_SwitchRelFilterMethodResult& coRef);
   tmdatafi_tclMsgNavTima_SwitchRelFilterMethodResult(const tmdatafi_tclMsgNavTima_SwitchRelFilterMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tBool FilterSwitched;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmdatafi_tclMsgNavTima_SwitchRelFilterMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmdatafi_tclToken::EN_MSG_NAVTIMA_SWITCHRELFILTERMETHODRESULT;}
};

class tmdatafi_tclMsgNavTima_MessageMemoryMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmdatafi_tclMsgNavTima_MessageMemoryMethodStart():MsgMemMajorId(0),MsgMemMinorId(0),ForceAlignment(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmdatafi_tclMsgNavTima_MessageMemoryMethodStart& operator=(const tmdatafi_tclMsgNavTima_MessageMemoryMethodStart& coRef);
   tmdatafi_tclMsgNavTima_MessageMemoryMethodStart(const tmdatafi_tclMsgNavTima_MessageMemoryMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 MsgMemMajorId;
   tU32 MsgMemMinorId;
   tBool ForceAlignment;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmdatafi_tclMsgNavTima_MessageMemoryMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmdatafi_tclToken::EN_MSG_NAVTIMA_MESSAGEMEMORYMETHODSTART;}
};

class tmdatafi_tclMsgNavTima_MessageMemoryMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmdatafi_tclMsgNavTima_MessageMemoryMethodResult():AmountOfSelectedMessages(0),MsgMemMajorId(0),MsgMemMinorId(0),AlignmentTriggered(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmdatafi_tclMsgNavTima_MessageMemoryMethodResult& operator=(const tmdatafi_tclMsgNavTima_MessageMemoryMethodResult& coRef);
   tmdatafi_tclMsgNavTima_MessageMemoryMethodResult(const tmdatafi_tclMsgNavTima_MessageMemoryMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU16 AmountOfSelectedMessages;
   tU32 MsgMemMajorId;
   tU32 MsgMemMinorId;
   tU8 AlignmentTriggered;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmdatafi_tclMsgNavTima_MessageMemoryMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmdatafi_tclToken::EN_MSG_NAVTIMA_MESSAGEMEMORYMETHODRESULT;}
};

class tmdatafi_tclMsgNavTima_ResetMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmdatafi_tclMsgNavTima_ResetMethodStart() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmdatafi_tclMsgNavTima_ResetMethodStart& operator=(const tmdatafi_tclMsgNavTima_ResetMethodStart& coRef);
   tmdatafi_tclMsgNavTima_ResetMethodStart(const tmdatafi_tclMsgNavTima_ResetMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmdatafi_tclMsgNavTima_ResetMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmdatafi_tclToken::EN_MSG_NAVTIMA_RESETMETHODSTART;}
};

class tmdatafi_tclMsgNavTima_ResetMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmdatafi_tclMsgNavTima_ResetMethodResult():ResetSucceed(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmdatafi_tclMsgNavTima_ResetMethodResult& operator=(const tmdatafi_tclMsgNavTima_ResetMethodResult& coRef);
   tmdatafi_tclMsgNavTima_ResetMethodResult(const tmdatafi_tclMsgNavTima_ResetMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tBool ResetSucceed;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmdatafi_tclMsgNavTima_ResetMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmdatafi_tclToken::EN_MSG_NAVTIMA_RESETMETHODRESULT;}
};

class tmdatafi_tclMsgNavTima_StatusGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmdatafi_tclMsgNavTima_StatusGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmdatafi_tclMsgNavTima_StatusGet& operator=(const tmdatafi_tclMsgNavTima_StatusGet& coRef);
   tmdatafi_tclMsgNavTima_StatusGet(const tmdatafi_tclMsgNavTima_StatusGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmdatafi_tclMsgNavTima_StatusGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmdatafi_tclToken::EN_MSG_NAVTIMA_STATUSGET;}
};

class tmdatafi_tclMsgNavTima_StatusUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmdatafi_tclMsgNavTima_StatusUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmdatafi_tclMsgNavTima_StatusUpReg& operator=(const tmdatafi_tclMsgNavTima_StatusUpReg& coRef);
   tmdatafi_tclMsgNavTima_StatusUpReg(const tmdatafi_tclMsgNavTima_StatusUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmdatafi_tclMsgNavTima_StatusUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmdatafi_tclToken::EN_MSG_NAVTIMA_STATUSUPREG;}
};

class tmdatafi_tclMsgNavTima_StatusRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmdatafi_tclMsgNavTima_StatusRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmdatafi_tclMsgNavTima_StatusRelUpReg& operator=(const tmdatafi_tclMsgNavTima_StatusRelUpReg& coRef);
   tmdatafi_tclMsgNavTima_StatusRelUpReg(const tmdatafi_tclMsgNavTima_StatusRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmdatafi_tclMsgNavTima_StatusRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmdatafi_tclToken::EN_MSG_NAVTIMA_STATUSRELUPREG;}
};

class tmdatafi_tclMsgNavTima_StatusStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmdatafi_tclMsgNavTima_StatusStatus():TIMAStatus(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmdatafi_tclMsgNavTima_StatusStatus& operator=(const tmdatafi_tclMsgNavTima_StatusStatus& coRef);
   tmdatafi_tclMsgNavTima_StatusStatus(const tmdatafi_tclMsgNavTima_StatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 TIMAStatus;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmdatafi_tclMsgNavTima_StatusStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmdatafi_tclToken::EN_MSG_NAVTIMA_STATUSSTATUS;}
};

class tmdatafi_tclMsgNavTima_RdbIdNotificationUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmdatafi_tclMsgNavTima_RdbIdNotificationUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmdatafi_tclMsgNavTima_RdbIdNotificationUpReg& operator=(const tmdatafi_tclMsgNavTima_RdbIdNotificationUpReg& coRef);
   tmdatafi_tclMsgNavTima_RdbIdNotificationUpReg(const tmdatafi_tclMsgNavTima_RdbIdNotificationUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmdatafi_tclMsgNavTima_RdbIdNotificationUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmdatafi_tclToken::EN_MSG_NAVTIMA_RDBIDNOTIFICATIONUPREG;}
};

class tmdatafi_tclMsgNavTima_RdbIdNotificationRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmdatafi_tclMsgNavTima_RdbIdNotificationRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmdatafi_tclMsgNavTima_RdbIdNotificationRelUpReg& operator=(const tmdatafi_tclMsgNavTima_RdbIdNotificationRelUpReg& coRef);
   tmdatafi_tclMsgNavTima_RdbIdNotificationRelUpReg(const tmdatafi_tclMsgNavTima_RdbIdNotificationRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmdatafi_tclMsgNavTima_RdbIdNotificationRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmdatafi_tclToken::EN_MSG_NAVTIMA_RDBIDNOTIFICATIONRELUPREG;}
};

class tmdatafi_tclMsgNavTima_RdbIdNotificationStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmdatafi_tclMsgNavTima_RdbIdNotificationStatus() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmdatafi_tclMsgNavTima_RdbIdNotificationStatus& operator=(const tmdatafi_tclMsgNavTima_RdbIdNotificationStatus& coRef);
   tmdatafi_tclMsgNavTima_RdbIdNotificationStatus(const tmdatafi_tclMsgNavTima_RdbIdNotificationStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_RDBId, std::allocator<fi_tcl_RDBId> > ListOfRdbIdsLight;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmdatafi_tclMsgNavTima_RdbIdNotificationStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmdatafi_tclToken::EN_MSG_NAVTIMA_RDBIDNOTIFICATIONSTATUS;}
};

class tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityUpReg& operator=(const tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityUpReg& coRef);
   tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityUpReg(const tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmdatafi_tclToken::EN_MSG_NAVTIMA_CURRENTRDBIDAVAILABILITYUPREG;}
};

class tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityRelUpReg& operator=(const tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityRelUpReg& coRef);
   tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityRelUpReg(const tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmdatafi_tclToken::EN_MSG_NAVTIMA_CURRENTRDBIDAVAILABILITYRELUPREG;}
};

class tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityStatus() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityStatus& operator=(const tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityStatus& coRef);
   tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityStatus(const tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_ISORDBIdAvailability, std::allocator<fi_tcl_ISORDBIdAvailability> > SupportedRdbIds;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmdatafi_tclMsgNavTima_CurrentRdbIdAvailabilityStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmdatafi_tclToken::EN_MSG_NAVTIMA_CURRENTRDBIDAVAILABILITYSTATUS;}
};

class tmdatafi_tclMsgNavTima_ExpiredTmcMessageListUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmdatafi_tclMsgNavTima_ExpiredTmcMessageListUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmdatafi_tclMsgNavTima_ExpiredTmcMessageListUpReg& operator=(const tmdatafi_tclMsgNavTima_ExpiredTmcMessageListUpReg& coRef);
   tmdatafi_tclMsgNavTima_ExpiredTmcMessageListUpReg(const tmdatafi_tclMsgNavTima_ExpiredTmcMessageListUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmdatafi_tclMsgNavTima_ExpiredTmcMessageListUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmdatafi_tclToken::EN_MSG_NAVTIMA_EXPIREDTMCMESSAGELISTUPREG;}
};

class tmdatafi_tclMsgNavTima_ExpiredTmcMessageListRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmdatafi_tclMsgNavTima_ExpiredTmcMessageListRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmdatafi_tclMsgNavTima_ExpiredTmcMessageListRelUpReg& operator=(const tmdatafi_tclMsgNavTima_ExpiredTmcMessageListRelUpReg& coRef);
   tmdatafi_tclMsgNavTima_ExpiredTmcMessageListRelUpReg(const tmdatafi_tclMsgNavTima_ExpiredTmcMessageListRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmdatafi_tclMsgNavTima_ExpiredTmcMessageListRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmdatafi_tclToken::EN_MSG_NAVTIMA_EXPIREDTMCMESSAGELISTRELUPREG;}
};

class tmdatafi_tclMsgNavTima_ExpiredTmcMessageListStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmdatafi_tclMsgNavTima_ExpiredTmcMessageListStatus():NumberOfSelectedMessages(0),MsgMemMajorId(0),MsgMemMinorId(0),MessageStockUnaligned(0),EraseAllTrafficMessages(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmdatafi_tclMsgNavTima_ExpiredTmcMessageListStatus& operator=(const tmdatafi_tclMsgNavTima_ExpiredTmcMessageListStatus& coRef);
   tmdatafi_tclMsgNavTima_ExpiredTmcMessageListStatus(const tmdatafi_tclMsgNavTima_ExpiredTmcMessageListStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU16 NumberOfSelectedMessages;
   tU32 MsgMemMajorId;
   tU32 MsgMemMinorId;
   tBool MessageStockUnaligned;
   tBool EraseAllTrafficMessages;
   std::vector<tU16, std::allocator<tU16> > ErasedTrafficMessages;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmdatafi_tclMsgNavTima_ExpiredTmcMessageListStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmdatafi_tclToken::EN_MSG_NAVTIMA_EXPIREDTMCMESSAGELISTSTATUS;}
};

class tmdatafi_tclMsgNavTima_TmcMessageChangedUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmdatafi_tclMsgNavTima_TmcMessageChangedUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmdatafi_tclMsgNavTima_TmcMessageChangedUpReg& operator=(const tmdatafi_tclMsgNavTima_TmcMessageChangedUpReg& coRef);
   tmdatafi_tclMsgNavTima_TmcMessageChangedUpReg(const tmdatafi_tclMsgNavTima_TmcMessageChangedUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmdatafi_tclMsgNavTima_TmcMessageChangedUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmdatafi_tclToken::EN_MSG_NAVTIMA_TMCMESSAGECHANGEDUPREG;}
};

class tmdatafi_tclMsgNavTima_TmcMessageChangedRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmdatafi_tclMsgNavTima_TmcMessageChangedRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmdatafi_tclMsgNavTima_TmcMessageChangedRelUpReg& operator=(const tmdatafi_tclMsgNavTima_TmcMessageChangedRelUpReg& coRef);
   tmdatafi_tclMsgNavTima_TmcMessageChangedRelUpReg(const tmdatafi_tclMsgNavTima_TmcMessageChangedRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmdatafi_tclMsgNavTima_TmcMessageChangedRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmdatafi_tclToken::EN_MSG_NAVTIMA_TMCMESSAGECHANGEDRELUPREG;}
};

class tmdatafi_tclMsgNavTima_TmcMessageChangedStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmdatafi_tclMsgNavTima_TmcMessageChangedStatus():NumberOfSelectedMessages(0),MsgMemMajorId(0),MsgMemMinorId(0),MessageStockUnaligned(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmdatafi_tclMsgNavTima_TmcMessageChangedStatus& operator=(const tmdatafi_tclMsgNavTima_TmcMessageChangedStatus& coRef);
   tmdatafi_tclMsgNavTima_TmcMessageChangedStatus(const tmdatafi_tclMsgNavTima_TmcMessageChangedStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU16 NumberOfSelectedMessages;
   tU32 MsgMemMajorId;
   tU32 MsgMemMinorId;
   tBool MessageStockUnaligned;
   std::vector<fi_tcl_TMChangedMessage, std::allocator<fi_tcl_TMChangedMessage> > TrafficMessageList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmdatafi_tclMsgNavTima_TmcMessageChangedStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmdatafi_tclToken::EN_MSG_NAVTIMA_TMCMESSAGECHANGEDSTATUS;}
};

class tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsUpReg& operator=(const tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsUpReg& coRef);
   tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsUpReg(const tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmdatafi_tclToken::EN_MSG_NAVTIMA_TRAFFICMSGMEMORYSTATISTICSUPREG;}
};

class tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsRelUpReg& operator=(const tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsRelUpReg& coRef);
   tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsRelUpReg(const tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmdatafi_tclToken::EN_MSG_NAVTIMA_TRAFFICMSGMEMORYSTATISTICSRELUPREG;}
};

class tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsStatus():TrafficMsgMemoryStatistics() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsStatus& operator=(const tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsStatus& coRef);
   tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsStatus(const tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_TrafficMsgMemoryStatistics TrafficMsgMemoryStatistics;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmdatafi_tclMsgNavTima_TrafficMsgMemoryStatisticsStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmdatafi_tclToken::EN_MSG_NAVTIMA_TRAFFICMSGMEMORYSTATISTICSSTATUS;}
};


#endif
