#ifndef TMDATAFILANGUAGE_HEADER
#define TMDATAFILANGUAGE_HEADER

class tmdatafi_tclInContext;
class tmdatafi_tclOutContext;
class tmdatafi_tclVisitorBase;

class MY_DECL tmdatafi_tclDescription {
 public:
  enum tenType { EN_PARSING, EN_GENERATING };	
  
  tmdatafi_tclDescription(fi_tclInContext* poIn, tmdatafi_tclVisitorBase* poVisit);
  tmdatafi_tclDescription(fi_tclOutContext* poOut, tmdatafi_tclVisitorBase* poVisit);
  
  /* --Hier kommen nun die Methoden, die einzelne Nachrichten entspr. NaFI 
		erzeugen (EN_GENERATING) bzw. einlesen (EN_PARSING). */

  tBool bInitMessage(tmdatafi_tclToken::tenType enMsgToken);
  tBool bProcessMessage();

  // tBool bProcessElement(); 

  tBool bDoIt(fi_tclVisitableTypeBase& poBaseType);
#ifndef FI_S_EXTERNAL_FI
  void vEnableSpecialBinContainer() { bUseSpecialBinContainer = true; }
#endif

 private:
  /* default constructor */ tmdatafi_tclDescription();  //lint !e1704 // always use parameters
  tenType enType; //--read or write?

  union {
    fi_tclInContext* poInContext;
    fi_tclOutContext* poOutContext;
  };

  tmdatafi_tclVisitorBase* poVisitor;

  // typedef navifi_tclTraversePath::tclKnot tclKnot;

  tBool bUseSpecialBinContainer;  
  
 public:
  
  // --Traversierungspfad
  fi_tclTraversePath<tmdatafi_tclKnot> oPath;
  //   navifi_tclTraversePath oPath;
  fi_tclTraversePath<tmdatafi_tclKnot> oCallStack;
   //  navifi_tclTraversePath oCallStack;
  
};

// --Inline-Implementierungen
inline tmdatafi_tclDescription::tmdatafi_tclDescription(fi_tclInContext* poIn, tmdatafi_tclVisitorBase* poVisit):
  enType(EN_PARSING),poInContext(poIn),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

inline tmdatafi_tclDescription::tmdatafi_tclDescription(fi_tclOutContext* poOut, tmdatafi_tclVisitorBase* poVisit):
  enType(EN_GENERATING),poOutContext(poOut),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

#endif

