#include "precompiled.hh"

tBool tmdatafi_tclDescription::bInitMessage(tmdatafi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case tmdatafi_tclToken::EN_LAST_TOKEN:
   case tmdatafi_tclToken::EN_LIST:
   case tmdatafi_tclToken::EN_END_OF_STRUCT:
   case tmdatafi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
   break;
      // include the expansions for the messages
   case tmdatafi_tclToken::EN_MSG_NAVTIMA_RDBIDHANDLINGMETHODSTART:
   {
      bResult &= oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_RDBID,tmdatafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_LIST,tmdatafi_tclSemanticDomain::EN_MSG_LISTOFRDBIDLIGHT));
   } break;
   case tmdatafi_tclToken::EN_MSG_NAVTIMA_SETABSFILTERMETHODSTART:
   {
      bResult &= oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_POSITIONWGS84,tmdatafi_tclSemanticDomain::EN_MSG_UPPERRIGHT));
      bResult &= oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_POSITIONWGS84,tmdatafi_tclSemanticDomain::EN_MSG_BOTTOMLEFT));
      bResult &= oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_BOOL,tmdatafi_tclSemanticDomain::EN_MSG_SWITCHONOFF));
   } break;
   case tmdatafi_tclToken::EN_MSG_NAVTIMA_SETABSFILTERMETHODRESULT:
   {
      bResult &= oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_BOOL,tmdatafi_tclSemanticDomain::EN_MSG_FILTERVALID));
   } break;
   case tmdatafi_tclToken::EN_MSG_NAVTIMA_SETRELFILTERMETHODSTART:
   {
      bResult &= oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_U32,tmdatafi_tclSemanticDomain::EN_MSG_HEIGHT));
      bResult &= oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_U32,tmdatafi_tclSemanticDomain::EN_MSG_WIDTH));
      bResult &= oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_BOOL,tmdatafi_tclSemanticDomain::EN_MSG_SWITCHONOFF));
   } break;
   case tmdatafi_tclToken::EN_MSG_NAVTIMA_SETRELFILTERMETHODRESULT:
   {
      bResult &= oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_BOOL,tmdatafi_tclSemanticDomain::EN_MSG_FILTERVALID));
   } break;
   case tmdatafi_tclToken::EN_MSG_NAVTIMA_SWITCHABSFILTERMETHODRESULT:
   {
      bResult &= oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_BOOL,tmdatafi_tclSemanticDomain::EN_MSG_FILTERSWITCHED));
   } break;
   case tmdatafi_tclToken::EN_MSG_NAVTIMA_SWITCHRELFILTERMETHODRESULT:
   {
      bResult &= oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_BOOL,tmdatafi_tclSemanticDomain::EN_MSG_FILTERSWITCHED));
   } break;
   case tmdatafi_tclToken::EN_MSG_NAVTIMA_MESSAGEMEMORYMETHODSTART:
   {
      bResult &= oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_BOOL,tmdatafi_tclSemanticDomain::EN_MSG_FORCEALIGNMENT));
      bResult &= oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_U32,tmdatafi_tclSemanticDomain::EN_MSG_MSGMEMMINORID));
      bResult &= oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_U32,tmdatafi_tclSemanticDomain::EN_MSG_MSGMEMMAJORID));
   } break;
   case tmdatafi_tclToken::EN_MSG_NAVTIMA_MESSAGEMEMORYMETHODRESULT:
   {
      bResult &= oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_U8,tmdatafi_tclSemanticDomain::EN_MSG_ALIGNMENTTRIGGERED));
      bResult &= oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_U32,tmdatafi_tclSemanticDomain::EN_MSG_MSGMEMMINORID));
      bResult &= oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_U32,tmdatafi_tclSemanticDomain::EN_MSG_MSGMEMMAJORID));
      bResult &= oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_U16,tmdatafi_tclSemanticDomain::EN_MSG_AMOUNTOFSELECTEDMESSAGES));
   } break;
   case tmdatafi_tclToken::EN_MSG_NAVTIMA_RESETMETHODRESULT:
   {
      bResult &= oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_BOOL,tmdatafi_tclSemanticDomain::EN_MSG_RESETSUCCEED));
   } break;
   case tmdatafi_tclToken::EN_MSG_NAVTIMA_STATUSSTATUS:
   {
      if (poOutContext->u16GetMajorVersion() <= 36)
      {
         bResult &= oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_U32,tmdatafi_tclSemanticDomain::EN_MSG_TIMASTATUS));
      }
   } break;
   case tmdatafi_tclToken::EN_MSG_NAVTIMA_RDBIDNOTIFICATIONSTATUS:
   {
      bResult &= oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_RDBID,tmdatafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_LIST,tmdatafi_tclSemanticDomain::EN_MSG_LISTOFRDBIDSLIGHT));
   } break;
   case tmdatafi_tclToken::EN_MSG_NAVTIMA_CURRENTRDBIDAVAILABILITYSTATUS:
   {
      bResult &= oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_ISORDBIDAVAILABILITY,tmdatafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_LIST,tmdatafi_tclSemanticDomain::EN_MSG_SUPPORTEDRDBIDS));
   } break;
   case tmdatafi_tclToken::EN_MSG_NAVTIMA_EXPIREDTMCMESSAGELISTSTATUS:
   {
      bResult &= oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_U16,tmdatafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_LIST,tmdatafi_tclSemanticDomain::EN_MSG_ERASEDTRAFFICMESSAGES));
      bResult &= oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_BOOL,tmdatafi_tclSemanticDomain::EN_MSG_ERASEALLTRAFFICMESSAGES));
      bResult &= oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_BOOL,tmdatafi_tclSemanticDomain::EN_MSG_MESSAGESTOCKUNALIGNED));
      bResult &= oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_U32,tmdatafi_tclSemanticDomain::EN_MSG_MSGMEMMINORID));
      bResult &= oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_U32,tmdatafi_tclSemanticDomain::EN_MSG_MSGMEMMAJORID));
      bResult &= oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_U16,tmdatafi_tclSemanticDomain::EN_MSG_NUMBEROFSELECTEDMESSAGES));
   } break;
   case tmdatafi_tclToken::EN_MSG_NAVTIMA_TMCMESSAGECHANGEDSTATUS:
   {
      bResult &= oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_TMCHANGEDMESSAGE,tmdatafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_LIST,tmdatafi_tclSemanticDomain::EN_MSG_TRAFFICMESSAGELIST));
      bResult &= oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_BOOL,tmdatafi_tclSemanticDomain::EN_MSG_MESSAGESTOCKUNALIGNED));
      bResult &= oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_U32,tmdatafi_tclSemanticDomain::EN_MSG_MSGMEMMINORID));
      bResult &= oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_U32,tmdatafi_tclSemanticDomain::EN_MSG_MSGMEMMAJORID));
      bResult &= oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_U16,tmdatafi_tclSemanticDomain::EN_MSG_NUMBEROFSELECTEDMESSAGES));
   } break;
   case tmdatafi_tclToken::EN_MSG_NAVTIMA_TRAFFICMSGMEMORYSTATISTICSSTATUS:
   {
      bResult &= oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_TRAFFICMSGMEMORYSTATISTICS,tmdatafi_tclSemanticDomain::EN_MSG_TRAFFICMSGMEMORYSTATISTICS));
   } break;
   case tmdatafi_tclToken::EN_BINCONTAINER:
   case tmdatafi_tclToken::EN_S32_METER:
   case tmdatafi_tclToken::EN_S32_SECOND:
   case tmdatafi_tclToken::EN_POSIXTIME:
   case tmdatafi_tclToken::EN_S16_KMPERHOUR:
   case tmdatafi_tclToken::EN_S16_CENTIMETERSECOND:
   case tmdatafi_tclToken::EN_FIVERSION:
   case tmdatafi_tclToken::EN_S32_LONGITUDE:
   case tmdatafi_tclToken::EN_S32_LATITUDE:
   case tmdatafi_tclToken::EN_POSITIONWGS84:
   case tmdatafi_tclToken::EN_E16_ISOCOUNTRYCODE:
   case tmdatafi_tclToken::EN_E8_BINCONTAINERTYPES:
   case tmdatafi_tclToken::EN_RDBID:
   case tmdatafi_tclToken::EN_TMPROGRAMSERVICE:
   case tmdatafi_tclToken::EN_TMSERVICEPROVIDER:
   case tmdatafi_tclToken::EN_E8_TMCATEGORY:
   case tmdatafi_tclToken::EN_E8_TMFLOWIMPACT:
   case tmdatafi_tclToken::EN_E8_TMURGENCY:
   case tmdatafi_tclToken::EN_B8_TMADDITIONALINFORMATION:
   case tmdatafi_tclToken::EN_E16_NAVIEVENTVALUE:
   case tmdatafi_tclToken::EN_E8_TRAFFICMSGTYPE:
   case tmdatafi_tclToken::EN_E8_EVENTTYPE:
   case tmdatafi_tclToken::EN_E8_TMLOCATIONTYPE:
   case tmdatafi_tclToken::EN_E16_EFFECTCODE:
   case tmdatafi_tclToken::EN_E16_CAUSECODE:
   case tmdatafi_tclToken::EN_E8_TENDENCY:
   case tmdatafi_tclToken::EN_B32_TRAFFICMESSAGESOURCE:
   case tmdatafi_tclToken::EN_TMEVENT:
   case tmdatafi_tclToken::EN_TMCODEDMESSAGE:
   case tmdatafi_tclToken::EN_TMCODEDMESSAGEBINCONTAINER:
   case tmdatafi_tclToken::EN_B16_TMSUBSTANTIALINFORMATION:
   case tmdatafi_tclToken::EN_B8_TRAFFICMESSAGESOURCEAVAILABILITY:
   case tmdatafi_tclToken::EN_E8_TMHAZARDLOCATIONACCURACY:
   case tmdatafi_tclToken::EN_E8_TMRELIABILITY:
   case tmdatafi_tclToken::EN_E8_TMHAZARDLOCATIONDYNAMICS:
   case tmdatafi_tclToken::EN_E8_TMEXTENDEDFLOWIMPACT:
   case tmdatafi_tclToken::EN_TRAFFICMSGMEMORYSTATISTICSPERTYPE:
   case tmdatafi_tclToken::EN_TRAFFICMSGMEMORYSTATISTICS:
   case tmdatafi_tclToken::EN_ISORDBIDAVAILABILITY:
   case tmdatafi_tclToken::EN_TMPRECISELOCATIONDESCRIPTION:
   case tmdatafi_tclToken::EN_TMCHANGEDMESSAGE:
   case tmdatafi_tclToken::EN_U8:   
   case tmdatafi_tclToken::EN_S8:   
   case tmdatafi_tclToken::EN_U16:   
   case tmdatafi_tclToken::EN_S16:   
   case tmdatafi_tclToken::EN_U24:   
   case tmdatafi_tclToken::EN_S24:   
   case tmdatafi_tclToken::EN_U32:   
   case tmdatafi_tclToken::EN_S32:   
   case tmdatafi_tclToken::EN_U64:   
   case tmdatafi_tclToken::EN_S64:   
   case tmdatafi_tclToken::EN_F32:   
   case tmdatafi_tclToken::EN_F64:   
   case tmdatafi_tclToken::EN_BOOL:   
   case tmdatafi_tclToken::EN_STRING:   
   case tmdatafi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      oPath.bGoDown(tmdatafi_tclKnot(enMsgToken,tmdatafi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool tmdatafi_tclDescription::bDoIt(fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (*poInContext) >> oTypeBase;
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (*poOutContext) << oTypeBase;
   }
   return poVisitor->bIsValid();
}

tBool tmdatafi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      tmdatafi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      tmdatafi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      tmdatafi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == tmdatafi_tclSemanticDomain::EN_LIST_ELEMENT) {
         oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            oPath.bGoDown(tmdatafi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            oPath.bGoDown(tmdatafi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            oPath.bGoUp();
            oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      oCallStack.bGoDown(tmdatafi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case tmdatafi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == tmdatafi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         oPath.bGoUp();
         oCallStack.bGoUp();
         oCallStack.bGoUp();
      } break;
      case tmdatafi_tclToken::EN_LIST: 
      {
         fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            tmdatafi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(tmdatafi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            tmdatafi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(tmdatafi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
         }
      } break;
      case tmdatafi_tclToken::EN_U8: 
      {
         fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case tmdatafi_tclToken::EN_U16: 
      {
         fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case tmdatafi_tclToken::EN_U24: 
      {
         fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case tmdatafi_tclToken::EN_U32: 
      {
         fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case tmdatafi_tclToken::EN_U64: 
      {
         fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case tmdatafi_tclToken::EN_S8: 
      {
         fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case tmdatafi_tclToken::EN_S16: 
      {
         fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case tmdatafi_tclToken::EN_S24: 
      {
         fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case tmdatafi_tclToken::EN_S32: 
      {
         fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case tmdatafi_tclToken::EN_S64: 
      {
         fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case tmdatafi_tclToken::EN_F32: 
      {
         fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case tmdatafi_tclToken::EN_F64: 
      {
         fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case tmdatafi_tclToken::EN_BOOL: 
      {
         fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case tmdatafi_tclToken::EN_STRING: 
      {
         fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case tmdatafi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
   case tmdatafi_tclToken::EN_MSG_NAVTIMA_RDBIDHANDLINGMETHODSTART:
   case tmdatafi_tclToken::EN_MSG_NAVTIMA_RDBIDHANDLINGMETHODRESULT:
   case tmdatafi_tclToken::EN_MSG_NAVTIMA_SETABSFILTERMETHODSTART:
   case tmdatafi_tclToken::EN_MSG_NAVTIMA_SETABSFILTERMETHODRESULT:
   case tmdatafi_tclToken::EN_MSG_NAVTIMA_SETRELFILTERMETHODSTART:
   case tmdatafi_tclToken::EN_MSG_NAVTIMA_SETRELFILTERMETHODRESULT:
   case tmdatafi_tclToken::EN_MSG_NAVTIMA_SWITCHABSFILTERMETHODSTART:
   case tmdatafi_tclToken::EN_MSG_NAVTIMA_SWITCHABSFILTERMETHODRESULT:
   case tmdatafi_tclToken::EN_MSG_NAVTIMA_SWITCHRELFILTERMETHODSTART:
   case tmdatafi_tclToken::EN_MSG_NAVTIMA_SWITCHRELFILTERMETHODRESULT:
   case tmdatafi_tclToken::EN_MSG_NAVTIMA_MESSAGEMEMORYMETHODSTART:
   case tmdatafi_tclToken::EN_MSG_NAVTIMA_MESSAGEMEMORYMETHODRESULT:
   case tmdatafi_tclToken::EN_MSG_NAVTIMA_RESETMETHODSTART:
   case tmdatafi_tclToken::EN_MSG_NAVTIMA_RESETMETHODRESULT:
   case tmdatafi_tclToken::EN_MSG_NAVTIMA_STATUSGET:
   case tmdatafi_tclToken::EN_MSG_NAVTIMA_STATUSUPREG:
   case tmdatafi_tclToken::EN_MSG_NAVTIMA_STATUSRELUPREG:
   case tmdatafi_tclToken::EN_MSG_NAVTIMA_STATUSSTATUS:
   case tmdatafi_tclToken::EN_MSG_NAVTIMA_RDBIDNOTIFICATIONUPREG:
   case tmdatafi_tclToken::EN_MSG_NAVTIMA_RDBIDNOTIFICATIONRELUPREG:
   case tmdatafi_tclToken::EN_MSG_NAVTIMA_RDBIDNOTIFICATIONSTATUS:
   case tmdatafi_tclToken::EN_MSG_NAVTIMA_CURRENTRDBIDAVAILABILITYUPREG:
   case tmdatafi_tclToken::EN_MSG_NAVTIMA_CURRENTRDBIDAVAILABILITYRELUPREG:
   case tmdatafi_tclToken::EN_MSG_NAVTIMA_CURRENTRDBIDAVAILABILITYSTATUS:
   case tmdatafi_tclToken::EN_MSG_NAVTIMA_EXPIREDTMCMESSAGELISTUPREG:
   case tmdatafi_tclToken::EN_MSG_NAVTIMA_EXPIREDTMCMESSAGELISTRELUPREG:
   case tmdatafi_tclToken::EN_MSG_NAVTIMA_EXPIREDTMCMESSAGELISTSTATUS:
   case tmdatafi_tclToken::EN_MSG_NAVTIMA_TMCMESSAGECHANGEDUPREG:
   case tmdatafi_tclToken::EN_MSG_NAVTIMA_TMCMESSAGECHANGEDRELUPREG:
   case tmdatafi_tclToken::EN_MSG_NAVTIMA_TMCMESSAGECHANGEDSTATUS:
   case tmdatafi_tclToken::EN_MSG_NAVTIMA_TRAFFICMSGMEMORYSTATISTICSUPREG:
   case tmdatafi_tclToken::EN_MSG_NAVTIMA_TRAFFICMSGMEMORYSTATISTICSRELUPREG:
   case tmdatafi_tclToken::EN_MSG_NAVTIMA_TRAFFICMSGMEMORYSTATISTICSSTATUS:
      bInitMessage(enToken);
      break;
   case tmdatafi_tclToken::EN_BINCONTAINER:
   {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_END_OF_STRUCT,tmdatafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_U8,tmdatafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_LIST,tmdatafi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case tmdatafi_tclToken::EN_S32_METER:
   {
      fi_tcl_s32_Meter o_s32_Meter;
      if (!bDoIt(o_s32_Meter))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case tmdatafi_tclToken::EN_S32_SECOND:
   {
      fi_tcl_s32_Second o_s32_Second;
      if (!bDoIt(o_s32_Second))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case tmdatafi_tclToken::EN_POSIXTIME:
   {
      if (poVisitor->bDoExpand_POSIXTime(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_END_OF_STRUCT,tmdatafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_S32,tmdatafi_tclSemanticDomain::EN_TIME));
      }
      else
      {
         fi_tcl_POSIXTime o_POSIXTime;
         if (!bDoIt(o_POSIXTime))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_POSIXTime.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_POSIXTime.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case tmdatafi_tclToken::EN_S16_KMPERHOUR:
   {
      fi_tcl_s16_KmPerHour o_s16_KmPerHour;
      if (!bDoIt(o_s16_KmPerHour))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case tmdatafi_tclToken::EN_S16_CENTIMETERSECOND:
   {
      fi_tcl_s16_CentimeterSecond o_s16_CentimeterSecond;
      if (!bDoIt(o_s16_CentimeterSecond))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case tmdatafi_tclToken::EN_FIVERSION:
   {
      if (poVisitor->bDoExpand_FIVersion(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_END_OF_STRUCT,tmdatafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_U8,tmdatafi_tclSemanticDomain::EN_PATCHVERSION));
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_U8,tmdatafi_tclSemanticDomain::EN_MINORVERSION));
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_U8,tmdatafi_tclSemanticDomain::EN_MAJORVERSION));
      }
      else
      {
         fi_tcl_FIVersion o_FIVersion;
         if (!bDoIt(o_FIVersion))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FIVersion.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FIVersion.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case tmdatafi_tclToken::EN_S32_LONGITUDE:
   {
      fi_tcl_s32_Longitude o_s32_Longitude;
      if (!bDoIt(o_s32_Longitude))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case tmdatafi_tclToken::EN_S32_LATITUDE:
   {
      fi_tcl_s32_Latitude o_s32_Latitude;
      if (!bDoIt(o_s32_Latitude))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case tmdatafi_tclToken::EN_POSITIONWGS84:
   {
      if (poVisitor->bDoExpand_PositionWGS84(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_END_OF_STRUCT,tmdatafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_S32_LATITUDE,tmdatafi_tclSemanticDomain::EN_LATITUDE));
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_S32_LONGITUDE,tmdatafi_tclSemanticDomain::EN_LONGITUDE));
      }
      else
      {
         fi_tcl_PositionWGS84 o_PositionWGS84;
         if (!bDoIt(o_PositionWGS84))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionWGS84.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_PositionWGS84.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case tmdatafi_tclToken::EN_E16_ISOCOUNTRYCODE:
   {
      fi_tcl_e16_ISOCountryCode o_e16_ISOCountryCode;
      if (!bDoIt(o_e16_ISOCountryCode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case tmdatafi_tclToken::EN_E8_BINCONTAINERTYPES:
   {
      fi_tcl_e8_BinContainerTypes o_e8_BinContainerTypes;
      if (!bDoIt(o_e8_BinContainerTypes))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case tmdatafi_tclToken::EN_RDBID:
   {
      if (poVisitor->bDoExpand_RDBId(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_END_OF_STRUCT,tmdatafi_tclSemanticDomain::EN_UNKNOWN));
         if (11 <= u16MajorVersion)
         {
            oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_U16,tmdatafi_tclSemanticDomain::EN_BSA));
         }
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_U8,tmdatafi_tclSemanticDomain::EN_TABLENO));
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_U8,tmdatafi_tclSemanticDomain::EN_TMCCOUNTRYCODE));
      }
      else
      {
         fi_tcl_RDBId o_RDBId;
         if (!bDoIt(o_RDBId))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RDBId.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_RDBId.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case tmdatafi_tclToken::EN_TMPROGRAMSERVICE:
   {
      if (poVisitor->bDoExpand_TMProgramService(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_END_OF_STRUCT,tmdatafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_STRING,tmdatafi_tclSemanticDomain::EN_PROGRAMSERVICENAME));
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_E16_ISOCOUNTRYCODE,tmdatafi_tclSemanticDomain::EN_COUNTRYCODE));
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_U32,tmdatafi_tclSemanticDomain::EN_EXTENDEDPROGRAMID));
         }
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_U16,tmdatafi_tclSemanticDomain::EN_PROGRAMID));
      }
      else
      {
         fi_tcl_TMProgramService o_TMProgramService;
         if (!bDoIt(o_TMProgramService))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMProgramService.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMProgramService.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case tmdatafi_tclToken::EN_TMSERVICEPROVIDER:
   {
      if (poVisitor->bDoExpand_TMServiceProvider(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_END_OF_STRUCT,tmdatafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_STRING,tmdatafi_tclSemanticDomain::EN_SERVICEPROVIDERNAME));
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_E16_ISOCOUNTRYCODE,tmdatafi_tclSemanticDomain::EN_COUNTRYCODE));
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_U32,tmdatafi_tclSemanticDomain::EN_EXTENDEDSERVICEID));
         }
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_U8,tmdatafi_tclSemanticDomain::EN_SERVICEID));
      }
      else
      {
         fi_tcl_TMServiceProvider o_TMServiceProvider;
         if (!bDoIt(o_TMServiceProvider))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMServiceProvider.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMServiceProvider.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case tmdatafi_tclToken::EN_E8_TMCATEGORY:
   {
      fi_tcl_e8_TMCategory o_e8_TMCategory;
      if (!bDoIt(o_e8_TMCategory))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case tmdatafi_tclToken::EN_E8_TMFLOWIMPACT:
   {
      fi_tcl_e8_TMFlowImpact o_e8_TMFlowImpact;
      if (!bDoIt(o_e8_TMFlowImpact))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case tmdatafi_tclToken::EN_E8_TMURGENCY:
   {
      fi_tcl_e8_TMUrgency o_e8_TMUrgency;
      if (!bDoIt(o_e8_TMUrgency))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case tmdatafi_tclToken::EN_B8_TMADDITIONALINFORMATION:
   {
      fi_tcl_b8_TMAdditionalInformation o_b8_TMAdditionalInformation;
      if (!bDoIt(o_b8_TMAdditionalInformation))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case tmdatafi_tclToken::EN_E16_NAVIEVENTVALUE:
   {
      fi_tcl_e16_NaviEventValue o_e16_NaviEventValue;
      if (!bDoIt(o_e16_NaviEventValue))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case tmdatafi_tclToken::EN_E8_TRAFFICMSGTYPE:
   {
      fi_tcl_e8_TrafficMsgType o_e8_TrafficMsgType;
      if (!bDoIt(o_e8_TrafficMsgType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case tmdatafi_tclToken::EN_E8_EVENTTYPE:
   {
      fi_tcl_e8_EventType o_e8_EventType;
      if (!bDoIt(o_e8_EventType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case tmdatafi_tclToken::EN_E8_TMLOCATIONTYPE:
   {
      fi_tcl_e8_TMLocationType o_e8_TMLocationType;
      if (!bDoIt(o_e8_TMLocationType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case tmdatafi_tclToken::EN_E16_EFFECTCODE:
   {
      fi_tcl_e16_EffectCode o_e16_EffectCode;
      if (!bDoIt(o_e16_EffectCode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case tmdatafi_tclToken::EN_E16_CAUSECODE:
   {
      fi_tcl_e16_CauseCode o_e16_CauseCode;
      if (!bDoIt(o_e16_CauseCode))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case tmdatafi_tclToken::EN_E8_TENDENCY:
   {
      fi_tcl_e8_Tendency o_e8_Tendency;
      if (!bDoIt(o_e8_Tendency))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case tmdatafi_tclToken::EN_B32_TRAFFICMESSAGESOURCE:
   {
      fi_tcl_b32_TrafficMessageSource o_b32_TrafficMessageSource;
      if (!bDoIt(o_b32_TrafficMessageSource))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case tmdatafi_tclToken::EN_TMEVENT:
   {
      if (poVisitor->bDoExpand_TMEvent(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_END_OF_STRUCT,tmdatafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_U8,tmdatafi_tclSemanticDomain::EN_PRIORITY));
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_S16_CENTIMETERSECOND,tmdatafi_tclSemanticDomain::EN_AVERAGESPEEDCMPERSEC));
         }
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_S16_KMPERHOUR,tmdatafi_tclSemanticDomain::EN_AVERAGESPEED));
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_S16_CENTIMETERSECOND,tmdatafi_tclSemanticDomain::EN_SPEEDLIMITADVICECMPERSEC));
         }
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_S16_KMPERHOUR,tmdatafi_tclSemanticDomain::EN_SPEEDLIMITADVICE));
         if (36 <= u16MajorVersion)
         {
            oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_S32_SECOND,tmdatafi_tclSemanticDomain::EN_DELAYINFORMATION));
         }
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_S32_METER,tmdatafi_tclSemanticDomain::EN_LENGTHINFORMATION));
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_E16_CAUSECODE,tmdatafi_tclSemanticDomain::EN_CAUSE));
         }
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_E8_TENDENCY,tmdatafi_tclSemanticDomain::EN_TENDENCY));
         }
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_E16_EFFECTCODE,tmdatafi_tclSemanticDomain::EN_EFFECT));
         }
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_E16_NAVIEVENTVALUE,tmdatafi_tclSemanticDomain::EN_NAVIEVENTVALUE));
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_E8_EVENTTYPE,tmdatafi_tclSemanticDomain::EN_EVENTTYPE));
         }
      }
      else
      {
         fi_tcl_TMEvent o_TMEvent;
         if (!bDoIt(o_TMEvent))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMEvent.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMEvent.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case tmdatafi_tclToken::EN_TMCODEDMESSAGE:
   {
      if (poVisitor->bDoExpand_TMCodedMessage(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_END_OF_STRUCT,tmdatafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_RDBID,tmdatafi_tclSemanticDomain::EN_RDBID));
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_TMEVENT,tmdatafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
            oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_LIST,tmdatafi_tclSemanticDomain::EN_EVENTS));
         }
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_BOOL,tmdatafi_tclSemanticDomain::EN_BIDIRECTIONAL));
         }
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_BOOL,tmdatafi_tclSemanticDomain::EN_DIRECTIONAGAINSTTMC));
         }
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_U8,tmdatafi_tclSemanticDomain::EN_EXTENT));
         }
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_E8_TMLOCATIONTYPE,tmdatafi_tclSemanticDomain::EN_PRIMARYLOCATIONTYPE));
         }
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_U16,tmdatafi_tclSemanticDomain::EN_SECONDARYLOCATIONCODE));
         }
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_U16,tmdatafi_tclSemanticDomain::EN_PRIMARYLOCATIONCODE));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_U8,tmdatafi_tclSemanticDomain::EN_AVERAGESPEED));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_U8,tmdatafi_tclSemanticDomain::EN_SPEEDLIMITADVICE));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_U8,tmdatafi_tclSemanticDomain::EN_LENGTHINFOANDLABEL2));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_U8,tmdatafi_tclSemanticDomain::EN_ROADNUMBERSUFFIX));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_U16,tmdatafi_tclSemanticDomain::EN_ROADNUMBER));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_U16,tmdatafi_tclSemanticDomain::EN_ROADCLASS));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_E16_NAVIEVENTVALUE,tmdatafi_tclSemanticDomain::EN_ADDITIONALNEV7));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_E16_NAVIEVENTVALUE,tmdatafi_tclSemanticDomain::EN_ADDITIONALNEV6));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_E16_NAVIEVENTVALUE,tmdatafi_tclSemanticDomain::EN_ADDITIONALNEV5));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_E16_NAVIEVENTVALUE,tmdatafi_tclSemanticDomain::EN_ADDITIONALNEV4));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_E16_NAVIEVENTVALUE,tmdatafi_tclSemanticDomain::EN_ADDITIONALNEV3));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_E16_NAVIEVENTVALUE,tmdatafi_tclSemanticDomain::EN_ADDITIONALNEV2));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_E16_NAVIEVENTVALUE,tmdatafi_tclSemanticDomain::EN_ADDITIONALNEV1));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_E16_NAVIEVENTVALUE,tmdatafi_tclSemanticDomain::EN_MAINNEV));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_U8,tmdatafi_tclSemanticDomain::EN_DIRECTIONALITY));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_U8,tmdatafi_tclSemanticDomain::EN_DIRANDEXTENT));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_U8,tmdatafi_tclSemanticDomain::EN_LOCATIONTYPE));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_U16,tmdatafi_tclSemanticDomain::EN_LOCATION2));
         }
         if (u16MajorVersion <= 36)
         {
            oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_U16,tmdatafi_tclSemanticDomain::EN_LOCATION1));
         }
      }
      else
      {
         fi_tcl_TMCodedMessage o_TMCodedMessage;
         if (!bDoIt(o_TMCodedMessage))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMCodedMessage.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMCodedMessage.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
#ifndef FI_S_EXTERNAL_FI
   case tmdatafi_tclToken::EN_TMCODEDMESSAGEBINCONTAINER:
   {
      if (poVisitor->bDoExpand_TMCodedMessageBinContainer(enSemanticDomain))
      {
         oPath.bGoUp();
         bInsideBinContainerVersion = true;
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_END_OF_STRUCT,tmdatafi_tclSemanticDomain::EN_BINCONTAINER));
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_TMCODEDMESSAGE,tmdatafi_tclSemanticDomain::EN_TMCODEDMESSAGE));
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_E8_BINCONTAINERTYPES,tmdatafi_tclSemanticDomain::EN_CONTAINERTYPE));
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_FIVERSION,tmdatafi_tclSemanticDomain::EN_CONTAINERFIVERSION));
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_U16,tmdatafi_tclSemanticDomain::EN_SERVICEID));
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_U32,tmdatafi_tclSemanticDomain::EN_CONTAINERLENGTH));
      }
      else
      {
         fi_tcl_TMCodedMessageBinContainer o_TMCodedMessageBinContainer;
         if (!bDoIt(o_TMCodedMessageBinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMCodedMessageBinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMCodedMessageBinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
#endif // FI_S_EXTERNAL_FI
   case tmdatafi_tclToken::EN_B16_TMSUBSTANTIALINFORMATION:
   {
      fi_tcl_b16_TMSubstantialInformation o_b16_TMSubstantialInformation;
      if (!bDoIt(o_b16_TMSubstantialInformation))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case tmdatafi_tclToken::EN_B8_TRAFFICMESSAGESOURCEAVAILABILITY:
   {
      fi_tcl_b8_TrafficMessageSourceAvailability o_b8_TrafficMessageSourceAvailability;
      if (!bDoIt(o_b8_TrafficMessageSourceAvailability))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case tmdatafi_tclToken::EN_E8_TMHAZARDLOCATIONACCURACY:
   {
      fi_tcl_e8_TMHazardLocationAccuracy o_e8_TMHazardLocationAccuracy;
      if (!bDoIt(o_e8_TMHazardLocationAccuracy))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case tmdatafi_tclToken::EN_E8_TMRELIABILITY:
   {
      fi_tcl_e8_TMReliability o_e8_TMReliability;
      if (!bDoIt(o_e8_TMReliability))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case tmdatafi_tclToken::EN_E8_TMHAZARDLOCATIONDYNAMICS:
   {
      fi_tcl_e8_TMHazardLocationDynamics o_e8_TMHazardLocationDynamics;
      if (!bDoIt(o_e8_TMHazardLocationDynamics))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case tmdatafi_tclToken::EN_E8_TMEXTENDEDFLOWIMPACT:
   {
      fi_tcl_e8_TMExtendedFlowImpact o_e8_TMExtendedFlowImpact;
      if (!bDoIt(o_e8_TMExtendedFlowImpact))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case tmdatafi_tclToken::EN_TRAFFICMSGMEMORYSTATISTICSPERTYPE:
   {
      if (poVisitor->bDoExpand_TrafficMsgMemoryStatisticsPerType(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_END_OF_STRUCT,tmdatafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_POSIXTIME,tmdatafi_tclSemanticDomain::EN_LATESTRECEPTIONTIME));
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_U16,tmdatafi_tclSemanticDomain::EN_NUMBEROFTRAFFICMSGS));
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_E8_TRAFFICMSGTYPE,tmdatafi_tclSemanticDomain::EN_TRAFFICMSGTYPE));
      }
      else
      {
         fi_tcl_TrafficMsgMemoryStatisticsPerType o_TrafficMsgMemoryStatisticsPerType;
         if (!bDoIt(o_TrafficMsgMemoryStatisticsPerType))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TrafficMsgMemoryStatisticsPerType.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TrafficMsgMemoryStatisticsPerType.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case tmdatafi_tclToken::EN_TRAFFICMSGMEMORYSTATISTICS:
   {
      if (poVisitor->bDoExpand_TrafficMsgMemoryStatistics(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_END_OF_STRUCT,tmdatafi_tclSemanticDomain::EN_UNKNOWN));
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_TRAFFICMSGMEMORYSTATISTICSPERTYPE,tmdatafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
            oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_LIST,tmdatafi_tclSemanticDomain::EN_STATISTICSPERTYPE));
         }
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_POSIXTIME,tmdatafi_tclSemanticDomain::EN_LATESTRECEPTIONTIME));
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_U16,tmdatafi_tclSemanticDomain::EN_NUMBEROFTRAFFICMSGS));
      }
      else
      {
         fi_tcl_TrafficMsgMemoryStatistics o_TrafficMsgMemoryStatistics;
         if (!bDoIt(o_TrafficMsgMemoryStatistics))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TrafficMsgMemoryStatistics.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TrafficMsgMemoryStatistics.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case tmdatafi_tclToken::EN_ISORDBIDAVAILABILITY:
   {
      if (poVisitor->bDoExpand_ISORDBIdAvailability(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_END_OF_STRUCT,tmdatafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_B8_TRAFFICMESSAGESOURCEAVAILABILITY,tmdatafi_tclSemanticDomain::EN_AVAILABILITY));
         if (11 <= u16MajorVersion)
         {
            oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_BOOL,tmdatafi_tclSemanticDomain::EN_CURRENTPOSITIONINSIDE));
         }
         if (11 <= u16MajorVersion)
         {
            oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_STRING,tmdatafi_tclSemanticDomain::EN_BSANAME));
         }
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_E16_ISOCOUNTRYCODE,tmdatafi_tclSemanticDomain::EN_ISOCOUNTRYCODE));
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_RDBID,tmdatafi_tclSemanticDomain::EN_RDBID));
      }
      else
      {
         fi_tcl_ISORDBIdAvailability o_ISORDBIdAvailability;
         if (!bDoIt(o_ISORDBIdAvailability))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ISORDBIdAvailability.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_ISORDBIdAvailability.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case tmdatafi_tclToken::EN_TMPRECISELOCATIONDESCRIPTION:
   {
      if (poVisitor->bDoExpand_TMPreciseLocationDescription(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_END_OF_STRUCT,tmdatafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_E8_TMHAZARDLOCATIONDYNAMICS,tmdatafi_tclSemanticDomain::EN_DYNAMICS));
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_E8_TMRELIABILITY,tmdatafi_tclSemanticDomain::EN_RELIABILITY));
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_E8_TMHAZARDLOCATIONACCURACY,tmdatafi_tclSemanticDomain::EN_ACCURACY));
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_S32_METER,tmdatafi_tclSemanticDomain::EN_DISTANCE));
      }
      else
      {
         fi_tcl_TMPreciseLocationDescription o_TMPreciseLocationDescription;
         if (!bDoIt(o_TMPreciseLocationDescription))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMPreciseLocationDescription.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMPreciseLocationDescription.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case tmdatafi_tclToken::EN_TMCHANGEDMESSAGE:
   {
      if (poVisitor->bDoExpand_TMChangedMessage(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_END_OF_STRUCT,tmdatafi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_BINCONTAINER,tmdatafi_tclSemanticDomain::EN_CODEDMESSAGE));
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_TMSERVICEPROVIDER,tmdatafi_tclSemanticDomain::EN_SERVICEPROVIDER));
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_TMPROGRAMSERVICE,tmdatafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_LIST,tmdatafi_tclSemanticDomain::EN_PROGRAMSERVICELIST));
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_B32_TRAFFICMESSAGESOURCE,tmdatafi_tclSemanticDomain::EN_TRAFFICMESSAGESOURCE));
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_E8_TMEXTENDEDFLOWIMPACT,tmdatafi_tclSemanticDomain::EN_TMEXTENDEDFLOWIMPACT));
         if (u16MajorVersion <= 25)
         {
            oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_E8_TMFLOWIMPACT,tmdatafi_tclSemanticDomain::EN_TMFLOWIMPACT));
         }
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_E8_TMCATEGORY,tmdatafi_tclSemanticDomain::EN_TMCATEGORY));
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_E8_TMURGENCY,tmdatafi_tclSemanticDomain::EN_URGENCY));
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_E16_ISOCOUNTRYCODE,tmdatafi_tclSemanticDomain::EN_COUNTRYCODEOFMESSAGE));
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_RDBID,tmdatafi_tclSemanticDomain::EN_RDB));
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_TMEVENT,tmdatafi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_LIST,tmdatafi_tclSemanticDomain::EN_EVENTLIST));
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_TMPRECISELOCATIONDESCRIPTION,tmdatafi_tclSemanticDomain::EN_PRECISELOCATIONDESCRIPTION));
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_BOOL,tmdatafi_tclSemanticDomain::EN_BIDIRECTIONAL));
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_BOOL,tmdatafi_tclSemanticDomain::EN_DIRECTIONAGAINSTTMC));
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_U8,tmdatafi_tclSemanticDomain::EN_EXTENT));
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_S32,tmdatafi_tclSemanticDomain::EN_SEGMENTBOGUSDISTANCETOPOS));
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_U16,tmdatafi_tclSemanticDomain::EN_SEGMENTLOCATIONCODE));
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_E8_TMLOCATIONTYPE,tmdatafi_tclSemanticDomain::EN_PRIMARYLOCATIONTYPE));
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_U16,tmdatafi_tclSemanticDomain::EN_SECONDARYLOCATIONCODE));
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_U16,tmdatafi_tclSemanticDomain::EN_PRIMARYLOCATIONCODE));
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_POSIXTIME,tmdatafi_tclSemanticDomain::EN_LATESTDECODETIME));
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_POSIXTIME,tmdatafi_tclSemanticDomain::EN_STOPTIME));
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_POSIXTIME,tmdatafi_tclSemanticDomain::EN_STARTTIME));
         if (38 <= u16MajorVersion)
         {
            oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_E8_TRAFFICMSGTYPE,tmdatafi_tclSemanticDomain::EN_MESSAGETYPE));
         }
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_U16,tmdatafi_tclSemanticDomain::EN_CONTAINERINDEX));
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_B8_TMADDITIONALINFORMATION,tmdatafi_tclSemanticDomain::EN_CHANGEDADDITIONALINFORMATION));
         oPath.bGoDown(tmdatafi_tclKnot(tmdatafi_tclToken::EN_B16_TMSUBSTANTIALINFORMATION,tmdatafi_tclSemanticDomain::EN_CHANGEDSUBSTANTIALINFORMATION));
      }
      else
      {
         fi_tcl_TMChangedMessage o_TMChangedMessage;
         if (!bDoIt(o_TMChangedMessage))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMChangedMessage.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_TMChangedMessage.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
      case tmdatafi_tclToken::EN_UNKNOWN:
      case tmdatafi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
  }
  return bResult;
}

