#ifndef __TMDATAFIDEBUGVISITOR_H__
#define __TMDATAFIDEBUGVISITOR_H__

class MY_DECL tmdatafi_tclPrintVisitor : public tmdatafi_tclVisitorBase {

private:
   /* default constructor */ tmdatafi_tclPrintVisitor();  //lint !e1704   // use constructor with parameter

public:
   tmdatafi_tclPrintVisitor(fi_tclOutput* poOut):poOutput(poOut) { line[0] = '\0'; }

   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(fi_tclU8& oU8);
   virtual tVoid vVisitS8(fi_tclS8& oS8);
   virtual tVoid vVisitU16(fi_tclU16& oU16);
   virtual tVoid vVisitS16(fi_tclS16& oS16);
   virtual tVoid vVisitU24(fi_tclU24& oU24);
   virtual tVoid vVisitS24(fi_tclS24& oS24);
   virtual tVoid vVisitU32(fi_tclU32& oU32);
   virtual tVoid vVisitS32(fi_tclS32& oS32);
   virtual tVoid vVisitU64(fi_tclU64& oU64);
   virtual tVoid vVisitS64(fi_tclS64& oS64);
   virtual tVoid vVisitBool(fi_tclBool& oBool);
   virtual tVoid vVisitString(fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(fi_tclList& oList);

   // Besuche die generierten Typen
   virtual tBool bDoExpand_BinContainer(tmdatafi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_s32_Meter(fi_tcl_s32_Meter& o_s32_Meter);
   virtual tVoid vVisit_s32_Second(fi_tcl_s32_Second& o_s32_Second);
   virtual tBool bDoExpand_POSIXTime(tmdatafi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_s16_KmPerHour(fi_tcl_s16_KmPerHour& o_s16_KmPerHour);
   virtual tVoid vVisit_s16_CentimeterSecond(fi_tcl_s16_CentimeterSecond& o_s16_CentimeterSecond);
   virtual tBool bDoExpand_FIVersion(tmdatafi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_s32_Longitude(fi_tcl_s32_Longitude& o_s32_Longitude);
   virtual tVoid vVisit_s32_Latitude(fi_tcl_s32_Latitude& o_s32_Latitude);
   virtual tBool bDoExpand_PositionWGS84(tmdatafi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e16_ISOCountryCode(fi_tcl_e16_ISOCountryCode& o_e16_ISOCountryCode);
   virtual tVoid vVisit_e8_BinContainerTypes(fi_tcl_e8_BinContainerTypes& o_e8_BinContainerTypes);
   virtual tBool bDoExpand_RDBId(tmdatafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TMProgramService(tmdatafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TMServiceProvider(tmdatafi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_TMCategory(fi_tcl_e8_TMCategory& o_e8_TMCategory);
   virtual tVoid vVisit_e8_TMFlowImpact(fi_tcl_e8_TMFlowImpact& o_e8_TMFlowImpact);
   virtual tVoid vVisit_e8_TMUrgency(fi_tcl_e8_TMUrgency& o_e8_TMUrgency);
   virtual tVoid vVisit_b8_TMAdditionalInformation(fi_tcl_b8_TMAdditionalInformation& o_b8_TMAdditionalInformation);
   virtual tVoid vVisit_e16_NaviEventValue(fi_tcl_e16_NaviEventValue& o_e16_NaviEventValue);
   virtual tVoid vVisit_e8_TrafficMsgType(fi_tcl_e8_TrafficMsgType& o_e8_TrafficMsgType);
   virtual tVoid vVisit_e8_EventType(fi_tcl_e8_EventType& o_e8_EventType);
   virtual tVoid vVisit_e8_TMLocationType(fi_tcl_e8_TMLocationType& o_e8_TMLocationType);
   virtual tVoid vVisit_e16_EffectCode(fi_tcl_e16_EffectCode& o_e16_EffectCode);
   virtual tVoid vVisit_e16_CauseCode(fi_tcl_e16_CauseCode& o_e16_CauseCode);
   virtual tVoid vVisit_e8_Tendency(fi_tcl_e8_Tendency& o_e8_Tendency);
   virtual tVoid vVisit_b32_TrafficMessageSource(fi_tcl_b32_TrafficMessageSource& o_b32_TrafficMessageSource);
   virtual tBool bDoExpand_TMEvent(tmdatafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TMCodedMessage(tmdatafi_tclSemanticDomain::tenType enSemantic);
#ifndef FI_S_EXTERNAL_FI
   virtual tBool bDoExpand_TMCodedMessageBinContainer(tmdatafi_tclSemanticDomain::tenType enSemantic);
#endif // FI_S_EXTERNAL_FI
   virtual tVoid vVisit_b16_TMSubstantialInformation(fi_tcl_b16_TMSubstantialInformation& o_b16_TMSubstantialInformation);
   virtual tVoid vVisit_b8_TrafficMessageSourceAvailability(fi_tcl_b8_TrafficMessageSourceAvailability& o_b8_TrafficMessageSourceAvailability);
   virtual tVoid vVisit_e8_TMHazardLocationAccuracy(fi_tcl_e8_TMHazardLocationAccuracy& o_e8_TMHazardLocationAccuracy);
   virtual tVoid vVisit_e8_TMReliability(fi_tcl_e8_TMReliability& o_e8_TMReliability);
   virtual tVoid vVisit_e8_TMHazardLocationDynamics(fi_tcl_e8_TMHazardLocationDynamics& o_e8_TMHazardLocationDynamics);
   virtual tVoid vVisit_e8_TMExtendedFlowImpact(fi_tcl_e8_TMExtendedFlowImpact& o_e8_TMExtendedFlowImpact);
   virtual tBool bDoExpand_TrafficMsgMemoryStatisticsPerType(tmdatafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TrafficMsgMemoryStatistics(tmdatafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_ISORDBIdAvailability(tmdatafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TMPreciseLocationDescription(tmdatafi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TMChangedMessage(tmdatafi_tclSemanticDomain::tenType enSemantic);
private:
	// ostream& oOut;
   tChar line[256];
   /*
	OSAL_tIODescriptor fd;
   char *ps8PrintBuf;
   tU32 u32BufSize;
   static const tU32 C_U32_MAXLINELENGTH;
   */
   fi_tclOutput* poOutput;
};


class MY_DECL tmdatafi_tclRandomInitVisitor : public tmdatafi_tclVisitorBase {
public:

   tmdatafi_tclRandomInitVisitor(tU32 u32Seed=1):u32ListSize(3) { srand(u32Seed); }
   tVoid vSetSeed(tU32 u32Seed) const { srand(u32Seed); }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(fi_tclU8& oU8);
   virtual tVoid vVisitS8(fi_tclS8& oS8);
   virtual tVoid vVisitU16(fi_tclU16& oU16);
   virtual tVoid vVisitS16(fi_tclS16& oS16);
   virtual tVoid vVisitU24(fi_tclU24& oU24);
   virtual tVoid vVisitS24(fi_tclS24& oS24);
   virtual tVoid vVisitU32(fi_tclU32& oU32);
   virtual tVoid vVisitS32(fi_tclS32& oS32);
   virtual tVoid vVisitU64(fi_tclU64& oU64);
   virtual tVoid vVisitS64(fi_tclS64& oS64);
   virtual tVoid vVisitBool(fi_tclBool& oBool);
   virtual tVoid vVisitString(fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(fi_tclList& oList);

	// Besuche die generierten Typen
   virtual tVoid vVisit_s32_Meter(fi_tcl_s32_Meter& o_s32_Meter);
   virtual tVoid vVisit_s32_Second(fi_tcl_s32_Second& o_s32_Second);
   virtual tVoid vVisit_s16_KmPerHour(fi_tcl_s16_KmPerHour& o_s16_KmPerHour);
   virtual tVoid vVisit_s16_CentimeterSecond(fi_tcl_s16_CentimeterSecond& o_s16_CentimeterSecond);
   virtual tVoid vVisit_s32_Longitude(fi_tcl_s32_Longitude& o_s32_Longitude);
   virtual tVoid vVisit_s32_Latitude(fi_tcl_s32_Latitude& o_s32_Latitude);
   virtual tVoid vVisit_e16_ISOCountryCode(fi_tcl_e16_ISOCountryCode& o_e16_ISOCountryCode);
   virtual tVoid vVisit_e8_BinContainerTypes(fi_tcl_e8_BinContainerTypes& o_e8_BinContainerTypes);
   virtual tVoid vVisit_e8_TMCategory(fi_tcl_e8_TMCategory& o_e8_TMCategory);
   virtual tVoid vVisit_e8_TMFlowImpact(fi_tcl_e8_TMFlowImpact& o_e8_TMFlowImpact);
   virtual tVoid vVisit_e8_TMUrgency(fi_tcl_e8_TMUrgency& o_e8_TMUrgency);
   virtual tVoid vVisit_b8_TMAdditionalInformation(fi_tcl_b8_TMAdditionalInformation& o_b8_TMAdditionalInformation);
   virtual tVoid vVisit_e16_NaviEventValue(fi_tcl_e16_NaviEventValue& o_e16_NaviEventValue);
   virtual tVoid vVisit_e8_TrafficMsgType(fi_tcl_e8_TrafficMsgType& o_e8_TrafficMsgType);
   virtual tVoid vVisit_e8_EventType(fi_tcl_e8_EventType& o_e8_EventType);
   virtual tVoid vVisit_e8_TMLocationType(fi_tcl_e8_TMLocationType& o_e8_TMLocationType);
   virtual tVoid vVisit_e16_EffectCode(fi_tcl_e16_EffectCode& o_e16_EffectCode);
   virtual tVoid vVisit_e16_CauseCode(fi_tcl_e16_CauseCode& o_e16_CauseCode);
   virtual tVoid vVisit_e8_Tendency(fi_tcl_e8_Tendency& o_e8_Tendency);
   virtual tVoid vVisit_b32_TrafficMessageSource(fi_tcl_b32_TrafficMessageSource& o_b32_TrafficMessageSource);
#ifndef FI_S_EXTERNAL_FI
#endif // FI_S_EXTERNAL_FI
   virtual tVoid vVisit_b16_TMSubstantialInformation(fi_tcl_b16_TMSubstantialInformation& o_b16_TMSubstantialInformation);
   virtual tVoid vVisit_b8_TrafficMessageSourceAvailability(fi_tcl_b8_TrafficMessageSourceAvailability& o_b8_TrafficMessageSourceAvailability);
   virtual tVoid vVisit_e8_TMHazardLocationAccuracy(fi_tcl_e8_TMHazardLocationAccuracy& o_e8_TMHazardLocationAccuracy);
   virtual tVoid vVisit_e8_TMReliability(fi_tcl_e8_TMReliability& o_e8_TMReliability);
   virtual tVoid vVisit_e8_TMHazardLocationDynamics(fi_tcl_e8_TMHazardLocationDynamics& o_e8_TMHazardLocationDynamics);
   virtual tVoid vVisit_e8_TMExtendedFlowImpact(fi_tcl_e8_TMExtendedFlowImpact& o_e8_TMExtendedFlowImpact);
	tU32 u32ListSize;
};

#endif
