/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef TMCTUNERFITYPES_HEADER
#define TMCTUNERFITYPES_HEADER

// #include <vector>
// 


class tmctunerfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

class tmctunerfi_tclMsgSwitchOnOffMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmctunerfi_tclMsgSwitchOnOffMethodStart():TmcOnOff(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmctunerfi_tclMsgSwitchOnOffMethodStart& operator=(const tmctunerfi_tclMsgSwitchOnOffMethodStart& coRef);
   tmctunerfi_tclMsgSwitchOnOffMethodStart(const tmctunerfi_tclMsgSwitchOnOffMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tBool TmcOnOff;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmctunerfi_tclMsgSwitchOnOffMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmctunerfi_tclToken::EN_MSG_SWITCHONOFFMETHODSTART;}
};

class tmctunerfi_tclMsgSwitchOnOffMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmctunerfi_tclMsgSwitchOnOffMethodResult():Success(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmctunerfi_tclMsgSwitchOnOffMethodResult& operator=(const tmctunerfi_tclMsgSwitchOnOffMethodResult& coRef);
   tmctunerfi_tclMsgSwitchOnOffMethodResult(const tmctunerfi_tclMsgSwitchOnOffMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tBool Success;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmctunerfi_tclMsgSwitchOnOffMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmctunerfi_tclToken::EN_MSG_SWITCHONOFFMETHODRESULT;}
};

class tmctunerfi_tclMsgSetRdbIdWishListMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmctunerfi_tclMsgSetRdbIdWishListMethodStart() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmctunerfi_tclMsgSetRdbIdWishListMethodStart& operator=(const tmctunerfi_tclMsgSetRdbIdWishListMethodStart& coRef);
   tmctunerfi_tclMsgSetRdbIdWishListMethodStart(const tmctunerfi_tclMsgSetRdbIdWishListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_TunerRdbId, std::allocator<fi_tcl_TunerRdbId> > ListOfRdbIds;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmctunerfi_tclMsgSetRdbIdWishListMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmctunerfi_tclToken::EN_MSG_SETRDBIDWISHLISTMETHODSTART;}
};

class tmctunerfi_tclMsgSetRdbIdWishListMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmctunerfi_tclMsgSetRdbIdWishListMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmctunerfi_tclMsgSetRdbIdWishListMethodResult& operator=(const tmctunerfi_tclMsgSetRdbIdWishListMethodResult& coRef);
   tmctunerfi_tclMsgSetRdbIdWishListMethodResult(const tmctunerfi_tclMsgSetRdbIdWishListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_TunerRdbId, std::allocator<fi_tcl_TunerRdbId> > ListOfRdbIds;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmctunerfi_tclMsgSetRdbIdWishListMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmctunerfi_tclToken::EN_MSG_SETRDBIDWISHLISTMETHODRESULT;}
};

class tmctunerfi_tclMsgExchangeTmcCapabilitiesMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmctunerfi_tclMsgExchangeTmcCapabilitiesMethodStart() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmctunerfi_tclMsgExchangeTmcCapabilitiesMethodStart& operator=(const tmctunerfi_tclMsgExchangeTmcCapabilitiesMethodStart& coRef);
   tmctunerfi_tclMsgExchangeTmcCapabilitiesMethodStart(const tmctunerfi_tclMsgExchangeTmcCapabilitiesMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_TmcCapability, std::allocator<fi_tcl_TmcCapability> > ListOfTmcCapabilities;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmctunerfi_tclMsgExchangeTmcCapabilitiesMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmctunerfi_tclToken::EN_MSG_EXCHANGETMCCAPABILITIESMETHODSTART;}
};

class tmctunerfi_tclMsgExchangeTmcCapabilitiesMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmctunerfi_tclMsgExchangeTmcCapabilitiesMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmctunerfi_tclMsgExchangeTmcCapabilitiesMethodResult& operator=(const tmctunerfi_tclMsgExchangeTmcCapabilitiesMethodResult& coRef);
   tmctunerfi_tclMsgExchangeTmcCapabilitiesMethodResult(const tmctunerfi_tclMsgExchangeTmcCapabilitiesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_TmcCapability, std::allocator<fi_tcl_TmcCapability> > ListOfTmcCapabilities;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmctunerfi_tclMsgExchangeTmcCapabilitiesMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmctunerfi_tclToken::EN_MSG_EXCHANGETMCCAPABILITIESMETHODRESULT;}
};

class tmctunerfi_tclMsgExchangeCapabilitiesMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmctunerfi_tclMsgExchangeCapabilitiesMethodStart() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmctunerfi_tclMsgExchangeCapabilitiesMethodStart& operator=(const tmctunerfi_tclMsgExchangeCapabilitiesMethodStart& coRef);
   tmctunerfi_tclMsgExchangeCapabilitiesMethodStart(const tmctunerfi_tclMsgExchangeCapabilitiesMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_CommonCapability, std::allocator<fi_tcl_CommonCapability> > ListOfCommonCapabilities;
   std::vector<fi_tcl_TmcCapability, std::allocator<fi_tcl_TmcCapability> > ListOfTmcCapabilities;
   std::vector<fi_tcl_TpegCapability, std::allocator<fi_tcl_TpegCapability> > ListOfTpegCapabilities;
   std::vector<fi_tcl_VersionedTpegApplication, std::allocator<fi_tcl_VersionedTpegApplication> > SupportedTpegApplications;
   std::vector<fi_tcl_e8_TpegLocReferencing, std::allocator<fi_tcl_e8_TpegLocReferencing> > SupportedTpegLocReferencing;
   std::vector<fi_tcl_e8_TpegTfpMethod, std::allocator<fi_tcl_e8_TpegTfpMethod> > SupportedTpegTfpMethods;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmctunerfi_tclMsgExchangeCapabilitiesMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmctunerfi_tclToken::EN_MSG_EXCHANGECAPABILITIESMETHODSTART;}
};

class tmctunerfi_tclMsgExchangeCapabilitiesMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmctunerfi_tclMsgExchangeCapabilitiesMethodResult() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmctunerfi_tclMsgExchangeCapabilitiesMethodResult& operator=(const tmctunerfi_tclMsgExchangeCapabilitiesMethodResult& coRef);
   tmctunerfi_tclMsgExchangeCapabilitiesMethodResult(const tmctunerfi_tclMsgExchangeCapabilitiesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_CommonCapability, std::allocator<fi_tcl_CommonCapability> > ListOfCommonCapabilities;
   std::vector<fi_tcl_TmcCapability, std::allocator<fi_tcl_TmcCapability> > ListOfTmcCapabilities;
   std::vector<fi_tcl_TpegCapability, std::allocator<fi_tcl_TpegCapability> > ListOfTpegCapabilities;
   std::vector<fi_tcl_VersionedTpegApplication, std::allocator<fi_tcl_VersionedTpegApplication> > SupportedTpegApplications;
   std::vector<fi_tcl_e8_TpegLocReferencing, std::allocator<fi_tcl_e8_TpegLocReferencing> > SupportedTpegLocReferencing;
   std::vector<fi_tcl_e8_TpegTfpMethod, std::allocator<fi_tcl_e8_TpegTfpMethod> > SupportedTpegTfpMethods;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmctunerfi_tclMsgExchangeCapabilitiesMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmctunerfi_tclToken::EN_MSG_EXCHANGECAPABILITIESMETHODRESULT;}
};

class tmctunerfi_tclMsgTunerModeGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmctunerfi_tclMsgTunerModeGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmctunerfi_tclMsgTunerModeGet& operator=(const tmctunerfi_tclMsgTunerModeGet& coRef);
   tmctunerfi_tclMsgTunerModeGet(const tmctunerfi_tclMsgTunerModeGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmctunerfi_tclMsgTunerModeGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmctunerfi_tclToken::EN_MSG_TUNERMODEGET;}
};

class tmctunerfi_tclMsgTunerModeUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmctunerfi_tclMsgTunerModeUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmctunerfi_tclMsgTunerModeUpReg& operator=(const tmctunerfi_tclMsgTunerModeUpReg& coRef);
   tmctunerfi_tclMsgTunerModeUpReg(const tmctunerfi_tclMsgTunerModeUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmctunerfi_tclMsgTunerModeUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmctunerfi_tclToken::EN_MSG_TUNERMODEUPREG;}
};

class tmctunerfi_tclMsgTunerModeRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmctunerfi_tclMsgTunerModeRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmctunerfi_tclMsgTunerModeRelUpReg& operator=(const tmctunerfi_tclMsgTunerModeRelUpReg& coRef);
   tmctunerfi_tclMsgTunerModeRelUpReg(const tmctunerfi_tclMsgTunerModeRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmctunerfi_tclMsgTunerModeRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmctunerfi_tclToken::EN_MSG_TUNERMODERELUPREG;}
};

class tmctunerfi_tclMsgTunerModeStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmctunerfi_tclMsgTunerModeStatus():TmcMode() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmctunerfi_tclMsgTunerModeStatus& operator=(const tmctunerfi_tclMsgTunerModeStatus& coRef);
   tmctunerfi_tclMsgTunerModeStatus(const tmctunerfi_tclMsgTunerModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_TmcMode TmcMode;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmctunerfi_tclMsgTunerModeStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmctunerfi_tclToken::EN_MSG_TUNERMODESTATUS;}
};

class tmctunerfi_tclMsgTmcDataGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmctunerfi_tclMsgTmcDataGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmctunerfi_tclMsgTmcDataGet& operator=(const tmctunerfi_tclMsgTmcDataGet& coRef);
   tmctunerfi_tclMsgTmcDataGet(const tmctunerfi_tclMsgTmcDataGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmctunerfi_tclMsgTmcDataGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmctunerfi_tclToken::EN_MSG_TMCDATAGET;}
};

class tmctunerfi_tclMsgTmcDataUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmctunerfi_tclMsgTmcDataUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmctunerfi_tclMsgTmcDataUpReg& operator=(const tmctunerfi_tclMsgTmcDataUpReg& coRef);
   tmctunerfi_tclMsgTmcDataUpReg(const tmctunerfi_tclMsgTmcDataUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmctunerfi_tclMsgTmcDataUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmctunerfi_tclToken::EN_MSG_TMCDATAUPREG;}
};

class tmctunerfi_tclMsgTmcDataRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmctunerfi_tclMsgTmcDataRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmctunerfi_tclMsgTmcDataRelUpReg& operator=(const tmctunerfi_tclMsgTmcDataRelUpReg& coRef);
   tmctunerfi_tclMsgTmcDataRelUpReg(const tmctunerfi_tclMsgTmcDataRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmctunerfi_tclMsgTmcDataRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmctunerfi_tclToken::EN_MSG_TMCDATARELUPREG;}
};

class tmctunerfi_tclMsgTmcDataStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmctunerfi_tclMsgTmcDataStatus():CycleStart(0),RDBId(),DataForRdbIdComplete(0),Duplicate(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmctunerfi_tclMsgTmcDataStatus& operator=(const tmctunerfi_tclMsgTmcDataStatus& coRef);
   tmctunerfi_tclMsgTmcDataStatus(const tmctunerfi_tclMsgTmcDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tBool CycleStart;
   fi_tcl_TunerRdbId RDBId;
   tBool DataForRdbIdComplete;
   tBool Duplicate;
   std::vector<fi_tcl_TrafficInfo, std::allocator<fi_tcl_TrafficInfo> > ListOfTrafficInfo;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmctunerfi_tclMsgTmcDataStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmctunerfi_tclToken::EN_MSG_TMCDATASTATUS;}
};

class tmctunerfi_tclMsgOperationModeGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmctunerfi_tclMsgOperationModeGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmctunerfi_tclMsgOperationModeGet& operator=(const tmctunerfi_tclMsgOperationModeGet& coRef);
   tmctunerfi_tclMsgOperationModeGet(const tmctunerfi_tclMsgOperationModeGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmctunerfi_tclMsgOperationModeGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmctunerfi_tclToken::EN_MSG_OPERATIONMODEGET;}
};

class tmctunerfi_tclMsgOperationModeUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmctunerfi_tclMsgOperationModeUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmctunerfi_tclMsgOperationModeUpReg& operator=(const tmctunerfi_tclMsgOperationModeUpReg& coRef);
   tmctunerfi_tclMsgOperationModeUpReg(const tmctunerfi_tclMsgOperationModeUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmctunerfi_tclMsgOperationModeUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmctunerfi_tclToken::EN_MSG_OPERATIONMODEUPREG;}
};

class tmctunerfi_tclMsgOperationModeRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmctunerfi_tclMsgOperationModeRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmctunerfi_tclMsgOperationModeRelUpReg& operator=(const tmctunerfi_tclMsgOperationModeRelUpReg& coRef);
   tmctunerfi_tclMsgOperationModeRelUpReg(const tmctunerfi_tclMsgOperationModeRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmctunerfi_tclMsgOperationModeRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmctunerfi_tclToken::EN_MSG_OPERATIONMODERELUPREG;}
};

class tmctunerfi_tclMsgOperationModeStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmctunerfi_tclMsgOperationModeStatus():TmcOperationMode() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmctunerfi_tclMsgOperationModeStatus& operator=(const tmctunerfi_tclMsgOperationModeStatus& coRef);
   tmctunerfi_tclMsgOperationModeStatus(const tmctunerfi_tclMsgOperationModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_TmcOperationMode TmcOperationMode;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmctunerfi_tclMsgOperationModeStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmctunerfi_tclToken::EN_MSG_OPERATIONMODESTATUS;}
};

class tmctunerfi_tclMsgRdbIdActualListGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmctunerfi_tclMsgRdbIdActualListGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmctunerfi_tclMsgRdbIdActualListGet& operator=(const tmctunerfi_tclMsgRdbIdActualListGet& coRef);
   tmctunerfi_tclMsgRdbIdActualListGet(const tmctunerfi_tclMsgRdbIdActualListGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmctunerfi_tclMsgRdbIdActualListGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmctunerfi_tclToken::EN_MSG_RDBIDACTUALLISTGET;}
};

class tmctunerfi_tclMsgRdbIdActualListUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmctunerfi_tclMsgRdbIdActualListUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmctunerfi_tclMsgRdbIdActualListUpReg& operator=(const tmctunerfi_tclMsgRdbIdActualListUpReg& coRef);
   tmctunerfi_tclMsgRdbIdActualListUpReg(const tmctunerfi_tclMsgRdbIdActualListUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmctunerfi_tclMsgRdbIdActualListUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmctunerfi_tclToken::EN_MSG_RDBIDACTUALLISTUPREG;}
};

class tmctunerfi_tclMsgRdbIdActualListRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmctunerfi_tclMsgRdbIdActualListRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmctunerfi_tclMsgRdbIdActualListRelUpReg& operator=(const tmctunerfi_tclMsgRdbIdActualListRelUpReg& coRef);
   tmctunerfi_tclMsgRdbIdActualListRelUpReg(const tmctunerfi_tclMsgRdbIdActualListRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmctunerfi_tclMsgRdbIdActualListRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmctunerfi_tclToken::EN_MSG_RDBIDACTUALLISTRELUPREG;}
};

class tmctunerfi_tclMsgRdbIdActualListStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmctunerfi_tclMsgRdbIdActualListStatus():ReceptionState() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmctunerfi_tclMsgRdbIdActualListStatus& operator=(const tmctunerfi_tclMsgRdbIdActualListStatus& coRef);
   tmctunerfi_tclMsgRdbIdActualListStatus(const tmctunerfi_tclMsgRdbIdActualListStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_TunerReceptionState ReceptionState;
   std::vector<fi_tcl_TunerRdbId, std::allocator<fi_tcl_TunerRdbId> > ListOfRdbIds;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmctunerfi_tclMsgRdbIdActualListStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmctunerfi_tclToken::EN_MSG_RDBIDACTUALLISTSTATUS;}
};

class tmctunerfi_tclMsgTunerStateAndModeGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmctunerfi_tclMsgTunerStateAndModeGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmctunerfi_tclMsgTunerStateAndModeGet& operator=(const tmctunerfi_tclMsgTunerStateAndModeGet& coRef);
   tmctunerfi_tclMsgTunerStateAndModeGet(const tmctunerfi_tclMsgTunerStateAndModeGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmctunerfi_tclMsgTunerStateAndModeGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmctunerfi_tclToken::EN_MSG_TUNERSTATEANDMODEGET;}
};

class tmctunerfi_tclMsgTunerStateAndModeUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmctunerfi_tclMsgTunerStateAndModeUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmctunerfi_tclMsgTunerStateAndModeUpReg& operator=(const tmctunerfi_tclMsgTunerStateAndModeUpReg& coRef);
   tmctunerfi_tclMsgTunerStateAndModeUpReg(const tmctunerfi_tclMsgTunerStateAndModeUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmctunerfi_tclMsgTunerStateAndModeUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmctunerfi_tclToken::EN_MSG_TUNERSTATEANDMODEUPREG;}
};

class tmctunerfi_tclMsgTunerStateAndModeRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmctunerfi_tclMsgTunerStateAndModeRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmctunerfi_tclMsgTunerStateAndModeRelUpReg& operator=(const tmctunerfi_tclMsgTunerStateAndModeRelUpReg& coRef);
   tmctunerfi_tclMsgTunerStateAndModeRelUpReg(const tmctunerfi_tclMsgTunerStateAndModeRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmctunerfi_tclMsgTunerStateAndModeRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmctunerfi_tclToken::EN_MSG_TUNERSTATEANDMODERELUPREG;}
};

class tmctunerfi_tclMsgTunerStateAndModeStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmctunerfi_tclMsgTunerStateAndModeStatus():TunerState(),OperationMode(),Message() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmctunerfi_tclMsgTunerStateAndModeStatus& operator=(const tmctunerfi_tclMsgTunerStateAndModeStatus& coRef);
   tmctunerfi_tclMsgTunerStateAndModeStatus(const tmctunerfi_tclMsgTunerStateAndModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_TunerState TunerState;
   fi_tcl_e8_OperationMode OperationMode;
   fi_tclString Message;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmctunerfi_tclMsgTunerStateAndModeStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmctunerfi_tclToken::EN_MSG_TUNERSTATEANDMODESTATUS;}
};

class tmctunerfi_tclMsgCurrentUserSelectedTmcStationGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmctunerfi_tclMsgCurrentUserSelectedTmcStationGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmctunerfi_tclMsgCurrentUserSelectedTmcStationGet& operator=(const tmctunerfi_tclMsgCurrentUserSelectedTmcStationGet& coRef);
   tmctunerfi_tclMsgCurrentUserSelectedTmcStationGet(const tmctunerfi_tclMsgCurrentUserSelectedTmcStationGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmctunerfi_tclMsgCurrentUserSelectedTmcStationGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmctunerfi_tclToken::EN_MSG_CURRENTUSERSELECTEDTMCSTATIONGET;}
};

class tmctunerfi_tclMsgCurrentUserSelectedTmcStationUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmctunerfi_tclMsgCurrentUserSelectedTmcStationUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmctunerfi_tclMsgCurrentUserSelectedTmcStationUpReg& operator=(const tmctunerfi_tclMsgCurrentUserSelectedTmcStationUpReg& coRef);
   tmctunerfi_tclMsgCurrentUserSelectedTmcStationUpReg(const tmctunerfi_tclMsgCurrentUserSelectedTmcStationUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmctunerfi_tclMsgCurrentUserSelectedTmcStationUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmctunerfi_tclToken::EN_MSG_CURRENTUSERSELECTEDTMCSTATIONUPREG;}
};

class tmctunerfi_tclMsgCurrentUserSelectedTmcStationRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmctunerfi_tclMsgCurrentUserSelectedTmcStationRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmctunerfi_tclMsgCurrentUserSelectedTmcStationRelUpReg& operator=(const tmctunerfi_tclMsgCurrentUserSelectedTmcStationRelUpReg& coRef);
   tmctunerfi_tclMsgCurrentUserSelectedTmcStationRelUpReg(const tmctunerfi_tclMsgCurrentUserSelectedTmcStationRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmctunerfi_tclMsgCurrentUserSelectedTmcStationRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmctunerfi_tclToken::EN_MSG_CURRENTUSERSELECTEDTMCSTATIONRELUPREG;}
};

class tmctunerfi_tclMsgCurrentUserSelectedTmcStationStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmctunerfi_tclMsgCurrentUserSelectedTmcStationStatus():RDBId(),ProgramId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmctunerfi_tclMsgCurrentUserSelectedTmcStationStatus& operator=(const tmctunerfi_tclMsgCurrentUserSelectedTmcStationStatus& coRef);
   tmctunerfi_tclMsgCurrentUserSelectedTmcStationStatus(const tmctunerfi_tclMsgCurrentUserSelectedTmcStationStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_TunerRdbId RDBId;
   tU16 ProgramId;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmctunerfi_tclMsgCurrentUserSelectedTmcStationStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmctunerfi_tclToken::EN_MSG_CURRENTUSERSELECTEDTMCSTATIONSTATUS;}
};

class tmctunerfi_tclMsgTpegDataGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmctunerfi_tclMsgTpegDataGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmctunerfi_tclMsgTpegDataGet& operator=(const tmctunerfi_tclMsgTpegDataGet& coRef);
   tmctunerfi_tclMsgTpegDataGet(const tmctunerfi_tclMsgTpegDataGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmctunerfi_tclMsgTpegDataGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmctunerfi_tclToken::EN_MSG_TPEGDATAGET;}
};

class tmctunerfi_tclMsgTpegDataUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmctunerfi_tclMsgTpegDataUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmctunerfi_tclMsgTpegDataUpReg& operator=(const tmctunerfi_tclMsgTpegDataUpReg& coRef);
   tmctunerfi_tclMsgTpegDataUpReg(const tmctunerfi_tclMsgTpegDataUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmctunerfi_tclMsgTpegDataUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmctunerfi_tclToken::EN_MSG_TPEGDATAUPREG;}
};

class tmctunerfi_tclMsgTpegDataRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmctunerfi_tclMsgTpegDataRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmctunerfi_tclMsgTpegDataRelUpReg& operator=(const tmctunerfi_tclMsgTpegDataRelUpReg& coRef);
   tmctunerfi_tclMsgTpegDataRelUpReg(const tmctunerfi_tclMsgTpegDataRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmctunerfi_tclMsgTpegDataRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmctunerfi_tclToken::EN_MSG_TPEGDATARELUPREG;}
};

class tmctunerfi_tclMsgTpegDataStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   tmctunerfi_tclMsgTpegDataStatus() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   tmctunerfi_tclMsgTpegDataStatus& operator=(const tmctunerfi_tclMsgTpegDataStatus& coRef);
   tmctunerfi_tclMsgTpegDataStatus(const tmctunerfi_tclMsgTpegDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   std::vector<fi_tcl_TpegMessage, std::allocator<fi_tcl_TpegMessage> > ListOfTpegMessages;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const tmctunerfi_tclMsgTpegDataStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return tmctunerfi_tclToken::EN_MSG_TPEGDATASTATUS;}
};


#endif
