#ifndef TMCTUNERFILANGUAGE_HEADER
#define TMCTUNERFILANGUAGE_HEADER

class tmctunerfi_tclInContext;
class tmctunerfi_tclOutContext;
class tmctunerfi_tclVisitorBase;

class MY_DECL tmctunerfi_tclDescription {
 public:
  enum tenType { EN_PARSING, EN_GENERATING };	
  
  tmctunerfi_tclDescription(fi_tclInContext* poIn, tmctunerfi_tclVisitorBase* poVisit);
  tmctunerfi_tclDescription(fi_tclOutContext* poOut, tmctunerfi_tclVisitorBase* poVisit);
  
  /* --Hier kommen nun die Methoden, die einzelne Nachrichten entspr. NaFI 
		erzeugen (EN_GENERATING) bzw. einlesen (EN_PARSING). */

  tBool bInitMessage(tmctunerfi_tclToken::tenType enMsgToken);
  tBool bProcessMessage();

  // tBool bProcessElement(); 

  tBool bDoIt(fi_tclVisitableTypeBase& poBaseType);
#ifndef FI_S_EXTERNAL_FI
  void vEnableSpecialBinContainer() { bUseSpecialBinContainer = true; }
#endif

 private:
  /* default constructor */ tmctunerfi_tclDescription();  //lint !e1704 // always use parameters
  tenType enType; //--read or write?

  union {
    fi_tclInContext* poInContext;
    fi_tclOutContext* poOutContext;
  };

  tmctunerfi_tclVisitorBase* poVisitor;

  // typedef navifi_tclTraversePath::tclKnot tclKnot;

  tBool bUseSpecialBinContainer;  
  
 public:
  
  // --Traversierungspfad
  fi_tclTraversePath<tmctunerfi_tclKnot> oPath;
  //   navifi_tclTraversePath oPath;
  fi_tclTraversePath<tmctunerfi_tclKnot> oCallStack;
   //  navifi_tclTraversePath oCallStack;
  
};

// --Inline-Implementierungen
inline tmctunerfi_tclDescription::tmctunerfi_tclDescription(fi_tclInContext* poIn, tmctunerfi_tclVisitorBase* poVisit):
  enType(EN_PARSING),poInContext(poIn),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

inline tmctunerfi_tclDescription::tmctunerfi_tclDescription(fi_tclOutContext* poOut, tmctunerfi_tclVisitorBase* poVisit):
  enType(EN_GENERATING),poOutContext(poOut),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

#endif

