/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef TEAFITYPES_HEADER
#define TEAFITYPES_HEADER

// #include <vector>
// 


class teafi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

class teafi_tclMsgGetTEAHorizonMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   teafi_tclMsgGetTEAHorizonMethodStart():RequestedMDBData() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   teafi_tclMsgGetTEAHorizonMethodStart& operator=(const teafi_tclMsgGetTEAHorizonMethodStart& coRef);
   teafi_tclMsgGetTEAHorizonMethodStart(const teafi_tclMsgGetTEAHorizonMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_b32_RoadInfoCategoryIndicator RequestedMDBData;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const teafi_tclMsgGetTEAHorizonMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return teafi_tclToken::EN_MSG_GETTEAHORIZONMETHODSTART;}
};

class teafi_tclMsgGetTEAHorizonMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   teafi_tclMsgGetTEAHorizonMethodResult():ReleaseId(0),PositionHorizonState(),RequestedMDBData(),DataBaseId(0),IndexOfRootInLastHorizon(),IndexOfLastRootInCurrentHorizon(0xFFFF),TripHandle(),RouteHandle(),TripSegmentNumber(),RouteInfoId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   teafi_tclMsgGetTEAHorizonMethodResult& operator=(const teafi_tclMsgGetTEAHorizonMethodResult& coRef);
   teafi_tclMsgGetTEAHorizonMethodResult(const teafi_tclMsgGetTEAHorizonMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 ReleaseId;
   fi_tcl_e8_PosHorizonState PositionHorizonState;
   fi_tcl_b32_RoadInfoCategoryIndicator RequestedMDBData;
   std::vector<fi_tcl_b8_TEAPresenceIndicator, std::allocator<fi_tcl_b8_TEAPresenceIndicator> > PathSectionStateList;
   tU32 DataBaseId;
   fi_tcl_u16_IndexInReferenceList IndexOfRootInLastHorizon;
   std::vector<fi_tcl_PosHorizonRootElement, std::allocator<fi_tcl_PosHorizonRootElement> > RootList;
   fi_tcl_u16_IndexInReferenceList IndexOfLastRootInCurrentHorizon;
   std::vector<fi_tcl_u16_IndexInReferenceList, std::allocator<fi_tcl_u16_IndexInReferenceList> > IndicesOfLastRootsInCurrentHorizon;
   fi_tcl_u16_TripHandle TripHandle;
   fi_tcl_u16_RouteHandle RouteHandle;
   fi_tcl_u16_TripSegmentNumber TripSegmentNumber;
   tU32 RouteInfoId;
   std::vector<fi_tcl_PosHorizonPathSection, std::allocator<fi_tcl_PosHorizonPathSection> > PathSectionList;
   std::vector<fi_tcl_PosHorizonOneCellSection, std::allocator<fi_tcl_PosHorizonOneCellSection> > OneCellRefList;
   std::vector<fi_tcl_NavClusterDesc, std::allocator<fi_tcl_NavClusterDesc> > ClusterRefList;
   std::vector<fi_tcl_TEAEventID, std::allocator<fi_tcl_TEAEventID> > TEAEventIDList;
   std::vector<fi_tcl_AlternativTEAEventIDList, std::allocator<fi_tcl_AlternativTEAEventIDList> > AlternativTEAEventList;
   std::vector<fi_tcl_HorizonMostProbablePath, std::allocator<fi_tcl_HorizonMostProbablePath> > MostProbablePathesList;
   std::vector<fi_tcl_HorizonRoadInfoUnion, std::allocator<fi_tcl_HorizonRoadInfoUnion> > RoadInfo;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const teafi_tclMsgGetTEAHorizonMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return teafi_tclToken::EN_MSG_GETTEAHORIZONMETHODRESULT;}
};

class teafi_tclMsgGetUPOIsMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   teafi_tclMsgGetUPOIsMethodStart():FilterList() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   teafi_tclMsgGetUPOIsMethodStart& operator=(const teafi_tclMsgGetUPOIsMethodStart& coRef);
   teafi_tclMsgGetUPOIsMethodStart(const teafi_tclMsgGetUPOIsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_UPOI_FilterList FilterList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const teafi_tclMsgGetUPOIsMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return teafi_tclToken::EN_MSG_GETUPOISMETHODSTART;}
};

class teafi_tclMsgGetUPOIsMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   teafi_tclMsgGetUPOIsMethodResult():ReleaseId(0),ListSetInfoPercentageUPOI(),UPOIListSet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   teafi_tclMsgGetUPOIsMethodResult& operator=(const teafi_tclMsgGetUPOIsMethodResult& coRef);
   teafi_tclMsgGetUPOIsMethodResult(const teafi_tclMsgGetUPOIsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 ReleaseId;
   fi_tcl_u8_Percent ListSetInfoPercentageUPOI;
   fi_tcl_UPOI_ListSet UPOIListSet;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const teafi_tclMsgGetUPOIsMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return teafi_tclToken::EN_MSG_GETUPOISMETHODRESULT;}
};

class teafi_tclMsgTEAHorizonGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   teafi_tclMsgTEAHorizonGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   teafi_tclMsgTEAHorizonGet& operator=(const teafi_tclMsgTEAHorizonGet& coRef);
   teafi_tclMsgTEAHorizonGet(const teafi_tclMsgTEAHorizonGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const teafi_tclMsgTEAHorizonGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return teafi_tclToken::EN_MSG_TEAHORIZONGET;}
};

class teafi_tclMsgTEAHorizonUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   teafi_tclMsgTEAHorizonUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   teafi_tclMsgTEAHorizonUpReg& operator=(const teafi_tclMsgTEAHorizonUpReg& coRef);
   teafi_tclMsgTEAHorizonUpReg(const teafi_tclMsgTEAHorizonUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const teafi_tclMsgTEAHorizonUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return teafi_tclToken::EN_MSG_TEAHORIZONUPREG;}
};

class teafi_tclMsgTEAHorizonRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   teafi_tclMsgTEAHorizonRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   teafi_tclMsgTEAHorizonRelUpReg& operator=(const teafi_tclMsgTEAHorizonRelUpReg& coRef);
   teafi_tclMsgTEAHorizonRelUpReg(const teafi_tclMsgTEAHorizonRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const teafi_tclMsgTEAHorizonRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return teafi_tclToken::EN_MSG_TEAHORIZONRELUPREG;}
};

class teafi_tclMsgTEAHorizonStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   teafi_tclMsgTEAHorizonStatus():ReleaseId(0),PositionHorizonState(),RequestedMDBData(),DataBaseId(0),IndexOfRootInLastHorizon() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   teafi_tclMsgTEAHorizonStatus& operator=(const teafi_tclMsgTEAHorizonStatus& coRef);
   teafi_tclMsgTEAHorizonStatus(const teafi_tclMsgTEAHorizonStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 ReleaseId;
   fi_tcl_e8_PosHorizonState PositionHorizonState;
   fi_tcl_b32_RoadInfoCategoryIndicator RequestedMDBData;
   std::vector<fi_tcl_b8_TEAPresenceIndicator, std::allocator<fi_tcl_b8_TEAPresenceIndicator> > PathSectionStateList;
   tU32 DataBaseId;
   fi_tcl_u16_IndexInReferenceList IndexOfRootInLastHorizon;
   std::vector<fi_tcl_PosHorizonPathSection, std::allocator<fi_tcl_PosHorizonPathSection> > PathSectionList;
   std::vector<fi_tcl_PosHorizonOneCellSection, std::allocator<fi_tcl_PosHorizonOneCellSection> > OneCellRefList;
   std::vector<fi_tcl_NavClusterDesc, std::allocator<fi_tcl_NavClusterDesc> > ClusterRefList;
   std::vector<fi_tcl_HorizonRoadInfoUnion, std::allocator<fi_tcl_HorizonRoadInfoUnion> > RoadInfo;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const teafi_tclMsgTEAHorizonStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return teafi_tclToken::EN_MSG_TEAHORIZONSTATUS;}
};

class teafi_tclMsgTEAHorizonStateGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   teafi_tclMsgTEAHorizonStateGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   teafi_tclMsgTEAHorizonStateGet& operator=(const teafi_tclMsgTEAHorizonStateGet& coRef);
   teafi_tclMsgTEAHorizonStateGet(const teafi_tclMsgTEAHorizonStateGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const teafi_tclMsgTEAHorizonStateGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return teafi_tclToken::EN_MSG_TEAHORIZONSTATEGET;}
};

class teafi_tclMsgTEAHorizonStateUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   teafi_tclMsgTEAHorizonStateUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   teafi_tclMsgTEAHorizonStateUpReg& operator=(const teafi_tclMsgTEAHorizonStateUpReg& coRef);
   teafi_tclMsgTEAHorizonStateUpReg(const teafi_tclMsgTEAHorizonStateUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const teafi_tclMsgTEAHorizonStateUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return teafi_tclToken::EN_MSG_TEAHORIZONSTATEUPREG;}
};

class teafi_tclMsgTEAHorizonStateRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   teafi_tclMsgTEAHorizonStateRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   teafi_tclMsgTEAHorizonStateRelUpReg& operator=(const teafi_tclMsgTEAHorizonStateRelUpReg& coRef);
   teafi_tclMsgTEAHorizonStateRelUpReg(const teafi_tclMsgTEAHorizonStateRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const teafi_tclMsgTEAHorizonStateRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return teafi_tclToken::EN_MSG_TEAHORIZONSTATERELUPREG;}
};

class teafi_tclMsgTEAHorizonStateStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   teafi_tclMsgTEAHorizonStateStatus():ReleaseId(0),PositionHorizonState(),RequestableMDBData(),ListSetInfoPercentageMDB(),ListSetInfoPercentageEDM(),ListSetInfoPercentageUPOI(),DataBaseId(0),TripHandle(),RouteHandle(),TripSegmentNumber(),RouteInfoId(0),AvailablePOISources(),ChangedPOISources() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   teafi_tclMsgTEAHorizonStateStatus& operator=(const teafi_tclMsgTEAHorizonStateStatus& coRef);
   teafi_tclMsgTEAHorizonStateStatus(const teafi_tclMsgTEAHorizonStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 ReleaseId;
   fi_tcl_e8_PosHorizonState PositionHorizonState;
   fi_tcl_b32_RoadInfoCategoryIndicator RequestableMDBData;
   std::vector<fi_tcl_b8_TEAPresenceIndicator, std::allocator<fi_tcl_b8_TEAPresenceIndicator> > PathSectionStateList;
   fi_tcl_u8_Percent ListSetInfoPercentageMDB;
   fi_tcl_u8_Percent ListSetInfoPercentageEDM;
   fi_tcl_u8_Percent ListSetInfoPercentageUPOI;
   tU32 DataBaseId;
   fi_tcl_u16_TripHandle TripHandle;
   fi_tcl_u16_RouteHandle RouteHandle;
   fi_tcl_u16_TripSegmentNumber TripSegmentNumber;
   tU32 RouteInfoId;
   fi_tcl_b16_UPOI_Source AvailablePOISources;
   fi_tcl_b16_UPOI_Source ChangedPOISources;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const teafi_tclMsgTEAHorizonStateStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return teafi_tclToken::EN_MSG_TEAHORIZONSTATESTATUS;}
};

class teafi_tclMsgMostProbableTEAPathGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   teafi_tclMsgMostProbableTEAPathGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   teafi_tclMsgMostProbableTEAPathGet& operator=(const teafi_tclMsgMostProbableTEAPathGet& coRef);
   teafi_tclMsgMostProbableTEAPathGet(const teafi_tclMsgMostProbableTEAPathGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const teafi_tclMsgMostProbableTEAPathGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return teafi_tclToken::EN_MSG_MOSTPROBABLETEAPATHGET;}
};

class teafi_tclMsgMostProbableTEAPathUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   teafi_tclMsgMostProbableTEAPathUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   teafi_tclMsgMostProbableTEAPathUpReg& operator=(const teafi_tclMsgMostProbableTEAPathUpReg& coRef);
   teafi_tclMsgMostProbableTEAPathUpReg(const teafi_tclMsgMostProbableTEAPathUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const teafi_tclMsgMostProbableTEAPathUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return teafi_tclToken::EN_MSG_MOSTPROBABLETEAPATHUPREG;}
};

class teafi_tclMsgMostProbableTEAPathRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   teafi_tclMsgMostProbableTEAPathRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   teafi_tclMsgMostProbableTEAPathRelUpReg& operator=(const teafi_tclMsgMostProbableTEAPathRelUpReg& coRef);
   teafi_tclMsgMostProbableTEAPathRelUpReg(const teafi_tclMsgMostProbableTEAPathRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const teafi_tclMsgMostProbableTEAPathRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return teafi_tclToken::EN_MSG_MOSTPROBABLETEAPATHRELUPREG;}
};

class teafi_tclMsgMostProbableTEAPathStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   teafi_tclMsgMostProbableTEAPathStatus():ReleaseId(0),MPPState() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   teafi_tclMsgMostProbableTEAPathStatus& operator=(const teafi_tclMsgMostProbableTEAPathStatus& coRef);
   teafi_tclMsgMostProbableTEAPathStatus(const teafi_tclMsgMostProbableTEAPathStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 ReleaseId;
   std::vector<tU16, std::allocator<tU16> > PathSectionListIndices;
   std::vector<fi_tcl_MPPData, std::allocator<fi_tcl_MPPData> > MPPList;
   fi_tcl_e8_MPPState MPPState;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const teafi_tclMsgMostProbableTEAPathStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return teafi_tclToken::EN_MSG_MOSTPROBABLETEAPATHSTATUS;}
};

class teafi_tclMsgEngineeringTextGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   teafi_tclMsgEngineeringTextGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   teafi_tclMsgEngineeringTextGet& operator=(const teafi_tclMsgEngineeringTextGet& coRef);
   teafi_tclMsgEngineeringTextGet(const teafi_tclMsgEngineeringTextGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const teafi_tclMsgEngineeringTextGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return teafi_tclToken::EN_MSG_ENGINEERINGTEXTGET;}
};

class teafi_tclMsgEngineeringTextUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   teafi_tclMsgEngineeringTextUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   teafi_tclMsgEngineeringTextUpReg& operator=(const teafi_tclMsgEngineeringTextUpReg& coRef);
   teafi_tclMsgEngineeringTextUpReg(const teafi_tclMsgEngineeringTextUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const teafi_tclMsgEngineeringTextUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return teafi_tclToken::EN_MSG_ENGINEERINGTEXTUPREG;}
};

class teafi_tclMsgEngineeringTextRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   teafi_tclMsgEngineeringTextRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   teafi_tclMsgEngineeringTextRelUpReg& operator=(const teafi_tclMsgEngineeringTextRelUpReg& coRef);
   teafi_tclMsgEngineeringTextRelUpReg(const teafi_tclMsgEngineeringTextRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const teafi_tclMsgEngineeringTextRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return teafi_tclToken::EN_MSG_ENGINEERINGTEXTRELUPREG;}
};

class teafi_tclMsgEngineeringTextStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   teafi_tclMsgEngineeringTextStatus():Message() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   teafi_tclMsgEngineeringTextStatus& operator=(const teafi_tclMsgEngineeringTextStatus& coRef);
   teafi_tclMsgEngineeringTextStatus(const teafi_tclMsgEngineeringTextStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tclString Message;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const teafi_tclMsgEngineeringTextStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return teafi_tclToken::EN_MSG_ENGINEERINGTEXTSTATUS;}
};


#endif
