/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#include "precompiled.hh"
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
teafi_tclMsgGetTEAHorizonMethodStart::teafi_tclMsgGetTEAHorizonMethodStart(const teafi_tclMsgGetTEAHorizonMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   RequestedMDBData = coRef.RequestedMDBData;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
teafi_tclMsgGetTEAHorizonMethodStart& teafi_tclMsgGetTEAHorizonMethodStart::operator=(const teafi_tclMsgGetTEAHorizonMethodStart& coRef)
{
   if (this == &coRef) return *this;
   RequestedMDBData = coRef.RequestedMDBData;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 teafi_tclMsgGetTEAHorizonMethodStart::u16GetServiceID() const {return TEAFI_C_U16_SERVICE_ID;}
tU16 teafi_tclMsgGetTEAHorizonMethodStart::u16GetFunctionID() const {return TEAFI_C_U16_GETTEAHORIZON;}
tU8 teafi_tclMsgGetTEAHorizonMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 teafi_tclMsgGetTEAHorizonMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool teafi_tclMsgGetTEAHorizonMethodStart::operator==(const teafi_tclMsgGetTEAHorizonMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (RequestedMDBData == rfoCmp.RequestedMDBData);
   return bResult;
}

fi_tclInContext& teafi_tclMsgGetTEAHorizonMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> RequestedMDBData;
   return oIn;
}

fi_tclOutContext& teafi_tclMsgGetTEAHorizonMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << RequestedMDBData;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
teafi_tclMsgGetTEAHorizonMethodResult::teafi_tclMsgGetTEAHorizonMethodResult(const teafi_tclMsgGetTEAHorizonMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   ReleaseId = coRef.ReleaseId;
   PositionHorizonState = coRef.PositionHorizonState;
   RequestedMDBData = coRef.RequestedMDBData;
   PathSectionStateList = coRef.PathSectionStateList;
   DataBaseId = coRef.DataBaseId;
   IndexOfRootInLastHorizon = coRef.IndexOfRootInLastHorizon;
   RootList = coRef.RootList;
   IndexOfLastRootInCurrentHorizon = coRef.IndexOfLastRootInCurrentHorizon;
   IndicesOfLastRootsInCurrentHorizon = coRef.IndicesOfLastRootsInCurrentHorizon;
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   TripSegmentNumber = coRef.TripSegmentNumber;
   RouteInfoId = coRef.RouteInfoId;
   PathSectionList = coRef.PathSectionList;
   OneCellRefList = coRef.OneCellRefList;
   ClusterRefList = coRef.ClusterRefList;
   TEAEventIDList = coRef.TEAEventIDList;
   AlternativTEAEventList = coRef.AlternativTEAEventList;
   MostProbablePathesList = coRef.MostProbablePathesList;
   RoadInfo = coRef.RoadInfo;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
teafi_tclMsgGetTEAHorizonMethodResult& teafi_tclMsgGetTEAHorizonMethodResult::operator=(const teafi_tclMsgGetTEAHorizonMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ReleaseId = coRef.ReleaseId;
   PositionHorizonState = coRef.PositionHorizonState;
   RequestedMDBData = coRef.RequestedMDBData;
   PathSectionStateList = coRef.PathSectionStateList;
   DataBaseId = coRef.DataBaseId;
   IndexOfRootInLastHorizon = coRef.IndexOfRootInLastHorizon;
   RootList = coRef.RootList;
   IndexOfLastRootInCurrentHorizon = coRef.IndexOfLastRootInCurrentHorizon;
   IndicesOfLastRootsInCurrentHorizon = coRef.IndicesOfLastRootsInCurrentHorizon;
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   TripSegmentNumber = coRef.TripSegmentNumber;
   RouteInfoId = coRef.RouteInfoId;
   PathSectionList = coRef.PathSectionList;
   OneCellRefList = coRef.OneCellRefList;
   ClusterRefList = coRef.ClusterRefList;
   TEAEventIDList = coRef.TEAEventIDList;
   AlternativTEAEventList = coRef.AlternativTEAEventList;
   MostProbablePathesList = coRef.MostProbablePathesList;
   RoadInfo = coRef.RoadInfo;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 teafi_tclMsgGetTEAHorizonMethodResult::u16GetServiceID() const {return TEAFI_C_U16_SERVICE_ID;}
tU16 teafi_tclMsgGetTEAHorizonMethodResult::u16GetFunctionID() const {return TEAFI_C_U16_GETTEAHORIZON;}
tU8 teafi_tclMsgGetTEAHorizonMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid teafi_tclMsgGetTEAHorizonMethodResult::vDestroy()
{
   PathSectionStateList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < RootList.size(); ++u32Idx)
         RootList[u32Idx].vDestroy();
   }
   RootList.clear();
   IndicesOfLastRootsInCurrentHorizon.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < PathSectionList.size(); ++u32Idx)
         PathSectionList[u32Idx].vDestroy();
   }
   PathSectionList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < OneCellRefList.size(); ++u32Idx)
         OneCellRefList[u32Idx].vDestroy();
   }
   OneCellRefList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < ClusterRefList.size(); ++u32Idx)
         ClusterRefList[u32Idx].vDestroy();
   }
   ClusterRefList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < TEAEventIDList.size(); ++u32Idx)
         TEAEventIDList[u32Idx].vDestroy();
   }
   TEAEventIDList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < AlternativTEAEventList.size(); ++u32Idx)
         AlternativTEAEventList[u32Idx].vDestroy();
   }
   AlternativTEAEventList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < MostProbablePathesList.size(); ++u32Idx)
         MostProbablePathesList[u32Idx].vDestroy();
   }
   MostProbablePathesList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < RoadInfo.size(); ++u32Idx)
         RoadInfo[u32Idx].vDestroy();
   }
   RoadInfo.clear();
}

tU32 teafi_tclMsgGetTEAHorizonMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (u16MajorVersion <= 18)
   {
      u32DynamicSize += 2;
   }
   if (19 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
      u32DynamicSize += RootList.size()*5;
   }
   if ((11 <= u16MajorVersion) && (u16MajorVersion <= 18))
   {
      u32DynamicSize += 2;
   }
   if (19 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
      u32DynamicSize += IndicesOfLastRootsInCurrentHorizon.size()*2;
   }
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += 2;
   }
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += 2;
   }
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += 2;
   }
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < PathSectionList.size(); ++u32ListIdx)
      u32DynamicSize += PathSectionList[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < OneCellRefList.size(); ++u32ListIdx)
      u32DynamicSize += OneCellRefList[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < AlternativTEAEventList.size(); ++u32ListIdx)
      u32DynamicSize += AlternativTEAEventList[u32ListIdx].u32GetSize(u16MajorVersion);
   if (11 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
      for (u32ListIdx = 0; u32ListIdx < MostProbablePathesList.size(); ++u32ListIdx)
         u32DynamicSize += MostProbablePathesList[u32ListIdx].u32GetSize(u16MajorVersion);
   }
   for (u32ListIdx = 0; u32ListIdx < RoadInfo.size(); ++u32ListIdx)
      u32DynamicSize += RoadInfo[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+41+PathSectionStateList.size()*1+ClusterRefList.size()*9+TEAEventIDList.size()*5;
}

tBool teafi_tclMsgGetTEAHorizonMethodResult::operator==(const teafi_tclMsgGetTEAHorizonMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ReleaseId == rfoCmp.ReleaseId);
      bResult = bResult && (PositionHorizonState == rfoCmp.PositionHorizonState);
      bResult = bResult && (RequestedMDBData == rfoCmp.RequestedMDBData);
      bResult = bResult && (PathSectionStateList.size() == rfoCmp.PathSectionStateList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PathSectionStateList.size()); ++u32Idx)
            bResult = bResult && (PathSectionStateList[u32Idx] == rfoCmp.PathSectionStateList[u32Idx]);
      }
      bResult = bResult && (DataBaseId == rfoCmp.DataBaseId);
      bResult = bResult && (IndexOfRootInLastHorizon == rfoCmp.IndexOfRootInLastHorizon);
      bResult = bResult && (RootList.size() == rfoCmp.RootList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RootList.size()); ++u32Idx)
            bResult = bResult && (RootList[u32Idx] == rfoCmp.RootList[u32Idx]);
      }
      bResult = bResult && (IndexOfLastRootInCurrentHorizon == rfoCmp.IndexOfLastRootInCurrentHorizon);
      bResult = bResult && (IndicesOfLastRootsInCurrentHorizon.size() == rfoCmp.IndicesOfLastRootsInCurrentHorizon.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < IndicesOfLastRootsInCurrentHorizon.size()); ++u32Idx)
            bResult = bResult && (IndicesOfLastRootsInCurrentHorizon[u32Idx] == rfoCmp.IndicesOfLastRootsInCurrentHorizon[u32Idx]);
      }
      bResult = bResult && (TripHandle == rfoCmp.TripHandle);
      bResult = bResult && (RouteHandle == rfoCmp.RouteHandle);
      bResult = bResult && (TripSegmentNumber == rfoCmp.TripSegmentNumber);
      bResult = bResult && (RouteInfoId == rfoCmp.RouteInfoId);
      bResult = bResult && (PathSectionList.size() == rfoCmp.PathSectionList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PathSectionList.size()); ++u32Idx)
            bResult = bResult && (PathSectionList[u32Idx] == rfoCmp.PathSectionList[u32Idx]);
      }
      bResult = bResult && (OneCellRefList.size() == rfoCmp.OneCellRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < OneCellRefList.size()); ++u32Idx)
            bResult = bResult && (OneCellRefList[u32Idx] == rfoCmp.OneCellRefList[u32Idx]);
      }
      bResult = bResult && (ClusterRefList.size() == rfoCmp.ClusterRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ClusterRefList.size()); ++u32Idx)
            bResult = bResult && (ClusterRefList[u32Idx] == rfoCmp.ClusterRefList[u32Idx]);
      }
      bResult = bResult && (TEAEventIDList.size() == rfoCmp.TEAEventIDList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TEAEventIDList.size()); ++u32Idx)
            bResult = bResult && (TEAEventIDList[u32Idx] == rfoCmp.TEAEventIDList[u32Idx]);
      }
      bResult = bResult && (AlternativTEAEventList.size() == rfoCmp.AlternativTEAEventList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < AlternativTEAEventList.size()); ++u32Idx)
            bResult = bResult && (AlternativTEAEventList[u32Idx] == rfoCmp.AlternativTEAEventList[u32Idx]);
      }
      bResult = bResult && (MostProbablePathesList.size() == rfoCmp.MostProbablePathesList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < MostProbablePathesList.size()); ++u32Idx)
            bResult = bResult && (MostProbablePathesList[u32Idx] == rfoCmp.MostProbablePathesList[u32Idx]);
      }
      bResult = bResult && (RoadInfo.size() == rfoCmp.RoadInfo.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RoadInfo.size()); ++u32Idx)
            bResult = bResult && (RoadInfo[u32Idx] == rfoCmp.RoadInfo[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& teafi_tclMsgGetTEAHorizonMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> ReleaseId;
   oIn >> PositionHorizonState;
   oIn >> RequestedMDBData;
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      PathSectionStateList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> PathSectionStateList[u32Idx];
      }
   }
   oIn >> DataBaseId;
   if (oIn.u16GetMajorVersion() <= 18)
   {
      oIn >> IndexOfRootInLastHorizon;
   }
   if (19 <= oIn.u16GetMajorVersion())
   {
      {
         tU32 u32Length;
         tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
         for (u32Idx = 0; u32Idx < RootList.size(); ++u32Idx)
         {
            RootList[u32Idx].vDestroy();
         }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
         oIn >> u32Length;
         RootList.resize(u32Length);
         for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
         {
            oIn >> RootList[u32Idx];
         }
      }
   }
   if ((11 <= oIn.u16GetMajorVersion()) && (oIn.u16GetMajorVersion() <= 18))
   {
      oIn >> IndexOfLastRootInCurrentHorizon;
   }
   if (19 <= oIn.u16GetMajorVersion())
   {
      {
         tU32 u32Length;
         tU32 u32Idx;
         oIn >> u32Length;
         IndicesOfLastRootsInCurrentHorizon.resize(u32Length);
         for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
         {
            oIn >> IndicesOfLastRootsInCurrentHorizon[u32Idx];
         }
      }
   }
   if (9 <= oIn.u16GetMajorVersion())
   {
      oIn >> TripHandle;
   }
   if (9 <= oIn.u16GetMajorVersion())
   {
      oIn >> RouteHandle;
   }
   if (9 <= oIn.u16GetMajorVersion())
   {
      oIn >> TripSegmentNumber;
   }
   if (9 <= oIn.u16GetMajorVersion())
   {
      oIn >> RouteInfoId;
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < PathSectionList.size(); ++u32Idx)
      {
         PathSectionList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      PathSectionList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> PathSectionList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < OneCellRefList.size(); ++u32Idx)
      {
         OneCellRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      OneCellRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> OneCellRefList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ClusterRefList.size(); ++u32Idx)
      {
         ClusterRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ClusterRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ClusterRefList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TEAEventIDList.size(); ++u32Idx)
      {
         TEAEventIDList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      TEAEventIDList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> TEAEventIDList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < AlternativTEAEventList.size(); ++u32Idx)
      {
         AlternativTEAEventList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      AlternativTEAEventList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> AlternativTEAEventList[u32Idx];
      }
   }
   if (11 <= oIn.u16GetMajorVersion())
   {
      {
         tU32 u32Length;
         tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
         for (u32Idx = 0; u32Idx < MostProbablePathesList.size(); ++u32Idx)
         {
            MostProbablePathesList[u32Idx].vDestroy();
         }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
         oIn >> u32Length;
         MostProbablePathesList.resize(u32Length);
         for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
         {
            oIn >> MostProbablePathesList[u32Idx];
         }
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < RoadInfo.size(); ++u32Idx)
      {
         RoadInfo[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      RoadInfo.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> RoadInfo[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& teafi_tclMsgGetTEAHorizonMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ReleaseId;
   oOut << PositionHorizonState;
   oOut << RequestedMDBData;
   oOut << (tU32)PathSectionStateList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < PathSectionStateList.size(); ++u32Idx)
         oOut << PathSectionStateList[u32Idx];
   }
   oOut << DataBaseId;
   if (oOut.u16GetMajorVersion() <= 18)
   {
      oOut << IndexOfRootInLastHorizon;
   }
   if (19 <= oOut.u16GetMajorVersion())
   {
      oOut << (tU32)RootList.size();
      {
         for (tU32 u32Idx = 0; u32Idx < RootList.size(); ++u32Idx)
            oOut << RootList[u32Idx];
      }
   }
   if ((11 <= oOut.u16GetMajorVersion()) && (oOut.u16GetMajorVersion() <= 18))
   {
      oOut << IndexOfLastRootInCurrentHorizon;
   }
   if (19 <= oOut.u16GetMajorVersion())
   {
      oOut << (tU32)IndicesOfLastRootsInCurrentHorizon.size();
      {
         for (tU32 u32Idx = 0; u32Idx < IndicesOfLastRootsInCurrentHorizon.size(); ++u32Idx)
            oOut << IndicesOfLastRootsInCurrentHorizon[u32Idx];
      }
   }
   if (9 <= oOut.u16GetMajorVersion())
   {
      oOut << TripHandle;
   }
   if (9 <= oOut.u16GetMajorVersion())
   {
      oOut << RouteHandle;
   }
   if (9 <= oOut.u16GetMajorVersion())
   {
      oOut << TripSegmentNumber;
   }
   if (9 <= oOut.u16GetMajorVersion())
   {
      oOut << RouteInfoId;
   }
   oOut << (tU32)PathSectionList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < PathSectionList.size(); ++u32Idx)
         oOut << PathSectionList[u32Idx];
   }
   oOut << (tU32)OneCellRefList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < OneCellRefList.size(); ++u32Idx)
         oOut << OneCellRefList[u32Idx];
   }
   oOut << (tU32)ClusterRefList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ClusterRefList.size(); ++u32Idx)
         oOut << ClusterRefList[u32Idx];
   }
   oOut << (tU32)TEAEventIDList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < TEAEventIDList.size(); ++u32Idx)
         oOut << TEAEventIDList[u32Idx];
   }
   oOut << (tU32)AlternativTEAEventList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < AlternativTEAEventList.size(); ++u32Idx)
         oOut << AlternativTEAEventList[u32Idx];
   }
   if (11 <= oOut.u16GetMajorVersion())
   {
      oOut << (tU32)MostProbablePathesList.size();
      {
         for (tU32 u32Idx = 0; u32Idx < MostProbablePathesList.size(); ++u32Idx)
            oOut << MostProbablePathesList[u32Idx];
      }
   }
   oOut << (tU32)RoadInfo.size();
   {
      for (tU32 u32Idx = 0; u32Idx < RoadInfo.size(); ++u32Idx)
         oOut << RoadInfo[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
teafi_tclMsgGetUPOIsMethodStart::teafi_tclMsgGetUPOIsMethodStart(const teafi_tclMsgGetUPOIsMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   FilterList = coRef.FilterList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
teafi_tclMsgGetUPOIsMethodStart& teafi_tclMsgGetUPOIsMethodStart::operator=(const teafi_tclMsgGetUPOIsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   FilterList = coRef.FilterList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 teafi_tclMsgGetUPOIsMethodStart::u16GetServiceID() const {return TEAFI_C_U16_SERVICE_ID;}
tU16 teafi_tclMsgGetUPOIsMethodStart::u16GetFunctionID() const {return TEAFI_C_U16_GETUPOIS;}
tU8 teafi_tclMsgGetUPOIsMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid teafi_tclMsgGetUPOIsMethodStart::vDestroy()
{
   FilterList.vDestroy(); 
}

tU32 teafi_tclMsgGetUPOIsMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+FilterList.u32GetSize(u16MajorVersion);
}

tBool teafi_tclMsgGetUPOIsMethodStart::operator==(const teafi_tclMsgGetUPOIsMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (FilterList == rfoCmp.FilterList);
   return bResult;
}

fi_tclInContext& teafi_tclMsgGetUPOIsMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> FilterList;
   return oIn;
}

fi_tclOutContext& teafi_tclMsgGetUPOIsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << FilterList;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
teafi_tclMsgGetUPOIsMethodResult::teafi_tclMsgGetUPOIsMethodResult(const teafi_tclMsgGetUPOIsMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   ReleaseId = coRef.ReleaseId;
   ListSetInfoPercentageUPOI = coRef.ListSetInfoPercentageUPOI;
   UPOIListSet = coRef.UPOIListSet;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
teafi_tclMsgGetUPOIsMethodResult& teafi_tclMsgGetUPOIsMethodResult::operator=(const teafi_tclMsgGetUPOIsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ReleaseId = coRef.ReleaseId;
   ListSetInfoPercentageUPOI = coRef.ListSetInfoPercentageUPOI;
   UPOIListSet = coRef.UPOIListSet;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 teafi_tclMsgGetUPOIsMethodResult::u16GetServiceID() const {return TEAFI_C_U16_SERVICE_ID;}
tU16 teafi_tclMsgGetUPOIsMethodResult::u16GetFunctionID() const {return TEAFI_C_U16_GETUPOIS;}
tU8 teafi_tclMsgGetUPOIsMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid teafi_tclMsgGetUPOIsMethodResult::vDestroy()
{
   UPOIListSet.vDestroy(); 
}

tU32 teafi_tclMsgGetUPOIsMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (15 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+4+UPOIListSet.u32GetSize(u16MajorVersion);
}

tBool teafi_tclMsgGetUPOIsMethodResult::operator==(const teafi_tclMsgGetUPOIsMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ReleaseId == rfoCmp.ReleaseId);
      bResult = bResult && (ListSetInfoPercentageUPOI == rfoCmp.ListSetInfoPercentageUPOI);
      bResult = bResult && (UPOIListSet == rfoCmp.UPOIListSet);
   return bResult;
}

fi_tclInContext& teafi_tclMsgGetUPOIsMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> ReleaseId;
   if (15 <= oIn.u16GetMajorVersion())
   {
      oIn >> ListSetInfoPercentageUPOI;
   }
   oIn >> UPOIListSet;
   return oIn;
}

fi_tclOutContext& teafi_tclMsgGetUPOIsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ReleaseId;
   if (15 <= oOut.u16GetMajorVersion())
   {
      oOut << ListSetInfoPercentageUPOI;
   }
   oOut << UPOIListSet;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
teafi_tclMsgTEAHorizonGet::teafi_tclMsgTEAHorizonGet(const teafi_tclMsgTEAHorizonGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
teafi_tclMsgTEAHorizonGet& teafi_tclMsgTEAHorizonGet::operator=(const teafi_tclMsgTEAHorizonGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 teafi_tclMsgTEAHorizonGet::u16GetServiceID() const {return TEAFI_C_U16_SERVICE_ID;}
tU16 teafi_tclMsgTEAHorizonGet::u16GetFunctionID() const {return TEAFI_C_U16_TEAHORIZON;}
tU8 teafi_tclMsgTEAHorizonGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 teafi_tclMsgTEAHorizonGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool teafi_tclMsgTEAHorizonGet::operator==(const teafi_tclMsgTEAHorizonGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& teafi_tclMsgTEAHorizonGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& teafi_tclMsgTEAHorizonGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
teafi_tclMsgTEAHorizonUpReg::teafi_tclMsgTEAHorizonUpReg(const teafi_tclMsgTEAHorizonUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
teafi_tclMsgTEAHorizonUpReg& teafi_tclMsgTEAHorizonUpReg::operator=(const teafi_tclMsgTEAHorizonUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 teafi_tclMsgTEAHorizonUpReg::u16GetServiceID() const {return TEAFI_C_U16_SERVICE_ID;}
tU16 teafi_tclMsgTEAHorizonUpReg::u16GetFunctionID() const {return TEAFI_C_U16_TEAHORIZON;}
tU8 teafi_tclMsgTEAHorizonUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 teafi_tclMsgTEAHorizonUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool teafi_tclMsgTEAHorizonUpReg::operator==(const teafi_tclMsgTEAHorizonUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& teafi_tclMsgTEAHorizonUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& teafi_tclMsgTEAHorizonUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
teafi_tclMsgTEAHorizonRelUpReg::teafi_tclMsgTEAHorizonRelUpReg(const teafi_tclMsgTEAHorizonRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
teafi_tclMsgTEAHorizonRelUpReg& teafi_tclMsgTEAHorizonRelUpReg::operator=(const teafi_tclMsgTEAHorizonRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 teafi_tclMsgTEAHorizonRelUpReg::u16GetServiceID() const {return TEAFI_C_U16_SERVICE_ID;}
tU16 teafi_tclMsgTEAHorizonRelUpReg::u16GetFunctionID() const {return TEAFI_C_U16_TEAHORIZON;}
tU8 teafi_tclMsgTEAHorizonRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 teafi_tclMsgTEAHorizonRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool teafi_tclMsgTEAHorizonRelUpReg::operator==(const teafi_tclMsgTEAHorizonRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& teafi_tclMsgTEAHorizonRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& teafi_tclMsgTEAHorizonRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
teafi_tclMsgTEAHorizonStatus::teafi_tclMsgTEAHorizonStatus(const teafi_tclMsgTEAHorizonStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   ReleaseId = coRef.ReleaseId;
   PositionHorizonState = coRef.PositionHorizonState;
   RequestedMDBData = coRef.RequestedMDBData;
   PathSectionStateList = coRef.PathSectionStateList;
   DataBaseId = coRef.DataBaseId;
   IndexOfRootInLastHorizon = coRef.IndexOfRootInLastHorizon;
   PathSectionList = coRef.PathSectionList;
   OneCellRefList = coRef.OneCellRefList;
   ClusterRefList = coRef.ClusterRefList;
   RoadInfo = coRef.RoadInfo;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
teafi_tclMsgTEAHorizonStatus& teafi_tclMsgTEAHorizonStatus::operator=(const teafi_tclMsgTEAHorizonStatus& coRef)
{
   if (this == &coRef) return *this;
   ReleaseId = coRef.ReleaseId;
   PositionHorizonState = coRef.PositionHorizonState;
   RequestedMDBData = coRef.RequestedMDBData;
   PathSectionStateList = coRef.PathSectionStateList;
   DataBaseId = coRef.DataBaseId;
   IndexOfRootInLastHorizon = coRef.IndexOfRootInLastHorizon;
   PathSectionList = coRef.PathSectionList;
   OneCellRefList = coRef.OneCellRefList;
   ClusterRefList = coRef.ClusterRefList;
   RoadInfo = coRef.RoadInfo;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 teafi_tclMsgTEAHorizonStatus::u16GetServiceID() const {return TEAFI_C_U16_SERVICE_ID;}
tU16 teafi_tclMsgTEAHorizonStatus::u16GetFunctionID() const {return TEAFI_C_U16_TEAHORIZON;}
tU8 teafi_tclMsgTEAHorizonStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid teafi_tclMsgTEAHorizonStatus::vDestroy()
{
   PathSectionStateList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < PathSectionList.size(); ++u32Idx)
         PathSectionList[u32Idx].vDestroy();
   }
   PathSectionList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < OneCellRefList.size(); ++u32Idx)
         OneCellRefList[u32Idx].vDestroy();
   }
   OneCellRefList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < ClusterRefList.size(); ++u32Idx)
         ClusterRefList[u32Idx].vDestroy();
   }
   ClusterRefList.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < RoadInfo.size(); ++u32Idx)
         RoadInfo[u32Idx].vDestroy();
   }
   RoadInfo.clear();
}

tU32 teafi_tclMsgTEAHorizonStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < PathSectionList.size(); ++u32ListIdx)
      u32DynamicSize += PathSectionList[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < OneCellRefList.size(); ++u32ListIdx)
      u32DynamicSize += OneCellRefList[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < RoadInfo.size(); ++u32ListIdx)
      u32DynamicSize += RoadInfo[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+35+PathSectionStateList.size()*1+ClusterRefList.size()*9;
}

tBool teafi_tclMsgTEAHorizonStatus::operator==(const teafi_tclMsgTEAHorizonStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ReleaseId == rfoCmp.ReleaseId);
      bResult = bResult && (PositionHorizonState == rfoCmp.PositionHorizonState);
      bResult = bResult && (RequestedMDBData == rfoCmp.RequestedMDBData);
      bResult = bResult && (PathSectionStateList.size() == rfoCmp.PathSectionStateList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PathSectionStateList.size()); ++u32Idx)
            bResult = bResult && (PathSectionStateList[u32Idx] == rfoCmp.PathSectionStateList[u32Idx]);
      }
      bResult = bResult && (DataBaseId == rfoCmp.DataBaseId);
      bResult = bResult && (IndexOfRootInLastHorizon == rfoCmp.IndexOfRootInLastHorizon);
      bResult = bResult && (PathSectionList.size() == rfoCmp.PathSectionList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PathSectionList.size()); ++u32Idx)
            bResult = bResult && (PathSectionList[u32Idx] == rfoCmp.PathSectionList[u32Idx]);
      }
      bResult = bResult && (OneCellRefList.size() == rfoCmp.OneCellRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < OneCellRefList.size()); ++u32Idx)
            bResult = bResult && (OneCellRefList[u32Idx] == rfoCmp.OneCellRefList[u32Idx]);
      }
      bResult = bResult && (ClusterRefList.size() == rfoCmp.ClusterRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ClusterRefList.size()); ++u32Idx)
            bResult = bResult && (ClusterRefList[u32Idx] == rfoCmp.ClusterRefList[u32Idx]);
      }
      bResult = bResult && (RoadInfo.size() == rfoCmp.RoadInfo.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RoadInfo.size()); ++u32Idx)
            bResult = bResult && (RoadInfo[u32Idx] == rfoCmp.RoadInfo[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& teafi_tclMsgTEAHorizonStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> ReleaseId;
   oIn >> PositionHorizonState;
   oIn >> RequestedMDBData;
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      PathSectionStateList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> PathSectionStateList[u32Idx];
      }
   }
   oIn >> DataBaseId;
   oIn >> IndexOfRootInLastHorizon;
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < PathSectionList.size(); ++u32Idx)
      {
         PathSectionList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      PathSectionList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> PathSectionList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < OneCellRefList.size(); ++u32Idx)
      {
         OneCellRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      OneCellRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> OneCellRefList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ClusterRefList.size(); ++u32Idx)
      {
         ClusterRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      ClusterRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> ClusterRefList[u32Idx];
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < RoadInfo.size(); ++u32Idx)
      {
         RoadInfo[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      RoadInfo.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> RoadInfo[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& teafi_tclMsgTEAHorizonStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ReleaseId;
   oOut << PositionHorizonState;
   oOut << RequestedMDBData;
   oOut << (tU32)PathSectionStateList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < PathSectionStateList.size(); ++u32Idx)
         oOut << PathSectionStateList[u32Idx];
   }
   oOut << DataBaseId;
   oOut << IndexOfRootInLastHorizon;
   oOut << (tU32)PathSectionList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < PathSectionList.size(); ++u32Idx)
         oOut << PathSectionList[u32Idx];
   }
   oOut << (tU32)OneCellRefList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < OneCellRefList.size(); ++u32Idx)
         oOut << OneCellRefList[u32Idx];
   }
   oOut << (tU32)ClusterRefList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < ClusterRefList.size(); ++u32Idx)
         oOut << ClusterRefList[u32Idx];
   }
   oOut << (tU32)RoadInfo.size();
   {
      for (tU32 u32Idx = 0; u32Idx < RoadInfo.size(); ++u32Idx)
         oOut << RoadInfo[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
teafi_tclMsgTEAHorizonStateGet::teafi_tclMsgTEAHorizonStateGet(const teafi_tclMsgTEAHorizonStateGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
teafi_tclMsgTEAHorizonStateGet& teafi_tclMsgTEAHorizonStateGet::operator=(const teafi_tclMsgTEAHorizonStateGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 teafi_tclMsgTEAHorizonStateGet::u16GetServiceID() const {return TEAFI_C_U16_SERVICE_ID;}
tU16 teafi_tclMsgTEAHorizonStateGet::u16GetFunctionID() const {return TEAFI_C_U16_TEAHORIZONSTATE;}
tU8 teafi_tclMsgTEAHorizonStateGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 teafi_tclMsgTEAHorizonStateGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool teafi_tclMsgTEAHorizonStateGet::operator==(const teafi_tclMsgTEAHorizonStateGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& teafi_tclMsgTEAHorizonStateGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& teafi_tclMsgTEAHorizonStateGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
teafi_tclMsgTEAHorizonStateUpReg::teafi_tclMsgTEAHorizonStateUpReg(const teafi_tclMsgTEAHorizonStateUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
teafi_tclMsgTEAHorizonStateUpReg& teafi_tclMsgTEAHorizonStateUpReg::operator=(const teafi_tclMsgTEAHorizonStateUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 teafi_tclMsgTEAHorizonStateUpReg::u16GetServiceID() const {return TEAFI_C_U16_SERVICE_ID;}
tU16 teafi_tclMsgTEAHorizonStateUpReg::u16GetFunctionID() const {return TEAFI_C_U16_TEAHORIZONSTATE;}
tU8 teafi_tclMsgTEAHorizonStateUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 teafi_tclMsgTEAHorizonStateUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool teafi_tclMsgTEAHorizonStateUpReg::operator==(const teafi_tclMsgTEAHorizonStateUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& teafi_tclMsgTEAHorizonStateUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& teafi_tclMsgTEAHorizonStateUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
teafi_tclMsgTEAHorizonStateRelUpReg::teafi_tclMsgTEAHorizonStateRelUpReg(const teafi_tclMsgTEAHorizonStateRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
teafi_tclMsgTEAHorizonStateRelUpReg& teafi_tclMsgTEAHorizonStateRelUpReg::operator=(const teafi_tclMsgTEAHorizonStateRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 teafi_tclMsgTEAHorizonStateRelUpReg::u16GetServiceID() const {return TEAFI_C_U16_SERVICE_ID;}
tU16 teafi_tclMsgTEAHorizonStateRelUpReg::u16GetFunctionID() const {return TEAFI_C_U16_TEAHORIZONSTATE;}
tU8 teafi_tclMsgTEAHorizonStateRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 teafi_tclMsgTEAHorizonStateRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool teafi_tclMsgTEAHorizonStateRelUpReg::operator==(const teafi_tclMsgTEAHorizonStateRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& teafi_tclMsgTEAHorizonStateRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& teafi_tclMsgTEAHorizonStateRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
teafi_tclMsgTEAHorizonStateStatus::teafi_tclMsgTEAHorizonStateStatus(const teafi_tclMsgTEAHorizonStateStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   ReleaseId = coRef.ReleaseId;
   PositionHorizonState = coRef.PositionHorizonState;
   RequestableMDBData = coRef.RequestableMDBData;
   PathSectionStateList = coRef.PathSectionStateList;
   ListSetInfoPercentageMDB = coRef.ListSetInfoPercentageMDB;
   ListSetInfoPercentageEDM = coRef.ListSetInfoPercentageEDM;
   ListSetInfoPercentageUPOI = coRef.ListSetInfoPercentageUPOI;
   DataBaseId = coRef.DataBaseId;
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   TripSegmentNumber = coRef.TripSegmentNumber;
   RouteInfoId = coRef.RouteInfoId;
   AvailablePOISources = coRef.AvailablePOISources;
   ChangedPOISources = coRef.ChangedPOISources;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
teafi_tclMsgTEAHorizonStateStatus& teafi_tclMsgTEAHorizonStateStatus::operator=(const teafi_tclMsgTEAHorizonStateStatus& coRef)
{
   if (this == &coRef) return *this;
   ReleaseId = coRef.ReleaseId;
   PositionHorizonState = coRef.PositionHorizonState;
   RequestableMDBData = coRef.RequestableMDBData;
   PathSectionStateList = coRef.PathSectionStateList;
   ListSetInfoPercentageMDB = coRef.ListSetInfoPercentageMDB;
   ListSetInfoPercentageEDM = coRef.ListSetInfoPercentageEDM;
   ListSetInfoPercentageUPOI = coRef.ListSetInfoPercentageUPOI;
   DataBaseId = coRef.DataBaseId;
   TripHandle = coRef.TripHandle;
   RouteHandle = coRef.RouteHandle;
   TripSegmentNumber = coRef.TripSegmentNumber;
   RouteInfoId = coRef.RouteInfoId;
   AvailablePOISources = coRef.AvailablePOISources;
   ChangedPOISources = coRef.ChangedPOISources;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 teafi_tclMsgTEAHorizonStateStatus::u16GetServiceID() const {return TEAFI_C_U16_SERVICE_ID;}
tU16 teafi_tclMsgTEAHorizonStateStatus::u16GetFunctionID() const {return TEAFI_C_U16_TEAHORIZONSTATE;}
tU8 teafi_tclMsgTEAHorizonStateStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid teafi_tclMsgTEAHorizonStateStatus::vDestroy()
{
   PathSectionStateList.clear();
}

tU32 teafi_tclMsgTEAHorizonStateStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (15 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   if (17 <= u16MajorVersion)
   {
      u32DynamicSize += 2;
   }
   if (17 <= u16MajorVersion)
   {
      u32DynamicSize += 2;
   }
   if (17 <= u16MajorVersion)
   {
      u32DynamicSize += 2;
   }
   if (17 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   if (17 <= u16MajorVersion)
   {
      u32DynamicSize += 2;
   }
   if (17 <= u16MajorVersion)
   {
      u32DynamicSize += 2;
   }
   return u32DynamicSize+19+PathSectionStateList.size()*1;
}

tBool teafi_tclMsgTEAHorizonStateStatus::operator==(const teafi_tclMsgTEAHorizonStateStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ReleaseId == rfoCmp.ReleaseId);
      bResult = bResult && (PositionHorizonState == rfoCmp.PositionHorizonState);
      bResult = bResult && (RequestableMDBData == rfoCmp.RequestableMDBData);
      bResult = bResult && (PathSectionStateList.size() == rfoCmp.PathSectionStateList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PathSectionStateList.size()); ++u32Idx)
            bResult = bResult && (PathSectionStateList[u32Idx] == rfoCmp.PathSectionStateList[u32Idx]);
      }
      bResult = bResult && (ListSetInfoPercentageMDB == rfoCmp.ListSetInfoPercentageMDB);
      bResult = bResult && (ListSetInfoPercentageEDM == rfoCmp.ListSetInfoPercentageEDM);
      bResult = bResult && (ListSetInfoPercentageUPOI == rfoCmp.ListSetInfoPercentageUPOI);
      bResult = bResult && (DataBaseId == rfoCmp.DataBaseId);
      bResult = bResult && (TripHandle == rfoCmp.TripHandle);
      bResult = bResult && (RouteHandle == rfoCmp.RouteHandle);
      bResult = bResult && (TripSegmentNumber == rfoCmp.TripSegmentNumber);
      bResult = bResult && (RouteInfoId == rfoCmp.RouteInfoId);
      bResult = bResult && (AvailablePOISources == rfoCmp.AvailablePOISources);
      bResult = bResult && (ChangedPOISources == rfoCmp.ChangedPOISources);
   return bResult;
}

fi_tclInContext& teafi_tclMsgTEAHorizonStateStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> ReleaseId;
   oIn >> PositionHorizonState;
   oIn >> RequestableMDBData;
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      PathSectionStateList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> PathSectionStateList[u32Idx];
      }
   }
   oIn >> ListSetInfoPercentageMDB;
   oIn >> ListSetInfoPercentageEDM;
   if (15 <= oIn.u16GetMajorVersion())
   {
      oIn >> ListSetInfoPercentageUPOI;
   }
   oIn >> DataBaseId;
   if (17 <= oIn.u16GetMajorVersion())
   {
      oIn >> TripHandle;
   }
   if (17 <= oIn.u16GetMajorVersion())
   {
      oIn >> RouteHandle;
   }
   if (17 <= oIn.u16GetMajorVersion())
   {
      oIn >> TripSegmentNumber;
   }
   if (17 <= oIn.u16GetMajorVersion())
   {
      oIn >> RouteInfoId;
   }
   if (17 <= oIn.u16GetMajorVersion())
   {
      oIn >> AvailablePOISources;
   }
   if (17 <= oIn.u16GetMajorVersion())
   {
      oIn >> ChangedPOISources;
   }
   return oIn;
}

fi_tclOutContext& teafi_tclMsgTEAHorizonStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ReleaseId;
   oOut << PositionHorizonState;
   oOut << RequestableMDBData;
   oOut << (tU32)PathSectionStateList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < PathSectionStateList.size(); ++u32Idx)
         oOut << PathSectionStateList[u32Idx];
   }
   oOut << ListSetInfoPercentageMDB;
   oOut << ListSetInfoPercentageEDM;
   if (15 <= oOut.u16GetMajorVersion())
   {
      oOut << ListSetInfoPercentageUPOI;
   }
   oOut << DataBaseId;
   if (17 <= oOut.u16GetMajorVersion())
   {
      oOut << TripHandle;
   }
   if (17 <= oOut.u16GetMajorVersion())
   {
      oOut << RouteHandle;
   }
   if (17 <= oOut.u16GetMajorVersion())
   {
      oOut << TripSegmentNumber;
   }
   if (17 <= oOut.u16GetMajorVersion())
   {
      oOut << RouteInfoId;
   }
   if (17 <= oOut.u16GetMajorVersion())
   {
      oOut << AvailablePOISources;
   }
   if (17 <= oOut.u16GetMajorVersion())
   {
      oOut << ChangedPOISources;
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
teafi_tclMsgMostProbableTEAPathGet::teafi_tclMsgMostProbableTEAPathGet(const teafi_tclMsgMostProbableTEAPathGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
teafi_tclMsgMostProbableTEAPathGet& teafi_tclMsgMostProbableTEAPathGet::operator=(const teafi_tclMsgMostProbableTEAPathGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 teafi_tclMsgMostProbableTEAPathGet::u16GetServiceID() const {return TEAFI_C_U16_SERVICE_ID;}
tU16 teafi_tclMsgMostProbableTEAPathGet::u16GetFunctionID() const {return TEAFI_C_U16_MOSTPROBABLETEAPATH;}
tU8 teafi_tclMsgMostProbableTEAPathGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 teafi_tclMsgMostProbableTEAPathGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool teafi_tclMsgMostProbableTEAPathGet::operator==(const teafi_tclMsgMostProbableTEAPathGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& teafi_tclMsgMostProbableTEAPathGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& teafi_tclMsgMostProbableTEAPathGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
teafi_tclMsgMostProbableTEAPathUpReg::teafi_tclMsgMostProbableTEAPathUpReg(const teafi_tclMsgMostProbableTEAPathUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
teafi_tclMsgMostProbableTEAPathUpReg& teafi_tclMsgMostProbableTEAPathUpReg::operator=(const teafi_tclMsgMostProbableTEAPathUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 teafi_tclMsgMostProbableTEAPathUpReg::u16GetServiceID() const {return TEAFI_C_U16_SERVICE_ID;}
tU16 teafi_tclMsgMostProbableTEAPathUpReg::u16GetFunctionID() const {return TEAFI_C_U16_MOSTPROBABLETEAPATH;}
tU8 teafi_tclMsgMostProbableTEAPathUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 teafi_tclMsgMostProbableTEAPathUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool teafi_tclMsgMostProbableTEAPathUpReg::operator==(const teafi_tclMsgMostProbableTEAPathUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& teafi_tclMsgMostProbableTEAPathUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& teafi_tclMsgMostProbableTEAPathUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
teafi_tclMsgMostProbableTEAPathRelUpReg::teafi_tclMsgMostProbableTEAPathRelUpReg(const teafi_tclMsgMostProbableTEAPathRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
teafi_tclMsgMostProbableTEAPathRelUpReg& teafi_tclMsgMostProbableTEAPathRelUpReg::operator=(const teafi_tclMsgMostProbableTEAPathRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 teafi_tclMsgMostProbableTEAPathRelUpReg::u16GetServiceID() const {return TEAFI_C_U16_SERVICE_ID;}
tU16 teafi_tclMsgMostProbableTEAPathRelUpReg::u16GetFunctionID() const {return TEAFI_C_U16_MOSTPROBABLETEAPATH;}
tU8 teafi_tclMsgMostProbableTEAPathRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 teafi_tclMsgMostProbableTEAPathRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool teafi_tclMsgMostProbableTEAPathRelUpReg::operator==(const teafi_tclMsgMostProbableTEAPathRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& teafi_tclMsgMostProbableTEAPathRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& teafi_tclMsgMostProbableTEAPathRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
teafi_tclMsgMostProbableTEAPathStatus::teafi_tclMsgMostProbableTEAPathStatus(const teafi_tclMsgMostProbableTEAPathStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   ReleaseId = coRef.ReleaseId;
   PathSectionListIndices = coRef.PathSectionListIndices;
   MPPList = coRef.MPPList;
   MPPState = coRef.MPPState;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
teafi_tclMsgMostProbableTEAPathStatus& teafi_tclMsgMostProbableTEAPathStatus::operator=(const teafi_tclMsgMostProbableTEAPathStatus& coRef)
{
   if (this == &coRef) return *this;
   ReleaseId = coRef.ReleaseId;
   PathSectionListIndices = coRef.PathSectionListIndices;
   MPPList = coRef.MPPList;
   MPPState = coRef.MPPState;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 teafi_tclMsgMostProbableTEAPathStatus::u16GetServiceID() const {return TEAFI_C_U16_SERVICE_ID;}
tU16 teafi_tclMsgMostProbableTEAPathStatus::u16GetFunctionID() const {return TEAFI_C_U16_MOSTPROBABLETEAPATH;}
tU8 teafi_tclMsgMostProbableTEAPathStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid teafi_tclMsgMostProbableTEAPathStatus::vDestroy()
{
   PathSectionListIndices.clear();
   {
      for (tU32 u32Idx = 0; u32Idx < MPPList.size(); ++u32Idx)
         MPPList[u32Idx].vDestroy();
   }
   MPPList.clear();
}

tU32 teafi_tclMsgMostProbableTEAPathStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (u16MajorVersion <= 12)
   {
      u32DynamicSize += 4;
      u32DynamicSize += PathSectionListIndices.size()*2;
   }
   tU32 u32ListIdx;
   if (13 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
      for (u32ListIdx = 0; u32ListIdx < MPPList.size(); ++u32ListIdx)
         u32DynamicSize += MPPList[u32ListIdx].u32GetSize(u16MajorVersion);
   }
   if (13 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+4;
}

tBool teafi_tclMsgMostProbableTEAPathStatus::operator==(const teafi_tclMsgMostProbableTEAPathStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ReleaseId == rfoCmp.ReleaseId);
      bResult = bResult && (PathSectionListIndices.size() == rfoCmp.PathSectionListIndices.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PathSectionListIndices.size()); ++u32Idx)
            bResult = bResult && (PathSectionListIndices[u32Idx] == rfoCmp.PathSectionListIndices[u32Idx]);
      }
      bResult = bResult && (MPPList.size() == rfoCmp.MPPList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < MPPList.size()); ++u32Idx)
            bResult = bResult && (MPPList[u32Idx] == rfoCmp.MPPList[u32Idx]);
      }
      bResult = bResult && (MPPState == rfoCmp.MPPState);
   return bResult;
}

fi_tclInContext& teafi_tclMsgMostProbableTEAPathStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> ReleaseId;
   if (oIn.u16GetMajorVersion() <= 12)
   {
      {
         tU32 u32Length;
         tU32 u32Idx;
         oIn >> u32Length;
         PathSectionListIndices.resize(u32Length);
         for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
         {
            oIn >> PathSectionListIndices[u32Idx];
         }
      }
   }
   if (13 <= oIn.u16GetMajorVersion())
   {
      {
         tU32 u32Length;
         tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
         for (u32Idx = 0; u32Idx < MPPList.size(); ++u32Idx)
         {
            MPPList[u32Idx].vDestroy();
         }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
         oIn >> u32Length;
         MPPList.resize(u32Length);
         for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
         {
            oIn >> MPPList[u32Idx];
         }
      }
   }
   if (13 <= oIn.u16GetMajorVersion())
   {
      oIn >> MPPState;
   }
   return oIn;
}

fi_tclOutContext& teafi_tclMsgMostProbableTEAPathStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << ReleaseId;
   if (oOut.u16GetMajorVersion() <= 12)
   {
      oOut << (tU32)PathSectionListIndices.size();
      {
         for (tU32 u32Idx = 0; u32Idx < PathSectionListIndices.size(); ++u32Idx)
            oOut << PathSectionListIndices[u32Idx];
      }
   }
   if (13 <= oOut.u16GetMajorVersion())
   {
      oOut << (tU32)MPPList.size();
      {
         for (tU32 u32Idx = 0; u32Idx < MPPList.size(); ++u32Idx)
            oOut << MPPList[u32Idx];
      }
   }
   if (13 <= oOut.u16GetMajorVersion())
   {
      oOut << MPPState;
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
teafi_tclMsgEngineeringTextGet::teafi_tclMsgEngineeringTextGet(const teafi_tclMsgEngineeringTextGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
teafi_tclMsgEngineeringTextGet& teafi_tclMsgEngineeringTextGet::operator=(const teafi_tclMsgEngineeringTextGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 teafi_tclMsgEngineeringTextGet::u16GetServiceID() const {return TEAFI_C_U16_SERVICE_ID;}
tU16 teafi_tclMsgEngineeringTextGet::u16GetFunctionID() const {return TEAFI_C_U16_ENGINEERINGTEXT;}
tU8 teafi_tclMsgEngineeringTextGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 teafi_tclMsgEngineeringTextGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool teafi_tclMsgEngineeringTextGet::operator==(const teafi_tclMsgEngineeringTextGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& teafi_tclMsgEngineeringTextGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& teafi_tclMsgEngineeringTextGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
teafi_tclMsgEngineeringTextUpReg::teafi_tclMsgEngineeringTextUpReg(const teafi_tclMsgEngineeringTextUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
teafi_tclMsgEngineeringTextUpReg& teafi_tclMsgEngineeringTextUpReg::operator=(const teafi_tclMsgEngineeringTextUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 teafi_tclMsgEngineeringTextUpReg::u16GetServiceID() const {return TEAFI_C_U16_SERVICE_ID;}
tU16 teafi_tclMsgEngineeringTextUpReg::u16GetFunctionID() const {return TEAFI_C_U16_ENGINEERINGTEXT;}
tU8 teafi_tclMsgEngineeringTextUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 teafi_tclMsgEngineeringTextUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool teafi_tclMsgEngineeringTextUpReg::operator==(const teafi_tclMsgEngineeringTextUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& teafi_tclMsgEngineeringTextUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& teafi_tclMsgEngineeringTextUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
teafi_tclMsgEngineeringTextRelUpReg::teafi_tclMsgEngineeringTextRelUpReg(const teafi_tclMsgEngineeringTextRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
teafi_tclMsgEngineeringTextRelUpReg& teafi_tclMsgEngineeringTextRelUpReg::operator=(const teafi_tclMsgEngineeringTextRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 teafi_tclMsgEngineeringTextRelUpReg::u16GetServiceID() const {return TEAFI_C_U16_SERVICE_ID;}
tU16 teafi_tclMsgEngineeringTextRelUpReg::u16GetFunctionID() const {return TEAFI_C_U16_ENGINEERINGTEXT;}
tU8 teafi_tclMsgEngineeringTextRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 teafi_tclMsgEngineeringTextRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool teafi_tclMsgEngineeringTextRelUpReg::operator==(const teafi_tclMsgEngineeringTextRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& teafi_tclMsgEngineeringTextRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& teafi_tclMsgEngineeringTextRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
teafi_tclMsgEngineeringTextStatus::teafi_tclMsgEngineeringTextStatus(const teafi_tclMsgEngineeringTextStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   Message = coRef.Message;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
teafi_tclMsgEngineeringTextStatus& teafi_tclMsgEngineeringTextStatus::operator=(const teafi_tclMsgEngineeringTextStatus& coRef)
{
   if (this == &coRef) return *this;
   Message = coRef.Message;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 teafi_tclMsgEngineeringTextStatus::u16GetServiceID() const {return TEAFI_C_U16_SERVICE_ID;}
tU16 teafi_tclMsgEngineeringTextStatus::u16GetFunctionID() const {return TEAFI_C_U16_ENGINEERINGTEXT;}
tU8 teafi_tclMsgEngineeringTextStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid teafi_tclMsgEngineeringTextStatus::vDestroy()
{
   Message.vDestroy();
}

tU32 teafi_tclMsgEngineeringTextStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+Message.u32GetSize(u16MajorVersion);
}

tBool teafi_tclMsgEngineeringTextStatus::operator==(const teafi_tclMsgEngineeringTextStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Message == rfoCmp.Message);
   return bResult;
}

fi_tclInContext& teafi_tclMsgEngineeringTextStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> Message;
   return oIn;
}

fi_tclOutContext& teafi_tclMsgEngineeringTextStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Message;
   return oOut;
}

