#ifndef TEAFILANGUAGE_HEADER
#define TEAFILANGUAGE_HEADER

class teafi_tclInContext;
class teafi_tclOutContext;
class teafi_tclVisitorBase;

class MY_DECL teafi_tclDescription {
 public:
  enum tenType { EN_PARSING, EN_GENERATING };	
  
  teafi_tclDescription(fi_tclInContext* poIn, teafi_tclVisitorBase* poVisit);
  teafi_tclDescription(fi_tclOutContext* poOut, teafi_tclVisitorBase* poVisit);
  
  /* --Hier kommen nun die Methoden, die einzelne Nachrichten entspr. NaFI 
		erzeugen (EN_GENERATING) bzw. einlesen (EN_PARSING). */

  tBool bInitMessage(teafi_tclToken::tenType enMsgToken);
  tBool bProcessMessage();

  // tBool bProcessElement(); 

  tBool bDoIt(fi_tclVisitableTypeBase& poBaseType);
#ifndef FI_S_EXTERNAL_FI
  void vEnableSpecialBinContainer() { bUseSpecialBinContainer = true; }
#endif

 private:
  /* default constructor */ teafi_tclDescription();  //lint !e1704 // always use parameters
  tenType enType; //--read or write?

  union {
    fi_tclInContext* poInContext;
    fi_tclOutContext* poOutContext;
  };

  teafi_tclVisitorBase* poVisitor;

  // typedef navifi_tclTraversePath::tclKnot tclKnot;

  tBool bUseSpecialBinContainer;  
  
 public:
  
  // --Traversierungspfad
  fi_tclTraversePath<teafi_tclKnot> oPath;
  //   navifi_tclTraversePath oPath;
  fi_tclTraversePath<teafi_tclKnot> oCallStack;
   //  navifi_tclTraversePath oCallStack;
  
};

// --Inline-Implementierungen
inline teafi_tclDescription::teafi_tclDescription(fi_tclInContext* poIn, teafi_tclVisitorBase* poVisit):
  enType(EN_PARSING),poInContext(poIn),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

inline teafi_tclDescription::teafi_tclDescription(fi_tclOutContext* poOut, teafi_tclVisitorBase* poVisit):
  enType(EN_GENERATING),poOutContext(poOut),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

#endif

