/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#include "precompiled.hh"
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgTransferUpdateFileInfoMethodStart::sxmweatherfi_tclMsgTransferUpdateFileInfoMethodStart(const sxmweatherfi_tclMsgTransferUpdateFileInfoMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   UpdateType = coRef.UpdateType;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgTransferUpdateFileInfoMethodStart& sxmweatherfi_tclMsgTransferUpdateFileInfoMethodStart::operator=(const sxmweatherfi_tclMsgTransferUpdateFileInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   UpdateType = coRef.UpdateType;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmweatherfi_tclMsgTransferUpdateFileInfoMethodStart::u16GetServiceID() const {return SXMWEATHERFI_C_U16_SERVICE_ID;}
tU16 sxmweatherfi_tclMsgTransferUpdateFileInfoMethodStart::u16GetFunctionID() const {return SXMWEATHERFI_C_U16_TRANSFERUPDATEFILEINFO;}
tU8 sxmweatherfi_tclMsgTransferUpdateFileInfoMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 sxmweatherfi_tclMsgTransferUpdateFileInfoMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool sxmweatherfi_tclMsgTransferUpdateFileInfoMethodStart::operator==(const sxmweatherfi_tclMsgTransferUpdateFileInfoMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UpdateType == rfoCmp.UpdateType);
   return bResult;
}

fi_tclInContext& sxmweatherfi_tclMsgTransferUpdateFileInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> UpdateType;
   return oIn;
}

fi_tclOutContext& sxmweatherfi_tclMsgTransferUpdateFileInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UpdateType;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgTransferUpdateFileInfoMethodResult::sxmweatherfi_tclMsgTransferUpdateFileInfoMethodResult(const sxmweatherfi_tclMsgTransferUpdateFileInfoMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   UpdateType = coRef.UpdateType;
   UpdateFileName = coRef.UpdateFileName;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgTransferUpdateFileInfoMethodResult& sxmweatherfi_tclMsgTransferUpdateFileInfoMethodResult::operator=(const sxmweatherfi_tclMsgTransferUpdateFileInfoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   UpdateType = coRef.UpdateType;
   UpdateFileName = coRef.UpdateFileName;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmweatherfi_tclMsgTransferUpdateFileInfoMethodResult::u16GetServiceID() const {return SXMWEATHERFI_C_U16_SERVICE_ID;}
tU16 sxmweatherfi_tclMsgTransferUpdateFileInfoMethodResult::u16GetFunctionID() const {return SXMWEATHERFI_C_U16_TRANSFERUPDATEFILEINFO;}
tU8 sxmweatherfi_tclMsgTransferUpdateFileInfoMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid sxmweatherfi_tclMsgTransferUpdateFileInfoMethodResult::vDestroy()
{
   UpdateFileName.vDestroy();
}

tU32 sxmweatherfi_tclMsgTransferUpdateFileInfoMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+UpdateFileName.u32GetSize(u16MajorVersion);
}

tBool sxmweatherfi_tclMsgTransferUpdateFileInfoMethodResult::operator==(const sxmweatherfi_tclMsgTransferUpdateFileInfoMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UpdateType == rfoCmp.UpdateType);
      bResult = bResult && (UpdateFileName == rfoCmp.UpdateFileName);
   return bResult;
}

fi_tclInContext& sxmweatherfi_tclMsgTransferUpdateFileInfoMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> UpdateType;
   oIn >> UpdateFileName;
   return oIn;
}

fi_tclOutContext& sxmweatherfi_tclMsgTransferUpdateFileInfoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UpdateType;
   oOut << UpdateFileName;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgReleaseUpdateFileMethodStart::sxmweatherfi_tclMsgReleaseUpdateFileMethodStart(const sxmweatherfi_tclMsgReleaseUpdateFileMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   UpdateType = coRef.UpdateType;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgReleaseUpdateFileMethodStart& sxmweatherfi_tclMsgReleaseUpdateFileMethodStart::operator=(const sxmweatherfi_tclMsgReleaseUpdateFileMethodStart& coRef)
{
   if (this == &coRef) return *this;
   UpdateType = coRef.UpdateType;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmweatherfi_tclMsgReleaseUpdateFileMethodStart::u16GetServiceID() const {return SXMWEATHERFI_C_U16_SERVICE_ID;}
tU16 sxmweatherfi_tclMsgReleaseUpdateFileMethodStart::u16GetFunctionID() const {return SXMWEATHERFI_C_U16_RELEASEUPDATEFILE;}
tU8 sxmweatherfi_tclMsgReleaseUpdateFileMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 sxmweatherfi_tclMsgReleaseUpdateFileMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool sxmweatherfi_tclMsgReleaseUpdateFileMethodStart::operator==(const sxmweatherfi_tclMsgReleaseUpdateFileMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UpdateType == rfoCmp.UpdateType);
   return bResult;
}

fi_tclInContext& sxmweatherfi_tclMsgReleaseUpdateFileMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> UpdateType;
   return oIn;
}

fi_tclOutContext& sxmweatherfi_tclMsgReleaseUpdateFileMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UpdateType;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgReleaseUpdateFileMethodResult::sxmweatherfi_tclMsgReleaseUpdateFileMethodResult(const sxmweatherfi_tclMsgReleaseUpdateFileMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   UpdateType = coRef.UpdateType;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgReleaseUpdateFileMethodResult& sxmweatherfi_tclMsgReleaseUpdateFileMethodResult::operator=(const sxmweatherfi_tclMsgReleaseUpdateFileMethodResult& coRef)
{
   if (this == &coRef) return *this;
   UpdateType = coRef.UpdateType;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmweatherfi_tclMsgReleaseUpdateFileMethodResult::u16GetServiceID() const {return SXMWEATHERFI_C_U16_SERVICE_ID;}
tU16 sxmweatherfi_tclMsgReleaseUpdateFileMethodResult::u16GetFunctionID() const {return SXMWEATHERFI_C_U16_RELEASEUPDATEFILE;}
tU8 sxmweatherfi_tclMsgReleaseUpdateFileMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 sxmweatherfi_tclMsgReleaseUpdateFileMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool sxmweatherfi_tclMsgReleaseUpdateFileMethodResult::operator==(const sxmweatherfi_tclMsgReleaseUpdateFileMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UpdateType == rfoCmp.UpdateType);
   return bResult;
}

fi_tclInContext& sxmweatherfi_tclMsgReleaseUpdateFileMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> UpdateType;
   return oIn;
}

fi_tclOutContext& sxmweatherfi_tclMsgReleaseUpdateFileMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UpdateType;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgXchngeCapabilitiesMethodStart::sxmweatherfi_tclMsgXchngeCapabilitiesMethodStart(const sxmweatherfi_tclMsgXchngeCapabilitiesMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
   WeatherCapabilities = coRef.WeatherCapabilities;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgXchngeCapabilitiesMethodStart& sxmweatherfi_tclMsgXchngeCapabilitiesMethodStart::operator=(const sxmweatherfi_tclMsgXchngeCapabilitiesMethodStart& coRef)
{
   if (this == &coRef) return *this;
   WeatherCapabilities = coRef.WeatherCapabilities;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmweatherfi_tclMsgXchngeCapabilitiesMethodStart::u16GetServiceID() const {return SXMWEATHERFI_C_U16_SERVICE_ID;}
tU16 sxmweatherfi_tclMsgXchngeCapabilitiesMethodStart::u16GetFunctionID() const {return SXMWEATHERFI_C_U16_XCHNGECAPABILITIES;}
tU8 sxmweatherfi_tclMsgXchngeCapabilitiesMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tVoid sxmweatherfi_tclMsgXchngeCapabilitiesMethodStart::vDestroy()
{
   WeatherCapabilities.vDestroy(); 
}

tU32 sxmweatherfi_tclMsgXchngeCapabilitiesMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+WeatherCapabilities.u32GetSize(u16MajorVersion);
}

tBool sxmweatherfi_tclMsgXchngeCapabilitiesMethodStart::operator==(const sxmweatherfi_tclMsgXchngeCapabilitiesMethodStart& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (WeatherCapabilities == rfoCmp.WeatherCapabilities);
   return bResult;
}

fi_tclInContext& sxmweatherfi_tclMsgXchngeCapabilitiesMethodStart::oRead(fi_tclInContext& oIn)
{
   oIn >> WeatherCapabilities;
   return oIn;
}

fi_tclOutContext& sxmweatherfi_tclMsgXchngeCapabilitiesMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   oOut << WeatherCapabilities;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgXchngeCapabilitiesMethodResult::sxmweatherfi_tclMsgXchngeCapabilitiesMethodResult(const sxmweatherfi_tclMsgXchngeCapabilitiesMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   SupportedCapabilities = coRef.SupportedCapabilities;
   GraphicalWeatherInfo = coRef.GraphicalWeatherInfo;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgXchngeCapabilitiesMethodResult& sxmweatherfi_tclMsgXchngeCapabilitiesMethodResult::operator=(const sxmweatherfi_tclMsgXchngeCapabilitiesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   SupportedCapabilities = coRef.SupportedCapabilities;
   GraphicalWeatherInfo = coRef.GraphicalWeatherInfo;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmweatherfi_tclMsgXchngeCapabilitiesMethodResult::u16GetServiceID() const {return SXMWEATHERFI_C_U16_SERVICE_ID;}
tU16 sxmweatherfi_tclMsgXchngeCapabilitiesMethodResult::u16GetFunctionID() const {return SXMWEATHERFI_C_U16_XCHNGECAPABILITIES;}
tU8 sxmweatherfi_tclMsgXchngeCapabilitiesMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid sxmweatherfi_tclMsgXchngeCapabilitiesMethodResult::vDestroy()
{
   SupportedCapabilities.vDestroy(); 
   GraphicalWeatherInfo.vDestroy(); 
}

tU32 sxmweatherfi_tclMsgXchngeCapabilitiesMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+SupportedCapabilities.u32GetSize(u16MajorVersion)+GraphicalWeatherInfo.u32GetSize(u16MajorVersion);
}

tBool sxmweatherfi_tclMsgXchngeCapabilitiesMethodResult::operator==(const sxmweatherfi_tclMsgXchngeCapabilitiesMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (SupportedCapabilities == rfoCmp.SupportedCapabilities);
      bResult = bResult && (GraphicalWeatherInfo == rfoCmp.GraphicalWeatherInfo);
   return bResult;
}

fi_tclInContext& sxmweatherfi_tclMsgXchngeCapabilitiesMethodResult::oRead(fi_tclInContext& oIn)
{
   oIn >> SupportedCapabilities;
   oIn >> GraphicalWeatherInfo;
   return oIn;
}

fi_tclOutContext& sxmweatherfi_tclMsgXchngeCapabilitiesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << SupportedCapabilities;
   oOut << GraphicalWeatherInfo;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgAcquireGraphicalAUMethodStart::sxmweatherfi_tclMsgAcquireGraphicalAUMethodStart(const sxmweatherfi_tclMsgAcquireGraphicalAUMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgAcquireGraphicalAUMethodStart& sxmweatherfi_tclMsgAcquireGraphicalAUMethodStart::operator=(const sxmweatherfi_tclMsgAcquireGraphicalAUMethodStart& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmweatherfi_tclMsgAcquireGraphicalAUMethodStart::u16GetServiceID() const {return SXMWEATHERFI_C_U16_SERVICE_ID;}
tU16 sxmweatherfi_tclMsgAcquireGraphicalAUMethodStart::u16GetFunctionID() const {return SXMWEATHERFI_C_U16_ACQUIREGRAPHICALAU;}
tU8 sxmweatherfi_tclMsgAcquireGraphicalAUMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 sxmweatherfi_tclMsgAcquireGraphicalAUMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxmweatherfi_tclMsgAcquireGraphicalAUMethodStart::operator==(const sxmweatherfi_tclMsgAcquireGraphicalAUMethodStart& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxmweatherfi_tclMsgAcquireGraphicalAUMethodStart::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxmweatherfi_tclMsgAcquireGraphicalAUMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgAcquireGraphicalAUMethodResult::sxmweatherfi_tclMsgAcquireGraphicalAUMethodResult(const sxmweatherfi_tclMsgAcquireGraphicalAUMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
   IndexList = coRef.IndexList;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgAcquireGraphicalAUMethodResult& sxmweatherfi_tclMsgAcquireGraphicalAUMethodResult::operator=(const sxmweatherfi_tclMsgAcquireGraphicalAUMethodResult& coRef)
{
   if (this == &coRef) return *this;
   IndexList = coRef.IndexList;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmweatherfi_tclMsgAcquireGraphicalAUMethodResult::u16GetServiceID() const {return SXMWEATHERFI_C_U16_SERVICE_ID;}
tU16 sxmweatherfi_tclMsgAcquireGraphicalAUMethodResult::u16GetFunctionID() const {return SXMWEATHERFI_C_U16_ACQUIREGRAPHICALAU;}
tU8 sxmweatherfi_tclMsgAcquireGraphicalAUMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tVoid sxmweatherfi_tclMsgAcquireGraphicalAUMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < IndexList.size(); ++u32Idx)
         IndexList[u32Idx].vDestroy();
   }
   IndexList.clear();
}

tU32 sxmweatherfi_tclMsgAcquireGraphicalAUMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+IndexList.size()*8;
}

tBool sxmweatherfi_tclMsgAcquireGraphicalAUMethodResult::operator==(const sxmweatherfi_tclMsgAcquireGraphicalAUMethodResult& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (IndexList.size() == rfoCmp.IndexList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < IndexList.size()); ++u32Idx)
            bResult = bResult && (IndexList[u32Idx] == rfoCmp.IndexList[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& sxmweatherfi_tclMsgAcquireGraphicalAUMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < IndexList.size(); ++u32Idx)
      {
         IndexList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      oIn >> u32Length;
      IndexList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> IndexList[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& sxmweatherfi_tclMsgAcquireGraphicalAUMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)IndexList.size();
   {
      for (tU32 u32Idx = 0; u32Idx < IndexList.size(); ++u32Idx)
         oOut << IndexList[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgReleaseGraphicalAUMethodStart::sxmweatherfi_tclMsgReleaseGraphicalAUMethodStart(const sxmweatherfi_tclMsgReleaseGraphicalAUMethodStart& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgReleaseGraphicalAUMethodStart& sxmweatherfi_tclMsgReleaseGraphicalAUMethodStart::operator=(const sxmweatherfi_tclMsgReleaseGraphicalAUMethodStart& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmweatherfi_tclMsgReleaseGraphicalAUMethodStart::u16GetServiceID() const {return SXMWEATHERFI_C_U16_SERVICE_ID;}
tU16 sxmweatherfi_tclMsgReleaseGraphicalAUMethodStart::u16GetFunctionID() const {return SXMWEATHERFI_C_U16_RELEASEGRAPHICALAU;}
tU8 sxmweatherfi_tclMsgReleaseGraphicalAUMethodStart::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODSTART;}

tU32 sxmweatherfi_tclMsgReleaseGraphicalAUMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxmweatherfi_tclMsgReleaseGraphicalAUMethodStart::operator==(const sxmweatherfi_tclMsgReleaseGraphicalAUMethodStart& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxmweatherfi_tclMsgReleaseGraphicalAUMethodStart::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxmweatherfi_tclMsgReleaseGraphicalAUMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgReleaseGraphicalAUMethodResult::sxmweatherfi_tclMsgReleaseGraphicalAUMethodResult(const sxmweatherfi_tclMsgReleaseGraphicalAUMethodResult& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgReleaseGraphicalAUMethodResult& sxmweatherfi_tclMsgReleaseGraphicalAUMethodResult::operator=(const sxmweatherfi_tclMsgReleaseGraphicalAUMethodResult& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmweatherfi_tclMsgReleaseGraphicalAUMethodResult::u16GetServiceID() const {return SXMWEATHERFI_C_U16_SERVICE_ID;}
tU16 sxmweatherfi_tclMsgReleaseGraphicalAUMethodResult::u16GetFunctionID() const {return SXMWEATHERFI_C_U16_RELEASEGRAPHICALAU;}
tU8 sxmweatherfi_tclMsgReleaseGraphicalAUMethodResult::u8GetOpCode() const {return CCA_C_U8_OPCODE_METHODRESULT;}

tU32 sxmweatherfi_tclMsgReleaseGraphicalAUMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxmweatherfi_tclMsgReleaseGraphicalAUMethodResult::operator==(const sxmweatherfi_tclMsgReleaseGraphicalAUMethodResult& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxmweatherfi_tclMsgReleaseGraphicalAUMethodResult::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxmweatherfi_tclMsgReleaseGraphicalAUMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgTabWeatherAuthInfoUpReg::sxmweatherfi_tclMsgTabWeatherAuthInfoUpReg(const sxmweatherfi_tclMsgTabWeatherAuthInfoUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgTabWeatherAuthInfoUpReg& sxmweatherfi_tclMsgTabWeatherAuthInfoUpReg::operator=(const sxmweatherfi_tclMsgTabWeatherAuthInfoUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmweatherfi_tclMsgTabWeatherAuthInfoUpReg::u16GetServiceID() const {return SXMWEATHERFI_C_U16_SERVICE_ID;}
tU16 sxmweatherfi_tclMsgTabWeatherAuthInfoUpReg::u16GetFunctionID() const {return SXMWEATHERFI_C_U16_TABWEATHERAUTHINFO;}
tU8 sxmweatherfi_tclMsgTabWeatherAuthInfoUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 sxmweatherfi_tclMsgTabWeatherAuthInfoUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxmweatherfi_tclMsgTabWeatherAuthInfoUpReg::operator==(const sxmweatherfi_tclMsgTabWeatherAuthInfoUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxmweatherfi_tclMsgTabWeatherAuthInfoUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxmweatherfi_tclMsgTabWeatherAuthInfoUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgTabWeatherAuthInfoRelUpReg::sxmweatherfi_tclMsgTabWeatherAuthInfoRelUpReg(const sxmweatherfi_tclMsgTabWeatherAuthInfoRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgTabWeatherAuthInfoRelUpReg& sxmweatherfi_tclMsgTabWeatherAuthInfoRelUpReg::operator=(const sxmweatherfi_tclMsgTabWeatherAuthInfoRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmweatherfi_tclMsgTabWeatherAuthInfoRelUpReg::u16GetServiceID() const {return SXMWEATHERFI_C_U16_SERVICE_ID;}
tU16 sxmweatherfi_tclMsgTabWeatherAuthInfoRelUpReg::u16GetFunctionID() const {return SXMWEATHERFI_C_U16_TABWEATHERAUTHINFO;}
tU8 sxmweatherfi_tclMsgTabWeatherAuthInfoRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 sxmweatherfi_tclMsgTabWeatherAuthInfoRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxmweatherfi_tclMsgTabWeatherAuthInfoRelUpReg::operator==(const sxmweatherfi_tclMsgTabWeatherAuthInfoRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxmweatherfi_tclMsgTabWeatherAuthInfoRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxmweatherfi_tclMsgTabWeatherAuthInfoRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgTabWeatherAuthInfoGet::sxmweatherfi_tclMsgTabWeatherAuthInfoGet(const sxmweatherfi_tclMsgTabWeatherAuthInfoGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgTabWeatherAuthInfoGet& sxmweatherfi_tclMsgTabWeatherAuthInfoGet::operator=(const sxmweatherfi_tclMsgTabWeatherAuthInfoGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmweatherfi_tclMsgTabWeatherAuthInfoGet::u16GetServiceID() const {return SXMWEATHERFI_C_U16_SERVICE_ID;}
tU16 sxmweatherfi_tclMsgTabWeatherAuthInfoGet::u16GetFunctionID() const {return SXMWEATHERFI_C_U16_TABWEATHERAUTHINFO;}
tU8 sxmweatherfi_tclMsgTabWeatherAuthInfoGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 sxmweatherfi_tclMsgTabWeatherAuthInfoGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxmweatherfi_tclMsgTabWeatherAuthInfoGet::operator==(const sxmweatherfi_tclMsgTabWeatherAuthInfoGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxmweatherfi_tclMsgTabWeatherAuthInfoGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxmweatherfi_tclMsgTabWeatherAuthInfoGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgTabWeatherAuthInfoStatus::sxmweatherfi_tclMsgTabWeatherAuthInfoStatus(const sxmweatherfi_tclMsgTabWeatherAuthInfoStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   TabWeatherAuthStatus = coRef.TabWeatherAuthStatus;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgTabWeatherAuthInfoStatus& sxmweatherfi_tclMsgTabWeatherAuthInfoStatus::operator=(const sxmweatherfi_tclMsgTabWeatherAuthInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   TabWeatherAuthStatus = coRef.TabWeatherAuthStatus;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmweatherfi_tclMsgTabWeatherAuthInfoStatus::u16GetServiceID() const {return SXMWEATHERFI_C_U16_SERVICE_ID;}
tU16 sxmweatherfi_tclMsgTabWeatherAuthInfoStatus::u16GetFunctionID() const {return SXMWEATHERFI_C_U16_TABWEATHERAUTHINFO;}
tU8 sxmweatherfi_tclMsgTabWeatherAuthInfoStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 sxmweatherfi_tclMsgTabWeatherAuthInfoStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool sxmweatherfi_tclMsgTabWeatherAuthInfoStatus::operator==(const sxmweatherfi_tclMsgTabWeatherAuthInfoStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (TabWeatherAuthStatus == rfoCmp.TabWeatherAuthStatus);
   return bResult;
}

fi_tclInContext& sxmweatherfi_tclMsgTabWeatherAuthInfoStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> TabWeatherAuthStatus;
   return oIn;
}

fi_tclOutContext& sxmweatherfi_tclMsgTabWeatherAuthInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << TabWeatherAuthStatus;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgSXMSignalInfoUpReg::sxmweatherfi_tclMsgSXMSignalInfoUpReg(const sxmweatherfi_tclMsgSXMSignalInfoUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgSXMSignalInfoUpReg& sxmweatherfi_tclMsgSXMSignalInfoUpReg::operator=(const sxmweatherfi_tclMsgSXMSignalInfoUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmweatherfi_tclMsgSXMSignalInfoUpReg::u16GetServiceID() const {return SXMWEATHERFI_C_U16_SERVICE_ID;}
tU16 sxmweatherfi_tclMsgSXMSignalInfoUpReg::u16GetFunctionID() const {return SXMWEATHERFI_C_U16_SXMSIGNALINFO;}
tU8 sxmweatherfi_tclMsgSXMSignalInfoUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 sxmweatherfi_tclMsgSXMSignalInfoUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxmweatherfi_tclMsgSXMSignalInfoUpReg::operator==(const sxmweatherfi_tclMsgSXMSignalInfoUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxmweatherfi_tclMsgSXMSignalInfoUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxmweatherfi_tclMsgSXMSignalInfoUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgSXMSignalInfoRelUpReg::sxmweatherfi_tclMsgSXMSignalInfoRelUpReg(const sxmweatherfi_tclMsgSXMSignalInfoRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgSXMSignalInfoRelUpReg& sxmweatherfi_tclMsgSXMSignalInfoRelUpReg::operator=(const sxmweatherfi_tclMsgSXMSignalInfoRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmweatherfi_tclMsgSXMSignalInfoRelUpReg::u16GetServiceID() const {return SXMWEATHERFI_C_U16_SERVICE_ID;}
tU16 sxmweatherfi_tclMsgSXMSignalInfoRelUpReg::u16GetFunctionID() const {return SXMWEATHERFI_C_U16_SXMSIGNALINFO;}
tU8 sxmweatherfi_tclMsgSXMSignalInfoRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 sxmweatherfi_tclMsgSXMSignalInfoRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxmweatherfi_tclMsgSXMSignalInfoRelUpReg::operator==(const sxmweatherfi_tclMsgSXMSignalInfoRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxmweatherfi_tclMsgSXMSignalInfoRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxmweatherfi_tclMsgSXMSignalInfoRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgSXMSignalInfoGet::sxmweatherfi_tclMsgSXMSignalInfoGet(const sxmweatherfi_tclMsgSXMSignalInfoGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgSXMSignalInfoGet& sxmweatherfi_tclMsgSXMSignalInfoGet::operator=(const sxmweatherfi_tclMsgSXMSignalInfoGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmweatherfi_tclMsgSXMSignalInfoGet::u16GetServiceID() const {return SXMWEATHERFI_C_U16_SERVICE_ID;}
tU16 sxmweatherfi_tclMsgSXMSignalInfoGet::u16GetFunctionID() const {return SXMWEATHERFI_C_U16_SXMSIGNALINFO;}
tU8 sxmweatherfi_tclMsgSXMSignalInfoGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 sxmweatherfi_tclMsgSXMSignalInfoGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxmweatherfi_tclMsgSXMSignalInfoGet::operator==(const sxmweatherfi_tclMsgSXMSignalInfoGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxmweatherfi_tclMsgSXMSignalInfoGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxmweatherfi_tclMsgSXMSignalInfoGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgSXMSignalInfoStatus::sxmweatherfi_tclMsgSXMSignalInfoStatus(const sxmweatherfi_tclMsgSXMSignalInfoStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   SXMSignalStatus = coRef.SXMSignalStatus;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgSXMSignalInfoStatus& sxmweatherfi_tclMsgSXMSignalInfoStatus::operator=(const sxmweatherfi_tclMsgSXMSignalInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   SXMSignalStatus = coRef.SXMSignalStatus;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmweatherfi_tclMsgSXMSignalInfoStatus::u16GetServiceID() const {return SXMWEATHERFI_C_U16_SERVICE_ID;}
tU16 sxmweatherfi_tclMsgSXMSignalInfoStatus::u16GetFunctionID() const {return SXMWEATHERFI_C_U16_SXMSIGNALINFO;}
tU8 sxmweatherfi_tclMsgSXMSignalInfoStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 sxmweatherfi_tclMsgSXMSignalInfoStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool sxmweatherfi_tclMsgSXMSignalInfoStatus::operator==(const sxmweatherfi_tclMsgSXMSignalInfoStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (SXMSignalStatus == rfoCmp.SXMSignalStatus);
   return bResult;
}

fi_tclInContext& sxmweatherfi_tclMsgSXMSignalInfoStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> SXMSignalStatus;
   return oIn;
}

fi_tclOutContext& sxmweatherfi_tclMsgSXMSignalInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << SXMSignalStatus;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgNewUpdateFileAvailableUpReg::sxmweatherfi_tclMsgNewUpdateFileAvailableUpReg(const sxmweatherfi_tclMsgNewUpdateFileAvailableUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgNewUpdateFileAvailableUpReg& sxmweatherfi_tclMsgNewUpdateFileAvailableUpReg::operator=(const sxmweatherfi_tclMsgNewUpdateFileAvailableUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmweatherfi_tclMsgNewUpdateFileAvailableUpReg::u16GetServiceID() const {return SXMWEATHERFI_C_U16_SERVICE_ID;}
tU16 sxmweatherfi_tclMsgNewUpdateFileAvailableUpReg::u16GetFunctionID() const {return SXMWEATHERFI_C_U16_NEWUPDATEFILEAVAILABLE;}
tU8 sxmweatherfi_tclMsgNewUpdateFileAvailableUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 sxmweatherfi_tclMsgNewUpdateFileAvailableUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxmweatherfi_tclMsgNewUpdateFileAvailableUpReg::operator==(const sxmweatherfi_tclMsgNewUpdateFileAvailableUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxmweatherfi_tclMsgNewUpdateFileAvailableUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxmweatherfi_tclMsgNewUpdateFileAvailableUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgNewUpdateFileAvailableRelUpReg::sxmweatherfi_tclMsgNewUpdateFileAvailableRelUpReg(const sxmweatherfi_tclMsgNewUpdateFileAvailableRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgNewUpdateFileAvailableRelUpReg& sxmweatherfi_tclMsgNewUpdateFileAvailableRelUpReg::operator=(const sxmweatherfi_tclMsgNewUpdateFileAvailableRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmweatherfi_tclMsgNewUpdateFileAvailableRelUpReg::u16GetServiceID() const {return SXMWEATHERFI_C_U16_SERVICE_ID;}
tU16 sxmweatherfi_tclMsgNewUpdateFileAvailableRelUpReg::u16GetFunctionID() const {return SXMWEATHERFI_C_U16_NEWUPDATEFILEAVAILABLE;}
tU8 sxmweatherfi_tclMsgNewUpdateFileAvailableRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 sxmweatherfi_tclMsgNewUpdateFileAvailableRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxmweatherfi_tclMsgNewUpdateFileAvailableRelUpReg::operator==(const sxmweatherfi_tclMsgNewUpdateFileAvailableRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxmweatherfi_tclMsgNewUpdateFileAvailableRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxmweatherfi_tclMsgNewUpdateFileAvailableRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgNewUpdateFileAvailableStatus::sxmweatherfi_tclMsgNewUpdateFileAvailableStatus(const sxmweatherfi_tclMsgNewUpdateFileAvailableStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   UpdateType = coRef.UpdateType;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgNewUpdateFileAvailableStatus& sxmweatherfi_tclMsgNewUpdateFileAvailableStatus::operator=(const sxmweatherfi_tclMsgNewUpdateFileAvailableStatus& coRef)
{
   if (this == &coRef) return *this;
   UpdateType = coRef.UpdateType;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmweatherfi_tclMsgNewUpdateFileAvailableStatus::u16GetServiceID() const {return SXMWEATHERFI_C_U16_SERVICE_ID;}
tU16 sxmweatherfi_tclMsgNewUpdateFileAvailableStatus::u16GetFunctionID() const {return SXMWEATHERFI_C_U16_NEWUPDATEFILEAVAILABLE;}
tU8 sxmweatherfi_tclMsgNewUpdateFileAvailableStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 sxmweatherfi_tclMsgNewUpdateFileAvailableStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool sxmweatherfi_tclMsgNewUpdateFileAvailableStatus::operator==(const sxmweatherfi_tclMsgNewUpdateFileAvailableStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (UpdateType == rfoCmp.UpdateType);
   return bResult;
}

fi_tclInContext& sxmweatherfi_tclMsgNewUpdateFileAvailableStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> UpdateType;
   return oIn;
}

fi_tclOutContext& sxmweatherfi_tclMsgNewUpdateFileAvailableStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << UpdateType;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgTabWeatherDataUpReg::sxmweatherfi_tclMsgTabWeatherDataUpReg(const sxmweatherfi_tclMsgTabWeatherDataUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgTabWeatherDataUpReg& sxmweatherfi_tclMsgTabWeatherDataUpReg::operator=(const sxmweatherfi_tclMsgTabWeatherDataUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmweatherfi_tclMsgTabWeatherDataUpReg::u16GetServiceID() const {return SXMWEATHERFI_C_U16_SERVICE_ID;}
tU16 sxmweatherfi_tclMsgTabWeatherDataUpReg::u16GetFunctionID() const {return SXMWEATHERFI_C_U16_TABWEATHERDATA;}
tU8 sxmweatherfi_tclMsgTabWeatherDataUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 sxmweatherfi_tclMsgTabWeatherDataUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxmweatherfi_tclMsgTabWeatherDataUpReg::operator==(const sxmweatherfi_tclMsgTabWeatherDataUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxmweatherfi_tclMsgTabWeatherDataUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxmweatherfi_tclMsgTabWeatherDataUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgTabWeatherDataRelUpReg::sxmweatherfi_tclMsgTabWeatherDataRelUpReg(const sxmweatherfi_tclMsgTabWeatherDataRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgTabWeatherDataRelUpReg& sxmweatherfi_tclMsgTabWeatherDataRelUpReg::operator=(const sxmweatherfi_tclMsgTabWeatherDataRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmweatherfi_tclMsgTabWeatherDataRelUpReg::u16GetServiceID() const {return SXMWEATHERFI_C_U16_SERVICE_ID;}
tU16 sxmweatherfi_tclMsgTabWeatherDataRelUpReg::u16GetFunctionID() const {return SXMWEATHERFI_C_U16_TABWEATHERDATA;}
tU8 sxmweatherfi_tclMsgTabWeatherDataRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 sxmweatherfi_tclMsgTabWeatherDataRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxmweatherfi_tclMsgTabWeatherDataRelUpReg::operator==(const sxmweatherfi_tclMsgTabWeatherDataRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxmweatherfi_tclMsgTabWeatherDataRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxmweatherfi_tclMsgTabWeatherDataRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgTabWeatherDataStatus::sxmweatherfi_tclMsgTabWeatherDataStatus(const sxmweatherfi_tclMsgTabWeatherDataStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   AccessUnitSize = coRef.AccessUnitSize;
   AccessUnitData = coRef.AccessUnitData;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgTabWeatherDataStatus& sxmweatherfi_tclMsgTabWeatherDataStatus::operator=(const sxmweatherfi_tclMsgTabWeatherDataStatus& coRef)
{
   if (this == &coRef) return *this;
   AccessUnitSize = coRef.AccessUnitSize;
   AccessUnitData = coRef.AccessUnitData;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmweatherfi_tclMsgTabWeatherDataStatus::u16GetServiceID() const {return SXMWEATHERFI_C_U16_SERVICE_ID;}
tU16 sxmweatherfi_tclMsgTabWeatherDataStatus::u16GetFunctionID() const {return SXMWEATHERFI_C_U16_TABWEATHERDATA;}
tU8 sxmweatherfi_tclMsgTabWeatherDataStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid sxmweatherfi_tclMsgTabWeatherDataStatus::vDestroy()
{
   AccessUnitData.clear();
}

tU32 sxmweatherfi_tclMsgTabWeatherDataStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8+AccessUnitData.size()*1;
}

tBool sxmweatherfi_tclMsgTabWeatherDataStatus::operator==(const sxmweatherfi_tclMsgTabWeatherDataStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (AccessUnitSize == rfoCmp.AccessUnitSize);
      bResult = bResult && (AccessUnitData.size() == rfoCmp.AccessUnitData.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < AccessUnitData.size()); ++u32Idx)
            bResult = bResult && (AccessUnitData[u32Idx] == rfoCmp.AccessUnitData[u32Idx]);
      }
   return bResult;
}

fi_tclInContext& sxmweatherfi_tclMsgTabWeatherDataStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> AccessUnitSize;
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      AccessUnitData.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> AccessUnitData[u32Idx];
      }
   }
   return oIn;
}

fi_tclOutContext& sxmweatherfi_tclMsgTabWeatherDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << AccessUnitSize;
   oOut << (tU32)AccessUnitData.size();
   {
      for (tU32 u32Idx = 0; u32Idx < AccessUnitData.size(); ++u32Idx)
         oOut << AccessUnitData[u32Idx];
   }
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgGraphicalWeatherAUUpReg::sxmweatherfi_tclMsgGraphicalWeatherAUUpReg(const sxmweatherfi_tclMsgGraphicalWeatherAUUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgGraphicalWeatherAUUpReg& sxmweatherfi_tclMsgGraphicalWeatherAUUpReg::operator=(const sxmweatherfi_tclMsgGraphicalWeatherAUUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmweatherfi_tclMsgGraphicalWeatherAUUpReg::u16GetServiceID() const {return SXMWEATHERFI_C_U16_SERVICE_ID;}
tU16 sxmweatherfi_tclMsgGraphicalWeatherAUUpReg::u16GetFunctionID() const {return SXMWEATHERFI_C_U16_GRAPHICALWEATHERAU;}
tU8 sxmweatherfi_tclMsgGraphicalWeatherAUUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 sxmweatherfi_tclMsgGraphicalWeatherAUUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxmweatherfi_tclMsgGraphicalWeatherAUUpReg::operator==(const sxmweatherfi_tclMsgGraphicalWeatherAUUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxmweatherfi_tclMsgGraphicalWeatherAUUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxmweatherfi_tclMsgGraphicalWeatherAUUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgGraphicalWeatherAURelUpReg::sxmweatherfi_tclMsgGraphicalWeatherAURelUpReg(const sxmweatherfi_tclMsgGraphicalWeatherAURelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgGraphicalWeatherAURelUpReg& sxmweatherfi_tclMsgGraphicalWeatherAURelUpReg::operator=(const sxmweatherfi_tclMsgGraphicalWeatherAURelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmweatherfi_tclMsgGraphicalWeatherAURelUpReg::u16GetServiceID() const {return SXMWEATHERFI_C_U16_SERVICE_ID;}
tU16 sxmweatherfi_tclMsgGraphicalWeatherAURelUpReg::u16GetFunctionID() const {return SXMWEATHERFI_C_U16_GRAPHICALWEATHERAU;}
tU8 sxmweatherfi_tclMsgGraphicalWeatherAURelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 sxmweatherfi_tclMsgGraphicalWeatherAURelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxmweatherfi_tclMsgGraphicalWeatherAURelUpReg::operator==(const sxmweatherfi_tclMsgGraphicalWeatherAURelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxmweatherfi_tclMsgGraphicalWeatherAURelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxmweatherfi_tclMsgGraphicalWeatherAURelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgGraphicalWeatherAUStatus::sxmweatherfi_tclMsgGraphicalWeatherAUStatus(const sxmweatherfi_tclMsgGraphicalWeatherAUStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   GraphicalAUData = coRef.GraphicalAUData;
   Counter = coRef.Counter;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgGraphicalWeatherAUStatus& sxmweatherfi_tclMsgGraphicalWeatherAUStatus::operator=(const sxmweatherfi_tclMsgGraphicalWeatherAUStatus& coRef)
{
   if (this == &coRef) return *this;
   GraphicalAUData = coRef.GraphicalAUData;
   Counter = coRef.Counter;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmweatherfi_tclMsgGraphicalWeatherAUStatus::u16GetServiceID() const {return SXMWEATHERFI_C_U16_SERVICE_ID;}
tU16 sxmweatherfi_tclMsgGraphicalWeatherAUStatus::u16GetFunctionID() const {return SXMWEATHERFI_C_U16_GRAPHICALWEATHERAU;}
tU8 sxmweatherfi_tclMsgGraphicalWeatherAUStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid sxmweatherfi_tclMsgGraphicalWeatherAUStatus::vDestroy()
{
   GraphicalAUData.clear();
}

tU32 sxmweatherfi_tclMsgGraphicalWeatherAUStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8+GraphicalAUData.size()*1;
}

tBool sxmweatherfi_tclMsgGraphicalWeatherAUStatus::operator==(const sxmweatherfi_tclMsgGraphicalWeatherAUStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (GraphicalAUData.size() == rfoCmp.GraphicalAUData.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < GraphicalAUData.size()); ++u32Idx)
            bResult = bResult && (GraphicalAUData[u32Idx] == rfoCmp.GraphicalAUData[u32Idx]);
      }
      bResult = bResult && (Counter == rfoCmp.Counter);
   return bResult;
}

fi_tclInContext& sxmweatherfi_tclMsgGraphicalWeatherAUStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      GraphicalAUData.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> GraphicalAUData[u32Idx];
      }
   }
   oIn >> Counter;
   return oIn;
}

fi_tclOutContext& sxmweatherfi_tclMsgGraphicalWeatherAUStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)GraphicalAUData.size();
   {
      for (tU32 u32Idx = 0; u32Idx < GraphicalAUData.size(); ++u32Idx)
         oOut << GraphicalAUData[u32Idx];
   }
   oOut << Counter;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgGraphicalWeatherDataUpReg::sxmweatherfi_tclMsgGraphicalWeatherDataUpReg(const sxmweatherfi_tclMsgGraphicalWeatherDataUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgGraphicalWeatherDataUpReg& sxmweatherfi_tclMsgGraphicalWeatherDataUpReg::operator=(const sxmweatherfi_tclMsgGraphicalWeatherDataUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmweatherfi_tclMsgGraphicalWeatherDataUpReg::u16GetServiceID() const {return SXMWEATHERFI_C_U16_SERVICE_ID;}
tU16 sxmweatherfi_tclMsgGraphicalWeatherDataUpReg::u16GetFunctionID() const {return SXMWEATHERFI_C_U16_GRAPHICALWEATHERDATA;}
tU8 sxmweatherfi_tclMsgGraphicalWeatherDataUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 sxmweatherfi_tclMsgGraphicalWeatherDataUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxmweatherfi_tclMsgGraphicalWeatherDataUpReg::operator==(const sxmweatherfi_tclMsgGraphicalWeatherDataUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxmweatherfi_tclMsgGraphicalWeatherDataUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxmweatherfi_tclMsgGraphicalWeatherDataUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgGraphicalWeatherDataRelUpReg::sxmweatherfi_tclMsgGraphicalWeatherDataRelUpReg(const sxmweatherfi_tclMsgGraphicalWeatherDataRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgGraphicalWeatherDataRelUpReg& sxmweatherfi_tclMsgGraphicalWeatherDataRelUpReg::operator=(const sxmweatherfi_tclMsgGraphicalWeatherDataRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmweatherfi_tclMsgGraphicalWeatherDataRelUpReg::u16GetServiceID() const {return SXMWEATHERFI_C_U16_SERVICE_ID;}
tU16 sxmweatherfi_tclMsgGraphicalWeatherDataRelUpReg::u16GetFunctionID() const {return SXMWEATHERFI_C_U16_GRAPHICALWEATHERDATA;}
tU8 sxmweatherfi_tclMsgGraphicalWeatherDataRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 sxmweatherfi_tclMsgGraphicalWeatherDataRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxmweatherfi_tclMsgGraphicalWeatherDataRelUpReg::operator==(const sxmweatherfi_tclMsgGraphicalWeatherDataRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxmweatherfi_tclMsgGraphicalWeatherDataRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxmweatherfi_tclMsgGraphicalWeatherDataRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgGraphicalWeatherDataStatus::sxmweatherfi_tclMsgGraphicalWeatherDataStatus(const sxmweatherfi_tclMsgGraphicalWeatherDataStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   Counter = coRef.Counter;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgGraphicalWeatherDataStatus& sxmweatherfi_tclMsgGraphicalWeatherDataStatus::operator=(const sxmweatherfi_tclMsgGraphicalWeatherDataStatus& coRef)
{
   if (this == &coRef) return *this;
   Counter = coRef.Counter;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmweatherfi_tclMsgGraphicalWeatherDataStatus::u16GetServiceID() const {return SXMWEATHERFI_C_U16_SERVICE_ID;}
tU16 sxmweatherfi_tclMsgGraphicalWeatherDataStatus::u16GetFunctionID() const {return SXMWEATHERFI_C_U16_GRAPHICALWEATHERDATA;}
tU8 sxmweatherfi_tclMsgGraphicalWeatherDataStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 sxmweatherfi_tclMsgGraphicalWeatherDataStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

tBool sxmweatherfi_tclMsgGraphicalWeatherDataStatus::operator==(const sxmweatherfi_tclMsgGraphicalWeatherDataStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (Counter == rfoCmp.Counter);
   return bResult;
}

fi_tclInContext& sxmweatherfi_tclMsgGraphicalWeatherDataStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> Counter;
   return oIn;
}

fi_tclOutContext& sxmweatherfi_tclMsgGraphicalWeatherDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << Counter;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgGraphicalWeatherAuthInfoUpReg::sxmweatherfi_tclMsgGraphicalWeatherAuthInfoUpReg(const sxmweatherfi_tclMsgGraphicalWeatherAuthInfoUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgGraphicalWeatherAuthInfoUpReg& sxmweatherfi_tclMsgGraphicalWeatherAuthInfoUpReg::operator=(const sxmweatherfi_tclMsgGraphicalWeatherAuthInfoUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmweatherfi_tclMsgGraphicalWeatherAuthInfoUpReg::u16GetServiceID() const {return SXMWEATHERFI_C_U16_SERVICE_ID;}
tU16 sxmweatherfi_tclMsgGraphicalWeatherAuthInfoUpReg::u16GetFunctionID() const {return SXMWEATHERFI_C_U16_GRAPHICALWEATHERAUTHINFO;}
tU8 sxmweatherfi_tclMsgGraphicalWeatherAuthInfoUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 sxmweatherfi_tclMsgGraphicalWeatherAuthInfoUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxmweatherfi_tclMsgGraphicalWeatherAuthInfoUpReg::operator==(const sxmweatherfi_tclMsgGraphicalWeatherAuthInfoUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxmweatherfi_tclMsgGraphicalWeatherAuthInfoUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxmweatherfi_tclMsgGraphicalWeatherAuthInfoUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgGraphicalWeatherAuthInfoRelUpReg::sxmweatherfi_tclMsgGraphicalWeatherAuthInfoRelUpReg(const sxmweatherfi_tclMsgGraphicalWeatherAuthInfoRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgGraphicalWeatherAuthInfoRelUpReg& sxmweatherfi_tclMsgGraphicalWeatherAuthInfoRelUpReg::operator=(const sxmweatherfi_tclMsgGraphicalWeatherAuthInfoRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmweatherfi_tclMsgGraphicalWeatherAuthInfoRelUpReg::u16GetServiceID() const {return SXMWEATHERFI_C_U16_SERVICE_ID;}
tU16 sxmweatherfi_tclMsgGraphicalWeatherAuthInfoRelUpReg::u16GetFunctionID() const {return SXMWEATHERFI_C_U16_GRAPHICALWEATHERAUTHINFO;}
tU8 sxmweatherfi_tclMsgGraphicalWeatherAuthInfoRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 sxmweatherfi_tclMsgGraphicalWeatherAuthInfoRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxmweatherfi_tclMsgGraphicalWeatherAuthInfoRelUpReg::operator==(const sxmweatherfi_tclMsgGraphicalWeatherAuthInfoRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxmweatherfi_tclMsgGraphicalWeatherAuthInfoRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxmweatherfi_tclMsgGraphicalWeatherAuthInfoRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgGraphicalWeatherAuthInfoGet::sxmweatherfi_tclMsgGraphicalWeatherAuthInfoGet(const sxmweatherfi_tclMsgGraphicalWeatherAuthInfoGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgGraphicalWeatherAuthInfoGet& sxmweatherfi_tclMsgGraphicalWeatherAuthInfoGet::operator=(const sxmweatherfi_tclMsgGraphicalWeatherAuthInfoGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmweatherfi_tclMsgGraphicalWeatherAuthInfoGet::u16GetServiceID() const {return SXMWEATHERFI_C_U16_SERVICE_ID;}
tU16 sxmweatherfi_tclMsgGraphicalWeatherAuthInfoGet::u16GetFunctionID() const {return SXMWEATHERFI_C_U16_GRAPHICALWEATHERAUTHINFO;}
tU8 sxmweatherfi_tclMsgGraphicalWeatherAuthInfoGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 sxmweatherfi_tclMsgGraphicalWeatherAuthInfoGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxmweatherfi_tclMsgGraphicalWeatherAuthInfoGet::operator==(const sxmweatherfi_tclMsgGraphicalWeatherAuthInfoGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxmweatherfi_tclMsgGraphicalWeatherAuthInfoGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxmweatherfi_tclMsgGraphicalWeatherAuthInfoGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgGraphicalWeatherAuthInfoStatus::sxmweatherfi_tclMsgGraphicalWeatherAuthInfoStatus(const sxmweatherfi_tclMsgGraphicalWeatherAuthInfoStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   GraphicalWeatherAuthStatus = coRef.GraphicalWeatherAuthStatus;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgGraphicalWeatherAuthInfoStatus& sxmweatherfi_tclMsgGraphicalWeatherAuthInfoStatus::operator=(const sxmweatherfi_tclMsgGraphicalWeatherAuthInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   GraphicalWeatherAuthStatus = coRef.GraphicalWeatherAuthStatus;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmweatherfi_tclMsgGraphicalWeatherAuthInfoStatus::u16GetServiceID() const {return SXMWEATHERFI_C_U16_SERVICE_ID;}
tU16 sxmweatherfi_tclMsgGraphicalWeatherAuthInfoStatus::u16GetFunctionID() const {return SXMWEATHERFI_C_U16_GRAPHICALWEATHERAUTHINFO;}
tU8 sxmweatherfi_tclMsgGraphicalWeatherAuthInfoStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 sxmweatherfi_tclMsgGraphicalWeatherAuthInfoStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool sxmweatherfi_tclMsgGraphicalWeatherAuthInfoStatus::operator==(const sxmweatherfi_tclMsgGraphicalWeatherAuthInfoStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (GraphicalWeatherAuthStatus == rfoCmp.GraphicalWeatherAuthStatus);
   return bResult;
}

fi_tclInContext& sxmweatherfi_tclMsgGraphicalWeatherAuthInfoStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> GraphicalWeatherAuthStatus;
   return oIn;
}

fi_tclOutContext& sxmweatherfi_tclMsgGraphicalWeatherAuthInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << GraphicalWeatherAuthStatus;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgWeatherAlertsAUUpReg::sxmweatherfi_tclMsgWeatherAlertsAUUpReg(const sxmweatherfi_tclMsgWeatherAlertsAUUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgWeatherAlertsAUUpReg& sxmweatherfi_tclMsgWeatherAlertsAUUpReg::operator=(const sxmweatherfi_tclMsgWeatherAlertsAUUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmweatherfi_tclMsgWeatherAlertsAUUpReg::u16GetServiceID() const {return SXMWEATHERFI_C_U16_SERVICE_ID;}
tU16 sxmweatherfi_tclMsgWeatherAlertsAUUpReg::u16GetFunctionID() const {return SXMWEATHERFI_C_U16_WEATHERALERTSAU;}
tU8 sxmweatherfi_tclMsgWeatherAlertsAUUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 sxmweatherfi_tclMsgWeatherAlertsAUUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxmweatherfi_tclMsgWeatherAlertsAUUpReg::operator==(const sxmweatherfi_tclMsgWeatherAlertsAUUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxmweatherfi_tclMsgWeatherAlertsAUUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxmweatherfi_tclMsgWeatherAlertsAUUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgWeatherAlertsAURelUpReg::sxmweatherfi_tclMsgWeatherAlertsAURelUpReg(const sxmweatherfi_tclMsgWeatherAlertsAURelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgWeatherAlertsAURelUpReg& sxmweatherfi_tclMsgWeatherAlertsAURelUpReg::operator=(const sxmweatherfi_tclMsgWeatherAlertsAURelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmweatherfi_tclMsgWeatherAlertsAURelUpReg::u16GetServiceID() const {return SXMWEATHERFI_C_U16_SERVICE_ID;}
tU16 sxmweatherfi_tclMsgWeatherAlertsAURelUpReg::u16GetFunctionID() const {return SXMWEATHERFI_C_U16_WEATHERALERTSAU;}
tU8 sxmweatherfi_tclMsgWeatherAlertsAURelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 sxmweatherfi_tclMsgWeatherAlertsAURelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxmweatherfi_tclMsgWeatherAlertsAURelUpReg::operator==(const sxmweatherfi_tclMsgWeatherAlertsAURelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxmweatherfi_tclMsgWeatherAlertsAURelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxmweatherfi_tclMsgWeatherAlertsAURelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgWeatherAlertsAUStatus::sxmweatherfi_tclMsgWeatherAlertsAUStatus(const sxmweatherfi_tclMsgWeatherAlertsAUStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   WeatherAlertsAUData = coRef.WeatherAlertsAUData;
   AlertPrio = coRef.AlertPrio;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgWeatherAlertsAUStatus& sxmweatherfi_tclMsgWeatherAlertsAUStatus::operator=(const sxmweatherfi_tclMsgWeatherAlertsAUStatus& coRef)
{
   if (this == &coRef) return *this;
   WeatherAlertsAUData = coRef.WeatherAlertsAUData;
   AlertPrio = coRef.AlertPrio;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmweatherfi_tclMsgWeatherAlertsAUStatus::u16GetServiceID() const {return SXMWEATHERFI_C_U16_SERVICE_ID;}
tU16 sxmweatherfi_tclMsgWeatherAlertsAUStatus::u16GetFunctionID() const {return SXMWEATHERFI_C_U16_WEATHERALERTSAU;}
tU8 sxmweatherfi_tclMsgWeatherAlertsAUStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tVoid sxmweatherfi_tclMsgWeatherAlertsAUStatus::vDestroy()
{
   WeatherAlertsAUData.clear();
}

tU32 sxmweatherfi_tclMsgWeatherAlertsAUStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5+WeatherAlertsAUData.size()*1;
}

tBool sxmweatherfi_tclMsgWeatherAlertsAUStatus::operator==(const sxmweatherfi_tclMsgWeatherAlertsAUStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (WeatherAlertsAUData.size() == rfoCmp.WeatherAlertsAUData.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < WeatherAlertsAUData.size()); ++u32Idx)
            bResult = bResult && (WeatherAlertsAUData[u32Idx] == rfoCmp.WeatherAlertsAUData[u32Idx]);
      }
      bResult = bResult && (AlertPrio == rfoCmp.AlertPrio);
   return bResult;
}

fi_tclInContext& sxmweatherfi_tclMsgWeatherAlertsAUStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      oIn >> u32Length;
      WeatherAlertsAUData.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         oIn >> WeatherAlertsAUData[u32Idx];
      }
   }
   oIn >> AlertPrio;
   return oIn;
}

fi_tclOutContext& sxmweatherfi_tclMsgWeatherAlertsAUStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << (tU32)WeatherAlertsAUData.size();
   {
      for (tU32 u32Idx = 0; u32Idx < WeatherAlertsAUData.size(); ++u32Idx)
         oOut << WeatherAlertsAUData[u32Idx];
   }
   oOut << AlertPrio;
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgWeatherAlertsAuthInfoUpReg::sxmweatherfi_tclMsgWeatherAlertsAuthInfoUpReg(const sxmweatherfi_tclMsgWeatherAlertsAuthInfoUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgWeatherAlertsAuthInfoUpReg& sxmweatherfi_tclMsgWeatherAlertsAuthInfoUpReg::operator=(const sxmweatherfi_tclMsgWeatherAlertsAuthInfoUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmweatherfi_tclMsgWeatherAlertsAuthInfoUpReg::u16GetServiceID() const {return SXMWEATHERFI_C_U16_SERVICE_ID;}
tU16 sxmweatherfi_tclMsgWeatherAlertsAuthInfoUpReg::u16GetFunctionID() const {return SXMWEATHERFI_C_U16_WEATHERALERTSAUTHINFO;}
tU8 sxmweatherfi_tclMsgWeatherAlertsAuthInfoUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_UPREG;}

tU32 sxmweatherfi_tclMsgWeatherAlertsAuthInfoUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxmweatherfi_tclMsgWeatherAlertsAuthInfoUpReg::operator==(const sxmweatherfi_tclMsgWeatherAlertsAuthInfoUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxmweatherfi_tclMsgWeatherAlertsAuthInfoUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxmweatherfi_tclMsgWeatherAlertsAuthInfoUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgWeatherAlertsAuthInfoRelUpReg::sxmweatherfi_tclMsgWeatherAlertsAuthInfoRelUpReg(const sxmweatherfi_tclMsgWeatherAlertsAuthInfoRelUpReg& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgWeatherAlertsAuthInfoRelUpReg& sxmweatherfi_tclMsgWeatherAlertsAuthInfoRelUpReg::operator=(const sxmweatherfi_tclMsgWeatherAlertsAuthInfoRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmweatherfi_tclMsgWeatherAlertsAuthInfoRelUpReg::u16GetServiceID() const {return SXMWEATHERFI_C_U16_SERVICE_ID;}
tU16 sxmweatherfi_tclMsgWeatherAlertsAuthInfoRelUpReg::u16GetFunctionID() const {return SXMWEATHERFI_C_U16_WEATHERALERTSAUTHINFO;}
tU8 sxmweatherfi_tclMsgWeatherAlertsAuthInfoRelUpReg::u8GetOpCode() const {return CCA_C_U8_OPCODE_RELUPREG;}

tU32 sxmweatherfi_tclMsgWeatherAlertsAuthInfoRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxmweatherfi_tclMsgWeatherAlertsAuthInfoRelUpReg::operator==(const sxmweatherfi_tclMsgWeatherAlertsAuthInfoRelUpReg& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxmweatherfi_tclMsgWeatherAlertsAuthInfoRelUpReg::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxmweatherfi_tclMsgWeatherAlertsAuthInfoRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgWeatherAlertsAuthInfoGet::sxmweatherfi_tclMsgWeatherAlertsAuthInfoGet(const sxmweatherfi_tclMsgWeatherAlertsAuthInfoGet& coRef):fi_tclVisitableTypeBase(coRef)
{
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgWeatherAlertsAuthInfoGet& sxmweatherfi_tclMsgWeatherAlertsAuthInfoGet::operator=(const sxmweatherfi_tclMsgWeatherAlertsAuthInfoGet& coRef)
{
   if (this == &coRef) return *this;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmweatherfi_tclMsgWeatherAlertsAuthInfoGet::u16GetServiceID() const {return SXMWEATHERFI_C_U16_SERVICE_ID;}
tU16 sxmweatherfi_tclMsgWeatherAlertsAuthInfoGet::u16GetFunctionID() const {return SXMWEATHERFI_C_U16_WEATHERALERTSAUTHINFO;}
tU8 sxmweatherfi_tclMsgWeatherAlertsAuthInfoGet::u8GetOpCode() const {return CCA_C_U8_OPCODE_GET;}

tU32 sxmweatherfi_tclMsgWeatherAlertsAuthInfoGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

tBool sxmweatherfi_tclMsgWeatherAlertsAuthInfoGet::operator==(const sxmweatherfi_tclMsgWeatherAlertsAuthInfoGet& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

fi_tclInContext& sxmweatherfi_tclMsgWeatherAlertsAuthInfoGet::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sxmweatherfi_tclMsgWeatherAlertsAuthInfoGet::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgWeatherAlertsAuthInfoStatus::sxmweatherfi_tclMsgWeatherAlertsAuthInfoStatus(const sxmweatherfi_tclMsgWeatherAlertsAuthInfoStatus& coRef):fi_tclVisitableTypeBase(coRef)
{
   WeatherAlertsAuthStatus = coRef.WeatherAlertsAuthStatus;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sxmweatherfi_tclMsgWeatherAlertsAuthInfoStatus& sxmweatherfi_tclMsgWeatherAlertsAuthInfoStatus::operator=(const sxmweatherfi_tclMsgWeatherAlertsAuthInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   WeatherAlertsAuthStatus = coRef.WeatherAlertsAuthStatus;
   return *this;
}

#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
tU16 sxmweatherfi_tclMsgWeatherAlertsAuthInfoStatus::u16GetServiceID() const {return SXMWEATHERFI_C_U16_SERVICE_ID;}
tU16 sxmweatherfi_tclMsgWeatherAlertsAuthInfoStatus::u16GetFunctionID() const {return SXMWEATHERFI_C_U16_WEATHERALERTSAUTHINFO;}
tU8 sxmweatherfi_tclMsgWeatherAlertsAuthInfoStatus::u8GetOpCode() const {return CCA_C_U8_OPCODE_STATUS;}

tU32 sxmweatherfi_tclMsgWeatherAlertsAuthInfoStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

tBool sxmweatherfi_tclMsgWeatherAlertsAuthInfoStatus::operator==(const sxmweatherfi_tclMsgWeatherAlertsAuthInfoStatus& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (WeatherAlertsAuthStatus == rfoCmp.WeatherAlertsAuthStatus);
   return bResult;
}

fi_tclInContext& sxmweatherfi_tclMsgWeatherAlertsAuthInfoStatus::oRead(fi_tclInContext& oIn)
{
   oIn >> WeatherAlertsAuthStatus;
   return oIn;
}

fi_tclOutContext& sxmweatherfi_tclMsgWeatherAlertsAuthInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   oOut << WeatherAlertsAuthStatus;
   return oOut;
}

