#ifndef SXMWEATHERFILANGUAGE_HEADER
#define SXMWEATHERFILANGUAGE_HEADER

class sxmweatherfi_tclInContext;
class sxmweatherfi_tclOutContext;
class sxmweatherfi_tclVisitorBase;

class MY_DECL sxmweatherfi_tclDescription {
 public:
  enum tenType { EN_PARSING, EN_GENERATING };	
  
  sxmweatherfi_tclDescription(fi_tclInContext* poIn, sxmweatherfi_tclVisitorBase* poVisit);
  sxmweatherfi_tclDescription(fi_tclOutContext* poOut, sxmweatherfi_tclVisitorBase* poVisit);
  
  /* --Hier kommen nun die Methoden, die einzelne Nachrichten entspr. NaFI 
		erzeugen (EN_GENERATING) bzw. einlesen (EN_PARSING). */

  tBool bInitMessage(sxmweatherfi_tclToken::tenType enMsgToken);
  tBool bProcessMessage();

  // tBool bProcessElement(); 

  tBool bDoIt(fi_tclVisitableTypeBase& poBaseType);
#ifndef FI_S_EXTERNAL_FI
  void vEnableSpecialBinContainer() { bUseSpecialBinContainer = true; }
#endif

 private:
  /* default constructor */ sxmweatherfi_tclDescription();  //lint !e1704 // always use parameters
  tenType enType; //--read or write?

  union {
    fi_tclInContext* poInContext;
    fi_tclOutContext* poOutContext;
  };

  sxmweatherfi_tclVisitorBase* poVisitor;

  // typedef navifi_tclTraversePath::tclKnot tclKnot;

  tBool bUseSpecialBinContainer;  
  
 public:
  
  // --Traversierungspfad
  fi_tclTraversePath<sxmweatherfi_tclKnot> oPath;
  //   navifi_tclTraversePath oPath;
  fi_tclTraversePath<sxmweatherfi_tclKnot> oCallStack;
   //  navifi_tclTraversePath oCallStack;
  
};

// --Inline-Implementierungen
inline sxmweatherfi_tclDescription::sxmweatherfi_tclDescription(fi_tclInContext* poIn, sxmweatherfi_tclVisitorBase* poVisit):
  enType(EN_PARSING),poInContext(poIn),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

inline sxmweatherfi_tclDescription::sxmweatherfi_tclDescription(fi_tclOutContext* poOut, sxmweatherfi_tclVisitorBase* poVisit):
  enType(EN_GENERATING),poOutContext(poOut),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

#endif

