#include "precompiled.hh"

tBool sxmweatherfi_tclDescription::bInitMessage(sxmweatherfi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case sxmweatherfi_tclToken::EN_LAST_TOKEN:
   case sxmweatherfi_tclToken::EN_LIST:
   case sxmweatherfi_tclToken::EN_END_OF_STRUCT:
   case sxmweatherfi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
   break;
      // include the expansions for the messages
   case sxmweatherfi_tclToken::EN_MSG_TRANSFERUPDATEFILEINFOMETHODSTART:
   {
      bResult &= oPath.bGoDown(sxmweatherfi_tclKnot(sxmweatherfi_tclToken::EN_E8_UPDATETYPE,sxmweatherfi_tclSemanticDomain::EN_MSG_UPDATETYPE));
   } break;
   case sxmweatherfi_tclToken::EN_MSG_TRANSFERUPDATEFILEINFOMETHODRESULT:
   {
      bResult &= oPath.bGoDown(sxmweatherfi_tclKnot(sxmweatherfi_tclToken::EN_STRING,sxmweatherfi_tclSemanticDomain::EN_MSG_UPDATEFILENAME));
      bResult &= oPath.bGoDown(sxmweatherfi_tclKnot(sxmweatherfi_tclToken::EN_E8_UPDATETYPE,sxmweatherfi_tclSemanticDomain::EN_MSG_UPDATETYPE));
   } break;
   case sxmweatherfi_tclToken::EN_MSG_RELEASEUPDATEFILEMETHODSTART:
   {
      bResult &= oPath.bGoDown(sxmweatherfi_tclKnot(sxmweatherfi_tclToken::EN_E8_UPDATETYPE,sxmweatherfi_tclSemanticDomain::EN_MSG_UPDATETYPE));
   } break;
   case sxmweatherfi_tclToken::EN_MSG_RELEASEUPDATEFILEMETHODRESULT:
   {
      bResult &= oPath.bGoDown(sxmweatherfi_tclKnot(sxmweatherfi_tclToken::EN_E8_UPDATETYPE,sxmweatherfi_tclSemanticDomain::EN_MSG_UPDATETYPE));
   } break;
   case sxmweatherfi_tclToken::EN_MSG_XCHNGECAPABILITIESMETHODSTART:
   {
      bResult &= oPath.bGoDown(sxmweatherfi_tclKnot(sxmweatherfi_tclToken::EN_CAPABILITIES,sxmweatherfi_tclSemanticDomain::EN_MSG_WEATHERCAPABILITIES));
   } break;
   case sxmweatherfi_tclToken::EN_MSG_XCHNGECAPABILITIESMETHODRESULT:
   {
      bResult &= oPath.bGoDown(sxmweatherfi_tclKnot(sxmweatherfi_tclToken::EN_GRAPHICALINFO,sxmweatherfi_tclSemanticDomain::EN_MSG_GRAPHICALWEATHERINFO));
      bResult &= oPath.bGoDown(sxmweatherfi_tclKnot(sxmweatherfi_tclToken::EN_CAPABILITIES,sxmweatherfi_tclSemanticDomain::EN_MSG_SUPPORTEDCAPABILITIES));
   } break;
   case sxmweatherfi_tclToken::EN_MSG_ACQUIREGRAPHICALAUMETHODRESULT:
   {
      bResult &= oPath.bGoDown(sxmweatherfi_tclKnot(sxmweatherfi_tclToken::EN_AU_INDEX,sxmweatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(sxmweatherfi_tclKnot(sxmweatherfi_tclToken::EN_LIST,sxmweatherfi_tclSemanticDomain::EN_MSG_INDEXLIST));
   } break;
   case sxmweatherfi_tclToken::EN_MSG_TABWEATHERAUTHINFOSTATUS:
   {
      bResult &= oPath.bGoDown(sxmweatherfi_tclKnot(sxmweatherfi_tclToken::EN_E8_AUTHORIZATIONSTATUS,sxmweatherfi_tclSemanticDomain::EN_MSG_TABWEATHERAUTHSTATUS));
   } break;
   case sxmweatherfi_tclToken::EN_MSG_SXMSIGNALINFOSTATUS:
   {
      bResult &= oPath.bGoDown(sxmweatherfi_tclKnot(sxmweatherfi_tclToken::EN_E8_SIGNALSTATUS,sxmweatherfi_tclSemanticDomain::EN_MSG_SXMSIGNALSTATUS));
   } break;
   case sxmweatherfi_tclToken::EN_MSG_NEWUPDATEFILEAVAILABLESTATUS:
   {
      bResult &= oPath.bGoDown(sxmweatherfi_tclKnot(sxmweatherfi_tclToken::EN_E8_UPDATETYPE,sxmweatherfi_tclSemanticDomain::EN_MSG_UPDATETYPE));
   } break;
   case sxmweatherfi_tclToken::EN_MSG_TABWEATHERDATASTATUS:
   {
      bResult &= oPath.bGoDown(sxmweatherfi_tclKnot(sxmweatherfi_tclToken::EN_U8,sxmweatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(sxmweatherfi_tclKnot(sxmweatherfi_tclToken::EN_LIST,sxmweatherfi_tclSemanticDomain::EN_MSG_ACCESSUNITDATA));
      bResult &= oPath.bGoDown(sxmweatherfi_tclKnot(sxmweatherfi_tclToken::EN_U32,sxmweatherfi_tclSemanticDomain::EN_MSG_ACCESSUNITSIZE));
   } break;
   case sxmweatherfi_tclToken::EN_MSG_GRAPHICALWEATHERAUSTATUS:
   {
      bResult &= oPath.bGoDown(sxmweatherfi_tclKnot(sxmweatherfi_tclToken::EN_U32,sxmweatherfi_tclSemanticDomain::EN_MSG_COUNTER));
      bResult &= oPath.bGoDown(sxmweatherfi_tclKnot(sxmweatherfi_tclToken::EN_U8,sxmweatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(sxmweatherfi_tclKnot(sxmweatherfi_tclToken::EN_LIST,sxmweatherfi_tclSemanticDomain::EN_MSG_GRAPHICALAUDATA));
   } break;
   case sxmweatherfi_tclToken::EN_MSG_GRAPHICALWEATHERDATASTATUS:
   {
      bResult &= oPath.bGoDown(sxmweatherfi_tclKnot(sxmweatherfi_tclToken::EN_U32,sxmweatherfi_tclSemanticDomain::EN_MSG_COUNTER));
   } break;
   case sxmweatherfi_tclToken::EN_MSG_GRAPHICALWEATHERAUTHINFOSTATUS:
   {
      bResult &= oPath.bGoDown(sxmweatherfi_tclKnot(sxmweatherfi_tclToken::EN_E8_AUTHORIZATIONSTATUS,sxmweatherfi_tclSemanticDomain::EN_MSG_GRAPHICALWEATHERAUTHSTATUS));
   } break;
   case sxmweatherfi_tclToken::EN_MSG_WEATHERALERTSAUSTATUS:
   {
      bResult &= oPath.bGoDown(sxmweatherfi_tclKnot(sxmweatherfi_tclToken::EN_E8_ALERTPRIO,sxmweatherfi_tclSemanticDomain::EN_MSG_ALERTPRIO));
      bResult &= oPath.bGoDown(sxmweatherfi_tclKnot(sxmweatherfi_tclToken::EN_U8,sxmweatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(sxmweatherfi_tclKnot(sxmweatherfi_tclToken::EN_LIST,sxmweatherfi_tclSemanticDomain::EN_MSG_WEATHERALERTSAUDATA));
   } break;
   case sxmweatherfi_tclToken::EN_MSG_WEATHERALERTSAUTHINFOSTATUS:
   {
      bResult &= oPath.bGoDown(sxmweatherfi_tclKnot(sxmweatherfi_tclToken::EN_E8_AUTHORIZATIONSTATUS,sxmweatherfi_tclSemanticDomain::EN_MSG_WEATHERALERTSAUTHSTATUS));
   } break;
   case sxmweatherfi_tclToken::EN_BINCONTAINER:
   case sxmweatherfi_tclToken::EN_E8_AUTHORIZATIONSTATUS:
   case sxmweatherfi_tclToken::EN_E8_SIGNALSTATUS:
   case sxmweatherfi_tclToken::EN_E8_UPDATETYPE:
   case sxmweatherfi_tclToken::EN_E8_ALERTPRIO:
   case sxmweatherfi_tclToken::EN_CAPABILITIES:
   case sxmweatherfi_tclToken::EN_AU_INDEX:
   case sxmweatherfi_tclToken::EN_GRAPHICALINFO:
   case sxmweatherfi_tclToken::EN_U8:   
   case sxmweatherfi_tclToken::EN_S8:   
   case sxmweatherfi_tclToken::EN_U16:   
   case sxmweatherfi_tclToken::EN_S16:   
   case sxmweatherfi_tclToken::EN_U24:   
   case sxmweatherfi_tclToken::EN_S24:   
   case sxmweatherfi_tclToken::EN_U32:   
   case sxmweatherfi_tclToken::EN_S32:   
   case sxmweatherfi_tclToken::EN_U64:   
   case sxmweatherfi_tclToken::EN_S64:   
   case sxmweatherfi_tclToken::EN_F32:   
   case sxmweatherfi_tclToken::EN_F64:   
   case sxmweatherfi_tclToken::EN_BOOL:   
   case sxmweatherfi_tclToken::EN_STRING:   
   case sxmweatherfi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      oPath.bGoDown(sxmweatherfi_tclKnot(enMsgToken,sxmweatherfi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool sxmweatherfi_tclDescription::bDoIt(fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (*poInContext) >> oTypeBase;
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (*poOutContext) << oTypeBase;
   }
   return poVisitor->bIsValid();
}

tBool sxmweatherfi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      sxmweatherfi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      sxmweatherfi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      sxmweatherfi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == sxmweatherfi_tclSemanticDomain::EN_LIST_ELEMENT) {
         oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            oPath.bGoDown(sxmweatherfi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            oPath.bGoDown(sxmweatherfi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            oPath.bGoUp();
            oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      oCallStack.bGoDown(sxmweatherfi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case sxmweatherfi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == sxmweatherfi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         oPath.bGoUp();
         oCallStack.bGoUp();
         oCallStack.bGoUp();
      } break;
      case sxmweatherfi_tclToken::EN_LIST: 
      {
         fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            sxmweatherfi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(sxmweatherfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            sxmweatherfi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(sxmweatherfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
         }
      } break;
      case sxmweatherfi_tclToken::EN_U8: 
      {
         fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case sxmweatherfi_tclToken::EN_U16: 
      {
         fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case sxmweatherfi_tclToken::EN_U24: 
      {
         fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case sxmweatherfi_tclToken::EN_U32: 
      {
         fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case sxmweatherfi_tclToken::EN_U64: 
      {
         fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case sxmweatherfi_tclToken::EN_S8: 
      {
         fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case sxmweatherfi_tclToken::EN_S16: 
      {
         fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case sxmweatherfi_tclToken::EN_S24: 
      {
         fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case sxmweatherfi_tclToken::EN_S32: 
      {
         fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case sxmweatherfi_tclToken::EN_S64: 
      {
         fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case sxmweatherfi_tclToken::EN_F32: 
      {
         fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case sxmweatherfi_tclToken::EN_F64: 
      {
         fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case sxmweatherfi_tclToken::EN_BOOL: 
      {
         fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case sxmweatherfi_tclToken::EN_STRING: 
      {
         fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case sxmweatherfi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
   case sxmweatherfi_tclToken::EN_MSG_TRANSFERUPDATEFILEINFOMETHODSTART:
   case sxmweatherfi_tclToken::EN_MSG_TRANSFERUPDATEFILEINFOMETHODRESULT:
   case sxmweatherfi_tclToken::EN_MSG_RELEASEUPDATEFILEMETHODSTART:
   case sxmweatherfi_tclToken::EN_MSG_RELEASEUPDATEFILEMETHODRESULT:
   case sxmweatherfi_tclToken::EN_MSG_XCHNGECAPABILITIESMETHODSTART:
   case sxmweatherfi_tclToken::EN_MSG_XCHNGECAPABILITIESMETHODRESULT:
   case sxmweatherfi_tclToken::EN_MSG_ACQUIREGRAPHICALAUMETHODSTART:
   case sxmweatherfi_tclToken::EN_MSG_ACQUIREGRAPHICALAUMETHODRESULT:
   case sxmweatherfi_tclToken::EN_MSG_RELEASEGRAPHICALAUMETHODSTART:
   case sxmweatherfi_tclToken::EN_MSG_RELEASEGRAPHICALAUMETHODRESULT:
   case sxmweatherfi_tclToken::EN_MSG_TABWEATHERAUTHINFOUPREG:
   case sxmweatherfi_tclToken::EN_MSG_TABWEATHERAUTHINFORELUPREG:
   case sxmweatherfi_tclToken::EN_MSG_TABWEATHERAUTHINFOGET:
   case sxmweatherfi_tclToken::EN_MSG_TABWEATHERAUTHINFOSTATUS:
   case sxmweatherfi_tclToken::EN_MSG_SXMSIGNALINFOUPREG:
   case sxmweatherfi_tclToken::EN_MSG_SXMSIGNALINFORELUPREG:
   case sxmweatherfi_tclToken::EN_MSG_SXMSIGNALINFOGET:
   case sxmweatherfi_tclToken::EN_MSG_SXMSIGNALINFOSTATUS:
   case sxmweatherfi_tclToken::EN_MSG_NEWUPDATEFILEAVAILABLEUPREG:
   case sxmweatherfi_tclToken::EN_MSG_NEWUPDATEFILEAVAILABLERELUPREG:
   case sxmweatherfi_tclToken::EN_MSG_NEWUPDATEFILEAVAILABLESTATUS:
   case sxmweatherfi_tclToken::EN_MSG_TABWEATHERDATAUPREG:
   case sxmweatherfi_tclToken::EN_MSG_TABWEATHERDATARELUPREG:
   case sxmweatherfi_tclToken::EN_MSG_TABWEATHERDATASTATUS:
   case sxmweatherfi_tclToken::EN_MSG_GRAPHICALWEATHERAUUPREG:
   case sxmweatherfi_tclToken::EN_MSG_GRAPHICALWEATHERAURELUPREG:
   case sxmweatherfi_tclToken::EN_MSG_GRAPHICALWEATHERAUSTATUS:
   case sxmweatherfi_tclToken::EN_MSG_GRAPHICALWEATHERDATAUPREG:
   case sxmweatherfi_tclToken::EN_MSG_GRAPHICALWEATHERDATARELUPREG:
   case sxmweatherfi_tclToken::EN_MSG_GRAPHICALWEATHERDATASTATUS:
   case sxmweatherfi_tclToken::EN_MSG_GRAPHICALWEATHERAUTHINFOUPREG:
   case sxmweatherfi_tclToken::EN_MSG_GRAPHICALWEATHERAUTHINFORELUPREG:
   case sxmweatherfi_tclToken::EN_MSG_GRAPHICALWEATHERAUTHINFOGET:
   case sxmweatherfi_tclToken::EN_MSG_GRAPHICALWEATHERAUTHINFOSTATUS:
   case sxmweatherfi_tclToken::EN_MSG_WEATHERALERTSAUUPREG:
   case sxmweatherfi_tclToken::EN_MSG_WEATHERALERTSAURELUPREG:
   case sxmweatherfi_tclToken::EN_MSG_WEATHERALERTSAUSTATUS:
   case sxmweatherfi_tclToken::EN_MSG_WEATHERALERTSAUTHINFOUPREG:
   case sxmweatherfi_tclToken::EN_MSG_WEATHERALERTSAUTHINFORELUPREG:
   case sxmweatherfi_tclToken::EN_MSG_WEATHERALERTSAUTHINFOGET:
   case sxmweatherfi_tclToken::EN_MSG_WEATHERALERTSAUTHINFOSTATUS:
      bInitMessage(enToken);
      break;
   case sxmweatherfi_tclToken::EN_BINCONTAINER:
   {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(sxmweatherfi_tclKnot(sxmweatherfi_tclToken::EN_END_OF_STRUCT,sxmweatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(sxmweatherfi_tclKnot(sxmweatherfi_tclToken::EN_U8,sxmweatherfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(sxmweatherfi_tclKnot(sxmweatherfi_tclToken::EN_LIST,sxmweatherfi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case sxmweatherfi_tclToken::EN_E8_AUTHORIZATIONSTATUS:
   {
      fi_tcl_e8_AuthorizationStatus o_e8_AuthorizationStatus;
      if (!bDoIt(o_e8_AuthorizationStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case sxmweatherfi_tclToken::EN_E8_SIGNALSTATUS:
   {
      fi_tcl_e8_SignalStatus o_e8_SignalStatus;
      if (!bDoIt(o_e8_SignalStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case sxmweatherfi_tclToken::EN_E8_UPDATETYPE:
   {
      fi_tcl_e8_UpdateType o_e8_UpdateType;
      if (!bDoIt(o_e8_UpdateType))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case sxmweatherfi_tclToken::EN_E8_ALERTPRIO:
   {
      fi_tcl_e8_AlertPrio o_e8_AlertPrio;
      if (!bDoIt(o_e8_AlertPrio))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case sxmweatherfi_tclToken::EN_CAPABILITIES:
   {
      if (poVisitor->bDoExpand_Capabilities(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(sxmweatherfi_tclKnot(sxmweatherfi_tclToken::EN_END_OF_STRUCT,sxmweatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(sxmweatherfi_tclKnot(sxmweatherfi_tclToken::EN_U32,sxmweatherfi_tclSemanticDomain::EN_U32TIMEOUT));
         oPath.bGoDown(sxmweatherfi_tclKnot(sxmweatherfi_tclToken::EN_STRING,sxmweatherfi_tclSemanticDomain::EN_U8EXCHANGEDIR));
         oPath.bGoDown(sxmweatherfi_tclKnot(sxmweatherfi_tclToken::EN_U16,sxmweatherfi_tclSemanticDomain::EN_U16WEATHERALERTSDBVER));
         oPath.bGoDown(sxmweatherfi_tclKnot(sxmweatherfi_tclToken::EN_U16,sxmweatherfi_tclSemanticDomain::EN_U16WEATHERLOCNDBVER));
         oPath.bGoDown(sxmweatherfi_tclKnot(sxmweatherfi_tclToken::EN_BOOL,sxmweatherfi_tclSemanticDomain::EN_BSKIDATA));
      }
      else
      {
         fi_tcl_Capabilities o_Capabilities;
         if (!bDoIt(o_Capabilities))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_Capabilities.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_Capabilities.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case sxmweatherfi_tclToken::EN_AU_INDEX:
   {
      if (poVisitor->bDoExpand_AU_Index(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(sxmweatherfi_tclKnot(sxmweatherfi_tclToken::EN_END_OF_STRUCT,sxmweatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(sxmweatherfi_tclKnot(sxmweatherfi_tclToken::EN_U32,sxmweatherfi_tclSemanticDomain::EN_U32SIZEAU));
         oPath.bGoDown(sxmweatherfi_tclKnot(sxmweatherfi_tclToken::EN_U32,sxmweatherfi_tclSemanticDomain::EN_U32ADDROFFSET));
      }
      else
      {
         fi_tcl_AU_Index o_AU_Index;
         if (!bDoIt(o_AU_Index))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AU_Index.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_AU_Index.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case sxmweatherfi_tclToken::EN_GRAPHICALINFO:
   {
      if (poVisitor->bDoExpand_GraphicalInfo(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(sxmweatherfi_tclKnot(sxmweatherfi_tclToken::EN_END_OF_STRUCT,sxmweatherfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(sxmweatherfi_tclKnot(sxmweatherfi_tclToken::EN_U32,sxmweatherfi_tclSemanticDomain::EN_U32SHMEMSIZE));
         oPath.bGoDown(sxmweatherfi_tclKnot(sxmweatherfi_tclToken::EN_STRING,sxmweatherfi_tclSemanticDomain::EN_SZSHMEMNAME));
      }
      else
      {
         fi_tcl_GraphicalInfo o_GraphicalInfo;
         if (!bDoIt(o_GraphicalInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_GraphicalInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_GraphicalInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
      case sxmweatherfi_tclToken::EN_UNKNOWN:
      case sxmweatherfi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
  }
  return bResult;
}

