#ifndef SXMMOVIEFILANGUAGE_HEADER
#define SXMMOVIEFILANGUAGE_HEADER

class sxmmoviefi_tclInContext;
class sxmmoviefi_tclOutContext;
class sxmmoviefi_tclVisitorBase;

class MY_DECL sxmmoviefi_tclDescription {
 public:
  enum tenType { EN_PARSING, EN_GENERATING };	
  
  sxmmoviefi_tclDescription(fi_tclInContext* poIn, sxmmoviefi_tclVisitorBase* poVisit);
  sxmmoviefi_tclDescription(fi_tclOutContext* poOut, sxmmoviefi_tclVisitorBase* poVisit);
  
  /* --Hier kommen nun die Methoden, die einzelne Nachrichten entspr. NaFI 
		erzeugen (EN_GENERATING) bzw. einlesen (EN_PARSING). */

  tBool bInitMessage(sxmmoviefi_tclToken::tenType enMsgToken);
  tBool bProcessMessage();

  // tBool bProcessElement(); 

  tBool bDoIt(fi_tclVisitableTypeBase& poBaseType);
#ifndef FI_S_EXTERNAL_FI
  void vEnableSpecialBinContainer() { bUseSpecialBinContainer = true; }
#endif

 private:
  /* default constructor */ sxmmoviefi_tclDescription();  //lint !e1704 // always use parameters
  tenType enType; //--read or write?

  union {
    fi_tclInContext* poInContext;
    fi_tclOutContext* poOutContext;
  };

  sxmmoviefi_tclVisitorBase* poVisitor;

  // typedef navifi_tclTraversePath::tclKnot tclKnot;

  tBool bUseSpecialBinContainer;  
  
 public:
  
  // --Traversierungspfad
  fi_tclTraversePath<sxmmoviefi_tclKnot> oPath;
  //   navifi_tclTraversePath oPath;
  fi_tclTraversePath<sxmmoviefi_tclKnot> oCallStack;
   //  navifi_tclTraversePath oCallStack;
  
};

// --Inline-Implementierungen
inline sxmmoviefi_tclDescription::sxmmoviefi_tclDescription(fi_tclInContext* poIn, sxmmoviefi_tclVisitorBase* poVisit):
  enType(EN_PARSING),poInContext(poIn),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

inline sxmmoviefi_tclDescription::sxmmoviefi_tclDescription(fi_tclOutContext* poOut, sxmmoviefi_tclVisitorBase* poVisit):
  enType(EN_GENERATING),poOutContext(poOut),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

#endif

