/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef SXMFUELFITYPES_HEADER
#define SXMFUELFITYPES_HEADER

// #include <vector>
// 


class sxmfuelfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

class sxmfuelfi_tclMsgRegionWishListMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmfuelfi_tclMsgRegionWishListMethodStart():LocnFilterSwitch(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmfuelfi_tclMsgRegionWishListMethodStart& operator=(const sxmfuelfi_tclMsgRegionWishListMethodStart& coRef);
   sxmfuelfi_tclMsgRegionWishListMethodStart(const sxmfuelfi_tclMsgRegionWishListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tBool LocnFilterSwitch;
   std::vector<tU16, std::allocator<tU16> > ListOfRegions;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmfuelfi_tclMsgRegionWishListMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmfuelfi_tclToken::EN_MSG_REGIONWISHLISTMETHODSTART;}
};

class sxmfuelfi_tclMsgRegionWishListMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmfuelfi_tclMsgRegionWishListMethodResult():FilterAccepted(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmfuelfi_tclMsgRegionWishListMethodResult& operator=(const sxmfuelfi_tclMsgRegionWishListMethodResult& coRef);
   sxmfuelfi_tclMsgRegionWishListMethodResult(const sxmfuelfi_tclMsgRegionWishListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tBool FilterAccepted;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmfuelfi_tclMsgRegionWishListMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmfuelfi_tclToken::EN_MSG_REGIONWISHLISTMETHODRESULT;}
};

class sxmfuelfi_tclMsgTransferFuelPriceDataMethodStart : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmfuelfi_tclMsgTransferFuelPriceDataMethodStart():ClientHighestAvailableUpdateId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmfuelfi_tclMsgTransferFuelPriceDataMethodStart& operator=(const sxmfuelfi_tclMsgTransferFuelPriceDataMethodStart& coRef);
   sxmfuelfi_tclMsgTransferFuelPriceDataMethodStart(const sxmfuelfi_tclMsgTransferFuelPriceDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 ClientHighestAvailableUpdateId;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmfuelfi_tclMsgTransferFuelPriceDataMethodStart& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmfuelfi_tclToken::EN_MSG_TRANSFERFUELPRICEDATAMETHODSTART;}
};

class sxmfuelfi_tclMsgTransferFuelPriceDataMethodResult : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmfuelfi_tclMsgTransferFuelPriceDataMethodResult():ServerHighestAvailableUpdateId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmfuelfi_tclMsgTransferFuelPriceDataMethodResult& operator=(const sxmfuelfi_tclMsgTransferFuelPriceDataMethodResult& coRef);
   sxmfuelfi_tclMsgTransferFuelPriceDataMethodResult(const sxmfuelfi_tclMsgTransferFuelPriceDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 ServerHighestAvailableUpdateId;
   std::vector<fi_tcl_FuelPriceData, std::allocator<fi_tcl_FuelPriceData> > ListOfFuelPriceData;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmfuelfi_tclMsgTransferFuelPriceDataMethodResult& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmfuelfi_tclToken::EN_MSG_TRANSFERFUELPRICEDATAMETHODRESULT;}
};

class sxmfuelfi_tclMsgFuelDataAuthInfoUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmfuelfi_tclMsgFuelDataAuthInfoUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmfuelfi_tclMsgFuelDataAuthInfoUpReg& operator=(const sxmfuelfi_tclMsgFuelDataAuthInfoUpReg& coRef);
   sxmfuelfi_tclMsgFuelDataAuthInfoUpReg(const sxmfuelfi_tclMsgFuelDataAuthInfoUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmfuelfi_tclMsgFuelDataAuthInfoUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmfuelfi_tclToken::EN_MSG_FUELDATAAUTHINFOUPREG;}
};

class sxmfuelfi_tclMsgFuelDataAuthInfoRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmfuelfi_tclMsgFuelDataAuthInfoRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmfuelfi_tclMsgFuelDataAuthInfoRelUpReg& operator=(const sxmfuelfi_tclMsgFuelDataAuthInfoRelUpReg& coRef);
   sxmfuelfi_tclMsgFuelDataAuthInfoRelUpReg(const sxmfuelfi_tclMsgFuelDataAuthInfoRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmfuelfi_tclMsgFuelDataAuthInfoRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmfuelfi_tclToken::EN_MSG_FUELDATAAUTHINFORELUPREG;}
};

class sxmfuelfi_tclMsgFuelDataAuthInfoGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmfuelfi_tclMsgFuelDataAuthInfoGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmfuelfi_tclMsgFuelDataAuthInfoGet& operator=(const sxmfuelfi_tclMsgFuelDataAuthInfoGet& coRef);
   sxmfuelfi_tclMsgFuelDataAuthInfoGet(const sxmfuelfi_tclMsgFuelDataAuthInfoGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmfuelfi_tclMsgFuelDataAuthInfoGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmfuelfi_tclToken::EN_MSG_FUELDATAAUTHINFOGET;}
};

class sxmfuelfi_tclMsgFuelDataAuthInfoStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmfuelfi_tclMsgFuelDataAuthInfoStatus():FuelDataAuthStatus() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmfuelfi_tclMsgFuelDataAuthInfoStatus& operator=(const sxmfuelfi_tclMsgFuelDataAuthInfoStatus& coRef);
   sxmfuelfi_tclMsgFuelDataAuthInfoStatus(const sxmfuelfi_tclMsgFuelDataAuthInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_AuthStatus FuelDataAuthStatus;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmfuelfi_tclMsgFuelDataAuthInfoStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmfuelfi_tclToken::EN_MSG_FUELDATAAUTHINFOSTATUS;}
};

class sxmfuelfi_tclMsgSXMSignalInfoUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmfuelfi_tclMsgSXMSignalInfoUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmfuelfi_tclMsgSXMSignalInfoUpReg& operator=(const sxmfuelfi_tclMsgSXMSignalInfoUpReg& coRef);
   sxmfuelfi_tclMsgSXMSignalInfoUpReg(const sxmfuelfi_tclMsgSXMSignalInfoUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmfuelfi_tclMsgSXMSignalInfoUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmfuelfi_tclToken::EN_MSG_SXMSIGNALINFOUPREG;}
};

class sxmfuelfi_tclMsgSXMSignalInfoRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmfuelfi_tclMsgSXMSignalInfoRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmfuelfi_tclMsgSXMSignalInfoRelUpReg& operator=(const sxmfuelfi_tclMsgSXMSignalInfoRelUpReg& coRef);
   sxmfuelfi_tclMsgSXMSignalInfoRelUpReg(const sxmfuelfi_tclMsgSXMSignalInfoRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmfuelfi_tclMsgSXMSignalInfoRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmfuelfi_tclToken::EN_MSG_SXMSIGNALINFORELUPREG;}
};

class sxmfuelfi_tclMsgSXMSignalInfoGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmfuelfi_tclMsgSXMSignalInfoGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmfuelfi_tclMsgSXMSignalInfoGet& operator=(const sxmfuelfi_tclMsgSXMSignalInfoGet& coRef);
   sxmfuelfi_tclMsgSXMSignalInfoGet(const sxmfuelfi_tclMsgSXMSignalInfoGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmfuelfi_tclMsgSXMSignalInfoGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmfuelfi_tclToken::EN_MSG_SXMSIGNALINFOGET;}
};

class sxmfuelfi_tclMsgSXMSignalInfoStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmfuelfi_tclMsgSXMSignalInfoStatus():SXMSignalStatus() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmfuelfi_tclMsgSXMSignalInfoStatus& operator=(const sxmfuelfi_tclMsgSXMSignalInfoStatus& coRef);
   sxmfuelfi_tclMsgSXMSignalInfoStatus(const sxmfuelfi_tclMsgSXMSignalInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   fi_tcl_e8_SXMSignalStatus SXMSignalStatus;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmfuelfi_tclMsgSXMSignalInfoStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmfuelfi_tclToken::EN_MSG_SXMSIGNALINFOSTATUS;}
};

class sxmfuelfi_tclMsgFuelTypeDataUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmfuelfi_tclMsgFuelTypeDataUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmfuelfi_tclMsgFuelTypeDataUpReg& operator=(const sxmfuelfi_tclMsgFuelTypeDataUpReg& coRef);
   sxmfuelfi_tclMsgFuelTypeDataUpReg(const sxmfuelfi_tclMsgFuelTypeDataUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmfuelfi_tclMsgFuelTypeDataUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmfuelfi_tclToken::EN_MSG_FUELTYPEDATAUPREG;}
};

class sxmfuelfi_tclMsgFuelTypeDataRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmfuelfi_tclMsgFuelTypeDataRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmfuelfi_tclMsgFuelTypeDataRelUpReg& operator=(const sxmfuelfi_tclMsgFuelTypeDataRelUpReg& coRef);
   sxmfuelfi_tclMsgFuelTypeDataRelUpReg(const sxmfuelfi_tclMsgFuelTypeDataRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmfuelfi_tclMsgFuelTypeDataRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmfuelfi_tclToken::EN_MSG_FUELTYPEDATARELUPREG;}
};

class sxmfuelfi_tclMsgFuelTypeDataGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmfuelfi_tclMsgFuelTypeDataGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmfuelfi_tclMsgFuelTypeDataGet& operator=(const sxmfuelfi_tclMsgFuelTypeDataGet& coRef);
   sxmfuelfi_tclMsgFuelTypeDataGet(const sxmfuelfi_tclMsgFuelTypeDataGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmfuelfi_tclMsgFuelTypeDataGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmfuelfi_tclToken::EN_MSG_FUELTYPEDATAGET;}
};

class sxmfuelfi_tclMsgFuelTypeDataStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmfuelfi_tclMsgFuelTypeDataStatus():ServcTextVer(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmfuelfi_tclMsgFuelTypeDataStatus& operator=(const sxmfuelfi_tclMsgFuelTypeDataStatus& coRef);
   sxmfuelfi_tclMsgFuelTypeDataStatus(const sxmfuelfi_tclMsgFuelTypeDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU8 ServcTextVer;
   std::vector<tU8, std::allocator<tU8> > ServcTextData;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmfuelfi_tclMsgFuelTypeDataStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmfuelfi_tclToken::EN_MSG_FUELTYPEDATASTATUS;}
};

class sxmfuelfi_tclMsgFuelPriceDataUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmfuelfi_tclMsgFuelPriceDataUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmfuelfi_tclMsgFuelPriceDataUpReg& operator=(const sxmfuelfi_tclMsgFuelPriceDataUpReg& coRef);
   sxmfuelfi_tclMsgFuelPriceDataUpReg(const sxmfuelfi_tclMsgFuelPriceDataUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmfuelfi_tclMsgFuelPriceDataUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmfuelfi_tclToken::EN_MSG_FUELPRICEDATAUPREG;}
};

class sxmfuelfi_tclMsgFuelPriceDataRelUpReg : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmfuelfi_tclMsgFuelPriceDataRelUpReg() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmfuelfi_tclMsgFuelPriceDataRelUpReg& operator=(const sxmfuelfi_tclMsgFuelPriceDataRelUpReg& coRef);
   sxmfuelfi_tclMsgFuelPriceDataRelUpReg(const sxmfuelfi_tclMsgFuelPriceDataRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmfuelfi_tclMsgFuelPriceDataRelUpReg& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmfuelfi_tclToken::EN_MSG_FUELPRICEDATARELUPREG;}
};

class sxmfuelfi_tclMsgFuelPriceDataGet : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmfuelfi_tclMsgFuelPriceDataGet() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmfuelfi_tclMsgFuelPriceDataGet& operator=(const sxmfuelfi_tclMsgFuelPriceDataGet& coRef);
   sxmfuelfi_tclMsgFuelPriceDataGet(const sxmfuelfi_tclMsgFuelPriceDataGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmfuelfi_tclMsgFuelPriceDataGet& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmfuelfi_tclToken::EN_MSG_FUELPRICEDATAGET;}
};

class sxmfuelfi_tclMsgFuelPriceDataStatus : public fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8  u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const {return *this;};
   virtual fi_tclTypeBase& rfoGetTypeBase() {return *this;};
   sxmfuelfi_tclMsgFuelPriceDataStatus():ServerHighestAvailableUpdateId(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sxmfuelfi_tclMsgFuelPriceDataStatus& operator=(const sxmfuelfi_tclMsgFuelPriceDataStatus& coRef);
   sxmfuelfi_tclMsgFuelPriceDataStatus(const sxmfuelfi_tclMsgFuelPriceDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   tU32 ServerHighestAvailableUpdateId;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual tBool operator==(const sxmfuelfi_tclMsgFuelPriceDataStatus& rfoCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tS32 s32GetTypeId() const { return sxmfuelfi_tclToken::EN_MSG_FUELPRICEDATASTATUS;}
};


#endif
