#include "precompiled.hh"

tBool sxmfuelfi_tclDescription::bInitMessage(sxmfuelfi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case sxmfuelfi_tclToken::EN_LAST_TOKEN:
   case sxmfuelfi_tclToken::EN_LIST:
   case sxmfuelfi_tclToken::EN_END_OF_STRUCT:
   case sxmfuelfi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
   break;
      // include the expansions for the messages
   case sxmfuelfi_tclToken::EN_MSG_REGIONWISHLISTMETHODSTART:
   {
      bResult &= oPath.bGoDown(sxmfuelfi_tclKnot(sxmfuelfi_tclToken::EN_U16,sxmfuelfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(sxmfuelfi_tclKnot(sxmfuelfi_tclToken::EN_LIST,sxmfuelfi_tclSemanticDomain::EN_MSG_LISTOFREGIONS));
      bResult &= oPath.bGoDown(sxmfuelfi_tclKnot(sxmfuelfi_tclToken::EN_BOOL,sxmfuelfi_tclSemanticDomain::EN_MSG_LOCNFILTERSWITCH));
   } break;
   case sxmfuelfi_tclToken::EN_MSG_REGIONWISHLISTMETHODRESULT:
   {
      bResult &= oPath.bGoDown(sxmfuelfi_tclKnot(sxmfuelfi_tclToken::EN_BOOL,sxmfuelfi_tclSemanticDomain::EN_MSG_FILTERACCEPTED));
   } break;
   case sxmfuelfi_tclToken::EN_MSG_TRANSFERFUELPRICEDATAMETHODSTART:
   {
      bResult &= oPath.bGoDown(sxmfuelfi_tclKnot(sxmfuelfi_tclToken::EN_U32,sxmfuelfi_tclSemanticDomain::EN_MSG_CLIENTHIGHESTAVAILABLEUPDATEID));
   } break;
   case sxmfuelfi_tclToken::EN_MSG_TRANSFERFUELPRICEDATAMETHODRESULT:
   {
      bResult &= oPath.bGoDown(sxmfuelfi_tclKnot(sxmfuelfi_tclToken::EN_FUELPRICEDATA,sxmfuelfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(sxmfuelfi_tclKnot(sxmfuelfi_tclToken::EN_LIST,sxmfuelfi_tclSemanticDomain::EN_MSG_LISTOFFUELPRICEDATA));
      bResult &= oPath.bGoDown(sxmfuelfi_tclKnot(sxmfuelfi_tclToken::EN_U32,sxmfuelfi_tclSemanticDomain::EN_MSG_SERVERHIGHESTAVAILABLEUPDATEID));
   } break;
   case sxmfuelfi_tclToken::EN_MSG_FUELDATAAUTHINFOSTATUS:
   {
      bResult &= oPath.bGoDown(sxmfuelfi_tclKnot(sxmfuelfi_tclToken::EN_E8_AUTHSTATUS,sxmfuelfi_tclSemanticDomain::EN_MSG_FUELDATAAUTHSTATUS));
   } break;
   case sxmfuelfi_tclToken::EN_MSG_SXMSIGNALINFOSTATUS:
   {
      bResult &= oPath.bGoDown(sxmfuelfi_tclKnot(sxmfuelfi_tclToken::EN_E8_SXMSIGNALSTATUS,sxmfuelfi_tclSemanticDomain::EN_MSG_SXMSIGNALSTATUS));
   } break;
   case sxmfuelfi_tclToken::EN_MSG_FUELTYPEDATASTATUS:
   {
      bResult &= oPath.bGoDown(sxmfuelfi_tclKnot(sxmfuelfi_tclToken::EN_U8,sxmfuelfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
      bResult &= oPath.bGoDown(sxmfuelfi_tclKnot(sxmfuelfi_tclToken::EN_LIST,sxmfuelfi_tclSemanticDomain::EN_MSG_SERVCTEXTDATA));
      bResult &= oPath.bGoDown(sxmfuelfi_tclKnot(sxmfuelfi_tclToken::EN_U8,sxmfuelfi_tclSemanticDomain::EN_MSG_SERVCTEXTVER));
   } break;
   case sxmfuelfi_tclToken::EN_MSG_FUELPRICEDATASTATUS:
   {
      bResult &= oPath.bGoDown(sxmfuelfi_tclKnot(sxmfuelfi_tclToken::EN_U32,sxmfuelfi_tclSemanticDomain::EN_MSG_SERVERHIGHESTAVAILABLEUPDATEID));
   } break;
   case sxmfuelfi_tclToken::EN_BINCONTAINER:
   case sxmfuelfi_tclToken::EN_E8_AUTHSTATUS:
   case sxmfuelfi_tclToken::EN_E8_SXMSIGNALSTATUS:
   case sxmfuelfi_tclToken::EN_FUELPRICEDATA:
   case sxmfuelfi_tclToken::EN_U8:   
   case sxmfuelfi_tclToken::EN_S8:   
   case sxmfuelfi_tclToken::EN_U16:   
   case sxmfuelfi_tclToken::EN_S16:   
   case sxmfuelfi_tclToken::EN_U24:   
   case sxmfuelfi_tclToken::EN_S24:   
   case sxmfuelfi_tclToken::EN_U32:   
   case sxmfuelfi_tclToken::EN_S32:   
   case sxmfuelfi_tclToken::EN_U64:   
   case sxmfuelfi_tclToken::EN_S64:   
   case sxmfuelfi_tclToken::EN_F32:   
   case sxmfuelfi_tclToken::EN_F64:   
   case sxmfuelfi_tclToken::EN_BOOL:   
   case sxmfuelfi_tclToken::EN_STRING:   
   case sxmfuelfi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      oPath.bGoDown(sxmfuelfi_tclKnot(enMsgToken,sxmfuelfi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool sxmfuelfi_tclDescription::bDoIt(fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (*poInContext) >> oTypeBase;
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (*poOutContext) << oTypeBase;
   }
   return poVisitor->bIsValid();
}

tBool sxmfuelfi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      sxmfuelfi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      sxmfuelfi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      sxmfuelfi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == sxmfuelfi_tclSemanticDomain::EN_LIST_ELEMENT) {
         oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            oPath.bGoDown(sxmfuelfi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            oPath.bGoDown(sxmfuelfi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            oPath.bGoUp();
            oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      oCallStack.bGoDown(sxmfuelfi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case sxmfuelfi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == sxmfuelfi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         oPath.bGoUp();
         oCallStack.bGoUp();
         oCallStack.bGoUp();
      } break;
      case sxmfuelfi_tclToken::EN_LIST: 
      {
         fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            sxmfuelfi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(sxmfuelfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            sxmfuelfi_tclKnot saveKnot;
            oPath.bGoUp(saveKnot);
            // push LIST knot
            oPath.bGoDown(sxmfuelfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            oPath.bGoDown(saveKnot);
         }
      } break;
      case sxmfuelfi_tclToken::EN_U8: 
      {
         fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case sxmfuelfi_tclToken::EN_U16: 
      {
         fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case sxmfuelfi_tclToken::EN_U24: 
      {
         fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case sxmfuelfi_tclToken::EN_U32: 
      {
         fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case sxmfuelfi_tclToken::EN_U64: 
      {
         fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case sxmfuelfi_tclToken::EN_S8: 
      {
         fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case sxmfuelfi_tclToken::EN_S16: 
      {
         fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case sxmfuelfi_tclToken::EN_S24: 
      {
         fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case sxmfuelfi_tclToken::EN_S32: 
      {
         fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case sxmfuelfi_tclToken::EN_S64: 
      {
         fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case sxmfuelfi_tclToken::EN_F32: 
      {
         fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case sxmfuelfi_tclToken::EN_F64: 
      {
         fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case sxmfuelfi_tclToken::EN_BOOL: 
      {
         fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case sxmfuelfi_tclToken::EN_STRING: 
      {
         fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      case sxmfuelfi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         oCallStack.bGoUp();
         oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
   case sxmfuelfi_tclToken::EN_MSG_REGIONWISHLISTMETHODSTART:
   case sxmfuelfi_tclToken::EN_MSG_REGIONWISHLISTMETHODRESULT:
   case sxmfuelfi_tclToken::EN_MSG_TRANSFERFUELPRICEDATAMETHODSTART:
   case sxmfuelfi_tclToken::EN_MSG_TRANSFERFUELPRICEDATAMETHODRESULT:
   case sxmfuelfi_tclToken::EN_MSG_FUELDATAAUTHINFOUPREG:
   case sxmfuelfi_tclToken::EN_MSG_FUELDATAAUTHINFORELUPREG:
   case sxmfuelfi_tclToken::EN_MSG_FUELDATAAUTHINFOGET:
   case sxmfuelfi_tclToken::EN_MSG_FUELDATAAUTHINFOSTATUS:
   case sxmfuelfi_tclToken::EN_MSG_SXMSIGNALINFOUPREG:
   case sxmfuelfi_tclToken::EN_MSG_SXMSIGNALINFORELUPREG:
   case sxmfuelfi_tclToken::EN_MSG_SXMSIGNALINFOGET:
   case sxmfuelfi_tclToken::EN_MSG_SXMSIGNALINFOSTATUS:
   case sxmfuelfi_tclToken::EN_MSG_FUELTYPEDATAUPREG:
   case sxmfuelfi_tclToken::EN_MSG_FUELTYPEDATARELUPREG:
   case sxmfuelfi_tclToken::EN_MSG_FUELTYPEDATAGET:
   case sxmfuelfi_tclToken::EN_MSG_FUELTYPEDATASTATUS:
   case sxmfuelfi_tclToken::EN_MSG_FUELPRICEDATAUPREG:
   case sxmfuelfi_tclToken::EN_MSG_FUELPRICEDATARELUPREG:
   case sxmfuelfi_tclToken::EN_MSG_FUELPRICEDATAGET:
   case sxmfuelfi_tclToken::EN_MSG_FUELPRICEDATASTATUS:
      bInitMessage(enToken);
      break;
   case sxmfuelfi_tclToken::EN_BINCONTAINER:
   {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(sxmfuelfi_tclKnot(sxmfuelfi_tclToken::EN_END_OF_STRUCT,sxmfuelfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(sxmfuelfi_tclKnot(sxmfuelfi_tclToken::EN_U8,sxmfuelfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(sxmfuelfi_tclKnot(sxmfuelfi_tclToken::EN_LIST,sxmfuelfi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
   case sxmfuelfi_tclToken::EN_E8_AUTHSTATUS:
   {
      fi_tcl_e8_AuthStatus o_e8_AuthStatus;
      if (!bDoIt(o_e8_AuthStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case sxmfuelfi_tclToken::EN_E8_SXMSIGNALSTATUS:
   {
      fi_tcl_e8_SXMSignalStatus o_e8_SXMSignalStatus;
      if (!bDoIt(o_e8_SXMSignalStatus))
         return FALSE;
      oCallStack.bGoUp();
      oPath.bGoUp();
   } break;
   case sxmfuelfi_tclToken::EN_FUELPRICEDATA:
   {
      if (poVisitor->bDoExpand_FuelPriceData(enSemanticDomain))
      {
         oPath.bGoUp();
         oPath.bGoDown(sxmfuelfi_tclKnot(sxmfuelfi_tclToken::EN_END_OF_STRUCT,sxmfuelfi_tclSemanticDomain::EN_UNKNOWN));
         oPath.bGoDown(sxmfuelfi_tclKnot(sxmfuelfi_tclToken::EN_U8,sxmfuelfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         oPath.bGoDown(sxmfuelfi_tclKnot(sxmfuelfi_tclToken::EN_LIST,sxmfuelfi_tclSemanticDomain::EN_ACCESSUNITDATA));
      }
      else
      {
         fi_tcl_FuelPriceData o_FuelPriceData;
         if (!bDoIt(o_FuelPriceData))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FuelPriceData.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FuelPriceData.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            oCallStack.bGoUp();
            oPath.bGoUp();
         }
      }
   } break;
      case sxmfuelfi_tclToken::EN_UNKNOWN:
      case sxmfuelfi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
  }
  return bResult;
}

